/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.offheap;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.jdbc.TableDiskPersistenceTest;
import com.pivotal.gemfirexd.jdbc.offheap.OffHeapTest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class OffHeapTableDiskPersistence
extends TableDiskPersistenceTest {
    private JdbcTestBase.RegionMapClearDetector rmcd = null;

    public OffHeapTableDiskPersistence(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(OffHeapTableDiskPersistence.class));
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
        System.setProperty("gemfire.off-heap-memory-size", "500m");
        System.setProperty("gemfire.disableManagement", "true");
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
        this.rmcd = new JdbcTestBase.RegionMapClearDetector();
        CacheObserverHolder.setInstance((CacheObserver)this.rmcd);
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.rmcd);
    }

    @Override
    public void tearDown() throws Exception {
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
        CacheObserverHolder.setInstance(null);
        GemFireXDQueryObserverHolder.clearInstance();
        super.tearDown();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
        System.setProperty("gemfire.off-heap-memory-size", "");
        System.setProperty("gemfire.disableManagement", "");
    }

    @Override
    public String getSuffix() {
        return " offheap " + super.getSuffix();
    }

    @Override
    public void testRegionEntryTypeForPersistentOverflowPRTable() throws Exception {
    }

    @Override
    public void testRegionEntryTypeForPersistentOverflowRedundantPRTable() throws Exception {
    }

    @Override
    public void testRegionEntryTypeForPersistentOverflowReplicateTable() throws Exception {
    }

    public void testDiskPersistenceRecoveryForLobTables_1() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname varchar(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange)) " + this.getSuffix());
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long freeSizeBeforeInserts = stats.getFreeMemory();
        long refCountBeforeInsert = JDBC.getTotalRefCount(ma);
        for (int i = 1; i < 2; i += 3) {
            OffHeapTest.DataGenerator dg = new OffHeapTest.DataGenerator();
            dg.insertIntoCompanies(psComp, "SYMB" + i, "NSE", 0);
        }
        long refCountAfterInsert = JDBC.getTotalRefCount(ma);
        OffHeapTableDiskPersistence.assertTrue((refCountBeforeInsert != refCountAfterInsert ? 1 : 0) != 0);
        long freesizeAfterInserts = stats.getFreeMemory();
        OffHeapTableDiskPersistence.assertTrue((freesizeAfterInserts != freeSizeBeforeInserts ? 1 : 0) != 0);
        conn.close();
        OffHeapTableDiskPersistence.shutDown();
        conn = OffHeapTableDiskPersistence.getConnection();
        for (DiskStoreImpl dsi : Misc.getGemFireCache().listDiskStores()) {
            dsi.waitForBackgroundTasks();
        }
        this.doOffHeapValidations();
        st = conn.createStatement();
        rs = st.executeQuery("select * from trade.companies where companyname is not null ");
        int numRows = 0;
        int numCols = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            for (int i = 0; i < numCols; ++i) {
                rs.getObject(i + 1);
            }
            ++numRows;
        }
        OffHeapTableDiskPersistence.assertEquals((int)1, (int)numRows);
        int numUpdate = st.executeUpdate("update trade.companies set companyname = 'zzz'");
        OffHeapTableDiskPersistence.assertEquals((int)1, (int)numUpdate);
        OffHeapTableDiskPersistence.assertEquals((long)JDBC.getTotalRefCount(ma), (long)refCountAfterInsert);
        conn.close();
        OffHeapTableDiskPersistence.shutDown();
        conn = OffHeapTableDiskPersistence.getConnection();
        st = conn.createStatement();
        for (DiskStoreImpl dsi : Misc.getGemFireCache().listDiskStores()) {
            dsi.waitForBackgroundTasks();
        }
        this.doOffHeapValidations();
        rs = st.executeQuery("select companyname from trade.companies where companyname is not null ");
        OffHeapTableDiskPersistence.assertTrue((boolean)rs.next());
        OffHeapTableDiskPersistence.assertEquals((String)"zzz", (String)rs.getString(1));
        OffHeapTableDiskPersistence.assertFalse((boolean)rs.next());
    }

    public void testDiskPersistenceRecoveryForLobTables_2() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname varchar(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange)) " + this.getSuffix());
        st.execute("create index company_tid on trade.companies(tid)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        OffHeapMemoryStats stats = SimpleMemoryAllocatorImpl.getAllocator().getStats();
        SimpleMemoryAllocatorImpl ma = SimpleMemoryAllocatorImpl.getAllocator();
        long freeSizeBeforeInserts = stats.getFreeMemory();
        long refCountBeforeInsert = JDBC.getTotalRefCount(ma);
        for (int i = 1; i < 2; i += 3) {
            OffHeapTest.DataGenerator dg = new OffHeapTest.DataGenerator();
            dg.insertIntoCompanies(psComp, "SYMB" + i, "NSE", 0);
        }
        long refCountAfterInsert = JDBC.getTotalRefCount(ma);
        OffHeapTableDiskPersistence.assertTrue((refCountBeforeInsert != refCountAfterInsert ? 1 : 0) != 0);
        long freesizeAfterInserts = stats.getFreeMemory();
        OffHeapTableDiskPersistence.assertTrue((freesizeAfterInserts != freeSizeBeforeInserts ? 1 : 0) != 0);
        int numUpdate = st.executeUpdate("update trade.companies set companyname = 'zzz'");
        conn.close();
        OffHeapTableDiskPersistence.shutDown();
        conn = OffHeapTableDiskPersistence.getConnection();
        for (DiskStoreImpl dsi : Misc.getGemFireCache().listDiskStores()) {
            dsi.waitForBackgroundTasks();
        }
        this.doOffHeapValidations();
        conn = OffHeapTableDiskPersistence.getConnection();
        st = conn.createStatement();
        this.doOffHeapValidations();
        rs = st.executeQuery("select companyname from trade.companies where companyname is not null ");
        OffHeapTableDiskPersistence.assertTrue((boolean)rs.next());
        OffHeapTableDiskPersistence.assertEquals((String)"zzz", (String)rs.getString(1));
        numUpdate = st.executeUpdate("update trade.companies set companyname = 'yyy'");
        conn.close();
        OffHeapTableDiskPersistence.shutDown();
        conn = OffHeapTableDiskPersistence.getConnection();
        for (DiskStoreImpl dsi : Misc.getGemFireCache().listDiskStores()) {
            dsi.waitForBackgroundTasks();
        }
        this.doOffHeapValidations();
        conn = OffHeapTableDiskPersistence.getConnection();
        st = conn.createStatement();
        this.doOffHeapValidations();
        rs = st.executeQuery("select companyname from trade.companies where companyname is not null ");
        OffHeapTableDiskPersistence.assertTrue((boolean)rs.next());
        OffHeapTableDiskPersistence.assertEquals((String)"yyy", (String)rs.getString(1));
        OffHeapTableDiskPersistence.assertFalse((boolean)rs.next());
    }

    @Override
    public void waitTillAllClear() {
        try {
            this.rmcd.waitTillAllClear();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new GemFireXDRuntimeException((Throwable)ie);
        }
    }
}

