/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc.offheap;

import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.OffHeapRegionEntry;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionDataStore;
import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.offheap.CollectionBasedOHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OHAddressCache;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GroupedAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SortResultSet;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class OffHeapOHACOptimizationTest
extends JdbcTestBase {
    private JdbcTestBase.RegionMapClearDetector rmcd = null;

    public OffHeapOHACOptimizationTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(OffHeapOHACOptimizationTest.class));
    }

    @Override
    public String reduceLogging() {
        return "config";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
        System.setProperty("gemfire.off-heap-memory-size", "500m");
        System.setProperty("gemfire.disableManagement", "true");
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
        this.rmcd = new JdbcTestBase.RegionMapClearDetector();
        CacheObserverHolder.setInstance((CacheObserver)this.rmcd);
        GemFireXDQueryObserverHolder.putInstance((QueryObserver)this.rmcd);
    }

    @Override
    public void tearDown() throws Exception {
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
        CacheObserverHolder.setInstance(null);
        GemFireXDQueryObserverHolder.clearInstance();
        super.tearDown();
        System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
        System.setProperty("gemfire.off-heap-memory-size", "");
        System.setProperty("gemfire.disableManagement", "");
    }

    public void testOrderByUnsortedRowsOptimizedDueToProjection_pr() throws Exception {
        this.basicTestOrderByUnsortedRowsOptimizedDueToProjection("");
    }

    public void testOrderByUnsortedRowsOptimizedDueToProjection() throws Exception {
        this.basicTestOrderByUnsortedRowsOptimizedDueToProjection("replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestOrderByUnsortedRowsOptimizedDueToProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            TreeMap<Integer, Integer> expectedResult = new TreeMap<Integer, Integer>();
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * i;
                psInsert.setInt(4, qty);
                if (qty < 100 || qty > 150) {
                    expectedResult.put(qty, i);
                }
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select cid, sid from trade.buyorders where  ( qty < 100 or qty > 150) order by qty";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = bulkTableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Iterator values = expectedResult.values().iterator();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertEquals((int)((Integer)values.next()), (int)rs.getInt(1));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block14: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testOrderByUnsortedRowsWithNoProjection_pr() throws Exception {
        this.basicTestOrderByUnsortedRowsWithNoProjection(" ");
    }

    public void testOrderByUnsortedRowsWithNoProjection_rr() throws Exception {
        this.basicTestOrderByUnsortedRowsWithNoProjection(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestOrderByUnsortedRowsWithNoProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            TreeMap<Integer, Integer> expectedResult = new TreeMap<Integer, Integer>();
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * i;
                psInsert.setInt(4, qty);
                if (qty < 100 || qty > 150) {
                    expectedResult.put(qty, i);
                }
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select * from trade.buyorders where  ( qty < 100 or qty > 150) order by qty";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        TestCase.assertTrue((boolean)(addressCache instanceof CollectionBasedOHAddressCache));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Iterator values = expectedResult.values().iterator();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertEquals((int)((Integer)values.next()), (int)rs.getInt(2));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block14: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testOrderByUnsortedRowsNoIndexNoProjection_pr() throws Exception {
        this.basicTestOrderByUnsortedRowsNoIndexNoProjection(" ");
    }

    public void testOrderByUnsortedRowsNoIndexNoProjection_rr() throws Exception {
        this.basicTestOrderByUnsortedRowsNoIndexNoProjection(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestOrderByUnsortedRowsNoIndexNoProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            TreeMap<Integer, Integer> expectedResult = new TreeMap<Integer, Integer>();
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * i;
                psInsert.setInt(4, qty);
                if (qty < 100 || qty > 150) {
                    expectedResult.put(qty, i);
                }
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select * from trade.buyorders where  ( qty < 100 or qty > 150) order by qty";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        TestCase.assertTrue((boolean)(addressCache instanceof CollectionBasedOHAddressCache));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Iterator values = expectedResult.values().iterator();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertEquals((int)((Integer)values.next()), (int)rs.getInt(2));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block14: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testOrderByUnsortedRowsNoIndexWithProjection_pr() throws Exception {
        this.basicTestOrderByUnsortedRowsNoIndexWithProjection(" ");
    }

    public void testOrderByUnsortedRowsNoIndexWithProjection_rr() throws Exception {
        this.basicTestOrderByUnsortedRowsNoIndexWithProjection(" replicate ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestOrderByUnsortedRowsNoIndexWithProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            TreeMap<Integer, Integer> expectedResult = new TreeMap<Integer, Integer>();
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * i;
                psInsert.setInt(4, qty);
                if (qty < 100 || qty > 150) {
                    expectedResult.put(qty, i);
                }
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select cid, sid from trade.buyorders where  ( qty < 100 or qty > 150) order by qty";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = bulkTableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCacheClass, addressCache.getClass());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Iterator values = expectedResult.values().iterator();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertEquals((int)((Integer)values.next()), (int)rs.getInt(1));
                rs.getInt(2);
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block14: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testOrderBySortedRowsIndexWithNoProjection_pr() throws Exception {
        this.basicTestOrderBySortedRowsIndexWithNoProjection(" ");
    }

    public void testOrderBySortedRowsIndexWithNoProjection_rr() throws Exception {
        this.basicTestOrderBySortedRowsIndexWithNoProjection(" replicate ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicTestOrderBySortedRowsIndexWithNoProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            TreeMap<Integer, Integer> expectedResult = new TreeMap<Integer, Integer>();
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * i;
                psInsert.setInt(4, qty);
                expectedResult.put(qty, i);
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select * from trade.buyorders  order by qty";
            TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = bulkTableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCacheClass, addressCache.getClass());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
            observer.addExpectedScanType("trade.buyorders", "trade.i3", TestUtil.ScanType.SORTEDMAPINDEX);
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Iterator values = expectedResult.values().iterator();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertEquals((int)((Integer)values.next()), (int)rs.getInt(2));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            rs.close();
            observer.checkAndClear();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block13: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testOrderByUnSortedRowsNoProjection_pr() throws Exception {
        this.basicTestOrderByUnSortedRowsNoProjection(" ");
    }

    public void testOrderByUnSortedRowsNoProjection_rr() throws Exception {
        this.basicTestOrderByUnSortedRowsNoProjection(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestOrderByUnSortedRowsNoProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            TreeMap<Integer, Integer> expectedResult = new TreeMap<Integer, Integer>();
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * i;
                psInsert.setInt(4, qty);
                expectedResult.put(qty, i);
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select * from trade.buyorders  order by qty";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        TestCase.assertTrue((boolean)(addressCache instanceof CollectionBasedOHAddressCache));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Iterator values = expectedResult.values().iterator();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertEquals((int)((Integer)values.next()), (int)rs.getInt(2));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block13: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testOrderByUnSortedRowsIndexWithNoProjection_pr() throws Exception {
        this.basicTestOrderByUnSortedRowsIndexWithNoProjection(" ");
    }

    public void testOrderByUnSortedRowsIndexWithNoProjection_rr() throws Exception {
        this.basicTestOrderByUnSortedRowsIndexWithNoProjection(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestOrderByUnSortedRowsIndexWithNoProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            TreeMap<Integer, Integer> expectedResult = new TreeMap<Integer, Integer>();
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * i;
                psInsert.setInt(4, qty);
                expectedResult.put(qty, i);
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select * from trade.buyorders  order by qty desc";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        TestCase.assertTrue((boolean)(addressCache instanceof CollectionBasedOHAddressCache));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Iterator values = expectedResult.descendingMap().values().iterator();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertEquals((int)((Integer)values.next()), (int)rs.getInt(2));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block13: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testDistinctUnsortedRowsOptimizedDueToProjection_pr() throws Exception {
        this.basicTestDistinctUnsortedRowsOptimizedDueToProjection("");
    }

    public void testDistinctUnsortedRowsOptimizedDueToProjection_rr() throws Exception {
        this.basicTestDistinctUnsortedRowsOptimizedDueToProjection("replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestDistinctUnsortedRowsOptimizedDueToProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            TreeSet<Integer> expectedResult = new TreeSet<Integer>();
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * (i % 5);
                psInsert.setInt(4, qty);
                if (i > 10) {
                    expectedResult.add(qty);
                }
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select distinct qty from trade.buyorders where  cid > 10 ";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = tableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertTrue((boolean)expectedResult.remove(rs.getInt(1)));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            OffHeapOHACOptimizationTest.assertTrue((boolean)expectedResult.isEmpty());
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block14: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testDistinctUnsortedRowsWithNoProjection_pr() throws Exception {
        this.basicTestDistinctUnsortedRowsWithNoProjection("");
    }

    public void testDistinctUnsortedRowsWithNoProjection_rr() throws Exception {
        this.basicTestDistinctUnsortedRowsWithNoProjection("replicate ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestDistinctUnsortedRowsWithNoProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null , cid int, sid int, qty int, bid decimal (30, 20),  status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?)");
            TreeSet<String> expectedResult = new TreeSet<String>();
            for (int i = 1; i < 500; ++i) {
                StringBuilder builder = new StringBuilder();
                psInsert.setInt(1, i % 20);
                builder.append(i % 20).append(',');
                psInsert.setInt(2, i % 20);
                builder.append(i % 20).append(',');
                psInsert.setInt(3, -1 * i % 20);
                builder.append(-1 * (i % 20)).append(',');
                int qty = 100 * (i % 5);
                psInsert.setInt(4, qty);
                builder.append(qty).append(',');
                psInsert.setFloat(5, 30.4f);
                builder.append(30.4).append(',');
                psInsert.setString(6, "cancelled");
                builder.append("cancelled").append(',');
                psInsert.setInt(7, 5);
                builder.append(5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
                expectedResult.add(builder.toString());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select distinct * from trade.buyorders where  cid >= 0 ";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        TestCase.assertTrue((boolean)(addressCache instanceof CollectionBasedOHAddressCache));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onSortResultSetOpen(ResultSet resultSet) {
                    try {
                        SortResultSet srs = (SortResultSet)resultSet;
                        NoPutResultSet source = srs.getSource();
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        Class<SortResultSet> clazz = SortResultSet.class;
                        Field field = clazz.getDeclaredField("source");
                        field.setAccessible(true);
                        field.set(srs, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            while (rs.next()) {
                StringBuilder sb = new StringBuilder();
                sb.append(rs.getInt(1)).append(',').append(rs.getInt(2)).append(',').append(rs.getInt(3)).append(',').append(rs.getInt(4)).append(',').append(rs.getFloat(5)).append(',').append(rs.getString(6)).append(',').append(rs.getInt(7));
                OffHeapOHACOptimizationTest.assertTrue((boolean)expectedResult.remove(sb.toString()));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            OffHeapOHACOptimizationTest.assertTrue((boolean)expectedResult.isEmpty());
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block13: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testGroupByUnsortedRowsOptimizedDueToProjection_pr() throws Exception {
        this.basicTestGroupByUnsortedRowsOptimizedDueToProjection(" ");
    }

    public void testGroupByUnsortedRowsOptimizedDueToProjection_rr() throws Exception {
        this.basicTestGroupByUnsortedRowsOptimizedDueToProjection(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void basicTestGroupByUnsortedRowsOptimizedDueToProjection(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            TreeSet<Integer> expectedResult = new TreeSet<Integer>();
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * (i % 5);
                psInsert.setInt(4, qty);
                if (i > 10) {
                    expectedResult.add(qty);
                }
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select  qty from trade.buyorders where  cid > 10 group by qty ";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = bulkTableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onGroupedAggregateResultSetOpen(ResultSet resultSet) {
                    try {
                        GroupedAggregateResultSet gars = (GroupedAggregateResultSet)resultSet;
                        Class<GenericAggregateResultSet> genericAggClass = GenericAggregateResultSet.class;
                        Field sourceField = genericAggClass.getDeclaredField("source");
                        sourceField.setAccessible(true);
                        NoPutResultSet source = (NoPutResultSet)sourceField.get(gars);
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        sourceField.set(gars, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertTrue((boolean)expectedResult.remove(rs.getInt(1)));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            OffHeapOHACOptimizationTest.assertTrue((boolean)expectedResult.isEmpty());
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block14: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testGroupByWithAggregateFunction_pr_1() throws Exception {
        this.basicTestGroupByWithAggregateFunction_1(" ");
    }

    public void testGroupByWithAggregateFunction_rr_1() throws Exception {
        this.basicTestGroupByWithAggregateFunction_1(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestGroupByWithAggregateFunction_1(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            HashMap<Integer, Integer> expectedResult = new HashMap<Integer, Integer>();
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * (i % 5);
                psInsert.setInt(4, qty);
                if (i > 10) {
                    int val = -1 * i;
                    Integer oldVal = (Integer)expectedResult.get(qty);
                    if (oldVal != null) {
                        val += oldVal.intValue();
                    }
                    expectedResult.put(qty, val);
                }
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select  sum(sid) from trade.buyorders where  cid > 10 group by qty ";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = bulkTableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onGroupedAggregateResultSetOpen(ResultSet resultSet) {
                    try {
                        GroupedAggregateResultSet gars = (GroupedAggregateResultSet)resultSet;
                        Class<GenericAggregateResultSet> genericAggClass = GenericAggregateResultSet.class;
                        Field sourceField = genericAggClass.getDeclaredField("source");
                        sourceField.setAccessible(true);
                        NoPutResultSet source = (NoPutResultSet)sourceField.get(gars);
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        sourceField.set(gars, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Collection vals = expectedResult.values();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertTrue((boolean)vals.remove(rs.getInt(1)));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            OffHeapOHACOptimizationTest.assertTrue((boolean)vals.isEmpty());
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block15: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block15;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testGroupByOnSortedData_pr() throws Exception {
        this.basicTestGroupByOnSortedData(" ");
    }

    public void testGroupByOnSortedData_rr() throws Exception {
        this.basicTestGroupByOnSortedData(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestGroupByOnSortedData(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            HashMap<Integer, Integer> expectedResult = new HashMap<Integer, Integer>();
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * (i % 5);
                psInsert.setInt(4, qty);
                int val = -1 * i;
                Integer oldVal = (Integer)expectedResult.get(qty);
                if (oldVal != null) {
                    val += oldVal.intValue();
                }
                expectedResult.put(qty, val);
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select  sum(sid) from trade.buyorders  group by qty ";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = bulkTableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onGroupedAggregateResultSetOpen(ResultSet resultSet) {
                    try {
                        GroupedAggregateResultSet gars = (GroupedAggregateResultSet)resultSet;
                        Class<GenericAggregateResultSet> genericAggClass = GenericAggregateResultSet.class;
                        Field sourceField = genericAggClass.getDeclaredField("source");
                        sourceField.setAccessible(true);
                        NoPutResultSet source = (NoPutResultSet)sourceField.get(gars);
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        sourceField.set(gars, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
            observer.addExpectedScanType("trade.buyorders", "trade.i3", TestUtil.ScanType.SORTEDMAPINDEX);
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Collection vals = expectedResult.values();
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertTrue((boolean)vals.remove(rs.getInt(1)));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            OffHeapOHACOptimizationTest.assertTrue((boolean)vals.isEmpty());
            rs.close();
            observer.checkAndClear();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block14: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block14;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testGroupByOptimizedWithSortedRows_pr() throws Exception {
        this.basicTestGroupByOptimizedWithSortedRows(" ");
    }

    public void testGroupByOptimizedWithSortedRows_rr() throws Exception {
        this.basicTestGroupByOptimizedWithSortedRows(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestGroupByOptimizedWithSortedRows(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            s.execute("create index i2 on trade.buyorders(cid, sid)");
            s.execute("create index i3 on trade.buyorders(qty)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            HashSet<Integer> expectedResult = new HashSet<Integer>();
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * (i % 5);
                psInsert.setInt(4, qty);
                expectedResult.add(qty);
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select qty from trade.buyorders  group by qty ";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        TestCase.assertNull((Object)addressCache);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onGroupedAggregateResultSetOpen(ResultSet resultSet) {
                    try {
                        GroupedAggregateResultSet gars = (GroupedAggregateResultSet)resultSet;
                        Class<GenericAggregateResultSet> genericAggClass = GenericAggregateResultSet.class;
                        Field sourceField = genericAggClass.getDeclaredField("source");
                        sourceField.setAccessible(true);
                        NoPutResultSet source = (NoPutResultSet)sourceField.get(gars);
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        sourceField.set(gars, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)observer);
            observer.addExpectedScanType("trade.buyorders", "trade.i3", TestUtil.ScanType.SORTEDMAPINDEX);
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertTrue((boolean)expectedResult.remove(rs.getInt(1)));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            OffHeapOHACOptimizationTest.assertTrue((boolean)expectedResult.isEmpty());
            rs.close();
            observer.checkAndClear();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block13: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block13;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testGroupByWithAggregateFunction_pr_2() throws Exception {
        this.basicTestGroupByWithAggregateFunction_2(" ");
    }

    public void testGroupByWithAggregateFunction_rr_2() throws Exception {
        this.basicTestGroupByWithAggregateFunction_2(" replicate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void basicTestGroupByWithAggregateFunction_2(String type) throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Statement s = null;
        Connection conn = TestUtil.getConnection();
        s = conn.createStatement();
        try {
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_qty_ck check (qty>=0))  offheap " + type;
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab3);
            s.execute("create index i1 on trade.buyorders(status)");
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            HashMap<Integer, Integer> expectedResult = new HashMap<Integer, Integer>();
            for (int i = 1; i < 500; ++i) {
                psInsert.setInt(1, i);
                psInsert.setInt(2, i);
                psInsert.setInt(3, -1 * i);
                int qty = 100 * (i % 5);
                psInsert.setInt(4, qty);
                if (i > 10) {
                    int val = 1;
                    Integer oldVal = (Integer)expectedResult.get(qty);
                    if (oldVal != null) {
                        val += oldVal.intValue();
                    }
                    expectedResult.put(qty, val);
                }
                psInsert.setFloat(5, 30.4f);
                psInsert.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(7, "cancelled");
                psInsert.setInt(8, 5);
                OffHeapOHACOptimizationTest.assertEquals((int)1, (int)psInsert.executeUpdate());
            }
            List<OffHeapRegionEntry> allEntries = this.collectAllEntries();
            String query = "select distinct count(*) from trade.buyorders where  cid > 10 group by qty ";
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCoreOfBulkTableScan(ResultSet resultSet) {
                    try {
                        Class<?> bulkTableScanClazz = resultSet.getClass();
                        Class<?> tableScanClazz = resultSet.getClass().getSuperclass();
                        Field field = tableScanClazz.getDeclaredField("ohAddressCache");
                        field.setAccessible(true);
                        OHAddressCache addressCache = (OHAddressCache)field.get(resultSet);
                        Class<?> addressCacheClass = bulkTableScanClazz.getDeclaredClasses()[0];
                        TestCase.assertEquals(addressCache.getClass(), addressCacheClass);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onGroupedAggregateResultSetOpen(ResultSet resultSet) {
                    try {
                        GroupedAggregateResultSet gars = (GroupedAggregateResultSet)resultSet;
                        Class<GenericAggregateResultSet> genericAggClass = GenericAggregateResultSet.class;
                        Field sourceField = genericAggClass.getDeclaredField("source");
                        sourceField.setAccessible(true);
                        NoPutResultSet source = (NoPutResultSet)sourceField.get(gars);
                        source = OffHeapOHACOptimizationTest.this.conditionSourceResultSet(source);
                        sourceField.set(gars, source);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            java.sql.ResultSet rs = s.executeQuery(query);
            int num = 0;
            Collection vals = expectedResult.values();
            HashSet valss = new HashSet();
            valss.addAll(vals);
            while (rs.next()) {
                OffHeapOHACOptimizationTest.assertTrue((boolean)valss.remove(rs.getInt(1)));
                ++num;
            }
            OffHeapOHACOptimizationTest.assertTrue((num > 0 ? 1 : 0) != 0);
            OffHeapOHACOptimizationTest.assertTrue((boolean)valss.isEmpty());
            rs.close();
            for (OffHeapRegionEntry ohre : allEntries) {
                long address = ohre.getAddress();
                if (SimpleMemoryAllocatorImpl.Chunk.retain((long)address)) {
                    SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                    continue;
                }
                ohre.setAddress(address, 0L);
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                this.rmcd.waitTillAllClear();
            }
        }
        finally {
            block15: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block15;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    private List<OffHeapRegionEntry> collectAllEntries() {
        ArrayList<OffHeapRegionEntry> allEntries = new ArrayList<OffHeapRegionEntry>();
        LocalRegion lr = Misc.getRegionByPath((String)"/TRADE/BUYORDERS");
        if (lr instanceof PartitionedRegion) {
            Set brs;
            PartitionedRegion pr = (PartitionedRegion)lr;
            PartitionedRegionDataStore prs = pr.getDataStore();
            if (prs != null && (brs = prs.getAllLocalBucketRegions()) != null) {
                for (BucketRegion br : brs) {
                    if (br == null) continue;
                    this.collectAllEntries((LocalRegion)br, allEntries);
                }
            }
        } else {
            this.collectAllEntries(lr, allEntries);
        }
        return allEntries;
    }

    private void collectAllEntries(LocalRegion rgn, List<OffHeapRegionEntry> allEntries) {
        Set keys = rgn.keys();
        for (Object key : keys) {
            OffHeapRegionEntry ohre = (OffHeapRegionEntry)rgn.basicGetEntry(key);
            allEntries.add(ohre);
        }
    }

    private NoPutResultSet conditionSourceResultSet(final NoPutResultSet noputResultSet) {
        NoPutResultSet testResultSetPassThru = new NoPutResultSet(){
            private List<RowLocation> rowsScanned = new ArrayList<RowLocation>();

            public void deleteRowDirectly() throws StandardException {
                noputResultSet.deleteRowDirectly();
            }

            public boolean canUpdateInPlace() {
                return noputResultSet.canUpdateInPlace();
            }

            public boolean needsToClone() {
                return noputResultSet.needsToClone();
            }

            public FormatableBitSet getValidColumns() {
                return noputResultSet.getValidColumns();
            }

            public ExecRow getNextRowFromRowSource() throws StandardException {
                return noputResultSet.getNextRowFromRowSource();
            }

            public void closeRowSource() {
                noputResultSet.closeRowSource();
            }

            public void rowLocation(RowLocation rl) throws StandardException {
                noputResultSet.rowLocation(rl);
            }

            public boolean needsRowLocation() {
                return noputResultSet.needsRowLocation();
            }

            public ExecRow setBeforeFirstRow() throws StandardException {
                return noputResultSet.setBeforeFirstRow();
            }

            public ExecRow setAfterLastRow() throws StandardException {
                return noputResultSet.setAfterLastRow();
            }

            public boolean returnsRows() {
                return noputResultSet.returnsRows();
            }

            public void resetStatistics() {
                noputResultSet.resetStatistics();
            }

            public boolean releaseLocks(GemFireTransaction tran) {
                return noputResultSet.releaseLocks(tran);
            }

            public void open() throws StandardException {
                noputResultSet.open();
            }

            public int modifiedRowCount() {
                return noputResultSet.modifiedRowCount();
            }

            public void markLocallyExecuted() {
                noputResultSet.markLocallyExecuted();
            }

            public boolean isDistributedResultSet() {
                return noputResultSet.isDistributedResultSet();
            }

            public boolean isClosed() {
                return noputResultSet.isClosed();
            }

            public boolean hasAutoGeneratedKeysResultSet() {
                return noputResultSet.hasAutoGeneratedKeysResultSet();
            }

            public SQLWarning getWarnings() {
                return noputResultSet.getWarnings();
            }

            public long getTimeSpent(int type, int timeType) {
                return noputResultSet.getTimeSpent(type, timeType);
            }

            public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
                return noputResultSet.getSubqueryTrackingArray(numSubqueries);
            }

            public int getRowNumber() {
                return noputResultSet.getRowNumber();
            }

            public ExecRow getRelativeRow(int row) throws StandardException {
                return noputResultSet.getRelativeRow(row);
            }

            public ExecRow getPreviousRow() throws StandardException {
                return noputResultSet.getPreviousRow();
            }

            public ExecRow getNextRow() throws StandardException {
                return noputResultSet.getNextRow();
            }

            public ExecRow getLastRow() throws StandardException {
                return noputResultSet.getLastRow();
            }

            public ExecRow getFirstRow() throws StandardException {
                return noputResultSet.getFirstRow();
            }

            public UUID getExecutionPlanID() {
                return noputResultSet.getExecutionPlanID();
            }

            public long getExecuteTime() {
                return noputResultSet.getExecuteTime();
            }

            public Timestamp getEndExecutionTimestamp() {
                return noputResultSet.getEndExecutionTimestamp();
            }

            public String getCursorName() {
                return noputResultSet.getCursorName();
            }

            public Timestamp getBeginExecutionTimestamp() {
                return noputResultSet.getBeginExecutionTimestamp();
            }

            public ResultSet getAutoGeneratedKeysResultset() {
                return noputResultSet.getAutoGeneratedKeysResultset();
            }

            public Activation getActivation() {
                return noputResultSet.getActivation();
            }

            public ExecRow getAbsoluteRow(int row) throws StandardException {
                return noputResultSet.getAbsoluteRow(row);
            }

            public void flushBatch() throws StandardException {
                noputResultSet.flushBatch();
            }

            public void finish() throws StandardException {
                noputResultSet.finish();
            }

            public void closeBatch() throws StandardException {
                noputResultSet.closeBatch();
            }

            public void close(boolean cleanupOnError) throws StandardException {
                noputResultSet.close(cleanupOnError);
            }

            public void clearCurrentRow() {
                noputResultSet.clearCurrentRow();
            }

            public void cleanUp(boolean cleanupOnError) throws StandardException {
                noputResultSet.cleanUp(cleanupOnError);
            }

            public boolean checkRowPosition(int isType) throws StandardException {
                return noputResultSet.checkRowPosition(isType);
            }

            public void checkCancellationFlag() throws StandardException {
                noputResultSet.checkCancellationFlag();
            }

            public boolean addLockReference(GemFireTransaction tran) {
                return noputResultSet.addLockReference(tran);
            }

            public void accept(ResultSetStatisticsVisitor visitor) {
                noputResultSet.accept(visitor);
            }

            public void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) throws StandardException {
                noputResultSet.upgradeReadLockToWrite(rl, container);
            }

            public void updateRowLocationPostRead() throws StandardException {
                noputResultSet.updateRowLocationPostRead();
            }

            public void updateRow(ExecRow row) throws StandardException {
                noputResultSet.updateRow(row);
            }

            public boolean supportsMoveToNextKey() {
                return noputResultSet.supportsMoveToNextKey();
            }

            public void setTargetResultSet(TargetResultSet trs) {
                noputResultSet.setTargetResultSet(trs);
            }

            public void setNeedsRowLocation(boolean needsRowLocation) {
                noputResultSet.setNeedsRowLocation(needsRowLocation);
            }

            public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
                noputResultSet.setGfKeysForNCJoin(keys);
            }

            public void setCurrentRow(ExecRow row) {
                noputResultSet.setCurrentRow(row);
            }

            public int resultSetNumber() {
                return noputResultSet.resultSetNumber();
            }

            public boolean requiresRelocking() {
                return noputResultSet.requiresRelocking();
            }

            public void reopenCore() throws StandardException {
                noputResultSet.reopenCore();
            }

            public void releasePreviousByteSource() {
                noputResultSet.releasePreviousByteSource();
            }

            public void setMaxSortingLimit(long limit) {
                noputResultSet.setMaxSortingLimit(limit);
            }

            public void positionScanAtRowLocation(RowLocation rLoc) throws StandardException {
                noputResultSet.positionScanAtRowLocation(rLoc);
            }

            public void openCore() throws StandardException {
                noputResultSet.openCore();
            }

            public void markRowAsDeleted() throws StandardException {
                noputResultSet.markRowAsDeleted();
            }

            public void markAsTopResultSet() {
                noputResultSet.markAsTopResultSet();
            }

            public boolean isForUpdate() {
                return noputResultSet.isForUpdate();
            }

            public TXState initLocalTXState() {
                return noputResultSet.initLocalTXState();
            }

            public int getScanKeyGroupID() {
                return noputResultSet.getScanKeyGroupID();
            }

            public int getScanIsolationLevel() {
                return noputResultSet.getScanIsolationLevel();
            }

            public int getPointOfAttachment() {
                return noputResultSet.getPointOfAttachment();
            }

            public ExecRow getNextRowCore() throws StandardException {
                Object bs;
                ExecRow row = noputResultSet.getNextRowCore();
                if (row != null && row instanceof AbstractCompactExecRow && (bs = ((AbstractCompactExecRow)row).getByteSource()) instanceof OffHeapByteSource) {
                    ((OffHeapByteSource)bs).release();
                }
                return row;
            }

            public PlanUtils.Context getNewPlanContext() {
                return noputResultSet.getNewPlanContext();
            }

            public double getEstimatedRowCount() {
                return noputResultSet.getEstimatedRowCount();
            }

            public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
                noputResultSet.filteredRowLocationPostRead(localTXState);
            }

            public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
                return noputResultSet.fetch(loc, destRow, validColumns, faultIn, container);
            }

            public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
                return noputResultSet.buildQueryPlan(builder, context);
            }

            public void forceReOpenCore() throws StandardException {
                noputResultSet.forceReOpenCore();
            }
        };
        return testResultSetPassThru;
    }
}

