/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEventQueue;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderConfigurationException;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.AsyncEventListener;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.GfxdGatewayEventListener;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.WanProcedures;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import io.snappydata.test.dunit.DistributedTestBase;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class WanTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(WanTest.class));
    }

    public WanTest(String name) {
        super(name);
    }

    public static void myTest(Integer param) {
        System.out.println("param=" + param);
    }

    protected String getCreateTestTableSQL() {
        return "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (" + currentTest + ")";
    }

    protected String getCreateTestTableWithoutAsyncEventListenerSQL() {
        return "create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024))";
    }

    protected String getCreateAppSG1TestTableSQL() {
        return "create table APP1_SG1.TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (" + currentTest + ")";
    }

    protected String getCreateAppSG2TestTableSQL() {
        return "create table APP2_SG2.TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (" + currentTest + ")";
    }

    protected String getSQLSuffixClause() {
        return "";
    }

    protected void waitForAsyncQueueToDrain(String asyncQueueBackingRegion) {
        final Region region = Misc.getRegion((String)asyncQueueBackingRegion, (boolean)true, (boolean)false);
        DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)new DistributedTestBase.WaitCriterion(){

            public boolean done() {
                return region.isEmpty();
            }

            public String description() {
                return "Waiting for the backing region of the AsyncEventQueue to drain.";
            }
        }, (long)5000L, (long)500L, (boolean)true);
    }

    public void testTableCreationWithAsyncEventListener() throws SQLException {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = WanTest.getConnection(info);
        JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListener", new Integer(10), null, null, null, null, Boolean.TRUE, Boolean.TRUE, null, "test-init-param");
        Statement stmt = conn.createStatement();
        stmt.execute(this.getCreateTestTableSQL());
        Region rgn = Misc.getGemFireCache().getRegion('/' + WanTest.getCurrentDefaultSchemaName() + "/TESTTABLE");
        String listenerId = currentTest.toUpperCase();
        WanTest.assertTrue((boolean)rgn.getAttributes().getEnableGateway());
        WanTest.assertTrue((String)rgn.getAttributes().getAsyncEventQueueIds().toString(), (boolean)rgn.getAttributes().getAsyncEventQueueIds().contains(listenerId));
        AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue(listenerId);
        WanTest.assertNotNull((Object)asyncQueue);
        WanTest.assertFalse((boolean)asyncQueue.isRunning());
        WanTest.assertFalse((boolean)asyncQueue.isPrimary());
        JdbcTestBase.startAsyncEventListener(currentTest);
        WanTest.assertTrue((boolean)asyncQueue.isRunning());
        WanTest.assertTrue((boolean)asyncQueue.isPrimary());
        WanTest.assertTrue((boolean)asyncQueue.isPersistent());
        WanTest.assertTrue((boolean)asyncQueue.isDiskSynchronous());
        TestGatewayEventListener tgen = (TestGatewayEventListener)this.getGatewayListenerForWBCL(currentTest).getAsyncEventListenerForTest();
        WanTest.assertEquals((String)tgen.test, (String)"test-init-param");
    }

    public void testAsyncEventListenerStop() throws SQLException {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = WanTest.getConnection(info);
        JdbcTestBase.addAsyncEventListenerWithConn("SG1", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListener", new Integer(10), null, null, null, null, Boolean.FALSE, Boolean.FALSE, null, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute(this.getCreateTestTableSQL());
        Region rgn = Misc.getGemFireCache().getRegion('/' + WanTest.getCurrentDefaultSchemaName() + "/TESTTABLE");
        WanTest.assertTrue((boolean)rgn.getAttributes().getEnableGateway());
        String listenerId = currentTest.toUpperCase();
        WanTest.assertTrue((String)rgn.getAttributes().getAsyncEventQueueIds().toString(), (boolean)rgn.getAttributes().getAsyncEventQueueIds().contains(listenerId));
        AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue(listenerId);
        WanTest.assertNotNull((Object)asyncQueue);
        WanTest.assertFalse((boolean)asyncQueue.isRunning());
        WanTest.assertFalse((boolean)asyncQueue.isPrimary());
        JdbcTestBase.startAsyncEventListener(currentTest);
        WanTest.assertTrue((boolean)asyncQueue.isRunning());
        WanTest.assertTrue((boolean)asyncQueue.isPrimary());
        JdbcTestBase.stopAsyncEventListener(currentTest);
        WanTest.assertFalse((boolean)asyncQueue.isRunning());
    }

    private GfxdGatewayEventListener getGatewayListenerForWBCL(String wbclID) {
        AsyncEventQueue asyncQueue = Misc.getGemFireCache().getAsyncEventQueue(wbclID.toUpperCase());
        return (GfxdGatewayEventListener)asyncQueue.getAsyncEventListener();
    }

    public void testNoAsyncEventListenerCreatedDueToServerGroupMismatch() throws SQLException {
        block2: {
            Properties info = new Properties();
            info.setProperty("server-groups", "SG1");
            WanTest.getConnection(info);
            try {
                JdbcTestBase.addAsyncEventListenerWithConn("SG2", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListener", new Integer(10), null, null, null, null, null, null, null, null, null);
                WanTest.fail("expected exception due to no datastore in SG1");
            }
            catch (SQLException sqle) {
                if ("X0Z08".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistentAsyncEventListenerQueue() throws Exception {
        if (isTransactional) {
            return;
        }
        String dirStr = "." + File.separatorChar + currentTest;
        File dir = new File(dirStr);
        try {
            HashSet<Event> temp;
            Properties info = new Properties();
            info.setProperty("server-groups", "SG1");
            Connection conn = WanTest.getConnection(info);
            this.cleanUpDirs(new File[]{dir});
            Statement stmt = conn.createStatement();
            stmt.execute("create diskstore test ( '" + dirStr + "' )");
            JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListenerNotify", new Integer(50), null, null, null, "test", Boolean.TRUE, Boolean.TRUE, null, "false");
            TestGatewayEventListenerNotify tgen = (TestGatewayEventListenerNotify)this.getGatewayListenerForWBCL(currentTest).getAsyncEventListenerForTest();
            JdbcTestBase.startAsyncEventListener(currentTest);
            stmt.execute(this.getCreateTestTableSQL());
            stmt.execute("Insert into TESTTABLE values(1,'desc1','Add1')");
            stmt.execute("Insert into TESTTABLE values(2,'desc1','Add2')");
            while (true) {
                Event[] events;
                if ((events = tgen.getEventsCollected()) == null) {
                    Thread.sleep(500L);
                    continue;
                }
                temp = new HashSet<Event>();
                for (Event ev : events) {
                    temp.add(ev);
                }
                if (temp.size() == 2) break;
                Thread.sleep(500L);
            }
            Iterator itr = temp.iterator();
            HashSet<Integer> keys = new HashSet<Integer>();
            keys.add(1);
            keys.add(2);
            WanTest.assertTrue((boolean)keys.remove(((Event)itr.next()).getPrimaryKey()[0]));
            WanTest.assertTrue((boolean)keys.remove(((Event)itr.next()).getPrimaryKey()[0]));
            try {
                WanTest.shutDown();
            }
            catch (Exception events) {
                // empty catch block
            }
            info = new Properties();
            WanTest.loadDriver();
            info.setProperty("server-groups", "SG1");
            conn = WanTest.getConnection(info);
            tgen = (TestGatewayEventListenerNotify)this.getGatewayListenerForWBCL(currentTest).getAsyncEventListenerForTest();
            conn = WanTest.getConnection(info);
            while (true) {
                if ((events = tgen.getEventsCollected()) == null) {
                    Thread.sleep(500L);
                    continue;
                }
                temp = new HashSet();
                for (Event ev : events) {
                    temp.add(ev);
                }
                if (temp.size() == 2) break;
                Thread.sleep(500L);
            }
            itr = temp.iterator();
            keys = new HashSet<Integer>();
            keys.add(1);
            keys.add(2);
            WanTest.assertTrue((boolean)keys.remove(((Event)itr.next()).getPrimaryKey()[0]));
            WanTest.assertTrue((boolean)keys.remove(((Event)itr.next()).getPrimaryKey()[0]));
            WanTest.stopAsyncEventListener(currentTest);
        }
        catch (Throwable throwable) {
            this.cleanUpDirs(new File[]{dir});
            throw throwable;
        }
        this.cleanUpDirs(new File[]{dir});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAsyncEventListenerAPI() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = WanTest.getConnection(info);
        JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListenerNotify", new Integer(10), null, false, null, null, Boolean.FALSE, Boolean.FALSE, null, "true,4");
        JdbcTestBase.startAsyncEventListener(currentTest);
        TestGatewayEventListenerNotify tgen = (TestGatewayEventListenerNotify)this.getGatewayListenerForWBCL(currentTest).getAsyncEventListenerForTest();
        Statement stmt = conn.createStatement();
        stmt.execute(this.getCreateTestTableWithoutAsyncEventListenerSQL());
        stmt.execute("alter table TESTTABLE set AsyncEventListener (" + currentTest + ')');
        stmt.execute("Insert into TESTTABLE values(1,'desc1','Add1')");
        stmt.execute("Insert into TESTTABLE values(2,'desc2','Add2')");
        stmt.execute("update TESTTABLE set description = 'modified' where id =2");
        Class<TestGatewayEventListenerNotify> clazz = TestGatewayEventListenerNotify.class;
        synchronized (TestGatewayEventListenerNotify.class) {
            stmt.execute("delete from testtable where ID = 1");
            TestGatewayEventListenerNotify.class.wait(30000L);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            boolean isTransactional = conn.getTransactionIsolation() != 0;
            Event[] events = tgen.getEventsCollected();
            int i = 1;
            for (Event ev : events) {
                WanTest.assertNotNull((Object)ev);
                switch (i) {
                    case 1: {
                        if (isTransactional) {
                            WanTest.assertEquals((Object)Event.Type.BULK_DML, (Object)ev.getType());
                            break;
                        }
                        WanTest.assertEquals((Object)Event.Type.AFTER_INSERT, (Object)ev.getType());
                        List list = ev.getNewRow();
                        WanTest.assertEquals((int)list.size(), (int)3);
                        WanTest.assertEquals(list.get(0), (Object)new Integer(1));
                        WanTest.assertEquals(list.get(1), (Object)"desc1");
                        WanTest.assertEquals(list.get(2), (Object)"Add1");
                        WanTest.assertNull((Object)ev.getModifiedColumns());
                        break;
                    }
                    case 2: {
                        if (isTransactional) {
                            WanTest.assertEquals((Object)Event.Type.BULK_DML, (Object)ev.getType());
                            break;
                        }
                        WanTest.assertEquals((Object)Event.Type.AFTER_INSERT, (Object)ev.getType());
                        List list = ev.getNewRow();
                        WanTest.assertEquals((int)list.size(), (int)3);
                        WanTest.assertEquals(list.get(0), (Object)new Integer(2));
                        WanTest.assertEquals(list.get(1), (Object)"desc2");
                        WanTest.assertEquals(list.get(2), (Object)"Add2");
                        WanTest.assertNull((Object)ev.getModifiedColumns());
                        break;
                    }
                    case 3: {
                        WanTest.assertEquals((Object)Event.Type.AFTER_UPDATE, (Object)ev.getType());
                        List list = ev.getNewRow();
                        WanTest.assertEquals((int)list.size(), (int)3);
                        WanTest.assertNull(list.get(0));
                        WanTest.assertEquals(list.get(1), (Object)"modified");
                        WanTest.assertNull(list.get(2));
                        int[] modCols = ev.getModifiedColumns();
                        WanTest.assertNotNull((Object)modCols);
                        WanTest.assertEquals((int)modCols[0], (int)2);
                        break;
                    }
                    case 4: {
                        WanTest.assertEquals((Object)Event.Type.AFTER_DELETE, (Object)ev.getType());
                        List list = ev.getNewRow();
                        WanTest.assertNull((Object)list);
                        WanTest.assertNull((Object)ev.getModifiedColumns());
                        break;
                    }
                }
                ++i;
            }
            this.waitForAsyncQueueToDrain("AsyncEventQueue_TESTASYNCEVENTLISTENERAPI_SERIAL_GATEWAY_SENDER_QUEUE");
            return;
        }
    }

    public void testGfxdBaseDirPathSetViaProperties() throws Exception {
        Properties info = new Properties();
        char fileSeparator = File.separatorChar;
        String dir = "." + fileSeparator + "testGfxdBaseDirPathSetViaProperties";
        info.setProperty("sys-disk-dir", dir);
        info.setProperty("server-groups", "SG1");
        this.deleteDirs = new String[]{dir};
        WanTest.getConnection(info);
        WanTest.assertEquals((String)System.getProperty(GfxdConstants.SYS_PERSISTENT_DIR_PROP), (String)dir);
    }

    public void _testBug41366_1() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1,SG2");
        Connection conn = WanTest.getConnection(info);
        JdbcTestBase.addAsyncEventListenerWithConn("SG1", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListener", null, new Integer(10), null, null, null, null, null, null, null, null);
        Statement stmt = conn.createStatement();
        stmt.execute("create schema APP1_SG1 DEFAULT SERVER GROUPS (SG1)");
        stmt.execute("create schema APP2_SG2 DEFAULT SERVER GROUPS (SG2)");
        stmt.execute(this.getCreateAppSG1TestTableSQL());
        stmt.execute(this.getCreateAppSG2TestTableSQL());
        Region rgn = Misc.getGemFireCache().getRegion("/APP1_SG1/TESTTABLE");
        WanTest.assertTrue((boolean)rgn.getAttributes().getEnableGateway());
        WanTest.assertEquals((String)rgn.getAttributes().getGatewayHubId(), (String)currentTest);
        rgn = Misc.getGemFireCache().getRegion("/APP2_SG2/TESTTABLE");
        WanTest.assertFalse((boolean)rgn.getAttributes().getEnableGateway());
        WanTest.assertEquals((String)rgn.getAttributes().getGatewayHubId(), (String)currentTest);
    }

    public void testBug41562_1() throws Exception {
        block2: {
            Connection conn = WanTest.getConnection();
            Statement stmt = conn.createStatement();
            stmt.execute(this.getCreateTestTableSQL());
            try {
                JdbcTestBase.addAsyncEventListenerWithConn(null, currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListener", null, new Integer(10), null, null, null, null, null, null, null, null);
                WanTest.fail("AsyncEventListener attachment should have thrown exception");
            }
            catch (SQLException sqle) {
                if ("42X01".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
    }

    public void testBug41562_2() throws Exception {
        block2: {
            Connection conn = WanTest.getConnection();
            Statement stmt = conn.createStatement();
            stmt.execute(this.getCreateTestTableSQL());
            try {
                JdbcTestBase.addAsyncEventListenerWithConn("", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListener", null, new Integer(10), null, null, null, null, null, null, null, null);
                WanTest.fail("AsyncEventListener attachment should have thrown exception");
            }
            catch (SQLException sqle) {
                if ("42X01".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGatewayEventsSuppressionBehaviour() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = WanTest.getConnection(info);
        JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListenerNotify", new Integer(10), null, null, null, null, Boolean.FALSE, Boolean.FALSE, null, "true,6");
        AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue(currentTest.toUpperCase());
        asyncQueue.addGatewayEventFilter(WanProcedures.getSerialDBSynchronizerFilter((boolean)true));
        JdbcTestBase.startAsyncEventListener(currentTest);
        TestGatewayEventListenerNotify tgen = (TestGatewayEventListenerNotify)this.getGatewayListenerForWBCL(currentTest).getAsyncEventListenerForTest();
        Statement stmt = conn.createStatement();
        stmt.execute(this.getCreateTestTableSQL());
        stmt.execute("Insert into TESTTABLE values(1,'desc1','Add1')");
        stmt.execute("Insert into TESTTABLE values(2,'desc2','Add2')");
        stmt.execute("Insert into TESTTABLE values(3,'desc3','Add3')");
        stmt.execute("Insert into TESTTABLE values(4,'desc4','Add4')");
        stmt.execute("update TESTTABLE set description = 'modified' where id =2");
        stmt.execute("delete from testtable where ADDRESS = 'Add4'");
        Class<TestGatewayEventListenerNotify> clazz = TestGatewayEventListenerNotify.class;
        synchronized (TestGatewayEventListenerNotify.class) {
            stmt.execute("delete from testtable where ID = 1");
            TestGatewayEventListenerNotify.class.wait(30000L);
            // ** MonitorExit[var6_6] (shouldn't be in output)
            Event[] events = tgen.getEventsCollected();
            int i = 1;
            for (Event ev : events) {
                WanTest.assertNotNull((Object)ev);
                switch (i) {
                    case 1: {
                        WanTest.assertEquals((Object)ev.getType(), (Object)Event.Type.AFTER_INSERT);
                        List list = ev.getNewRow();
                        WanTest.assertEquals((int)list.size(), (int)3);
                        WanTest.assertEquals(list.get(0), (Object)new Integer(1));
                        WanTest.assertEquals(list.get(1), (Object)"desc1");
                        WanTest.assertEquals(list.get(2), (Object)"Add1");
                        WanTest.assertNull((Object)ev.getModifiedColumns());
                        WanTest.assertEquals((Object)1, (Object)ev.getPrimaryKey()[0]);
                        break;
                    }
                    case 2: {
                        WanTest.assertEquals((Object)ev.getType(), (Object)Event.Type.AFTER_INSERT);
                        List list = ev.getNewRow();
                        WanTest.assertEquals((int)list.size(), (int)3);
                        WanTest.assertEquals(list.get(0), (Object)new Integer(2));
                        WanTest.assertEquals(list.get(1), (Object)"desc2");
                        WanTest.assertEquals(list.get(2), (Object)"Add2");
                        WanTest.assertNull((Object)ev.getModifiedColumns());
                        WanTest.assertEquals((Object)2, (Object)ev.getPrimaryKey()[0]);
                        break;
                    }
                    case 3: {
                        WanTest.assertEquals((Object)ev.getType(), (Object)Event.Type.AFTER_INSERT);
                        List list = ev.getNewRow();
                        WanTest.assertEquals((int)list.size(), (int)3);
                        WanTest.assertEquals(list.get(0), (Object)new Integer(3));
                        WanTest.assertEquals(list.get(1), (Object)"desc3");
                        WanTest.assertEquals(list.get(2), (Object)"Add3");
                        WanTest.assertNull((Object)ev.getModifiedColumns());
                        WanTest.assertEquals((Object)3, (Object)ev.getPrimaryKey()[0]);
                        break;
                    }
                    case 4: {
                        WanTest.assertEquals((Object)ev.getType(), (Object)Event.Type.AFTER_INSERT);
                        List list = ev.getNewRow();
                        WanTest.assertEquals((int)list.size(), (int)3);
                        WanTest.assertEquals(list.get(0), (Object)new Integer(4));
                        WanTest.assertEquals(list.get(1), (Object)"desc4");
                        WanTest.assertEquals(list.get(2), (Object)"Add4");
                        WanTest.assertNull((Object)ev.getModifiedColumns());
                        WanTest.assertEquals((Object)4, (Object)ev.getPrimaryKey()[0]);
                        break;
                    }
                    case 5: {
                        WanTest.assertEquals((Object)ev.getType(), (Object)Event.Type.AFTER_UPDATE);
                        List list = ev.getNewRow();
                        WanTest.assertEquals((int)list.size(), (int)3);
                        WanTest.assertNull(list.get(0));
                        WanTest.assertEquals(list.get(1), (Object)"modified");
                        WanTest.assertNull(list.get(2));
                        int[] modCols = ev.getModifiedColumns();
                        WanTest.assertNotNull((Object)modCols);
                        WanTest.assertNull((Object)ev.getOldRow());
                        WanTest.assertEquals((int)modCols[0], (int)2);
                        WanTest.assertEquals((Object)2, (Object)ev.getPrimaryKey()[0]);
                        break;
                    }
                    case 6: {
                        WanTest.assertEquals((Object)ev.getType(), (Object)Event.Type.AFTER_DELETE);
                        List list = ev.getNewRow();
                        WanTest.assertNull((Object)list);
                        WanTest.assertNull((Object)ev.getModifiedColumns());
                        WanTest.assertEquals((Object)1, (Object)ev.getPrimaryKey()[0]);
                        break;
                    }
                }
                ++i;
            }
            this.waitForAsyncQueueToDrain("AsyncEventQueue_TESTGATEWAYEVENTSSUPPRESSIONBEHAVIOUR_SERIAL_GATEWAY_SENDER_QUEUE");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbSynchronizerPersistenceWithoutParams(boolean isPR, boolean useGfxdNetclient) throws Exception {
        Statement derbyStmt = null;
        Statement stmt = null;
        final int[] numInserts = new int[]{0};
        final int[] numPKUpdates = new int[]{0};
        final int[] numPKDeletes = new int[]{0};
        final int[] numBulkOp = new int[]{0};
        try {
            Properties info = new Properties();
            info.setProperty("server-groups", "SG1");
            Connection conn = WanTest.getConnection(info);
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            String createTable = "create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int)";
            derbyStmt.execute(createTable);
            if (useGfxdNetclient) {
                conn = TestUtil.startNetserverAndGetLocalNetConnection();
            }
            JdbcTestBase.addAsyncEventListenerWithConn("SG1", currentTest, "com.pivotal.gemfirexd.callbacks.DBSynchronizer", new Integer(10), null, null, null, null, Boolean.FALSE, Boolean.FALSE, null, "org.apache.derby.jdbc.EmbeddedDriver," + derbyDbUrl, conn);
            JdbcTestBase.startAsyncEventListener(currentTest);
            final boolean[] ok = new boolean[]{false};
            stmt = conn.createStatement();
            stmt.execute("create table TESTTABLE (ID int not null primary key , DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int ) AsyncEventListener (" + currentTest + ')' + (isPR ? "" : " replicate") + this.getSQLSuffixClause());
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsModified, Statement ps, String dml) {
                    numBulkOp[0] = numBulkOp[0] + 1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterPKBasedDBSynchExecution(Event.Type type, int numRowsModified, Statement ps) {
                    if (type.equals((Object)Event.Type.AFTER_DELETE)) {
                        numPKDeletes[0] = numPKDeletes[0] + numRowsModified;
                        WanTest wanTest = WanTest.this;
                        synchronized (wanTest) {
                            ((Object)((Object)WanTest.this)).notify();
                            ok[0] = true;
                        }
                    } else if (type.equals((Object)Event.Type.AFTER_INSERT)) {
                        numInserts[0] = numInserts[0] + numRowsModified;
                    } else if (type.equals((Object)Event.Type.AFTER_UPDATE)) {
                        numPKUpdates[0] = numPKUpdates[0] + numRowsModified;
                    }
                }
            });
            stmt.execute("Insert into TESTTABLE values(1,'desc1','Add1',1)");
            stmt.execute("Insert into TESTTABLE values(2,'desc2','Add2',2)");
            stmt.execute("Insert into TESTTABLE values(3,'desc3','Add3',3)");
            stmt.execute("Insert into TESTTABLE values(4,'desc4','Add4',4)");
            stmt.execute("Insert into TESTTABLE values(5,'desc5','Add4',5)");
            stmt.execute("Insert into TESTTABLE values(6,'desc6','Add6',6)");
            stmt.execute("update TESTTABLE set ID1 = ID1 +1 ");
            stmt.execute("delete from TESTTABLE where ID1 = 5 ");
            stmt.execute("update TESTTABLE set description = 'modified' where id =2");
            stmt.execute("delete from testtable where ID = 1");
            conn.commit();
            WanTest wanTest = this;
            synchronized (wanTest) {
                if (!ok[0]) {
                    ((Object)((Object)this)).wait(30000L);
                }
            }
            if (conn.getTransactionIsolation() != 0) {
                WanTest.assertEquals((int)0, (int)numInserts[0]);
            } else {
                WanTest.assertEquals((int)6, (int)numInserts[0]);
            }
            WanTest.assertEquals((int)1, (int)numPKUpdates[0]);
            WanTest.assertEquals((int)1, (int)numPKDeletes[0]);
            WanTest.assertEquals((int)2, (int)numBulkOp[0]);
            final AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue(currentTest.toUpperCase());
            DistributedTestBase.WaitCriterion wc = new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    return asyncQueue.getSender().getQueue().size() == 0;
                }

                public String description() {
                    return "waiting for queue for " + TestUtil.currentTest.toUpperCase() + " to drain";
                }
            };
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)30000L, (long)500L, (boolean)true);
            JdbcTestBase.stopAsyncEventListener(currentTest);
            WanTest.validateResults(derbyStmt, stmt, "select * from testtable", false);
        }
        finally {
            block18: {
                if (derbyStmt != null) {
                    derbyStmt.execute("drop table TESTTABLE");
                }
                if (stmt != null) {
                    stmt.execute("drop table TESTTABLE");
                    this.waitTillAllClear();
                }
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block18;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbSynchronizerPersistenceWithParams(boolean isPR) throws Exception {
        Statement derbyStmt = null;
        Statement stmt = null;
        final int[] numInserts = new int[]{0};
        final int[] numPKUpdates = new int[]{0};
        final int[] numPKDeletes = new int[]{0};
        final int[] numBulkOp = new int[]{0};
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute("create table TESTTABLE (ID int not null primary key,DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int)");
            Properties info = new Properties();
            info.setProperty("server-groups", "SG1");
            Connection conn = WanTest.getConnection(info);
            JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.callbacks.DBSynchronizer", new Integer(10), null, null, null, null, Boolean.FALSE, Boolean.FALSE, null, "org.apache.derby.jdbc.EmbeddedDriver," + derbyDbUrl);
            JdbcTestBase.startAsyncEventListener(currentTest);
            final boolean[] ok = new boolean[]{false};
            stmt = conn.createStatement();
            stmt.execute("create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int) AsyncEventListener (" + currentTest + ')' + (isPR ? "" : " replicate") + this.getSQLSuffixClause());
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsModified, Statement ps, String dml) {
                    numBulkOp[0] = numBulkOp[0] + 1;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterPKBasedDBSynchExecution(Event.Type type, int numRowsModified, Statement ps) {
                    if (type.equals((Object)Event.Type.AFTER_DELETE)) {
                        numPKDeletes[0] = numPKDeletes[0] + numRowsModified;
                        WanTest wanTest = WanTest.this;
                        synchronized (wanTest) {
                            ((Object)((Object)WanTest.this)).notify();
                            ok[0] = true;
                        }
                    } else if (type.equals((Object)Event.Type.AFTER_INSERT)) {
                        numInserts[0] = numInserts[0] + numRowsModified;
                    } else if (type.equals((Object)Event.Type.AFTER_UPDATE)) {
                        numPKUpdates[0] = numPKUpdates[0] + numRowsModified;
                    }
                }
            });
            stmt.execute("Insert into TESTTABLE values(1,'desc1','Add1',1)");
            stmt.execute("Insert into TESTTABLE values(2,'desc2','Add2',2)");
            stmt.execute("Insert into TESTTABLE values(3,'desc3','Add3',3)");
            stmt.execute("Insert into TESTTABLE values(4,'desc4','Add4',4)");
            stmt.execute("Insert into TESTTABLE values(5,'desc5','Add4',5)");
            stmt.execute("Insert into TESTTABLE values(6,'desc6','Add6',6)");
            PreparedStatement pstmt = conn.prepareStatement("update TESTTABLE set ID1 = ID1 + ? ");
            pstmt.setInt(1, 1);
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("delete from TESTTABLE where ID1 = ? ");
            pstmt.setInt(1, 5);
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("update TESTTABLE set description = ? where id =?");
            pstmt.setString(1, "modified");
            pstmt.setInt(2, 2);
            pstmt.executeUpdate();
            stmt.execute("delete from testtable where ID = 1");
            WanTest wanTest = this;
            synchronized (wanTest) {
                if (!ok[0]) {
                    ((Object)((Object)this)).wait(30000L);
                }
            }
            WanTest.assertEquals((int)6, (int)numInserts[0]);
            WanTest.assertEquals((int)1, (int)numPKUpdates[0]);
            WanTest.assertEquals((int)1, (int)numPKDeletes[0]);
            WanTest.assertEquals((int)2, (int)numBulkOp[0]);
            final AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue(currentTest.toUpperCase());
            DistributedTestBase.WaitCriterion wc = new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    return asyncQueue.getSender().getQueue().size() == 0;
                }

                public String description() {
                    return "waiting for queue for " + TestUtil.currentTest.toUpperCase() + " to drain";
                }
            };
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)30000L, (long)500L, (boolean)true);
            JdbcTestBase.stopAsyncEventListener(currentTest);
            WanTest.validateResults(derbyStmt, stmt, "select * from testtable", false);
        }
        finally {
            if (derbyStmt != null) {
                derbyStmt.execute("drop table TESTTABLE");
            }
            if (stmt != null) {
                stmt.execute("drop table TESTTABLE");
                this.waitTillAllClear();
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testDBSynchronizerPersistenceWithoutParamsForPr() throws Exception {
        if (isTransactional) {
            return;
        }
        this.dbSynchronizerPersistenceWithoutParams(true, false);
    }

    public void testDBSynchronizerPersistenceWithoutParamsForPrUsingGfxdNetClient() throws Exception {
        if (isTransactional) {
            return;
        }
        this.dbSynchronizerPersistenceWithoutParams(true, true);
    }

    public void testDBSynchronizerPersistenceWithoutParamsForReplicate() throws Exception {
        if (isTransactional) {
            return;
        }
        this.dbSynchronizerPersistenceWithoutParams(false, true);
    }

    public void testDBSynchronizerPersistenceWithParamsForPr() throws Exception {
        if (isTransactional) {
            return;
        }
        this.dbSynchronizerPersistenceWithParams(true);
    }

    public void testDBSynchronizerPersistenceWithParamsForReplicate() throws Exception {
        if (isTransactional) {
            return;
        }
        this.dbSynchronizerPersistenceWithParams(false);
    }

    public void testMultipleAsyncEventListeners_Bug43419() throws Exception {
        Event[] events;
        if (isTransactional) {
            return;
        }
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = WanTest.getConnection(info);
        JdbcTestBase.addAsyncEventListener("SG1", currentTest + "_1", "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListenerNotify", new Integer(10), null, null, null, null, null, null, null, "test-init-param");
        JdbcTestBase.addAsyncEventListener("SG1", currentTest + "_2", "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListenerNotify", new Integer(10), null, null, null, null, null, null, null, "test-init-param");
        Statement stmt = conn.createStatement();
        stmt.execute("create table TESTTABLE (ID int not null , DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (" + currentTest + "_1, " + currentTest + "_2)" + this.getSQLSuffixClause());
        Region rgn = Misc.getGemFireCache().getRegion('/' + WanTest.getCurrentDefaultSchemaName() + "/TESTTABLE");
        WanTest.assertTrue((boolean)rgn.getAttributes().getEnableGateway());
        WanTest.assertEquals((String)rgn.getAttributes().getGatewayHubId(), (String)"");
        JdbcTestBase.startAsyncEventListener(currentTest + "_1");
        JdbcTestBase.startAsyncEventListener(currentTest + "_2");
        TestGatewayEventListenerNotify tgen1 = (TestGatewayEventListenerNotify)this.getGatewayListenerForWBCL(currentTest + "_1").getAsyncEventListenerForTest();
        TestGatewayEventListenerNotify tgen2 = (TestGatewayEventListenerNotify)this.getGatewayListenerForWBCL(currentTest + "_2").getAsyncEventListenerForTest();
        stmt.execute("Insert into TESTTABLE values(1,'desc1','Add1')");
        while ((events = tgen1.getEventsCollected()) == null) {
            Thread.sleep(500L);
        }
        WanTest.assertEquals((int)1, (int)events.length);
        while ((events = tgen2.getEventsCollected()) == null) {
            Thread.sleep(500L);
        }
        WanTest.assertEquals((int)1, (int)events.length);
        this.waitForAsyncQueueToDrain("AsyncEventQueue_TESTMULTIPLEASYNCEVENTLISTENERS_BUG43419_1_SERIAL_GATEWAY_SENDER_QUEUE");
        this.waitForAsyncQueueToDrain("AsyncEventQueue_TESTMULTIPLEASYNCEVENTLISTENERS_BUG43419_2_SERIAL_GATEWAY_SENDER_QUEUE");
    }

    public void testAsyncEventListenerForSkipListenerForReplicate() throws Exception {
        this.asyncEventListenerForSkipListener(true, false, -1);
    }

    public void testAsyncEventListenerForSkipListenerForPR() throws Exception {
        this.asyncEventListenerForSkipListener(false, false, -1);
    }

    public void testAsyncEventListenerForSkipListenerForPRUsingNetConnection() throws Exception {
        this.asyncEventListenerForSkipListener(false, true, 1535);
    }

    public void testAsyncEventListenerForSkipListenerForReplicateUsingNetConnection() throws Exception {
        this.asyncEventListenerForSkipListener(true, true, 1536);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncEventListenerForSkipListener(boolean useReplicate, boolean useNetConnection, int port) throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = null;
        try {
            conn = TestUtil.getConnection(info);
            info.clear();
            info.setProperty("skip-listeners", "true");
            if (useNetConnection) {
                TestUtil.startNetServer(port, null);
            }
            JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListenerNotify", new Integer(10), null, null, null, null, null, null, null, "test-init-param,0");
            Statement stmt = conn.createStatement();
            stmt.execute("create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024)) AsyncEventListener (" + currentTest + ')' + (useReplicate ? "replicate" : "") + this.getSQLSuffixClause());
            JdbcTestBase.startAsyncEventListener(currentTest);
            conn = useNetConnection ? TestUtil.getNetConnection(port, null, info) : TestUtil.getConnection(info);
            stmt = conn.createStatement();
            TestGatewayEventListenerNotify tgen1 = (TestGatewayEventListenerNotify)this.getGatewayListenerForWBCL(currentTest).getAsyncEventListenerForTest();
            stmt.execute("Insert into TESTTABLE values(1,'desc1','Add1')");
            stmt.execute("Insert into TESTTABLE values(2,'desc2','Add2')");
            stmt.execute("Update TESTTABLE set DESCRIPTION =''");
            stmt.execute("Update TESTTABLE set DESCRIPTION ='desc1' where ID = 1");
            stmt.execute("delete from TESTTABLE where ID = 1");
            stmt.execute("delete from TESTTABLE ");
            Thread.sleep(3000L);
            Event[] events = tgen1.getEventsCollected();
            WanTest.assertEquals((int)0, (int)events.length);
            WanTest.assertEquals((int)0, (int)tgen1.getNumCallbacks());
            WanTest.assertFalse((boolean)tgen1.exceptionOccurred());
        }
        finally {
            conn.close();
            if (useNetConnection) {
                TestUtil.stopNetServer();
            }
        }
    }

    public void testDBSynchronizerForSkipListenerReplicate() throws Exception {
        this.dbSynchronizerForSkipListener(true);
    }

    public void testDBSynchronizerForSkipListenerPR() throws Exception {
        this.dbSynchronizerForSkipListener(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dbSynchronizerForSkipListener(boolean useReplicate) throws Exception {
        Statement derbyStmt = null;
        Statement stmt = null;
        final boolean[] anyCallBack = new boolean[]{false};
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute("create table TESTTABLE (ID int not null primary key,DESCRIPTION varchar(1024), ADDRESS varchar(1024), ID1 int)");
            Properties info = new Properties();
            info.setProperty("server-groups", "SG1");
            info.setProperty("skip-listeners", "true");
            Connection conn = WanTest.getConnection(info);
            JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.callbacks.DBSynchronizer", new Integer(10), null, null, null, null, Boolean.FALSE, Boolean.FALSE, null, "org.apache.derby.jdbc.EmbeddedDriver," + derbyDbUrl);
            JdbcTestBase.startAsyncEventListener(currentTest);
            stmt = conn.createStatement();
            stmt.execute("create table TESTTABLE (ID int not null primary key, DESCRIPTION varchar(1024) , ADDRESS varchar(1024), ID1 int) AsyncEventListener (" + currentTest + ") " + (useReplicate ? "replicate " : "") + this.getSQLSuffixClause());
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter(){

                public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsModified, Statement ps, String dml) {
                    anyCallBack[0] = true;
                }

                public void afterPKBasedDBSynchExecution(Event.Type type, int numRowsModified, Statement ps) {
                    anyCallBack[0] = true;
                }
            });
            stmt.execute("Insert into TESTTABLE values(1,'desc1','Add1',1)");
            stmt.execute("Insert into TESTTABLE values(2,'desc2','Add2',2)");
            stmt.execute("Insert into TESTTABLE values(3,'desc3','Add3',3)");
            stmt.execute("Insert into TESTTABLE values(4,'desc4','Add4',4)");
            stmt.execute("Insert into TESTTABLE values(5,'desc5','Add4',5)");
            stmt.execute("Insert into TESTTABLE values(6,'desc6','Add6',6)");
            PreparedStatement pstmt = conn.prepareStatement("update TESTTABLE set ID1 = ID1 + ? ");
            pstmt.setInt(1, 1);
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("delete from TESTTABLE where ID1 = ? ");
            pstmt.setInt(1, 5);
            pstmt.executeUpdate();
            pstmt = conn.prepareStatement("update TESTTABLE set description = ? where id =?");
            pstmt.setString(1, "modified");
            pstmt.setInt(2, 2);
            pstmt.executeUpdate();
            stmt.execute("delete from testtable where ID = 1");
            Thread.sleep(3000L);
            JdbcTestBase.stopAsyncEventListener(currentTest);
            ResultSet derbyRs = derbyStmt.executeQuery("select * from testtable");
            WanTest.assertFalse((boolean)derbyRs.next());
            WanTest.assertFalse((boolean)anyCallBack[0]);
            derbyRs.close();
        }
        finally {
            if (derbyStmt != null) {
                derbyStmt.execute("drop table TESTTABLE");
            }
            if (stmt != null) {
                stmt.execute("drop table TESTTABLE");
                this.waitTillAllClear();
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testExternalProc() throws Exception {
        Connection conn = WanTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE PROCEDURE PRO_TRIGGER(IN num INTEGER ) PARAMETER STYLE JAVA  LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.WanTest.myTest(java.lang.Integer)'");
        conn = WanTest.getConnection();
        CallableStatement cs = conn.prepareCall("CALL PRO_TRIGGER(?)");
        cs.setNull(1, 4);
        cs.execute();
        stmt.execute("CALL PRO_TRIGGER(1) ");
    }

    public void testGatewaySenderToSySTables() throws SQLException {
        this.getConnectionWithServerGroup();
        WanTest.getConnection().createStatement().execute("CREATE GATEWAYSENDER mySender ( remotedsid 2 socketbuffersize 1000 manualstart true  SOCKETREADTIMEOUT 1000 ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false DISKSYNCHRONOUS false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (sg1)");
        ResultSet hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.GATEWAYSENDERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)rsmd.getColumnCount(), (int)15);
        while (hubRs.next()) {
            WanTest.assertEquals((String)"SENDER_ID", (String)rsmd.getColumnName(1));
            WanTest.assertEquals((String)"REMOTE_DS_ID", (String)rsmd.getColumnName(2));
            WanTest.assertEquals((String)"SERVER_GROUPS", (String)rsmd.getColumnName(3));
            WanTest.assertEquals((String)"SOCKET_BUFFER_SIZE", (String)rsmd.getColumnName(4));
            WanTest.assertEquals((String)"MANUAL_START", (String)rsmd.getColumnName(5));
            WanTest.assertEquals((String)"SOCKET_READ_TIMEOUT", (String)rsmd.getColumnName(6));
            WanTest.assertEquals((String)"BATCH_CONFLATION", (String)rsmd.getColumnName(7));
            WanTest.assertEquals((String)"BATCH_SIZE", (String)rsmd.getColumnName(8));
            WanTest.assertEquals((String)"BATCH_TIME_INTERVAL", (String)rsmd.getColumnName(9));
            WanTest.assertEquals((String)"IS_PERSISTENCE", (String)rsmd.getColumnName(10));
            WanTest.assertEquals((String)"DISK_STORE_NAME", (String)rsmd.getColumnName(11));
            WanTest.assertEquals((String)"MAX_QUEUE_MEMORY", (String)rsmd.getColumnName(12));
            WanTest.assertEquals((String)"ALERT_THRESHOLD", (String)rsmd.getColumnName(13));
            WanTest.assertEquals((String)"IS_STARTED", (String)rsmd.getColumnName(14));
            WanTest.assertEquals((String)"DISK_SYNCHRONOUS", (String)rsmd.getColumnName(15));
            WanTest.assertEquals((String)"MYSENDER", (String)hubRs.getString(1));
            WanTest.assertEquals((int)2, (int)hubRs.getInt(2));
            WanTest.assertEquals((String)"SG1", (String)hubRs.getString(3));
            WanTest.assertEquals((int)1000, (int)hubRs.getInt(4));
            WanTest.assertEquals((boolean)true, (boolean)hubRs.getBoolean(5));
            WanTest.assertEquals((int)1000, (int)hubRs.getInt(6));
            WanTest.assertEquals((boolean)true, (boolean)hubRs.getBoolean(7));
            WanTest.assertEquals((int)10, (int)hubRs.getInt(8));
            WanTest.assertEquals((int)100, (int)hubRs.getInt(9));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(10));
            WanTest.assertEquals(null, (String)hubRs.getString(11));
            WanTest.assertEquals((int)400, (int)hubRs.getInt(12));
            WanTest.assertEquals((int)100, (int)hubRs.getInt(13));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(14));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(15));
        }
    }

    public void testGatewaySenderDefaultsToSySTables() throws SQLException {
        this.getConnectionWithServerGroup();
        WanTest.getConnection().createStatement().execute("CREATE GATEWAYSENDER mySender ( remotedsid 2 manualstart true) server groups (sg1)");
        ResultSet hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.GATEWAYSENDERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)rsmd.getColumnCount(), (int)15);
        while (hubRs.next()) {
            WanTest.assertEquals((String)"MYSENDER", (String)hubRs.getString(1));
            WanTest.assertEquals((int)2, (int)hubRs.getInt(2));
            WanTest.assertEquals((String)"SG1", (String)hubRs.getString(3));
            WanTest.assertEquals((int)524288, (int)hubRs.getInt(4));
            WanTest.assertEquals((boolean)true, (boolean)hubRs.getBoolean(5));
            WanTest.assertEquals((int)GatewaySender.DEFAULT_SOCKET_READ_TIMEOUT, (int)hubRs.getInt(6));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(7));
            WanTest.assertEquals((int)100, (int)hubRs.getInt(8));
            WanTest.assertEquals((int)1000, (int)hubRs.getInt(9));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(10));
            WanTest.assertEquals(null, (String)hubRs.getString(11));
            WanTest.assertEquals((int)100, (int)hubRs.getInt(12));
            WanTest.assertEquals((int)0, (int)hubRs.getInt(13));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(14));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(15));
        }
    }

    public void testAsyncEventListenersToSySTables() throws Exception {
        this.getConnectionWithServerGroup();
        Connection conn = WanTest.getConnection();
        conn.createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false  ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false DISKSYNCHRONOUS false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (sg1)");
        ResultSet hubRs = conn.createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            WanTest.assertEquals((String)"ID", (String)rsmd.getColumnName(1));
            WanTest.assertEquals((String)"LISTENER_CLASS", (String)rsmd.getColumnName(2));
            WanTest.assertEquals((String)"SERVER_GROUPS", (String)rsmd.getColumnName(3));
            WanTest.assertEquals((String)"MANUAL_START", (String)rsmd.getColumnName(4));
            WanTest.assertEquals((String)"BATCH_CONFLATION", (String)rsmd.getColumnName(5));
            WanTest.assertEquals((String)"BATCH_SIZE", (String)rsmd.getColumnName(6));
            WanTest.assertEquals((String)"BATCH_TIME_INTERVAL", (String)rsmd.getColumnName(7));
            WanTest.assertEquals((String)"IS_PERSISTENCE", (String)rsmd.getColumnName(8));
            WanTest.assertEquals((String)"DISK_STORE_NAME", (String)rsmd.getColumnName(9));
            WanTest.assertEquals((String)"MAX_QUEUE_MEMORY", (String)rsmd.getColumnName(10));
            WanTest.assertEquals((String)"ALERT_THRESHOLD", (String)rsmd.getColumnName(11));
            WanTest.assertEquals((String)"IS_STARTED", (String)rsmd.getColumnName(12));
            WanTest.assertEquals((String)"DISK_SYNCHRONOUS", (String)rsmd.getColumnName(14));
            WanTest.assertEquals((String)"MYLISTENER", (String)hubRs.getString(1));
            WanTest.assertEquals((String)"com.pivotal.gemfirexd.callbacks.DBSynchronizer", (String)hubRs.getString(2));
            WanTest.assertEquals((String)"SG1", (String)hubRs.getString(3));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(4));
            WanTest.assertEquals((boolean)true, (boolean)hubRs.getBoolean(5));
            WanTest.assertEquals((int)10, (int)hubRs.getInt(6));
            WanTest.assertEquals((int)100, (int)hubRs.getInt(7));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(8));
            WanTest.assertEquals(null, (String)hubRs.getString(9));
            WanTest.assertEquals((int)400, (int)hubRs.getInt(10));
            WanTest.assertEquals((int)100, (int)hubRs.getInt(11));
            WanTest.assertEquals((boolean)true, (boolean)hubRs.getBoolean(12));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(14));
        }
    }

    public void testAsyncEventListenersToSySTables_NetClient() throws Exception {
        this.getConnectionWithServerGroup();
        Connection conn = TestUtil.startNetserverAndGetLocalNetConnection();
        conn.createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false  ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false DISKSYNCHRONOUS false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (sg1)");
        ResultSet hubRs = conn.createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            WanTest.assertEquals((String)"ID", (String)rsmd.getColumnName(1));
            WanTest.assertEquals((String)"LISTENER_CLASS", (String)rsmd.getColumnName(2));
            WanTest.assertEquals((String)"SERVER_GROUPS", (String)rsmd.getColumnName(3));
            WanTest.assertEquals((String)"MANUAL_START", (String)rsmd.getColumnName(4));
            WanTest.assertEquals((String)"BATCH_CONFLATION", (String)rsmd.getColumnName(5));
            WanTest.assertEquals((String)"BATCH_SIZE", (String)rsmd.getColumnName(6));
            WanTest.assertEquals((String)"BATCH_TIME_INTERVAL", (String)rsmd.getColumnName(7));
            WanTest.assertEquals((String)"IS_PERSISTENCE", (String)rsmd.getColumnName(8));
            WanTest.assertEquals((String)"DISK_STORE_NAME", (String)rsmd.getColumnName(9));
            WanTest.assertEquals((String)"MAX_QUEUE_MEMORY", (String)rsmd.getColumnName(10));
            WanTest.assertEquals((String)"ALERT_THRESHOLD", (String)rsmd.getColumnName(11));
            WanTest.assertEquals((String)"IS_STARTED", (String)rsmd.getColumnName(12));
            WanTest.assertEquals((String)"DISK_SYNCHRONOUS", (String)rsmd.getColumnName(14));
            WanTest.assertEquals((String)"MYLISTENER", (String)hubRs.getString(1));
            WanTest.assertEquals((String)"com.pivotal.gemfirexd.callbacks.DBSynchronizer", (String)hubRs.getString(2));
            WanTest.assertEquals((String)"SG1", (String)hubRs.getString(3));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(4));
            WanTest.assertEquals((boolean)true, (boolean)hubRs.getBoolean(5));
            WanTest.assertEquals((int)10, (int)hubRs.getInt(6));
            WanTest.assertEquals((int)100, (int)hubRs.getInt(7));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(8));
            WanTest.assertEquals(null, (String)hubRs.getString(9));
            WanTest.assertEquals((int)400, (int)hubRs.getInt(10));
            WanTest.assertEquals((int)100, (int)hubRs.getInt(11));
            WanTest.assertEquals((boolean)true, (boolean)hubRs.getBoolean(12));
            WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(14));
        }
    }

    public void testAsyncEventListenersDefaultsToSySTables() throws SQLException {
        this.getConnectionWithServerGroup();
        WanTest.getConnection().createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart true) server groups (sg1)");
        ResultSet hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, false);
        }
        CallableStatement cs = WanTest.getConnection().prepareCall("call SYS.START_ASYNC_EVENT_LISTENER (?)");
        cs.setString(1, "MYLISTENER");
        cs.execute();
        hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, true);
        }
        cs = WanTest.getConnection().prepareCall("call SYS.STOP_ASYNC_EVENT_LISTENER (?)");
        cs.setString(1, "MYLISTENER");
        cs.execute();
        hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, false);
        }
        WanTest.getConnection().createStatement().execute("DROP ASYNCEVENTLISTENER MYLISTENER");
        hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        WanTest.assertFalse((boolean)hubRs.next());
        WanTest.getConnection().createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart true) server groups (sg1)");
        hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, false);
        }
        cs = WanTest.getConnection().prepareCall("call SYS.START_ASYNC_EVENT_LISTENER (?)");
        cs.setString(1, "MYLISTENER");
        cs.execute();
        hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, true);
        }
        cs = WanTest.getConnection().prepareCall("call SYS.STOP_ASYNC_EVENT_LISTENER (?)");
        cs.setString(1, "MYLISTENER");
        cs.execute();
        hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, false);
        }
    }

    public void validateSysTableRows(ResultSet hubRs, boolean isStarted) throws SQLException {
        WanTest.assertEquals((String)"MYLISTENER", (String)hubRs.getString(1));
        WanTest.assertEquals((String)"com.pivotal.gemfirexd.callbacks.DBSynchronizer", (String)hubRs.getString(2));
        WanTest.assertEquals((String)"SG1", (String)hubRs.getString(3));
        WanTest.assertEquals((boolean)true, (boolean)hubRs.getBoolean(4));
        WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(5));
        WanTest.assertEquals((int)100, (int)hubRs.getInt(6));
        WanTest.assertEquals((int)5, (int)hubRs.getInt(7));
        WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(8));
        WanTest.assertEquals(null, (String)hubRs.getString(9));
        WanTest.assertEquals((int)100, (int)hubRs.getInt(10));
        WanTest.assertEquals((int)0, (int)hubRs.getInt(11));
        WanTest.assertEquals((boolean)isStarted, (boolean)hubRs.getBoolean(12));
        WanTest.assertEquals((boolean)false, (boolean)hubRs.getBoolean(14));
    }

    public void testAsyncEventListenersDefaultsToSySTables_NetClient() throws Exception {
        this.getConnectionWithServerGroup();
        Connection conn = TestUtil.startNetserverAndGetLocalNetConnection();
        conn.createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart true) server groups (sg1)");
        ResultSet hubRs = conn.createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, false);
        }
        CallableStatement cs = conn.prepareCall("call SYS.START_ASYNC_EVENT_LISTENER (?)");
        cs.setString(1, "MYLISTENER");
        cs.execute();
        hubRs = conn.createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, true);
        }
        cs = conn.prepareCall("call SYS.STOP_ASYNC_EVENT_LISTENER (?)");
        cs.setString(1, "MYLISTENER");
        cs.execute();
        hubRs = conn.createStatement().executeQuery("select * from SYS.ASYNCEVENTLISTENERS");
        rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)14, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            this.validateSysTableRows(hubRs, false);
        }
    }

    public void testGatewayReceiversDefaults() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1,SG2,PQR");
        Connection con = WanTest.getConnection(info);
        con.createStatement().execute("CREATE GATEWAYRECEIVER ok ");
        ResultSet hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)9, (int)rsmd.getColumnCount());
        int runningPort = 0;
        while (hubRs.next()) {
            WanTest.assertEquals((String)"ID", (String)rsmd.getColumnName(1));
            WanTest.assertEquals((String)"RUNNING_PORT", (String)rsmd.getColumnName(2));
            WanTest.assertEquals((String)"START_PORT", (String)rsmd.getColumnName(3));
            WanTest.assertEquals((String)"END_PORT", (String)rsmd.getColumnName(4));
            WanTest.assertEquals((String)"SERVER_GROUPS", (String)rsmd.getColumnName(5));
            WanTest.assertEquals((String)"SOCKET_BUFFER_SIZE", (String)rsmd.getColumnName(6));
            WanTest.assertEquals((String)"MAX_TIME_BETWEEN_PINGS", (String)rsmd.getColumnName(7));
            WanTest.assertEquals((String)"BIND_ADDRESS", (String)rsmd.getColumnName(8));
            WanTest.assertEquals((String)"HOST_NAME_FOR_SENDERS", (String)rsmd.getColumnName(9));
            WanTest.assertEquals((String)"OK", (String)hubRs.getString(1));
            runningPort = hubRs.getInt(2);
            WanTest.assertTrue((5000 <= runningPort && 5500 > runningPort ? 1 : 0) != 0);
            WanTest.assertEquals((int)5000, (int)hubRs.getInt(3));
            WanTest.assertEquals((int)5500, (int)hubRs.getInt(4));
            WanTest.assertEquals((String)"", (String)hubRs.getString(5));
            WanTest.assertEquals((int)524288, (int)hubRs.getInt(6));
            WanTest.assertEquals((int)60000, (int)hubRs.getInt(7));
            WanTest.assertEquals((String)"", (String)hubRs.getString(8));
            WanTest.assertEquals((String)SocketCreator.getLocalHost().getHostName(), (String)hubRs.getString(9));
        }
    }

    public void testGatewayReceiversHNSWithCustomProperty() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1,SG2,PQR");
        info.setProperty("custom-NIC1", "NIC1");
        Connection con = WanTest.getConnection(info);
        con.createStatement().execute("CREATE GATEWAYRECEIVER ok (hostnameforsenders 'NIC1')");
        ResultSet hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)9, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            WanTest.assertEquals((String)"HOST_NAME_FOR_SENDERS", (String)rsmd.getColumnName(9));
            WanTest.assertEquals((String)"NIC1", (String)hubRs.getString(9));
        }
    }

    public void testGatewayReceiversHNSWithIP() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1,SG2,PQR");
        info.setProperty("custom-NIC1", "NIC1");
        Connection con = WanTest.getConnection(info);
        con.createStatement().execute("CREATE GATEWAYRECEIVER ok (hostnameforsenders '127.0.0.1')");
        ResultSet hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)9, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            WanTest.assertEquals((String)"HOST_NAME_FOR_SENDERS", (String)rsmd.getColumnName(9));
            WanTest.assertEquals((String)"127.0.0.1", (String)hubRs.getString(9));
        }
    }

    public void testGatewayReceiversHNSWithLocalHost() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1,SG2,PQR");
        info.setProperty("custom-NIC1", "NIC1");
        Connection con = WanTest.getConnection(info);
        con.createStatement().execute("CREATE GATEWAYRECEIVER ok (hostnameforsenders 'localhost')");
        ResultSet hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)9, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            WanTest.assertEquals((String)"HOST_NAME_FOR_SENDERS", (String)rsmd.getColumnName(9));
            WanTest.assertEquals((String)"localhost", (String)hubRs.getString(9));
        }
    }

    public void testGatewayReceiversHNSWithInvalidProperty() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1,SG2,PQR");
        Connection con = WanTest.getConnection(info);
        try {
            con.createStatement().execute("CREATE GATEWAYRECEIVER ok (hostnameforsenders 'NIC1')");
            WanTest.fail("This test should have thrown exception");
        }
        catch (Exception e) {
            return;
        }
    }

    public void testGatewayReceivers() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1,SG2,PQR");
        Connection con = WanTest.getConnection(info);
        con.createStatement().execute("CREATE GATEWAYRECEIVER ok ( socketbuffersize 1000 bindaddress '127.0.0.1' maxtimebetweenpings 10000) server groups (sg1)");
        ResultSet hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
        ResultSetMetaData rsmd = hubRs.getMetaData();
        WanTest.assertEquals((int)9, (int)rsmd.getColumnCount());
        int runningPort = 0;
        while (hubRs.next()) {
            WanTest.assertEquals((String)"ID", (String)rsmd.getColumnName(1));
            WanTest.assertEquals((String)"RUNNING_PORT", (String)rsmd.getColumnName(2));
            WanTest.assertEquals((String)"START_PORT", (String)rsmd.getColumnName(3));
            WanTest.assertEquals((String)"END_PORT", (String)rsmd.getColumnName(4));
            WanTest.assertEquals((String)"SERVER_GROUPS", (String)rsmd.getColumnName(5));
            WanTest.assertEquals((String)"SOCKET_BUFFER_SIZE", (String)rsmd.getColumnName(6));
            WanTest.assertEquals((String)"MAX_TIME_BETWEEN_PINGS", (String)rsmd.getColumnName(7));
            WanTest.assertEquals((String)"BIND_ADDRESS", (String)rsmd.getColumnName(8));
            WanTest.assertEquals((String)"OK", (String)hubRs.getString(1));
            runningPort = hubRs.getInt(2);
            WanTest.assertTrue((String)("unexpected running port " + runningPort), (5000 <= runningPort && 5500 > runningPort ? 1 : 0) != 0);
            WanTest.assertEquals((int)5000, (int)hubRs.getInt(3));
            WanTest.assertEquals((int)5500, (int)hubRs.getInt(4));
            WanTest.assertEquals((String)"SG1", (String)hubRs.getString(5));
            WanTest.assertEquals((int)1000, (int)hubRs.getInt(6));
            WanTest.assertEquals((int)10000, (int)hubRs.getInt(7));
            WanTest.assertEquals((String)"127.0.0.1", (String)hubRs.getString(8));
        }
        hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS WHERE SERVER_GROUPS LIKE '%SG1%'");
        WanTest.assertEquals((int)9, (int)rsmd.getColumnCount());
        while (hubRs.next()) {
            WanTest.assertEquals((String)"SG1", (String)hubRs.getString(5));
        }
        con.createStatement().execute("DROP GATEWAYRECEIVER OK");
        hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
        rsmd = hubRs.getMetaData();
        while (hubRs.next()) {
            WanTest.fail("There should not be any row present in the SYS.GATEWAYRECEIVERS table");
        }
        con.createStatement().execute("CREATE GATEWAYRECEIVER R1 ( startport 11111 endport 11114 socketbuffersize 1000 bindaddress '0.0.0.0' maxtimebetweenpings 10000) server groups (sg1)");
        con.createStatement().execute("CREATE GATEWAYRECEIVER R2 ( startport 11111 endport 11114 socketbuffersize 1000 bindaddress '0.0.0.0' maxtimebetweenpings 10000) server groups (sg1)");
        con.createStatement().execute("CREATE GATEWAYRECEIVER R3 ( startport 11111 endport 11114 socketbuffersize 1000 bindaddress '0.0.0.0' maxtimebetweenpings 10000) server groups (sg1)");
        con.createStatement().execute("CREATE GATEWAYRECEIVER R4 ( startport 11111 endport 11114 socketbuffersize 1000 bindaddress '0.0.0.0' maxtimebetweenpings 10000) server groups (sg1)");
        hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
        rsmd = hubRs.getMetaData();
        while (hubRs.next()) {
            runningPort = hubRs.getInt(2);
            WanTest.assertTrue((String)Integer.toString(runningPort), (11111 <= runningPort && 11114 >= runningPort ? 1 : 0) != 0);
            WanTest.assertEquals((int)11111, (int)hubRs.getInt(3));
            WanTest.assertEquals((int)11114, (int)hubRs.getInt(4));
            WanTest.assertEquals((String)"SG1", (String)hubRs.getString(5));
            WanTest.assertEquals((int)1000, (int)hubRs.getInt(6));
            WanTest.assertEquals((int)10000, (int)hubRs.getInt(7));
            WanTest.assertEquals((String)"0.0.0.0", (String)hubRs.getString(8));
        }
        try {
            con.createStatement().execute("CREATE GATEWAYRECEIVER R4 ( startport 11111 endport 11114 socketbuffersize 1000 bindaddress '0.0.0.0' maxtimebetweenpings 10000) server groups (sg1)");
            WanTest.fail("Test was expected to throw BindException ");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                return;
            }
            WanTest.fail("Test was expected to throw SQLException ");
        }
        con.createStatement().execute("CREATE GATEWAYRECEIVER R5 ( startport 11111 endport 11115 socketbuffersize 1000 bindaddress '0.0.0.0' maxtimebetweenpings 10000) server groups (sg1)");
        for (GatewayReceiver rcvr : Misc.getGemFireCache().getGatewayReceivers()) {
            con.createStatement().execute("DROP GATEWAYRECEIVER " + rcvr.getId());
        }
        hubRs = con.createStatement().executeQuery("select * from SYS.GATEWAYRECEIVERS");
        rsmd = hubRs.getMetaData();
        while (hubRs.next()) {
            WanTest.fail("There should not be any row present in the SYS.GATEWAYRECEIVERS table");
        }
    }

    public void testBug45823() throws SQLException {
        block8: {
            Statement stmt;
            block7: {
                block6: {
                    Properties info = new Properties();
                    Connection conn = WanTest.getConnection(info);
                    stmt = conn.createStatement();
                    try {
                        stmt.execute("create gatewayreceiver mybad1 (startport -5 endport 5)");
                        WanTest.fail("CREATE GATEWAYRECEIVER should have failed with illegal numerical port value");
                    }
                    catch (SQLException sqle) {
                        if ("42X44".equals(sqle.getSQLState())) break block6;
                        throw sqle;
                    }
                }
                try {
                    stmt.execute("create gatewayreceiver mybad1 (startport 10 endport 5)");
                    WanTest.fail("CREATE GATEWAYRECEIVER should have failed with illegal port combination");
                }
                catch (SQLException sqle) {
                    if ("22008".equals(sqle.getSQLState())) break block7;
                    throw sqle;
                }
            }
            try {
                stmt.execute("create gatewayreceiver mybad1 (startport 10 endport 99999)");
                WanTest.fail("CREATE GATEWAYRECEIVER should have failed with illegal port combination");
            }
            catch (SQLException sqle) {
                if ("22008".equals(sqle.getSQLState())) break block8;
                throw sqle;
            }
        }
    }

    public void testBug45822() throws SQLException {
        block8: {
            Statement stmt;
            block7: {
                block6: {
                    Properties info = new Properties();
                    Connection conn = WanTest.getConnection(info);
                    stmt = conn.createStatement();
                    try {
                        stmt.execute("DROP ASYNCEVENTLISTENER NOSUCH1");
                        WanTest.fail("DROP ASYNCEVENTLISTENER NOSUCH1 should have failed");
                    }
                    catch (SQLException sqle) {
                        if ("42Y55".equals(sqle.getSQLState())) break block6;
                        throw sqle;
                    }
                }
                try {
                    stmt.execute("DROP GATEWAYRECEIVER NOSUCH1");
                    WanTest.fail("DROP GATEWAYRECEIVER NOSUCH1 should have failed");
                }
                catch (SQLException sqle) {
                    if ("42Y55".equals(sqle.getSQLState())) break block7;
                    throw sqle;
                }
            }
            try {
                stmt.execute("DROP GATEWAYSENDER NOSUCH1");
                WanTest.fail("DROP GATEWAYSENDER NOSUCH1 should have failed");
            }
            catch (SQLException sqle) {
                if ("42Y55".equals(sqle.getSQLState())) break block8;
                throw sqle;
            }
        }
    }

    public void testAlterTableWithAsyncEventListener() throws SQLException {
        this.getConnectionWithServerGroup();
        WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL)" + this.getSQLSuffixClause());
        WanTest.getConnection().createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER (myListener) ");
        AbstractRegion r = (AbstractRegion)Misc.getGemFireCache().getRegion("/APP/TESTTABLE");
        Assert.assertEquals((int)1, (int)r.getAsyncEventQueueIds().size());
        Assert.assertTrue((boolean)r.getAsyncEventQueueIds().contains("MYLISTENER"));
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET EVICTION MAXSIZE 10");
        Assert.assertEquals((int)1, (int)r.getAsyncEventQueueIds().size());
        Assert.assertTrue((boolean)r.getAsyncEventQueueIds().contains("MYLISTENER"));
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER () ");
        Assert.assertEquals((int)0, (int)r.getAsyncEventQueueIds().size());
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET EVICTION MAXSIZE 10");
        WanTest.getConnection().createStatement().execute("CREATE ASYNCEVENTLISTENER myListener2 ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER (myListener, myListener2) ");
        Assert.assertEquals((int)2, (int)r.getAsyncEventQueueIds().size());
        Assert.assertTrue((boolean)r.getAsyncEventQueueIds().contains("MYLISTENER"));
        Assert.assertTrue((boolean)r.getAsyncEventQueueIds().contains("MYLISTENER2"));
        ResultSet hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.SYSTABLES where tablename='TESTTABLE'");
        while (hubRs.next()) {
            Assert.assertEquals((String)"MYLISTENER,MYLISTENER2", (String)hubRs.getString(17));
        }
    }

    public void testAlterGatewaySendersAndAsyncEventListener() throws SQLException {
        this.getConnectionWithServerGroup();
        WanTest.getConnection().createStatement().execute("CREATE GATEWAYSENDER mySender ( remotedsid 2 socketbuffersize 1000 manualstart true  SOCKETREADTIMEOUT 1000 ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (sg1)");
        WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL) GATEWAYSENDER(mySender)" + this.getSQLSuffixClause());
        WanTest.getConnection().createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER (myListener) ");
        ResultSet hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.SYSTABLES where tablename='TESTTABLE'");
        while (hubRs.next()) {
            Assert.assertEquals((String)"MYLISTENER", (String)hubRs.getString(17));
            Assert.assertEquals((String)"MYSENDER", (String)hubRs.getString(19));
        }
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET GATEWAYSENDER () ");
        hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.SYSTABLES where tablename='TESTTABLE'");
        while (hubRs.next()) {
            Assert.assertEquals((String)"MYLISTENER", (String)hubRs.getString(17));
            Assert.assertEquals(null, (String)hubRs.getString(19));
        }
    }

    public void _testGatewayProceduresException() throws SQLException {
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            this.getConnectionWithServerGroup();
                            WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL) ASYNCEVENTLISTENER(myListener)");
                            WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET GATEWAYSENDER(mySender)");
                            try {
                                WanTest.getConnection().createStatement().execute("CALL SYS.START_GATEWAYSENDER('mySender')");
                                WanTest.fail();
                            }
                            catch (SQLException ex) {
                                if (ex.getSQLState().equals("X0Z23") && ex.getErrorCode() == 20000) break block11;
                                WanTest.fail();
                            }
                        }
                        try {
                            WanTest.getConnection().createStatement().execute("CALL SYS.STOP_GATEWAYSENDER('mySender')");
                            WanTest.fail();
                        }
                        catch (SQLException ex) {
                            if (ex.getSQLState().equals("X0Z23") && ex.getErrorCode() == 20000) break block12;
                            WanTest.fail();
                        }
                    }
                    try {
                        WanTest.getConnection().createStatement().execute("CALL SYS.START_ASYNC_EVENT_LISTENER('myListener')");
                        WanTest.fail();
                    }
                    catch (SQLException ex) {
                        if (ex.getSQLState().equals("X0Z23") && ex.getErrorCode() == 20000) break block13;
                        WanTest.fail();
                    }
                }
                try {
                    WanTest.getConnection().createStatement().execute("CALL SYS.STOP_ASYNC_EVENT_LISTENER('myListener')");
                    WanTest.fail();
                }
                catch (SQLException ex) {
                    if (ex.getSQLState().equals("X0Z23") && ex.getErrorCode() == 20000) break block14;
                    WanTest.fail();
                }
            }
            ResultSet hubRs = WanTest.getConnection().createStatement().executeQuery("select * from SYS.SYSTABLES where tablename='TESTTABLE'");
            while (hubRs.next()) {
                Assert.assertEquals((String)"MYLISTENER", (String)hubRs.getString(17));
                Assert.assertEquals((String)"MYSENDER", (String)hubRs.getString(19));
            }
            WanTest.getConnection().createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
            WanTest.getConnection().createStatement().execute("CALL SYS.START_ASYNC_EVENT_LISTENER('myListener')");
            WanTest.getConnection().createStatement().execute("CALL SYS.STOP_ASYNC_EVENT_LISTENER('myListener')");
            WanTest.getConnection().createStatement().execute("CREATE GATEWAYSENDER mySender ( remotedsid 2 socketbuffersize 1000 manualstart true  SOCKETREADTIMEOUT 1000 ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (sg1)");
            try {
                WanTest.getConnection().createStatement().execute("CALL SYS.START_GATEWAYSENDER('mySender')");
            }
            catch (SQLException e) {
                if (e.getCause() instanceof GatewaySenderConfigurationException) break block15;
                WanTest.fail();
            }
        }
        WanTest.getConnection().createStatement().execute("CALL SYS.STOP_GATEWAYSENDER('mySender')");
    }

    public void testNoLocalGatewayAsyncEventListenerWarning() throws SQLException {
        this.getConnectionWithServerGroup();
        WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL) GATEWAYSENDER(mySender)" + this.getSQLSuffixClause());
        WanTest.getConnection().createStatement().execute("DROP TABLE TESTTABLE");
        this.waitTillAllClear();
        WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL) ASYNCEVENTLISTENER(myListener)" + this.getSQLSuffixClause());
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER(myListener)");
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET GATEWAYSENDER(mySender)");
        WanTest.getConnection().createStatement().execute("DROP TABLE TESTTABLE");
        this.waitTillAllClear();
        WanTest.getConnection().createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
        WanTest.getConnection().createStatement().execute("CREATE GATEWAYSENDER mySender ( remotedsid 2 socketbuffersize 1000 manualstart true  SOCKETREADTIMEOUT 1000 ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (sg1)");
        WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL) GATEWAYSENDER(mySender)" + this.getSQLSuffixClause());
        WanTest.getConnection().createStatement().execute("DROP TABLE TESTTABLE");
        this.waitTillAllClear();
        WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL) ASYNCEVENTLISTENER(myListener)" + this.getSQLSuffixClause());
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER(myListener)");
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET GATEWAYSENDER(mySender)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAttachDetachAsyncEventListener() throws Exception {
        this.getConnectionWithServerGroup();
        Statement derbyStmt = null;
        Statement stmt = null;
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute("CREATE TABLE TESTTABLE (ID INT NOT NULL, NAME VARCHAR(30))");
            WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL, NAME VARCHAR(30))");
            stmt = WanTest.getConnection().createStatement();
            stmt.execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
            stmt.execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER(myListener)");
            stmt.execute("INSERT INTO TESTTABLE VALUES(1, 'name1')");
            stmt.execute("INSERT INTO TESTTABLE VALUES(2, 'name2')");
            final AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue("MYLISTENER");
            DistributedTestBase.WaitCriterion wc = new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    int sz = asyncQueue.getSender().getQueue().size();
                    if (sz == 0) {
                        return true;
                    }
                    TestUtil.getLogger().info((Object)("Got size as " + sz + " for 'MYLISTENER'"));
                    return false;
                }

                public String description() {
                    return "waiting for queue for 'MYLISTENER' to drain";
                }
            };
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)30000L, (long)500L, (boolean)true);
            WanTest.validateResults(derbyStmt, stmt, "select * from testtable", false);
            stmt.execute("CREATE ASYNCEVENTLISTENER anotherListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
            stmt.execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER (anotherListener) ");
            stmt.execute("INSERT INTO TESTTABLE VALUES(3, 'name3')");
            stmt.execute("INSERT INTO TESTTABLE VALUES(4, 'name4')");
            final AsyncEventQueueImpl anotherAsyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue("ANOTHERLISTENER");
            DistributedTestBase.WaitCriterion anotherWC = new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    int sz = anotherAsyncQueue.getSender().getQueue().size();
                    if (sz == 0) {
                        return true;
                    }
                    TestUtil.getLogger().info((Object)("Got size as " + sz + " for 'ANOTHERLISTENER'"));
                    return false;
                }

                public String description() {
                    return "waiting for queue for 'ANOTHERLISTENER' to drain";
                }
            };
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)anotherWC, (long)30000L, (long)500L, (boolean)true);
            WanTest.validateResults(derbyStmt, stmt, "select * from testtable", false);
            stmt.execute("DROP ASYNCEVENTLISTENER myListener");
            stmt.execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER () ");
            stmt.execute("DROP ASYNCEVENTLISTENER anotherListener");
            stmt.execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
            stmt.execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER (myListener) ");
            stmt.execute("INSERT INTO TESTTABLE VALUES(5, 'name5')");
            stmt.execute("INSERT INTO TESTTABLE VALUES(6, 'name6')");
            final AsyncEventQueueImpl thirdAsyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue("MYLISTENER");
            DistributedTestBase.WaitCriterion thirdWC = new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    int sz = thirdAsyncQueue.getSender().getQueue().size();
                    if (sz == 0) {
                        return true;
                    }
                    TestUtil.getLogger().info((Object)("Got size as " + sz + " for 'MYLISTENER'"));
                    return false;
                }

                public String description() {
                    return "waiting for queue for 'MYLISTENER' to drain";
                }
            };
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)thirdWC, (long)30000L, (long)500L, (boolean)true);
            WanTest.validateResults(derbyStmt, stmt, "select * from testtable", false);
        }
        finally {
            try {
                if (derbyStmt != null) {
                    derbyStmt.execute("DROP TABLE TESTTABLE");
                }
                if (stmt != null) {
                    stmt.execute("DROP TABLE TESTTABLE");
                    this.waitTillAllClear();
                    stmt.execute("DROP ASYNCEVENTLISTENER myListener");
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStartStopAsyncEventListener() throws Exception {
        this.getConnectionWithServerGroup();
        Statement derbyStmt = null;
        Statement stmt = null;
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute("CREATE TABLE TESTTABLE (ID INT NOT NULL, NAME VARCHAR(30))");
            stmt = WanTest.getConnection().createStatement();
            stmt.execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
            stmt.execute("CREATE TABLE TESTTABLE (ID INT NOT NULL, NAME VARCHAR(30)) ASYNCEVENTLISTENER(myListener)");
            ResultSet hubRs = stmt.executeQuery("select * from SYS.SYSTABLES where tablename='TESTTABLE'");
            while (hubRs.next()) {
                Assert.assertEquals((String)"MYLISTENER", (String)hubRs.getString(17));
            }
            stmt.execute("INSERT INTO TESTTABLE VALUES(1, 'name1')");
            stmt.execute("INSERT INTO TESTTABLE VALUES(2, 'name2')");
            final AsyncEventQueueImpl asyncQueue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue("MYLISTENER");
            DistributedTestBase.WaitCriterion wc = new DistributedTestBase.WaitCriterion(){

                public boolean done() {
                    int sz = asyncQueue.getSender().getQueue().size();
                    if (sz == 0) {
                        return true;
                    }
                    TestUtil.getLogger().info((Object)("Got size as " + sz + " for 'MYLISTENER'"));
                    return false;
                }

                public String description() {
                    return "waiting for queue for 'MYLISTENER' to drain";
                }
            };
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)30000L, (long)500L, (boolean)true);
            WanTest.validateResults(derbyStmt, stmt, "select * from testtable", false);
            stmt.execute("CALL SYS.STOP_ASYNC_EVENT_LISTENER('myListener')");
            stmt.execute("CALL SYS.START_ASYNC_EVENT_LISTENER('myListener')");
            stmt.execute("INSERT INTO TESTTABLE VALUES(3, 'name3')");
            stmt.execute("INSERT INTO TESTTABLE VALUES(4, 'name4')");
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)30000L, (long)500L, (boolean)true);
            WanTest.validateResults(derbyStmt, stmt, "select * from testtable", false);
            stmt.execute("CALL SYS.STOP_ASYNC_EVENT_LISTENER('MYLISTENER')");
            stmt.execute("CALL SYS.START_ASYNC_EVENT_LISTENER('MYLISTENER')");
            stmt.execute("INSERT INTO TESTTABLE VALUES(5, 'name5')");
            stmt.execute("INSERT INTO TESTTABLE VALUES(6, 'name6')");
            DistributedTestBase.waitForCriterion((DistributedTestBase.WaitCriterion)wc, (long)30000L, (long)500L, (boolean)true);
            WanTest.validateResults(derbyStmt, stmt, "select * from testtable", false);
            stmt.execute("CALL SYS.STOP_ASYNC_EVENT_LISTENER('myListener')");
        }
        finally {
            try {
                if (derbyStmt != null) {
                    derbyStmt.execute("DROP TABLE TESTTABLE");
                }
                if (stmt != null) {
                    stmt.execute("DROP TABLE TESTTABLE");
                    this.waitTillAllClear();
                    stmt.execute("DROP ASYNCEVENTLISTENER myListener");
                }
            }
            catch (Exception exception) {}
        }
    }

    public void testDropGatewaySenderAndDropDiskStore() throws SQLException {
        block12: {
            block11: {
                block10: {
                    this.getConnectionWithServerGroup();
                    char fileSeparator = System.getProperty("file.separator").charAt(0);
                    GemFireCacheImpl cache = Misc.getGemFireCache();
                    if (cache.findDiskStore("TESTDROPGATEWAYSENDERANDDROPDISKSTORE") == null) {
                        String path = "." + fileSeparator + "test_dir";
                        File file = new File(path);
                        if (!file.mkdirs() && !file.isDirectory()) {
                            throw new DiskAccessException("Could not create directory for  default disk store : " + file.getAbsolutePath(), (Region)null);
                        }
                        try {
                            Connection conn1 = TestUtil.getConnection();
                            Statement stmt1 = conn1.createStatement();
                            stmt1.execute("Create DiskStore testDropGatewaySenderAndDropDiskStore'" + path + "'");
                            conn1.close();
                        }
                        catch (SQLException e) {
                            throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
                        }
                    }
                    WanTest.getConnection().createStatement().execute("CREATE ASYNCEVENTLISTENER myListener ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)");
                    WanTest.getConnection().createStatement().execute("CREATE TABLE TESTTABLE (ID INT NOT NULL)  ASYNCEVENTLISTENER (myListener) PERSISTENT 'TESTDROPGATEWAYSENDERANDDROPDISKSTORE'" + this.getSQLSuffixClause());
                    try {
                        WanTest.getConnection().createStatement().execute("drop asynceventlistener mylistener");
                        WanTest.fail();
                    }
                    catch (SQLException e) {
                        if ("X0Y25".equals(e.getSQLState())) break block10;
                        throw e;
                    }
                }
                try {
                    WanTest.getConnection().createStatement().execute("drop gatewaysender mylistener");
                    WanTest.fail();
                }
                catch (SQLException e) {
                    if ("42Y55".equals(e.getSQLState())) break block11;
                    throw e;
                }
            }
            try {
                WanTest.getConnection().createStatement().execute("drop diskstore TESTDROPGATEWAYSENDERANDDROPDISKSTORE");
                WanTest.fail();
            }
            catch (SQLException e) {
                if ("X0Y25".equals(e.getSQLState())) break block12;
                throw e;
            }
        }
        WanTest.getConnection().createStatement().execute("ALTER TABLE TESTTABLE SET ASYNCEVENTLISTENER () ");
        WanTest.getConnection().createStatement().execute("drop asynceventlistener mylistener");
        WanTest.getConnection().createStatement().execute("drop table testtable");
        this.waitTillAllClear();
        WanTest.getConnection().createStatement().execute("drop diskstore testDropGatewaySenderAndDropDiskStore");
    }

    public void testBug46127CreateDup() throws Exception {
        Connection conn;
        block5: {
            block4: {
                this.getConnectionWithServerGroup();
                conn = WanTest.getConnection();
                conn.createStatement().execute("CREATE ASYNCEVENTLISTENER dup1 ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false  ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (sg1)");
                try {
                    conn.createStatement().execute("CREATE ASYNCEVENTLISTENER dup1 ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false  ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (sg1)");
                    WanTest.fail("CREATE ASYNCEVENTLISTENER dup1 should have failed");
                }
                catch (SQLException sqle) {
                    if ("X0Z22".equals(sqle.getSQLState())) break block4;
                    throw sqle;
                }
            }
            conn.createStatement().execute("DROP ASYNCEVENTLISTENER dup1");
            conn.createStatement().execute("CREATE GATEWAYRECEIVER dup3 ");
            try {
                conn.createStatement().execute("CREATE GATEWAYRECEIVER dup3 ");
                WanTest.fail("CREATE GATEWAYRECEIVER dup3 should have failed");
            }
            catch (SQLException sqle) {
                if ("X0Y68".equals(sqle.getSQLState())) break block5;
                throw sqle;
            }
        }
        conn.createStatement().execute("DROP GATEWAYRECEIVER dup3");
    }

    public void testCreateDropGWR_Bug46171() throws Exception {
        Object[][] Script_CreateDropGWR = new Object[][]{{"create gatewayreceiver x1 (bindaddress 'bleh')", "22008"}, {"drop gatewayreceiver x1", "42Y55"}, {"create gatewayreceiver x1 (bindaddress 'localhost')", null}, {"create gatewayreceiver x1 (bindaddress 'localhost')", "X0Y68"}, {"drop gatewayreceiver x1", null}, {"create gatewayreceiver x1 (bindaddress 'localhost')", null}};
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        JDBC.SQLUnitTestHelper(stmt, Script_CreateDropGWR);
    }

    public void testDropDiskStoreWithAsyncEventListener_46845() throws SQLException {
        Connection conn;
        block2: {
            this.getConnectionWithServerGroup();
            conn = WanTest.getConnection();
            conn.createStatement().execute("CREATE DISKSTORE TEST46845");
            conn.createStatement().execute("CREATE ASYNCEVENTLISTENER Test46845_Async ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false  ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100 DISKSTORENAME TEST46845) server groups (sg1)");
            try {
                conn.createStatement().execute("DROP DISKSTORE TEST46845");
                WanTest.fail("DROP DISKSTORE should have failed");
            }
            catch (SQLException sqle) {
                if ("X0Y25".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
        conn.createStatement().execute("DROP ASYNCEVENTLISTENER IF EXISTS TEST46845_ASYNC");
        conn.createStatement().execute("DROP DISKSTORE TEST46845");
    }

    private Connection getConnectionWithServerGroup() throws SQLException {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = WanTest.getConnection(info);
        return conn;
    }

    public void waitTillAllClear() {
    }

    public static class TestGatewayEventListenerNotify
    implements AsyncEventListener {
        private volatile Event[] eventsProcessed = null;
        private volatile int eventsExpected = -1;
        private volatile boolean allowRemoval = true;
        private int currNum = 0;
        private int numCallbacks = 0;
        private boolean encounteredException = false;

        Event[] getEventsCollected() {
            return this.eventsProcessed;
        }

        int getNumCallbacks() {
            return this.numCallbacks;
        }

        boolean exceptionOccurred() {
            return this.encounteredException;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public boolean processEvents(List<Event> events) {
            try {
                ++this.numCallbacks;
                if (this.eventsExpected == -1) {
                    Event[] newarray = new Event[(this.eventsProcessed != null ? this.eventsProcessed.length : 0) + events.size()];
                    int k = 0;
                    if (this.eventsProcessed != null) {
                        for (Event ev : this.eventsProcessed) {
                            newarray[k++] = ev;
                        }
                    }
                    for (Event ev : events) {
                        newarray[k++] = ev;
                    }
                    this.eventsProcessed = newarray;
                    Class<TestGatewayEventListenerNotify> clazz = TestGatewayEventListenerNotify.class;
                    // MONITORENTER : com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListenerNotify.class
                    TestGatewayEventListenerNotify.class.notify();
                    // MONITOREXIT : clazz
                } else {
                    for (Event event : events) {
                        this.eventsProcessed[this.currNum++] = event;
                    }
                    if (this.currNum == this.eventsExpected) {
                        Class<TestGatewayEventListenerNotify> clazz = TestGatewayEventListenerNotify.class;
                        // MONITORENTER : com.pivotal.gemfirexd.jdbc.WanTest$TestGatewayEventListenerNotify.class
                        TestGatewayEventListenerNotify.class.notify();
                        // MONITOREXIT : clazz
                    }
                }
                try {
                    Thread.sleep(500L);
                    return this.allowRemoval;
                }
                catch (InterruptedException itr) {
                    // empty catch block
                }
                return this.allowRemoval;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.encounteredException = true;
                return this.allowRemoval;
            }
        }

        public void close() {
        }

        public void start() {
        }

        public void init(String initParams) {
            StringTokenizer tokenizer = new StringTokenizer(initParams, ",");
            if (tokenizer.hasMoreTokens()) {
                boolean bl = this.allowRemoval = !"false".equalsIgnoreCase(tokenizer.nextToken());
            }
            if (tokenizer.hasMoreTokens()) {
                this.eventsExpected = Integer.parseInt(tokenizer.nextToken());
            }
            if (this.eventsExpected >= 0) {
                this.eventsProcessed = new Event[this.eventsExpected];
            }
        }
    }

    public static class TestGatewayEventListener
    implements AsyncEventListener {
        public String test;

        public boolean processEvents(List<Event> events) {
            return false;
        }

        public void close() {
        }

        public void start() {
        }

        public void init(String initParamStr) {
            this.test = initParamStr;
        }
    }
}

