/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.ToursDBUtil;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.log4j.Logger;

public class ViewTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ViewTest.class));
    }

    public ViewTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testCreateView() throws SQLException {
        Connection conn = ViewTest.getConnection();
        ToursDBUtil.createAndLoadToursDB(conn);
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE VIEW ese AS SELECT city_name, country, language FROM cities WHERE language LIKE '%ese'");
        ResultSet rs = s.executeQuery("SELECT * FROM ese");
        ViewTest.assertEquals((int)7, (int)JDBC.assertDrainResults(rs));
        conn.close();
    }

    public void testDropTableWithView_43720() throws SQLException {
        Statement stmt;
        block2: {
            Connection conn = ViewTest.getConnection();
            stmt = conn.createStatement();
            stmt.execute("create table temp (x int) partition by column (x)");
            ViewTest.assertEquals((int)3, (int)stmt.executeUpdate("insert into temp values (1), (2), (3)"));
            stmt.execute("create view temp2 as select * from temp where x > 2");
            ViewTest.assertEquals((int)1, (int)stmt.executeUpdate("insert into temp values (4)"));
            try {
                stmt.execute("drop table temp");
                ViewTest.fail("expected an exception");
            }
            catch (SQLException sqle) {
                if ("X0Y23".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
        ViewTest.assertEquals((int)1, (int)stmt.executeUpdate("insert into temp values (5)"));
    }

    public void testJoins() throws Exception {
        int i;
        Connection conn = ViewTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1 (i1 int, j1 int)");
        stmt.execute("create table t2 (i2 int, j2 int)");
        stmt.execute("create table t3 (a3 int, b3 int)");
        stmt.execute("create table t4 (a4 int, b4 int)");
        stmt.execute("create view V1 as select distinct T1.i1 i, T2.j2 j from T1, T2 where T1.i1 = T2.i2");
        stmt.execute("create view V2 as select distinct T3.a3 a, T4.b4 b from T3, T4 where T3.a3 = T4.a4");
        stmt.execute("create view V3 as select T1.i1 i, T2.j2 j from T1, T2 where T1.i1 = T2.i2");
        stmt.execute("create view V4 as select T3.a3 a, T4.b4 b from T3, T4 where T3.a3 = T4.a4");
        for (int i2 = 1; i2 <= 5; ++i2) {
            stmt.execute("insert into t1 values (" + i2 + ", " + i2 + ')');
            stmt.execute("insert into t2 values (" + i2 + ", " + i2 + ')');
            if (i2 % 2 != 1) continue;
            stmt.execute("insert into t3 values (" + i2 + ", " + i2 + ')');
            stmt.execute("insert into t4 values (" + i2 + ", " + i2 + ')');
        }
        ResultSet rs = stmt.executeQuery("select * from V3 where V3.i in (1,2,3,4,5) order by V3.i");
        for (i = 1; i <= 5; ++i) {
            ViewTest.assertTrue((boolean)rs.next());
            ViewTest.assertEquals((int)i, (int)rs.getInt(1));
            ViewTest.assertEquals((int)i, (int)rs.getInt(2));
        }
        ViewTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from V3, V4 where V3.j = V4.b and V3.i in (1,2,3,4,5) order by V3.i");
        for (i = 1; i <= 5; i += 2) {
            ViewTest.assertTrue((boolean)rs.next());
            ViewTest.assertEquals((int)i, (int)rs.getInt(1));
            ViewTest.assertEquals((int)i, (int)rs.getInt(2));
            ViewTest.assertEquals((int)i, (int)rs.getInt(3));
            ViewTest.assertEquals((int)i, (int)rs.getInt(4));
        }
        ViewTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select * from V1, V2 where V1.j = V2.b and V1.i in (1,2,3,4,5) order by V1.i");
        for (i = 1; i <= 5; i += 2) {
            ViewTest.assertTrue((boolean)rs.next());
            ViewTest.assertEquals((int)i, (int)rs.getInt(1));
            ViewTest.assertEquals((int)i, (int)rs.getInt(2));
            ViewTest.assertEquals((int)i, (int)rs.getInt(3));
            ViewTest.assertEquals((int)i, (int)rs.getInt(4));
        }
        ViewTest.assertFalse((boolean)rs.next());
        String baseDir = ViewTest.getResourcesDir() + "/lib/views/";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{baseDir + "create-objects.sql", baseDir + "program-unit-xwalk-load.sql", baseDir + "selected-programs-load.sql"}, (boolean)false, (Logger)ViewTest.getLogger(), null, null, (boolean)false);
        rs = stmt.executeQuery("select count(*) from ERASV2.VW_APPLICANT_PROGRAM");
        ViewTest.assertTrue((boolean)rs.next());
        ViewTest.assertEquals((int)967, (int)rs.getInt(1));
        ViewTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("SELECT * FROM ERASV2.VW_APPLICANT_PROGRAM WHERE UNIT_ID = '014035214850'");
        for (int i3 = 1; i3 <= 967; ++i3) {
            ViewTest.assertTrue((boolean)rs.next());
            ViewTest.assertEquals((String)"014035214850", (String)rs.getString(2));
            ViewTest.assertEquals((int)22882, (int)rs.getInt(3));
        }
        ViewTest.assertFalse((boolean)rs.next());
    }

    public void testColocatedJoins_44616() throws SQLException {
        DMLQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = ViewTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table p_test1 (idval int, dataval1 varchar(20)) partition by column (idval)");
        stmt.execute("create table p_test2 (idval int, dataval2 varchar(20)) partition by column (idval) colocate with (p_test1)");
        stmt.execute("create table p_test3 (idval int, dataval3 varchar(20)) partition by column (idval) colocate with (p_test1)");
        stmt.execute("create view p_view1_2 (idval, dataval1, dataval2) as select t1.idval, t1.dataval1, t2.dataval2 from p_test1 t1, p_test2 t2 where t1.idval = t2.idval");
        for (int id = 1; id <= 20; ++id) {
            stmt.execute("insert into p_test1 values (" + id + ", 'd1_" + id + "')");
            stmt.execute("insert into p_test2 values (" + id + ", 'd2_" + id + "')");
            stmt.execute("insert into p_test3 values (" + id + ", 'd3_" + id + "')");
        }
        ResultSet rs = stmt.executeQuery("select v1.idval, v1.dataval1, v1.dataval2, t3.dataval3 from p_view1_2 v1, p_test3 t3 where v1.idval = t3.idval order by v1.idval");
        for (int id = 1; id <= 20; ++id) {
            ViewTest.assertTrue((boolean)rs.next());
            ViewTest.assertEquals((int)id, (int)rs.getInt(1));
        }
        ViewTest.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug_50173() throws SQLException {
        try {
            int i;
            System.setProperty(GfxdConstants.GFXD_DISABLE_COLUMN_ELIMINATION, "true");
            Connection conn = ViewTest.getConnection();
            Statement st = conn.createStatement();
            st.execute("create schema trade");
            st.execute("create table trade.A ( subscriber_id varchar(64) not null, cell_id varchar(30), time_from timestamp not null, did int) replicate");
            st.execute("create table trade.B ( cell_id varchar(8) not null, valid_until timestamp null, nl varchar(30) null ) replicate");
            st.execute("create unique index trade.idx_a_pk on trade.a ( subscriber_id, cell_id, time_from )");
            st.execute("create index trade.idx_a_subscriber_id on trade.a ( subscriber_id )");
            st.execute("create index trade.idx_a_cell_id on trade.a ( cell_id )");
            st.execute("create unique index trade.idx_b_cell_id on trade.b ( cell_id, valid_until )");
            String[] securities = new String[]{"IBM", "MOT", "INTC", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2", "IBM2", "MOT2", "INTC2", "TEK2", "AMD2", "CSCO2", "DELL2", "HP2", "SMALL12", "SMALL22", "IBM3", "MOT3", "INTC3", "TEK3", "AMD3", "CSCO3", "DELL3", "HP3", "SMALL13", "SMALL23"};
            PreparedStatement psInsert = conn.prepareStatement("insert into trade.A values (?, ?, ?, ?)");
            for (i = 0; i < 30; ++i) {
                psInsert.setString(1, securities[i % 30]);
                psInsert.setString(2, securities[i % 30]);
                psInsert.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                psInsert.setInt(4, i + 1);
                psInsert.executeUpdate();
            }
            psInsert = conn.prepareStatement("insert into trade.B values (?, ?, ?)");
            for (i = 0; i < 30; ++i) {
                psInsert.setString(1, securities[i % 30]);
                psInsert.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                psInsert.setString(3, securities[i % 30]);
                psInsert.executeUpdate();
            }
            String query = "select innerQuery.nl from (select b.valid_until, b.nl from trade.A a LEFT JOIN trade.B b ON a.cell_id=b.cell_id) innerQuery group by innerQuery.nl; ";
            PreparedStatement pst = conn.prepareStatement(query);
            ResultSet r = pst.executeQuery();
            int count = 0;
            while (r.next()) {
                ++count;
            }
            ViewTest.assertEquals((int)30, (int)count);
            r.close();
        }
        finally {
            System.clearProperty(GfxdConstants.GFXD_DISABLE_COLUMN_ELIMINATION);
        }
    }
}

