/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.Region;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class UniqueKeyIndexTest
extends JdbcTestBase {
    public UniqueKeyIndexTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(UniqueKeyIndexTest.class));
    }

    public String getOverflowSuffix() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDMLOnUniqeKeyIndex() throws SQLException {
        Connection conn = UniqueKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 int NOT NULL, c3 char(20) NOT NULL, UNIQUE (c2,c3)) " + this.getOverflowSuffix());
        s.execute("insert into t1 (c1, c2, c3) values (10, 10, 'XXXX')");
        s.execute("insert into t1 (c1, c2, c3) values (20, 20, 'YYYY')");
        s.execute("insert into t1 (c1, c2, c3) values (30, 30, 'ZZZZ')");
        String[][] expectedRows = new String[][]{{"10", "10", "XXXX"}};
        ResultSet rs = s.executeQuery("select * from t1 where t1.c1=10");
        JDBC.assertFullResultSet(rs, expectedRows);
        try {
            Monitor.getStream().println("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            s.execute("insert into t1 (c1, c2, c3) values (40, 10, 'XXXX')");
        }
        catch (SQLException e) {
            return;
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
        }
        throw new SQLException("Duplicate key Exception should be thrown!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUniqueKeyMultiColumn() throws SQLException {
        Connection conn = UniqueKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 int NOT NULL, c3 char(20) NOT NULL, UNIQUE (c2,c3))" + this.getOverflowSuffix());
        s.execute("insert into t1 (c1, c2, c3) values (10, 10, 'XXXX')");
        s.execute("insert into t1 (c1, c2, c3) values (20, 20, 'YYYY')");
        s.execute("insert into t1 (c1, c2, c3) values (30, 30, 'ZZZZ')");
        s.execute("insert into t1 (c1, c2, c3) values (40, 10, 'ZZZZ')");
        String[][] expectedRows = new String[][]{{"10", "10", "XXXX"}};
        ResultSet rs = s.executeQuery("select * from t1 where t1.c1=10");
        JDBC.assertFullResultSet(rs, expectedRows);
        try {
            Monitor.getStream().println("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            s.execute("update t1 set t1.c3='XXXX' where t1.c1=40");
        }
        catch (SQLException e) {
            if (e.toString().toLowerCase().contains("duplicate")) {
                return;
            }
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
        }
        throw new SQLException("Duplicate key Exception should be thrown!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFor39436() throws SQLException {
        Connection conn = UniqueKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 int NOT NULL, c3 char(20) NOT NULL, c4 int , UNIQUE (c2,c3))" + this.getOverflowSuffix());
        s.execute("create index idx1 on t1(c2, c3)");
        s.execute("create unique index idx2 on t1(c2, c3)");
        s.execute("create index idx3 on t1(c3, c4)");
        s.execute("create unique index idx4 on t1(c3, c4)");
        s.execute("insert into t1 (c1, c2, c3, c4) values (10, 10, 'XXXX', 10)");
        s.execute("insert into t1 (c1, c2, c3, c4) values (20, 20, 'YYYY', 20)");
        s.execute("insert into t1 (c1, c2, c3, c4) values (30, 30, 'ZZZZ', 30)");
        s.execute("insert into t1 (c1, c2, c3, c4) values (40, 30, 'XXXX', 40)");
        String[][] expectedRows = new String[][]{{"10", "10", "XXXX", "10"}};
        ResultSet rs = s.executeQuery("select * from t1 where t1.c1=10");
        JDBC.assertFullResultSet(rs, expectedRows);
        s.execute("update t1 set t1.c4=70 where t1.c1=40");
        boolean gotExpectedExcepiton = false;
        try {
            Monitor.getStream().println("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            s.execute("update t1 set t1.c3='ZZZZ' where t1.c1=40");
        }
        catch (SQLException e) {
            if (!"23505".equals(e.getSQLState())) {
                throw e;
            }
            gotExpectedExcepiton = true;
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
        }
        if (!gotExpectedExcepiton) {
            throw new SQLException("Test failed");
        }
        gotExpectedExcepiton = false;
        try {
            Monitor.getStream().println("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            s.execute("update t1 set t1.c2=10 where t1.c1=40");
        }
        catch (SQLException e) {
            if (!"23505".equals(e.getSQLState())) {
                throw e;
            }
            gotExpectedExcepiton = true;
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
        }
        if (!gotExpectedExcepiton) {
            throw new SQLException("Test failed");
        }
        gotExpectedExcepiton = false;
        try {
            Monitor.getStream().println("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            s.execute("update t1 set t1.c3='ZZZZ' where t1.c1=40 and t1.c4=70");
        }
        catch (SQLException e) {
            if (!"23505".equals(e.getSQLState())) {
                throw e;
            }
            gotExpectedExcepiton = true;
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
        }
        if (!gotExpectedExcepiton) {
            throw new SQLException("Test failed");
        }
        conn = UniqueKeyIndexTest.getConnection();
        s = conn.createStatement();
        s.execute("update t1 set t1.c3='XXXX' where t1.c1=40 and t1.c4=70");
        rs = s.executeQuery("select c1, c3 from t1 where c1=40");
        UniqueKeyIndexTest.assertTrue((boolean)rs.next());
        UniqueKeyIndexTest.assertEquals((String)"XXXX", (String)rs.getString("c3").trim());
        UniqueKeyIndexTest.assertEquals((int)40, (int)rs.getInt(1));
        UniqueKeyIndexTest.assertFalse((boolean)rs.next());
        s.execute("delete from t1 where c3='XXXX'");
        rs = s.executeQuery("select c1, c3 from t1 where c1=40");
        UniqueKeyIndexTest.assertFalse((boolean)rs.next());
    }

    public void testMiscGetGemFireKey() throws SQLException, StandardException {
        Connection conn = UniqueKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TestTable (c1 int primary key, c2 int NOT NULL, c3 char(20) NOT NULL, c4 int , UNIQUE (c2,c3))" + this.getOverflowSuffix());
        s.execute("insert into TestTable (c1, c2, c3, c4) values (10, 10, 'XXXX', 10)");
        s.execute("insert into TestTable (c1, c2, c3, c4) values (20, 20, 'YYYY', 20)");
        s.execute("insert into TestTable (c1, c2, c3, c4) values (30, 30, 'ZZZZ', 30)");
        s.execute("insert into TestTable (c1, c2, c3, c4) values (40, 30, 'XXXX', 40)");
        Region tableRegion = Misc.getRegionForTable((String)(UniqueKeyIndexTest.getCurrentDefaultSchemaName() + ".TESTTABLE"), (boolean)true);
        RegionKey key = UniqueKeyIndexTest.getGemFireKey(10, tableRegion);
        Object value = tableRegion.get((Object)key);
        UniqueKeyIndexTest.assertNotNull((String)"Value cannot be null", (Object)value);
        int i = 20;
        key = UniqueKeyIndexTest.getGemFireKey(i, tableRegion);
        value = tableRegion.get((Object)key);
        UniqueKeyIndexTest.assertNotNull((String)"Value cannot be null", (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFor39605() throws SQLException {
        Connection conn = UniqueKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100),tid int, primary key (cid))" + this.getOverflowSuffix());
        s.execute("create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int,constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete RESTRICT, constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0),constraint availloan_ck check (loanlimit>=availloan and availloan >=0))" + this.getOverflowSuffix());
        s.execute("INSERT INTO trade.customers VALUES (10, 'name10', CURRENT_DATE, 'address10',10)");
        s.execute("INSERT INTO trade.customers VALUES (20, 'name20', CURRENT_DATE, 'address20',20)");
        s.execute("INSERT INTO trade.customers VALUES (30, 'name30', CURRENT_DATE, 'address30',30)");
        s.execute("INSERT INTO trade.customers VALUES (40, 'name40', CURRENT_DATE, 'address40',40)");
        s.execute("INSERT INTO trade.customers VALUES (50, 'name50', CURRENT_DATE, 'address50',50)");
        s.execute("INSERT INTO trade.networth  VALUES (10, 2310.00, 1234.00, 56,   45.00, 10)");
        s.execute("INSERT INTO trade.networth  VALUES (20, 2310.00, 1234.00, 456,  245.00, 10)");
        s.execute("INSERT INTO trade.networth  VALUES (30, 2310.00, 1234.00, 3456, 1245.00, 10)");
        s.execute("INSERT INTO trade.networth  VALUES (40, 2310.00, 1234.00, 3456, 1245.00, 10)");
        s.execute("INSERT INTO trade.networth  VALUES (50, 2310.00, 1234.00, 3456, 1245.00, 10)");
        boolean gotExpectedException = false;
        try {
            Monitor.getStream().println("<ExpectedException action=add>java.sql.SQLIntegrityConstraintViolationException</ExpectedException>");
            Monitor.getStream().flush();
            s.executeUpdate("UPDATE trade.networth set loanlimit=1000 where securities>1000 and tid=10");
        }
        catch (Exception e) {
            gotExpectedException = true;
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>java.sql.SQLIntegrityConstraintViolationException</ExpectedException>");
            Monitor.getStream().flush();
        }
        if (!gotExpectedException) {
            throw new SQLException("Test failed");
        }
        ResultSet rs = s.executeQuery("select * from trade.networth where loanlimit=1000");
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertTrue((count >= 0 && count < 3 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40040() throws Exception {
        Connection conn = null;
        Statement s = null;
        try {
            conn = UniqueKeyIndexTest.getConnection();
            s = conn.createStatement();
            s.execute("create table Child ( id2 int primary key, sector_id2 int unique not null, subsector_id2 int ) replicate" + this.getOverflowSuffix());
            s.execute("insert into Child values (1,1,1)");
            Monitor.getStream().println("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            for (int i = 0; i < 10; ++i) {
                try {
                    s.execute("insert into Child values (2,1,1)");
                    UniqueKeyIndexTest.fail("Insert should not have successed  as unique key violation would occur");
                    continue;
                }
                catch (SQLException sqle) {
                    UniqueKeyIndexTest.assertEquals((String)sqle.toString(), (String)"23505", (String)sqle.getSQLState());
                }
            }
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            conn = UniqueKeyIndexTest.getConnection();
            s = conn.createStatement();
            s.execute("Drop table Child ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40342_1() throws Exception {
        Connection conn = null;
        Statement s = null;
        try {
            conn = UniqueKeyIndexTest.getConnection();
            s = conn.createStatement();
            s.execute("create table master ( id int primary key, dummy int ) " + this.getOverflowSuffix());
            s.execute("create table Child ( id2 int primary key, sector_id2 int , subsector_id2 int, constraint cust_newt_fk foreign key (sector_id2) references master (id)  ) partition by column(id2) " + this.getOverflowSuffix());
            PreparedStatement psInsertMaster = conn.prepareStatement("insert into Master values (?,?)");
            PreparedStatement psInsertChild = conn.prepareStatement("insert into Child values (?,?,?)");
            for (int i = 0; i < 10; ++i) {
                psInsertMaster.setInt(1, i);
                psInsertMaster.setInt(2, i);
                psInsertMaster.execute();
                psInsertChild.setInt(1, i);
                psInsertChild.setInt(2, i);
                psInsertChild.setInt(3, 1);
                psInsertChild.execute();
            }
            String sql = "select id2 from Child where id2 IN (?,?,?) and id2 < ?";
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setInt(1, 3);
            ps.setInt(2, 4);
            ps.setInt(3, 5);
            ps.setInt(4, 4);
            ResultSet rs = ps.executeQuery();
            int size = 0;
            while (rs.next()) {
                ++size;
            }
            UniqueKeyIndexTest.assertEquals((int)1, (int)size);
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            conn = UniqueKeyIndexTest.getConnection();
            s = conn.createStatement();
            s.execute("Drop table Child ");
            s.execute("Drop table Master ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _testBug40427() throws Exception {
        Connection conn = null;
        Statement s = null;
        try {
            int i;
            conn = UniqueKeyIndexTest.getConnection();
            s = conn.createStatement();
            s.execute("create table master ( id int primary key, dummy int ) " + this.getOverflowSuffix());
            s.execute("create table Child ( id2 int , sector_id2 int , subsector_id2 int, constraint cust_newt_fk foreign key (sector_id2) references master (id))   " + this.getOverflowSuffix());
            PreparedStatement psInsertMaster = conn.prepareStatement("insert into Master values (?,?)");
            PreparedStatement psInsertChild = conn.prepareStatement("insert into Child values (?,?,?)");
            for (i = 0; i < 16; ++i) {
                psInsertMaster.setInt(1, i);
                psInsertMaster.setInt(2, i);
                psInsertMaster.execute();
            }
            for (i = 0; i < 9; ++i) {
                psInsertChild.setInt(1, i);
                psInsertChild.setInt(2, i + 1);
                psInsertChild.setInt(3, i + 1);
                psInsertChild.execute();
            }
            for (i = 9; i < 14; ++i) {
                psInsertChild.setInt(1, i);
                psInsertChild.setNull(2, 4);
                psInsertChild.setInt(3, i + 1);
                psInsertChild.execute();
            }
            String sql = "select id2,sector_id2 from Child where id2 =?  and id2  < ?";
            PreparedStatement ps = conn.prepareStatement(sql);
            ps.setInt(1, 9);
            ps.setInt(2, 10);
            ResultSet rs = ps.executeQuery();
            int size = 0;
            while (rs.next()) {
                UniqueKeyIndexTest.assertEquals((int)rs.getInt(1), (int)9);
                UniqueKeyIndexTest.assertEquals((int)rs.getInt(2), (int)0);
                ++size;
            }
            UniqueKeyIndexTest.assertEquals((int)1, (int)size);
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
            conn = UniqueKeyIndexTest.getConnection();
            s = conn.createStatement();
            s.execute("Drop table Child ");
        }
    }
}

