/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.execute.InternalRegionFunctionContext;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMBucketRowLocationThinDiskLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMBucketRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMBucketRowLocationThinDiskRegionEntryOffHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMBucketRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinDiskLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinDiskRegionEntryOffHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VMLocalRowLocationThinRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinDiskLRURegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinDiskRegionEntryHeap;
import com.pivotal.gemfirexd.internal.engine.store.entry.VersionedBucketRowLocationThinDiskRegionEntryOffHeap;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TableDiskPersistenceTest
extends JdbcTestBase {
    public TableDiskPersistenceTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(TableDiskPersistenceTest.class));
    }

    public void testSingleColumnPKTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("create table t1 (c1 int primary key, c2 int, c3 varchar(20) ) " + this.getSuffix());
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c2.add(15);
            c2.add(25);
            c3.add("XXXX");
            c3.add("YYYY");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            c1.add(10);
            c1.add(20);
            c2.add(15);
            c2.add(25);
            c3.add("XXXX");
            c3.add("YYYY");
            rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException sQLException) {}
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMultiColumnPKTable() throws SQLException {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2)) " + this.getSuffix());
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertNull((Object)krc.getKeyBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getValueBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            for (DiskStoreImpl dsi : Misc.getGemFireCache().listDiskStores()) {
                dsi.waitForBackgroundTasks();
            }
            rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertNull((Object)krc.getKeyBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getValueBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            s = conn.createStatement();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertNull((Object)krc.getKeyBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getValueBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            s.executeUpdate("update t1 set c3 = 'AAAA' where c1 = 30 ");
            rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertNull((Object)krc.getKeyBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getValueBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            for (DiskStoreImpl dsi : Misc.getGemFireCache().listDiskStores()) {
                dsi.waitForBackgroundTasks();
            }
            rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertNull((Object)krc.getKeyBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getValueBytes());
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            s = conn.createStatement();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("AAAA");
            rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            try {
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException sQLException) {}
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForPersistentNonRedundantPRTable() throws Exception {
        Class<?> expectedEntryClass = this.getExpectedEntryClass();
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  " + this.getSuffix() + " synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            Iterator itr = rgn.keys().iterator();
            boolean enteredLoop = false;
            while (itr.hasNext()) {
                CompactCompositeRegionKey krc = (CompactCompositeRegionKey)itr.next();
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(expectedEntryClass, re.getClass());
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(expectedEntryClass, re.getClass());
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    private Class<?> getExpectedEntryClass() {
        boolean persistent = false;
        if (this.getSuffix().toLowerCase().contains("persistent")) {
            persistent = true;
        }
        Class expectedEntryClass = this.getSuffix().trim().toLowerCase().indexOf("offheap") == -1 ? (persistent ? VersionedBucketRowLocationThinDiskRegionEntryHeap.class : VMBucketRowLocationThinDiskRegionEntryHeap.class) : (persistent ? VersionedBucketRowLocationThinDiskRegionEntryOffHeap.class : VMBucketRowLocationThinDiskRegionEntryOffHeap.class);
        return expectedEntryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForPersistentRedundantPRTable() throws Exception {
        Class<?> expectedEntryClass = this.getExpectedEntryClass();
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  " + this.getSuffix() + " synchronous redundancy 1 ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            Iterator itr = rgn.keys().iterator();
            boolean enteredLoop = false;
            while (itr.hasNext()) {
                CompactCompositeRegionKey krc = (CompactCompositeRegionKey)itr.next();
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), expectedEntryClass);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), expectedEntryClass);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForPersistentOverflowPRTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  eviction by lrucount 1 evictaction overflow" + this.getSuffix() + " synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VersionedBucketRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VersionedBucketRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForPersistentOverflowRedundantPRTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2)) redundancy 1 eviction by lrucount 1 evictaction overflow" + this.getSuffix() + " synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VersionedBucketRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VersionedBucketRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForOverflowPRTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  eviction by lrucount 1 evictaction overflow  synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VMBucketRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            Iterator itr = rgn.keys().iterator();
            TableDiskPersistenceTest.assertFalse((boolean)itr.hasNext());
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForOverflowRedundantPRTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  eviction by lrucount 1 evictaction overflow  synchronous redundancy 1");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VMBucketRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            Iterator itr = rgn.keys().iterator();
            TableDiskPersistenceTest.assertFalse((boolean)itr.hasNext());
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForDefaultPRTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2)) ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(VMBucketRowLocationThinRegionEntryHeap.class, re.getClass());
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            Iterator itr = rgn.keys().iterator();
            TableDiskPersistenceTest.assertFalse((boolean)itr.hasNext());
            enteredLoop = false;
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForPRRedundantTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  redundancy 1  ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, (LocalRegion)rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VMBucketRowLocationThinRegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            Iterator itr = rgn.keys().iterator();
            TableDiskPersistenceTest.assertFalse((boolean)itr.hasNext());
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForPersistentOverflowReplicateTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  eviction by lrucount 1 evictaction overflow replicate  " + this.getSuffix() + " synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VMLocalRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VMLocalRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForPersistentReplicateTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        Class expectedEntryClass = null;
        expectedEntryClass = this.getSuffix().trim().toLowerCase().indexOf("offheap") == -1 ? VMLocalRowLocationThinDiskRegionEntryHeap.class : VMLocalRowLocationThinDiskRegionEntryOffHeap.class;
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))   replicate  " + this.getSuffix() + " synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), expectedEntryClass);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), expectedEntryClass);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForOverflowReplicateTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2)) replicate  eviction by lrucount 1 evictaction overflow synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VMLocalRowLocationThinDiskLRURegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            Iterator itr = rgn.keys().iterator();
            TableDiskPersistenceTest.assertFalse((boolean)itr.hasNext());
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRegionEntryTypeForReplicateTable() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))   replicate  ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            boolean enteredLoop = false;
            String path = Misc.getRegionPath((String)schema, (String)"T1", null);
            LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            for (CompactCompositeRegionKey krc : rgn.keys()) {
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() == null || krc.getValueBytes() == null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertTrue((krc.getKeyBytes() != null || krc.getValueBytes() != null ? 1 : 0) != 0);
                TableDiskPersistenceTest.assertNotNull((Object)krc.getTableInfo());
            }
            Iterator entryItr = rgn.getDataView().getLocalEntriesIterator((InternalRegionFunctionContext)null, true, false, true, rgn);
            while (entryItr.hasNext()) {
                RowLocation re = (RowLocation)entryItr.next();
                TableDiskPersistenceTest.assertEquals(re.getClass(), VMLocalRowLocationThinRegionEntryHeap.class);
                enteredLoop = true;
            }
            TableDiskPersistenceTest.assertTrue((boolean)enteredLoop);
            enteredLoop = false;
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            Iterator itr = rgn.keys().iterator();
            TableDiskPersistenceTest.assertFalse((boolean)itr.hasNext());
        }
        finally {
            try {
                s = conn.createStatement();
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException ignore) {
                ignore.printStackTrace();
            }
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistentTableDropBehaviour() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        TestUtil.getCurrentDefaultSchemaName();
        try {
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  " + this.getSuffix() + " synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            HashSet<Integer> c1 = new HashSet<Integer>();
            HashSet<Integer> c2 = new HashSet<Integer>();
            HashSet<String> c3 = new HashSet<String>();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            ResultSet rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
            s.execute("drop table t1");
            this.waitTillAllClear();
            conn.close();
            TableDiskPersistenceTest.shutDown();
            conn = TableDiskPersistenceTest.getConnection();
            s = conn.createStatement();
            TestUtil.getCurrentDefaultSchemaName();
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))   " + this.getSuffix() + " synchronous ");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            c1 = new HashSet();
            c2 = new HashSet();
            c3 = new HashSet();
            c1.add(10);
            c1.add(20);
            c1.add(30);
            c2.add(15);
            c2.add(25);
            c2.add(35);
            c3.add("XXXX");
            c3.add("YYYY");
            c3.add("ZZZZ");
            rs = s.executeQuery("select c1, c2, c3 from t1 ");
            while (rs.next()) {
                TableDiskPersistenceTest.assertTrue((boolean)c1.remove(rs.getInt(1)));
                TableDiskPersistenceTest.assertTrue((boolean)c2.remove(rs.getInt(2)));
                TableDiskPersistenceTest.assertTrue((boolean)c3.remove(rs.getString(3)));
            }
            TableDiskPersistenceTest.assertFalse((boolean)rs.next());
            TableDiskPersistenceTest.assertTrue((c1.isEmpty() && c2.isEmpty() && c3.isEmpty() ? 1 : 0) != 0);
        }
        finally {
            try {
                s.execute("drop table t1");
                this.waitTillAllClear();
            }
            catch (SQLException sQLException) {}
            conn.close();
        }
    }

    public void testSystableOffHeapAttribute() throws Exception {
        Connection conn = TableDiskPersistenceTest.getConnection();
        Statement s = conn.createStatement();
        TestUtil.getCurrentDefaultSchemaName();
        s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2))  " + this.getSuffix() + " synchronous ");
        ResultSet rs = s.executeQuery("select * from sys.systables where TABLENAME = 'T1'");
        TableDiskPersistenceTest.assertTrue((boolean)rs.next());
        System.out.println(rs.getString("DISKATTRS"));
        if (this.getSuffix().toLowerCase().indexOf("offheap") == -1) {
            TableDiskPersistenceTest.assertFalse((boolean)rs.getBoolean("OFFHEAPENABLED"));
        } else {
            TableDiskPersistenceTest.assertTrue((boolean)rs.getBoolean("OFFHEAPENABLED"));
        }
    }

    public String getSuffix() {
        return " persistent ";
    }

    public void waitTillAllClear() {
    }
}

