/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.client.am.Connection;
import com.pivotal.gemfirexd.internal.client.am.SingleHopPreparedStatement;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;

public class SingleHopTest
extends JdbcTestBase {
    public SingleHopTest(String name) {
        super(name);
    }

    public void test0MaxConnectionsAndSetSchema() throws Exception {
        System.setProperty("gemfirexd.client.single-hop-max-connections", "100");
        Connection.initialize();
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        conn.createStatement().execute("create schema trade");
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        SingleHopTest.assertEquals((int)100, (int)Connection.SINGLE_HOP_MAX_CONN_PER_SERVER);
        Statement s = connShop.createStatement();
        s.execute("set current schema trade");
        s.execute("create table example(c1 int not null, c2 int not null primary key) partition by primary key");
        s.execute("insert into trade.example values(1, 2), (2, 3)");
        PreparedStatement ps = connShop.prepareStatement("select * from example where c2 = ?");
        ps.setInt(1, 2);
        ps.execute();
        ResultSet rs = ps.getResultSet();
        rs.next();
        SingleHopTest.assertEquals((int)2, (int)rs.getInt(2));
        System.clearProperty("gemfirexd.client.single-hop-max-connections");
        Connection.initialize();
    }

    public void testexcnIdDebug() throws Exception {
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        conn.createStatement().execute("create schema trade");
        Properties props = new Properties();
        java.sql.Connection tc = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        tc.setTransactionIsolation(2);
        Statement s = tc.createStatement();
        s.execute("set current schema trade");
        s.execute("create table example(c1 int not null, c2 int not null primary key) partition by primary key");
        s.execute("insert into trade.example values(1, 2), (2, 3)");
        PreparedStatement ps = tc.prepareStatement("select * from example where c2 = ?");
        ps.setInt(1, 2);
        ps.execute();
        ResultSet rs = ps.getResultSet();
        rs.next();
        SingleHopTest.assertEquals((int)2, (int)rs.getInt(2));
        System.clearProperty("gemfirexd.client.single-hop-max-connections");
        s.execute("select * from example");
        s.execute("update example set c1 = 100 where c2 = 200");
        tc.commit();
    }

    public void testDebug() throws Exception {
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        System.setProperty("gemfirexd.debug.true", "TraceSingleHop,QueryDistribution");
        DMLQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        Statement s = conn.createStatement();
        String ddl = "create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by column (sec_id, price)  REDUNDANCY 2";
        s.execute(ddl);
        ddl = "create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 10000)  REDUNDANCY 2";
        s.execute(ddl);
        s.execute("insert into trade.securities values (1204, 'lo', 33.9, 'hkse', 53)");
        s.execute("insert into trade.portfolio values (508, 1204, 1080, 1080, 36612.00000000000000000000, 100)");
        String selStmnt = "select * from trade.securities where sec_id = ?";
        PreparedStatement ps2 = connShop.prepareStatement(selStmnt);
        ps2.setInt(1, 1204);
        ResultSet rs = ps2.executeQuery();
        SingleHopTest.assertTrue((boolean)rs.next());
        BigDecimal price = rs.getBigDecimal(3);
        SingleHopTest.assertFalse((boolean)rs.next());
        String updStmnt2 = "update trade.portfolio set subTotal = ? * qty  where cid = ? and sid = ?  and tid= ?";
        PreparedStatement ps = connShop.prepareStatement(updStmnt2);
        ps.setBigDecimal(1, price);
        ps.setInt(2, 508);
        ps.setInt(3, 1204);
        ps.setInt(4, 53);
        ps.executeUpdate();
        System.out.println(ps.executeUpdate());
        System.out.println(ps.executeUpdate());
        System.out.println(ps.executeUpdate());
        System.out.println(ps.executeUpdate());
    }

    public void testHoppForTheSelectCaseGiven() throws Exception {
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        System.setProperty("gemfirexd.debug.true", "TraceSingleHop,QueryDistribution");
        DMLQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table t1 ( id int , name varchar(10), type int, address varchar(50), Primary Key (id, name ))";
        String selstmnt = "select type, id, name from t1 where id IN (?,?,?) AND name IN (?,?,?)";
        s.execute(ddl);
        connShop.prepareStatement(selstmnt);
    }

    public void testRoutingObjectCompatibility_VarChar_maxwidth() throws Exception {
        if (isTransactional) {
            return;
        }
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID varchar(10) NOT NULL, SECONDID varchar(40) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('zero', 'zero', 'zero'), ('one1', 'one1', 'one'), ('two2', 'two2', 'two'), ('tree', 'tree', 'three'), ('two2two2tw', 'two2two2two2', 'two2two2tw')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "two2two2two2");
        psimple.execute();
        ResultSet rs = psimple.getResultSet();
        SingleHopTest.assertFalse((boolean)rs.next());
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "two2two2two2");
        pshop.execute();
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        String selstmnt_const = "select * from EMP.PARTITIONTESTTABLE where id = 'two2two2two2'";
        psimple = conn.prepareStatement(selstmnt_const);
        psimple.execute();
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt_const);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.execute();
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
    }

    public void testRoutingObjectCompatibility_Integer() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setInt(1, 2);
        psimple.execute();
        psimple.close();
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 2);
        pshop.execute();
        ResultSet rs = pshop.getResultSet();
        while (rs.next()) {
        }
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY PRIMARY KEY";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setInt(1, 2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)2, shopset.iterator().next());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setInt(1, 2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)2, shopset.iterator().next());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID int, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 4);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)0, shopset.iterator().next());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ? and secondid = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.setInt(2, 2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 4);
        pshop.setInt(2, 2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)0, shopset.iterator().next());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setInt(1, 2);
        psimple.setInt(2, 2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 2);
        pshop.setInt(2, 2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)2, shopset.iterator().next());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID int, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY RANGE (ID) (values between 0 and 1, values between 1 and 2, values between 2 and 3)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setInt(1, 2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setInt(1, 90);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 90);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 4);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID int, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY LIST (ID) ( VALUES (0, 10), VALUES (20, 70), VALUES (1, 100) )";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setInt(1, 2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setInt(1, 90);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 90);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 4);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID int, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY (ID + 4)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setInt(1, 2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
        rkeys.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
    }

    public void testRoutingObjectCompatibility_LongInt() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID bigint NOT NULL, SECONDID bigint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setLong(1, 2L);
        psimple.execute();
        psimple.close();
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setLong(1, 2L);
        pshop.execute();
        ResultSet rs = pshop.getResultSet();
        while (rs.next()) {
        }
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID bigint NOT NULL, SECONDID bigint not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setLong(1, 2L);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setLong(1, 2L);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)2, shopset.iterator().next());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID bigint, SECONDID bigint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, -5);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)0, shopset.iterator().next());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ? and secondid = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.setLong(2, 2L);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, -5);
        pshop.setLong(2, 2L);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)0, shopset.iterator().next());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setLong(1, 2L);
        psimple.setLong(2, 2L);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setLong(1, 2L);
        pshop.setLong(2, 2L);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)2, shopset.iterator().next());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID bigint, SECONDID bigint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY RANGE (ID) (values between 0 and 1, values between 1 and 2, values between 2 and 3)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setLong(1, 2L);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setLong(1, 2L);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setLong(1, 90L);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setLong(1, 90L);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, -5);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID bigint, SECONDID bigint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY LIST (ID) ( VALUES (0, 10), VALUES (20, 70), VALUES (1, 100) )";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setLong(1, 2L);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setLong(1, 2L);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setLong(1, 90L);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setLong(1, 90L);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, -5);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID bigint, SECONDID bigint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY (ID + 4)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setLong(1, 2L);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setLong(1, 2L);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
        rkeys.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
    }

    public void testRoutingObjectCompatibility_SmallInt() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID smallint NOT NULL, SECONDID smallint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setShort(1, (short)10);
        psimple.execute();
        psimple.close();
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setShort(1, (short)10);
        pshop.execute();
        ResultSet rs = pshop.getResultSet();
        while (rs.next()) {
        }
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID smallint NOT NULL, SECONDID smallint not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setShort(1, (short)2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setShort(1, (short)2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID smallint, SECONDID smallint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 5);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)0, shopset.iterator().next());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ? and secondid = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.setShort(2, (short)2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 5);
        pshop.setShort(2, (short)2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.assertEquals((Object)0, shopset.iterator().next());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setShort(1, (short)2);
        psimple.setShort(2, (short)2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setShort(1, (short)2);
        pshop.setShort(2, (short)2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID smallint, SECONDID smallint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY RANGE (ID) (values between 0 and 1, values between 1 and 2, values between 2 and 3)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setShort(1, (short)2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setShort(1, (short)2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setShort(1, (short)90);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setShort(1, (short)90);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 5);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID smallint, SECONDID smallint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY LIST (ID) ( VALUES (0, 10), VALUES (20, 70), VALUES (1, 100) )";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setShort(1, (short)2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setShort(1, (short)2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setShort(1, (short)90);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setShort(1, (short)90);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 5);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID smallint, SECONDID smallint not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY (ID + 4)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setShort(1, (short)2);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setShort(1, (short)2);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
        rkeys.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
    }

    public void testRoutingObjectCompatibility_Decimal() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID decimal(20, 10) NOT NULL, SECONDID decimal(20, 10) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setBigDecimal(1, BigDecimal.valueOf(2.22));
        psimple.execute();
        psimple.close();
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setBigDecimal(1, BigDecimal.valueOf(2.22));
        pshop.execute();
        ResultSet rs = pshop.getResultSet();
        while (rs.next()) {
        }
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID decimal(20, 10) NOT NULL, SECONDID decimal(20, 10) not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setBigDecimal(1, BigDecimal.valueOf(2.22));
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setBigDecimal(1, BigDecimal.valueOf(2.22));
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID decimal(20, 10), SECONDID decimal(20, 10) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 3);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ? and secondid = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.setBigDecimal(2, BigDecimal.valueOf(2.22));
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 3);
        pshop.setBigDecimal(2, BigDecimal.valueOf(2.22));
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setBigDecimal(1, BigDecimal.valueOf(2.22));
        psimple.setBigDecimal(2, BigDecimal.valueOf(2.22));
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setBigDecimal(1, BigDecimal.valueOf(2.22));
        pshop.setBigDecimal(2, BigDecimal.valueOf(2.22));
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID decimal(20, 10), SECONDID decimal(20, 10), THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY RANGE (ID) (values between 0 and 1, values between 1 and 2, values between 2 and 3)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setBigDecimal(1, BigDecimal.valueOf(2L));
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setBigDecimal(1, BigDecimal.valueOf(2L));
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setBigDecimal(1, BigDecimal.valueOf(9.99));
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setBigDecimal(1, BigDecimal.valueOf(9.99));
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 3);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID decimal(20, 10), SECONDID decimal(20, 10) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY LIST (ID) ( VALUES (0, 10), VALUES (20, 70), VALUES (1, 100) )";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setBigDecimal(1, BigDecimal.valueOf(2L));
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setBigDecimal(1, BigDecimal.valueOf(2L));
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setBigDecimal(1, BigDecimal.valueOf(9L));
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setBigDecimal(1, BigDecimal.valueOf(9L));
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 3);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID decimal(20, 10), SECONDID decimal(20, 10) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY (ID + 4)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setBigDecimal(1, BigDecimal.valueOf(2L));
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setBigDecimal(1, BigDecimal.valueOf(2L));
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
        rkeys.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
    }

    public void testRoutingObjectCompatibility_Double() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID double NOT NULL, SECONDID double not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setDouble(1, 2.0);
        psimple.execute();
        psimple.close();
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setDouble(1, 2.0);
        pshop.execute();
        ResultSet rs = pshop.getResultSet();
        while (rs.next()) {
        }
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID double NOT NULL, SECONDID double not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setDouble(1, 2.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setDouble(1, 2.0);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID double, SECONDID double not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 8);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ? and secondid = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.setDouble(2, 2.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 8);
        pshop.setDouble(2, 2.0);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setDouble(1, 2.0);
        psimple.setDouble(2, 2.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setDouble(1, 2.0);
        pshop.setDouble(2, 2.0);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID double, SECONDID double, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY RANGE (ID) (values between 0 and 1, values between 1 and 2, values between 2 and 3)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setDouble(1, 2.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setDouble(1, 2.0);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setDouble(1, 100.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setDouble(1, 100.0);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 8);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID double, SECONDID double not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY LIST (ID) ( VALUES (0, 10), VALUES (20, 70), VALUES (1, 100) )";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setDouble(1, 2.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setDouble(1, 2.0);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setDouble(1, 9.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setDouble(1, 9.0);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 8);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID double, SECONDID double not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY (ID + 4)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setDouble(1, 2.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setDouble(1, 2.0);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
        rkeys.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
    }

    public void testRoutingObjectCompatibility_Real() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID real NOT NULL, SECONDID real not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setFloat(1, Float.valueOf("2.22").floatValue());
        psimple.execute();
        psimple.close();
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setFloat(1, Float.valueOf("2.22").floatValue());
        pshop.execute();
        ResultSet rs = pshop.getResultSet();
        while (rs.next()) {
        }
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID real NOT NULL, SECONDID real not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setDouble(1, 2.0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setFloat(1, Float.valueOf("2.22").floatValue());
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID real, SECONDID real not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0.0, 0.0, 'zero'), (1.11, 1.11, 'one'), (2.22, 2.22, 'two'), (3.333, 3.333, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 7);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ? and secondid = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.setFloat(2, Float.valueOf("2.22").floatValue());
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 7);
        pshop.setFloat(2, Float.valueOf("2.22").floatValue());
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setFloat(1, Float.valueOf("2.22").floatValue());
        psimple.setFloat(2, Float.valueOf("2.22").floatValue());
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setFloat(1, Float.valueOf("2.22").floatValue());
        pshop.setFloat(2, Float.valueOf("2.22").floatValue());
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID real, SECONDID real, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY RANGE (ID) (values between 0 and 1, values between 1 and 2, values between 2 and 3)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setFloat(1, Float.valueOf(2.0f).floatValue());
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setFloat(1, Float.valueOf(2.0f).floatValue());
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setFloat(1, Float.valueOf(200.0f).floatValue());
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setFloat(1, Float.valueOf(200.0f).floatValue());
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 7);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID real, SECONDID real not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY LIST (ID) ( VALUES (0, 10), VALUES (20, 70), VALUES (1, 100) )";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setFloat(1, Float.valueOf(2.0f).floatValue());
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setFloat(1, Float.valueOf(2.0f).floatValue());
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setFloat(1, Float.valueOf(200.0f).floatValue());
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setFloat(1, Float.valueOf(200.0f).floatValue());
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 7);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID real, SECONDID real not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY (ID + 4)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values (0, 0, 'zero'), (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setFloat(1, Float.valueOf(2.0f).floatValue());
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setFloat(1, Float.valueOf(2.0f).floatValue());
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
        rkeys.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
    }

    public void testRoutingObjectCompatibility_Char() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID char(4) NOT NULL, SECONDID char(4) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('zero', 'zero', 'zero'), ('one1', 'one1', 'one'), ('two2', 'two2', 'two'), ('tree', 'tree', 'three')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "two2");
        psimple.execute();
        psimple.close();
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "two2");
        pshop.execute();
        ResultSet rs = pshop.getResultSet();
        while (rs.next()) {
        }
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID char(4) NOT NULL, SECONDID char(4) not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('zero', 'zero', 'zero'), ('one1', 'one1', 'one'), ('two2', 'two2', 'two'), ('tree', 'tree', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "two2");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "two2");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID char(4), SECONDID char(4) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('zero', 'zero', 'zero'), ('one1', 'one1', 'one'), ('two2', 'two2', 'two'), ('tree', 'tree', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 1);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ? and secondid = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.setString(2, "two2");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 1);
        pshop.setString(2, "two2");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setString(1, "two2");
        psimple.setString(2, "two2");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "two2");
        pshop.setString(2, "two2");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID char(2), SECONDID char(2), THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY RANGE (ID) (values between 'AA' and 'BB', values between 'BB' and 'CC', values between 'CC' and 'DD')";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('AA', 'AA', 'zero'), ('BB', 'BB', 'one'), ('CC', 'CC', 'two'), ('DD', 'DD', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "BB");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "BB");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setString(1, "FF");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "FF");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 1);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID char(2), SECONDID char(2) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY LIST (ID) ( VALUES ('AA', 'aa'), VALUES ('BB', 'bb'), VALUES ('CC', 'cc') )";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('AA', 'AA', 'zero'), ('BB', 'BB', 'one'), ('CC', 'CC', 'two'), ('DD', 'DD', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "BB");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "BB");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setString(1, "FF");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "FF");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 1);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID char(2), SECONDID char(2) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY (trim(ID))";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('AA', 'AA', 'zero'), ('BB', 'BB', 'one'), ('CC', 'CC', 'two'), ('DD', 'DD', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "FF");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "FF");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
        rkeys.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
    }

    public void testRoutingObjectCompatibility_VarChar() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        Statement s = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID varchar(10) NOT NULL, SECONDID varchar(40) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('zero', 'zero', 'zero'), ('one1', 'one1', 'one'), ('two2', 'two2', 'two'), ('tree', 'tree', 'three')");
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "two2");
        psimple.execute();
        psimple.close();
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "two2");
        pshop.execute();
        ResultSet rs = pshop.getResultSet();
        while (rs.next()) {
        }
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID varchar(40) NOT NULL, SECONDID varchar(40) not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('zero', 'zero', 'zero'), ('one1', 'one1', 'one'), ('two2', 'two2', 'two'), ('tree', 'tree', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "two2");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "two2");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID varchar(10), SECONDID varchar(10) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('zero', 'zero', 'zero'), ('one1', 'one1', 'one'), ('two2', 'two2', 'two'), ('tree', 'tree', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 12);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ? and secondid = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setNull(1, 0);
        psimple.setString(2, "two2");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 12);
        pshop.setString(2, "two2");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setString(1, "two2");
        psimple.setString(2, "two2");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "two2");
        pshop.setString(2, "two2");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID char(2), SECONDID char(2), THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY RANGE (ID) (values between 'AA' and 'BB', values between 'BB' and 'CC', values between 'CC' and 'DD')";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('AA', 'AA', 'zero'), ('BB', 'BB', 'one'), ('CC', 'CC', 'two'), ('DD', 'DD', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "BB");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "BB");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setString(1, "FF");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "FF");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 12);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID varchar(20), SECONDID varchar(20) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY LIST (ID) ( VALUES ('AA', 'aa'), VALUES ('BB', 'bb'), VALUES ('CC', 'cc') )";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('AA', 'AA', 'zero'), ('BB', 'BB', 'one'), ('CC', 'CC', 'two'), ('DD', 'DD', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "BB");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "BB");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setString(1, "FF");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "FF");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        psimple.setNull(1, 0);
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setNull(1, 12);
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)1, (int)shopset.size());
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
        rkeys.clear();
        shopset.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
        ddl = "create table EMP.PARTITIONTESTTABLE (ID varchar(20), SECONDID varchar(20) not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID)) PARTITION BY (trim(lower(ID)))";
        s.execute(ddl);
        s.execute("insert into EMP.PARTITIONTESTTABLE values ('AA', 'AA', 'zero'), ('BB', 'BB', 'one'), ('CC', 'CC', 'two'), ('DD', 'DD', 'three')");
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        psimple = conn.prepareStatement(selstmnt);
        psimple.setString(1, "FF");
        psimple.execute();
        rs = psimple.getResultSet();
        while (rs.next()) {
        }
        rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "FF");
        pshop.execute();
        rs = pshop.getResultSet();
        while (rs.next()) {
        }
        shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
        rkeys.clear();
        s.execute("drop table EMP.PARTITIONTESTTABLE");
    }

    public static void compareSetEqulas(Set<Object> rkeys, Set<Object> shopset, boolean anyorder) {
        if (rkeys == null) {
            SingleHopTest.assertNull(shopset);
            return;
        }
        SingleHopTest.assertNotNull(shopset);
        SingleHopTest.assertEquals((int)rkeys.size(), (int)shopset.size());
        if (!anyorder) {
            for (int i = 0; i < shopset.size(); ++i) {
                SingleHopTest.assertEquals((Object)rkeys.toArray()[i], (Object)shopset.toArray()[i]);
                System.out.println(shopset.toArray()[i]);
            }
        } else {
            for (Object rk : rkeys) {
                SingleHopTest.assertTrue((boolean)shopset.contains(rk));
            }
        }
    }

    public void testUndoableSingleHopCases() throws Exception {
        if (isTransactional) {
            return;
        }
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID int not null, PRIMARY KEY (SECONDID)) PARTITION BY COLUMN (ID)";
        PreparedStatement ps = connShop.prepareStatement(ddl);
        ps.execute();
        Set rset = ((SingleHopPreparedStatement)ps).getRoutingObjectSet();
        SingleHopTest.assertNull((Object)rset);
        String insertSQL = "insert into EMP.PARTITIONTESTTABLE values (?, ?, ?)";
        ps = connShop.prepareStatement(insertSQL);
        for (int i = 0; i < 3; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.setInt(3, i);
            int cnt = ps.executeUpdate();
            SingleHopTest.assertEquals((int)1, (int)cnt);
        }
        Statement s = connShop.createStatement();
        s.execute("select * from EMP.PARTITIONTESTTABLE");
        ResultSet rs = s.getResultSet();
        while (rs.next()) {
            System.out.println(rs.getInt(1) + ", " + rs.getInt(2) + ", " + rs.getInt(3));
        }
        rset = ((SingleHopPreparedStatement)ps).getRoutingObjectSet();
        SingleHopTest.assertNull((Object)rset);
        String selstmnt = "select * from EMP.PARTITIONTESTTABLE where id = ?";
        PreparedStatement pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 2);
        pshop.execute();
        rset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertNotNull((Object)rset);
        ((SingleHopPreparedStatement)pshop).setRoutingObjectSetToNull();
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id IN (2, ?, ?)";
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 0);
        pshop.setInt(2, 10);
        pshop.execute();
        rset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertNotNull((Object)rset);
        ((SingleHopPreparedStatement)pshop).setRoutingObjectSetToNull();
        rs = pshop.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        SingleHopTest.assertEquals((int)2, (int)cnt);
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id > ? and id < ?";
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 0);
        pshop.setInt(2, 2);
        pshop.execute();
        rset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)rset.size());
        rs = pshop.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        SingleHopTest.assertEquals((int)1, (int)cnt);
        selstmnt = "select * from EMP.PARTITIONTESTTABLE where id > ? or id = ?";
        pshop = connShop.prepareStatement(selstmnt);
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setInt(1, 1);
        pshop.setInt(2, 0);
        pshop.execute();
        rset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)rset.size());
        rs = pshop.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        SingleHopTest.assertEquals((int)2, (int)cnt);
    }

    public void testBug47520() throws Exception {
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        SingleHopTest.setupConnection(props1);
        java.sql.Connection conn = TestUtil.getConnection(props1);
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        Statement st = connShop.createStatement();
        ResultSet rs = null;
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        st.execute("create table trade.securities(sid int not null, symbol varchar(10), exchange varchar(10), constraint sec_pk primary key (sid), constraint sec_uq unique (symbol, exchange)) partition by primary key");
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companyname char(10), tid int, constraint comp_pk primary key (symbol, exchange), constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict) partition by column (companyname)");
        st.execute("insert into trade.securities values (1, 'zv0', 'tse')");
        st.execute("insert into trade.securities values (2, 'cv1', 'fse')");
        st.execute("create index indexcompaniestid on trade.companies (tid)");
        st.execute("insert into trade.companies values ('zv0', 'tse', 'abc', 1)");
        st.execute("insert into trade.companies values ('cv1', 'fse', 'def', 1)");
        PreparedStatement ps = conn.prepareStatement("select * from trade.companies where companyname = ? and tid = ?");
        ps.setString(1, "abc");
        ps.setInt(2, 1);
        rs = ps.executeQuery();
        SingleHopTest.assertTrue((boolean)rs.next());
        SingleHopTest.assertEquals((String)"zv0", (String)rs.getString(1));
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        PreparedStatement pshop = connShop.prepareStatement("select * from trade.companies where companyname = ? and tid = ?");
        ((SingleHopPreparedStatement)pshop).createNewSetForTesting();
        pshop.setString(1, "abc");
        pshop.setInt(2, 1);
        rs = pshop.executeQuery();
        SingleHopTest.assertTrue((boolean)rs.next());
        SingleHopTest.assertEquals((String)"zv0", (String)rs.getString(1));
        Set shopset = ((SingleHopPreparedStatement)pshop).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
    }

    public void testBug48416_PartitionByList() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        java.sql.Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        st.execute("create table app.m1 (col1 int primary key , col2 int, col3 smallint, col4 int) partition by list (col3) (VALUES (0, 1), VALUES (2), VALUES (3), VALUES (5, 7))");
        st.execute("create index app.idx1 on app.m1(col2)");
        st.execute("insert into app.m1 values (1, 2, 3, 4)");
        st.execute("insert into app.m1 values (3, 4, 5, 6)");
        PreparedStatement ps = conn.prepareStatement("update app.m1 set col4 = ? where col2 = ? and col3 = ?");
        ps.setInt(1, 1234);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        int ret = ps.executeUpdate();
        SingleHopTest.assertEquals((int)1, (int)ret);
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        ps = connShop.prepareStatement("update app.m1 set col4 = ? where col2 = ? and col3 = ?");
        ((SingleHopPreparedStatement)ps).createNewSetForTesting();
        ps.setInt(1, 1234);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        ret = ps.executeUpdate();
        SingleHopTest.assertEquals((int)1, (int)ret);
        Set shopset = ((SingleHopPreparedStatement)ps).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
    }

    public void testBug48416_PartitionByRange() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        java.sql.Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        st.execute("create table app.m1 (col1 int primary key , col2 int, col3 smallint, col4 int) partition by range (col3) (values between 0 and 2, values between 3 and 5, values between 6 and 7)");
        st.execute("create index app.idx1 on app.m1(col2)");
        st.execute("insert into app.m1 values (1, 2, 3, 4)");
        st.execute("insert into app.m1 values (4, 5, 6, 7)");
        PreparedStatement ps = conn.prepareStatement("update app.m1 set col4 = ? where col2 = ? and col3 = ?");
        ps.setInt(1, 1234);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        int ret = ps.executeUpdate();
        SingleHopTest.assertEquals((int)1, (int)ret);
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        ps = connShop.prepareStatement("update app.m1 set col4 = ? where col2 = ? and col3 = ?");
        ((SingleHopPreparedStatement)ps).createNewSetForTesting();
        ps.setInt(1, 1234);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        ret = ps.executeUpdate();
        SingleHopTest.assertEquals((int)1, (int)ret);
        Set shopset = ((SingleHopPreparedStatement)ps).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
    }

    public void testBug48416_PartitionByColumn() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        java.sql.Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        st.execute("create table app.m1 (col1 int primary key , col2 int, col3 smallint, col4 int) partition by column (col3) ");
        st.execute("create index app.idx1 on app.m1(col2)");
        st.execute("insert into app.m1 values (1, 2, 3, 4)");
        st.execute("insert into app.m1 values (3, 4, 5, 6)");
        PreparedStatement ps = conn.prepareStatement("update app.m1 set col4 = ? where col2 = ? and col3 = ?");
        ps.setInt(1, 1234);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        int ret = ps.executeUpdate();
        SingleHopTest.assertEquals((int)1, (int)ret);
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        ps = connShop.prepareStatement("update app.m1 set col4 = ? where col2 = ? and col3 = ?");
        ((SingleHopPreparedStatement)ps).createNewSetForTesting();
        ps.setInt(1, 1234);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        ret = ps.executeUpdate();
        SingleHopTest.assertEquals((int)1, (int)ret);
        Set shopset = ((SingleHopPreparedStatement)ps).getRoutingObjectSet();
        SingleHopTest.compareSetEqulas(rkeys, shopset, false);
    }

    public void testBug48416_PartitionByExpression() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        java.sql.Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Properties props = new Properties();
        props.setProperty("single-hop-enabled", "true");
        props.setProperty("single-hop-max-connections", "5");
        java.sql.Connection connShop = SingleHopTest.startNetserverAndGetLocalNetConnection(props);
        RoutingKeysObserver observer = new RoutingKeysObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        st.execute("create table app.m1 (col1 int primary key , col2 int, col3 smallint, col4 int) partition by (col3 + 3) ");
        st.execute("create index app.idx1 on app.m1(col2)");
        st.execute("insert into app.m1 values (1, 2, 3, 4)");
        st.execute("insert into app.m1 values (3, 4, 5, 6)");
        PreparedStatement ps = conn.prepareStatement("update app.m1 set col4 = ? where col2 = ? and col3 = ?");
        ps.setInt(1, 1234);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        int ret = ps.executeUpdate();
        SingleHopTest.assertEquals((int)1, (int)ret);
        Set<Object> rkeys = observer.getRoutingKeys();
        SingleHopTest.assertEquals((int)1, (int)rkeys.size());
        ps = connShop.prepareStatement("update app.m1 set col4 = ? where col2 = ? and col3 = ?");
        ((SingleHopPreparedStatement)ps).createNewSetForTesting();
        ps.setInt(1, 1234);
        ps.setInt(2, 2);
        ps.setInt(3, 3);
        ret = ps.executeUpdate();
        SingleHopTest.assertEquals((int)1, (int)ret);
        Set shopset = ((SingleHopPreparedStatement)ps).getRoutingObjectSet();
        SingleHopTest.assertEquals((int)0, (int)shopset.size());
    }

    public static class RoutingKeysObserver
    extends GemFireXDQueryObserverAdapter {
        private Set<Object> routingKeys;

        public void setRoutingObjectsBeforeExecution(Set<Object> routingKeys) {
            this.routingKeys = routingKeys;
        }

        public Set<Object> getRoutingKeys() {
            return this.routingKeys;
        }

        public void reset() {
            this.routingKeys = null;
        }

        public void afterSingleRowInsert(Object routingObj) {
            if (this.routingKeys == null) {
                this.routingKeys = new HashSet<Object>();
            }
            this.routingKeys.add(routingObj);
        }
    }
}

