/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SimpleAppTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(SimpleAppTest.class));
    }

    public SimpleAppTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSimpleApp() throws SQLException {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert = null;
        PreparedStatement psUpdate = null;
        Statement s = null;
        ResultSet rs = null;
        Connection conn = null;
        try {
            int number;
            conn = SimpleAppTest.getConnection();
            s = conn.createStatement();
            statements.add(s);
            s.execute("create table location(num int, addr varchar(40))");
            psInsert = conn.prepareStatement("insert into location values (?, ?)");
            statements.add(psInsert);
            psInsert.setInt(1, 1956);
            psInsert.setString(2, "Webster St.");
            int n = psInsert.executeUpdate();
            SimpleAppTest.assertEquals((String)"Insert not working ", (int)1, (int)n);
            psInsert.setInt(1, 1910);
            psInsert.setString(2, "Union St.");
            n = psInsert.executeUpdate();
            SimpleAppTest.assertEquals((String)"Insert not working ", (int)1, (int)n);
            psUpdate = conn.prepareStatement("update location set num=?, addr=? where num=?");
            statements.add(psUpdate);
            psUpdate.setInt(1, 180);
            psUpdate.setString(2, "Grand Ave.");
            psUpdate.setInt(3, 1956);
            n = psUpdate.executeUpdate();
            SimpleAppTest.assertEquals((String)"Update not working  ", (int)1, (int)n);
            psUpdate.setInt(1, 300);
            psUpdate.setString(2, "Lakeshore Ave.");
            psUpdate.setInt(3, 180);
            n = psUpdate.executeUpdate();
            SimpleAppTest.assertEquals((String)"Update not working ", (int)1, (int)n);
            rs = s.executeQuery("SELECT num, addr FROM location ORDER BY num");
            if (!rs.next()) {
                SimpleAppTest.fail("No rows in ResultSet");
            }
            if ((number = rs.getInt(1)) != 300) {
                SimpleAppTest.fail("Wrong row returned, expected num=300, got " + number);
            }
            if (!rs.next()) {
                SimpleAppTest.fail("Too few rows");
            }
            if ((number = rs.getInt(1)) != 1910) {
                SimpleAppTest.fail("Wrong row returned, expected num=1910, got " + number);
            }
            if (rs.next()) {
                SimpleAppTest.fail("Too many rows");
            }
            s.execute("drop table location");
            conn.commit();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            int i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            if (conn != null) {
                conn.close();
                conn = null;
            }
        }
    }
}

