/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RangePartitionResolverTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(RangePartitionResolverTest.class));
    }

    public RangePartitionResolverTest(String name) {
        super(name);
    }

    public void testRange_bug42950() throws SQLException, StandardException {
        Connection conn = RangePartitionResolverTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null, sid int not null)  partition by range (cid) (VALUES BETWEEN 0 AND 1666, VALUES BETWEEN 1666 AND 3332, VALUES BETWEEN 3332 AND 4998, VALUES BETWEEN 4998 AND 6664, VALUES BETWEEN 6664 AND 8330, VALUES BETWEEN 8330 AND 10000)  BUCKETS 7  REDUNDANCY 3");
        GfxdRangePartitionResolver erpr = (GfxdRangePartitionResolver)((PartitionedRegion)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO")).getPartitionResolver();
        Object[] robjs = erpr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(0), false, (DataValueDescriptor)new SQLInteger(10000), false);
        RangePartitionResolverTest.assertNotNull((Object)robjs);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)robjs[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)robjs[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)robjs[2]);
        RangePartitionResolverTest.assertEquals((Object)4, (Object)robjs[3]);
        RangePartitionResolverTest.assertEquals((Object)5, (Object)robjs[4]);
        RangePartitionResolverTest.assertEquals((Object)6, (Object)robjs[5]);
    }

    public void testRanges() throws SQLException, StandardException {
        Connection conn = RangePartitionResolverTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 )");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
        RangePartitionResolverTest.assertNotNull((Object)rpr);
        SQLInteger lowerBound = null;
        SQLInteger upperBound = null;
        Object[] routingObjects = null;
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)3, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[2]);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, false);
        RangePartitionResolverTest.assertEquals((int)3, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[2]);
        upperBound = new SQLInteger(60);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, false);
        RangePartitionResolverTest.assertEquals((int)2, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, false, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)3, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[2]);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)2, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[1]);
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)3, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[2]);
        lowerBound = new SQLInteger(15);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(60);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, false, (DataValueDescriptor)upperBound, false);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[0]);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(95);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(20);
        upperBound = new SQLInteger(30);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        lowerBound = new SQLInteger(60);
        upperBound = new SQLInteger(60);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[0]);
        s.close();
        conn.close();
    }

    public void testRangesInfinity() throws SQLException, StandardException {
        Connection conn = RangePartitionResolverTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table EMP.PARTITIONTESTTABLE_ONE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and 40, VALUES BETWEEN 50 and +INFINITY )");
        Cache cache = CacheFactory.getAnyInstance();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE_ONE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
        RangePartitionResolverTest.assertNotNull((Object)rpr);
        SQLInteger lowerBound = null;
        SQLInteger upperBound = null;
        Object[] routingObjects = null;
        lowerBound = new SQLInteger(-10);
        upperBound = new SQLInteger(30);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        lowerBound = new SQLInteger(10);
        upperBound = new SQLInteger(45);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(60);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(50);
        upperBound = new SQLInteger(70);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[0]);
        lowerBound = null;
        upperBound = new SQLInteger(30);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, false, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        lowerBound = null;
        upperBound = new SQLInteger(45);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, false, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(50);
        upperBound = null;
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, false);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[0]);
        s.close();
        conn.close();
    }

    public void testRanges_colocated() throws SQLException, StandardException {
        Connection conn = RangePartitionResolverTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 )");
        s.execute("create table EMP.PARTITIONTESTTABLE_COLOCATED (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 ) COLOCATE WITH (EMP.PARTITIONTESTTABLE)");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE_COLOCATED");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
        RangePartitionResolverTest.assertNotNull((Object)rpr);
        SQLInteger lowerBound = null;
        SQLInteger upperBound = null;
        Object[] routingObjects = null;
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)3, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[2]);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, false);
        RangePartitionResolverTest.assertEquals((int)3, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[2]);
        upperBound = new SQLInteger(60);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, false);
        RangePartitionResolverTest.assertEquals((int)2, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, false, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)3, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[2]);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)2, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[1]);
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)3, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[1]);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[2]);
        lowerBound = new SQLInteger(15);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(60);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, false, (DataValueDescriptor)upperBound, false);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[0]);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(95);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(20);
        upperBound = new SQLInteger(30);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        lowerBound = new SQLInteger(60);
        upperBound = new SQLInteger(60);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)3, (Object)routingObjects[0]);
        s.close();
        conn.close();
    }

    public void testRangesInfinity_colocated() throws SQLException, StandardException {
        Connection conn = RangePartitionResolverTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table EMP.PARTITIONTESTTABLE_ONE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and 40, VALUES BETWEEN 50 and +INFINITY )");
        s.execute("create table EMP.PARTITIONTESTTABLE_ONE_COLOCATED (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and 40, VALUES BETWEEN 50 and +INFINITY ) COLOCATE WITH (EMP.PARTITIONTESTTABLE_ONE)");
        Cache cache = CacheFactory.getAnyInstance();
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE_ONE_COLOCATED");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
        RangePartitionResolverTest.assertNotNull((Object)rpr);
        SQLInteger lowerBound = null;
        SQLInteger upperBound = null;
        Object[] routingObjects = null;
        lowerBound = new SQLInteger(-10);
        upperBound = new SQLInteger(30);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        lowerBound = new SQLInteger(10);
        upperBound = new SQLInteger(45);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(60);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(50);
        upperBound = new SQLInteger(70);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[0]);
        lowerBound = null;
        upperBound = new SQLInteger(30);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)1, (Object)routingObjects[0]);
        lowerBound = null;
        upperBound = new SQLInteger(45);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(50);
        upperBound = null;
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        RangePartitionResolverTest.assertEquals((int)1, (int)routingObjects.length);
        RangePartitionResolverTest.assertEquals((Object)2, (Object)routingObjects[0]);
        s.close();
        conn.close();
    }

    public void testUpdateTableScan() throws Exception {
        RangePartitionResolverTest.setupConnection();
        GemFireCacheImpl cache = Misc.getGemFireCache();
        RangePartitionResolverTest.sqlExecute("create table EMP.PARTITIONTESTTABLE (ID int not null,  TID int not null)PARTITION BY RANGE ( TID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 )", false);
        Region reg = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = reg.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
        RangePartitionResolverTest.assertNotNull((Object)rpr);
        String query1 = "select * from EMP.PARTITIONTESTTABLE";
        String query2 = "select * from EMP.PARTITIONTESTTABLE where ID = 5";
        String query3 = "select * from EMP.PARTITIONTESTTABLE where ID = 8";
        String query4 = "select * from EMP.PARTITIONTESTTABLE where ID = 10";
        RangePartitionResolverTest.sqlExecute("insert into EMP.PARTITIONTESTTABLE values (4, 20), (5, 30), (3, 40), (3, 5), (6, 30), (5, 200), (8, 5)", true);
        RangePartitionResolverTest.sqlExecuteVerifyText(query1, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query1", false, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query2, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query2", false, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query3, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query3", false, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query4, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "empty", false, false);
        RangePartitionResolverTest.sqlExecute("update EMP.PARTITIONTESTTABLE set ID = 5 where TID = 30", true);
        RangePartitionResolverTest.sqlExecuteVerifyText(query1, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query1_update", false, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query2, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query2_update", true, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query3, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query3", false, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query4, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "empty", false, false);
        RangePartitionResolverTest.sqlExecute("update EMP.PARTITIONTESTTABLE set ID = 10 where TID = 5", true);
        RangePartitionResolverTest.sqlExecuteVerifyText(query1, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query1_update2", true, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query2, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query2_update", true, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query3, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "empty", false, false);
        RangePartitionResolverTest.sqlExecuteVerifyText(query4, RangePartitionResolverTest.getResourcesDir() + "/lib/checkQuery.xml", "scan_query4_update", false, false);
    }
}

