/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDouble;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RangePartitionResolverAllTypesTest
extends JdbcTestBase {
    private static String[] Region_Names = new String[]{"/EMP/PARTITIONTESTTABLE_INT", "/EMP/PARTITIONTESTTABLE_STRING", "/EMP/PARTITIONTESTTABLE_DECIMAL", "/EMP/PARTITIONTESTTABLE_DATE", "/EMP/PARTITIONTESTTABLE_TIME", "/EMP/PARTITIONTESTTABLE_TIMESTAMP"};
    private static String[] Set1_CreateTableStmntDiffDataType = new String[]{"create table EMP.PARTITIONTESTTABLE_INT (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 )", "create table EMP.PARTITIONTESTTABLE_STRING (ID varchar(1024) not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 'abc' and 'abg', VALUES BETWEEN 'abg' and 'abk', VALUES BETWEEN 'abk' and 'abp', VALUES BETWEEN 'abt' and 'abz' )", "create table EMP.PARTITIONTESTTABLE_DECIMAL (ID decimal not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1.1 and 5.1, VALUES BETWEEN 5.1 and 10.1, VALUES BETWEEN 10.1 and 15.1, VALUES BETWEEN 20.1 and 25.1 )", "create table EMP.PARTITIONTESTTABLE_DATE (ID date not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN {d '2000-01-01'} and {d '2000-06-30'}, VALUES BETWEEN {d '2000-06-30'} and {d '2000-12-31'}, VALUES BETWEEN {d '2000-12-31'} and {d '2008-08-30'}, VALUES BETWEEN {d '2008-12-20'} and {d '2009-05-01'} )", "create table EMP.PARTITIONTESTTABLE_TIME (ID Time not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN {t '00:20:00'} and {t '00:40:00'}, VALUES BETWEEN {t '00:40:00'} and {t '01:20:00'}, VALUES BETWEEN {t '01:20:00'} and {t '02:30:30'}, VALUES BETWEEN {t '03:00:00'} and {t '04:00:00'} )", "create table EMP.PARTITIONTESTTABLE_TIMESTAMP (ID Timestamp not null,  DESCRIPTION varchar(1024) not null, primary key (ID))PARTITION BY RANGE ( ID ) ( VALUES BETWEEN {ts '2000-01-01 00:01:00'} and {ts '2000-06-30 00:01:00'}, VALUES BETWEEN {ts '2000-06-30 00:01:00'} and {ts '2000-12-31 00:01:00'}, VALUES BETWEEN {ts '2000-12-31 00:01:00'} and {ts '2008-08-30 00:01:00'}, VALUES BETWEEN {ts '2008-12-20 00:01:00'} and {ts '2009-05-01 00:01:00'} )"};
    private static Object[] Set1_params = new Object[]{new Object[]{new Object[]{new SQLInteger(25), Boolean.TRUE, new SQLInteger(75), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{new SQLInteger(25), Boolean.TRUE, new SQLInteger(75), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{new SQLInteger(25), Boolean.TRUE, new SQLInteger(60), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2)}}, new Object[]{new SQLInteger(25), Boolean.FALSE, new SQLInteger(75), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{new SQLInteger(40), Boolean.TRUE, new SQLInteger(75), Boolean.TRUE, new Integer[]{new Integer(2), new Integer(3)}}, new Object[]{new SQLInteger(15), Boolean.TRUE, new SQLInteger(75), Boolean.TRUE, null}, new Object[]{new SQLInteger(40), Boolean.FALSE, new SQLInteger(60), Boolean.FALSE, new Integer[]{new Integer(2)}}, new Object[]{new SQLInteger(4), Boolean.TRUE, new SQLInteger(95), Boolean.TRUE, null}, new Object[]{new SQLInteger(20), Boolean.TRUE, new SQLInteger(30), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{new SQLInteger(60), Boolean.TRUE, new SQLInteger(60), Boolean.TRUE, new Integer[]{new Integer(3)}}}, new Object[]{new Object[]{new SQLVarchar("abd"), Boolean.TRUE, new SQLVarchar("abm"), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{new SQLVarchar("abd"), Boolean.TRUE, new SQLVarchar("abm"), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{new SQLVarchar("abd"), Boolean.TRUE, new SQLVarchar("abk"), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2)}}, new Object[]{new SQLVarchar("abd"), Boolean.FALSE, new SQLVarchar("abm"), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{new SQLVarchar("abg"), Boolean.TRUE, new SQLVarchar("abm"), Boolean.TRUE, new Integer[]{new Integer(2), new Integer(3)}}, new Object[]{new SQLVarchar("aba"), Boolean.TRUE, new SQLVarchar("abm"), Boolean.TRUE, null}, new Object[]{new SQLVarchar("abg"), Boolean.FALSE, new SQLVarchar("abk"), Boolean.FALSE, new Integer[]{new Integer(2)}}, new Object[]{new SQLVarchar("abg"), Boolean.TRUE, new SQLVarchar("abv"), Boolean.TRUE, null}, new Object[]{new SQLVarchar("abc"), Boolean.TRUE, new SQLVarchar("abe"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{new SQLVarchar("abk"), Boolean.TRUE, new SQLVarchar("abk"), Boolean.TRUE, new Integer[]{new Integer(3)}}}, new Object[]{new Object[]{RangePartitionResolverAllTypesTest.getDouble(2.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(13.1), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(2.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(13.1), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(2.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(10.1), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2)}}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(2.1), Boolean.FALSE, RangePartitionResolverAllTypesTest.getDouble(13.1), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(5.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(13.1), Boolean.TRUE, new Integer[]{new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(0.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(13.1), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(5.1), Boolean.FALSE, RangePartitionResolverAllTypesTest.getDouble(10.1), Boolean.FALSE, new Integer[]{new Integer(2)}}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(5.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(27.1), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(1.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(4.1), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(10.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(10.1), Boolean.TRUE, new Integer[]{new Integer(3)}}}, new Object[]{new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-03-03"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2004-12-31"), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-03-03"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2004-12-31"), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-03-03"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2000-12-31"), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2)}}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-03-03"), Boolean.FALSE, RangePartitionResolverAllTypesTest.getDate("2004-12-31"), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-06-30"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2004-12-31"), Boolean.TRUE, new Integer[]{new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getDate("1999-01-03"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2004-12-31"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-06-30"), Boolean.FALSE, RangePartitionResolverAllTypesTest.getDate("2000-12-31"), Boolean.FALSE, new Integer[]{new Integer(2)}}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-06-30"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2009-03-03"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-01-01"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2000-03-03"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2000-12-31"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2000-12-31"), Boolean.TRUE, new Integer[]{new Integer(3)}}}, new Object[]{new Object[]{RangePartitionResolverAllTypesTest.getTime("00:30:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("02:00:00"), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getTime("00:30:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("02:00:00"), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getTime("00:30:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("01:20:00"), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2)}}, new Object[]{RangePartitionResolverAllTypesTest.getTime("00:30:00"), Boolean.FALSE, RangePartitionResolverAllTypesTest.getTime("02:00:00"), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getTime("00:40:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("02:00:00"), Boolean.TRUE, new Integer[]{new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getTime("00:10:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("02:00:00"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTime("00:40:00"), Boolean.FALSE, RangePartitionResolverAllTypesTest.getTime("01:20:00"), Boolean.FALSE, new Integer[]{new Integer(2)}}, new Object[]{RangePartitionResolverAllTypesTest.getTime("00:40:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("03:30:00"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTime("00:20:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("00:30:00"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{RangePartitionResolverAllTypesTest.getTime("01:20:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("01:20:00"), Boolean.TRUE, new Integer[]{new Integer(3)}}}, new Object[]{new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-03-01 00:01:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2004-01-01 00:01:00"), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-03-01 00:01:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2004-01-01 00:01:00"), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-03-01 00:01:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2000-12-31 00:01:00"), Boolean.FALSE, new Integer[]{new Integer(1), new Integer(2)}}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-03-01 00:01:00"), Boolean.FALSE, RangePartitionResolverAllTypesTest.getTimeStamp("2004-01-01 00:01:00"), Boolean.TRUE, new Integer[]{new Integer(1), new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-06-30 00:01:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2004-01-01 00:01:00"), Boolean.TRUE, new Integer[]{new Integer(2), new Integer(3)}}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("1990-01-01 00:01:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2004-01-01 00:01:00"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-06-30 00:01:00"), Boolean.FALSE, RangePartitionResolverAllTypesTest.getTimeStamp("2000-12-31 00:01:00"), Boolean.FALSE, new Integer[]{new Integer(2)}}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-06-30 00:01:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2009-01-01 00:01:00"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-01-01 00:01:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2000-03-01 00:01:00"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2000-12-31 00:01:00"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2000-12-31 00:01:00"), Boolean.TRUE, new Integer[]{new Integer(3)}}}};
    private static String[] Set2_CreateTableStmntDiffDataType = new String[]{"create table EMP.PARTITIONTESTTABLE_INT (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and 40, VALUES BETWEEN 50 and +INFINITY )", "create table EMP.PARTITIONTESTTABLE_STRING (ID varchar(1024) not null,  DESCRIPTION varchar(1024) not null, primary key (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and 'abc', VALUES BETWEEN 'abt' and +INFINITY )", "create table EMP.PARTITIONTESTTABLE_DECIMAL (ID decimal not null,  DESCRIPTION varchar(1024) not null, primary key (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and 1.1, VALUES BETWEEN 2.1 and +INFINITY )", "create table EMP.PARTITIONTESTTABLE_DATE (ID date not null,  DESCRIPTION varchar(1024) not null, primary key (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and {d '2004-01-01'}, VALUES BETWEEN {d '2008-01-01'} and +INFINITY )", "create table EMP.PARTITIONTESTTABLE_TIME (ID Time not null,  DESCRIPTION varchar(1024) not null, primary key (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and {t '10:20:30'}, VALUES BETWEEN {t '20:30:40'} and +INFINITY )", "create table EMP.PARTITIONTESTTABLE_TIMESTAMP (ID Timestamp not null,  DESCRIPTION varchar(1024) not null, primary key (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN -INFINITY and {ts '2004-01-01 10:10:10'}, VALUES BETWEEN {ts '2008-01-01 20:20:20'} and +INFINITY )"};
    private static Object[] Set2_params = new Object[]{new Object[]{new Object[]{new SQLInteger(-10), Boolean.TRUE, new SQLInteger(30), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{new SQLInteger(10), Boolean.TRUE, new SQLInteger(45), Boolean.TRUE, null}, new Object[]{new SQLInteger(40), Boolean.TRUE, new SQLInteger(60), Boolean.TRUE, null}, new Object[]{new SQLInteger(50), Boolean.TRUE, new SQLInteger(70), Boolean.TRUE, new Integer[]{new Integer(2)}}, new Object[]{null, Boolean.TRUE, new SQLInteger(30), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{null, Boolean.TRUE, new SQLInteger(45), Boolean.TRUE, null}, new Object[]{new SQLInteger(50), Boolean.TRUE, null, Boolean.TRUE, new Integer[]{new Integer(2)}}}, new Object[]{new Object[]{new SQLVarchar("aba"), Boolean.TRUE, new SQLVarchar("abb"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{new SQLVarchar("abb"), Boolean.TRUE, new SQLVarchar("abd"), Boolean.TRUE, null}, new Object[]{new SQLVarchar("abc"), Boolean.TRUE, new SQLVarchar("abv"), Boolean.TRUE, null}, new Object[]{new SQLVarchar("abt"), Boolean.TRUE, new SQLVarchar("abv"), Boolean.TRUE, new Integer[]{new Integer(2)}}, new Object[]{null, Boolean.TRUE, new SQLVarchar("abb"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{null, Boolean.TRUE, new SQLVarchar("abd"), Boolean.TRUE, null}, new Object[]{new SQLVarchar("abt"), Boolean.TRUE, null, Boolean.TRUE, new Integer[]{new Integer(2)}}}, new Object[]{new Object[]{RangePartitionResolverAllTypesTest.getDouble(-1.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(0.1), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(0.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(1.4), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(1.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(3.1), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(2.1), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(5.1), Boolean.TRUE, new Integer[]{new Integer(2)}}, new Object[]{null, Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(0.1), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{null, Boolean.TRUE, RangePartitionResolverAllTypesTest.getDouble(1.5), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDouble(2.1), Boolean.TRUE, null, Boolean.TRUE, new Integer[]{new Integer(2)}}}, new Object[]{new Object[]{RangePartitionResolverAllTypesTest.getDate("1999-01-01"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2003-01-01"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2003-08-08"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2005-04-04"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2004-01-01"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2009-01-01"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2008-01-01"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2009-01-01"), Boolean.TRUE, new Integer[]{new Integer(2)}}, new Object[]{null, Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2003-08-08"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{null, Boolean.TRUE, RangePartitionResolverAllTypesTest.getDate("2005-01-01"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getDate("2008-01-01"), Boolean.TRUE, null, Boolean.TRUE, new Integer[]{new Integer(2)}}}, new Object[]{new Object[]{RangePartitionResolverAllTypesTest.getTime("5:20:30"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("08:20:30"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{RangePartitionResolverAllTypesTest.getTime("5:20:30"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("11:20:30"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTime("10:20:30"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("21:30:40"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTime("20:30:40"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("22:30:40"), Boolean.TRUE, new Integer[]{new Integer(2)}}, new Object[]{null, Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("08:20:30"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{null, Boolean.TRUE, RangePartitionResolverAllTypesTest.getTime("11:20:30"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTime("20:30:40"), Boolean.TRUE, null, Boolean.TRUE, new Integer[]{new Integer(2)}}}, new Object[]{new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("1996-01-01 10:10:10"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2003-01-01 10:10:10"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2003-01-01 10:10:10"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2005-01-01 10:10:10"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2004-01-01 10:10:10"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2009-01-01 10:10:10"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2008-01-01 20:20:20"), Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2009-01-01 10:10:10"), Boolean.TRUE, new Integer[]{new Integer(2)}}, new Object[]{null, Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2003-01-01 10:10:10"), Boolean.TRUE, new Integer[]{new Integer(1)}}, new Object[]{null, Boolean.TRUE, RangePartitionResolverAllTypesTest.getTimeStamp("2006-01-01 10:10:10"), Boolean.TRUE, null}, new Object[]{RangePartitionResolverAllTypesTest.getTimeStamp("2008-01-01 20:20:20"), Boolean.TRUE, null, Boolean.TRUE, new Integer[]{new Integer(2)}}}};

    private static SQLDate getDate(String s) {
        try {
            return new SQLDate(s, true, null);
        }
        catch (StandardException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static SQLTime getTime(String s) {
        try {
            return new SQLTime(s, true, null);
        }
        catch (StandardException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static SQLTimestamp getTimeStamp(String s) {
        try {
            return new SQLTimestamp(s, true, null);
        }
        catch (StandardException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static SQLDouble getDouble(double d) {
        try {
            return new SQLDouble(d);
        }
        catch (StandardException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(RangePartitionResolverAllTypesTest.class));
    }

    public RangePartitionResolverAllTypesTest(String name) {
        super(name);
    }

    public void testRanges() throws SQLException, StandardException, IOException {
        Connection conn = RangePartitionResolverAllTypesTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        for (int i = 0; i < Set1_CreateTableStmntDiffDataType.length; ++i) {
            System.out.println("Region Name = " + Region_Names[i]);
            s.execute(Set1_CreateTableStmntDiffDataType[i]);
            Region regtwo = cache.getRegion(Region_Names[i]);
            RegionAttributes rattr = regtwo.getAttributes();
            PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
            GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
            Object[] eachTypeArray = (Object[])Set1_params[i];
            for (int eachCase = 0; eachCase < eachTypeArray.length; ++eachCase) {
                Object[] params = (Object[])eachTypeArray[eachCase];
                Object[] routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)params[0], ((Boolean)params[1]).booleanValue(), (DataValueDescriptor)params[2], ((Boolean)params[3]).booleanValue());
                Integer[] verifyRoutingObjects = (Integer[])params[4];
                if (verifyRoutingObjects == null) {
                    RangePartitionResolverAllTypesTest.assertNull((Object)routingObjects);
                    continue;
                }
                RangePartitionResolverAllTypesTest.assertEquals((int)verifyRoutingObjects.length, (int)routingObjects.length);
                for (int v = 0; v < verifyRoutingObjects.length; ++v) {
                    RangePartitionResolverAllTypesTest.assertEquals((Object)verifyRoutingObjects[v], (Object)routingObjects[v]);
                }
            }
        }
        s.close();
        conn.close();
    }

    public void testRangesInfinity() throws SQLException, StandardException {
        Connection conn = RangePartitionResolverAllTypesTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        for (int i = 0; i < Set2_CreateTableStmntDiffDataType.length; ++i) {
            s.execute(Set2_CreateTableStmntDiffDataType[i]);
            Region regtwo = cache.getRegion(Region_Names[i]);
            System.out.println("Region Name = " + Region_Names[i]);
            RegionAttributes rattr = regtwo.getAttributes();
            PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
            GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
            Object[] eachTypeArray = (Object[])Set2_params[i];
            for (int eachCase = 0; eachCase < eachTypeArray.length; ++eachCase) {
                Object[] params = (Object[])eachTypeArray[eachCase];
                Object[] routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)params[0], ((Boolean)params[1]).booleanValue(), (DataValueDescriptor)params[2], ((Boolean)params[3]).booleanValue());
                Integer[] verifyRoutingObjects = (Integer[])params[4];
                if (verifyRoutingObjects == null) {
                    RangePartitionResolverAllTypesTest.assertNull((Object)routingObjects);
                    continue;
                }
                RangePartitionResolverAllTypesTest.assertEquals((int)verifyRoutingObjects.length, (int)routingObjects.length);
                for (int v = 0; v < verifyRoutingObjects.length; ++v) {
                    RangePartitionResolverAllTypesTest.assertEquals((Object)verifyRoutingObjects[v], (Object)routingObjects[v]);
                }
            }
        }
        s.close();
        conn.close();
    }
}

