/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.catalog.SystemProcedures;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CursorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ProjectRestrictNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ScrollInsensitiveResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.stats.StatementPlanDUnit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class QueryTest
extends JdbcTestBase {
    public QueryTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(QueryTest.class));
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        SystemProcedures.TEST_FAILURE_MODE = false;
    }

    public void test48488() throws Exception {
        Properties props = new Properties();
        props.setProperty("mcast-port", Integer.toString(AvailablePort.getRandomAvailablePort((int)1)));
        QueryTest.setupConnection(props);
        TestUtil.assertTimerLibraryLoaded();
        int netPort = QueryTest.startNetserverAndReturnPort();
        Connection netConn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = netConn.createStatement();
        stmt.execute("CREATE TABLE C_BO_PRTY(  ROWID_OBJECT                CHAR(14)     NOT NULL,  CREATE_DATE                 DATE         DEFAULT CURRENT_DATE,  LAST_UPDATE_DATE            DATE,  HUB_STATE_IND               INTEGER      DEFAULT 1 NOT NULL,  PRTY_CUST_ROLE_FL           CHAR(1)      NOT NULL,  PRTY_PERS_ROLE_FL           CHAR(1)      NOT NULL,  PRTY_FST_NM                 VARCHAR(40),  PRTY_MID_NM                 VARCHAR(40),  PRTY_LAST_NM                VARCHAR(40),  PRTY_FULL_NM                VARCHAR(120),  PRTY_CUST_INFRML_NM         VARCHAR(40),  PRTY_PERS_PREF_NM           VARCHAR(40),  PRTY_TITL_SFX_CD            VARCHAR(40),  PRTY_TKN_SSN_NUM            VARCHAR(32),  PRTY_BIRTH_DT               DATE,  PRTY_GNDR_CD                VARCHAR(3),  PRTY_GNDR_DSC               VARCHAR(240),  PRTY_TRUVUE_PIN_ID          VARCHAR(17),  PRTY_ORIG_FST_NM            VARCHAR(40),  PRTY_ORIG_MID_NM            VARCHAR(40),  PRTY_ORIG_LST_NM            VARCHAR(40),  PRTY_ORIG_TITL_SFX_CD       VARCHAR(40),  PRTY_NA_SKEY                BIGINT,  NAME_PFX_CD_FK              VARCHAR(32),  NM_UPDT_RSN_ID              CHAR(14),  NM_SFX_CD_FK                VARCHAR(32),  PRTY_CNTCT_METH_TYP_CD      VARCHAR(32),  PRTY_HIDE_SRC_TXT           VARCHAR(240),  PRTY_RLNSHP_OKTOEMAIL_FL    CHAR(1)) REDUNDANCY 0 PERSISTENT PARTITION BY COLUMN (ROWID_OBJECT);");
        stmt.execute("CREATE TABLE C_BO_POSTAL_ADDR(  ROWID_OBJECT           CHAR(14)      NOT NULL,  CREATE_DATE            DATE          DEFAULT CURRENT_DATE,  LAST_UPDATE_DATE       DATE,  HUB_STATE_IND          INTEGER       DEFAULT 1 NOT NULL,  PSTL_LN1_TXT           VARCHAR(100),  PSTL_LN2_TXT           VARCHAR(100),  PSTL_LN3_TXT           VARCHAR(100),  PSTL_LN4_TXT           VARCHAR(100),  PSTL_CITY_NM           VARCHAR(40),  PSTL_CD                VARCHAR(32),  PSTL_ORIG_LN1_TXT      VARCHAR(100),  PSTL_ORIG_LN2_TXT      VARCHAR(100),  PSTL_ORIG_LN3_TXT      VARCHAR(100),  PSTL_ORIG_LN4_TXT      VARCHAR(100),  PSTL_ORIG_CITY_NM      VARCHAR(36),  PSTL_ORIGIN_REGN_NM    VARCHAR(40),  PSTL_ORIG_CD           VARCHAR(32),  PRTY_ID                CHAR(14)      NOT NULL,  CUST_ADDR_DNU_RSN_ID   CHAR(14),  ST_ID                  CHAR(14),  CNTRY_ID               CHAR(14),  REGN_ID                CHAR(14),  ADDR_TYP_ID            CHAR(14),  ADDR_RSDNCY_TYP_ID     CHAR(14)) REDUNDANCY 0 PERSISTENT PARTITION BY COLUMN (PRTY_ID) COLOCATE WITH (C_BO_PRTY);");
        stmt.execute("CREATE VIEW FINDCUST as SELECT  B.HUB_STATE_IND,            C.PSTL_LN1_TXT,            C.PSTL_LN2_TXT,            C.PSTL_LN3_TXT,            C.PSTL_LN4_TXT,            C.PSTL_CITY_NM,            C.PSTL_CD,            C.ST_ID,            B.ROWID_OBJECT AS CUST_ID,            B.PRTY_FST_NM,            B.PRTY_LAST_NM,            B.PRTY_CUST_INFRML_NM,            B.PRTY_TITL_SFX_CD,            B.NAME_PFX_CD_FK,            B.NM_SFX_CD_FK,            B.PRTY_HIDE_SRC_TXT,            B.PRTY_CNTCT_METH_TYP_CD,            C.PSTL_ORIG_LN1_TXT,            C.PSTL_ORIG_LN2_TXT,            C.PSTL_ORIG_LN3_TXT,            C.PSTL_ORIG_LN4_TXT,            B.PRTY_MID_NM,            C.PSTL_ORIG_CITY_NM,            C.PSTL_ORIG_CD,            B.PRTY_ORIG_FST_NM,            B.PRTY_ORIG_LST_NM,            C.CUST_ADDR_DNU_RSN_ID,            C.REGN_ID,            C.LAST_UPDATE_DATE,            C.CNTRY_ID,            B.PRTY_ORIG_MID_NM       FROM         C_BO_POSTAL_ADDR C       INNER JOIN   C_BO_PRTY B ON B.ROWID_OBJECT = C.PRTY_ID");
        java.sql.ResultSet r = stmt.executeQuery("select count(*) from findcust");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)0, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        PreparedStatement boPrty = netConn.prepareStatement("insert into C_BO_PRTY (ROWID_OBJECT, PRTY_CUST_ROLE_FL, PRTY_PERS_ROLE_FL) values (?, ? , ?)");
        PreparedStatement postAddrs = netConn.prepareStatement("insert into C_BO_POSTAL_ADDR (ROWID_OBJECT, PRTY_ID) values (?, ?)");
        for (int i = 1; i <= 100; ++i) {
            boPrty.setString(1, "   Str " + i);
            postAddrs.setString(2, "   Str " + i);
            boPrty.setString(2, "Y");
            boPrty.setString(3, "N");
            postAddrs.setString(1, "ROWIDOBJ___" + i);
            boPrty.addBatch();
            postAddrs.addBatch();
        }
        boPrty.executeBatch();
        boPrty.clearBatch();
        postAddrs.executeBatch();
        postAddrs.clearBatch();
        stmt.execute("call syscs_util.set_explain_connection(1)");
        PreparedStatement ps = netConn.prepareStatement("select count(*) from findcust where CUST_ID like ? ");
        ps.setString(1, "%");
        r = ps.executeQuery();
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)100, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        r.close();
        stmt.execute("call syscs_util.set_explain_connection(0)");
        java.sql.ResultSet qp = stmt.executeQuery("select stmt_id, stmt_text from sys.statementplans");
        QueryTest.assertTrue((boolean)qp.next());
        do {
            String uuid = qp.getString(1);
            System.out.println("Extracting plan for " + uuid);
            java.sql.ResultSet plan = netConn.createStatement().executeQuery("explain " + uuid);
            QueryTest.assertTrue((boolean)plan.next());
            String thePlan = plan.getString(1);
            QueryTest.getLogger().info((Object)("plan : " + thePlan));
            StringTokenizer t = new StringTokenizer(thePlan, "\r\n");
            QueryTest.assertEquals((int)23, (int)t.countTokens());
            QueryTest.assertFalse((boolean)plan.next());
        } while (qp.next());
    }

    public void test48488_2() throws SQLException {
        if (isTransactional) {
            return;
        }
        Connection conn = QueryTest.getConnection();
        TestUtil.assertTimerLibraryLoaded();
        Statement stmt = conn.createStatement();
        java.sql.ResultSet r = null;
        Properties props = new Properties();
        props.setProperty("mcast-port", Integer.toString(AvailablePort.getRandomAvailablePort((int)1)));
        stmt.execute("create table t1 (i int, s smallint, d double precision, r real, c10 char(10),c30 char(30), vc10 varchar(10), vc30 varchar(30))");
        stmt.execute("create table t2 (i int, s smallint, d double precision, r real, c10 char(10),     c30 char(30), vc10 varchar(10), vc30 varchar(30))");
        stmt.execute("insert into t1 values (null, null, null, null, null, null, null, null)");
        stmt.execute("insert into t1 values (1, 1, 1e1, 1e1, '11111', '11111     11', '11111','11111      11')");
        stmt.execute("insert into t1 values (2, 2, 2e1, 2e1, '22222', '22222     22', '22222',  '22222      22')");
        stmt.execute("insert into t2 values (null, null, null, null, null, null, null, null)");
        stmt.execute("insert into t2 values (3, 3, 3e1, 3e1, '33333', '33333     33', '33333','33333      33')");
        stmt.execute("insert into t2 values (4, 4, 4e1, 4e1, '44444', '44444     44', '44444',  '44444      44')");
        THashSet values = new THashSet();
        values.add((Object)"13");
        values.add((Object)"14");
        values.add((Object)"10");
        values.add((Object)"23");
        values.add((Object)"24");
        values.add((Object)"20");
        values.add((Object)"31");
        values.add((Object)"32");
        values.add((Object)"30");
        values.add((Object)"41");
        values.add((Object)"42");
        values.add((Object)"40");
        values.add((Object)"910");
        values.add((Object)"01");
        values.add((Object)"02");
        values.add((Object)"03");
        values.add((Object)"04");
        values.add((Object)"00");
        r = stmt.executeQuery("values (9, 10) union select a.i, b.i from t1 a, t2 b union select b.i, a.i from t1 a, t2 b");
        while (r.next()) {
            QueryTest.assertTrue((boolean)values.remove((Object)(r.getInt(1) + "" + r.getInt(2))));
        }
        QueryTest.assertFalse((boolean)r.next());
        QueryTest.assertTrue((boolean)values.isEmpty());
        r.close();
        stmt.execute("drop table t1");
        stmt.execute("drop table t2");
        stmt.close();
        conn.close();
        values.clear();
        conn = QueryTest.getConnection(props);
        stmt = conn.createStatement();
        stmt.execute("create table b1 (c0 int)");
        stmt.execute("create table xx (c1 int, c2 int)");
        stmt.execute("create table b2 (c3 int, c4 int)");
        stmt.execute("insert into b1 values 1");
        stmt.execute("insert into xx values (0, 1)");
        stmt.execute("insert into b2 values (0, 2)");
        r = stmt.executeQuery("select b1.* from b1 JOIN (select * from xx) VW(c1,c2) on (b1.c0 = vw.c2) JOIN b2 on (vw.c1 = b2.c3)");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)1, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        r.close();
        stmt.execute("drop table b2");
        stmt.execute("drop table xx");
        stmt.execute("create table b (c1 int, c2 int, c3 char(1), c4 int, c5 int, c6 int) replicate");
        stmt.execute("create table b2 (c1 int, c2 int, c3 char(1), c4 int, c5 int, c6 int) replicate");
        stmt.execute("create table b4 (c7 int, c4 int, c6 int) replicate");
        stmt.execute("create table b3 (c8 int, c9 int, c5 int, c6 int) replicate ");
        stmt.execute("create view bvw (c5, c1 ,c2 ,c3 ,c4) as select c5, c1 ,c2 ,c3 ,c4 from b2 union select c5, c1 ,c2 ,c3 ,c4 from b");
        stmt.execute("insert into b4 (c7,c4,c6) values (4, 42, 31)");
        stmt.execute("insert into b2 (c5,c1,c3,c4,c6) values (3,4, 'F',43,23)");
        stmt.execute("insert into b3 (c5,c8,c9,c6) values (2,3,19,28)");
        r = stmt.executeQuery("select b3.* from b3 join bvw on (b3.c8 = bvw.c5) join b4 on (bvw.c1 = b4.c7) where b4.c4 = 42");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((String)"319228", (String)("" + r.getInt(1) + r.getInt(2) + r.getInt(3) + r.getInt(4)));
        QueryTest.assertFalse((boolean)r.next());
        r.close();
        stmt.execute("drop table b1");
        stmt.execute("drop view bvw");
        stmt.execute("drop table b2");
        stmt.execute("drop table b");
        stmt.close();
        conn.close();
        conn = QueryTest.getConnection();
        stmt = conn.createStatement();
        stmt.execute("create table b1 (c0 int) REPLICATE");
        stmt.execute("create table xx (c1 int, c2 int)");
        stmt.execute("create table b2 (c3 int, c4 int) REPLICATE");
        stmt.execute("insert into b1 values 1");
        stmt.execute("insert into xx values (0, 1)");
        stmt.execute("insert into b2 values (0, 2)");
        r = stmt.executeQuery("select b1.* from b1 JOIN (select * from xx) VW(ccx1,ccx2) on (b1.c0 = vw.ccx2) JOIN b2 on (vw.ccx1 = b2.c3)");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)1, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        r.close();
        stmt.close();
        conn.close();
        conn = QueryTest.getConnection(props);
        stmt = conn.createStatement();
        stmt.execute("CREATE TABLE APP.T1 (I INTEGER, J INTEGER)");
        stmt.execute("insert into t1 values (1, 2), (2, 4), (3, 6), (4, 8), (5, 10)");
        stmt.execute("CREATE TABLE APP.T2 (I INTEGER, J INTEGER)");
        stmt.execute("insert into t2 values (1, 2), (2, -4), (3, 6), (4, -8), (5, 10)");
        stmt.execute("CREATE TABLE APP.T3 (A INTEGER, B INTEGER)");
        stmt.execute("insert into T3 values (1,1), (2,2), (3,3), (4,4), (6, 24),(7, 28), (8, 32), (9, 36), (10, 40)");
        stmt.execute("insert into t3 (a) values 11, 12, 13, 14, 15, 16, 17, 18, 19, 20");
        stmt.execute("update t3 set b = 2 * a where a > 10");
        stmt.execute("CREATE TABLE APP.T4 (A INTEGER, B INTEGER)");
        stmt.execute("insert into t4 values (3, 12), (4, 16)");
        stmt.execute("insert into t4 (a) values 11, 12, 13, 14, 15, 16, 17, 18, 19, 20");
        stmt.execute("update t4 set b = 2 * a where a > 10");
        stmt.execute("insert into t3 (a) values 21, 22, 23, 24, 25, 26, 27, 28, 29, 30");
        stmt.execute("insert into t3 (a) values 31, 32, 33, 34, 35, 36, 37, 38, 39, 40");
        stmt.execute("insert into t3 (a) values 41, 42, 43, 44, 45, 46, 47, 48, 49, 50");
        stmt.execute("insert into t3 (a) values 51, 52, 53, 54, 55, 56, 57, 58, 59, 60");
        stmt.execute("insert into t3 (a) values 61, 62, 63, 64, 65, 66, 67, 68, 69, 70");
        stmt.execute("insert into t3 (a) values 71, 72, 73, 74, 75, 76, 77, 78, 79, 80");
        stmt.execute("insert into t3 (a) values 81, 82, 83, 84, 85, 86, 87, 88, 89, 90");
        stmt.execute("insert into t3 (a) values 91, 92, 93, 94, 95, 96, 97, 98, 99, 100");
        stmt.execute("update t3 set b = 2 * a where a > 20");
        stmt.execute("insert into t4 (a, b) (select a,b from t3 where a > 20)");
        stmt.execute("insert into t4 (a, b) (select a,b from t3 where a > 20)");
        stmt.execute("insert into t3 (a, b) (select a,b from t4 where a > 20)");
        stmt.execute("insert into t4 (a, b) (select a,b from t3 where a > 20)");
        stmt.execute("insert into t3 (a, b) (select a,b from t4 where a > 20)");
        stmt.execute("insert into t4 (a, b) (select a,b from t3 where a > 20)");
        stmt.execute("insert into t3 (a, b) (select a,b from t4 where a > 20)");
        stmt.execute("insert into t4 (a, b) (select a,b from t3 where a > 20)");
        stmt.execute("insert into t3 (a, b) (select a,b from t4 where a > 20)");
        stmt.execute("insert into t4 (a, b) (select a,b from t3 where a > 20)");
        stmt.execute("insert into t3 (a, b) (select a,b from t4 where a > 20)");
        stmt.execute("insert into t4 (a, b) (select a,b from t3 where a > 20)");
        stmt.execute("insert into t3 (a, b) (select a,b from t4 where a > 20)");
        stmt.execute("insert into t4 (a, b) (select a,b from t3 where a > 20)");
        stmt.execute("insert into t3 (a, b) (select a,b from t4 where a > 60)");
        stmt.execute("create view V1 as select i, j from T1 union select i,j from T2");
        stmt.execute("create view V2 as select a,b from T3 union select a,b from T4");
        r = stmt.executeQuery("select count(*) from V1, V2 where V1.j > 0");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)505, (int)r.getInt(1));
        r.close();
        stmt.close();
        conn.close();
    }

    public void test45937() throws SQLException {
        Connection conn = QueryTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table twenty (x int)");
        stmt.execute("create table hundred (x int generated always as identity, dc int)");
        stmt.execute("create table t1 (id int generated always as identity, two int, twenty int, hundred varchar(3))");
        stmt.execute("insert into t1 (hundred, twenty, two) select cast(char(hundred.x) as varchar(3)), twenty.x, twenty.x from hundred, twenty");
    }

    public void testSelectFromPrimaryKeyAndIndex() throws SQLException {
        int numCust = 200;
        int numOrder = 100;
        int interval = 50;
        int numQueries = 1;
        int expectedRows = interval * numQueries;
        Connection conn = QueryTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        this.createIndex(conn);
        this.loadSampleData(conn, numCust, numOrder);
        QueryTest.assertEquals((String)"Row count did not match", (int)expectedRows, (int)this.selectFromTable(conn, interval, numQueries));
        this.dropTable(conn);
    }

    public void testSelectFrom() throws Exception {
        int numCust = 200;
        int numOrder = 100;
        int interval = 50;
        int numQueries = 1;
        int expectedRows = interval * numQueries;
        QueryTest.setupConnection();
        Connection conn = QueryTest.startNetserverAndGetLocalNetConnection();
        this.createTable(conn);
        this.loadSampleData(conn, numCust, numOrder);
        int countFromTable = this.selectFromTable(conn, interval, numQueries);
        QueryTest.assertEquals((String)"Row count from table did not match", (int)expectedRows, (int)countFromTable);
        this.dropTable(conn);
    }

    public void testSelectFromPrimaryKey() throws SQLException {
        int numCust = 200;
        int numOrder = 100;
        int interval = 50;
        int numQueries = 1;
        int expectedRows = interval * numQueries;
        Connection conn = QueryTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        this.loadSampleData(conn, numCust, numOrder);
        QueryTest.assertEquals((String)"Row count did not match", (int)expectedRows, (int)this.selectFromTable(conn, interval, numQueries));
        this.dropTable(conn);
    }

    public void testSelectFromIndex() throws SQLException {
        int numCust = 200;
        int numOrder = 100;
        int interval = 50;
        int numQueries = 1;
        int expectedRows = interval * numQueries;
        Connection conn = QueryTest.getConnection();
        this.createTable(conn);
        this.createIndex(conn);
        this.loadSampleData(conn, numCust, numOrder);
        int rowsRead = this.selectFromTable(conn, interval, numQueries);
        QueryTest.assertEquals((String)"Row count did not match", (int)expectedRows, (int)rowsRead);
        this.dropTable(conn);
    }

    public void test42809() throws SQLException {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = conn.getMetaData().getTables(null, null, "course".toUpperCase(), new String[]{"TABLE"});
        boolean found = rs.next();
        rs.close();
        if (found) {
            st.execute("drop table course ");
        }
        st.execute("create table course (course_id int, course_name varchar(2048),  primary key(course_id)) ");
        String sql = "insert into course values( ";
        StringBuilder ins = new StringBuilder(sql);
        for (int i = 0; i < 1000; ++i) {
            ins.append(i).append(", '");
            ins.append(TestUtil.numstr(i)).append("' )");
            if (i % 100 == 0) {
                st.execute(ins.toString());
                ins = new StringBuilder(sql);
                continue;
            }
            ins.append(", ( ");
        }
    }

    public void testLocateInGroupBy() throws SQLException {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table t2 (c1 varchar(10))");
        st.execute("insert into t2 values '123 ', 'abc ', '123', 'abc'");
        PreparedStatement ps = conn.prepareStatement("select locate(c1, 'abc') from t2 group by locate(c1, 'abc')");
        java.sql.ResultSet r = ps.executeQuery();
        HashSet<Integer> results = new HashSet<Integer>();
        results.add(0);
        results.add(1);
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)results.remove(r.getObject(1)));
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)results.remove(r.getObject(1)));
        QueryTest.assertFalse((boolean)r.next());
        r.close();
        ps = conn.prepareStatement("select locate(c1, 'abc', 2) from t2 group by locate(c1, 'abc',2)");
        r = ps.executeQuery();
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((Object)r.getObject(1), (Object)0);
        QueryTest.assertFalse((boolean)r.next());
        r.close();
    }

    public void test42854() throws SQLException {
        String[] query;
        Connection conn;
        block5: {
            conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            java.sql.ResultSet rs = conn.getMetaData().getTables(null, null, "course".toUpperCase(), new String[]{"TABLE"});
            boolean found = rs.next();
            rs.close();
            if (found) {
                st.execute("drop table course ");
            }
            st.execute("create table course (course_id int, course_name varchar(2048), course_type varchar(1024),  primary key(course_id)) partition by column(course_id) ");
            String sql = "insert into course values( ";
            StringBuilder ins = new StringBuilder(sql);
            for (int i = 0; i < 1000; ++i) {
                ins.append(i).append(", '");
                ins.append(TestUtil.numstr(i % 10)).append("', '");
                ins.append(TestUtil.numstr(i % 10)).append("' )");
                st.execute(ins.toString());
                ins = new StringBuilder(sql);
            }
            conn.createStatement().execute("create function r() returns double external name 'java.lang.Math.random' language java parameter style java");
            try {
                conn.createStatement().executeQuery("select r(), count(*) from course group by r()");
                QueryTest.fail("Should have failed with exception");
            }
            catch (SQLException sqe) {
                if (sqe.getSQLState().equals("42Y30")) break block5;
                throw sqe;
            }
        }
        java.sql.ResultSet r = conn.createStatement().executeQuery("select count(1) from course group by pi()");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)1000, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        r = conn.createStatement().executeQuery("select count(1) from course group by dsid()");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)1000, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        for (String q : query = new String[]{"select count(1) from course group by ltrim(course_name)", "select count(1) from course group by substr(course_name, 2, 3)"}) {
            this.assertResult(q, conn, true);
            this.assertResult(q, conn, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test42682() throws SQLException {
        Connection conn = QueryTest.getConnection();
        this.createTableWithPrimaryKey(conn);
        this.loadSampleData(conn, 2, 10);
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                private static final long serialVersionUID = 1L;

                public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
                    TestCase.assertTrue((boolean)(qt instanceof CursorNode));
                    TestCase.assertTrue((boolean)(((CursorNode)qt).getResultSetNode() instanceof ScrollInsensitiveResultSetNode));
                    ResultSetNode rn = ((ScrollInsensitiveResultSetNode)((CursorNode)qt).getResultSetNode()).getChildResult();
                    TestCase.assertTrue((boolean)(rn instanceof ProjectRestrictNode));
                    if (!lcc.isConnectionForRemote()) {
                        TestCase.assertTrue((boolean)(((ProjectRestrictNode)rn).getChildResult() instanceof GroupByNode));
                    } else {
                        TestCase.assertTrue((boolean)(((ProjectRestrictNode)rn).getChildResult() instanceof FromBaseTable));
                        FromBaseTable fbt = (FromBaseTable)((ProjectRestrictNode)rn).getChildResult();
                        TestCase.assertTrue((boolean)fbt.isSpecialRegionSize());
                    }
                }

                public void beforeQueryExecution(EmbedStatement stmt, Activation activation) throws SQLException {
                }
            });
            java.sql.ResultSet r = conn.createStatement().executeQuery("select count(*) from orders");
            r.next();
            QueryTest.assertEquals((int)20, (int)r.getInt(1));
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverHolder());
            this.dropTable(conn);
        }
    }

    public void test42917() throws SQLException {
        java.sql.ResultSet r;
        Statement st;
        block32: {
            String res;
            int[] a1s;
            Connection conn = QueryTest.getConnection();
            st = conn.createStatement();
            st.execute("CREATE TABLE D3764A (A1 INTEGER, A2 VARCHAR(10))");
            st.execute("INSERT INTO D3764A (A1) VALUES (1), (2), (3), (4), (5), (6), (5), (3), (1)");
            r = st.executeQuery("SELECT A1 FROM D3764A UNION SELECT COUNT(A1) FROM D3764A");
            while (r.next()) {
                System.out.println(r.getInt(1));
            }
            r.close();
            r = st.executeQuery("select distinct coalesce(a2, char(a1), 'X'), coalesce(a2, 'X', a2), nvl(a2, 'X'), nvl(a2, char(a1)) from D3764A");
            int a1 = 1;
            while (r.next()) {
                QueryTest.assertEquals((int)a1, (int)r.getInt(1));
                QueryTest.assertEquals((String)"X", (String)r.getString(2));
                QueryTest.assertEquals((String)"X", (String)r.getString(3));
                QueryTest.assertEquals((int)a1, (int)r.getInt(4));
                ++a1;
            }
            QueryTest.assertEquals((int)7, (int)a1);
            r = st.executeQuery("select a1, decode(a1, 1, 'one',2, 'two',3, 'three',   'other') from D3764A where a1 < 6 order by a1");
            for (int a1v : a1s = new int[]{1, 1, 2, 3, 3, 4, 5, 5}) {
                QueryTest.assertTrue((boolean)r.next());
                switch (a1v) {
                    case 1: {
                        res = "one";
                        break;
                    }
                    case 2: {
                        res = "two";
                        break;
                    }
                    case 3: {
                        res = "three";
                        break;
                    }
                    default: {
                        res = "other";
                    }
                }
                QueryTest.assertEquals((int)a1v, (int)r.getInt(1));
                QueryTest.assertEquals((String)res, (String)r.getString(2));
            }
            QueryTest.assertFalse((boolean)r.next());
            r = st.executeQuery("select a1, decode(a1, 1, 'one',3, 'three',   'other') from D3764A where a1 < 6 order by a1");
            for (int a1v : a1s) {
                QueryTest.assertTrue((boolean)r.next());
                switch (a1v) {
                    case 1: {
                        res = "one";
                        break;
                    }
                    case 3: {
                        res = "three";
                        break;
                    }
                    default: {
                        res = "other";
                    }
                }
                QueryTest.assertEquals((int)a1v, (int)r.getInt(1));
                QueryTest.assertEquals((String)res, (String)r.getString(2));
            }
            QueryTest.assertFalse((boolean)r.next());
            r = st.executeQuery("select a1, decode(a1, 3, 'three',   'other') from D3764A where a1 < 6 order by a1");
            for (int a1v : a1s) {
                QueryTest.assertTrue((boolean)r.next());
                switch (a1v) {
                    case 3: {
                        res = "three";
                        break;
                    }
                    default: {
                        res = "other";
                    }
                }
                QueryTest.assertEquals((int)a1v, (int)r.getInt(1));
                QueryTest.assertEquals((String)res, (String)r.getString(2));
            }
            QueryTest.assertFalse((boolean)r.next());
            r = st.executeQuery("select a1, decode(a1, 1, 'one',2, 'two',3, 'three') from D3764A where a1 < 6 order by a1");
            for (int a1v : a1s) {
                QueryTest.assertTrue((boolean)r.next());
                switch (a1v) {
                    case 1: {
                        res = "one";
                        break;
                    }
                    case 2: {
                        res = "two";
                        break;
                    }
                    case 3: {
                        res = "three";
                        break;
                    }
                    default: {
                        res = null;
                    }
                }
                QueryTest.assertEquals((int)a1v, (int)r.getInt(1));
                QueryTest.assertEquals((String)res, (String)r.getString(2));
            }
            QueryTest.assertFalse((boolean)r.next());
            r = st.executeQuery("select a1, decode(a1, 1, 'one') from D3764A where a1 < 6 order by a1");
            for (int a1v : a1s) {
                QueryTest.assertTrue((boolean)r.next());
                switch (a1v) {
                    case 1: {
                        res = "one";
                        break;
                    }
                    default: {
                        res = null;
                    }
                }
                QueryTest.assertEquals((int)a1v, (int)r.getInt(1));
                QueryTest.assertEquals((String)res, (String)r.getString(2));
            }
            QueryTest.assertFalse((boolean)r.next());
            try {
                r = st.executeQuery("select a1, decode(a1, 'other') from D3764A where a1 < 6 order by a1");
                QueryTest.fail("expected a syntax error");
            }
            catch (SQLException sqle) {
                if ("42X01".equals(sqle.getSQLState())) break block32;
                throw sqle;
            }
        }
        st.execute("drop table D3764A");
        st.executeUpdate("create table t (i int, s smallint, l bigint, c char(10), v varchar(50), lvc long varchar, d double precision, r real, dt date, t time, ts timestamp, b char(2) for bit data, bv varchar(2) for bit data, lbv long varchar for bit data)");
        st.executeUpdate("insert into t (i) values (null)");
        st.executeUpdate("insert into t (i) values (null)");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (1, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 200, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 2000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'goodbye', 'everyone is here', 'adios, muchachos', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'noone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 100.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 100.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-09-09'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:55:55'), timestamp('1992-01-01 12:30:30'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:55:55'), X'12af', X'0f0f', X'ABCD')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'ffff', X'0f0f', X'1234')");
        st.executeUpdate(" insert into t values (0, 100, 1000000, 'hello', 'everyone is here', 'what the heck do we care?', 200.0e0, 200.0e0, date('1992-01-01'), time('12:30:30'), timestamp('1992-01-01 12:30:30'), X'12af', X'ffff', X'ABCD')");
        r = st.executeQuery(" select ts from t group by ts order by ts");
        String[] expRS = new String[]{"1992-01-01 12:30:30.0", "1992-01-01 12:55:55.0", null};
        int index = 0;
        while (r.next()) {
            if (expRS[index] == null) {
                QueryTest.assertEquals(null, (Object)r.getTimestamp(1));
            } else {
                QueryTest.assertEquals((String)expRS[index], (String)r.getTimestamp(1).toString());
            }
            ++index;
        }
        r.close();
        st.executeUpdate("drop table t");
    }

    public void test42993() throws Exception {
        if (isTransactional) {
            return;
        }
        Connection conn = QueryTest.getConnection();
        conn.createStatement().execute("declare global temporary table session.ztemp ( orderID varchar( 50 ) ) not logged");
        Statement s = conn.createStatement();
        s.execute("insert into session.ztemp values ('1'), ('2'), ('3')");
        java.sql.ResultSet rs = s.executeQuery("select * from session.ztemp order by orderID ");
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertEquals((String)String.valueOf('1'), (String)rs.getString(1));
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertEquals((String)String.valueOf('2'), (String)rs.getString(1));
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertEquals((String)String.valueOf('3'), (String)rs.getString(1));
        QueryTest.assertFalse((boolean)rs.next());
        s.execute("set schema session");
        s.execute("update ztemp set orderID = 'hi' ");
        s.execute("delete from ztemp");
    }

    public void testMultiConnectionTempTable() throws Exception {
        Connection conn1;
        Connection conn2;
        block3: {
            if (isTransactional) {
                return;
            }
            conn2 = QueryTest.getConnection();
            conn1 = QueryTest.getConnection();
            conn1.createStatement().execute("declare global temporary table temp_check ( orderID varchar( 50 ) ) not logged");
            Statement s = conn1.createStatement();
            s.execute("insert into session.temp_check values ('1'), ('2'), ('3')");
            try {
                conn2.createStatement().execute("declare global temporary table temp_check ( orderID varchar( 50 ) ) not logged");
                QueryTest.fail("expected duplicate name creation... if we started to support duplicate name across connections, its okay to fix this");
            }
            catch (SQLException sqle) {
                if ("X0Y32".equals(sqle.getSQLState())) break block3;
                throw sqle;
            }
        }
        conn1.close();
        conn2.createStatement().execute("declare global temporary table temp_check ( orderID varchar( 50 ) ) not logged");
    }

    public void testTemporaryTableAndTransaction() throws Exception {
        if (isTransactional) {
            return;
        }
        Connection conn = QueryTest.getConnection();
        conn.setTransactionIsolation(2);
        conn.createStatement().execute("declare global temporary table temp_check ( orderID varchar( 50 ) ) not logged");
        Statement s = conn.createStatement();
        s.execute("insert into session.temp_check values ('1'), ('2'), ('3')");
        java.sql.ResultSet r = s.executeQuery("select * from session.temp_check");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertFalse((boolean)r.next());
        TableDescriptor t = ((EmbedConnection)conn).getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable("temp_check".toUpperCase());
        QueryTest.assertTrue((t != null && t.getDescriptorName().equalsIgnoreCase("temp_check") ? 1 : 0) != 0);
        conn.rollback();
        TableDescriptor tn = ((EmbedConnection)conn).getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable("temp_check".toUpperCase());
        QueryTest.assertTrue((tn == null ? 1 : 0) != 0);
        conn.close();
        conn = QueryTest.getConnection();
        conn.createStatement().execute("declare global temporary table temp_check ( orderID varchar( 50 ) ) not logged");
        conn.setTransactionIsolation(2);
        s = conn.createStatement();
        s.execute("insert into session.temp_check values ('1'), ('2'), ('3')");
        r = s.executeQuery("select * from session.temp_check");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertFalse((boolean)r.next());
        t = ((EmbedConnection)conn).getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable("temp_check".toUpperCase());
        QueryTest.assertTrue((t != null && t.getDescriptorName().equalsIgnoreCase("temp_check") ? 1 : 0) != 0);
        conn.rollback();
        conn.setTransactionIsolation(0);
        java.sql.ResultSet ch = conn.createStatement().executeQuery("select * from session.temp_check");
        QueryTest.assertFalse((boolean)ch.next());
        conn.close();
        conn = QueryTest.getConnection();
        conn.createStatement().execute("declare global temporary table temp_check ( orderID varchar( 50 ) ) not logged");
        conn.setTransactionIsolation(2);
        s = conn.createStatement();
        s.execute("insert into session.temp_check values ('1'), ('2'), ('3')");
        r = s.executeQuery("select * from session.temp_check");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertFalse((boolean)r.next());
        conn.createStatement().execute("drop table session.temp_check");
        conn.rollback();
        conn.setTransactionIsolation(0);
        java.sql.ResultSet rnone = s.executeQuery("select * from session.temp_check");
        QueryTest.assertFalse((boolean)rnone.next());
        conn.close();
    }

    public void testTemporaryTableAndTransactionWithOperations() throws Exception {
        if (isTransactional) {
            return;
        }
        Connection conn = QueryTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement s = conn.createStatement();
        s.execute("create table txtable (id int primary key, addr varchar(20))");
        for (int id = 1; id <= 100; ++id) {
            s.execute("insert into txtable values (" + id + ", 'addr" + id + "')");
        }
        s.execute("declare global temporary table temp_check ( orderID varchar( 50 ) ) not logged");
        s.execute("insert into session.temp_check values ('1'), ('2'), ('3')");
        java.sql.ResultSet r = s.executeQuery("select count(*) from txtable");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)100, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        r = s.executeQuery("select * from session.temp_check");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertFalse((boolean)r.next());
        TableDescriptor td = ((EmbedConnection)conn).getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable("temp_check".toUpperCase());
        QueryTest.assertTrue((td != null && td.getDescriptorName().equalsIgnoreCase("temp_check") ? 1 : 0) != 0);
        conn.rollback();
        td = ((EmbedConnection)conn).getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable("temp_check".toUpperCase());
        QueryTest.assertNull((Object)td);
        r = s.executeQuery("select count(*) from txtable");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)0, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        conn.commit();
        conn.close();
        conn = QueryTest.getConnection();
        conn.setTransactionIsolation(2);
        s = conn.createStatement();
        for (int id = 1; id <= 100; ++id) {
            s.execute("insert into txtable values (" + id + ",'s" + id + "')");
        }
        s.execute("declare global temporary table temp_check ( orderID varchar( 50 ) ) not logged");
        s.execute("insert into session.temp_check values ('1'), ('2'), ('3')");
        r = s.executeQuery("select count(*) from txtable");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)100, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        r = s.executeQuery("select * from session.temp_check");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertFalse((boolean)r.next());
        td = ((EmbedConnection)conn).getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable("temp_check".toUpperCase());
        QueryTest.assertTrue((td != null && td.getDescriptorName().equalsIgnoreCase("temp_check") ? 1 : 0) != 0);
        conn.commit();
        td = ((EmbedConnection)conn).getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable("temp_check".toUpperCase());
        QueryTest.assertTrue((td != null && td.getDescriptorName().equalsIgnoreCase("temp_check") ? 1 : 0) != 0);
        r = s.executeQuery("select count(*) from txtable");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)100, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        conn.commit();
        conn.close();
    }

    public void testDateTime() throws Exception {
        Connection conn = QueryTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table datetime_family (id int primary key, type_date date, type_time time, type_datetime timestamp)");
        stmt.execute("insert into datetime_family values (1, '2004-10-10', '10:10:10', '2004-10-10 10:10:10'), (2, '2005-10-10', NULL, '2005-10-10 10:10:10')");
        PreparedStatement pstmt = conn.prepareStatement("select * from datetime_family where type_datetime=?");
        pstmt.setTimestamp(1, Timestamp.valueOf("2005-10-10 10:10:10"));
        java.sql.ResultSet rs = pstmt.executeQuery();
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertEquals((int)2, (int)rs.getInt(1));
        QueryTest.assertFalse((boolean)rs.next());
        rs.close();
        pstmt = conn.prepareStatement("select * from datetime_family where type_date=?");
        pstmt.setTimestamp(1, Timestamp.valueOf("2005-10-10 10:10:10"));
        rs = pstmt.executeQuery();
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertEquals((int)2, (int)rs.getInt(1));
        QueryTest.assertFalse((boolean)rs.next());
        rs.close();
        pstmt.setString(1, "2004-10-10 10:10:10");
        rs = pstmt.executeQuery();
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertEquals((int)1, (int)rs.getInt(1));
        QueryTest.assertFalse((boolean)rs.next());
        rs.close();
        pstmt = conn.prepareStatement("select * from datetime_family where type_time=?");
        pstmt.setTimestamp(1, Timestamp.valueOf("2005-10-10 10:10:10"));
        rs = pstmt.executeQuery();
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertEquals((int)1, (int)rs.getInt(1));
        QueryTest.assertFalse((boolean)rs.next());
        rs.close();
        stmt.execute("drop table datetime_family");
        conn.close();
    }

    public void test43206() throws Exception {
        Connection conn = QueryTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table pizza (i int) ");
        java.sql.ResultSet rs = conn.createStatement().executeQuery("select m.ID, m.hostdata from sys.systables t, sys.members m where t.tableschemaname='APP' and t.tablename='PIZZA' and m.hostdata = 'true'");
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select m.ID, m.hostdata from sys.systables t, sys.members m where t.tableschemaname='APP' and t.tablename='PIZZA' and m.hostdata = 1");
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery("select m.ID, m.hostdata from sys.systables t, sys.members m where t.tableschemaname='APP' and t.tablename='PIZZA' and m.hostdata = 1");
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertFalse((boolean)rs.next());
    }

    public void testSemiColonTermination() throws SQLException {
        block5: {
            Connection conn = QueryTest.getConnection();
            Statement s = conn.createStatement();
            s.execute("create table pizza (i int primary key, j varchar(10), x char(10) ) ;");
            s.execute("drop table pizza; ");
            s.execute("create table pizza (i int primary key, j int, x char(10) ) partition by (j);");
            s.execute("drop table pizza; ");
            String createFunction = "CREATE FUNCTION times (value INTEGER )RETURNS INTEGER LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.functions.TestFunctions.times' PARAMETER STYLE JAVA NO SQL RETURNS NULL ON NULL INPUT";
            conn.createStatement().execute(createFunction);
            s.execute("drop function times; ");
            s.execute("create table pizza (i int primary key, j int, x char(10) ) partition by range (j) (values between 1 and 10) redundancy 1;");
            s.execute("insert into pizza values (1, 2, 'x');");
            s.execute("update pizza set x='y';");
            java.sql.ResultSet rs = s.executeQuery("select count(*) from pizza group by substr(x, 1, 1);");
            while (rs.next()) {
            }
            rs = s.executeQuery("select dsid(), count(i) from pizza, sys.members --gemfirexd-properties withSecondaries=true \n;");
            while (rs.next()) {
            }
            rs = s.executeQuery("values current schema;");
            while (rs.next()) {
            }
            s.execute("delete from pizza;");
            try {
                s.execute("insert into pizza values (2, 3, 'u'),(;");
            }
            catch (SQLException e) {
                if ("42x01".equalsIgnoreCase(e.getSQLState())) break block5;
                throw e;
            }
        }
    }

    public void testDeleteWithSubquery() throws SQLException {
        Connection conn = QueryTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table Image (id int primary key, imageId int) ");
        st.execute("insert into Image values (1, 1) , (2, 1), (3, 1), (4, 2) ");
        st.execute("create table JournalArticleImage (articleImageId int primary key, tempImage int )");
        st.execute("insert into JournalArticleImage values (1, 1), (3, 1), (4, 2)");
        st.execute("delete from Image where imageId IN (SELECT articleImageId FROM JournalArticleImage where tempImage = 1)");
    }

    public void test41047() throws SQLException {
        Connection conn = QueryTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table tt1 (CLICOL01 smallint not null,clicol02 smallint, clicol51 blob(1G))");
        conn.commit();
        PreparedStatement pSt = conn.prepareStatement("insert into tt1 values (?,?,?)");
        pSt.setShort(1, (short)500);
        pSt.setShort(2, (short)501);
        pSt.setBytes(3, "404 bit".getBytes());
        pSt.execute();
        java.sql.ResultSet rs = st.executeQuery("select * from tt1");
        QueryTest.assertTrue((boolean)rs.next());
        QueryTest.assertEquals((int)500, (int)rs.getShort(1));
        QueryTest.assertEquals((String)"Second int is supposed to be 501 not 500", (int)501, (int)rs.getShort(2));
        QueryTest.assertFalse((boolean)rs.next());
        pSt.close();
        conn.commit();
    }

    public void test42856_42918_DerbyPartioned() throws SQLException {
        Connection conn = QueryTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ");
        conn.commit();
        PreparedStatement pSt = conn.prepareStatement("Insert into  TESTTABLE1 values(?,?,?)");
        for (int i = 1; i < 4; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, "desc1_" + i);
            pSt.setString(3, "add1_" + i);
            pSt.execute();
        }
        java.sql.ResultSet rs42856 = st.executeQuery("select ID1, DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 = ( select DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 > 'desc1_1' intersect select DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 < 'desc1_3')");
        QueryTest.assertTrue((boolean)rs42856.next());
        QueryTest.assertEquals((int)2, (int)rs42856.getInt(1));
        QueryTest.assertFalse((boolean)rs42856.next());
        java.sql.ResultSet rs42918 = st.executeQuery("SELECT COUNT(ID1) FROM TESTTABLE1 UNION SELECT ID1 FROM TESTTABLE1 where ID1 = 0");
        QueryTest.assertTrue((boolean)rs42918.next());
        QueryTest.assertEquals((int)3, (int)rs42918.getInt(1));
        QueryTest.assertFalse((boolean)rs42918.next());
        pSt.close();
        conn.commit();
    }

    public void test42856_42918_DerbyReplicated() throws SQLException {
        Connection conn = null;
        skipDefaultPartitioned = true;
        conn = QueryTest.getConnection();
        skipDefaultPartitioned = false;
        Statement st = conn.createStatement();
        st.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null)");
        conn.commit();
        PreparedStatement pSt = conn.prepareStatement("Insert into  TESTTABLE1 values(?,?,?)");
        for (int i = 1; i < 4; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, "desc1_" + i);
            pSt.setString(3, "add1_" + i);
            pSt.execute();
        }
        java.sql.ResultSet rs42856 = st.executeQuery("select ID1, DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 = ( select DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 > 'desc1_1' intersect select DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 < 'desc1_3')");
        QueryTest.assertTrue((boolean)rs42856.next());
        QueryTest.assertEquals((int)2, (int)rs42856.getInt(1));
        QueryTest.assertFalse((boolean)rs42856.next());
        java.sql.ResultSet rs42918 = st.executeQuery("SELECT COUNT(ID1) FROM TESTTABLE1 UNION SELECT ID1 FROM TESTTABLE1 where ID1 = 0");
        QueryTest.assertTrue((boolean)rs42918.next());
        QueryTest.assertEquals((int)3, (int)rs42918.getInt(1));
        QueryTest.assertFalse((boolean)rs42918.next());
        pSt.close();
        conn.commit();
    }

    public void test42856_42918_singleDistributedNode() throws SQLException {
        Properties props = new Properties();
        String available_port = String.valueOf(AvailablePort.getRandomAvailablePort((int)1));
        props.setProperty("mcast-port", available_port);
        Connection conn = QueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ");
        conn.commit();
        PreparedStatement pSt = conn.prepareStatement("Insert into  TESTTABLE1 values(?,?,?)");
        for (int i = 1; i < 4; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, "desc1_" + i);
            pSt.setString(3, "add1_" + i);
            pSt.execute();
        }
        try {
            java.sql.ResultSet rs42856 = st.executeQuery("select ID1, DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 = ( select DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 > 'desc1_1' intersect select DESCRIPTION1 from TESTTABLE1 where DESCRIPTION1 < 'desc1_3')");
            rs42856.next();
            QueryTest.fail("Test should fail with feature not supported exception");
        }
        catch (SQLException sqle) {
            QueryTest.assertEquals((String)"0A000", (String)sqle.getSQLState());
        }
        try {
            java.sql.ResultSet rs42918 = st.executeQuery("SELECT COUNT(ID1) FROM TESTTABLE1 UNION SELECT ID1 FROM TESTTABLE1 where ID1 = 0");
            QueryTest.assertTrue((boolean)rs42918.next());
            QueryTest.fail("Test should fail with feature not supported exception");
        }
        catch (SQLException sqle) {
            QueryTest.assertEquals((String)"0A000", (String)sqle.getSQLState());
        }
        pSt.close();
        conn.commit();
    }

    public void test42856_42918_46899_lonerVmNode() throws SQLException {
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(0));
        Connection conn = QueryTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table TESTTABLE1 (ID1 int not null,  DESCRIPTION1 varchar(1024) not null, ADDRESS1 varchar(1024) not null ) ");
        conn.commit();
        PreparedStatement pSt = conn.prepareStatement("Insert into  TESTTABLE1 values(?,?,?)");
        for (int i = 1; i < 4; ++i) {
            pSt.setInt(1, i);
            pSt.setString(2, "desc1_" + i);
            pSt.setString(3, "add1_" + i);
            pSt.execute();
        }
        java.sql.ResultSet rs42918 = st.executeQuery("SELECT COUNT(ID1) FROM TESTTABLE1 UNION SELECT ID1 FROM TESTTABLE1 where ID1 = 0");
        QueryTest.assertTrue((boolean)rs42918.next());
        QueryTest.assertEquals((int)3, (int)rs42918.getInt(1));
        QueryTest.assertFalse((boolean)rs42918.next());
        pSt.close();
        conn.commit();
    }

    public void testDecimalDEFAULT() throws Exception {
        int[] precisions;
        QueryTest.setupConnection();
        int netPort = QueryTest.startNetserverAndReturnPort();
        Connection netConn = TestUtil.getNetConnection(netPort, null, null);
        Statement stmt = netConn.createStatement();
        for (int prec : precisions = new int[]{30, 31, 35, 36, 37, 44, 45, 46, 53, 54, 55, 125, 126, 127}) {
            int id;
            QueryTest.sqlExecute("create table s.defaulttest(id int primary key,  price decimal(" + prec + ", 20) default null, qty int default 0, " + "name varchar(10) default 'none')", true);
            String insertStr = "insert into s.defaulttest (id, price, qty, name) values(?, ?, DEFAULT, DEFAULT)";
            PreparedStatement insertStmt = netConn.prepareStatement(insertStr);
            StringBuilder decP = new StringBuilder();
            for (int i = 1; i <= (prec - 20) / 2; ++i) {
                decP.append("20");
            }
            String decPrefix = decP.append('.').toString();
            for (id = 1; id < 5; ++id) {
                insertStmt.setInt(1, id);
                if (id == 1) {
                    insertStmt.setBigDecimal(2, BigDecimal.ZERO);
                } else if (id == 2) {
                    insertStmt.setBigDecimal(2, new BigDecimal("0.000"));
                } else {
                    insertStmt.setBigDecimal(2, new BigDecimal(decPrefix + id));
                }
                QueryTest.assertEquals((int)1, (int)insertStmt.executeUpdate());
            }
            for (id = 5; id < 10; ++id) {
                QueryTest.assertEquals((int)1, (int)stmt.executeUpdate("insert into s.defaulttest (id, price, qty, name) values(" + id + ", " + new BigDecimal(decPrefix + id) + ", DEFAULT, DEFAULT)"));
            }
            insertStmt = netConn.prepareStatement("insert into s.defaulttest values(?, DEFAULT, DEFAULT, ?)");
            for (id = 10; id < 15; ++id) {
                insertStmt.setInt(1, id);
                insertStmt.setString(2, "name_" + id);
                QueryTest.assertEquals((int)1, (int)insertStmt.executeUpdate());
            }
            for (id = 15; id < 20; ++id) {
                QueryTest.assertEquals((int)1, (int)stmt.executeUpdate("insert into s.defaulttest values(" + id + ", DEFAULT, DEFAULT, 'name_" + id + "')"));
            }
            java.sql.ResultSet rs = stmt.executeQuery("select * from s.defaulttest order by id");
            for (int id2 = 1; id2 < 20; ++id2) {
                QueryTest.assertTrue((boolean)rs.next());
                QueryTest.assertEquals((int)id2, (int)rs.getInt(1));
                if (id2 == 1) {
                    QueryTest.assertEquals((Object)BigDecimal.ZERO.setScale(20), (Object)rs.getBigDecimal(2));
                    QueryTest.assertEquals((String)"none", (String)rs.getString(4));
                } else if (id2 == 2) {
                    QueryTest.assertEquals((Object)new BigDecimal("0.000").setScale(20), (Object)rs.getBigDecimal(2));
                    QueryTest.assertEquals((String)"none", (String)rs.getString(4));
                } else if (id2 < 10) {
                    QueryTest.assertEquals((Object)new BigDecimal(decPrefix + id2).setScale(20), (Object)rs.getBigDecimal(2));
                    QueryTest.assertEquals((String)"none", (String)rs.getString(4));
                } else {
                    QueryTest.assertNull((Object)rs.getBigDecimal(2));
                    QueryTest.assertNull((Object)rs.getString(2));
                    QueryTest.assertEquals((String)("name_" + id2), (String)rs.getString(4));
                }
                QueryTest.assertEquals((int)0, (int)rs.getInt(3));
            }
            QueryTest.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select distinct avg(price) from s.defaulttest");
            QueryTest.assertTrue((boolean)rs.next());
            BigDecimal sum = BigDecimal.ZERO;
            for (int id3 = 3; id3 < 10; ++id3) {
                sum = sum.add(new BigDecimal(decPrefix + id3));
            }
            QueryTest.assertEquals((Object)sum.divide(new BigDecimal(9), 20, RoundingMode.DOWN), (Object)rs.getBigDecimal(1));
            QueryTest.assertFalse((boolean)rs.next());
            stmt.execute("drop table s.defaulttest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGroupingOptimizationForGroupByClause_1() throws Exception {
        GemFireXDQueryObserver old;
        Statement derbyStmt;
        Statement stmt;
        block22: {
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
            stmt = null;
            String query = "select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1";
            Connection conn = null;
            derbyStmt = null;
            String table = "create table txhistory(cid int,  sid int, qty int)";
            String index = "create index txhistory_sid on txhistory(sid)";
            ArrayList throwables = new ArrayList();
            old = null;
            try {
                String tempDerbyUrl = "jdbc:derby:newDB;create=true;";
                if (currentUserName != null) {
                    tempDerbyUrl = tempDerbyUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
                }
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                String derbyDbUrl = tempDerbyUrl;
                Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                derbyStmt.execute(table);
                derbyStmt.execute(index);
                Statement derbyStmt1 = derbyConn.createStatement();
                conn = TestUtil.getConnection();
                stmt = conn.createStatement();
                stmt.execute(table + " replicate");
                stmt.execute(index);
                PreparedStatement ps_insert_derby = derbyConn.prepareStatement("insert into txhistory values(?,?,?)");
                PreparedStatement ps_insert_gfxd = conn.prepareStatement("insert into txhistory values(?,?,?)");
                ps_insert_derby.setInt(1, 1);
                ps_insert_derby.setInt(2, 1);
                ps_insert_derby.setInt(3, 100);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 1);
                ps_insert_gfxd.setInt(2, 1);
                ps_insert_gfxd.setInt(3, 100);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 11);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 300);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 11);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 300);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 22);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 600);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 22);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 600);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 3);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 900);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 3);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 900);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 6);
                ps_insert_derby.setInt(2, 4);
                ps_insert_derby.setInt(3, 2400);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 6);
                ps_insert_gfxd.setInt(2, 4);
                ps_insert_gfxd.setInt(3, 2400);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 12);
                ps_insert_derby.setInt(2, 4);
                ps_insert_derby.setInt(3, 4800);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 12);
                ps_insert_gfxd.setInt(2, 4);
                ps_insert_gfxd.setInt(3, 4800);
                ps_insert_gfxd.executeUpdate();
                PreparedStatement derbyQueryStmt = derbyConn.prepareStatement("select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1");
                PreparedStatement stmtQuery = conn.prepareStatement("select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1");
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private static final long serialVersionUID = 1L;

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, ResultSet theResults) {
                        NoPutResultSet noputrs = (NoPutResultSet)theResults;
                        TestCase.assertTrue((boolean)noputrs.supportsMoveToNextKey());
                    }
                });
                int cid = 10;
                int sid = 100;
                stmtQuery.setInt(1, cid);
                stmtQuery.setInt(2, sid);
                derbyQueryStmt.setInt(1, cid);
                derbyQueryStmt.setInt(2, sid);
                QueryTest.validateResults(derbyQueryStmt, stmtQuery, "select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1", false);
                ps_insert_derby.close();
                derbyQueryStmt.close();
                if (derbyStmt == null) break block22;
            }
            catch (Exception e) {
                e.printStackTrace();
                QueryTest.fail("Test failed because of exception " + e);
                return;
            }
            try {
                derbyStmt.execute("drop table txhistory");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stmt != null) {
            try {
                stmt.execute("drop table txhistory");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (old == null) return;
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        return;
        finally {
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table txhistory");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGroupingOptimizationForGroupByClause_2() throws Exception {
        GemFireXDQueryObserver old;
        Statement derbyStmt;
        Statement stmt;
        block22: {
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
            stmt = null;
            String query = "select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1";
            Connection conn = null;
            derbyStmt = null;
            String table = "create table txhistory(cid int,  sid int, qty int)";
            String index = "create index txhistory_sid_cid on txhistory(sid, cid)";
            ArrayList throwables = new ArrayList();
            old = null;
            try {
                String tempDerbyUrl = "jdbc:derby:newDB;create=true;";
                if (currentUserName != null) {
                    tempDerbyUrl = tempDerbyUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
                }
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                String derbyDbUrl = tempDerbyUrl;
                Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                derbyStmt.execute(table);
                derbyStmt.execute(index);
                Statement derbyStmt1 = derbyConn.createStatement();
                conn = TestUtil.getConnection();
                stmt = conn.createStatement();
                stmt.execute(table + " replicate");
                stmt.execute(index);
                PreparedStatement ps_insert_derby = derbyConn.prepareStatement("insert into txhistory values(?,?,?)");
                PreparedStatement ps_insert_gfxd = conn.prepareStatement("insert into txhistory values(?,?,?)");
                ps_insert_derby.setInt(1, 1);
                ps_insert_derby.setInt(2, 1);
                ps_insert_derby.setInt(3, 100);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 1);
                ps_insert_gfxd.setInt(2, 1);
                ps_insert_gfxd.setInt(3, 100);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 11);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 300);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 11);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 300);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 22);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 600);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 22);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 600);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 3);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 900);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 3);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 900);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 6);
                ps_insert_derby.setInt(2, 4);
                ps_insert_derby.setInt(3, 2400);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 6);
                ps_insert_gfxd.setInt(2, 4);
                ps_insert_gfxd.setInt(3, 2400);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 12);
                ps_insert_derby.setInt(2, 4);
                ps_insert_derby.setInt(3, 4800);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 12);
                ps_insert_gfxd.setInt(2, 4);
                ps_insert_gfxd.setInt(3, 4800);
                ps_insert_gfxd.executeUpdate();
                PreparedStatement derbyQueryStmt = derbyConn.prepareStatement("select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1");
                PreparedStatement stmtQuery = conn.prepareStatement("select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1");
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private static final long serialVersionUID = 1L;

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, ResultSet theResults) {
                        NoPutResultSet noputrs = (NoPutResultSet)theResults;
                        TestCase.assertFalse((boolean)noputrs.supportsMoveToNextKey());
                    }
                });
                int cid = 10;
                int sid = 100;
                stmtQuery.setInt(1, cid);
                stmtQuery.setInt(2, sid);
                derbyQueryStmt.setInt(1, cid);
                derbyQueryStmt.setInt(2, sid);
                QueryTest.validateResults(derbyQueryStmt, stmtQuery, "select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1", false);
                ps_insert_derby.close();
                derbyQueryStmt.close();
                if (derbyStmt == null) break block22;
            }
            catch (Exception e) {
                e.printStackTrace();
                QueryTest.fail("Test failed because of exception " + e);
                return;
            }
            try {
                derbyStmt.execute("drop table txhistory");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (stmt != null) {
            try {
                stmt.execute("drop table txhistory");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (old == null) return;
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        return;
        finally {
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table txhistory");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (stmt != null) {
                try {
                    stmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGroupingOptimizationForGroupByClause_3() throws Exception {
        GemFireXDQueryObserver old;
        Statement derbyStmt;
        Statement stmt;
        block22: {
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
            stmt = null;
            String query = "select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1";
            Connection conn = null;
            derbyStmt = null;
            String table = "create table txhistory(cid int,  sid int, qty int)";
            ArrayList throwables = new ArrayList();
            old = null;
            try {
                String tempDerbyUrl2332 = "jdbc:derby:newDB;create=true;";
                if (currentUserName != null) {
                    tempDerbyUrl2332 = tempDerbyUrl2332 + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
                }
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                String derbyDbUrl = tempDerbyUrl2332;
                Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                derbyStmt.execute(table);
                Statement derbyStmt1 = derbyConn.createStatement();
                conn = TestUtil.getConnection();
                stmt = conn.createStatement();
                stmt.execute(table + " replicate");
                PreparedStatement ps_insert_derby = derbyConn.prepareStatement("insert into txhistory values(?,?,?)");
                PreparedStatement ps_insert_gfxd = conn.prepareStatement("insert into txhistory values(?,?,?)");
                ps_insert_derby.setInt(1, 1);
                ps_insert_derby.setInt(2, 1);
                ps_insert_derby.setInt(3, 100);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 1);
                ps_insert_gfxd.setInt(2, 1);
                ps_insert_gfxd.setInt(3, 100);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 11);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 300);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 11);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 300);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 22);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 600);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 22);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 600);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 3);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 900);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 3);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 900);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 6);
                ps_insert_derby.setInt(2, 4);
                ps_insert_derby.setInt(3, 2400);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 6);
                ps_insert_gfxd.setInt(2, 4);
                ps_insert_gfxd.setInt(3, 2400);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 12);
                ps_insert_derby.setInt(2, 4);
                ps_insert_derby.setInt(3, 4800);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 12);
                ps_insert_gfxd.setInt(2, 4);
                ps_insert_gfxd.setInt(3, 4800);
                ps_insert_gfxd.executeUpdate();
                PreparedStatement derbyQueryStmt = derbyConn.prepareStatement("select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1");
                PreparedStatement stmtQuery = conn.prepareStatement("select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1");
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private static final long serialVersionUID = 1L;

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, ResultSet theResults) {
                        NoPutResultSet noputrs = (NoPutResultSet)theResults;
                        TestCase.assertFalse((boolean)noputrs.supportsMoveToNextKey());
                    }
                });
                int cid = 10;
                int sid = 100;
                stmtQuery.setInt(1, cid);
                stmtQuery.setInt(2, sid);
                derbyQueryStmt.setInt(1, cid);
                derbyQueryStmt.setInt(2, sid);
                QueryTest.validateResults(derbyQueryStmt, stmtQuery, "select sid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid HAVING count(*) >=1", false);
                ps_insert_derby.close();
                derbyQueryStmt.close();
                if (derbyStmt == null) break block22;
            }
            catch (Exception e) {
                e.printStackTrace();
                QueryTest.fail("Test failed because of exception " + e);
                return;
            }
            try {
                derbyStmt.execute("drop table txhistory");
            }
            catch (Exception tempDerbyUrl2332) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.execute("drop table txhistory");
            }
            catch (Exception tempDerbyUrl2332) {
                // empty catch block
            }
        }
        if (old == null) return;
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        return;
        finally {
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testGroupingOptimizationForGroupByClause_4() throws Exception {
        GemFireXDQueryObserver old;
        Statement derbyStmt;
        Statement stmt;
        block22: {
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
            stmt = null;
            String query = "select sid,cid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid , cid HAVING count(*) >=1";
            Connection conn = null;
            derbyStmt = null;
            String table = "create table txhistory(cid int,  sid int, qty int)";
            String index = "create index txhistory_sid_cid on txhistory(sid, cid)";
            ArrayList throwables = new ArrayList();
            old = null;
            try {
                String tempDerbyUrl2332 = "jdbc:derby:newDB;create=true;";
                if (currentUserName != null) {
                    tempDerbyUrl2332 = tempDerbyUrl2332 + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
                }
                Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
                String derbyDbUrl = tempDerbyUrl2332;
                Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
                derbyStmt = derbyConn.createStatement();
                derbyStmt.execute(table);
                derbyStmt.execute(index);
                Statement derbyStmt1 = derbyConn.createStatement();
                conn = TestUtil.getConnection();
                stmt = conn.createStatement();
                stmt.execute(table + " replicate");
                stmt.execute(index);
                PreparedStatement ps_insert_derby = derbyConn.prepareStatement("insert into txhistory values(?,?,?)");
                PreparedStatement ps_insert_gfxd = conn.prepareStatement("insert into txhistory values(?,?,?)");
                ps_insert_derby.setInt(1, 1);
                ps_insert_derby.setInt(2, 1);
                ps_insert_derby.setInt(3, 100);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 1);
                ps_insert_gfxd.setInt(2, 1);
                ps_insert_gfxd.setInt(3, 100);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 11);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 300);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 11);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 300);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 22);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 600);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 22);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 600);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 3);
                ps_insert_derby.setInt(2, 3);
                ps_insert_derby.setInt(3, 900);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 3);
                ps_insert_gfxd.setInt(2, 3);
                ps_insert_gfxd.setInt(3, 900);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 6);
                ps_insert_derby.setInt(2, 4);
                ps_insert_derby.setInt(3, 2400);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 6);
                ps_insert_gfxd.setInt(2, 4);
                ps_insert_gfxd.setInt(3, 2400);
                ps_insert_gfxd.executeUpdate();
                ps_insert_derby.setInt(1, 12);
                ps_insert_derby.setInt(2, 4);
                ps_insert_derby.setInt(3, 4800);
                ps_insert_derby.executeUpdate();
                ps_insert_gfxd.setInt(1, 12);
                ps_insert_gfxd.setInt(2, 4);
                ps_insert_gfxd.setInt(3, 4800);
                ps_insert_gfxd.executeUpdate();
                PreparedStatement derbyQueryStmt = derbyConn.prepareStatement("select sid,cid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid , cid HAVING count(*) >=1");
                PreparedStatement stmtQuery = conn.prepareStatement("select sid,cid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid , cid HAVING count(*) >=1");
                old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
                    private static final long serialVersionUID = 1L;

                    public void onEmbedResultSetMovePosition(EmbedResultSet rs, ExecRow newRow, ResultSet theResults) {
                        NoPutResultSet noputrs = (NoPutResultSet)theResults;
                        TestCase.assertTrue((boolean)noputrs.supportsMoveToNextKey());
                    }
                });
                int cid = 10;
                int sid = 100;
                stmtQuery.setInt(1, cid);
                stmtQuery.setInt(2, sid);
                derbyQueryStmt.setInt(1, cid);
                derbyQueryStmt.setInt(2, sid);
                QueryTest.validateResults(derbyQueryStmt, stmtQuery, "select sid,cid, count(*) from txhistory  where cid > ? and sid < ?  GROUP BY sid , cid HAVING count(*) >=1", false);
                ps_insert_derby.close();
                derbyQueryStmt.close();
                if (derbyStmt == null) break block22;
            }
            catch (Exception e) {
                e.printStackTrace();
                QueryTest.fail("Test failed because of exception " + e);
                return;
            }
            try {
                derbyStmt.execute("drop table txhistory");
            }
            catch (Exception tempDerbyUrl2332) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.execute("drop table txhistory");
            }
            catch (Exception tempDerbyUrl2332) {
                // empty catch block
            }
        }
        if (old == null) return;
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
        return;
        finally {
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance(old);
            }
        }
    }

    public void DISABLE_testOrList_45041() throws Exception {
        QueryTest.setupConnection();
        Connection conn = jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table test1 (id int primary key, name varchar(100) not null)");
        stmt.execute("create index idx1 on test1(name)");
        for (int id = 1; id < 100; ++id) {
            stmt.execute("insert into test1 values (" + id + ", 'name" + id + "')");
        }
        TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        java.sql.ResultSet rs = stmt.executeQuery("select * from test1 where name < 'name5' or name > 'name90' order by id");
        int i = 1;
        while (rs.next()) {
            if (i == 5) {
                i = 10;
            } else if (i == 50) {
                i = 91;
            }
            QueryTest.assertEquals((int)i, (int)rs.getInt(1));
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(2));
            ++i;
        }
        QueryTest.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select id from test1 where name < 'name5' or name > 'name90' order by name");
        i = 1;
        while (rs.next()) {
            if (i > 1) {
                if (i <= 5) {
                    i = (i - 1) * 10;
                } else if (i % 10 == 0 && i < 50) {
                    i /= 10;
                } else if (i == 50) {
                    i = 91;
                }
            }
            QueryTest.assertEquals((int)i, (int)rs.getInt(1));
            ++i;
        }
        QueryTest.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name from test1 where name < 'name5' or name > 'name90' order by name");
        i = 1;
        while (rs.next()) {
            if (i > 1) {
                if (i <= 5) {
                    i = (i - 1) * 10;
                } else if (i % 10 == 0 && i < 50) {
                    i /= 10;
                } else if (i == 50) {
                    i = 91;
                }
            }
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(1));
            ++i;
        }
        QueryTest.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name, id from test1 where name < 'name5' or name > 'name90' order by name");
        i = 1;
        while (rs.next()) {
            if (i > 1) {
                if (i <= 5) {
                    i = (i - 1) * 10;
                } else if (i % 10 == 0 && i < 50) {
                    i /= 10;
                } else if (i == 50) {
                    i = 91;
                }
            }
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(1));
            QueryTest.assertEquals((int)i, (int)rs.getInt(2));
            ++i;
        }
        QueryTest.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name from test1 where name < 'name5' or name > 'name90' order by id");
        i = 1;
        while (rs.next()) {
            if (i == 5) {
                i = 10;
            } else if (i == 50) {
                i = 91;
            }
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(1));
            ++i;
        }
        QueryTest.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name, id from test1 where name < 'name5' or name > 'name90' order by id");
        i = 1;
        while (rs.next()) {
            if (i == 5) {
                i = 10;
            } else if (i == 50) {
                i = 91;
            }
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(1));
            QueryTest.assertEquals((int)i, (int)rs.getInt(2));
            ++i;
        }
        QueryTest.assertEquals((int)100, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        Object[][] expectedRows = new Object[][]{{7, "name7"}, {8, "name8"}, {9, "name9"}, {61, "name61"}, {62, "name62"}, {63, "name63"}, {64, "name64"}, {65, "name65"}, {66, "name66"}, {67, "name67"}, {68, "name68"}, {69, "name69"}, {70, "name70"}, {71, "name71"}, {72, "name72"}, {73, "name73"}, {74, "name74"}, {75, "name75"}, {76, "name76"}, {77, "name77"}, {78, "name78"}, {79, "name79"}, {80, "name80"}, {81, "name81"}, {82, "name82"}, {83, "name83"}, {84, "name84"}, {85, "name85"}, {86, "name86"}, {87, "name87"}, {88, "name88"}, {89, "name89"}};
        rs = stmt.executeQuery("select id from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90') order by id");
        i = 7;
        while (rs.next()) {
            if (i == 10) {
                i = 61;
            }
            QueryTest.assertEquals((int)i, (int)rs.getInt(1));
            ++i;
        }
        QueryTest.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90') order by id");
        i = 7;
        while (rs.next()) {
            if (i == 10) {
                i = 61;
            }
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(1));
            ++i;
        }
        QueryTest.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name, id from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90') order by id");
        i = 7;
        while (rs.next()) {
            if (i == 10) {
                i = 61;
            }
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(1));
            QueryTest.assertEquals((int)i, (int)rs.getInt(2));
            ++i;
        }
        QueryTest.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select id, name from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90')");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select * from test1 where (name < 'name80' and name > 'name60') or (name > 'name70' and name < 'name90')");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.SORTEDMAPINDEX);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name from test1 where (name < 'name80' and id > 60) or (name > 'name70' and id < 90) order by id");
        i = 8;
        while (rs.next()) {
            if (i == 10) {
                i = 61;
            }
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(1));
            ++i;
        }
        QueryTest.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.TABLE);
        observer.checkAndClear();
        rs = stmt.executeQuery("select name, id from test1 where (name < 'name80' and id > 60) or (id > 70 and name < 'name90') order by id");
        i = 61;
        while (rs.next()) {
            QueryTest.assertEquals((String)("name" + i), (String)rs.getString(1));
            QueryTest.assertEquals((int)i, (int)rs.getInt(2));
            ++i;
        }
        QueryTest.assertEquals((int)90, (int)i);
        observer.addExpectedScanType(QueryTest.getCurrentDefaultSchemaName() + ".TEST1", TestUtil.ScanType.TABLE);
        observer.checkAndClear();
    }

    public void test45509() throws Exception {
        Properties cp = new Properties();
        cp.setProperty("mcast-port", Integer.toString(AvailablePort.getRandomAvailablePort((int)1)));
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create table course (course_id int, i int,  primary key(course_id)) partition by column (i) redundancy 1");
        st.execute("insert into course values (1, 1), (2, 2), (3, 1), (4, 3), (5, 1)");
        String myId = Misc.getGemFireCache().getMyId().toString();
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){
            private static final long serialVersionUID = 1L;

            public void regionSizeOptimizationTriggered(FromBaseTable fbt, SelectNode selectNode) {
                TestCase.assertTrue((boolean)selectNode.convertCountToRegionSize());
                TestCase.assertTrue((fbt.getResultColumns().size() <= 1 ? 1 : 0) != 0);
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        java.sql.ResultSet r = st.executeQuery("select count(*) from course -- GEMFIREXD-PROPERTIES withSecondaries=true\n");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)5, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        r = st.executeQuery("select dsid(), count(*) from course");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((String)myId, (String)r.getString(1));
        QueryTest.assertEquals((int)5, (int)r.getInt(2));
        QueryTest.assertFalse((boolean)r.next());
        r = st.executeQuery("select dsid(), count(*) from course group by dsid()");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((String)myId, (String)r.getString(1));
        QueryTest.assertEquals((int)5, (int)r.getInt(2));
        QueryTest.assertFalse((boolean)r.next());
        r = st.executeQuery("select count(*), dsid(), count(*) from course group by dsid() having count(*) > 1");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)5, (int)r.getInt(1));
        QueryTest.assertEquals((String)myId, (String)r.getString(2));
        QueryTest.assertEquals((int)5, (int)r.getInt(3));
        QueryTest.assertFalse((boolean)r.next());
        r = st.executeQuery("select count(*) from course group by dsid() having count(*) > 1");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)5, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
        r = st.executeQuery("select count(*) from course group by dsid() having count(*) <= 0 or count(*) > 5");
        QueryTest.assertFalse((boolean)r.next());
        r = st.executeQuery("select count(*) from course group by dsid()");
        QueryTest.assertTrue((boolean)r.next());
        QueryTest.assertEquals((int)5, (int)r.getInt(1));
        QueryTest.assertFalse((boolean)r.next());
    }

    public void test49829() throws SQLException {
        Properties cp = new Properties();
        cp.setProperty("mcast-port", Integer.toString(AvailablePort.getRandomAvailablePort((int)1)));
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create table FDC_NRT_CNTXT_HIST (EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL,  primary key(eqp_id, cntxt_id, stop_dt) ) partition by column (eqp_id, cntxt_id, stop_dt)");
        st.execute("insert into FDC_NRT_CNTXT_HIST values  ('1', 1, '2014-01-24 18:48:00'),('2', 1, '2014-01-24 18:48:00'),('3', 1, '2014-01-24 18:48:00'),('4', 1, '2014-01-24 18:48:00'),('5', 1, '2014-01-24 18:48:00'),('6', 1, '2014-01-24 18:48:00'),('7', 1, '2014-01-24 18:48:00'),('8', 1, '2014-01-24 18:48:00'),('9', 1, '2014-01-24 18:48:00'),('10', 1, '2014-01-24 18:48:00'),('11', 1, '2014-01-24 18:48:00'),('12', 1, '2014-01-24 18:48:00'),('13', 1, '2014-01-24 18:48:00')");
        st.execute("create table FDC_NRT_TCHART_HIST (EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL, SVID_NAME VARCHAR(64) NOT NULL,  primary key(eqp_id, cntxt_id, stop_dt, svid_name) ) partition by column (eqp_id, cntxt_id, stop_dt) COLOCATE WITH (FDC_NRT_CNTXT_HIST)");
        st.execute("insert into FDC_NRT_TCHART_HIST values  ('1', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('2', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('3', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('4', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('5', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('6', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('7', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('8', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('9', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('10', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('11', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('12', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59'),('13', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59')");
        st.execute("create table FDC_NRT_PUMPER_HIST_LOG ( EQP_ID VARCHAR(40) NOT NULL, CNTXT_ID INTEGER NOT NULL, STOP_DT TIMESTAMP NOT NULL, UPDATE_DT TIMESTAMP NOT NULL, EXEC_TIME DOUBLE, primary key (eqp_id, cntxt_id, stop_dt, update_dt) ) partition by primary key");
        st.execute("insert into FDC_NRT_PUMPER_HIST_LOG values  ('1', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('2', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('3', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('4', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('5', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('6', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('7', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('8', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('9', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('10', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('11', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('12', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41),('13', 1, '2014-01-24 18:48:00', '2014-01-24 18:47:59', 41)");
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){
            private static final long serialVersionUID = 1L;

            public void regionSizeOptimizationTriggered(FromBaseTable fbt, SelectNode selectNode) {
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        java.sql.ResultSet r = st.executeQuery("explain select a.eqp_id, a.cntxt_id, a.stop_dt, dsid() as datanode_id from FDC_NRT_CNTXT_HIST a left join FDC_NRT_TCHART_HIST b on (a.eqp_id =b.eqp_id and a.cntxt_id=b.cntxt_id and a.stop_dt=b.stop_dt) where a.eqp_id||cast(a.cntxt_id as char(100)) in ( select eqp_id||cast(t.cntxt_id as char(100)) from FDC_NRT_PUMPER_HIST_LOG t where 1=1 and exec_time > 40 and stop_dt > '2014-01-24 18:47:59' and stop_dt < '2014-01-24 18:49:59')");
        while (r.next()) {
            System.out.println(r.getString(1));
        }
    }

    private void assertResult(String query, Connection conn, boolean prepare) throws SQLException {
        java.sql.ResultSet r;
        if (prepare) {
            PreparedStatement ps = conn.prepareStatement(query);
            r = ps.executeQuery();
        } else {
            r = conn.createStatement().executeQuery(query);
        }
        int numrows = 0;
        while (r.next()) {
            QueryTest.assertEquals((int)100, (int)r.getInt(1));
            System.out.println(r.getInt(1));
            ++numrows;
        }
        QueryTest.assertEquals((int)10, (int)numrows);
        r.close();
    }

    public int selectFromTable(Connection conn, int retrievalSize, int numQueries) throws SQLException {
        Random rand = new Random(System.currentTimeMillis());
        int count = 0;
        int startLoc = rand.nextInt(5000);
        PreparedStatement q = conn.prepareStatement("Select * from Orders where vol > ? and vol < ?");
        for (int i = startLoc; i < startLoc + numQueries; ++i) {
            count += this.selectFromTable(conn, q, i, retrievalSize);
        }
        return count;
    }

    private int selectFromTable(Connection conn, PreparedStatement q, int from, int retrievalSize) throws SQLException {
        int count = 0;
        q.setInt(1, from);
        q.setInt(2, from + retrievalSize + 1);
        java.sql.ResultSet rs = q.executeQuery();
        while (rs.next()) {
            ++count;
        }
        QueryTest.assertEquals((String)"Row count for single query did not match;", (int)retrievalSize, (int)count);
        return count;
    }

    public int selectFromRegion(int retrievalSize, int expectedRegionSize) throws Exception {
        System.out.println("Running query directly on region...");
        Random rand = new Random(System.currentTimeMillis());
        int count = 0;
        int startLoc = rand.nextInt(5000);
        Region region = Misc.getRegionForTable((String)(QueryTest.getCurrentDefaultSchemaName() + ".ORDERS"), (boolean)true);
        QueryTest.assertEquals((String)"region size;", (int)expectedRegionSize, (int)region.size());
        int i = startLoc;
        int iCount = 0;
        Iterator itr = region.values().iterator();
        while (itr.hasNext()) {
            int vol = this.getIntFromDataValue(itr.next(), 2);
            int from = i;
            int to = i + retrievalSize + 1;
            if (vol <= from || vol >= to) continue;
            ++count;
            ++iCount;
        }
        QueryTest.assertEquals((String)"Row count for single query did not match. ", (int)retrievalSize, (int)iCount);
        return count;
    }

    public void clearTable(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("delete from orders");
        s.close();
    }

    public void dropTable(Connection conn) throws SQLException {
        if (conn.isClosed()) {
            return;
        }
        Statement s = conn.createStatement();
        try {
            s.execute("drop table orders");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        s.close();
    }

    public void createTable(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        DatabaseMetaData dbmd = conn.getMetaData();
        java.sql.ResultSet rs = dbmd.getTables(null, null, "orders".toUpperCase(), new String[]{"TABLE"});
        QueryTest.assertTrue((boolean)dbmd.othersInsertsAreVisible(1003));
        QueryTest.assertTrue((boolean)dbmd.othersDeletesAreVisible(1003));
        boolean found = rs.next();
        rs.close();
        if (found) {
            s.execute("drop table orders ");
        }
        s.execute("create table orders(id int not null , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createTableWithPrimaryKey(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int PRIMARY KEY, cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.close();
    }

    public void createIndex(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create index volumeIdx on orders(vol)");
        s.close();
    }

    public void loadSampleData(Connection conn, int numOfCustomers, int numOrdersPerCustomer) throws SQLException {
        System.out.println("Loading data (" + numOfCustomers * numOrdersPerCustomer + " rows)...");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        Random rand = new Random(System.currentTimeMillis());
        PreparedStatement psInsert = conn.prepareStatement("insert into orders values (?, ?, ?, ?, ?, ?)");
        int volNum = 0;
        for (int i = 0; i < numOfCustomers; ++i) {
            int baseId = i * numOrdersPerCustomer;
            String custName = "CustomerWithaLongName" + i;
            for (int j = 0; j < numOrdersPerCustomer; ++j) {
                psInsert.setInt(1, baseId + j);
                psInsert.setString(2, custName);
                psInsert.setInt(3, volNum++);
                psInsert.setString(4, securities[rand.nextInt(10)]);
                psInsert.setInt(5, 0);
                String queryString = "Emperors club for desperate men, Washington DC, District of Columbia";
                psInsert.setString(6, queryString);
                psInsert.executeUpdate();
            }
        }
    }

    public void test49291() throws Exception {
        Connection conn = QueryTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.test ( id int , name varchar(10))");
        st.execute("insert into trade.test values (1, 'tina')");
        st.execute("insert into trade.test values (2, 'mina')");
        st.execute("insert into trade.test values (null, 'jhk')");
        st.execute("insert into trade.test values (null, 'jhiok')");
        st.execute("insert into trade.test values (3, null)");
        st.execute("insert into trade.test values (4, null)");
        st.execute("insert into trade.test values (5, null)");
        st.execute("select * from trade.test where name = nvl('dada' , 'abc')");
        st.execute("select * from trade.test where name = nvl('' , 'abc')");
        st.execute("delete from trade.test where nvl('' , 'tina') = nvl(name, 'abc')");
        st.execute("delete from trade.test where nvl(name , 'abc') = nvl('', 'mina')");
        String query = "Select id, name from trade.test";
        java.sql.ResultSet rs = st.executeQuery(query);
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        QueryTest.assertEquals((int)7, (int)count);
        st.execute("delete from trade.test where nvl('tina', '') = nvl(name, 'abc')");
        st.execute("delete from trade.test where nvl(name , 'abc') = nvl('mina', '')");
        rs = st.executeQuery(query);
        count = 0;
        while (rs.next()) {
            ++count;
        }
        QueryTest.assertEquals((int)5, (int)count);
        st.execute("drop table trade.test");
        st.execute("drop schema trade restrict");
    }

    public void test49292() throws Exception {
        Connection conn = QueryTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("drop table if exists course ");
        st.execute("create table course (course_id int, i int, course_name varchar(10),  primary key(course_id)) partition by primary key ");
        st.execute("insert into course values (1, 1, 'd'), (2, 2, 'd'), (3, 1, 'd'), (4, 3, 'd'), (5, 1, 'd')");
        st.execute("insert into course values (11, 1, 'd'), (12, 2, 'd'), (13, 1, 'd'), (14, 3, 'd'), (15, 1, 'd')");
        st.execute("insert into course values (21, 1, 'd'), (22, 2, 'd'), (23, 1, 'd'), (24, 3, 'd'), (25, 1, 'd')");
        st.execute("insert into course values (31, 1, 'd'), (32, 3, 'd'), (33, 1, 'd'), (34, 3, 'd'), (35, 1, 'd')");
        st.execute("insert into course values (41, 1, 'd'), (42, 4, 'd'), (43, 1, 'd'), (44, 3, 'd'), (45, 1, 'd')");
        java.sql.ResultSet rs = null;
        String plan = null;
        rs = st.executeQuery("explain select * from course --GEMFIREXD-PROPERTIES withSecondaries=false\n where course_name = ? parameter values ('d')");
        QueryTest.assertTrue((boolean)rs.next());
        plan = rs.getString(1);
        QueryTest.getLogger().info((Object)("Plan : " + plan));
        plan = StatementPlanDUnit.statement(plan);
        plan = StatementPlanDUnit.tablescan(plan, "25", 1, "COURSE_NAME", "APP.COURSE", "HEAP", 0);
        QueryTest.assertTrue((plan == null ? 1 : 0) != 0);
        QueryTest.assertFalse((boolean)rs.next());
        rs.close();
        PreparedStatement ps = conn.prepareStatement("explain select * from course --GEMFIREXD-PROPERTIES withSecondaries=false\n where course_name = ?");
        ps.setString(1, "d");
        rs = ps.executeQuery();
        QueryTest.assertTrue((boolean)rs.next());
        plan = rs.getString(1);
        QueryTest.getLogger().info((Object)("Plan : " + plan));
        plan = StatementPlanDUnit.statement(plan);
        plan = StatementPlanDUnit.tablescan(plan, "25", 1, "COURSE_NAME", "APP.COURSE", "HEAP", 0);
        QueryTest.assertTrue((plan == null ? 1 : 0) != 0);
        QueryTest.assertFalse((boolean)rs.next());
        rs.close();
        rs = st.executeQuery("explain as xml select * from course --GEMFIREXD-PROPERTIES withSecondaries=false\n where course_name = ? parameter values ('d') ");
        QueryTest.assertTrue((boolean)rs.next());
        plan = rs.getString(1);
        int lines = 0;
        StringTokenizer stz = new StringTokenizer(plan, "\n");
        String tok = null;
        while (stz.hasMoreTokens()) {
            tok = stz.nextToken();
            if (++lines == 3) {
                QueryTest.assertEquals((String)"<root>", (String)tok);
                continue;
            }
            if (lines != 4) continue;
            QueryTest.assertEquals((String)"<plan>", (String)tok);
        }
        QueryTest.assertEquals((String)"</root>", (String)tok);
        QueryTest.getLogger().info((Object)(lines + " lines of plan : " + plan));
        QueryTest.assertFalse((boolean)rs.next());
        QueryTest.assertEquals((int)20, (int)lines);
        rs.close();
        rs = st.executeQuery("explain as xmlfragments select * from course --GEMFIREXD-PROPERTIES withSecondaries=false\n where course_name = ? parameter values ('d')");
        QueryTest.assertTrue((boolean)rs.next());
        plan = rs.getString(1);
        lines = 0;
        stz = new StringTokenizer(plan, "\n");
        tok = null;
        while (stz.hasMoreTokens()) {
            tok = stz.nextToken();
            if (++lines != 0) continue;
            QueryTest.assertEquals((String)"<plan>", (String)tok);
        }
        QueryTest.assertEquals((String)"</plan>", (String)tok);
        QueryTest.getLogger().info((Object)(lines + " lines of plan : " + plan));
        QueryTest.assertFalse((boolean)rs.next());
        QueryTest.assertEquals((int)16, (int)lines);
        rs.close();
        try {
            st.executeQuery("explain as xmlfragments embed 'vanilla.xsl' select * from course --GEMFIREXD-PROPERTIES withSecondaries=false\n where course_name = ? parameter values ('d') ");
            QueryTest.fail("expected parsing exception");
        }
        catch (SQLException sqle) {
            QueryTest.assertEquals((String)"42X01", (String)sqle.getSQLState());
        }
        rs = st.executeQuery("explain as xml embed 'vanilla.xsl' select * from course --GEMFIREXD-PROPERTIES withSecondaries=false\n where course_name = ? parameter values ('d') ");
        QueryTest.assertTrue((boolean)rs.next());
        plan = rs.getString(1);
        lines = 0;
        stz = new StringTokenizer(plan, "\n");
        tok = null;
        while (stz.hasMoreTokens()) {
            tok = stz.nextToken();
            if (++lines == 1) {
                QueryTest.assertTrue((boolean)tok.contains("xml version"));
                QueryTest.assertTrue((boolean)tok.contains("encoding="));
                QueryTest.assertTrue((boolean)tok.contains("UTF-8"));
                continue;
            }
            if (lines == 2) {
                QueryTest.assertTrue((boolean)tok.contains("xml-stylesheet"));
                QueryTest.assertTrue((boolean)tok.contains("vanilla.xsl"));
                continue;
            }
            if (lines == 4) {
                QueryTest.assertEquals((String)"<root>", (String)tok);
                continue;
            }
            if (lines != 5) continue;
            QueryTest.assertEquals((String)"<plan>", (String)tok);
        }
        QueryTest.assertEquals((String)"</root>", (String)tok);
        QueryTest.getLogger().info((Object)(lines + " lines of plan : " + plan));
        QueryTest.assertFalse((boolean)rs.next());
        QueryTest.assertEquals((int)21, (int)lines);
        rs.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test49400_1() throws Exception {
        SystemProcedures.TEST_FAILURE_MODE = true;
        Properties p = new Properties();
        p.setProperty("auth-provider", "builtin");
        p.setProperty("gemfirexd.user.sysONE", "3b6005b975a13d93cb2accec0167d2c12039ff451dee");
        p.setProperty("user", "sysONE");
        p.setProperty("password", "pwdSys");
        Connection eConn = QueryTest.getConnection(p);
        Statement st = eConn.createStatement();
        st.execute("call sys.create_user('DBUSER', 'PWDUSER') ");
        st.execute("create table test_1 (i int)");
        st.execute("insert into test_1 values 1,2,3,4,5,6");
        st.execute("grant select on test_1 to public");
        Properties cProps = new Properties();
        cProps.setProperty("user", "DBUSER");
        cProps.setProperty("password", "PWDUSER");
        int netPort = QueryTest.startNetserverAndReturnPort(null);
        Connection nConn = QueryTest.getConnection(cProps);
        try (Statement st2 = nConn.createStatement();){
            java.sql.ResultSet rs = st2.executeQuery("explain select * from sysone.test_1");
            QueryTest.fail("expected authorization failed exception....");
        }
    }

    public void test49400_2() throws Exception {
        QueryTest.assertFalse((boolean)SystemProcedures.TEST_FAILURE_MODE);
        Properties p = new Properties();
        p.setProperty("auth-provider", "builtin");
        p.setProperty("gemfirexd.user.sysONE", "3b6005b975a13d93cb2accec0167d2c12039ff451dee");
        p.setProperty("user", "sysONE");
        p.setProperty("password", "pwdSys");
        Connection eConn = QueryTest.getConnection(p);
        Statement st = eConn.createStatement();
        st.execute("call sys.create_user('DBUSER', 'PWDUSER') ");
        st.execute("create table test_1 (i int)");
        st.execute("insert into test_1 values 1,2,3,4,5,6");
        st.execute("grant select on test_1 to public");
        Properties cProps = new Properties();
        cProps.setProperty("user", "DBUSER");
        cProps.setProperty("password", "PWDUSER");
        eConn = QueryTest.getConnection(cProps);
        int netPort = QueryTest.startNetserverAndReturnPort(null);
        Connection nConn = QueryTest.getNetConnection(netPort, null, cProps);
        for (Connection conn : new Connection[]{nConn, eConn}) {
            Statement st2 = conn.createStatement();
            java.sql.ResultSet rs = st2.executeQuery("explain select * from sysone.test_1");
            QueryTest.assertTrue((boolean)rs.next());
            String plan = rs.getString(1);
            int lines = 0;
            StringTokenizer stz = new StringTokenizer(plan, "\n");
            String tok = null;
            while (stz.hasMoreTokens()) {
                tok = stz.nextToken();
                ++lines;
            }
            QueryTest.getLogger().info((Object)(lines + " lines of plan : " + plan));
            QueryTest.assertFalse((boolean)rs.next());
            QueryTest.assertEquals((int)4, (int)lines);
            rs.close();
            conn.close();
        }
    }

    public void test51502() throws Exception {
        Properties p = new Properties();
        p.setProperty("mcast-port", Integer.toString(AvailablePort.getRandomAvailablePort((int)1)));
        QueryTest.getConnection(p);
        Connection conn = QueryTest.startNetserverAndGetLocalNetConnection();
        Statement st = conn.createStatement();
        st.execute("drop table if exists course ");
        st.execute("create table course (course_id int, i int, course_name varchar(10),  primary key(course_id)) partition by primary key ");
        st.execute("insert into course values (1, 1, 'd'), (2, 2, 'd'), (3, 1, 'd'), (4, 3, 'd'), (5, 1, 'd')");
        st.execute("insert into course values (11, 1, 'd'), (12, 2, 'd'), (13, 1, 'd'), (14, 3, 'd'), (15, 1, 'd')");
        st.execute("insert into course values (21, 1, 'd'), (22, 2, 'd'), (23, 1, 'd'), (24, 3, 'd'), (25, 1, 'd')");
        st.execute("insert into course values (31, 1, 'd'), (32, 3, 'd'), (33, 1, 'd'), (34, 3, 'd'), (35, 1, 'd')");
        st.execute("insert into course values (41, 1, 'd'), (42, 4, 'd'), (43, 1, 'd'), (44, 3, 'd'), (45, 1, 'd')");
        st.execute("call sys.set_global_statement_statistics('true','true')");
        st.execute("call SYSCS_UTIL.SET_STATISTICS_TIMING(1)");
        st.execute("call SYSCS_UTIL.SET_EXPLAIN_CONNECTION(1)");
        final boolean[] queryPlanGenerationStatus = new boolean[1];
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){
            private static final long serialVersionUID = 1L;

            public void afterQueryPlanGeneration() {
                queryPlanGenerationStatus[0] = true;
            }
        });
        java.sql.ResultSet r = st.executeQuery("select count(1), course_name from course group by course_name");
        while (r.next()) {
            QueryTest.assertEquals((int)25, (int)r.getInt(1));
            QueryTest.assertEquals((String)"d", (String)r.getString(2));
        }
        r.close();
        QueryTest.assertTrue((String)"Query Plan Generation should have been successfull", (boolean)queryPlanGenerationStatus[0]);
    }

    public void test51355() throws Exception {
        block3: {
            QueryTest.getConnection();
            Connection conn = QueryTest.startNetserverAndGetLocalNetConnection();
            Statement stmt = conn.createStatement();
            stmt.execute("create table t1 (col1 int, col2 int, col3 varchar(100))");
            stmt.execute("insert into t1 values (2, 2, 'abcdefghijklmnopqrstABCDEFGH100')");
            java.sql.ResultSet r = stmt.executeQuery("select col1, col2, cast (substr(substr(col3, 10), 20) as int) from t1");
            while (r.next()) {
                QueryTest.assertEquals((int)100, (int)r.getInt(3));
            }
            stmt.execute("delete from t1");
            stmt.execute("insert into t1 values (1, 1, 'abcdefghijklmnopqrstuv')");
            try {
                r = stmt.executeQuery("select col1, col2, cast (substr(substr(col3, 10), 5) as int) from t1");
                r.next();
                QueryTest.fail("supposed to fail with NumberFormatException");
            }
            catch (SQLException e) {
                if ("22018".equals(e.getSQLState())) break block3;
                throw e;
            }
        }
    }

    public void test51194() throws Exception {
        QueryTest.getConnection();
        Connection conn = QueryTest.startNetserverAndGetLocalNetConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table \"ro ot\".\"base Table\"( \"my id\" varchar(100) primary key)");
        stmt.execute("create synonym \"synschema1\".\"first synonym\" for \"ro ot\".\"base Table\" ");
        stmt.execute("create synonym \"syn Schema2\".\"second synonym\" for \"ro ot\".\"base Table\" ");
        stmt.execute("create synonym \"fake table\".\"but real synonym\" for \"ro ot\".\"base table\" ");
        DatabaseMetaData dmd = conn.getMetaData();
        java.sql.ResultSet colM = dmd.getColumns(null, "ro ot", "base Table", null);
        QueryTest.assertTrue((boolean)colM.next());
        QueryTest.assertEquals((String)"ro ot", (String)colM.getString(2));
        QueryTest.assertEquals((String)"base Table", (String)colM.getString(3));
        QueryTest.assertEquals((String)"my id", (String)colM.getString(4));
        QueryTest.assertFalse((boolean)colM.next());
        colM = dmd.getColumns(null, "synschema1", "first synonym", null);
        QueryTest.assertTrue((boolean)colM.next());
        QueryTest.assertEquals((String)"synschema1", (String)colM.getString(2));
        QueryTest.assertEquals((String)"first synonym", (String)colM.getString(3));
        QueryTest.assertEquals((String)"my id", (String)colM.getString(4));
        QueryTest.assertFalse((boolean)colM.next());
        colM = dmd.getColumns(null, "syn Schema2", "second synonym", null);
        QueryTest.assertTrue((boolean)colM.next());
        QueryTest.assertEquals((String)"syn Schema2", (String)colM.getString(2));
        QueryTest.assertEquals((String)"second synonym", (String)colM.getString(3));
        QueryTest.assertEquals((String)"my id", (String)colM.getString(4));
        QueryTest.assertFalse((boolean)colM.next());
        colM = dmd.getColumns(null, "fake table", "but real synonym", null);
        QueryTest.assertFalse((boolean)colM.next());
    }
}

