/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class ProcedureTest
extends JdbcTestBase {
    private List statements;
    private static final String[] PROCEDURES = new String[]{"CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveDynamicResults' " + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE RETRIEVE_OUTGOING_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveDynamicResultsWithOutgoingResultSet'" + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE PROCEDURE_INOUT_PARAMETERS(number INT, INOUT name VARCHAR(25), OUT total INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procedureWithInAndOutParameters'" + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE PROCEDURE_WITHOUT_RESULTSET(number INT, INOUT name VARCHAR(20) ) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procedureWithoutDynamicResultSets'", "CREATE PROCEDURE PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(number INT, name VARCHAR(20) ) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procedureWithoutDynamicResultSetsAndOutParameters'", "CREATE PROCEDURE RETRIEVE_CLOSED_RESULT() LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveClosedResult' " + "DYNAMIC RESULT SETS 1", "CREATE PROCEDURE RETRIEVE_EXTERNAL_RESULT(DBNAME VARCHAR(128), DBUSER VARCHAR(128), DBPWD VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".retrieveExternalResult' " + "DYNAMIC RESULT SETS 1", "CREATE PROCEDURE PROC_WITH_SIDE_EFFECTS(ret INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procWithSideEffects' " + "DYNAMIC RESULT SETS 2", "CREATE PROCEDURE NESTED_RESULT_SETS(proctext VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".nestedDynamicResultSets' " + "DYNAMIC RESULT SETS 6"};
    private static final String[][] TABLES = new String[][]{{"SIMPLE_TABLE", "CREATE TABLE SIMPLE_TABLE (id INT)"}};

    public ProcedureTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ProcedureTest.class));
    }

    public void testDocExample() throws Exception {
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        stmt.execute("create type ExampleObjType external name '" + ExampleObj.class.getName() + "' language java");
        stmt.execute("CREATE PROCEDURE myProc (IN inParam1 VARCHAR(10),  OUT outParam2 INTEGER,  INOUT example ExampleObjType, OUT count INTEGER)LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 2 EXTERNAL NAME '" + ProcedureTest.class.getName() + ".myProc'");
        stmt.execute("create table MyTable(x int not null, y int not null)");
        stmt.execute("insert into MyTable values (1, 10), (2, 20), (3, 30), (4, 40)");
        CallableStatement callableStmt = cxn.prepareCall("{CALL myProc('abc', ?, ?, ?) ON TABLE MyTable WHERE x BETWEEN 5 AND 10}");
        callableStmt.registerOutParameter(1, 4);
        callableStmt.registerOutParameter(2, 2000);
        callableStmt.registerOutParameter(3, 4);
        callableStmt.setObject(2, (Object)new ExampleObj());
        callableStmt.execute();
        int outParam2 = callableStmt.getInt(1);
        ExampleObj example = (ExampleObj)callableStmt.getObject(2);
        assert (example.getValue() == 100);
        assert (outParam2 == 200);
        boolean moreResults = true;
        int cnt = 0;
        int rowCount = 0;
        do {
            int i;
            ResultSet thisResultSet = callableStmt.getResultSet();
            int colCnt = thisResultSet.getMetaData().getColumnCount();
            if (cnt == 0) {
                System.out.println("Result Set 1 starts");
                while (thisResultSet.next()) {
                    for (i = 1; i < colCnt + 1; ++i) {
                        System.out.print(thisResultSet.getObject(i));
                        if (i != 1) continue;
                        System.out.print(',');
                    }
                    System.out.println();
                    ++rowCount;
                }
                System.out.println("ResultSet 1 ends\n");
                ++cnt;
                continue;
            }
            thisResultSet.next();
            System.out.println("ResultSet 2 starts");
            i = 1;
            if (i < colCnt + 1) {
                cnt = thisResultSet.getInt(1);
                System.out.print(cnt);
                System.out.println();
            }
            System.out.println("ResultSet 2 ends");
        } while (moreResults = callableStmt.getMoreResults());
        assert (rowCount == cnt);
        assert (rowCount == 4);
    }

    public static void myProc(String inParam1, int[] outParam2, ExampleObj[] example, int[] count, ResultSet[] resultSet1, ResultSet[] resultSet2, ProcedureExecutionContext ctx) throws SQLException {
        Connection conn = ctx.getConnection();
        ExampleObj obj = new ExampleObj();
        obj.setValue(100);
        example[0] = obj;
        outParam2[0] = 200;
        Statement stmt = conn.createStatement();
        stmt.execute("select * from mytable");
        resultSet1[0] = stmt.getResultSet();
        Statement stmt3 = conn.createStatement();
        stmt3.execute("select count(*) from mytable");
        stmt3.getResultSet().next();
        Integer cnt = stmt3.getResultSet().getInt(1);
        count[0] = cnt;
        Statement stmt2 = conn.createStatement();
        stmt2.execute("select count(*) from mytable");
        resultSet2[0] = stmt2.getResultSet();
    }

    public void testDocExample_1() throws Exception {
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        stmt.execute("create type ExampleObjType external name '" + ExampleObj.class.getName() + "' language java");
        stmt.execute("CREATE PROCEDURE myProc (IN inParam1 ExampleObjType) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME '" + ProcedureTest.class.getName() + ".myProc_1'");
        stmt.execute("create table MyTable(x int not null)");
        CallableStatement callableStmt = cxn.prepareCall("{CALL myProc(?) ON TABLE MyTable WHERE x BETWEEN 5 AND 10}");
        callableStmt.setObject(1, (Object)new ExampleObj());
        callableStmt.execute();
        boolean moreResults = true;
        do {
            callableStmt.getResultSet();
        } while (moreResults = callableStmt.getMoreResults());
    }

    public static void myProc_1(ExampleObj example, ResultSet[] resultSet1) {
    }

    public void testReadWriteModifiesSQLDataProcedure() throws Exception {
        Statement s;
        block5: {
            block4: {
                String createProcNoSQLStr = "CREATE PROCEDURE SQL_DATA_OPTIONS_PROC_NO_SQL(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME '" + ProcedureTest.class.getName() + ".sqlDataOptionsProc' " + "DYNAMIC RESULT SETS 4";
                Connection conn = TestUtil.getConnection();
                s = conn.createStatement();
                s.execute(createProcNoSQLStr);
                try {
                    s.execute("call SQL_DATA_OPTIONS_PROC_NO_SQL(1)");
                    ProcedureTest.fail("should fail as the proc is actually executing sql data");
                }
                catch (SQLException e) {
                    if ("38001".equals(e.getSQLState())) break block4;
                    throw e;
                }
            }
            String createProcSQLStr = "CREATE PROCEDURE SQL_DATA_OPTIONS_PROC_SQL(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".sqlDataOptionsProc' " + "DYNAMIC RESULT SETS 4";
            s.execute(createProcSQLStr);
            s.execute("call SQL_DATA_OPTIONS_PROC_SQL(1)");
            String createProcUpdateSQLStr = "CREATE PROCEDURE SQL_DATA_OPTIONS_PROC_UPDATE_SQL(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".sqlDataOptionsProc' " + "DYNAMIC RESULT SETS 4";
            s.execute("create table app.t1(col1 int not null)");
            s.execute("insert into app.t1 values(1), (2)");
            s.execute(createProcUpdateSQLStr);
            try {
                s.execute("call SQL_DATA_OPTIONS_PROC_UPDATE_SQL(2)");
                ProcedureTest.fail("should fail as updating should not be allowed");
            }
            catch (SQLException e) {
                if ("38002".equals(e.getSQLState())) break block5;
                throw e;
            }
        }
        String createProcUpdateSQLStr_WITH_MODIFIES = "CREATE PROCEDURE SQL_DATA_OPTIONS_PROC_UPDATE_SQL_WITH_MODIFIES(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".sqlDataOptionsProc' " + "DYNAMIC RESULT SETS 4";
        s.execute(createProcUpdateSQLStr_WITH_MODIFIES);
        s.execute("call SQL_DATA_OPTIONS_PROC_UPDATE_SQL_WITH_MODIFIES(2)");
        String createProcUpdateSQLStr_WITH_DEFAULT = "CREATE PROCEDURE SQL_DATA_OPTIONS_PROC_UPDATE_SQL_WITH_DEFAULT(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".sqlDataOptionsProc' " + "DYNAMIC RESULT SETS 4";
        s.execute(createProcUpdateSQLStr_WITH_DEFAULT);
        s.execute("call SQL_DATA_OPTIONS_PROC_UPDATE_SQL_WITH_DEFAULT(2)");
    }

    public static void sqlDataOptionsProc(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ProcedureExecutionContext ctx) throws SQLException {
        Connection c = ctx.getConnection();
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            c.createStatement().executeUpdate("update app.t1 set col1 = 100");
        }
    }

    public void testExecuteQueryWithNoDynamicResultSets() throws SQLException {
        ProcedureTest.setup();
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(0)");
            ProcedureTest.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet() throws SQLException {
        ProcedureTest.setup();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(1)");
        ProcedureTest.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        ProcedureTest.assertSame((Object)stmt, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet() throws SQLException {
        ProcedureTest.setup();
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL RETRIEVE_DYNAMIC_RESULTS(2)");
            ProcedureTest.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testExecuteUpdateWithOneDynamicResultSet() throws SQLException {
        ProcedureTest.setup();
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("CALL RETRIEVE_DYNAMIC_RESULTS(1)");
            ProcedureTest.fail("executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void testExecuteQueryWithDataAwareProcedureCall() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID in (?,?,?) AND THIRDID='3'");
        cs.setInt(1, 2);
        cs.setInt(2, 3);
        cs.setInt(3, 4);
        cs.setInt(4, 5);
        cs.execute();
        String[][] results = new String[2][1];
        results[0][0] = "1";
        results[1][0] = "1";
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > 1) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void _testExecuteQueryWithMissingResultProcessorClass() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?) WITH RESULT PROCESSOR Fubar ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID in (?,?,?) AND THIRDID='3'");
        cs.setInt(1, 2);
        cs.setInt(2, 3);
        cs.setInt(3, 4);
        cs.setInt(4, 5);
        cs.execute();
        String[][] results = new String[2][1];
        results[0][0] = "1";
        results[1][0] = "1";
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > 1) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testDataAwareProcedureCallUsingGlobalIndex() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?) ON TABLE EMP.PARTITIONTESTTABLE1 WHERE SECONDID in (?,?,?) AND THIRDID='3'");
        cs.setInt(1, 2);
        cs.setInt(2, 3);
        cs.setInt(3, 4);
        cs.setInt(4, 5);
        cs.execute();
        String[][] results = new String[2][1];
        results[0][0] = "1";
        results[1][0] = "1";
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > 1) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testDataAwareProcedureWithoutResultSets() throws SQLException {
        ParameterMetaData pmd;
        int numParameters;
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET(?, ?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        cs.registerOutParameter(2, 12, 20);
        int number = 2;
        String name = "INOUTPARAMETER";
        cs.setInt(1, number);
        cs.setString(2, name);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs != null || cs.getMoreResults()) {
            ProcedureTest.fail("no dynamic result set for the procedure!");
        }
        ProcedureTest.assertTrue((String)" the number of parameter is 2", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 2 ? 1 : 0) != 0);
        try {
            cs.getInt(1);
            ProcedureTest.fail("the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object parameter2 = cs.getObject(2);
        ProcedureTest.assertTrue((String)("the second inout parameter is " + name + number), (boolean)parameter2.equals(name + number));
    }

    public void testDataAwareProcedureWithoutResultSetsUsingGlobalIndex() throws SQLException {
        ParameterMetaData pmd;
        int numParameters;
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET(?, ?) ON TABLE EMP.PARTITIONTESTTABLE1 WHERE SECONDID=4 AND THIRDID='3'");
        cs.registerOutParameter(2, 12, 20);
        int number = 2;
        String name = "INOUTPARAMETER";
        cs.setInt(1, number);
        cs.setString(2, name);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs != null || cs.getMoreResults()) {
            ProcedureTest.fail("no dynamic result set for the procedure!");
        }
        ProcedureTest.assertTrue((String)" the number of parameter is 2", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 2 ? 1 : 0) != 0);
        try {
            cs.getInt(1);
            ProcedureTest.fail("the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object parameter2 = cs.getObject(2);
        ProcedureTest.assertTrue((String)("the second inout parameter is " + name + number), (boolean)parameter2.equals(name + number));
    }

    public void testDataAwareProcedureWithoutResultSetsAndOutParameters() throws SQLException {
        block6: {
            CallableStatement cs;
            block5: {
                ParameterMetaData pmd;
                int numParameters;
                ProcedureTest.setup();
                cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(?, ?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
                int number = 2;
                String name = "INOUTPARAMETER";
                cs.setInt(1, number);
                cs.setString(2, name);
                cs.execute();
                ResultSet rs = cs.getResultSet();
                if (rs != null || cs.getMoreResults()) {
                    ProcedureTest.fail("no dynamic result set for the procedure!");
                }
                ProcedureTest.assertTrue((String)" the number of parameter is 2", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 2 ? 1 : 0) != 0);
                try {
                    cs.getInt(1);
                    ProcedureTest.fail("the in parameter should not be used for output!");
                }
                catch (SQLException e) {
                    if ("XCL26".equals(e.getSQLState())) break block5;
                    throw e;
                }
            }
            try {
                cs.getObject(2);
                ProcedureTest.fail("the in parameter should not be used for output!");
            }
            catch (SQLException e) {
                if ("XCL26".equals(e.getSQLState())) break block6;
                throw e;
            }
        }
    }

    public void testDataAwareProcedureWithoutResultSetsAndOutParametersAndQuestionMark() throws SQLException {
        block6: {
            CallableStatement cs;
            block5: {
                ParameterMetaData pmd;
                int numParameters;
                ProcedureTest.setup();
                cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(2, 'INOUTPARAMETER') ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
                cs.execute();
                ResultSet rs = cs.getResultSet();
                if (rs != null || cs.getMoreResults()) {
                    ProcedureTest.fail("no dynamic result set for the procedure!");
                }
                ProcedureTest.assertTrue((String)" the number of parameter is 0", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 0 ? 1 : 0) != 0);
                try {
                    cs.getInt(1);
                    ProcedureTest.fail("no input parameters!");
                }
                catch (SQLException e) {
                    if ("07009".equals(e.getSQLState())) break block5;
                    throw e;
                }
            }
            try {
                cs.getObject(2);
                ProcedureTest.fail("no input parameters!");
            }
            catch (SQLException e) {
                if ("07009".equals(e.getSQLState())) break block6;
                throw e;
            }
        }
    }

    public void testProcedureWithoutResultSetsAndOutParameters() throws SQLException {
        ParameterMetaData pmd;
        int numParameters;
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(?, ?)");
        int number = 2;
        String name = "INOUTPARAMETER";
        cs.setInt(1, number);
        cs.setString(2, name);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        if (rs != null || cs.getMoreResults()) {
            ProcedureTest.fail("no dynamic result set for the procedure!");
        }
        ProcedureTest.assertTrue((String)" the number of parameter is 2", ((numParameters = (pmd = cs.getParameterMetaData()).getParameterCount()) == 2 ? 1 : 0) != 0);
        try {
            cs.getInt(1);
            ProcedureTest.fail("the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            cs.getObject(2);
            ProcedureTest.fail("the in parameteter cannot be read!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDataAwareProcedureWithOutgoingResultSets() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        int number = 2;
        cs.setInt(1, number);
        cs.execute();
        String[][] results = new String[2][10];
        results[0][0] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
        }
        int[] numRows = new int[]{0, 9};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > numRows[rsIndex]) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testDataAwareProcedureWithOutgoingResultSetsAndNoRoutingObjects() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONRANGETESTTABLE WHERE SECONDID in (?, ?, ?)");
        int number = 2;
        cs.setInt(1, number);
        cs.setInt(2, 2);
        cs.setInt(3, 3);
        cs.setInt(4, 4);
        cs.execute();
        String[][] results = new String[2][10];
        results[0][0] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
        }
        int[] numRows = new int[]{0, 9};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > numRows[rsIndex]) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testDataAwareProcedureWithOutgoingResultSetsOnAll() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON ALL");
        int number = 2;
        cs.setInt(1, number);
        cs.execute();
        String[][] results = new String[2][10];
        results[0][0] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
        }
        int[] numRows = new int[]{0, 9};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > numRows[rsIndex]) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testDataAwareProcedureWithOutgoingResultSetsOnRangePartitionTable() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONRANGETESTTABLE WHERE ID>1 and ID<15");
        int number = 2;
        cs.setInt(1, number);
        cs.execute();
        String[][] results = new String[2][10];
        results[0][0] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
        }
        int[] numRows = new int[]{0, 9};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > numRows[rsIndex]) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testDataAwareProcedureWithOutgoingResultSetsOnListPartitionTable() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONLISTTESTTABLE WHERE ID in (?, ?, ?)");
        int number = 2;
        cs.setInt(1, number);
        cs.setInt(2, 10);
        cs.setInt(3, 15);
        cs.setInt(4, 31);
        cs.execute();
        String[][] results = new String[2][10];
        results[0][0] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
        }
        int[] numRows = new int[]{0, 9};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > numRows[rsIndex]) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testExecuteQueryWithOutgoingResultSetInDerbyCall() throws SQLException {
        ProcedureTest.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?)");
        cs.setInt(1, 2);
        cs.execute();
        String[][] results = new String[2][10];
        results[0][0] = "1";
        for (int i = 0; i < 10; ++i) {
            results[1][i] = i + "String" + i;
        }
        int[] numRows = new int[]{0, 9};
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > numRows[rsIndex]) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ProcedureTest.assertEquals((String)results[rsIndex][rowIndex], (String)row);
                ++rowIndex;
            }
        } while (cs.getMoreResults());
    }

    public void testCallProcedureWithInAndOutParameter() throws SQLException {
        int parameter3;
        String outParameter;
        ProcedureTest.setup();
        int number = 2;
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_INOUT_PARAMETERS(?, ?, ?)");
        cs.setInt(1, number);
        cs.registerOutParameter(2, 12);
        cs.setString(2, "INOUT_PARAMETER");
        cs.registerOutParameter(3, 4);
        cs.execute();
        String[][] results = new String[2][1];
        results[0][0] = "1";
        results[1][0] = "1";
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > 1) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
        String outValue = cs.getString(2);
        if (!outValue.equals(outParameter = "INOUT_PARAMETERModified")) {
            ProcedureTest.fail("the out parameter is supposed to " + outParameter + " but " + outValue);
        }
        if ((parameter3 = cs.getInt(3)) != number) {
            ProcedureTest.fail("the out parameter is supposed to " + number + " but " + parameter3);
        }
    }

    public void testDataAwareProcedureWithInAndOutParameter() throws SQLException {
        int parameter3;
        String outParameter;
        ProcedureTest.setup();
        int number = 2;
        CallableStatement cs = this.prepareCall("CALL PROCEDURE_INOUT_PARAMETERS(?, ?, ?) ON TABLE EMP.PARTITIONTESTTABLE WHERE SECONDID=4 AND THIRDID='3'");
        cs.setInt(1, number);
        cs.registerOutParameter(2, 12);
        cs.setString(2, "INOUT_PARAMETER");
        cs.registerOutParameter(3, 4);
        cs.execute();
        String[][] results = new String[2][1];
        results[0][0] = "1";
        results[1][0] = "1";
        int rsIndex = -1;
        do {
            ++rsIndex;
            int rowIndex = 0;
            ResultSet rs = cs.getResultSet();
            ResultSetMetaData metaData = rs.getMetaData();
            int rowCount = metaData.getColumnCount();
            while (rs.next()) {
                String row = "";
                for (int i = 1; i <= rowCount; ++i) {
                    Object value = rs.getObject(i);
                    row = row + value.toString();
                }
                if (rsIndex > 1 || rowIndex > 1) {
                    ProcedureTest.fail("the result is not correct!");
                }
                if (!row.equals(results[rsIndex][rowIndex])) {
                    ProcedureTest.fail("the result is not correct!");
                }
                ++rowIndex;
            }
        } while (cs.getMoreResults());
        String outValue = cs.getString(2);
        if (!outValue.equals(outParameter = "INOUT_PARAMETERModified")) {
            ProcedureTest.fail("the out parameter is supposed to " + outParameter + " but " + outValue);
        }
        if ((parameter3 = cs.getInt(3)) != number) {
            ProcedureTest.fail("the out parameter is supposed to " + number + " but " + parameter3);
        }
    }

    private void assertNoResultSetFromExecuteQuery(SQLException sqle) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y78", sqle);
    }

    private void assertMultipleResultsFromExecuteQuery(SQLException sqle) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y78", sqle);
    }

    private void assertResultsFromExecuteUpdate(SQLException sqle) {
        ProcedureTest.assertSQLState("Unexpected SQL state.", "X0Y79", sqle);
    }

    private static void setup() throws SQLException {
        int i;
        ProcedureTest.setupConnection();
        Connection conn = ProcedureTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID))");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (4, 4, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (5, 5, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '2') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4') ");
        s.execute("SELECT * FROM EMP.PARTITIONTESTTABLE WHERE (SECONDID=10 AND THIRDID='20') OR (SECONDID=10 AND THIRDID='20')");
        s.execute("create table EMP.PARTITIONTESTTABLE1 (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (3, 3, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (4, 4, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (5, 5, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '2') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '4') ");
        s.execute("create table EMP.PARTITIONRANGETESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 10, VALUES BETWEEN 10 and 20, VALUES BETWEEN 20 and 30, VALUES BETWEEN 30 and 40 )");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (1, 2, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (10, 3, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (15, 4, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (21, 5, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (30, 2, '2') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (35, 2, '4') ");
        s.execute("create table EMP.PARTITIONLISTTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY LIST ( ID ) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31, 100))");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (0, 2, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (5, 3, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (15, 4, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (30, 5, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (31, 2, '2') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (25, 2, '4') ");
        s.execute("create table EMP.PARTITIONEMPTYTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN ( ID )");
        for (i = 0; i < PROCEDURES.length; ++i) {
            s.execute(PROCEDURES[i]);
        }
        for (i = 0; i < TABLES.length; ++i) {
            s.execute(TABLES[i][1]);
        }
        conn.close();
    }

    public static void retrieveDynamicResults(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void procedureWithInAndOutParameters(int number, String[] name, int[] total, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        name[0] = name[0] + "Modified";
        total[0] = number;
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void procedureWithoutDynamicResultSets(int number, String[] name) throws SQLException {
        name[0] = name[0] + number;
    }

    public static void procedureWithoutDynamicResultSetsAndOutParameters(int number, String name) throws SQLException {
    }

    public static void retrieveDynamicResultsWithOutgoingResultSet(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ProcedureExecutionContext pec) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            OutgoingResultSet ors = pec.getOutgoingResultSet(2);
            for (int i = 0; i < 10; ++i) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new Integer(i));
                row.add("String" + i);
                ors.addRow(row);
            }
            ors.endResults();
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void retrieveClosedResult(ResultSet[] closed2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        closed2[0] = c.createStatement().executeQuery("VALUES(1)");
        closed2[0].close();
    }

    public static void retrieveExternalResult(String dbName, String user, String password, ResultSet[] external) throws SQLException {
        String url = "jdbc:derby:" + dbName;
        Connection conn = DriverManager.getConnection(url, user, password);
        external[0] = conn.createStatement().executeQuery("VALUES(1)");
    }

    public static void procWithSideEffects(int returnResults, ResultSet[] rs1, ResultSet[] rs2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = c.createStatement();
        stmt.executeUpdate("INSERT INTO SIMPLE_TABLE VALUES (42)");
        if (returnResults > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (returnResults > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void nestedDynamicResultSets(String procedureText, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ResultSet[] rs5, ResultSet[] rs6) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        CallableStatement cs = c.prepareCall("CALL " + procedureText);
        cs.execute();
        rs6[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs3[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs4[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs2[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs1[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs5[0] = cs.getResultSet();
    }

    private void checkExecuteClosesResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        int pass = 0;
        do {
            allRS[pass++] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[pass - 1].getStatement());
        } while (cs.getMoreResults(2));
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
        cs.execute();
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void checkCSCloseClosesResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        int pass = 0;
        do {
            allRS[pass++] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[pass - 1].getStatement());
        } while (cs.getMoreResults(2));
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
        cs.close();
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void mixedGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        cs.execute();
        allRS[0] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[0].getStatement());
        boolean moreRS = cs.getMoreResults(2);
        if (!moreRS) {
            ProcedureTest.fail("FAIL - no second result set");
        }
        allRS[1] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[1].getStatement());
        allRS[0].next();
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        allRS[1].next();
        ProcedureTest.assertEquals((int)3, (int)allRS[1].getInt(1));
        moreRS = cs.getMoreResults(1);
        if (!moreRS) {
            ProcedureTest.fail("FAIL - no third result set");
        }
        allRS[2] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[2].getStatement());
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        JDBC.assertClosed(allRS[1]);
        allRS[2].next();
        ProcedureTest.assertEquals((int)4, (int)allRS[2].getInt(1));
        moreRS = cs.getMoreResults(2);
        if (!moreRS) {
            ProcedureTest.fail("FAIL - no fourth result set");
        }
        allRS[3] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[3].getStatement());
        allRS[3].next();
        ProcedureTest.assertEquals((int)2, (int)allRS[0].getInt(1));
        JDBC.assertClosed(allRS[1]);
        ProcedureTest.assertEquals((int)4, (int)allRS[2].getInt(1));
        ProcedureTest.assertEquals((int)5, (int)allRS[3].getInt(1));
        moreRS = cs.getMoreResults(3);
        if (!moreRS) {
            ProcedureTest.fail("FAIL - no fifth result set");
        }
        allRS[4] = cs.getResultSet();
        ProcedureTest.assertSame((Object)cs, (Object)allRS[4].getStatement());
        allRS[4].next();
        JDBC.assertClosed(allRS[0]);
        JDBC.assertClosed(allRS[1]);
        JDBC.assertClosed(allRS[2]);
        JDBC.assertClosed(allRS[3]);
        ProcedureTest.assertEquals((int)6, (int)allRS[4].getInt(1));
        moreRS = cs.getMoreResults(2);
        if (moreRS) {
            ProcedureTest.fail("FAIL - too many result sets");
        }
        JDBC.assertClosed(allRS[0]);
        JDBC.assertClosed(allRS[1]);
        JDBC.assertClosed(allRS[2]);
        JDBC.assertClosed(allRS[3]);
        ProcedureTest.assertEquals((int)6, (int)allRS[4].getInt(1));
        allRS[4].close();
    }

    private void keepCurrentGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults(2));
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults(2));
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
    }

    private void closeCurrentGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults(1));
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults(1));
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void defaultGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            ProcedureTest.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            ProcedureTest.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                ProcedureTest.assertTrue((boolean)cs.getMoreResults());
                continue;
            }
            ProcedureTest.assertFalse((boolean)cs.getMoreResults());
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    public Statement createStatement() throws SQLException {
        Statement s = ProcedureTest.getStatement();
        this.addStatement(s);
        return s;
    }

    private void addStatement(Statement s) {
        if (this.statements == null) {
            this.statements = new ArrayList();
        }
        this.statements.add(s);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = ProcedureTest.getPreparedStatement(sql);
        this.addStatement(ps);
        return ps;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cs = jdbcConn.prepareCall(sql);
        this.addStatement(cs);
        return cs;
    }

    public static void assertSQLState(String message, String expected, SQLException exception) {
        ProcedureTest.assertNotNull((String)"Exception cannot be null when asserting on SQLState", (Object)exception);
        try {
            String state = exception.getSQLState();
            if (state != null) {
                ProcedureTest.assertTrue((String)"The exception's SQL state must be five characters long", (state.length() == 5 ? 1 : 0) != 0);
            }
            if (expected != null) {
                ProcedureTest.assertTrue((String)"The expected SQL state must be five characters long", (expected.length() == 5 ? 1 : 0) != 0);
            }
            ProcedureTest.assertEquals((String)message, (String)expected, (String)state);
        }
        catch (AssertionFailedError e) {
            try {
                Method m = Throwable.class.getMethod("initCause", Throwable.class);
                m.invoke((Object)e, exception);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            exception = exception.getNextException();
            if (exception != null) {
                ProcedureTest.assertSQLState(message, expected, exception);
            }
            throw e;
        }
    }

    public static void assertErrorCode(String message, int expected, SQLException exception) {
        while (exception != null) {
            try {
                ProcedureTest.assertEquals((String)message, (int)expected, (int)exception.getErrorCode());
            }
            catch (AssertionFailedError e) {
                exception = exception.getNextException();
            }
        }
    }

    public void testInvalidCallOnClause() throws SQLException {
        block8: {
            CallableStatement cs;
            block7: {
                block6: {
                    ProcedureTest.setup();
                    Connection conn = ProcedureTest.getConnection();
                    Statement s = conn.createStatement();
                    s.execute("CREATE TABLE INVALID_CALL_TABLE (COL1 INTEGER)");
                    s.execute("CREATE VIEW INVALID_CALL_VIEW AS SELECT * FROM INVALID_CALL_TABLE");
                    try {
                        cs = this.prepareCall("CALL SYSCS_UTIL.EMPTY_STATEMENT_CACHE() ON TABLE SYS.MEMBERS");
                        cs.execute();
                    }
                    catch (SQLException e) {
                        if ("0A000".equals(e.getSQLState())) break block6;
                        throw e;
                    }
                }
                try {
                    cs = this.prepareCall("CALL SYSCS_UTIL.EMPTY_STATEMENT_CACHE() ON TABLE INVALID_CALL_VIEW");
                    cs.execute();
                }
                catch (SQLException e) {
                    if ("0A000".equals(e.getSQLState())) break block7;
                    throw e;
                }
            }
            try {
                cs = this.prepareCall("CALL SYSCS_UTIL.EMPTY_STATEMENT_CACHE() ON TABLE SYSIBM.SYSDUMMY1");
                cs.execute();
            }
            catch (SQLException e) {
                if ("0A000".equals(e.getSQLState())) break block8;
                throw e;
            }
        }
    }

    public void testDDLUnitTestCallStmt() throws SQLException {
        block71: {
            CallableStatement cs;
            block70: {
                block69: {
                    block68: {
                        block67: {
                            block66: {
                                block65: {
                                    block64: {
                                        block63: {
                                            block62: {
                                                block61: {
                                                    block60: {
                                                        block59: {
                                                            block58: {
                                                                block57: {
                                                                    block56: {
                                                                        block55: {
                                                                            block54: {
                                                                                block53: {
                                                                                    block52: {
                                                                                        block51: {
                                                                                            block50: {
                                                                                                block49: {
                                                                                                    String[] sqlstate_xie06_calls;
                                                                                                    ProcedureTest.setup();
                                                                                                    Connection conn = ProcedureTest.getConnection();
                                                                                                    Statement s = conn.createStatement();
                                                                                                    s.execute("CREATE TABLE CALLUT1 (COL1 INTEGER, COL2 INTEGER)");
                                                                                                    s.execute("CREATE TABLE CALLUT2 (COL1 INTEGER, COL2 INTEGER) PARTITION BY COLUMN(COL1)");
                                                                                                    for (String myCall : sqlstate_xie06_calls = new String[]{"SYSCS_UTIL.EXPORT_QUERY(NULL,NULL,NULL,NULL,NULL)", "SYSCS_UTIL.EXPORT_TABLE(NULL,NULL,NULL,NULL,NULL,NULL)", "SYSCS_UTIL.IMPORT_DATA(NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0)", "SYSCS_UTIL.IMPORT_TABLE(NULL,NULL,NULL,NULL,NULL,NULL,0)", "SQLJ.INSTALL_JAR(NULL,NULL,0)", "SQLJ.INSTALL_JAR_BYTES(NULL,NULL)", "SQLJ.REMOVE_JAR(NULL,0)", "SQLJ.REPLACE_JAR(NULL,NULL)", "SQLJ.REPLACE_JAR_BYTES(NULL,NULL)", "SYS.ADD_LISTENER(NULL,NULL,NULL,NULL,NULL,NULL)", "SYS.ATTACH_LOADER(NULL,NULL,NULL,NULL)", "SYS.ATTACH_WRITER(NULL,NULL,NULL,NULL,NULL)", "SYS.REMOVE_LISTENER(NULL,NULL,NULL)", "SYS.REMOVE_LOADER(NULL,NULL)", "SYS.REMOVE_WRITER(NULL,NULL)", "SYS.START_ASYNC_EVENT_LISTENER(NULL)", "SYS.STOP_ASYNC_EVENT_LISTENER(NULL)", "SYS.STOP_GATEWAYSENDER(NULL)", "SYS.START_GATEWAYSENDER(NULL)", "SYS.SET_QUERYSTATS(NULL)", "SYS.CREATE_ALL_BUCKETS(NULL)"}) {
                                                                                                        try {
                                                                                                            CallableStatement cs2 = this.prepareCall("CALL " + myCall);
                                                                                                            cs2.execute();
                                                                                                            ProcedureTest.fail("should fail since nulls not allowed for these calls");
                                                                                                        }
                                                                                                        catch (SQLException e) {
                                                                                                            if ("XIE06".equals(e.getSQLState())) continue;
                                                                                                            throw e;
                                                                                                        }
                                                                                                    }
                                                                                                    try {
                                                                                                        cs = this.prepareCall("CALL SYS.SET_EVICTION_HEAP_PERCENTAGE(-5)");
                                                                                                        cs.execute();
                                                                                                        ProcedureTest.fail("should fail as percentage is negative");
                                                                                                    }
                                                                                                    catch (SQLException e) {
                                                                                                        if ("38000".equals(e.getSQLState())) break block49;
                                                                                                        throw e;
                                                                                                    }
                                                                                                }
                                                                                                try {
                                                                                                    cs = this.prepareCall("CALL SYS.SET_EVICTION_HEAP_PERCENTAGE(444)");
                                                                                                    cs.execute();
                                                                                                    ProcedureTest.fail("should fail as percentage is greater than 100");
                                                                                                }
                                                                                                catch (SQLException e) {
                                                                                                    if ("38000".equals(e.getSQLState())) break block50;
                                                                                                    throw e;
                                                                                                }
                                                                                            }
                                                                                            try {
                                                                                                cs = this.prepareCall("CALL SYS.SET_CRITICAL_HEAP_PERCENTAGE(-5)");
                                                                                                cs.execute();
                                                                                                ProcedureTest.fail("should fail as percentage is negative");
                                                                                            }
                                                                                            catch (SQLException e) {
                                                                                                if ("38000".equals(e.getSQLState())) break block51;
                                                                                                throw e;
                                                                                            }
                                                                                        }
                                                                                        try {
                                                                                            cs = this.prepareCall("CALL SYS.SET_CRITICAL_HEAP_PERCENTAGE(444)");
                                                                                            cs.execute();
                                                                                            ProcedureTest.fail("should fail as percentage is greater than 100");
                                                                                        }
                                                                                        catch (SQLException e) {
                                                                                            if ("38000".equals(e.getSQLState())) break block52;
                                                                                            throw e;
                                                                                        }
                                                                                    }
                                                                                    try {
                                                                                        cs = this.prepareCall("CALL SYS.SET_EVICTION_OFFHEAP_PERCENTAGE(-5)");
                                                                                        cs.execute();
                                                                                        ProcedureTest.fail("should fail as percentage is negative");
                                                                                    }
                                                                                    catch (SQLException e) {
                                                                                        if ("38000".equals(e.getSQLState())) break block53;
                                                                                        throw e;
                                                                                    }
                                                                                }
                                                                                try {
                                                                                    cs = this.prepareCall("CALL SYS.SET_EVICTION_OFFHEAP_PERCENTAGE(444)");
                                                                                    cs.execute();
                                                                                    ProcedureTest.fail("should fail as percentage is greater than 100");
                                                                                }
                                                                                catch (SQLException e) {
                                                                                    if ("38000".equals(e.getSQLState())) break block54;
                                                                                    throw e;
                                                                                }
                                                                            }
                                                                            try {
                                                                                cs = this.prepareCall("CALL SYS.SET_CRITICAL_OFFHEAP_PERCENTAGE(-5)");
                                                                                cs.execute();
                                                                                ProcedureTest.fail("should fail as percentage is negative");
                                                                            }
                                                                            catch (SQLException e) {
                                                                                if ("38000".equals(e.getSQLState())) break block55;
                                                                                throw e;
                                                                            }
                                                                        }
                                                                        try {
                                                                            cs = this.prepareCall("CALL SYS.SET_CRITICAL_OFFHEAP_PERCENTAGE(444)");
                                                                            cs.execute();
                                                                            ProcedureTest.fail("should fail as percentage is greater than 100");
                                                                        }
                                                                        catch (SQLException e) {
                                                                            if ("38000".equals(e.getSQLState())) break block56;
                                                                            throw e;
                                                                        }
                                                                    }
                                                                    try {
                                                                        cs = this.prepareCall("CALL SYS.CREATE_USER(NULL,NULL)");
                                                                        cs.execute();
                                                                        ProcedureTest.fail("should fail as userid is null");
                                                                    }
                                                                    catch (SQLException e) {
                                                                        if ("28502".equals(e.getSQLState())) break block57;
                                                                        throw e;
                                                                    }
                                                                }
                                                                try {
                                                                    cs = this.prepareCall("CALL SYS.DROP_USER(NULL)");
                                                                    cs.execute();
                                                                    ProcedureTest.fail("should fail as userid is null");
                                                                }
                                                                catch (SQLException e) {
                                                                    if ("28502".equals(e.getSQLState())) break block58;
                                                                    throw e;
                                                                }
                                                            }
                                                            try {
                                                                cs = this.prepareCall("CALL SYS.CREATE_ALL_BUCKETS('SYS.SYSTABLES')");
                                                                cs.execute();
                                                                ProcedureTest.fail("should fail as table is not partitioned");
                                                            }
                                                            catch (SQLException e) {
                                                                if ("X0Z15".equals(e.getSQLState())) break block59;
                                                                throw e;
                                                            }
                                                        }
                                                        try {
                                                            cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() WITH RESULT PROCESSOR X");
                                                            cs.execute();
                                                            ProcedureTest.fail("should fail as result processor class is missing");
                                                        }
                                                        catch (SQLException e) {
                                                            if ("42X51".equals(e.getSQLState())) break block60;
                                                            throw e;
                                                        }
                                                    }
                                                    try {
                                                        cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE MISSINGTABLE");
                                                        cs.execute();
                                                        ProcedureTest.fail("should fail as table is missing");
                                                    }
                                                    catch (SQLException e) {
                                                        if ("42X05".equals(e.getSQLState())) break block61;
                                                        throw e;
                                                    }
                                                }
                                                try {
                                                    cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE SYS.SYSTABLES");
                                                    cs.execute();
                                                    ProcedureTest.fail("should fail as table is not legal target");
                                                }
                                                catch (SQLException e) {
                                                    if ("0A000".equals(e.getSQLState())) break block62;
                                                    throw e;
                                                }
                                            }
                                            try {
                                                cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE CALLUT2 WHERE COL1 IN (SELECT COL1 FROM CALLUT1)");
                                                cs.execute();
                                                ProcedureTest.fail("should fail as where clause is not scalar");
                                            }
                                            catch (SQLException e) {
                                                if ("42904".equals(e.getSQLState())) break block63;
                                                throw e;
                                            }
                                        }
                                        try {
                                            cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE CALLUT2 WHERE COL99 = 4");
                                            cs.execute();
                                            ProcedureTest.fail("should fail as where clause references missing column");
                                        }
                                        catch (SQLException e) {
                                            if ("42X04".equals(e.getSQLState())) break block64;
                                            throw e;
                                        }
                                    }
                                    try {
                                        cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE CALLUT2 WHERE MAX(COL1) = 5");
                                        cs.execute();
                                        ProcedureTest.fail("should fail as where clause contains an aggregate");
                                    }
                                    catch (SQLException e) {
                                        if ("42903".equals(e.getSQLState())) break block65;
                                        throw e;
                                    }
                                }
                                try {
                                    cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE CALLUT2 WHERE 5");
                                    cs.execute();
                                    ProcedureTest.fail("should fail as where clause is a constant");
                                }
                                catch (SQLException e) {
                                    if ("42X19".equals(e.getSQLState())) break block66;
                                    throw e;
                                }
                            }
                            try {
                                cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE CALLUT2 WHERE NULL");
                                cs.execute();
                                ProcedureTest.fail("should fail as where clause is a null - syntax error");
                            }
                            catch (SQLException e) {
                                if ("42X01".equals(e.getSQLState())) break block67;
                                throw e;
                            }
                        }
                        try {
                            cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE CALLUT2 ON ALL");
                            cs.execute();
                            ProcedureTest.fail("should fail with syntax error");
                        }
                        catch (SQLException e) {
                            if ("42X01".equals(e.getSQLState())) break block68;
                            throw e;
                        }
                    }
                    try {
                        cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE CALLUT2 ON SERVER GROUPS()");
                        cs.execute();
                        ProcedureTest.fail("should fail with syntax error");
                    }
                    catch (SQLException e) {
                        if ("42X01".equals(e.getSQLState())) break block69;
                        throw e;
                    }
                }
                try {
                    cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON SERVER GROUPS ()");
                    cs.execute();
                    ProcedureTest.fail("should fail with syntax error");
                }
                catch (SQLException e) {
                    if ("42X01".equals(e.getSQLState())) break block70;
                    throw e;
                }
            }
            try {
                cs = this.prepareCall("CALL SYS.BALANCE_ALL_BUCKETS() ON TABLE CALLUT1 ON TABLE CALLUT2");
                cs.execute();
                ProcedureTest.fail("should fail with syntax error");
            }
            catch (SQLException e) {
                if ("42X01".equals(e.getSQLState())) break block71;
                throw e;
            }
        }
    }

    public static void procSecuritasBug(Timestamp time) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement stmt = c.prepareStatement("update test set time2= ?");
        stmt.setTimestamp(1, time);
        stmt.executeUpdate();
    }

    public static void procSecuritasBug_2(ResultSet[] external) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = c.createStatement();
        external[0] = stmt.executeQuery("select time2 from test");
    }

    public static class ExampleObj
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int val;

        public void setValue(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }
}

