/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ProcedureAuthorizationTest
extends JdbcTestBase {
    Properties props = new Properties();

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ProcedureAuthorizationTest.class));
    }

    public ProcedureAuthorizationTest(String name) {
        super(name);
    }

    public void verifyUnauthorizedExecution(CallableStatement tCallableSt, boolean withContextConn) throws SQLException {
        block11: {
            int param2;
            block10: {
                block9: {
                    block8: {
                        param2 = withContextConn ? 0 : 1;
                        tCallableSt.setInt(1, 1);
                        tCallableSt.setInt(2, param2);
                        try {
                            tCallableSt.execute();
                        }
                        catch (SQLException e) {
                            if (e.getSQLState().equals("42502") || e.getSQLState().equals("38002")) break block8;
                            throw e;
                        }
                    }
                    tCallableSt.setInt(1, 2);
                    tCallableSt.setInt(2, param2);
                    try {
                        tCallableSt.execute();
                    }
                    catch (SQLException e) {
                        if (e.getSQLState().equals("42500") || e.getSQLState().equals("38002")) break block9;
                        throw e;
                    }
                }
                tCallableSt.setInt(1, 3);
                tCallableSt.setInt(2, param2);
                try {
                    tCallableSt.execute();
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("42502") || e.getSQLState().equals("38002")) break block10;
                    throw e;
                }
            }
            tCallableSt.setInt(1, 4);
            tCallableSt.setInt(2, param2);
            try {
                tCallableSt.execute();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42500") || e.getSQLState().equals("38002")) break block11;
                throw e;
            }
        }
    }

    public void verifyUnauthorizedExecutionForReadOnlyProc_(CallableStatement tCallableSt, boolean withContextConn) throws SQLException {
        block11: {
            int param2;
            block10: {
                block9: {
                    block8: {
                        param2 = withContextConn ? 0 : 1;
                        tCallableSt.setInt(1, 1);
                        tCallableSt.setInt(2, param2);
                        try {
                            tCallableSt.execute();
                        }
                        catch (SQLException e) {
                            if (e.getSQLState().equals("42502")) break block8;
                            throw e;
                        }
                    }
                    tCallableSt.setInt(1, 2);
                    tCallableSt.setInt(2, param2);
                    try {
                        tCallableSt.execute();
                    }
                    catch (SQLException e) {
                        if (e.getSQLState().equals("38002")) break block9;
                        throw e;
                    }
                }
                tCallableSt.setInt(1, 3);
                tCallableSt.setInt(2, param2);
                try {
                    tCallableSt.execute();
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("38002")) break block10;
                    throw e;
                }
            }
            tCallableSt.setInt(1, 4);
            tCallableSt.setInt(2, param2);
            try {
                tCallableSt.execute();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("38002")) break block11;
                throw e;
            }
        }
    }

    public void testProcedureAuthorization_ModifiesSQLData() throws SQLException {
        this.props.put("auth-provider", "BUILTIN");
        this.props.put("gemfirexd.user.APP", "APP");
        this.props.put("gemfirexd.sql-authorization", "TRUE");
        this.props.put("user", "APP");
        this.props.put("password", "APP");
        this.props.setProperty("mcast-port", "0");
        ProcedureAuthorizationTest.loadDriverClass(TestUtil.getDriver());
        this.props = ProcedureAuthorizationTest.doCommonSetup(this.props);
        Connection conn = DriverManager.getConnection(TestUtil.getProtocol(), this.props);
        Statement st = conn.createStatement();
        st.execute("DROP TABLE IF EXISTS TESTSCHEMA.T");
        st.execute("DROP SCHEMA IF EXISTS TESTSCHEMA RESTRICT");
        st.execute("CREATE SCHEMA TESTSCHEMA");
        st.execute("CREATE TABLE TESTSCHEMA.T(C1 INT, C2 INT)");
        st.execute("CALL SYS.CREATE_USER('gemfirexd.user.TUSER','TPASSWORD')");
        Properties props2 = new Properties();
        props2.put("user", "TUSER");
        props2.put("password", "TPASSWORD");
        Connection tconn = DriverManager.getConnection(TestUtil.getProtocol(), props2);
        Statement tstatement = tconn.createStatement();
        tstatement.execute("DROP PROCEDURE IF EXISTS TUSER.EXAMPLE_PROC");
        String createProc = "CREATE PROCEDURE TUSER.EXAMPLE_PROC(IN S_MONTH INTEGER,IN S_YEAR INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.ProcedureAuthorizationTest.exampleProc'";
        tstatement.execute(createProc);
        CallableStatement tCallableSt = tconn.prepareCall("CALL TUSER.EXAMPLE_PROC(?,?)");
        this.verify(st, tCallableSt, true, false);
        this.verify(st, tCallableSt, false, false);
    }

    public void testProcedureAuthorization_ReadsSQLData() throws SQLException {
        this.props.put("auth-provider", "BUILTIN");
        this.props.put("gemfirexd.user.APP", "APP");
        this.props.put("gemfirexd.sql-authorization", "TRUE");
        this.props.put("user", "APP");
        this.props.put("password", "APP");
        this.props.setProperty("mcast-port", "0");
        ProcedureAuthorizationTest.loadDriverClass(TestUtil.getDriver());
        this.props = ProcedureAuthorizationTest.doCommonSetup(this.props);
        Connection conn = DriverManager.getConnection(TestUtil.getProtocol(), this.props);
        Statement st = conn.createStatement();
        st.execute("DROP TABLE IF EXISTS TESTSCHEMA.T");
        st.execute("DROP SCHEMA IF EXISTS TESTSCHEMA RESTRICT");
        st.execute("CREATE SCHEMA TESTSCHEMA");
        st.execute("CREATE TABLE TESTSCHEMA.T(C1 INT, C2 INT)");
        st.execute("CALL SYS.CREATE_USER('gemfirexd.user.TUSER','TPASSWORD')");
        Properties props2 = new Properties();
        props2.put("user", "TUSER");
        props2.put("password", "TPASSWORD");
        Connection tconn = DriverManager.getConnection(TestUtil.getProtocol(), props2);
        Statement tstatement = tconn.createStatement();
        tstatement.execute("DROP PROCEDURE IF EXISTS TUSER.EXAMPLE_PROC");
        String createProc = "CREATE PROCEDURE TUSER.EXAMPLE_PROC(IN S_MONTH INTEGER,IN S_YEAR INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.ProcedureAuthorizationTest.exampleProc'";
        tstatement.execute(createProc);
        CallableStatement tCallableSt = tconn.prepareCall("CALL TUSER.EXAMPLE_PROC(?,?)");
        this.verify(st, tCallableSt, true, true);
        this.verify(st, tCallableSt, false, true);
    }

    public void testProcedureAuthorization_NoSQL() throws SQLException {
        block5: {
            CallableStatement tCallableSt;
            Statement st;
            block4: {
                this.props.put("auth-provider", "BUILTIN");
                this.props.put("gemfirexd.user.APP", "APP");
                this.props.put("gemfirexd.sql-authorization", "TRUE");
                this.props.put("user", "APP");
                this.props.put("password", "APP");
                this.props.setProperty("mcast-port", "0");
                ProcedureAuthorizationTest.loadDriverClass(TestUtil.getDriver());
                this.props = ProcedureAuthorizationTest.doCommonSetup(this.props);
                Connection conn = DriverManager.getConnection(TestUtil.getProtocol(), this.props);
                st = conn.createStatement();
                st.execute("DROP TABLE IF EXISTS TESTSCHEMA.T");
                st.execute("DROP SCHEMA IF EXISTS TESTSCHEMA RESTRICT");
                st.execute("CREATE SCHEMA TESTSCHEMA");
                st.execute("CREATE TABLE TESTSCHEMA.T(C1 INT, C2 INT)");
                st.execute("CALL SYS.CREATE_USER('gemfirexd.user.TUSER','TPASSWORD')");
                Properties props2 = new Properties();
                props2.put("user", "TUSER");
                props2.put("password", "TPASSWORD");
                Connection tconn = DriverManager.getConnection(TestUtil.getProtocol(), props2);
                Statement tstatement = tconn.createStatement();
                tstatement.execute("DROP PROCEDURE IF EXISTS TUSER.EXAMPLE_PROC");
                String createProc = "CREATE PROCEDURE TUSER.EXAMPLE_PROC(IN S_MONTH INTEGER,IN S_YEAR INTEGER) LANGUAGE JAVA PARAMETER STYLE JAVA NO SQL EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.ProcedureAuthorizationTest.exampleProc'";
                tstatement.execute(createProc);
                tCallableSt = tconn.prepareCall("CALL TUSER.EXAMPLE_PROC(?,?)");
                try {
                    this.verify(st, tCallableSt, true, true);
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("38001")) break block4;
                    throw e;
                }
            }
            try {
                this.verify(st, tCallableSt, false, true);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("38001")) break block5;
                throw e;
            }
        }
    }

    public void assertExecutionException(CallableStatement tCallableSt, String errorCode) throws SQLException {
        boolean thrown = false;
        try {
            tCallableSt.execute();
        }
        catch (SQLException e) {
            if (e.getSQLState().equals(errorCode)) {
                thrown = true;
            }
            throw e;
        }
        ProcedureAuthorizationTest.assertTrue((boolean)thrown);
    }

    public void verify(Statement first, CallableStatement second, boolean withContextConnection, boolean readOnlyProc) throws SQLException {
        Statement st = first;
        CallableStatement tCallableSt = second;
        this.verifyUnauthorizedExecution(tCallableSt, withContextConnection);
        st.execute("GRANT SELECT ON TESTSCHEMA.T TO TUSER");
        tCallableSt.setInt(1, 1);
        tCallableSt.setInt(2, 0);
        tCallableSt.execute();
        st.execute("GRANT INSERT ON TESTSCHEMA.T TO TUSER");
        tCallableSt.setInt(1, 2);
        tCallableSt.setInt(2, 0);
        if (readOnlyProc) {
            this.assertExecutionException(tCallableSt, "38002");
        } else {
            tCallableSt.execute();
        }
        st.execute("GRANT UPDATE ON TESTSCHEMA.T TO TUSER");
        tCallableSt.setInt(1, 3);
        tCallableSt.setInt(2, 0);
        if (readOnlyProc) {
            this.assertExecutionException(tCallableSt, "38002");
        } else {
            tCallableSt.execute();
        }
        st.execute("GRANT DELETE ON TESTSCHEMA.T TO TUSER");
        tCallableSt.setInt(1, 4);
        tCallableSt.setInt(2, 0);
        if (readOnlyProc) {
            this.assertExecutionException(tCallableSt, "38002");
        } else {
            tCallableSt.execute();
        }
        st.execute("REVOKE SELECT ON TESTSCHEMA.T FROM TUSER");
        st.execute("REVOKE INSERT ON TESTSCHEMA.T FROM TUSER");
        st.execute("REVOKE UPDATE ON TESTSCHEMA.T FROM TUSER");
        st.execute("REVOKE DELETE ON TESTSCHEMA.T FROM TUSER");
        this.verifyUnauthorizedExecution(tCallableSt, withContextConnection);
    }

    public static void exampleProc(int inParam1, int inParam2, ProcedureExecutionContext ctx) throws SQLException {
        Statement st = null;
        if (inParam2 == 0) {
            Connection conn = ctx.getConnection();
            st = conn.createStatement();
        } else {
            Properties props2 = new Properties();
            props2.put("user", "TUSER");
            props2.put("password", "TPASSWORD");
            Connection tconn = DriverManager.getConnection(TestUtil.getProtocol(), props2);
            st = tconn.createStatement();
        }
        if (inParam1 == 1) {
            st.execute("SELECT * FROM TESTSCHEMA.T");
        } else if (inParam1 == 2) {
            st.execute("INSERT INTO TESTSCHEMA.T VALUES(4,4)");
        } else if (inParam1 == 3) {
            st.execute("UPDATE TESTSCHEMA.T SET C1 = 3 WHERE C1 = 4");
        } else if (inParam1 == 4) {
            st.execute("DELETE FROM TESTSCHEMA.T WHERE C1 = 3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            ProcedureAuthorizationTest.shutDown(this.props);
            currentUserName = null;
            currentUserPassword = null;
        }
        finally {
            super.tearDown();
            String[] dirs = this.testSpecificDirectoriesForDeletion();
            if (dirs != null) {
                for (String dir : dirs) {
                    ProcedureAuthorizationTest.deleteDir(new File(dir));
                }
            }
            ProcedureAuthorizationTest.clearAllOplogFiles();
        }
    }
}

