/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.dataawareprocedure.MergeSortDUnit;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.procedure.OutgoingResultSet;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class Procedure2Test
extends JdbcTestBase {
    private List<Statement> statements;
    static int tidGot = -1;
    static BigDecimal subtotalGot = new BigDecimal(-1);
    private static int delInvokeCnt = 0;
    private static final String[] PROCEDURES = new String[]{"CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".retrieveDynamicResults' " + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE RETRIEVE_OUTGOING_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".retrieveDynamicResultsWithOutgoingResultSet'" + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE PROCEDURE_INOUT_PARAMETERS(number INT, INOUT name VARCHAR(25), OUT total INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".procedureWithInAndOutParameters'" + "DYNAMIC RESULT SETS 4", "CREATE PROCEDURE PROCEDURE_WITHOUT_RESULTSET(number INT, INOUT name VARCHAR(20) ) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".procedureWithoutDynamicResultSets'", "CREATE PROCEDURE PROCEDURE_WITHOUT_RESULTSET_OUTPARAMETER(number INT, name VARCHAR(20) ) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".procedureWithoutDynamicResultSetsAndOutParameters'", "CREATE PROCEDURE RETRIEVE_CLOSED_RESULT() LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".retrieveClosedResult' " + "DYNAMIC RESULT SETS 1", "CREATE PROCEDURE RETRIEVE_EXTERNAL_RESULT(DBNAME VARCHAR(128), DBUSER VARCHAR(128), DBPWD VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".retrieveExternalResult' " + "DYNAMIC RESULT SETS 1", "CREATE PROCEDURE PROC_WITH_SIDE_EFFECTS(ret INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".procWithSideEffects' " + "DYNAMIC RESULT SETS 2", "CREATE PROCEDURE NESTED_RESULT_SETS(proctext VARCHAR(128)) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + Procedure2Test.class.getName() + ".nestedDynamicResultSets' " + "DYNAMIC RESULT SETS 6"};
    private static final String[][] TABLES = new String[][]{{"SIMPLE_TABLE", "CREATE TABLE SIMPLE_TABLE (id INT)"}};

    public Procedure2Test(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(Procedure2Test.class));
    }

    public static void selectOnlyIn(int cid1, int cid2, int sid, int tid, ResultSet[] rs, ResultSet[] rs2, ResultSet[] rs3, ProcedureExecutionContext context) throws SQLException {
        Procedure2Test.getLogger().info((Object)"method executed");
    }

    public static void selectInAsWellASOut(int cid1, int cid2, int sid, int tid, int[] data, ResultSet[] rs, ResultSet[] rs2, ResultSet[] rs3, ProcedureExecutionContext context) throws SQLException {
        Procedure2Test.getLogger().info((Object)"method executed");
    }

    public void testProperExceptionInvalidProcClassName() throws SQLException {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME '" + MergeSortDUnit.class.getName() + "garbage.mergeSort' ");
            s.execute("CREATE ALIAS MergeSortProcessor FOR '" + MergeSortDUnit.MergeSortProcessor.class.getName() + "garbage'");
            s.execute("CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor");
            Procedure2Test.fail("should not proceed");
        }
        catch (SQLException e) {
            Procedure2Test.assertEquals((String)"42X51", (String)e.getSQLState());
        }
    }

    public void testProperExceptionInvalidProcessorClassName() throws SQLException {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME '" + MergeSortDUnit.class.getName() + ".mergeSort' ");
            s.execute("CREATE ALIAS MergeSortProcessor FOR '" + MergeSortDUnit.MergeSortProcessor.class.getName() + "garbage'");
            s.execute("CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor");
            Procedure2Test.fail("should not proceed");
        }
        catch (SQLException e) {
            Procedure2Test.assertEquals((String)"42X51", (String)e.getSQLState());
        }
    }

    public void testBug42875_OUT() throws SQLException {
        String showGfxdPortfolio = "create procedure trade.showGfxdPortfolio(IN DP1 Integer, IN DP2 Integer, IN DP3 Integer, IN DP4 Integer, OUT DP5 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 3 EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Procedure2Test.selectInAsWellASOut'";
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table trade.portfolio (cid int not null, tid int not null)");
        s.execute(showGfxdPortfolio);
        CallableStatement cs = conn.prepareCall(" call trade.showGfxdPortfolio(?, ?, ?, ?, ?) ON Table trade.portfolio where cid > 258 and cid< 1113 and tid=2");
        cs.setInt(1, 1);
        cs.setInt(2, 2);
        cs.setInt(3, 3);
        cs.setInt(4, 4);
        cs.registerOutParameter(5, 4);
        cs.execute();
    }

    public void testBug42875_onlyIN() throws SQLException {
        String showGfxdPortfolio = "create procedure trade.showGfxdPortfolio(IN DP1 Integer, IN DP2 Integer, IN DP3 Integer, IN DP4 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 3 EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Procedure2Test.selectOnlyIn'";
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table trade.portfolio (cid int not null, tid int not null)");
        s.execute(showGfxdPortfolio);
        CallableStatement cs = conn.prepareCall(" call trade.showGfxdPortfolio(?, ?, ?, ?) ON Table trade.portfolio where cid > 258 and cid< 1113 and tid=2");
        cs.setInt(1, 1);
        cs.setInt(2, 2);
        cs.setInt(3, 3);
        cs.setInt(4, 4);
        cs.execute();
    }

    public static void updateGfxdPortfolioByCidRange(BigDecimal subTotal, int tid, ProcedureExecutionContext context) throws SQLException {
        tidGot = tid;
        subtotalGot = subTotal;
    }

    public void testBug42963_NPEInBCMethod() throws SQLException {
        String updateGfxdPortfolioByCidRange = "create procedure trade.updateGfxdPortfolioByCidRange(IN DP1 DECIMAL(30, 20), IN DP2 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA Modifies SQL DATA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Procedure2Test.updateGfxdPortfolioByCidRange'";
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table trade.portfolio (cid int not null, tid int not null)");
        s.execute(updateGfxdPortfolioByCidRange);
        CallableStatement cs = conn.prepareCall("{call trade.updateGfxdPortfolioByCidRange(?, ?) ON Table trade.portfolio where cid > 474 and cid< 2055 and tid=17}");
        cs.setInt(1, 1);
        cs.setInt(2, 2);
        cs.execute();
        Procedure2Test.assertEquals((int)2, (int)tidGot);
    }

    public void testExecuteQueryWithNoDynamicResultSets_prepared() throws SQLException {
        Procedure2Test.setup();
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 0);
        try {
            ps.executeQuery();
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet_prepared() throws SQLException {
        Procedure2Test.setup();
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 1);
        ResultSet rs = ps.executeQuery();
        Procedure2Test.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        Procedure2Test.assertSame((Object)ps, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet_prepared() throws SQLException {
        Procedure2Test.setup();
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 2);
        try {
            ps.executeQuery();
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testExecuteUpdateWithNoDynamicResultSets_prepared() throws SQLException {
        Procedure2Test.setup();
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 0);
        JDBC.assertNoMoreResults(ps);
    }

    public void testExecuteUpdateWithOneDynamicResultSet_prepared() throws SQLException {
        Procedure2Test.setup();
        PreparedStatement ps = this.prepareStatement("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        ps.setInt(1, 1);
        try {
            ps.executeUpdate();
            Procedure2Test.fail("executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void testExecuteQueryWithNoDynamicResultSets_callable() throws SQLException {
        Procedure2Test.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 0);
        try {
            cs.executeQuery();
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public void testExecuteQueryWithOneDynamicResultSet_callable() throws SQLException {
        Procedure2Test.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 1);
        ResultSet rs = cs.executeQuery();
        Procedure2Test.assertNotNull((String)"executeQuery() returned null.", (Object)rs);
        Procedure2Test.assertSame((Object)cs, (Object)rs.getStatement());
        JDBC.assertDrainResultsHasData(rs);
    }

    public void testExecuteQueryWithMoreThanOneDynamicResultSet_callable() throws SQLException {
        Procedure2Test.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 2);
        try {
            cs.executeQuery();
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
    }

    public void testCreateProcedureResultProcessorAlias() throws SQLException {
        Procedure2Test.setup();
        Statement s = Procedure2Test.getConnection().createStatement();
        s.execute("CREATE ALIAS MergeSortProcessor FOR '" + MergeSortDUnit.class.getName() + ".MergeSortProcessor'");
    }

    public void testAlias() throws Exception {
        Statement s = Procedure2Test.getConnection().createStatement();
        s.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME '" + MergeSortDUnit.class.getName() + ".justanothermergeSort' ");
        s.execute("CREATE ALIAS MergeSortProcessor FOR '" + MergeSortDUnit.MergeSortProcessor.class.getName() + "'");
        CallableStatement cs = this.prepareCall("CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor");
        cs.execute();
        cs.getResultSet();
    }

    public void _testDataAwareProcedureWithOutgoingResultSetsWithoutNodesToExecute() throws SQLException {
        Procedure2Test.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_OUTGOING_RESULTS(?) ON TABLE EMP.PARTITIONEMPTYTESTTABLE WHERE ID in (?, ?, ?)");
        int number = 2;
        cs.setInt(1, number);
        cs.setInt(2, 2);
        cs.setInt(3, 3);
        cs.setInt(4, 4);
        cs.execute();
        do {
            ResultSet rs;
            ResultSetMetaData metaData;
            int rowCount;
            if ((rowCount = (metaData = (rs = cs.getResultSet()).getMetaData()).getColumnCount()) == 0 && !rs.next()) continue;
            Procedure2Test.fail("The result set is supposed to be empty!");
        } while (cs.getMoreResults());
    }

    public void testExecuteUpdateWithOneDynamicResultSet_callable() throws SQLException {
        Procedure2Test.setup();
        CallableStatement cs = this.prepareCall("CALL RETRIEVE_DYNAMIC_RESULTS(?)");
        cs.setInt(1, 1);
        try {
            cs.executeUpdate();
            Procedure2Test.fail("executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
    }

    public void _testRollbackStoredProcWithExecuteQuery() throws SQLException {
        Procedure2Test.setup();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(1)");
        rs.close();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void _testRollbackStoredProcWithExecuteUpdate() throws SQLException {
        Procedure2Test.setup();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL PROC_WITH_SIDE_EFFECTS(0)");
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void _testRollbackStoredProcWhenExecuteQueryReturnsNothing() throws SQLException {
        Connection conn = Procedure2Test.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(0)");
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void _testRollbackStoredProcWhenExecuteQueryReturnsTooMuch() throws SQLException {
        Connection conn = Procedure2Test.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL PROC_WITH_SIDE_EFFECTS(2)");
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void _testRollbackStoredProcWhenExecuteUpdateReturnsResults() throws SQLException {
        Connection conn = Procedure2Test.getConnection();
        conn.setAutoCommit(true);
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("CALL PROC_WITH_SIDE_EFFECTS(1)");
            Procedure2Test.fail("executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void _testRollbackStoredProcWhenExecuteQueryReturnsNothing_prepared() throws SQLException {
        Connection conn = Procedure2Test.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 0);
        try {
            ps.executeQuery();
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void _testRollbackStoredProcWhenExecuteQueryReturnsTooMuch_prepared() throws SQLException {
        Connection conn = Procedure2Test.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 2);
        try {
            ps.executeQuery();
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertMultipleResultsFromExecuteQuery(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void _testRollbackStoredProcWhenExecuteUpdateReturnsResults_prepared() throws SQLException {
        Connection conn = Procedure2Test.getConnection();
        conn.setAutoCommit(true);
        PreparedStatement ps = this.prepareStatement("CALL PROC_WITH_SIDE_EFFECTS(?)");
        ps.setInt(1, 1);
        try {
            ps.executeUpdate();
            Procedure2Test.fail("executeUpdate() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertResultsFromExecuteUpdate(sqle);
        }
        Statement stmt = this.createStatement();
        JDBC.assertEmpty(stmt.executeQuery("SELECT * FROM SIMPLE_TABLE"));
    }

    public void testClosedDynamicResultSetsFromExecuteQuery() throws SQLException {
        Procedure2Test.setup();
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("CALL RETRIEVE_CLOSED_RESULT()");
            Procedure2Test.fail("executeQuery() didn't fail.");
        }
        catch (SQLException sqle) {
            this.assertNoResultSetFromExecuteQuery(sqle);
        }
    }

    public static void procreadssql(ResultSet[] outResults, ProcedureExecutionContext context) throws SQLException {
        ++delInvokeCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteTriggerWhichHasProc() throws SQLException {
        ResultSet rs;
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t2(col1 int not null, col2 int not null primary key)");
        s.execute("CREATE PROCEDURE proc_reads_sql () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME '" + Procedure2Test.class.getName() + ".procreadssql' ");
        try {
            s.execute("create trigger before_row_trig_reads_sql no cascade BEFORE delete on t2 for each ROW call proc_reads_sql()");
            s.execute("insert into t2 values(1, 11), (2, 22)");
            s.execute("delete from t2");
            rs = s.executeQuery("select * from t2");
            while (rs.next()) {
                Procedure2Test.fail("table should have been empty");
            }
        }
        finally {
            s.execute("drop trigger before_row_trig_reads_sql");
        }
        s.execute("insert into t2 values(1, 11), (2, 22)");
        rs = s.executeQuery("select * from t2");
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        Procedure2Test.assertEquals((int)2, (int)cnt);
        Procedure2Test.assertEquals((int)2, (int)delInvokeCnt);
    }

    public void testClosedDynamicResultSetsFromExecuteUpdate() throws SQLException {
        Procedure2Test.setup();
        Statement stmt = this.createStatement();
        stmt.executeUpdate("CALL RETRIEVE_CLOSED_RESULT()");
        JDBC.assertNoMoreResults(stmt);
    }

    private void assertNoResultSetFromExecuteQuery(SQLException sqle) {
        Procedure2Test.assertSQLState("Unexpected SQL state.", "X0Y78", sqle);
    }

    private void assertMultipleResultsFromExecuteQuery(SQLException sqle) {
        Procedure2Test.assertSQLState("Unexpected SQL state.", "X0Y78", sqle);
    }

    private void assertResultsFromExecuteUpdate(SQLException sqle) {
        Procedure2Test.assertSQLState("Unexpected SQL state.", "X0Y79", sqle);
    }

    private static void setup() throws SQLException {
        int i;
        Connection conn = Procedure2Test.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID))");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (4, 4, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (5, 5, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '2') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4') ");
        s.execute("SELECT * FROM EMP.PARTITIONTESTTABLE WHERE (SECONDID=10 AND THIRDID='20') OR (SECONDID=10 AND THIRDID='20')");
        s.execute("create table EMP.PARTITIONTESTTABLE1 (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (3, 3, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (4, 4, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (5, 5, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '2') ");
        s.execute("INSERT INTO EMP.PARTITIONTESTTABLE1 VALUES (2, 2, '4') ");
        s.execute("create table EMP.PARTITIONRANGETESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 1 and 10, VALUES BETWEEN 10 and 20, VALUES BETWEEN 20 and 30, VALUES BETWEEN 30 and 40 )");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (1, 2, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (10, 3, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (15, 4, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (21, 5, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (30, 2, '2') ");
        s.execute("INSERT INTO EMP.PARTITIONRANGETESTTABLE VALUES (35, 2, '4') ");
        s.execute("create table EMP.PARTITIONLISTTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY LIST ( ID ) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31, 100))");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (0, 2, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (5, 3, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (15, 4, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (30, 5, '3') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (31, 2, '2') ");
        s.execute("INSERT INTO EMP.PARTITIONLISTTESTTABLE VALUES (25, 2, '4') ");
        s.execute("create table EMP.PARTITIONEMPTYTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (ID)) PARTITION BY COLUMN ( ID )");
        for (i = 0; i < PROCEDURES.length; ++i) {
            s.execute(PROCEDURES[i]);
        }
        for (i = 0; i < TABLES.length; ++i) {
            s.execute(TABLES[i][1]);
        }
        conn.close();
    }

    public static void retrieveDynamicResults(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void procedureWithInAndOutParameters(int number, String[] name, int[] total, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        name[0] = name[0] + "Modified";
        total[0] = number;
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void procedureWithoutDynamicResultSets(int number, String[] name) throws SQLException {
        name[0] = name[0] + number;
    }

    public static void procedureWithoutDynamicResultSetsAndOutParameters(int number, String name) throws SQLException {
    }

    public static void retrieveDynamicResultsWithOutgoingResultSet(int number, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ProcedureExecutionContext pec) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        if (number > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 1) {
            OutgoingResultSet ors = pec.getOutgoingResultSet(2);
            for (int i = 0; i < 10; ++i) {
                ArrayList<Object> row = new ArrayList<Object>();
                row.add(new Integer(i));
                row.add("String" + i);
                ors.addRow(row);
            }
            ors.endResults();
        }
        if (number > 2) {
            rs3[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (number > 3) {
            rs4[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void retrieveClosedResult(ResultSet[] closed2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        closed2[0] = c.createStatement().executeQuery("VALUES(1)");
        closed2[0].close();
    }

    public static void retrieveExternalResult(String dbName, String user, String password, ResultSet[] external) throws SQLException {
        String url = "jdbc:derby:" + dbName;
        Connection conn = DriverManager.getConnection(url, user, password);
        external[0] = conn.createStatement().executeQuery("VALUES(1)");
    }

    public static void procWithSideEffects(int returnResults, ResultSet[] rs1, ResultSet[] rs2) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = c.createStatement();
        stmt.executeUpdate("INSERT INTO SIMPLE_TABLE VALUES (42)");
        if (returnResults > 0) {
            rs1[0] = c.createStatement().executeQuery("VALUES(1)");
        }
        if (returnResults > 1) {
            rs2[0] = c.createStatement().executeQuery("VALUES(1)");
        }
    }

    public static void nestedDynamicResultSets(String procedureText, ResultSet[] rs1, ResultSet[] rs2, ResultSet[] rs3, ResultSet[] rs4, ResultSet[] rs5, ResultSet[] rs6) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        CallableStatement cs = c.prepareCall("CALL " + procedureText);
        cs.execute();
        rs6[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs3[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs4[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs2[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs1[0] = cs.getResultSet();
        if (!cs.getMoreResults(2)) {
            return;
        }
        rs5[0] = cs.getResultSet();
    }

    public void _testGetMoreResults() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table MRS.FIVERS(i integer)");
        PreparedStatement ps = this.prepareStatement("insert into MRS.FIVERS values (?)");
        for (int i = 1; i <= 20; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        s.executeUpdate("create procedure MRS.FIVEJP() parameter style JAVA READS SQL DATA dynamic result sets 5 language java external name 'org.apache.derbyTesting.functionTests.util.Procedure2Test.fivejp'");
        CallableStatement cs = this.prepareCall("CALL MRS.FIVEJP()");
        Object[] allRS = new ResultSet[5];
        this.defaultGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.closeCurrentGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.keepCurrentGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.mixedGetMoreResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.checkExecuteClosesResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        this.checkCSCloseClosesResults(cs, (ResultSet[])allRS);
        Arrays.fill(allRS, null);
        CallableStatement nestedCs = this.prepareCall("CALL NESTED_RESULT_SETS('MRS.FIVEJP()')");
        this.defaultGetMoreResults(nestedCs, (ResultSet[])allRS);
    }

    private void checkExecuteClosesResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        int pass = 0;
        do {
            allRS[pass++] = cs.getResultSet();
            Procedure2Test.assertSame((Object)cs, (Object)allRS[pass - 1].getStatement());
        } while (cs.getMoreResults(2));
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
        cs.execute();
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void checkCSCloseClosesResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        int pass = 0;
        do {
            allRS[pass++] = cs.getResultSet();
            Procedure2Test.assertSame((Object)cs, (Object)allRS[pass - 1].getStatement());
        } while (cs.getMoreResults(2));
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
        cs.close();
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void mixedGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        cs.execute();
        allRS[0] = cs.getResultSet();
        Procedure2Test.assertSame((Object)cs, (Object)allRS[0].getStatement());
        boolean moreRS = cs.getMoreResults(2);
        if (!moreRS) {
            Procedure2Test.fail("FAIL - no second result set");
        }
        allRS[1] = cs.getResultSet();
        Procedure2Test.assertSame((Object)cs, (Object)allRS[1].getStatement());
        allRS[0].next();
        Procedure2Test.assertEquals((int)2, (int)allRS[0].getInt(1));
        allRS[1].next();
        Procedure2Test.assertEquals((int)3, (int)allRS[1].getInt(1));
        moreRS = cs.getMoreResults(1);
        if (!moreRS) {
            Procedure2Test.fail("FAIL - no third result set");
        }
        allRS[2] = cs.getResultSet();
        Procedure2Test.assertSame((Object)cs, (Object)allRS[2].getStatement());
        Procedure2Test.assertEquals((int)2, (int)allRS[0].getInt(1));
        JDBC.assertClosed(allRS[1]);
        allRS[2].next();
        Procedure2Test.assertEquals((int)4, (int)allRS[2].getInt(1));
        moreRS = cs.getMoreResults(2);
        if (!moreRS) {
            Procedure2Test.fail("FAIL - no fourth result set");
        }
        allRS[3] = cs.getResultSet();
        Procedure2Test.assertSame((Object)cs, (Object)allRS[3].getStatement());
        allRS[3].next();
        Procedure2Test.assertEquals((int)2, (int)allRS[0].getInt(1));
        JDBC.assertClosed(allRS[1]);
        Procedure2Test.assertEquals((int)4, (int)allRS[2].getInt(1));
        Procedure2Test.assertEquals((int)5, (int)allRS[3].getInt(1));
        moreRS = cs.getMoreResults(3);
        if (!moreRS) {
            Procedure2Test.fail("FAIL - no fifth result set");
        }
        allRS[4] = cs.getResultSet();
        Procedure2Test.assertSame((Object)cs, (Object)allRS[4].getStatement());
        allRS[4].next();
        JDBC.assertClosed(allRS[0]);
        JDBC.assertClosed(allRS[1]);
        JDBC.assertClosed(allRS[2]);
        JDBC.assertClosed(allRS[3]);
        Procedure2Test.assertEquals((int)6, (int)allRS[4].getInt(1));
        moreRS = cs.getMoreResults(2);
        if (moreRS) {
            Procedure2Test.fail("FAIL - too many result sets");
        }
        JDBC.assertClosed(allRS[0]);
        JDBC.assertClosed(allRS[1]);
        JDBC.assertClosed(allRS[2]);
        JDBC.assertClosed(allRS[3]);
        Procedure2Test.assertEquals((int)6, (int)allRS[4].getInt(1));
        allRS[4].close();
    }

    private void keepCurrentGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            Procedure2Test.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            Procedure2Test.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                Procedure2Test.assertTrue((boolean)cs.getMoreResults(2));
                continue;
            }
            Procedure2Test.assertFalse((boolean)cs.getMoreResults(2));
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertDrainResults(allRS[i]);
        }
    }

    private void closeCurrentGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            Procedure2Test.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            Procedure2Test.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                Procedure2Test.assertTrue((boolean)cs.getMoreResults(1));
                continue;
            }
            Procedure2Test.assertFalse((boolean)cs.getMoreResults(1));
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    private void defaultGetMoreResults(CallableStatement cs, ResultSet[] allRS) throws SQLException {
        int i;
        cs.execute();
        for (i = 0; i < 5; ++i) {
            allRS[i] = cs.getResultSet();
            Procedure2Test.assertSame((Object)cs, (Object)allRS[i].getStatement());
            allRS[i].next();
            Procedure2Test.assertEquals((int)(2 + i), (int)allRS[i].getInt(1));
            if (i < 4) {
                Procedure2Test.assertTrue((boolean)cs.getMoreResults());
                continue;
            }
            Procedure2Test.assertFalse((boolean)cs.getMoreResults());
        }
        for (i = 0; i < 5; ++i) {
            JDBC.assertClosed(allRS[i]);
        }
    }

    public Statement createStatement() throws SQLException {
        Statement s = Procedure2Test.getConnection().createStatement();
        this.addStatement(s);
        return s;
    }

    private void addStatement(Statement s) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(s);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = Procedure2Test.getConnection().prepareStatement(sql);
        this.addStatement(ps);
        return ps;
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cs = Procedure2Test.getConnection().prepareCall(sql);
        this.addStatement(cs);
        return cs;
    }

    public static void assertSQLState(String message, String expected, SQLException exception) {
        Procedure2Test.assertNotNull((String)"Exception cannot be null when asserting on SQLState", (Object)exception);
        try {
            String state = exception.getSQLState();
            if (state != null) {
                Procedure2Test.assertTrue((String)"The exception's SQL state must be five characters long", (state.length() == 5 ? 1 : 0) != 0);
            }
            if (expected != null) {
                Procedure2Test.assertTrue((String)"The expected SQL state must be five characters long", (expected.length() == 5 ? 1 : 0) != 0);
            }
            Procedure2Test.assertEquals((String)message, (String)expected, (String)state);
        }
        catch (AssertionFailedError e) {
            try {
                Method m = Throwable.class.getMethod("initCause", Throwable.class);
                m.invoke((Object)e, exception);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            exception = exception.getNextException();
            if (exception != null) {
                Procedure2Test.assertSQLState(message, expected, exception);
            }
            throw e;
        }
    }

    public static void assertErrorCode(String message, int expected, SQLException exception) {
        while (exception != null) {
            try {
                Procedure2Test.assertEquals((String)message, (int)expected, (int)exception.getErrorCode());
            }
            catch (AssertionFailedError e) {
                exception = exception.getNextException();
            }
        }
    }
}

