/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class PrimaryKeyIndexTest
extends JdbcTestBase {
    public PrimaryKeyIndexTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(PrimaryKeyIndexTest.class));
    }

    public void testBug39489() throws SQLException {
        Connection conn = PrimaryKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        s.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 25), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))");
        s.execute("create table emp.employees (eid int not null constraint employees_pk primary key, emp_name varchar(100), since date, addr varchar(100), ssn varchar(9))");
        s.execute("create table trade.trades (tid int, cid int, eid int, tradedate date, primary Key (tid), foreign key (cid) references trade.customers (cid), constraint emp_fk foreign key (eid) references emp.employees (eid))");
        conn.commit();
        conn.prepareStatement("delete from trade.customers where (cust_name = ? or cid = ? ) and tid = ?");
    }

    public void testDMLOnPrimaryKeyIndex() throws SQLException {
        Connection conn = PrimaryKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int not null, c2 int, c3 char(20), PRIMARY KEY (c1))");
        s.execute("insert into t1 (c1, c2, c3) values (10, 10, 'XXXX')");
        s.execute("insert into t1 (c1, c2, c3) values (20, 20, 'YYYY')");
        s.execute("insert into t1 (c1, c2, c3) values (30, 30, 'ZZZZ')");
        String[][] expectedRows = new String[][]{{"10", "10", "XXXX"}};
        ResultSet rs = s.executeQuery("select * from t1");
        JDBC.assertDrainResults(rs, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDuplicatePrimaryKey() throws SQLException {
        Connection conn = PrimaryKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 int, c3 char(20))");
        s.execute("insert into t1 (c1, c2, c3) values (10, 10, 'XXXX')");
        s.execute("insert into t1 (c1, c2, c3) values (20, 20, 'YYYY')");
        s.execute("insert into t1 (c1, c2, c3) values (30, 30, 'ZZZZ')");
        try {
            Monitor.getStream().println("<ExpectedException action=add>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
            s.execute("insert into t1 (c1, c2, c3) values (10, 10, 'XXXX')");
        }
        catch (Exception e) {
            return;
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>com.gemstone.gemfire.cache.EntryExistsException</ExpectedException>");
            Monitor.getStream().flush();
        }
        PrimaryKeyIndexTest.fail("Expected duplicate key exception");
    }

    public void testPrimaryKeyIndexWithTwoColumns() throws SQLException {
        Connection conn = PrimaryKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int, c2 int, c3 char(20), PRIMARY KEY (c1,c2))");
        s.execute("insert into t1 (c1, c2, c3) values (10, 10, 'YYYY')");
        s.execute("insert into t1 (c1, c2, c3) values (10, 20, 'AAAA')");
        s.execute("insert into t1 (c1, c2, c3) values (30, 10, 'AAAA')");
        PreparedStatement ps = conn.prepareStatement("select * from t1 where t1.c1=10 ");
        ResultSet rs = ps.executeQuery();
        JDBC.assertDrainResults(rs, 2);
    }

    public void testHashPrimaryKeyIndexWithInPredicate() throws SQLException {
        Connection conn = PrimaryKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 int, c3 char(20))");
        s.execute("create index i1 on t1 (c1)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 (c1, c2, c3) values (?, 10, 'YYYY')");
        for (int i = 1; i < 100; ++i) {
            ps.setInt(1, i);
            ps.execute();
        }
        ResultSet rs = s.executeQuery("select * from t1 where t1.c1 in (10,20,30) ");
        JDBC.assertDrainResults(rs, 3);
    }

    public void testPrimaryKeyWithInequality() throws SQLException {
        Connection conn = PrimaryKeyIndexTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 int, c3 char(20))");
        s.execute("insert into t1 (c1, c2, c3) values (10, 10, 'YYYY')");
        s.execute("insert into t1 (c1, c2, c3) values (20, 10, 'AAAA')");
        s.execute("insert into t1 (c1, c2, c3) values (30, 10, 'AAAA')");
        s.execute("create index indx on t1 (c1)");
        ResultSet rs = s.executeQuery("select * from t1 where t1.c1>=10 ");
        JDBC.assertDrainResults(rs, 3);
    }

    public void testNullWithPrimaryKeySyntax() throws SQLException {
        block5: {
            Statement s;
            block4: {
                Connection conn = PrimaryKeyIndexTest.getConnection();
                s = conn.createStatement();
                try {
                    s.executeQuery("create table nullpk1( col1 int null primary key)");
                    PrimaryKeyIndexTest.fail("Should have failed with sqlstate 42831");
                }
                catch (SQLException sqe) {
                    if (sqe.getSQLState().equals("42831")) break block4;
                    throw sqe;
                }
            }
            try {
                s.executeQuery("create table nullpk2( col1 int null, constraint pk1 primary key(col1))");
                PrimaryKeyIndexTest.fail("Should have failed with sqlstate 42831");
            }
            catch (SQLException sqe) {
                if (sqe.getSQLState().equals("42831")) break block5;
                throw sqe;
            }
        }
    }
}

