/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class PkAsRegionKeyTest
extends JdbcTestBase {
    public PkAsRegionKeyTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(PkAsRegionKeyTest.class));
    }

    public void testPkAsRegionKeySingleColumn() throws SQLException {
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 char(200))");
        s.execute("insert into t1 (c1, c2) values (10, 'YYYY')");
        s.execute("insert into t1 (c1, c2) values (20, 'YYYY')");
        ResultSet rs = s.executeQuery("select * from t1 where t1.c1=10");
        PkAsRegionKeyTest.assertTrue((String)"No rows in ResultSet", (boolean)rs.next());
        int num = rs.getInt(1);
        PkAsRegionKeyTest.assertEquals((String)("Wrong row returned" + num), (int)10, (int)num);
        PkAsRegionKeyTest.assertFalse((String)("Expected a result set containing one row but there is another with " + rs.getInt(1)), (boolean)rs.next());
    }

    public void testPkAsRegionKeyMultiColumn() throws SQLException {
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement s = conn.createStatement();
        PreparedStatement psInsert = null;
        ResultSet rs = null;
        s.execute("create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 varchar (200) , PRIMARY KEY (c1, c2, c3))");
        psInsert = conn.prepareStatement("insert into t1 ( c1, c2, c3, c4 ) values (?, ?, ?, ?)");
        int numInsert = 10;
        int intValue = 0;
        for (int i = 0; i < numInsert; ++i) {
            psInsert.setInt(1, intValue + 10);
            psInsert.setInt(2, intValue + 20);
            psInsert.setInt(3, intValue + 30);
            psInsert.setString(4, "YYYY");
            intValue += 10;
            int r = psInsert.executeUpdate();
            PkAsRegionKeyTest.assertEquals((String)("Insert failed at : " + i), (int)1, (int)r);
        }
        rs = s.executeQuery("Select * from t1 where t1.c1 = 10");
        PkAsRegionKeyTest.assertTrue((String)"No rows in ResultSet", (boolean)rs.next());
        int num = rs.getInt(1);
        PkAsRegionKeyTest.assertEquals((String)"Wrong row returned", (int)10, (int)num);
        PkAsRegionKeyTest.assertFalse((String)("Expected a result set conatining one row but there is another with " + rs.getInt(1)), (boolean)rs.next());
    }

    public void _testSingleColumnPkWithAlterTable() throws SQLException {
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement s = conn.createStatement();
        PreparedStatement psInsertBroker = null;
        PreparedStatement psInsertBrokerTickets = null;
        s.execute("Create table brokers (id int not null, name varchar(200))");
        s.execute("alter table brokers add primary key (id)");
        psInsertBroker = conn.prepareStatement("insert into brokers ( id, name ) values (?, ?)");
        int numInserts = 10;
        int key = 0;
        for (int i = 0; i < numInserts; ++i) {
            psInsertBroker.setInt(1, key + 10);
            psInsertBroker.setString(2, "YYYY" + key);
            int ret = psInsertBroker.executeUpdate();
            key += 10;
            PkAsRegionKeyTest.assertEquals((String)"Insert should always retrun 1 row updated", (int)ret, (int)1);
        }
        ResultSet rs = s.executeQuery("Select * from brokers");
        int numResults = 0;
        while (rs.next()) {
            ++numResults;
        }
        PkAsRegionKeyTest.assertEquals((String)"Number of rows in result set should be equal to number of inserts", (int)numInserts, (int)numResults);
        s.execute("Create table broker_tickets (id int not null, brokerId int, price double, quantity int, ticker varchar(20))");
        s.execute("alter table broker_tickets add primary key(id)");
        psInsertBrokerTickets = conn.prepareStatement("insert into broker_tickets (id, brokerId, price, quantity, ticker ) values (?, ?, ?, ?, ?)");
        key = 0;
        double price = 1.0;
        int quantity = 10;
        for (int i = 0; i < numInserts; ++i) {
            psInsertBrokerTickets.setInt(1, key + 10);
            psInsertBrokerTickets.setInt(2, key + 10);
            psInsertBrokerTickets.setDouble(3, price);
            psInsertBrokerTickets.setInt(4, quantity);
            psInsertBrokerTickets.setString(5, "YYYY" + key);
            int rt = psInsertBrokerTickets.executeUpdate();
            PkAsRegionKeyTest.assertEquals((String)"Insert should always retrun 1 row updated", (int)rt, (int)1);
            key += 10;
            price += 0.01;
        }
        rs = s.executeQuery("select * from broker_tickets");
        numResults = 0;
        while (rs.next()) {
            ++numResults;
        }
        PkAsRegionKeyTest.assertEquals((String)"Number of rows in result set should be equal to number of inserts", (int)numInserts, (int)numResults);
        rs = s.executeQuery("select b.id,b.name from brokers b,broker_tickets bt where bt.brokerId = b.id and bt.price >= 1 and bt.price < 2");
        numResults = 0;
        while (rs.next()) {
            ++numResults;
        }
        PkAsRegionKeyTest.assertEquals((String)"Number of rows in result set should be equal to number of inserts", (int)numInserts, (int)numResults);
        rs = s.executeQuery("Select id from brokers");
        numResults = 0;
        while (rs.next()) {
            ++numResults;
        }
        PkAsRegionKeyTest.assertEquals((String)"Number of rows in result set should be equal to number of inserts", (int)numInserts, (int)numResults);
        rs = s.executeQuery("select b.id,b.name from brokers b,broker_tickets bt where bt.brokerId = b.id and bt.price >= 1 and bt.price < 2");
        numResults = 0;
        while (rs.next()) {
            ++numResults;
        }
        PkAsRegionKeyTest.assertEquals((String)"Number of rows in result set should be equal to number of inserts", (int)numInserts, (int)numResults);
        rs = s.executeQuery("select b.id,b.name from brokers b,broker_tickets bt where bt.brokerId = b.id and bt.price >= 1 and bt.price < 2");
        numResults = 0;
        while (rs.next()) {
            ++numResults;
        }
        PkAsRegionKeyTest.assertEquals((String)"Number of rows in result set should be equal to number of inserts", (int)numInserts, (int)numResults);
    }

    public void _testSingleColumnPkUpdate() throws SQLException {
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement s = conn.createStatement();
        PreparedStatement psInsert = null;
        PreparedStatement psUpdate = null;
        s.execute("create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 varchar (200) , PRIMARY KEY (c1, c2, c3))");
        int key = 0;
        int numInsert = 100;
        psInsert = conn.prepareStatement("insert into t1 ( c1, c2, c3, c4 ) values (?, ?, ?, ?)");
        for (int i = 0; i < numInsert; ++i) {
            psInsert.setInt(1, key + 10);
            psInsert.setInt(2, key + 20);
            psInsert.setInt(3, key + 30);
            psInsert.setString(4, "YYYY");
            int re = psInsert.executeUpdate();
            PkAsRegionKeyTest.assertEquals((String)"Insert should always retrun 1 row updated", (int)re, (int)1);
            key += 10;
        }
        ResultSet rs = s.executeQuery("select * from t1 where t1.c1=10 and t1.c2=20 and t1.c3=30");
        PkAsRegionKeyTest.assertTrue((String)"No rows in ResultSet", (boolean)rs.next());
        PkAsRegionKeyTest.assertEquals((String)"Wrong row returned", (int)10, (int)rs.getInt(1));
        PkAsRegionKeyTest.assertEquals((String)"Wrong row returned", (int)20, (int)rs.getInt(2));
        PkAsRegionKeyTest.assertEquals((String)"Wrong row returned", (int)30, (int)rs.getInt(3));
        PkAsRegionKeyTest.assertFalse((String)("Expected a result set conatining one row but there is another with " + rs.getInt(1)), (boolean)rs.next());
        int startValue = 0;
        String updateValue = "DDDD";
        psUpdate = conn.prepareStatement("update t1 set c4=? where c1=? And c2 = ? And c3= ?");
        for (int i = 0; i < 1; ++i) {
            updateValue = "DDDD" + i;
            psUpdate.setString(1, updateValue);
            psUpdate.setInt(2, startValue + 10);
            psUpdate.setInt(3, startValue + 20);
            psUpdate.setInt(4, startValue + 30);
            int ret = psUpdate.executeUpdate();
            PkAsRegionKeyTest.assertEquals((String)"Insert should always return 1 row updated", (int)ret, (int)1);
            rs = s.executeQuery("select * from t1 where t1.c1=" + (startValue + 10) + " And t1.c2= " + (startValue + 20) + " and t1.c3=" + (startValue + 30));
            PkAsRegionKeyTest.assertTrue((String)"ResultSet should not be empty, should contain one row.", (boolean)rs.next());
            PkAsRegionKeyTest.assertEquals((String)"ResultSet mismatch", (String)updateValue, (String)rs.getString(3).trim());
            startValue += 10;
        }
    }

    public void disabled_testMulitColumnPkSelection() throws SQLException {
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement s = conn.createStatement();
        PreparedStatement psInsertBrokerTickets = null;
        s.execute("Create table broker_tickets (id int not null, brokerId int, firmId int,  price double, quantity int, ticker varchar(20), PRIMARY KEY (id, brokerId, firmId ))");
        psInsertBrokerTickets = conn.prepareStatement("insert into broker_tickets (id, brokerId, firmId,  price, quantity, ticker ) values (?, ?, ?, ?, ?, ?)");
        int numInserts = 5;
        int key = 0;
        double price = 1.0;
        int quantity = 10;
        for (int i = 0; i < numInserts; ++i) {
            psInsertBrokerTickets.setInt(1, key + 10);
            psInsertBrokerTickets.setInt(2, key + 10);
            psInsertBrokerTickets.setInt(3, key + 10);
            psInsertBrokerTickets.setDouble(4, price);
            psInsertBrokerTickets.setInt(5, quantity);
            psInsertBrokerTickets.setString(6, "YYYY" + key);
            int rt = psInsertBrokerTickets.executeUpdate();
            PkAsRegionKeyTest.assertEquals((String)"Insert should always return 1 row updated", (int)rt, (int)1);
            key += 10;
            price += 0.01;
        }
        ResultSet rs = s.executeQuery("Select * from broker_tickets");
        int numResults = 0;
        key = 0;
        while (rs.next()) {
            String ticker = rs.getString(6);
            if (!ticker.trim().equalsIgnoreCase("YYYY" + key)) {
                PkAsRegionKeyTest.fail("Expected colummn value : " + "YYYY" + key + " but  : " + ticker.trim() + " was found  and other column are 1st : " + rs.getInt(1) + " 2nd " + rs.getInt(2) + " 3rd " + rs.getInt(3) + " 4th " + rs.getDouble(4) + " 5th " + rs.getInt(5));
            }
            key += 10;
            ++numResults;
        }
        PkAsRegionKeyTest.assertEquals((String)"Number of rows in result set should be equal to number of inserts", (int)numInserts, (int)numResults);
        key = 0;
        for (int i = 0; i < numInserts; ++i) {
            rs = s.executeQuery("select * from broker_tickets where id=" + (key + 10) + "and brokerId=" + (key + 10) + "and firmId=" + (key + 10));
            numResults = 0;
            PkAsRegionKeyTest.assertTrue((String)"ResultSet should have one row.", (boolean)rs.next());
            String ticker = rs.getString(6);
            PkAsRegionKeyTest.assertEquals((String)("YYYY" + key), (String)ticker.trim());
        }
    }

    public void testQueryWithOutPk() throws SQLException {
        int i;
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement s = conn.createStatement();
        PreparedStatement psInsertBrokerTickets = null;
        s.execute("Create table broker_tickets (id int not null, brokerId int, firmId int,  price double, quantity int, ticker varchar(20))");
        psInsertBrokerTickets = conn.prepareStatement("insert into broker_tickets (id, brokerId, firmId,  price, quantity, ticker ) values (?, ?, ?, ?, ?, ?)");
        int numInserts = 5;
        int key = 0;
        double price = 1.0;
        int quantity = 10;
        for (int i2 = 0; i2 < numInserts; ++i2) {
            psInsertBrokerTickets.setInt(1, key + 10);
            psInsertBrokerTickets.setInt(2, key + 10);
            psInsertBrokerTickets.setInt(3, key + 10);
            psInsertBrokerTickets.setDouble(4, price);
            psInsertBrokerTickets.setInt(5, quantity);
            psInsertBrokerTickets.setString(6, "YYYY" + key);
            int rt = psInsertBrokerTickets.executeUpdate();
            PkAsRegionKeyTest.assertEquals((int)1, (int)rt);
            key += 10;
            price += 0.01;
        }
        int searchKey = 10;
        ResultSet rs = s.executeQuery("Select id, brokerId, firmId from broker_tickets where id=" + searchKey + "and brokerId=" + searchKey + "and firmId=" + searchKey);
        if (!rs.next()) {
            PkAsRegionKeyTest.fail("ResultSet should have at least one row.");
        }
        PkAsRegionKeyTest.assertEquals((int)searchKey, (int)rs.getInt(1));
        int numResults = 0;
        rs = s.executeQuery("Select * from broker_tickets");
        while (rs.next()) {
            ++numResults;
        }
        PkAsRegionKeyTest.assertEquals((int)numInserts, (int)numResults);
        s.execute("Create index idIndex on broker_tickets(id)");
        searchKey = 0;
        for (i = 0; i < numInserts; ++i) {
            rs = s.executeQuery("Select * from broker_tickets where id = " + (searchKey + 10));
            PkAsRegionKeyTest.assertTrue((String)("Expected one row with id =" + (searchKey + 10)), (boolean)rs.next());
            PkAsRegionKeyTest.assertEquals((int)(searchKey + 10), (int)rs.getInt(1));
            PkAsRegionKeyTest.assertEquals((int)(searchKey + 10), (int)rs.getInt(2));
            PkAsRegionKeyTest.assertEquals((int)(searchKey + 10), (int)rs.getInt(3));
            searchKey += 10;
        }
        searchKey = 0;
        for (i = 0; i < numInserts; ++i) {
            rs = s.executeQuery("Select id, brokerId from broker_tickets where id = " + (searchKey + 10));
            PkAsRegionKeyTest.assertTrue((String)("Expected one row with id =" + (searchKey + 10)), (boolean)rs.next());
            PkAsRegionKeyTest.assertEquals((int)(searchKey + 10), (int)rs.getInt(1));
            PkAsRegionKeyTest.assertEquals((int)(searchKey + 10), (int)rs.getInt(2));
            searchKey += 10;
        }
    }

    public void testRegionEntryAsRowLocation() throws SQLException {
        int i;
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement s = conn.createStatement();
        PreparedStatement psUpdateBrokerTickets = null;
        PreparedStatement psInsertBrokerTickets = null;
        s.execute("Create table broker_tickets (id int not null, brokerId int not null, firmId int not null, price double, quantity int, ticker varchar(20), PRIMARY KEY (id, brokerId))");
        psInsertBrokerTickets = conn.prepareStatement("insert into broker_tickets (id, brokerId, firmId,  price, quantity, ticker ) values (?, ?, ?, ?, ?, ?)");
        int numInserts = 5;
        int key = 0;
        double price = 1.0;
        int quantity = 10;
        for (int i2 = 0; i2 < numInserts; ++i2) {
            psInsertBrokerTickets.setInt(1, key + 10);
            psInsertBrokerTickets.setInt(2, key + 10);
            psInsertBrokerTickets.setInt(3, key + 10);
            psInsertBrokerTickets.setDouble(4, price);
            psInsertBrokerTickets.setInt(5, quantity);
            psInsertBrokerTickets.setString(6, "YYYY" + key);
            int rt = psInsertBrokerTickets.executeUpdate();
            PkAsRegionKeyTest.assertEquals((String)"Insert should return 1.", (int)1, (int)rt);
            key += 10;
            price += 0.01;
        }
        int searchKey = 10;
        ResultSet rs = s.executeQuery("Select id, brokerId, firmId from broker_tickets where id=" + searchKey + "and brokerId=" + searchKey + "and firmId=" + searchKey);
        if (!rs.next()) {
            PkAsRegionKeyTest.fail("ResultSet should have at least one row.");
        }
        int expected = 20;
        rs = s.executeQuery("select firmId from broker_tickets where firmId =" + expected);
        PkAsRegionKeyTest.assertTrue((String)("ResultSet should have on row with firmId " + expected), (boolean)rs.next());
        PkAsRegionKeyTest.assertEquals((int)expected, (int)rs.getInt(1));
        s.execute("create index broker_firmId on broker_tickets(firmId)");
        searchKey = 0;
        for (i = 0; i < numInserts; ++i) {
            rs = s.executeQuery("Select * from broker_tickets where firmId=" + (searchKey + 10));
            if (!rs.next()) {
                PkAsRegionKeyTest.fail("ResultSet should have atleast one row.");
            }
            PkAsRegionKeyTest.assertEquals((String)"Expected value not found ", (int)(searchKey + 10), (int)rs.getInt(1));
            PkAsRegionKeyTest.assertEquals((String)"Expected value not found ", (int)(searchKey + 10), (int)rs.getInt(2));
            PkAsRegionKeyTest.assertEquals((String)"Expected value not found ", (int)(searchKey + 10), (int)rs.getInt(3));
            searchKey += 10;
        }
        psUpdateBrokerTickets = conn.prepareStatement("Update broker_tickets set firmId = ? where firmId = ?");
        key = 0;
        for (i = 0; i < numInserts; ++i) {
            psUpdateBrokerTickets.setInt(1, (key + 10) * 10);
            psUpdateBrokerTickets.setInt(2, key + 10);
            int result = psUpdateBrokerTickets.executeUpdate();
            PkAsRegionKeyTest.assertEquals((String)("Updated should modify one row for key  " + (key + 10)), (int)1, (int)result);
            key += 10;
        }
        searchKey = 0;
        for (i = 0; i < numInserts; ++i) {
            rs = s.executeQuery("Select * from broker_tickets where firmId=" + (searchKey + 10) * 10);
            if (!rs.next()) {
                PkAsRegionKeyTest.fail("ResultSet should have atleast one row for : " + (searchKey + 10) * 10);
            }
            PkAsRegionKeyTest.assertEquals((String)"Expected value not found ", (int)(searchKey + 10), (int)rs.getInt(1));
            PkAsRegionKeyTest.assertEquals((String)"Expected value not found ", (int)(searchKey + 10), (int)rs.getInt(2));
            PkAsRegionKeyTest.assertEquals((String)"Expected value not found ", (int)((searchKey + 10) * 10), (int)rs.getInt(3));
            searchKey += 10;
        }
    }

    public void _testCascadedDeletes() throws SQLException {
        int k;
        int i;
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement createStatement = conn.createStatement();
        createStatement.execute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
        createStatement.execute("create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int, constraint netw_pk primary key (cid), constraint cust_newt_fk foreign key (cid) references trade.customers (cid) on delete cascade )");
        PreparedStatement psNetworth = conn.prepareStatement("insert into trade.networth values (?,?,?,?,?,?) ");
        PreparedStatement psCustomer = conn.prepareStatement("insert into trade.customers values (?,?,?,?,?)");
        System.out.println("Memory before table insertions : " + Runtime.getRuntime().freeMemory() + " and the max : " + Runtime.getRuntime().maxMemory());
        for (i = 0; i < 10; ++i) {
            psCustomer.setInt(1, i);
            psCustomer.setString(2, "customer_" + i);
            psCustomer.setDate(3, new Date(System.currentTimeMillis()));
            psCustomer.setString(4, "OREGON");
            psCustomer.setInt(5, 0);
            k = psCustomer.executeUpdate();
            if (k == 1) continue;
            throw new RuntimeException("Data not inserted customer : " + i);
        }
        for (i = 0; i < 10; ++i) {
            psNetworth.setInt(1, i);
            psNetworth.setBigDecimal(2, new BigDecimal(10000 + i));
            psNetworth.setBigDecimal(3, new BigDecimal(10000 + i));
            psNetworth.setInt(4, i);
            psNetworth.setBigDecimal(5, new BigDecimal(10000 + i));
            psNetworth.setInt(6, i);
            k = psNetworth.executeUpdate();
            if (k == 1) continue;
            throw new RuntimeException("Data not inserted Networth : " + i);
        }
        System.out.println("Memory after table insertions : " + Runtime.getRuntime().freeMemory() + " and the max : " + Runtime.getRuntime().maxMemory());
        PreparedStatement psCustDelete = conn.prepareStatement("delete from trade.customers where cid=?");
        psCustDelete.setInt(1, 1);
        psCustDelete.execute();
        System.out.println("Memory after table delete : " + Runtime.getRuntime().freeMemory() + " and the max : " + Runtime.getRuntime().maxMemory());
    }

    public void testSingleVmIndexScans() throws Exception {
        Connection conn = PkAsRegionKeyTest.getConnection();
        Statement s = conn.createStatement();
        PreparedStatement psInsertBrokerTickets = null;
        s.execute("Create table broker_tickets (id int not null, ticketPrice int not null , firmId int not null ,  price double, quantity int, ticker varchar(20), PRIMARY KEY (id)) redundancy 3");
        psInsertBrokerTickets = conn.prepareStatement("insert into broker_tickets (id, ticketPrice, firmId,  price, quantity, ticker ) values (?, ?, ?, ?, ?, ?)");
        int numInserts = 1000;
        int key = 0;
        double price = 1.0;
        int quantity = 10;
        for (int i = 0; i < numInserts; ++i) {
            psInsertBrokerTickets.setInt(1, key + 10);
            if (i % 2 == 0) {
                psInsertBrokerTickets.setInt(2, 10);
            } else {
                psInsertBrokerTickets.setInt(2, 20);
            }
            psInsertBrokerTickets.setInt(3, key + 10);
            psInsertBrokerTickets.setDouble(4, price);
            psInsertBrokerTickets.setInt(5, quantity);
            psInsertBrokerTickets.setString(6, "YYYY" + key);
            int rt = psInsertBrokerTickets.executeUpdate();
            PkAsRegionKeyTest.assertEquals((String)"Insert should return 1.", (int)1, (int)rt);
            key += 10;
            price += 0.01;
        }
        s.execute("create index index_ticketPrice on broker_tickets (ticketPrice)");
        ResultSet rs = s.executeQuery("select avg(distinct ticketPrice) from broker_tickets");
        while (rs.next()) {
            PkAsRegionKeyTest.assertEquals((String)"Result should match ", (int)15, (int)rs.getInt(1));
        }
    }
}

