/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class OrdersTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(OrdersTest.class));
    }

    public OrdersTest(String name) {
        super(name);
    }

    public void testQuery() throws Exception {
        Connection conn = OrdersTest.getConnection();
        this.loadTestData(conn);
        String queryString = "Select * from Orders where vol > ? and vol < ?";
        PreparedStatement q = conn.prepareStatement(queryString);
        for (int i = 0; i < 20; ++i) {
            q.setInt(1, i);
            q.setInt(2, i + 100);
            ResultSet rs = q.executeQuery();
            while (rs.next()) {
            }
        }
    }

    public void loadTestData(Connection conn) throws SQLException {
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        Random rand = new Random(System.currentTimeMillis());
        Statement s = conn.createStatement();
        s.execute("create table orders(id int not null , cust_name varchar(200), vol int, security_id varchar(10), num int, addr varchar(100))");
        s.execute("create index volumeIdx on orders(vol)");
        PreparedStatement psInsert = conn.prepareStatement("insert into orders values (?, ?, ?, ?, ?, ?)");
        int numOfCustomers = 100;
        int numOrdersPerCustomer = 10;
        for (int i = 0; i < numOfCustomers; ++i) {
            for (int j = 0; j < numOrdersPerCustomer; ++j) {
                psInsert.setInt(1, i * j);
                psInsert.setString(2, "CustomerWithaLongName" + i);
                psInsert.setInt(3, rand.nextInt(500));
                psInsert.setString(4, securities[rand.nextInt(10)]);
                psInsert.setInt(5, 0);
                String queryString = "Emperors club for desperate men, Washington DC, District of Columbia";
                psInsert.setString(6, queryString);
                psInsert.executeUpdate();
            }
        }
    }
}

