/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class JsonTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(JsonTest.class));
    }

    public JsonTest(String name) {
        super(name);
    }

    public static void simpleJSONOps(Connection conn, boolean isPartitioned, boolean isOffHeap) throws Exception {
        Statement stmt = conn.createStatement();
        String[] jsonStrings = new String[]{"{\"f1\":1,\"f2\":true}", "{\"f3\":1,\"f4\":true}", "{\"f5\":1,\"f6\":true}", null, "{\"f6\":1,\"f7\":true}", "{\"f7\":1,\"f8\":true}"};
        String createTable = "CREATE table t1(col1 int, col2 json) persistent";
        createTable = isPartitioned ? createTable + " partition by (col1)" : createTable + " replicate";
        if (isOffHeap) {
            createTable = createTable + " offheap";
        }
        stmt.execute(createTable);
        stmt.execute("insert into t1 values (1, '" + jsonStrings[0] + "')");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        ps.setInt(1, 2);
        ps.setString(2, jsonStrings[1]);
        ps.execute();
        PreparedStatement ps2 = conn.prepareStatement("insert into t1 values (?, ?)");
        ps2.setInt(1, 3);
        ps2.setObject(2, jsonStrings[2]);
        ps2.execute();
        ps2.setInt(1, 4);
        ps2.setString(2, jsonStrings[3]);
        ps2.execute();
        stmt.execute("put into t1 values (5, '" + jsonStrings[4] + "')");
        ps2.setInt(1, 6);
        Clob inputClob = conn.createClob();
        inputClob.setString(1L, jsonStrings[5]);
        ps2.setClob(2, inputClob);
        ps2.execute();
        ResultSet rs = stmt.executeQuery("select col1, col2 from t1 order by col1");
        int i = 0;
        String[] jsonCol = new String[6];
        Clob c = null;
        while (rs.next()) {
            c = rs.getClob(2);
            jsonCol[i] = c != null ? c.getSubString(1L, (int)c.length()) : null;
            System.out.println(jsonCol[i]);
            JsonTest.getLogger().info((Object)jsonCol[i]);
            if (jsonCol[i] != null) {
                JsonTest.assertEquals((String)jsonStrings[i].replaceAll("\\s+", ""), (String)jsonCol[i].replaceAll("\\s+", ""));
            } else {
                JsonTest.assertTrue((jsonStrings[i] == null ? 1 : 0) != 0);
            }
            ++i;
        }
        rs = stmt.executeQuery("select count(a.col1) from (select col1, col2 from t1) a group by a.col1");
        i = 0;
        while (rs.next()) {
            System.out.println(rs.getInt(1));
            JsonTest.assertEquals((int)1, (int)rs.getInt(1));
            ++i;
        }
        JsonTest.assertEquals((int)6, (int)i);
        rs = stmt.executeQuery("select count(a.col1) from (select col1, col2 from t1) a group by a.col1 having a.col1 > 0");
        i = 0;
        while (rs.next()) {
            System.out.println(rs.getInt(1));
            JsonTest.assertEquals((int)1, (int)rs.getInt(1));
            ++i;
        }
        JsonTest.assertEquals((int)6, (int)i);
        conn.commit();
        stmt.execute("create view view1 as select * from t1 where col1 > 0");
        rs = stmt.executeQuery("select * from view1 order by col1");
        i = 0;
        jsonCol = new String[6];
        while (rs.next()) {
            jsonCol[i] = rs.getString(2);
            System.out.println(jsonCol[i]);
            JsonTest.getLogger().info((Object)jsonCol[i]);
            if (jsonCol[i] != null) {
                JsonTest.assertEquals((String)jsonStrings[i].replaceAll("\\s+", ""), (String)jsonCol[i].replaceAll("\\s+", ""));
            } else {
                JsonTest.assertTrue((jsonStrings[i] == null ? 1 : 0) != 0);
            }
            ++i;
        }
    }

    public void testJSON() throws Exception {
        Connection cxn = TestUtil.getConnection();
        JsonTest.simpleJSONOps(cxn, true, false);
    }

    public void testJSON_thinClient() throws Exception {
        Connection conn = TestUtil.getConnection();
        int netPort = TestUtil.startNetserverAndReturnPort();
        Connection cxn = TestUtil.getNetConnection(netPort, null, null);
        JsonTest.simpleJSONOps(cxn, true, false);
    }

    public void testJSON_stream() throws Exception {
        BufferedReader bufferedReader;
        FileInputStream fileInputStream;
        String[] data = new String[]{"{\"f1\":1,\"f2\":true}", "{\"f2\":2,\"f3\":true}"};
        PrintWriter p = new PrintWriter(new File("jsondata.dat"));
        p.write(data[0]);
        p.close();
        p = new PrintWriter(new File("jsondata2.dat"));
        p.write(data[1]);
        p.close();
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        stmt.execute("CREATE table app.t1(col1 int, col2 json) persistent partition by (col1)");
        PreparedStatement pstmt = cxn.prepareStatement("insert into app.t1 values (?, ?)");
        pstmt.setInt(1, 0);
        File file = new File("jsondata.dat");
        int fileLength = (int)file.length();
        FileInputStream stream = fileInputStream = new FileInputStream(file);
        pstmt.setAsciiStream(2, (InputStream)stream, fileLength);
        pstmt.execute();
        pstmt.setInt(1, 1);
        File file2 = new File("jsondata2.dat");
        long fileLength2 = file2.length();
        BufferedReader fileReader = bufferedReader = new BufferedReader(new FileReader(file2));
        pstmt.setCharacterStream(2, (Reader)fileReader, fileLength2);
        pstmt.execute();
        ResultSet rs = stmt.executeQuery("select * from  app.t1 order by col1");
        int i = 0;
        while (rs.next()) {
            StringBuffer sb = new StringBuffer();
            Reader r = rs.getCharacterStream(2);
            int c = -1;
            while ((c = r.read()) > -1) {
                sb.append((char)c);
            }
            String jsonCol = sb.toString();
            JsonTest.getLogger().info((Object)jsonCol);
            if (jsonCol != null) {
                JsonTest.assertEquals((String)data[i].replaceAll("\\s+", ""), (String)jsonCol.replaceAll("\\s+", ""));
            } else {
                JsonTest.assertTrue((data[i] == null ? 1 : 0) != 0);
            }
            ++i;
        }
        JsonTest.assertEquals((int)2, (int)i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug51374_1() throws Exception {
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        String[] jsonStrings = new String[]{"{\"f1\":1,\"f2\":true, \"stringField\": \"mystring\"}", "{\"f3\":1,\"f4\":true, \"stringField\": \"mystring\"}", "{\"f5\":1,\"f6\":true, \"stringField\": \"mystring\"}", null};
        stmt.execute("CREATE table app.t1(col1 int, col2 varchar(10), col3 json) persistent partition by (col1) ");
        PreparedStatement ps = cxn.prepareStatement("insert into app.t1 values (?, ?, ?)");
        for (int i = 0; i < 4; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "" + i);
            ps.setString(3, jsonStrings[i]);
            ps.execute();
        }
        try {
            stmt.execute("CALL SYSCS_UTIL.EXPORT_TABLE('APP','T1', 'T1.dat',NULL, NULL, NULL)");
            stmt.execute("CREATE table app.t2(col1 int, col2 varchar(10), col3 json) persistent partition by (col1)");
            stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T2', 'T1.dat', NULL, NULL, NULL, 0, 0, 1, 0, null, null)");
            ResultSet rs = stmt.executeQuery("select col1, col3 from app.t2 order by col1");
            int i = 0;
            String[] jsonCol = new String[4];
            while (rs.next()) {
                jsonCol[i] = rs.getString(2);
                System.out.println(jsonCol[i]);
                JsonTest.getLogger().info((Object)jsonCol[i]);
                if (jsonCol[i] != null) {
                    JsonTest.assertEquals((String)jsonStrings[i].replaceAll("\\s+", ""), (String)jsonCol[i].replaceAll("\\s+", ""));
                } else {
                    JsonTest.assertTrue((jsonStrings[i] == null ? 1 : 0) != 0);
                }
                ++i;
            }
        }
        finally {
            new File("T1.dat").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug51374_2() throws Exception {
        Connection cxn = TestUtil.getConnection();
        Statement stmt = cxn.createStatement();
        String[] s = new String[]{"a\nbc", "p\"q\"\nr", "", "   \"\n\"\"", "", null};
        stmt.execute("CREATE table app.t1(col1 int, col2 varchar(10)) persistent partition by (col1) ");
        PreparedStatement ps = cxn.prepareStatement("insert into app.t1 values (?, ?)");
        for (int j = 0; j < s.length; ++j) {
            ps.setInt(1, j);
            ps.setString(2, s[j]);
            ps.execute();
        }
        try {
            stmt.execute("CALL SYSCS_UTIL.EXPORT_TABLE('APP','T1', 'T1.dat',NULL, NULL, NULL)");
            stmt.execute("CREATE table app.t2(col1 int, col2 varchar(10)) persistent partition by (col1)");
            stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T2', 'T1.dat', NULL, NULL, NULL, 0, 0, 2, 0, null, null)");
            ResultSet rs = stmt.executeQuery("select col1, col2 from app.t2 order by col1");
            int i = 0;
            while (rs.next()) {
                String output = rs.getString(2);
                JsonTest.assertEquals((String)s[i], (String)output);
                System.out.println("output=" + output);
                ++i;
            }
        }
        finally {
            new File("T1.dat").delete();
        }
    }
}

