/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class JoinTest
extends JdbcTestBase {
    public JoinTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(JoinTest.class));
    }

    public void testJoin() throws Exception {
        this.reduceLogLevelForTest("config");
        int numCust = 200;
        int numOrder = 100;
        int interval = 50;
        int numQueries = 1;
        int expectedRows = interval * numQueries;
        boolean startLoc = false;
        Connection conn = JoinTest.getConnection();
        this.createTables(conn);
        this.loadSampleData(conn, numCust, numOrder);
        int countFromTable = this.selectFromTables(conn, interval, numQueries);
        System.out.println("retrieved " + countFromTable + " rows");
        this.dropTables(conn);
    }

    public int selectFromTables(Connection conn, int retrievalSize, int numQueries) throws SQLException {
        Random rand = new Random(System.currentTimeMillis());
        int count = 0;
        int startLoc = rand.nextInt(5000);
        String queryString = "Select * from orders o, customers c where o.cust_id = c.id AND o.vol > ? and o.vol < ?";
        PreparedStatement q = conn.prepareStatement("Select * from orders o, customers c where vol > ? and vol < ?");
        for (int i = startLoc; i < startLoc + numQueries; ++i) {
            count += this.selectFromTable(conn, q, i, retrievalSize);
        }
        return count;
    }

    private int selectFromTable(Connection conn, PreparedStatement q, int from, int retrievalSize) throws SQLException {
        int count = 0;
        q.setInt(1, from);
        q.setInt(2, from + retrievalSize + 1);
        ResultSet rs = q.executeQuery();
        while (rs.next()) {
            ++count;
        }
        return count;
    }

    public void clearTables(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("delete from orders, customers");
        s.close();
    }

    public void dropTables(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        try {
            s.execute("drop table orders; drop table customers");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        s.close();
    }

    public void createTables(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        s.execute("create table orders(id int not null , vol int, security_id varchar(10), num int, cust_id int)");
        s.execute("create table customers (id int not null , name varchar(200), addr varchar(100))");
        s.close();
    }

    public void loadSampleData(Connection conn, int numOfCustomers, int numOrdersPerCustomer) throws SQLException {
        System.out.println("Loading data (" + numOfCustomers * numOrdersPerCustomer + " rows)...");
        String[] securities = new String[]{"IBM", "INTC", "MOT", "TEK", "AMD", "CSCO", "DELL", "HP", "SMALL1", "SMALL2"};
        Random rand = new Random(System.currentTimeMillis());
        PreparedStatement orderInsert = conn.prepareStatement("insert into orders values (?, ?, ?, ?, ?)");
        PreparedStatement custInsert = conn.prepareStatement("insert into customers values (?, ?, ?)");
        int volNum = 0;
        for (int i = 0; i < numOfCustomers; ++i) {
            String custName = "CustomerWithaLongName" + i;
            String addr = "123 Wisteria Lane, Anywhere, USA";
            custInsert.setInt(1, i);
            custInsert.setString(2, custName);
            custInsert.setString(3, addr);
            custInsert.executeUpdate();
            for (int j = 0; j < numOrdersPerCustomer; ++j) {
                orderInsert.setInt(1, j);
                orderInsert.setInt(2, volNum++);
                orderInsert.setString(3, securities[rand.nextInt(10)]);
                orderInsert.setInt(4, rand.nextInt(100));
                orderInsert.setInt(5, i);
                orderInsert.executeUpdate();
            }
        }
    }
}

