/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.Oplog;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.gemstone.junit.UnitTest;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DropTableNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import io.snappydata.test.memscale.OffHeapHelper;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeMap;
import org.apache.derbyTesting.junit.JDBC;

public class JdbcTestBase
extends TestUtil
implements UnitTest {
    protected String[] deleteDirs;

    public JdbcTestBase(String name) {
        super(name);
    }

    protected String[] testSpecificDirectoriesForDeletion() {
        return this.deleteDirs;
    }

    protected void clearTestSpecificDirectoriesForDeletion() {
        this.deleteDirs = null;
    }

    @Override
    protected void setUp() throws Exception {
        if (GemFireStore.getBootingInstance() != null) {
            JdbcTestBase.shutDown();
        }
        GemFireXDUtils.IS_TEST_MODE = true;
        System.setProperty("gemfire.ALLOW_STANDALONE_HDFS_FILESYSTEM", "true");
        this.clearTestSpecificDirectoriesForDeletion();
        super.setUp();
        JdbcTestBase.loadDriver();
        JdbcTestBase.loadNetDriver();
    }

    protected static Map<String, Long> getAllOplogFiles() {
        String currDir = System.getProperty("user.dir");
        File cdir = new File(currDir);
        File[] files = FileUtil.listFiles((File)cdir);
        TreeMap<String, Long> results = new TreeMap<String, Long>();
        for (File file : files) {
            long length = file.length();
            if (file.getName().endsWith(".lk")) continue;
            if (file.getName().endsWith(".crf") || file.getName().endsWith(".drf")) {
                length = 0L;
            }
            if (!file.getName().matches(".*GFXD-DEFAULT-DISKSTORE.*")) continue;
            results.put(file.getPath(), length);
        }
        return results;
    }

    protected static void clearAllOplogFiles() {
        File[] files;
        String currDir = System.getProperty("user.dir");
        File cdir = new File(currDir);
        for (File file : files = FileUtil.listFiles((File)cdir)) {
            if (file.getName().matches(".*GFXD-DEFAULT-DISKSTORE.*")) {
                file.delete();
                continue;
            }
            if (!file.getName().matches("datadictionary") || !file.isDirectory()) continue;
            JdbcTestBase.deleteDir(file);
        }
    }

    protected void doOffHeapValidations() throws Exception {
        SimpleMemoryAllocatorImpl sma = null;
        try {
            sma = SimpleMemoryAllocatorImpl.getAllocator();
        }
        catch (CacheClosedException ignore) {
            sma = null;
        }
        if (sma != null) {
            JDBC.assertLiveChunksAndRegionEntryValidity(sma);
        }
    }

    protected void doEndOffHeapValidations() throws Exception {
        OffHeapHelper.waitForWanQueuesToDrain();
        OffHeapHelper.verifyOffHeapMemoryConsistency((boolean)true);
        OffHeapHelper.closeAllRegions();
        OffHeapHelper.verifyOffHeapMemoryConsistency((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            this.doEndOffHeapValidations();
        }
        finally {
            try {
                JdbcTestBase.shutDown();
                currentUserName = null;
                currentUserPassword = null;
            }
            finally {
                super.tearDown();
                GemFireXDUtils.IS_TEST_MODE = false;
                String[] dirs = this.testSpecificDirectoriesForDeletion();
                if (dirs != null) {
                    for (String dir : dirs) {
                        JdbcTestBase.deleteDir(new File(dir));
                    }
                }
                JdbcTestBase.clearAllOplogFiles();
            }
        }
    }

    protected int getIntFromDataValue(Object dataValue, int index) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object value = Array.get(dataValue, index);
        Class<?> valueClass = Class.forName("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
        Method getIntMethod = valueClass.getMethod("getInt", null);
        return (Integer)getIntMethod.invoke(value, (Object[])null);
    }

    static void addAsyncEventListener(String serverGroups, String ID, String className, Integer batchSize, Integer batchTimeInterval, Boolean batchConflation, Integer maxQueueMem, String diskStoreName, Boolean enablePersistence, Boolean diskSync, Integer alertThreshold, String initParamStr) throws SQLException {
        JdbcTestBase.addAsyncEventListenerWithConn(serverGroups, ID, className, batchSize, batchTimeInterval, batchConflation, maxQueueMem, diskStoreName, enablePersistence, diskSync, alertThreshold, initParamStr, null);
    }

    static void addAsyncEventListenerWithConn(String serverGroups, String ID, String className, Integer batchSize, Integer batchTimeInterval, Boolean batchConflation, Integer maxQueueMem, String diskStore, Boolean enablePersistence, Boolean diskSync, Integer alertThreshold, String initParamStr, Connection conn) throws SQLException {
        if (conn == null) {
            conn = JdbcTestBase.getConnection();
        }
        String createDDL = MessageFormat.format("CREATE ASYNCEVENTLISTENER {1} (listenerclass ''{2}'' initparams ''{10}'' {3} {4} {5} {6} {7} {8} {9} {11}) server groups ({0})", serverGroups, ID, className, batchSize != null ? "BATCHSIZE " + batchSize : "", batchTimeInterval != null ? "BATCHTIMEINTERVAL " + batchTimeInterval : "", batchConflation != null ? "ENABLEBATCHCONFLATION " + batchConflation : "", maxQueueMem != null ? "MAXQUEUEMEMORY " + maxQueueMem : "", diskStore != null ? "DISKSTORENAME " + diskStore : "", enablePersistence != null ? "ENABLEPERSISTENCE " + enablePersistence : "", alertThreshold != null ? "ALERTTHRESHOLD " + alertThreshold : "", initParamStr != null ? initParamStr : "", diskSync != null ? "DISKSYNCHRONOUS " + diskSync : "");
        conn.createStatement().execute(createDDL);
    }

    static void startAsyncEventListener(String ID) throws SQLException {
        JdbcTestBase.startAsyncEventListener(ID, null);
    }

    static void startAsyncEventListener(String ID, Connection conn) throws SQLException {
        try {
            if (conn == null) {
                conn = JdbcTestBase.getConnection();
            }
            CallableStatement cs = conn.prepareCall("call SYS.START_ASYNC_EVENT_LISTENER (?)");
            cs.setString(1, ID);
            cs.execute();
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
        }
    }

    static void stopAsyncEventListener(String ID) throws SQLException {
        try {
            Connection conn = JdbcTestBase.getConnection();
            CallableStatement cs = conn.prepareCall("call SYS.STOP_ASYNC_EVENT_LISTENER (?)");
            cs.setString(1, ID);
            cs.execute();
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)sqle);
        }
    }

    public void cleanUpDirs(File[] dirs) {
        if (dirs != null) {
            for (File file : dirs) {
                if (!file.isDirectory()) continue;
                File[] files = file.listFiles();
                if (files != null) {
                    for (File f : files) {
                        f.delete();
                    }
                }
                file.delete();
            }
        }
    }

    public static class RegionMapClearDetector
    extends GemFireXDQueryObserverAdapter
    implements CacheObserver {
        private int numExpectedRegionClearCalls = 0;
        private int currentCallCount = 0;

        private void setNumExpectedRegionClearCalls(int numExpected) {
            this.numExpectedRegionClearCalls = numExpected;
            this.currentCallCount = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTillAllClear() throws InterruptedException {
            RegionMapClearDetector regionMapClearDetector = this;
            synchronized (regionMapClearDetector) {
                if (this.currentCallCount < this.numExpectedRegionClearCalls) {
                    ((Object)((Object)this)).wait();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void afterRegionCustomEntryConcurrentHashMapClear() {
            RegionMapClearDetector regionMapClearDetector = this;
            synchronized (regionMapClearDetector) {
                ++this.currentCallCount;
                if (this.currentCallCount == this.numExpectedRegionClearCalls) {
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }

        public void afterQueryParsing(String query, StatementNode qt, LanguageConnectionContext lcc) {
            if (qt instanceof DropTableNode) {
                DropTableNode dtn = (DropTableNode)qt;
                String tableToDrop = dtn.getFullName();
                Region rgn = Misc.getRegionForTable((String)tableToDrop, (boolean)false);
                if (rgn != null && rgn.getAttributes().getEnableOffHeapMemory()) {
                    if (rgn.getAttributes().getDataPolicy().isPartition()) {
                        PartitionedRegion pr = (PartitionedRegion)rgn;
                        int numBucketsHosted = pr.getRegionAdvisor().getAllBucketAdvisors().size();
                        this.setNumExpectedRegionClearCalls(numBucketsHosted);
                    } else {
                        this.setNumExpectedRegionClearCalls(1);
                    }
                } else {
                    this.setNumExpectedRegionClearCalls(0);
                }
            } else {
                this.setNumExpectedRegionClearCalls(0);
            }
        }

        public void afterRegionClear(RegionEvent event) {
        }

        public void beforeDiskClear() {
        }

        public void goingToFlush() {
        }

        public void afterWritingBytes() {
        }

        public void beforeGoingToCompact() {
        }

        public void afterHavingCompacted() {
        }

        public void afterConflation(ByteBuffer origBB, ByteBuffer conflatedBB) {
        }

        public void afterSettingOplogOffSet(long offset) {
        }

        public void beforeSwitchingOplog() {
        }

        public void afterSwitchingOplog() {
        }

        public void afterKrfCreated() {
        }

        public void beforeStoppingCompactor() {
        }

        public void afterStoppingCompactor() {
        }

        public void afterSignallingCompactor() {
        }

        public void afterMarkingGIIStarted() {
        }

        public void afterMarkingGIICompleted() {
        }

        public void afterSwitchingWriteAndFlushMaps() {
        }

        public void beforeSettingDiskRef() {
        }

        public void afterSettingDiskRef() {
        }

        public void beforeDeletingCompactedOplog(Oplog compactedOplog) {
        }

        public void beforeDeletingEmptyOplog(Oplog emptyOplog) {
        }

        public boolean shouldCreateKRFIRF() {
            return false;
        }
    }
}

