/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class JdbcApiTest
extends JdbcTestBase {
    private static final int[] ALL_ISOLATION_LEVELS = new int[]{0, 1, 2, 4, 8};

    public JdbcApiTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(JdbcApiTest.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionGetTransactionIsolation() throws SQLException {
        try (Connection conn = JdbcApiTest.getConnection();){
            if (isTransactional) {
                JdbcApiTest.assertEquals((int)2, (int)conn.getTransactionIsolation());
            } else {
                JdbcApiTest.assertEquals((int)0, (int)conn.getTransactionIsolation());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnectionSetTransactionIsolation() throws SQLException {
        try (Connection conn = JdbcApiTest.getConnection();){
            for (int txnLvl : ALL_ISOLATION_LEVELS) {
                try {
                    conn.setTransactionIsolation(txnLvl);
                    if (txnLvl != 8) continue;
                    JdbcApiTest.fail("Should have thrown an SQLException with SQLState class XJ045");
                }
                catch (SQLException sqle) {
                    if (txnLvl == 0) {
                        throw sqle;
                    }
                    String sqlState = sqle.getSQLState();
                    JdbcApiTest.assertTrue((String)("got sqlState=" + sqlState + " when setting isolation level to " + txnLvl), (boolean)sqlState.startsWith("XJ045"));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDatabaseMetadataTransactions() throws SQLException {
        try (Connection conn = JdbcApiTest.getConnection();){
            DatabaseMetaData dbmd = conn.getMetaData();
            JdbcApiTest.assertEquals((int)0, (int)dbmd.getDefaultTransactionIsolation());
            JdbcApiTest.assertTrue((boolean)dbmd.supportsMultipleTransactions());
            JdbcApiTest.assertTrue((boolean)dbmd.supportsTransactions());
            int txnLvl = 0;
            JdbcApiTest.assertTrue((boolean)dbmd.supportsTransactionIsolationLevel(txnLvl));
            txnLvl = 2;
            JdbcApiTest.assertTrue((boolean)dbmd.supportsTransactionIsolationLevel(txnLvl));
            txnLvl = 1;
            JdbcApiTest.assertTrue((boolean)dbmd.supportsTransactionIsolationLevel(txnLvl));
            txnLvl = 4;
            JdbcApiTest.assertTrue((boolean)dbmd.supportsTransactionIsolationLevel(txnLvl));
            txnLvl = 8;
            JdbcApiTest.assertFalse((boolean)dbmd.supportsTransactionIsolationLevel(txnLvl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetGeneratedKeys() throws SQLException {
        try (Connection conn = JdbcApiTest.getConnection();){
            Statement s = conn.createStatement();
            s.execute("CREATE TABLE owners(ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY, first_name VARCHAR(30), last_name VARCHAR(30), address VARCHAR(255), city VARCHAR(80), telephone VARCHAR(20), PRIMARY KEY (id))");
            PreparedStatement ps = conn.prepareStatement("INSERT INTO owners (FIRST_NAME, LAST_NAME, ADDRESS, CITY, TELEPHONE) VALUES(?, ?, ?, ?, ?)", 1);
            ps.setString(1, "joe");
            ps.setString(2, "joe");
            ps.setString(3, "joe");
            ps.setString(4, "joe");
            ps.setString(5, "joe");
            ps.execute();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            JdbcApiTest.assertEquals((int)1, (int)rs.getMetaData().getColumnCount());
            JdbcApiTest.assertEquals((String)"ID", (String)rs.getMetaData().getColumnName(1));
            JdbcApiTest.assertEquals(Integer.class, rs.getObject(1).getClass());
            JdbcApiTest.assertFalse((boolean)rs.next());
        }
    }

    public void testRSQualifiedNames_41272() throws Exception {
        int id;
        Connection conn = JdbcApiTest.getConnection();
        Connection netConn = JdbcApiTest.startNetserverAndGetLocalNetConnection();
        Statement s = conn.createStatement();
        s.execute("CREATE TABLE o.owner(ID INTEGER NOT NULL , address VARCHAR(255), city VARCHAR(80), telephone VARCHAR(20), PRIMARY KEY (id)) replicate");
        s.execute("CREATE TABLE o.ownername(ID INTEGER NOT NULL , firstname VARCHAR(30), lastname VARCHAR(30), city VARCHAR(80), PRIMARY KEY (id)) replicate");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO o.owner (ID, ADDRESS, CITY, TELEPHONE) VALUES(?, ?, ?, ?)");
        for (id = 1; id <= 10; ++id) {
            ps.setInt(1, id);
            ps.setString(2, "addr" + id);
            ps.setString(3, "city" + id);
            ps.setString(4, "tel" + id);
            ps.execute();
        }
        ps = conn.prepareStatement("INSERT INTO o.ownername VALUES(?, ?, ?, ?)");
        for (id = 1; id <= 10; ++id) {
            ps.setInt(1, id);
            ps.setString(2, "fname" + id);
            ps.setString(3, "sname" + id);
            ps.setString(4, "city_" + id);
            ps.execute();
        }
        this.verifyResults(conn);
        this.verifyResults(netConn);
    }

    private void verifyResults(Connection conn) throws SQLException {
        int id;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from o.owner o, o.ownername n where o.id = n.id order by o.id");
        for (id = 1; id <= 10; ++id) {
            JdbcApiTest.assertTrue((boolean)rs.next());
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("ID"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("id"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("ID"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("id"));
            JdbcApiTest.assertEquals((String)("city" + id), (String)rs.getString("CITY"));
            JdbcApiTest.assertEquals((String)("city" + id), (String)rs.getString("City"));
            JdbcApiTest.assertEquals((Object)("city" + id), (Object)rs.getObject("CITY"));
            JdbcApiTest.assertEquals((Object)("city" + id), (Object)rs.getObject("City"));
            JdbcApiTest.assertEquals((String)("city" + id), (String)rs.getString("O.OWNER.CITY"));
            JdbcApiTest.assertEquals((String)("city" + id), (String)rs.getString("Owner.City"));
            JdbcApiTest.assertEquals((String)("city_" + id), (String)rs.getString("O.OWNERNAME.CITY"));
            JdbcApiTest.assertEquals((String)("city_" + id), (String)rs.getString("ownername.City"));
            JdbcApiTest.assertEquals((Object)("city" + id), (Object)rs.getObject("OWNER.CITY"));
            JdbcApiTest.assertEquals((Object)("city" + id), (Object)rs.getObject("o.owner.City"));
            JdbcApiTest.assertEquals((Object)("city_" + id), (Object)rs.getObject("OWNERNAME.CITY"));
            JdbcApiTest.assertEquals((Object)("city_" + id), (Object)rs.getObject("o.OwnerName.City"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("O.OWNER.ID"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("Owner.id"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("OWNERNAME.ID"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("o.ownerName.Id"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("OWNER.ID"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("O.owner.id"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("O.OWNERNAME.ID"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("ownername.id"));
            JdbcApiTest.assertEquals((String)("addr" + id), (String)rs.getString("ADDRESS"));
            JdbcApiTest.assertEquals((String)("addr" + id), (String)rs.getString("address"));
            JdbcApiTest.assertEquals((String)("addr" + id), (String)rs.getString("OWNER.ADDRESS"));
            JdbcApiTest.assertEquals((String)("addr" + id), (String)rs.getString("o.owner.Address"));
            JdbcApiTest.assertEquals((Object)("addr" + id), (Object)rs.getObject("ADDRESS"));
            JdbcApiTest.assertEquals((Object)("addr" + id), (Object)rs.getObject("address"));
            JdbcApiTest.assertEquals((Object)("addr" + id), (Object)rs.getObject("O.OWNER.ADDRESS"));
            JdbcApiTest.assertEquals((Object)("addr" + id), (Object)rs.getObject("Owner.address"));
            JdbcApiTest.assertEquals((String)("tel" + id), (String)rs.getString("TELEPHONE"));
            JdbcApiTest.assertEquals((String)("tel" + id), (String)rs.getString("Telephone"));
            JdbcApiTest.assertEquals((String)("tel" + id), (String)rs.getString("O.OWNER.TELEPHONE"));
            JdbcApiTest.assertEquals((String)("tel" + id), (String)rs.getString("OWNER.telephone"));
            JdbcApiTest.assertEquals((Object)("tel" + id), (Object)rs.getObject("TELEPHONE"));
            JdbcApiTest.assertEquals((Object)("tel" + id), (Object)rs.getObject("Telephone"));
            JdbcApiTest.assertEquals((Object)("tel" + id), (Object)rs.getObject("OWNER.TELEPHONE"));
            JdbcApiTest.assertEquals((Object)("tel" + id), (Object)rs.getObject("o.owner.telephone"));
            JdbcApiTest.assertEquals((String)("fname" + id), (String)rs.getString("FIRSTNAME"));
            JdbcApiTest.assertEquals((String)("fname" + id), (String)rs.getString("FirstName"));
            JdbcApiTest.assertEquals((String)("fname" + id), (String)rs.getString("O.OWNERNAME.FIRSTNAME"));
            JdbcApiTest.assertEquals((String)("fname" + id), (String)rs.getString("OwnerName.firstName"));
            JdbcApiTest.assertEquals((Object)("fname" + id), (Object)rs.getObject("FIRSTNAME"));
            JdbcApiTest.assertEquals((Object)("fname" + id), (Object)rs.getObject("firstname"));
            JdbcApiTest.assertEquals((Object)("fname" + id), (Object)rs.getObject("OWNERNAME.FIRSTNAME"));
            JdbcApiTest.assertEquals((Object)("fname" + id), (Object)rs.getObject("O.ownerName.firstname"));
            JdbcApiTest.assertEquals((String)("sname" + id), (String)rs.getString("LASTNAME"));
            JdbcApiTest.assertEquals((String)("sname" + id), (String)rs.getString("LastName"));
            JdbcApiTest.assertEquals((String)("sname" + id), (String)rs.getString("O.OWNERNAME.LASTNAME"));
            JdbcApiTest.assertEquals((String)("sname" + id), (String)rs.getString("o.ownerName.lastName"));
            JdbcApiTest.assertEquals((Object)("sname" + id), (Object)rs.getObject("LASTNAME"));
            JdbcApiTest.assertEquals((Object)("sname" + id), (Object)rs.getObject("lastname"));
            JdbcApiTest.assertEquals((Object)("sname" + id), (Object)rs.getObject("OWNERNAME.LASTNAME"));
            JdbcApiTest.assertEquals((Object)("sname" + id), (Object)rs.getObject("ownername.lastname"));
        }
        rs = stmt.executeQuery("select o.id, n.id, o.city, n.city, o.address from o.owner o, o.ownername n where o.id = n.id order by o.id");
        for (id = 1; id <= 10; ++id) {
            JdbcApiTest.assertTrue((boolean)rs.next());
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("ID"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("id"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("ID"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("id"));
            JdbcApiTest.assertEquals((String)("city" + id), (String)rs.getString("CITY"));
            JdbcApiTest.assertEquals((String)("city" + id), (String)rs.getString("City"));
            JdbcApiTest.assertEquals((Object)("city" + id), (Object)rs.getObject("CITY"));
            JdbcApiTest.assertEquals((Object)("city" + id), (Object)rs.getObject("City"));
            JdbcApiTest.assertEquals((String)("city" + id), (String)rs.getString("O.OWNER.CITY"));
            JdbcApiTest.assertEquals((String)("city" + id), (String)rs.getString("Owner.City"));
            JdbcApiTest.assertEquals((String)("city_" + id), (String)rs.getString("O.OWNERNAME.CITY"));
            JdbcApiTest.assertEquals((String)("city_" + id), (String)rs.getString("ownername.City"));
            JdbcApiTest.assertEquals((Object)("city" + id), (Object)rs.getObject("OWNER.CITY"));
            JdbcApiTest.assertEquals((Object)("city" + id), (Object)rs.getObject("o.owner.City"));
            JdbcApiTest.assertEquals((Object)("city_" + id), (Object)rs.getObject("OWNERNAME.CITY"));
            JdbcApiTest.assertEquals((Object)("city_" + id), (Object)rs.getObject("o.OwnerName.City"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("O.OWNER.ID"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("Owner.id"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("OWNERNAME.ID"));
            JdbcApiTest.assertEquals((int)id, (int)rs.getInt("o.ownerName.Id"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("OWNER.ID"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("O.owner.id"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("O.OWNERNAME.ID"));
            JdbcApiTest.assertEquals((Object)id, (Object)rs.getObject("ownername.id"));
            JdbcApiTest.assertEquals((String)("addr" + id), (String)rs.getString("ADDRESS"));
            JdbcApiTest.assertEquals((String)("addr" + id), (String)rs.getString("address"));
            JdbcApiTest.assertEquals((String)("addr" + id), (String)rs.getString("OWNER.ADDRESS"));
            JdbcApiTest.assertEquals((String)("addr" + id), (String)rs.getString("o.owner.Address"));
            JdbcApiTest.assertEquals((Object)("addr" + id), (Object)rs.getObject("ADDRESS"));
            JdbcApiTest.assertEquals((Object)("addr" + id), (Object)rs.getObject("address"));
            JdbcApiTest.assertEquals((Object)("addr" + id), (Object)rs.getObject("O.OWNER.ADDRESS"));
            JdbcApiTest.assertEquals((Object)("addr" + id), (Object)rs.getObject("Owner.address"));
        }
    }
}

