/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public class JUnit4TestBase {
    @Rule
    public TestName name = new TestName();

    @AfterClass
    public static void classTearDown() throws SQLException {
        TestUtil.setCurrentTestClass(null);
        TestUtil.currentTest = null;
        if (GemFireStore.getBootedInstance() != null) {
            Properties props = new Properties();
            if (TestUtil.bootUserName != null) {
                props.setProperty("user", TestUtil.bootUserName);
                props.setProperty("password", TestUtil.bootUserPassword);
            }
            Connection conn = DriverManager.getConnection(TestUtil.getProtocol(), props);
            CleanDatabaseTestSetup.cleanDatabase(conn, false);
        }
    }

    @Before
    public void setUp() {
        TestUtil.setCurrentTestClass(this.getClass());
        TestUtil.currentTest = this.name.getMethodName();
    }

    @After
    public void tearDown() {
        TestUtil.setCurrentTestClass(null);
        TestUtil.currentTest = null;
    }

    protected void setLogLevelForTest(String logLevel) {
        TestUtil.reduceLogLevel(logLevel);
    }
}

