/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.persistence.PersistentID;
import com.gemstone.gemfire.internal.FileUtil;
import com.gemstone.gemfire.internal.cache.AbstractRegionEntry;
import com.gemstone.gemfire.internal.cache.CacheObserver;
import com.gemstone.gemfire.internal.cache.CacheObserverAdapter;
import com.gemstone.gemfire.internal.cache.CacheObserverHolder;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionEntryContext;
import com.gemstone.gemfire.internal.cache.persistence.BackupManager;
import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TIntIntHashMap;
import com.gemstone.gnu.trove.TObjectObjectProcedure;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeIndexKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.TestCase;

public class IndexPersistenceTest
extends JdbcTestBase {
    public IndexPersistenceTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getBackupDirOnly());
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getIncrementalDir());
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getIncremental2Dir());
    }

    protected String offHeap() {
        return "";
    }

    protected static File getBackupDir() {
        File dir = IndexPersistenceTest.getBackupDirOnly();
        dir.mkdirs();
        return dir;
    }

    protected static File getBackupDirOnly() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        return new File(tmpDir, "backupDir");
    }

    private static File getIncrementalDir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, "incremental");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private static File getIncremental2Dir() {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File dir = new File(tmpDir, "incremental2");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    private void backup_shutdown_cleanup_restore(File backupDir, File baseDir) throws SQLException, IOException, InterruptedException {
        IndexPersistenceTest.deleteDirContents(backupDir);
        Map<String, Long> originalFiles = IndexPersistenceTest.getAllOplogFiles();
        HashSet<PersistentID> status = this.backup(backupDir, baseDir);
        IndexPersistenceTest.assertEquals((int)2, (int)status.size());
        TestUtil.shutDown();
        IndexPersistenceTest.clearAllOplogFiles();
        this.restoreBackup(backupDir, 1);
        Map<String, Long> restoredFiles = IndexPersistenceTest.getAllOplogFiles();
        if (!originalFiles.equals(restoredFiles)) {
            TreeMap<String, Long> missing = new TreeMap<String, Long>(originalFiles);
            TreeMap<String, Long> newFiles = new TreeMap<String, Long>(restoredFiles);
            missing.entrySet().removeAll(restoredFiles.entrySet());
            newFiles.entrySet().removeAll(originalFiles.entrySet());
            IndexPersistenceTest.fail("Files restored from backup did not match original set. Missing files : " + missing + ", new files " + newFiles);
        }
    }

    private HashSet<PersistentID> backup(File backupDir, File baseDir) throws IOException {
        BackupManager backup = Misc.getGemFireCache().startBackup(Misc.getGemFireCache().getDistributedSystem().getDistributedMember());
        backup.prepareBackup();
        HashSet set = backup.finishBackup(backupDir, baseDir);
        File incompleteBackup = FileUtil.find((File)backupDir, (String)".*INCOMPLETE.*");
        IndexPersistenceTest.assertNull((Object)incompleteBackup);
        return set;
    }

    protected void restoreBackup(File backupDir, int expectedNumScripts) throws IOException, InterruptedException {
        List restoreScripts = FileUtil.findAll((File)backupDir, (String)".*restore.*");
        IndexPersistenceTest.assertEquals((String)("Restore scripts " + restoreScripts), (int)expectedNumScripts, (int)restoreScripts.size());
        for (File script : restoreScripts) {
            System.out.println("restore scripts:" + script);
            this.execute(script);
        }
    }

    private void execute(File script) throws IOException, InterruptedException {
        String line;
        ProcessBuilder pb = new ProcessBuilder(script.getAbsolutePath());
        pb.redirectErrorStream(true);
        Process process = pb.start();
        InputStream is = process.getInputStream();
        byte[] buffer = new byte[1024];
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        while ((line = br.readLine()) != null) {
            System.out.println("OUTPUT:" + line);
        }
        IndexPersistenceTest.assertEquals((int)0, (int)process.waitFor());
    }

    private static File[] listFiles(File dir) {
        File[] result = dir.listFiles();
        if (result == null) {
            result = new File[]{};
        }
        return result;
    }

    public static void printDirectory(String dirname, String testcasename) {
        File[] files = IndexPersistenceTest.listFiles(new File(dirname));
        if (!testcasename.equals("")) {
            System.out.println("------------------");
        }
        System.out.println(testcasename + ":list dir:" + dirname);
        for (File f : files) {
            if (f.getAbsolutePath().contains(".xml") || f.getAbsolutePath().contains(".gfs") || f.getAbsolutePath().contains(".log") || f.getAbsolutePath().contains(".dtd") || f.getAbsolutePath().contains(".txt")) continue;
            System.out.println("list dir:" + f + ":size=" + f.length());
            if (!f.isDirectory() || !f.exists()) continue;
            IndexPersistenceTest.printDirectory(f.getAbsolutePath(), "");
        }
        String dict_dir = dirname + "/datadictionary";
        if (new File(dict_dir).exists()) {
            IndexPersistenceTest.printDirectory(dict_dir, "");
        }
    }

    public void testRecoveryOfIndexThroughAlterTable_simulateCrash() throws Exception {
        CrashSimulator crashSimulator = new CrashSimulator();
        this.alterTableTest((CacheObserver)crashSimulator);
    }

    public void testRecoveryOfIndexThroughAlterTable() throws Exception {
        this.alterTableTest(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterTableTest(CacheObserver crashSimulator) throws Exception {
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        for (int j = 0; j < 2; ++j) {
            try {
                int cnt;
                int i;
                TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                if (j == 1) {
                    ddl = ddl + " replicate";
                }
                stmt.execute(ddl);
                PreparedStatement ps = conn.prepareStatement("insert into TMP.T1 values(?, ?, ?)");
                for (i = 0; i < 20; ++i) {
                    ps.setInt(1, i);
                    ps.setString(2, "one-c2-" + i);
                    ps.setInt(3, i);
                    cnt = ps.executeUpdate();
                    IndexPersistenceTest.assertEquals((int)1, (int)cnt);
                }
                stmt.execute("create table TMP.T2(c12 int not null primary key, c22 varchar(20) not null, c32 int not null, c42 int not null, c52 int not null) persistent" + (j == 1 ? " replicate" : "") + this.offHeap());
                stmt.execute("alter table TMP.T2 add constraint t2_fk foreign key (c12) references TMP.T1 (c1)");
                stmt.execute("alter table TMP.T2 add constraint t2_uk1 unique (c32)");
                if (crashSimulator != null) {
                    LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
                }
                CacheObserverHolder.setInstance((CacheObserver)crashSimulator);
                ps = conn.prepareStatement("insert into TMP.T2 values(?, ?, ?, ?, ?)");
                for (i = 0; i < 5; ++i) {
                    ps.setInt(1, i);
                    ps.setString(2, "c22-" + i);
                    ps.setInt(3, i);
                    ps.setInt(4, i);
                    ps.setInt(5, i);
                    cnt = ps.executeUpdate();
                    IndexPersistenceTest.assertEquals((int)1, (int)cnt);
                }
                stmt.execute("alter table TMP.T2 add constraint t2_uk2 unique (c52)");
                for (i = 5; i < 10; ++i) {
                    ps.setInt(1, i);
                    ps.setString(2, "c22-" + i);
                    ps.setInt(3, i);
                    ps.setInt(4, i);
                    ps.setInt(5, i);
                    cnt = ps.executeUpdate();
                    IndexPersistenceTest.assertEquals((int)1, (int)cnt);
                }
                TestUtil.shutDown();
                LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
                IndexAccountObserver ob = new IndexAccountObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob);
                conn = TestUtil.getConnection();
                if (j == 0) {
                    IndexPersistenceTest.assertEquals((int)1, (int)ob.getMap().size());
                } else {
                    IndexPersistenceTest.assertEquals((int)3, (int)ob.getMap().size());
                }
                ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                    public boolean execute(Object a, Object b) {
                        TestCase.assertEquals((int)10, (int)((Integer)b));
                        return true;
                    }
                });
                TestUtil.shutDown();
                LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
                ob = new IndexAccountObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob);
                conn = TestUtil.getConnection();
                if (j == 0) {
                    IndexPersistenceTest.assertEquals((int)1, (int)ob.getMap().size());
                } else {
                    IndexPersistenceTest.assertEquals((int)3, (int)ob.getMap().size());
                }
                ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                    public boolean execute(Object a, Object b) {
                        TestCase.assertEquals((int)10, (int)((Integer)b));
                        return true;
                    }
                });
                continue;
            }
            finally {
                this.doCleanUp();
            }
        }
    }

    public void DISABLED_BUG_51841_testRecoveryOfImplicitIndexes_orig() throws Exception {
        this.doTestRecoveryOfImplicitIndexes(false, false);
        this.doTestRecoveryOfImplicitIndexes(true, false);
    }

    public void DISABLED_BUG_51841_testRecoveryOfImplicitIndexes() throws Exception {
        this.doTestRecoveryOfImplicitIndexes(false, true);
        this.doTestRecoveryOfImplicitIndexes(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestRecoveryOfImplicitIndexes(boolean replicate, boolean singleAmpersand) throws Exception {
        String ddl2;
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        String origDDL2 = ddl2 = "create table TMP.T2(c12 int not null unique , c22 varchar(20) not null, c32 int not null, foreign key (c32) references TMP.T1(c1)) persistent" + this.offHeap();
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getBackupDirOnly());
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getIncrementalDir());
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getIncremental2Dir());
        try {
            int num;
            Integer i;
            TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
            Connection conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            stmt.execute("create schema TMP");
            if (replicate) {
                ddl = ddl + " replicate";
            }
            stmt.execute(ddl);
            stmt.execute("create index TMP.IDX2 on TMP.T1(c2, c3)");
            stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
            stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
            stmt.execute("insert into TMP.T1 values(5, 'one', 1), (6, 'two', 2), (7, 'three', 3), (8, 'four', 3)");
            stmt.execute("select * from TMP.T1 where c3 = 3");
            ResultSet rs = stmt.getResultSet();
            int cnt = 0;
            while (rs.next()) {
                i = (Integer)rs.getObject(1);
                if (i == 3 || i == 4 || i == 7 || i == 8) {
                    IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                }
                ++cnt;
            }
            ddl2 = replicate ? (origDDL2 = origDDL2 + " replicate") : ddl2 + " partition by column(c12)";
            stmt.execute(ddl2);
            stmt.execute("insert into TMP.T2 values(1, 'one', 2), (2, 'two', 1), (3, 'three', 2), (4, 'four', 8)");
            stmt.execute("create index TMP.IDX22 on TMP.t2(c22)");
            stmt.execute("insert into TMP.T2 values(11, 'thirtyone', 7), (12, 'thirtytwo', 5), (13, 'thirtythree', 3), (14, 'thirtyfour', 3)");
            observer.clear();
            if (singleAmpersand) {
                stmt.execute("select * from TMP.T2 where c22 like 'thirty%'");
            } else {
                stmt.execute("select * from TMP.T2 where c22 like '%thirty%'");
            }
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                i = (Integer)rs.getObject(1);
                IndexPersistenceTest.assertTrue((i == 11 || i == 12 || i == 13 || i == 14 ? 1 : 0) != 0);
                ++cnt;
            }
            observer.addExpectedScanType("TMP.T2", "TMP.IDX22", TestUtil.ScanType.SORTEDMAPINDEX);
            observer.checkAndClear();
            IndexPersistenceTest.assertEquals((int)4, (int)cnt);
            GfxdIndexManager iu = (GfxdIndexManager)((LocalRegion)Misc.getGemFireCache().getRegion("/TMP/T2")).getIndexUpdater();
            List list = iu.getIndexContainers();
            for (GemFireContainer index : list) {
                System.out.println("index=" + index + " ID: " + index.getQualifiedTableName());
            }
            this.backup_shutdown_cleanup_restore(IndexPersistenceTest.getBackupDir(), null);
            IndexAccountObserver ob = new IndexAccountObserver();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob);
            conn = TestUtil.getConnection();
            ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                public boolean execute(Object a, Object b) {
                    System.out.println("KN: a=" + a + " b=" + b);
                    return true;
                }
            });
            System.out.println("KN: ************** First restart ****************");
            IndexPersistenceTest.assertEquals((int)5, (int)ob.getMap().size());
            ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                public boolean execute(Object a, Object b) {
                    System.out.println("KN: a=" + a + " b=" + b);
                    TestCase.assertEquals((int)8, (int)((Integer)b));
                    return true;
                }
            });
            System.out.println("KN: ************** First restart end****************");
            stmt = conn.createStatement();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            observer.addExpectedScanType("TMP.T2", "TMP.IDX22", TestUtil.ScanType.SORTEDMAPINDEX);
            if (singleAmpersand) {
                stmt.execute("select * from TMP.T2 where c22 like 'thirty%'");
            } else {
                stmt.execute("select * from TMP.T2 where c22 like '%thirty%'");
            }
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                Integer i2 = (Integer)rs.getObject(1);
                IndexPersistenceTest.assertTrue((i2 == 11 || i2 == 12 || i2 == 13 || i2 == 14 ? 1 : 0) != 0);
                ++cnt;
            }
            IndexPersistenceTest.assertEquals((int)4, (int)cnt);
            observer.checkAndClear();
            stmt.execute("select c32 from TMP.T2");
            rs = stmt.getResultSet();
            cnt = 0;
            TIntIntHashMap res = new TIntIntHashMap();
            while (rs.next()) {
                Integer i3 = (Integer)rs.getObject(1);
                num = res.get(i3.intValue());
                res.put(i3.intValue(), ++num);
                ++cnt;
            }
            observer.checkAndClear();
            IndexPersistenceTest.assertEquals((int)8, (int)cnt);
            IndexPersistenceTest.assertEquals((int)2, (int)res.get(2));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(1));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(8));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(7));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(5));
            IndexPersistenceTest.assertEquals((int)2, (int)res.get(3));
            observer.clear();
            observer.addExpectedScanType("TMP.T2", "TMP.3__T2__C12", TestUtil.ScanType.SORTEDMAPINDEX);
            stmt.execute("select * from TMP.T2 where c12 = 3 or c12 = 14");
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                int i4 = rs.getInt(1);
                IndexPersistenceTest.assertTrue((i4 == 3 || i4 == 14 ? 1 : 0) != 0);
                ++cnt;
            }
            observer.checkAndClear();
            IndexPersistenceTest.assertEquals((int)2, (int)cnt);
            stmt.execute("create index TMP.IDX33 on TMP.T2(c12, c32)");
            observer.clear();
            observer.addExpectedScanType("TMP.T2", "TMP.IDX33", TestUtil.ScanType.SORTEDMAPINDEX);
            stmt.execute("select c12, c22 from TMP.T2 where c12 = 1 and c32 = 2");
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                int i5 = rs.getInt(1);
                IndexPersistenceTest.assertEquals((int)1, (int)i5);
                ++cnt;
            }
            observer.checkAndClear();
            IndexPersistenceTest.assertEquals((int)1, (int)cnt);
            this.backup_shutdown_cleanup_restore(IndexPersistenceTest.getIncrementalDir(), IndexPersistenceTest.getBackupDir());
            ob = new IndexAccountObserver();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob);
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            System.out.println("KN: ************** Printing all at Second restart ****************");
            ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                public boolean execute(Object a, Object b) {
                    System.out.println("KN: a=" + a + " b=" + b);
                    return true;
                }
            });
            IndexPersistenceTest.assertEquals((int)6, (int)ob.getMap().size());
            System.out.println("KN: ************** Second restart ****************");
            ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                public boolean execute(Object a, Object b) {
                    System.out.println("KN: a=" + a + " b=" + b);
                    TestCase.assertEquals((int)8, (int)((Integer)b));
                    return true;
                }
            });
            System.out.println("KN: ************** Second restart end****************");
            stmt = conn.createStatement();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            observer.addExpectedScanType("TMP.T2", "TMP.IDX22", TestUtil.ScanType.SORTEDMAPINDEX);
            if (singleAmpersand) {
                stmt.execute("select * from TMP.T2 where c22 like 'thirty%'");
            } else {
                stmt.execute("select * from TMP.T2 where c22 like '%thirty%'");
            }
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                Integer i6 = (Integer)rs.getObject(1);
                IndexPersistenceTest.assertTrue((i6 == 11 || i6 == 12 || i6 == 13 || i6 == 14 ? 1 : 0) != 0);
                ++cnt;
            }
            observer.checkAndClear();
            IndexPersistenceTest.assertEquals((int)4, (int)cnt);
            stmt.execute("select c32 from TMP.T2");
            rs = stmt.getResultSet();
            cnt = 0;
            res = new TIntIntHashMap();
            while (rs.next()) {
                Integer i7 = (Integer)rs.getObject(1);
                num = res.get(i7.intValue());
                res.put(i7.intValue(), ++num);
                ++cnt;
            }
            observer.checkAndClear();
            IndexPersistenceTest.assertEquals((int)8, (int)cnt);
            IndexPersistenceTest.assertEquals((int)2, (int)res.get(2));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(1));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(8));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(7));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(5));
            IndexPersistenceTest.assertEquals((int)2, (int)res.get(3));
            observer.clear();
            observer.addExpectedScanType("TMP.T2", "TMP.3__T2__C12", TestUtil.ScanType.SORTEDMAPINDEX);
            stmt.execute("select * from TMP.T2 where c12 = 3 or c12 = 14");
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                int i8 = rs.getInt(1);
                IndexPersistenceTest.assertTrue((i8 == 3 || i8 == 14 ? 1 : 0) != 0);
                ++cnt;
            }
            IndexPersistenceTest.assertEquals((int)2, (int)cnt);
            stmt.execute("select c12, c32 from TMP.T2 where c12 = 1 and c32 = 2");
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                int i9 = rs.getInt(1);
                IndexPersistenceTest.assertEquals((int)1, (int)i9);
                ++cnt;
            }
            IndexPersistenceTest.assertEquals((int)1, (int)cnt);
            observer.clear();
            this.backup_shutdown_cleanup_restore(IndexPersistenceTest.getIncremental2Dir(), IndexPersistenceTest.getIncrementalDir());
            ob = new IndexAccountObserver();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob);
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            IndexPersistenceTest.assertEquals((int)6, (int)ob.getMap().size());
            System.out.println("KN: ************** Third restart ****************");
            ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                public boolean execute(Object a, Object b) {
                    System.out.println("KN: a=" + a + " b=" + b);
                    return true;
                }
            });
            System.out.println("KN: ************** Third restart end****************");
            stmt = conn.createStatement();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            observer.addExpectedScanType("TMP.T2", "TMP.IDX22", TestUtil.ScanType.SORTEDMAPINDEX);
            if (singleAmpersand) {
                stmt.execute("select * from TMP.T2 where c22 like 'thirty%'");
            } else {
                stmt.execute("select * from TMP.T2 where c22 like '%thirty%'");
            }
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                Integer i10 = (Integer)rs.getObject(1);
                IndexPersistenceTest.assertTrue((i10 == 11 || i10 == 12 || i10 == 13 || i10 == 14 ? 1 : 0) != 0);
                ++cnt;
            }
            observer.checkAndClear();
            IndexPersistenceTest.assertEquals((int)4, (int)cnt);
            stmt.execute("select c32 from TMP.T2");
            rs = stmt.getResultSet();
            cnt = 0;
            res = new TIntIntHashMap();
            while (rs.next()) {
                Integer i11 = (Integer)rs.getObject(1);
                num = res.get(i11.intValue());
                res.put(i11.intValue(), ++num);
                ++cnt;
            }
            observer.checkAndClear();
            IndexPersistenceTest.assertEquals((int)8, (int)cnt);
            IndexPersistenceTest.assertEquals((int)2, (int)res.get(2));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(1));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(8));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(7));
            IndexPersistenceTest.assertEquals((int)1, (int)res.get(5));
            IndexPersistenceTest.assertEquals((int)2, (int)res.get(3));
        }
        finally {
            this.doCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_BUG_51841_testIncrementalBackupWithIndexCreation() throws Exception {
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getBackupDirOnly());
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getIncrementalDir());
        IndexPersistenceTest.deleteDir(IndexPersistenceTest.getIncremental2Dir());
        try {
            Integer i;
            System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
            Connection conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            stmt.execute("create schema TMP");
            stmt.execute(ddl);
            stmt.execute("create index TMP.IDX2 on TMP.T1(c2, c3)");
            stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
            this.backup_shutdown_cleanup_restore(IndexPersistenceTest.getBackupDir(), null);
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
            stmt.execute("insert into TMP.T1 values(5, 'one', 1), (6, 'two', 2), (7, 'three', 3), (8, 'four', 3)");
            stmt.execute("select * from TMP.T1 where c3 = 3");
            ResultSet rs = stmt.getResultSet();
            int cnt = 0;
            while (rs.next()) {
                i = (Integer)rs.getObject(1);
                if (i == 3 || i == 4 || i == 7 || i == 8) {
                    IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                }
                ++cnt;
            }
            IndexPersistenceTest.assertEquals((int)4, (int)cnt);
            this.backup_shutdown_cleanup_restore(IndexPersistenceTest.getIncrementalDir(), IndexPersistenceTest.getBackupDir());
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute("drop index TMP.IDX1");
            stmt.execute("create index TMP.IDX1 on TMP.T1(c3, c2)");
            this.backup_shutdown_cleanup_restore(IndexPersistenceTest.getIncremental2Dir(), IndexPersistenceTest.getIncrementalDir());
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute("select * from TMP.T1 where c3 = 3");
            rs = stmt.getResultSet();
            cnt = 0;
            while (rs.next()) {
                i = (Integer)rs.getObject(1);
                if (i == 3 || i == 4 || i == 7 || i == 8) {
                    IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                }
                ++cnt;
            }
            IndexPersistenceTest.assertEquals((int)4, (int)cnt);
        }
        finally {
            this.doCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void DISABLED_BUG_51841_testRecoveryOfOnTheFlyIndexCreation() throws Exception {
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        for (int j = 0; j < 2; ++j) {
            try {
                Object i;
                TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                if (j == 1) {
                    ddl = ddl + " replicate";
                }
                stmt.execute(ddl);
                stmt.execute("create index TMP.IDX2 on TMP.T1(c2, c3)");
                stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                stmt.execute("insert into TMP.T1 values(5, 'one', 1), (6, 'two', 2), (7, 'three', 3), (8, 'four', 3)");
                stmt.execute("select * from TMP.T1 where c3 = 3");
                ResultSet rs = stmt.getResultSet();
                int cnt = 0;
                while (rs.next()) {
                    Integer i2 = (Integer)rs.getObject(1);
                    if (i2 == 3 || i2 == 4 || i2 == 7 || i2 == 8) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.T1", "TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                observer.addExpectedScanType("TMP.T1", "TMP.T1", TestUtil.ScanType.TABLE);
                observer.checkAndClear();
                IndexPersistenceTest.assertEquals((int)4, (int)cnt);
                stmt.execute("create index TMP.IDX3 on TMP.T1(c2)");
                stmt.execute("create index TMP.IDX4 on TMP.T1(c1, c2, c3)");
                this.backup_shutdown_cleanup_restore(IndexPersistenceTest.getBackupDir(), null);
                IndexAccountObserver ob = new IndexAccountObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)ob);
                conn = TestUtil.getConnection();
                ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                    public boolean execute(Object a, Object b) {
                        System.out.println("KN: a=" + a + " b=" + b);
                        return true;
                    }
                });
                IndexPersistenceTest.assertEquals((int)4, (int)ob.getMap().size());
                ob.getMap().forEachEntry(new TObjectObjectProcedure(){

                    public boolean execute(Object a, Object b) {
                        TestCase.assertEquals((int)8, (int)((Integer)b));
                        return true;
                    }
                });
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    i = (Integer)rs.getObject(1);
                    if ((Integer)i == 3 || (Integer)i == 4 || (Integer)i == 7 || (Integer)i == 8) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.T1", "TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                observer.addExpectedScanType("TMP.T1", "TMP.T1", TestUtil.ScanType.TABLE);
                observer.checkAndClear();
                IndexPersistenceTest.assertEquals((int)4, (int)cnt);
                stmt.execute("select * from TMP.T1 where c1 = 1 and c2 = 'one' and c3 = 1");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    i = (Integer)rs.getObject(1);
                    IndexPersistenceTest.assertEquals((Object)i, (Object)rs.getObject(3));
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.IDX4", TestUtil.ScanType.SORTEDMAPINDEX);
                IndexPersistenceTest.assertEquals((int)1, (int)cnt);
                stmt.execute("select * from TMP.T1 where c2 = 'two'");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    i = rs.getString(2);
                    IndexPersistenceTest.assertTrue((boolean)((String)i).equals("two"));
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.IDX3", TestUtil.ScanType.SORTEDMAPINDEX);
                IndexPersistenceTest.assertEquals((int)2, (int)cnt);
                observer.clear();
                stmt.execute("insert into TMP.T1 values(9, 'one', 1), (10, 'two', 2), (11, 'three', 3), (12, 'four', 3)");
                this.backup_shutdown_cleanup_restore(IndexPersistenceTest.getBackupDir(), null);
                conn = TestUtil.getConnection();
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    i = (Integer)rs.getObject(1);
                    if ((Integer)i == 3 || (Integer)i == 4 || (Integer)i == 7 || (Integer)i == 8 || (Integer)i == 11 || (Integer)i == 12) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    System.out.println(rs.getObject(1) + ", " + rs.getObject(2) + ", " + rs.getObject(3));
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.T1", "TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                observer.checkAndClear();
                IndexPersistenceTest.assertEquals((int)6, (int)cnt);
                stmt.execute("select * from TMP.T1 where c2 = 'three'");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    i = rs.getString(2);
                    IndexPersistenceTest.assertTrue((boolean)((String)i).equals("three"));
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.IDX3", TestUtil.ScanType.SORTEDMAPINDEX);
                IndexPersistenceTest.assertEquals((int)3, (int)cnt);
                continue;
            }
            finally {
                this.doCleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoveryAfterNormalShutDown() throws Exception {
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        for (int j = 0; j < 1; ++j) {
            try {
                Integer i;
                TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                if (j == 1) {
                    ddl = ddl + " replicate";
                }
                stmt.execute(ddl);
                stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                stmt.execute("select * from TMP.T1 where c3 = 3");
                ResultSet rs = stmt.getResultSet();
                int cnt = 0;
                while (rs.next()) {
                    i = (Integer)rs.getObject(1);
                    if (i == 3 || i == 4) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                IndexPersistenceTest.assertEquals((int)2, (int)cnt);
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    i = (Integer)rs.getObject(1);
                    if (i == 3 || i == 4) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                IndexPersistenceTest.assertEquals((int)2, (int)cnt);
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    i = (Integer)rs.getObject(1);
                    if (i == 3 || i == 4) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                IndexPersistenceTest.assertEquals((int)2, (int)cnt);
                continue;
            }
            finally {
                this.doCleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompactionWithIdxKrf() throws Exception {
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        for (int j = 0; j < 1; ++j) {
            try {
                TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                if (j == 1) {
                    ddl = ddl + " replicate";
                }
                stmt.execute(ddl);
                stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                PreparedStatement ps = conn.prepareStatement("insert into TMP.T1 values(?, 'word', ?)");
                for (int i = 0; i < 50; ++i) {
                    ps.setInt(1, i);
                    ps.setInt(2, i);
                    ps.addBatch();
                }
                ps.executeBatch();
                stmt.execute("select * from TMP.T1 where c3 = 3");
                ResultSet rs = stmt.getResultSet();
                int cnt = 0;
                while (rs.next()) {
                    Integer i = (Integer)rs.getObject(1);
                    if (i == 3) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                IndexPersistenceTest.assertEquals((int)1, (int)cnt);
                GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                DiskStoreImpl ds = cache.findDiskStore(cache.getDefaultDiskStoreName());
                ds.forceRoll();
                stmt.execute("delete from TMP.T1 where c1 > 5");
                ds.forceCompaction();
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    Integer i = (Integer)rs.getObject(1);
                    if (i == 3) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                IndexPersistenceTest.assertEquals((int)1, (int)cnt);
                continue;
            }
            finally {
                this.doCleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoveryAfterNormalShutDown_withUpdatesAlso_noPK() throws Exception {
        String ddl = "create table TMP.T1(c1 int not null, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        for (int j = 0; j < 2; ++j) {
            try {
                TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                if (j == 1) {
                    ddl = ddl + " replicate";
                }
                stmt.execute(ddl);
                stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                Statement stmt2 = conn.createStatement();
                stmt2.execute("update TMP.T1 set c3 = 4 where c3 = 3");
                stmt2.execute("select * from TMP.T1 where c3 = 3");
                ResultSet rs = stmt2.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                stmt = conn.createStatement();
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                continue;
            }
            finally {
                this.doCleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoveryAfterNormalShutDown_withUpdatesAlso() throws Exception {
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        for (int j = 0; j < 2; ++j) {
            try {
                TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                if (j == 1) {
                    ddl = ddl + " replicate";
                }
                stmt.execute(ddl);
                stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                Statement stmt2 = conn.createStatement();
                stmt2.execute("update TMP.T1 set c3 = 4 where c3 = 3");
                stmt2.execute("select * from TMP.T1 where c3 = 3");
                ResultSet rs = stmt2.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                stmt = conn.createStatement();
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                continue;
            }
            finally {
                this.doCleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoMemoryLeakOnCrashIndexRecovery() throws Exception {
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) eviction by lrucount 1 evictaction overflow synchronous replicate persistent" + this.offHeap();
        for (int j = 0; j < 1; ++j) {
            try {
                System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                CrashSimulator crashSimulator = new CrashSimulator();
                if (crashSimulator != null) {
                    LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = true;
                }
                CacheObserverHolder.setInstance((CacheObserver)crashSimulator);
                stmt.execute("create schema TMP");
                if (j == 1) {
                    ddl = ddl + " replicate";
                }
                stmt.execute(ddl);
                stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                stmt.execute("select * from TMP.T1 where c3 = 3");
                ResultSet rs = stmt.getResultSet();
                int cnt = 0;
                while (rs.next()) {
                    Integer i = (Integer)rs.getObject(1);
                    if (i == 3 || i == 4) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                final ArrayList cciks = new ArrayList();
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                    public void scanControllerOpened(Object sc, Conglomerate conglom) {
                        try {
                            if (sc instanceof SortedMap2IndexScanController) {
                                SortedMap2IndexScanController indexScan = (SortedMap2IndexScanController)sc;
                                Class<MemIndexScanController> memIndexSCClass = MemIndexScanController.class;
                                Field openConglomField = memIndexSCClass.getDeclaredField("openConglom");
                                openConglomField.setAccessible(true);
                                OpenMemIndex mi = (OpenMemIndex)openConglomField.get(sc);
                                ConcurrentSkipListMap skipListMap = mi.getGemFireContainer().getSkipListMap();
                                for (Object key : skipListMap.keySet()) {
                                    if (!(key instanceof CompactCompositeIndexKey)) continue;
                                    cciks.add((CompactCompositeIndexKey)key);
                                }
                            }
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                LocalRegion region = Misc.getRegionByPath((String)"/TMP/T1");
                IndexPersistenceTest.assertNotNull((Object)region);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                cnt = 0;
                while (rs.next()) {
                    Integer i = (Integer)rs.getObject(1);
                    if (i == 3 || i == 4) {
                        IndexPersistenceTest.assertEquals((Object)3, (Object)rs.getObject(3));
                    }
                    ++cnt;
                }
                HashSet<Object> bytesStoredInRegion = new HashSet<Object>();
                Set keys = region.keys();
                for (Object e : keys) {
                    AbstractRegionEntry are = (AbstractRegionEntry)region.basicGetEntry(e);
                    Object val = are.getValueInVM((RegionEntryContext)region);
                    bytesStoredInRegion.add(val);
                }
                IndexPersistenceTest.assertFalse((boolean)cciks.isEmpty());
                for (CompactCompositeIndexKey compactCompositeIndexKey : cciks) {
                    Object valBytes = compactCompositeIndexKey.getValueByteSource();
                    if (valBytes != null) {
                        IndexPersistenceTest.assertTrue((boolean)bytesStoredInRegion.contains(valBytes));
                    }
                    compactCompositeIndexKey.releaseValueByteSource(valBytes);
                }
                for (Object e : bytesStoredInRegion) {
                    if (!(e instanceof OffHeapByteSource)) continue;
                    ((OffHeapByteSource)e).release();
                }
                TestUtil.shutDown();
                continue;
            }
            finally {
                this.doCleanUp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRecoveryAfterNormalShutDown_withUpdatesAlso_txn() throws Exception {
        String ddl = "create table TMP.T1(c1 int not null primary key, c2 varchar(20) not null, c3 int not null) persistent" + this.offHeap();
        for (int j = 0; j < 4; ++j) {
            try {
                int cnt;
                TestUtil.ScanTypeQueryObserver observer = new TestUtil.ScanTypeQueryObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "true");
                Connection conn = TestUtil.getConnection();
                Statement stmt = conn.createStatement();
                stmt.execute("create schema TMP");
                if (j > 1) {
                    ddl = ddl + " replicate";
                }
                stmt.execute(ddl);
                stmt.execute("create index TMP.IDX1 on TMP.T1(c3)");
                stmt.execute("insert into TMP.T1 values(1, 'one', 1), (2, 'two', 2), (3, 'three', 3), (4, 'four', 3)");
                conn.setTransactionIsolation(2);
                conn.setAutoCommit(false);
                Statement stmt2 = conn.createStatement();
                stmt2.execute("update TMP.T1 set c3 = 4 where c3 = 3");
                stmt2.execute("select * from TMP.T1 where c3 = 3");
                ResultSet rs = stmt2.getResultSet();
                IndexPersistenceTest.assertFalse((boolean)rs.next());
                if (j % 2 == 0) {
                    conn.commit();
                } else {
                    conn.rollback();
                }
                stmt = conn.createStatement();
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                if (j % 2 == 0) {
                    IndexPersistenceTest.assertFalse((boolean)rs.next());
                } else {
                    IndexPersistenceTest.assertTrue((boolean)rs.next());
                    cnt = 1;
                    while (rs.next()) {
                        ++cnt;
                    }
                    IndexPersistenceTest.assertEquals((int)2, (int)cnt);
                }
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                if (j % 2 == 0) {
                    IndexPersistenceTest.assertFalse((boolean)rs.next());
                } else {
                    IndexPersistenceTest.assertTrue((boolean)rs.next());
                    cnt = 1;
                    while (rs.next()) {
                        ++cnt;
                    }
                    IndexPersistenceTest.assertEquals((int)2, (int)cnt);
                }
                observer.addExpectedScanType("TMP.IDX1", TestUtil.ScanType.SORTEDMAPINDEX);
                TestUtil.shutDown();
                conn = TestUtil.getConnection();
                this.checkIndexRecovery(true);
                stmt = conn.createStatement();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
                stmt.execute("select * from TMP.T1 where c3 = 3");
                rs = stmt.getResultSet();
                if (j % 2 == 0) {
                    IndexPersistenceTest.assertFalse((boolean)rs.next());
                    continue;
                }
                IndexPersistenceTest.assertTrue((boolean)rs.next());
                cnt = 1;
                while (rs.next()) {
                    ++cnt;
                }
                IndexPersistenceTest.assertEquals((int)2, (int)cnt);
                continue;
            }
            finally {
                this.doCleanUp();
            }
        }
    }

    private void doCleanUp() throws SQLException {
        System.setProperty(GfxdConstants.GFXD_PERSIST_INDEXES, "false");
        TestUtil.shutDown();
        IndexPersistenceTest.clearAllOplogFiles();
        CacheObserverHolder.setInstance(null);
        LocalRegion.ISSUE_CALLBACKS_TO_CACHE_OBSERVER = false;
    }

    private void checkIndexRecovery(boolean expected) {
        boolean actual = GemFireStore.getBootingInstance().didIndexRecovery();
        IndexPersistenceTest.assertEquals((boolean)expected, (boolean)actual);
    }

    private class CrashSimulator
    extends CacheObserverAdapter {
        private CrashSimulator() {
        }

        public boolean shouldCreateKRFIRF() {
            return false;
        }
    }

    private static class IndexAccountObserver
    extends GemFireXDQueryObserverAdapter {
        private THashMap map;

        private IndexAccountObserver() {
        }

        public boolean needIndexRecoveryAccounting() {
            return true;
        }

        public void setIndexRecoveryAccountingMap(THashMap map) {
            this.map = map;
        }

        public THashMap getMap() {
            return this.map;
        }
    }
}

