/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.ToursDBUtil;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.load.ImportBase;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.IOException;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.log4j.Logger;

public class ImportExportTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ImportExportTest.class));
    }

    public ImportExportTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testCaseInsensitivity() throws SQLException {
        currentUserName = null;
        currentUserPassword = null;
        Connection conn = ImportExportTest.getConnection();
        ToursDBUtil.createAndLoadToursDB(conn);
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM flights");
        ImportExportTest.assertTrue((boolean)rs.next());
        int numRows = rs.getInt(1);
        rs.close();
        s.executeUpdate("CALL SYSCS_UTIL.EXPORT_TABLE('aPp','fLightS','flites.csv',null,null,null)");
        s.executeUpdate("CREATE TABLE FLIGHTS2(FLIGHT_ID CHAR(6) NOT NULL , SEGMENT_NUMBER INTEGER NOT NULL , ORIG_AIRPORT CHAR(3), DEPART_TIME TIME, DEST_AIRPORT CHAR(3), ARRIVE_TIME TIME, MEAL CHAR(1), FLYING_TIME DOUBLE PRECISION, MILES INTEGER, AIRCRAFT VARCHAR(6), CONSTRAINT FLIGHTS_PK2 Primary Key ( FLIGHT_ID, SEGMENT_NUMBER), CONSTRAINT MEAL_CONSTRAINT2 CHECK (meal IN ('B', 'L', 'D', 'S')))");
        s.executeUpdate("CALL SYSCS_UTIL.IMPORT_TABLE('ApP','Flights2','flites.csv',null,null,null,0)");
        rs = s.executeQuery("SELECT * FROM flights2");
        ImportExportTest.assertEquals((int)numRows, (int)JDBC.assertDrainResults(rs));
        conn.close();
    }

    private void testImportHelper(Connection conn, String dataScript, String testDir, int expectedRows) throws SQLException, IOException, PrivilegedActionException, StandardException {
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{dataScript}, (boolean)false, (Logger)ImportExportTest.getLogger(), (String)"<path_prefix>", (String)testDir, (boolean)false);
        String viewQuery = "SELECT * from TD_INSTRUMENT_SCD";
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery(viewQuery);
        int rows = 0;
        while (rs.next()) {
            ++rows;
        }
        ImportExportTest.assertEquals((int)expectedRows, (int)rows);
        ImportExportTest.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testImport() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        System.setProperty("gemfirexd.debug.true", "QueryDistribution,TraceActivation,TraceClientHA,TraceSingleHop,TraceExecute,TraceNCJ,TraceImport");
        SanityManager.DEBUG_SET((String)"PrintRCList");
        Connection conn = ImportExportTest.getConnection();
        conn.setTransactionIsolation(0);
        try {
            ImportBase.TEST_IMPORT = true;
            String testDir = ImportExportTest.getResourcesDir();
            String createScript = testDir + "/lib/ImportData/schema.sql";
            GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{createScript}, (boolean)false, (Logger)ImportExportTest.getLogger(), null, null, (boolean)false);
            this.testImportHelper(conn, testDir + "/lib/ImportData/import1.sql", testDir, 103);
            this.testImportHelper(conn, testDir + "/lib/ImportData/import2.sql", testDir, 103);
            this.testImportHelper(conn, testDir + "/lib/ImportData/import3.sql", testDir, 103);
            this.testImportHelper(conn, testDir + "/lib/ImportData/import4.sql", testDir, 103);
            this.testImportHelper(conn, testDir + "/lib/ImportData/import5.sql", testDir, 103);
            String scriptDrop = testDir + "/lib/ImportData/schemaDrop.sql";
            GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{scriptDrop}, (boolean)false, (Logger)ImportExportTest.getLogger(), null, null, (boolean)false);
        }
        finally {
            ImportBase.TEST_IMPORT = false;
        }
    }
}

