/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.EntryOperationImpl;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdListPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GfxdResolverAPITest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(GfxdResolverAPITest.class));
    }

    public GfxdResolverAPITest(String name) {
        super(name);
    }

    public void testRangeResolver_1() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by range (sid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 10 AND 15, VALUES BETWEEN 20 AND 23, VALUES BETWEEN 25 AND 30, VALUES BETWEEN 31 AND 100)");
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)rpr);
        String[] sarr = rpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)rpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)rpr.getPartitioningColumnsCount());
        Integer robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)5, (int)robj);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)rpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)1, (int)robj);
    }

    public void testRangeResolver_2() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by range (sid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 10 AND 15, VALUES BETWEEN 20 AND 23, VALUES BETWEEN 25 AND 30, VALUES BETWEEN 31 AND 100)");
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)rpr);
        String[] sarr = rpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)rpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)rpr.getPartitioningColumnsCount());
        Integer robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)5, (int)robj);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)rpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)1, (int)robj);
    }

    public void testRangeResolver_3() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by range (sid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 10 AND 15, VALUES BETWEEN 20 AND 23, VALUES BETWEEN 25 AND 30, VALUES BETWEEN 31 AND 100)");
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)rpr);
        String[] sarr = rpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)rpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)rpr.getPartitioningColumnsCount());
        Integer robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)5, (int)robj);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)rpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)1, (int)robj);
    }

    public void testRangeResolver_4() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by range (sid) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 10 AND 15, VALUES BETWEEN 20 AND 23, VALUES BETWEEN 25 AND 30, VALUES BETWEEN 31 AND 100)");
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)rpr);
        String[] sarr = rpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)rpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)rpr.getPartitioningColumnsCount());
        Integer robj = (Integer)rpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)5, (int)robj);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)rpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)1, (int)robj);
    }

    public void testListResolver_1() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by list (sid) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31, 100))");
        GfxdListPartitionResolver lpr = (GfxdListPartitionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)lpr);
        String[] sarr = lpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)lpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)lpr.getPartitioningColumnsCount());
        Integer robj = (Integer)lpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)0, (int)robj);
        int maxWidth = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)4).getMaximumWidth();
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)lpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)new SQLInteger(1).computeHashCode(maxWidth, 0), (int)robj);
    }

    public void testListResolver_2() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by list (sid) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31, 100))");
        GfxdListPartitionResolver lpr = (GfxdListPartitionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)lpr);
        String[] sarr = lpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)lpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)lpr.getPartitioningColumnsCount());
        Integer robj = (Integer)lpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)0, (int)robj);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)lpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)1, (int)robj);
    }

    public void testListResolver_3() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by list (sid) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31, 100))");
        GfxdListPartitionResolver lpr = (GfxdListPartitionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)lpr);
        String[] sarr = lpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)lpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)lpr.getPartitioningColumnsCount());
        Integer robj = (Integer)lpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)0, (int)robj);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)lpr.getRoutingObjectFromDvdArray(values);
        int maxWidth = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)4).getMaximumWidth();
        GfxdResolverAPITest.assertEquals((int)new SQLInteger(1).computeHashCode(maxWidth, 0), (int)robj);
    }

    public void testListResolver_4() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by list (sid) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31, 100))");
        GfxdListPartitionResolver lpr = (GfxdListPartitionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)lpr);
        String[] sarr = lpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)lpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)lpr.getPartitioningColumnsCount());
        Integer robj = (Integer)lpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)0, (int)robj);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)lpr.getRoutingObjectFromDvdArray(values);
        int maxWidth = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)4).getMaximumWidth();
        GfxdResolverAPITest.assertEquals((int)new SQLInteger(1).computeHashCode(maxWidth, 0), (int)robj);
    }

    public void testColumnResolver_1() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by column (sid)");
        GfxdPartitionByExpressionResolver cpr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)cpr);
        String[] sarr = cpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)cpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)cpr.getPartitioningColumnsCount());
        SQLInteger dvd = new SQLInteger(5);
        Integer robj = (Integer)cpr.getRoutingKeyForColumn((DataValueDescriptor)dvd);
        int expectedHash = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)dvd, null, (int)0);
        GfxdResolverAPITest.assertEquals((int)expectedHash, (int)robj);
        dvd = new SQLInteger(1);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), dvd};
        robj = (Integer)cpr.getRoutingObjectFromDvdArray(values);
        expectedHash = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)dvd, null, (int)0);
        GfxdResolverAPITest.assertEquals((int)expectedHash, (int)robj);
    }

    public void testColumnResolver_2() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by column (cid, sid)");
        GfxdPartitionByExpressionResolver cpr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)cpr);
        String[] sarr = cpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)2, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)cpr.getPartitioningColumnIndex("CID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)cpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)2, (int)cpr.getPartitioningColumnsCount());
        SQLInteger cid = new SQLInteger(6);
        SQLInteger sid = new SQLInteger(1);
        DataValueDescriptor[] values = new DataValueDescriptor[]{cid, new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), sid};
        int hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)cid, null, (int)0);
        hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)sid, null, (int)hashcode);
        Integer robj = (Integer)cpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)hashcode, (int)robj);
    }

    public void testColumnResolver_3() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by column (cid, sid)");
        GfxdPartitionByExpressionResolver cpr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)cpr);
        String[] sarr = cpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)2, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)cpr.getPartitioningColumnIndex("CID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)cpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)2, (int)cpr.getPartitioningColumnsCount());
        SQLInteger cid = new SQLInteger(6);
        SQLInteger sid = new SQLInteger(1);
        DataValueDescriptor[] values = new DataValueDescriptor[]{cid, new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), sid};
        int hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)cid, null, (int)0);
        hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)sid, null, (int)hashcode);
        Integer robj = (Integer)cpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)hashcode, (int)robj);
    }

    public void testColumnResolver_4() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by column (cid, sid)");
        GfxdPartitionByExpressionResolver cpr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)cpr);
        String[] sarr = cpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)2, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)cpr.getPartitioningColumnIndex("CID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)cpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)2, (int)cpr.getPartitioningColumnsCount());
        SQLInteger cid = new SQLInteger(6);
        SQLInteger sid = new SQLInteger(1);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        int hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)cid, null, (int)0);
        hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)sid, null, (int)hashcode);
        Integer robj = (Integer)cpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)hashcode, (int)robj);
    }

    public void testColumnResolver_5() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by primary key");
        GfxdPartitionByExpressionResolver cpr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)cpr);
        String[] sarr = cpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)2, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)cpr.getPartitioningColumnIndex("CID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)cpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)2, (int)cpr.getPartitioningColumnsCount());
        SQLInteger cid = new SQLInteger(6);
        SQLInteger sid = new SQLInteger(1);
        DataValueDescriptor[] values = new DataValueDescriptor[]{cid, new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        int hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)cid, null, (int)0);
        hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)sid, null, (int)hashcode);
        Integer robj = (Integer)cpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)hashcode, (int)robj);
    }

    public void testColumnResolver_6() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))partition by primary key");
        GfxdPartitionByExpressionResolver cpr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)cpr);
        String[] sarr = cpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)1, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)cpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)cpr.getPartitioningColumnsCount());
        Integer robj = (Integer)cpr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(5));
        GfxdResolverAPITest.assertEquals((int)5, (int)robj);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        robj = (Integer)cpr.getRoutingObjectFromDvdArray(values);
        GfxdResolverAPITest.assertEquals((int)1, (int)robj);
    }

    public void _testDefaultResolver_1() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))");
        GfxdPartitionByExpressionResolver dpr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)dpr);
        GfxdResolverAPITest.assertTrue((boolean)dpr.isDefaultPartitioning());
        String[] sarr = dpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)2, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)dpr.getPartitioningColumnIndex("CID"));
        GfxdResolverAPITest.assertEquals((int)1, (int)dpr.getPartitioningColumnIndex("SID"));
        GfxdResolverAPITest.assertEquals((int)2, (int)dpr.getPartitioningColumnsCount());
        SQLInteger cid = new SQLInteger(5);
        SQLInteger sid = new SQLInteger(10);
        Integer robj = (Integer)dpr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(5), new SQLInteger(10)});
        int hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)cid, null, (int)0);
        hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)sid, null, (int)hashcode);
        GfxdResolverAPITest.assertEquals((int)hashcode, (int)robj);
        cid = new SQLInteger(6);
        sid = new SQLInteger(1);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), sid};
        robj = (Integer)dpr.getRoutingObjectFromDvdArray(values);
        hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)cid, null, (int)0);
        hashcode = GfxdPartitionByExpressionResolver.computeHashCode((DataValueDescriptor)sid, null, (int)hashcode);
        GfxdResolverAPITest.assertEquals((int)hashcode, (int)robj);
    }

    public void testDefaultResolver_2() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))");
        GfxdPartitionByExpressionResolver dpr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)dpr);
        GfxdResolverAPITest.assertTrue((boolean)dpr.isDefaultPartitioning());
        String[] sarr = dpr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)0, (int)sarr.length);
        GfxdResolverAPITest.assertEquals((int)0, (int)dpr.getPartitioningColumnsCount());
        Integer robj = (Integer)dpr.getRoutingObject((EntryOperation)new EntryOperationImpl(null, Operation.CREATE, (Object)5L, null, null));
        GfxdResolverAPITest.assertEquals((int)Long.valueOf(5L).hashCode(), (int)robj);
    }

    private boolean nameArrayContains(String[] arr, String candidate) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equalsIgnoreCase(candidate)) continue;
            return true;
        }
        return false;
    }

    private boolean idxArrayContains(int[] arr, int candidate) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != candidate) continue;
            return true;
        }
        return false;
    }

    public void testExpressionResolver_1() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid, sid)) Partition by (qty + cid * tid)");
        GfxdPartitionByExpressionResolver epr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)epr);
        String[] sarr = epr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)3, (int)sarr.length);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(71), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc == null) {
            EmbedConnection embedConn = GemFireXDUtils.getTSSConnection((boolean)true, (boolean)false, (boolean)false);
            embedConn.getTR().setupContextStack();
        }
        Integer robj = (Integer)epr.getRoutingObjectFromDvdArray(values);
        int expectedhashcode = 671;
        GfxdResolverAPITest.assertEquals((int)expectedhashcode, (int)robj);
        String[] cnames = epr.getColumnNames();
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "cid"));
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "qty"));
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "tid"));
        cnames = epr.getDistributionDescriptor().getPartitionColumnNames();
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "cid"));
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "qty"));
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "tid"));
        GfxdResolverAPITest.assertTrue((boolean)epr.getMasterTable(false).equalsIgnoreCase("/trade/portfolio"));
        GfxdResolverAPITest.assertTrue((boolean)epr.getName().equalsIgnoreCase("gfxd-expression-partition-resolver"));
        int[] expectedValues = new int[]{0, 1, 2};
        int idx = epr.getPartitioningColumnIndex("CID");
        GfxdResolverAPITest.assertTrue((boolean)this.idxArrayContains(expectedValues, idx));
        idx = epr.getPartitioningColumnIndex("TID");
        GfxdResolverAPITest.assertTrue((boolean)this.idxArrayContains(expectedValues, idx));
        idx = epr.getPartitioningColumnIndex("QTY");
        GfxdResolverAPITest.assertTrue((boolean)this.idxArrayContains(expectedValues, idx));
        GfxdResolverAPITest.assertEquals((int)3, (int)epr.getPartitioningColumnsCount());
        boolean gotException = false;
        try {
            epr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(1));
        }
        catch (AssertionError ae) {
            gotException = true;
        }
        GfxdResolverAPITest.assertTrue((boolean)gotException);
        gotException = false;
        try {
            epr.getRoutingObjectsForList(new DataValueDescriptor[]{new SQLInteger(1)});
        }
        catch (AssertionError ae) {
            gotException = true;
        }
        GfxdResolverAPITest.assertTrue((boolean)gotException);
        gotException = false;
        Integer i = (Integer)epr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(1), new SQLInteger(2), new SQLInteger(1)});
        GfxdResolverAPITest.assertEquals((int)3, (int)i);
        GfxdResolverAPITest.assertNull((Object)epr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(1), true, (DataValueDescriptor)new SQLInteger(1), true));
    }

    public void testExpressionResolver_2() throws SQLException, StandardException {
        int sretHashcode;
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null, id varchar(20) not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid)) Partition by (substr(id, 4))");
        GfxdPartitionByExpressionResolver epr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)epr);
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLVarchar("IBM_INDIA"), new SQLInteger(10), new SQLInteger(100), new SQLInteger(1)};
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc == null) {
            GemFireXDUtils.getTSSConnection((boolean)true, (boolean)false, (boolean)false);
        }
        Integer robj = (Integer)epr.getRoutingObjectFromDvdArray(values);
        SQLVarchar sret = new SQLVarchar("_INDIA");
        int expectedhashcode = sretHashcode = sret.hashCode();
        GfxdResolverAPITest.assertEquals((int)expectedhashcode, (int)robj);
    }

    public static int myAdd(int a) {
        return 2 * a;
    }

    public void testExpressionResolver_3() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create function f(raw int) returns int parameter style java no sql language java external name 'com.pivotal.gemfirexd.jdbc.GfxdResolverAPITest.myAdd'");
        s.execute("create table trade.portfolio (cid int not null, id varchar(20) not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid)) Partition by (f(cid))");
        GfxdPartitionByExpressionResolver epr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)epr);
        SQLInteger sret = new SQLInteger(12);
        final int expectedHashCode = sret.hashCode();
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

            public void afterGetRoutingObject(Object routingObject) {
                TestCase.assertEquals((int)expectedHashCode, (int)routingObject.hashCode());
            }
        });
        s.execute("insert into trade.portfolio values (6, 'IBM_INDIA', 10, 100, 1)");
        String[] sarr = epr.getColumnNames();
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(sarr, "cid"));
    }

    public void _testExpressionResolverDefault_1() throws SQLException, StandardException {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null,qty int not null, availQty int not null, tid int, sid int not null, constraint portf_pk primary key (cid, sid)) Partition by (cid * sid)");
        s.execute("create table trade.portfolio_FK (cidf int not null, sidf int not null, qty int not null, constraint cust_newt_fk foreign key (cidf, sidf) references trade.portfolio (cid, sid))");
        GfxdPartitionByExpressionResolver epr = (GfxdPartitionByExpressionResolver)Misc.getGemFireCache().getRegion("/TRADE/PORTFOLIO_FK").getAttributes().getPartitionAttributes().getPartitionResolver();
        GfxdResolverAPITest.assertNotNull((Object)epr);
        String[] sarr = epr.getColumnNames();
        GfxdResolverAPITest.assertEquals((int)2, (int)sarr.length);
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(sarr, "cidf"));
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(sarr, "sidf"));
        DataValueDescriptor[] values = new DataValueDescriptor[]{new SQLInteger(6), new SQLInteger(70), new SQLInteger(10)};
        LanguageConnectionContext lcc = Misc.getLanguageConnectionContext();
        if (lcc == null) {
            GemFireXDUtils.getTSSConnection((boolean)true, (boolean)false, (boolean)false);
        }
        Integer robj = (Integer)epr.getRoutingObjectFromDvdArray(values);
        int expectedhashcode = 420;
        GfxdResolverAPITest.assertEquals((int)expectedhashcode, (int)robj);
        String[] cnames = epr.getColumnNames();
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "cidf"));
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "sidf"));
        cnames = epr.getDistributionDescriptor().getPartitionColumnNames();
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "cidf"));
        GfxdResolverAPITest.assertTrue((boolean)this.nameArrayContains(cnames, "sidf"));
        GfxdResolverAPITest.assertTrue((boolean)epr.getMasterTable(false).equalsIgnoreCase("/trade/portfolio"));
        GfxdResolverAPITest.assertTrue((boolean)epr.getName().equalsIgnoreCase("gfxd-expression-partition-resolver"));
        int[] expectedValues = new int[]{0, 1};
        int idx = epr.getPartitioningColumnIndex("CIDF");
        GfxdResolverAPITest.assertTrue((boolean)this.idxArrayContains(expectedValues, idx));
        idx = epr.getPartitioningColumnIndex("SIDF");
        GfxdResolverAPITest.assertTrue((boolean)this.idxArrayContains(expectedValues, idx));
        GfxdResolverAPITest.assertEquals((int)2, (int)epr.getPartitioningColumnsCount());
        boolean gotException = false;
        try {
            epr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(1));
        }
        catch (AssertionError e) {
            gotException = true;
        }
        GfxdResolverAPITest.assertTrue((boolean)gotException);
        gotException = false;
        try {
            epr.getRoutingObjectsForList(new DataValueDescriptor[]{new SQLInteger(1)});
        }
        catch (AssertionError e) {
            gotException = true;
        }
        GfxdResolverAPITest.assertTrue((boolean)gotException);
        gotException = false;
        Integer i = (Integer)epr.getRoutingObjectsForPartitioningColumns(new DataValueDescriptor[]{new SQLInteger(1), new SQLInteger(2)});
        GfxdResolverAPITest.assertEquals((int)2, (int)i);
        GfxdResolverAPITest.assertNull((Object)epr.getRoutingObjectsForRange((DataValueDescriptor)new SQLInteger(1), true, (DataValueDescriptor)new SQLInteger(1), true));
    }

    public void testExpression_bug41002() throws Exception {
        Statement stmt;
        Connection conn;
        block5: {
            block4: {
                conn = GfxdResolverAPITest.getConnection();
                stmt = conn.createStatement();
                stmt.execute("CREATE TABLE COFFEES (COF_NAME VARCHAR(32) CONSTRAINT COF_PK PRIMARY KEY, SUP_ID INTEGER, PRICE FLOAT, SALES INTEGER, TOTAL INTEGER) PARTITION BY (COF_NAME)");
                try {
                    stmt.execute("CREATE TABLE SUPPLIERS (SUP_ID INTEGER CONSTRAINT SUP_PK PRIMARY KEY, SUP_NAME VARCHAR(40), STREET VARCHAR(40), CITY VARCHAR(20), STATE VARCHAR(2), ZIP CHAR(5)) PARTITION BY SUP_ID COLOCATE WITH (COFFEES)");
                }
                catch (SQLException ex) {
                    if ("42X01".equals(ex.getSQLState())) break block4;
                    throw ex;
                }
            }
            stmt.execute("CREATE TABLE SUPPLIERS (SUP_ID INTEGER CONSTRAINT SUP_PK PRIMARY KEY, SUP_NAME VARCHAR(40), STREET VARCHAR(40), CITY VARCHAR(20), STATE VARCHAR(2), ZIP CHAR(5)) PARTITION BY (SUP_ID) COLOCATE WITH (COFFEES)");
            stmt.execute("INSERT INTO COFFEES VALUES('French Roast', 49, 8.99, 0, 0)");
            stmt.execute("INSERT INTO SUPPLIERS VALUES(49, 'Nestle', 'Street1', 'City1', 'OR', '40000')");
            GfxdResolverAPITest.sqlExecuteVerifyText("SELECT * FROM COFFEES", GfxdResolverAPITest.getResourcesDir() + "/lib/checkQuery.xml", "bug41002_coffees", true, false);
            GfxdResolverAPITest.sqlExecuteVerifyText("SELECT * FROM SUPPLIERS", GfxdResolverAPITest.getResourcesDir() + "/lib/checkQuery.xml", "bug41002_suppliers", false, false);
            GfxdResolverAPITest.addExpectedException(UnsupportedOperationException.class);
            try {
                stmt.execute("drop table COFFEES");
            }
            catch (SQLException ex) {
                if ("X0Y98".equals(ex.getSQLState())) break block5;
                throw ex;
            }
        }
        GfxdResolverAPITest.removeExpectedException(UnsupportedOperationException.class);
        stmt.execute("drop table SUPPLIERS");
        stmt.execute("drop table COFFEES");
        conn.close();
    }

    private void createHashFunction(Connection conn) throws SQLException {
        String stmt = "CREATE FUNCTION myhash(value INTEGER) RETURNS INTEGER PARAMETER STYLE java LANGUAGE java NO SQL EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.GfxdResolverAPITest.myhash'";
        Statement s = conn.createStatement();
        s.execute(stmt);
        s.close();
    }

    public static int myhash(int value) throws SQLException {
        int i = Integer.valueOf(value).hashCode();
        return i;
    }

    public void testExprResolver_2() throws Exception {
        String parentsql = "create table t.customer (    c_w_id         integer        not null,    c_d_id         integer        not null,    c_id           integer        not null,    c_discount     decimal(4,4),    c_credit       char(2),    c_last         varchar(16),    c_first        varchar(16),    c_credit_lim   decimal(12,2),    c_balance      decimal(12,2),    c_ytd_payment  float,    c_payment_cnt  integer,    c_delivery_cnt integer,    c_street_1     varchar(20),    c_street_2     varchar(20),    c_city         varchar(20),    c_state        char(2),    c_zip          char(9),    c_phone        char(16),    c_since        timestamp,    c_middle       char(2),    c_data         varchar(500)  ) partition by (c_w_id)";
        String childsql = "create table t.stock (s_w_id integer not null, s_i_id   integer       not null,    s_quantity   decimal(4,0),    s_ytd        decimal(8,2),    s_order_cnt  integer,    s_remote_cnt integer,    s_data       varchar(50),    s_dist_01    char(24),    s_dist_02    char(24),    s_dist_03    char(24),    s_dist_04    char(24),    s_dist_05    char(24),    s_dist_06    char(24),    s_dist_07    char(24),    s_dist_08    char(24),    s_dist_09    char(24),    s_dist_10    char(24)  ) partition by (myhash(s_w_id)) colocate with (t.customer)";
        Connection conn = TestUtil.getConnection();
        this.createHashFunction(conn);
        Statement stmt = conn.createStatement();
        stmt.execute("create schema t");
        stmt.execute(parentsql);
        stmt.execute("alter table t.customer add constraint pk_customer primary key (c_w_id, c_d_id, c_id)");
        try {
            stmt.execute(childsql);
            GfxdResolverAPITest.fail("child create table should not succeed");
        }
        catch (SQLException sqle) {
            GfxdResolverAPITest.assertTrue((boolean)"X0Y95".equals(sqle.getSQLState()));
        }
    }

    public void testExprResolver() throws Exception {
        String parentsql = "create table t.customer (    c_w_id         integer        not null,    c_d_id         integer        not null,    c_id           integer        not null,    c_discount     decimal(4,4),    c_credit       char(2),    c_last         varchar(16),    c_first        varchar(16),    c_credit_lim   decimal(12,2),    c_balance      decimal(12,2),    c_ytd_payment  float,    c_payment_cnt  integer,    c_delivery_cnt integer,    c_street_1     varchar(20),    c_street_2     varchar(20),    c_city         varchar(20),    c_state        char(2),    c_zip          char(9),    c_phone        char(16),    c_since        timestamp,    c_middle       char(2),    c_data         varchar(500)  ) partition by (myhash(c_w_id))";
        Connection conn = TestUtil.getConnection();
        this.createHashFunction(conn);
        Statement stmt = conn.createStatement();
        stmt.execute("create schema t");
        stmt.execute(parentsql);
        stmt.execute("alter table t.customer add constraint pk_customer primary key (c_w_id, c_d_id, c_id)");
        stmt.execute("insert into t.customer values(1, 1, 1, 0.0, 'hi', 'man', 'kumar', 0.0, 0.0, 1.0, 1, 1, 'st1', 'st2', 'pune', 'ma', '909090909', '1234567891011111', null, 'hi', null)");
    }

    public void testBug43150() throws Exception {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))  partition by list (tid) (VALUES (14, 1, 2, 10, 4, 5), VALUES (6, 7, 16, 9, 3, 11), VALUES (12, 13, 0, 15, 8, 17))  ");
        s.execute("create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id))");
        s.execute("create table portfolio (cid int not null, sid int not null, qty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid), constraint sec_fk foreign key (sid) references securities (sec_id))");
        PartitionedRegion pr1 = (PartitionedRegion)Misc.getRegion((String)"/APP/PORTFOLIO", (boolean)true, (boolean)false);
        GfxdPartitionResolver rslvr1 = (GfxdPartitionResolver)pr1.getPartitionResolver();
        PartitionedRegion pr2 = (PartitionedRegion)Misc.getRegion((String)"/APP/SECURITIES", (boolean)true, (boolean)false);
        pr2.getPartitionResolver();
        PartitionedRegion pr3 = (PartitionedRegion)Misc.getRegion((String)"/APP/CUSTOMERS", (boolean)true, (boolean)false);
        pr3.getPartitionResolver();
        s.executeUpdate("insert into securities values(163,'1','1',1)");
        s.executeUpdate("insert into customers values(2,'2',1)");
        s.executeUpdate("insert into portfolio values(2,163,1,1)");
        GfxdResolverAPITest.assertEquals((int)1, (int)rslvr1.getPartitioningColumnsCount());
        Iterator itr = pr1.keys().iterator();
        Object key = itr.next();
        Object val = pr1.get(key);
        Integer rtObj = (Integer)rslvr1.getRoutingObject(key, val, (Region)pr1);
        int maxWidth = DataTypeDescriptor.getBuiltInDataTypeDescriptor((int)4).getMaximumWidth();
        GfxdResolverAPITest.assertEquals((int)new SQLInteger(163).computeHashCode(maxWidth, 0), (int)rtObj);
    }

    public void testBug43688_1() throws Exception {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))  partition by list (tid) (VALUES (14, 1, 2, 10, 4, 5), VALUES (6, 7, 16, 9, 3, 11), VALUES (12, 13, 0, 15, 8, 17))  ");
        s.execute("create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) ) partition by list (sec_id) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31, 163))");
        s.execute("create table portfolio (cid int not null, sid int not null, qty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid), constraint sec_fk foreign key (sid) references securities (sec_id))");
        PartitionedRegion pr1 = (PartitionedRegion)Misc.getRegion((String)"/APP/PORTFOLIO", (boolean)true, (boolean)false);
        GfxdPartitionResolver rslvr1 = (GfxdPartitionResolver)pr1.getPartitionResolver();
        PartitionedRegion pr2 = (PartitionedRegion)Misc.getRegion((String)"/APP/SECURITIES", (boolean)true, (boolean)false);
        pr2.getPartitionResolver();
        PartitionedRegion pr3 = (PartitionedRegion)Misc.getRegion((String)"/APP/CUSTOMERS", (boolean)true, (boolean)false);
        pr3.getPartitionResolver();
        s.executeUpdate("insert into securities values(163,'1','1',1)");
        s.executeUpdate("insert into customers values(2,'2',1)");
        s.executeUpdate("insert into portfolio values(2,163,1,1)");
        GfxdResolverAPITest.assertEquals((int)1, (int)rslvr1.getPartitioningColumnsCount());
        Iterator itr = pr1.keys().iterator();
        Object key = itr.next();
        Object val = pr1.get(key);
        Integer rtObj = (Integer)rslvr1.getRoutingObject(key, val, (Region)pr1);
        GfxdResolverAPITest.assertEquals((int)4, (int)rtObj);
    }

    public void testBug43688_2() throws Exception {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))  partition by list (tid) (VALUES (14, 1, 2, 10, 4, 5), VALUES (6, 7, 16, 9, 3, 11), VALUES (12, 13, 0, 15, 8, 17))  ");
        s.execute("create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) ) partition by list (sec_id) ( VALUES (0, 5) , VALUES (10, 15), VALUES (20, 23), VALUES(25, 30), VALUES(31))");
        s.execute("create table portfolio (cid int not null, sid int not null, qty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid), constraint sec_fk foreign key (sid) references securities (sec_id))");
        PartitionedRegion pr1 = (PartitionedRegion)Misc.getRegion((String)"/APP/PORTFOLIO", (boolean)true, (boolean)false);
        GfxdPartitionResolver rslvr1 = (GfxdPartitionResolver)pr1.getPartitionResolver();
        PartitionedRegion pr2 = (PartitionedRegion)Misc.getRegion((String)"/APP/SECURITIES", (boolean)true, (boolean)false);
        GfxdPartitionResolver rslvr2 = (GfxdPartitionResolver)pr2.getPartitionResolver();
        PartitionedRegion pr3 = (PartitionedRegion)Misc.getRegion((String)"/APP/CUSTOMERS", (boolean)true, (boolean)false);
        pr3.getPartitionResolver();
        s.executeUpdate("insert into securities values(163,'1','1',1)");
        s.executeUpdate("insert into customers values(2,'2',1)");
        s.executeUpdate("insert into portfolio values(2,163,1,1)");
        GfxdResolverAPITest.assertEquals((int)1, (int)rslvr1.getPartitioningColumnsCount());
        Iterator itr1 = pr1.keys().iterator();
        Object key1 = itr1.next();
        Object val1 = pr1.get(key1);
        Integer rtObj1 = (Integer)rslvr1.getRoutingObject(key1, val1, (Region)pr1);
        GfxdResolverAPITest.assertEquals((int)1, (int)rslvr2.getPartitioningColumnsCount());
        Iterator itr2 = pr2.keys().iterator();
        Object key2 = itr2.next();
        Object val2 = pr2.get(key2);
        Integer rtObj2 = (Integer)rslvr2.getRoutingObject(key2, val2, (Region)pr2);
        GfxdResolverAPITest.assertEquals((int)rtObj2, (int)rtObj1);
    }

    public void testBug43688_3() throws Exception {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))  partition by list (tid) (VALUES (14, 1, 2, 10, 4, 5), VALUES (6, 7, 16, 9, 3, 11), VALUES (12, 13, 0, 15, 8, 17))  ");
        s.execute("create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) )partition by range (sec_id) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 10 AND 15, VALUES BETWEEN 20 AND 23, VALUES BETWEEN 25 AND 30, VALUES BETWEEN 31 AND 200)");
        s.execute("create table portfolio (cid int not null, sid int not null, qty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid), constraint sec_fk foreign key (sid) references securities (sec_id))");
        PartitionedRegion pr1 = (PartitionedRegion)Misc.getRegion((String)"/APP/PORTFOLIO", (boolean)true, (boolean)false);
        GfxdPartitionResolver rslvr1 = (GfxdPartitionResolver)pr1.getPartitionResolver();
        PartitionedRegion pr2 = (PartitionedRegion)Misc.getRegion((String)"/APP/SECURITIES", (boolean)true, (boolean)false);
        pr2.getPartitionResolver();
        PartitionedRegion pr3 = (PartitionedRegion)Misc.getRegion((String)"/APP/CUSTOMERS", (boolean)true, (boolean)false);
        pr3.getPartitionResolver();
        s.executeUpdate("insert into securities values(163,'1','1',1)");
        s.executeUpdate("insert into customers values(2,'2',1)");
        s.executeUpdate("insert into portfolio values(2,163,1,1)");
        GfxdResolverAPITest.assertEquals((int)1, (int)rslvr1.getPartitioningColumnsCount());
        Iterator itr = pr1.keys().iterator();
        Object key = itr.next();
        Object val = pr1.get(key);
        Integer rtObj = (Integer)rslvr1.getRoutingObject(key, val, (Region)pr1);
        GfxdResolverAPITest.assertEquals((int)5, (int)rtObj);
    }

    public void testBug43688_4() throws Exception {
        Connection conn = GfxdResolverAPITest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table customers (cid int not null, cust_name varchar(100),  tid int, primary key (cid))  partition by list (tid) (VALUES (14, 1, 2, 10, 4, 5), VALUES (6, 7, 16, 9, 3, 11), VALUES (12, 13, 0, 15, 8, 17))  ");
        s.execute("create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id) ) partition by range (sec_id) ( VALUES BETWEEN 0 AND 5, VALUES BETWEEN 10 AND 15, VALUES BETWEEN 20 AND 23, VALUES BETWEEN 25 AND 30, VALUES BETWEEN 31 AND 160)");
        s.execute("create table portfolio (cid int not null, sid int not null, qty int not null,tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references customers (cid), constraint sec_fk foreign key (sid) references securities (sec_id))");
        PartitionedRegion pr1 = (PartitionedRegion)Misc.getRegion((String)"/APP/PORTFOLIO", (boolean)true, (boolean)false);
        GfxdPartitionResolver rslvr1 = (GfxdPartitionResolver)pr1.getPartitionResolver();
        PartitionedRegion pr2 = (PartitionedRegion)Misc.getRegion((String)"/APP/SECURITIES", (boolean)true, (boolean)false);
        GfxdPartitionResolver rslvr2 = (GfxdPartitionResolver)pr2.getPartitionResolver();
        PartitionedRegion pr3 = (PartitionedRegion)Misc.getRegion((String)"/APP/CUSTOMERS", (boolean)true, (boolean)false);
        pr3.getPartitionResolver();
        s.executeUpdate("insert into securities values(163,'1','1',1)");
        s.executeUpdate("insert into customers values(2,'2',1)");
        s.executeUpdate("insert into portfolio values(2,163,1,1)");
        GfxdResolverAPITest.assertEquals((int)1, (int)rslvr1.getPartitioningColumnsCount());
        Iterator itr1 = pr1.keys().iterator();
        Object key1 = itr1.next();
        Object val1 = pr1.get(key1);
        Integer rtObj1 = (Integer)rslvr1.getRoutingObject(key1, val1, (Region)pr1);
        Iterator itr2 = pr2.keys().iterator();
        Object key2 = itr2.next();
        Object val2 = pr2.get(key2);
        Integer rtObj2 = (Integer)rslvr2.getRoutingObject(key2, val2, (Region)pr2);
        GfxdResolverAPITest.assertEquals((int)rtObj2, (int)rtObj1);
    }
}

