/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.SocketCreator;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.client.am.Cursor;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.tools.internal.JarTools;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;

public class GfxdJarInstallationTest
extends JdbcTestBase {
    private final String myjar = GfxdJarInstallationTest.getResourcesDir() + "/lib/myjar.jar";
    private final String myfalsejar = GfxdJarInstallationTest.getResourcesDir() + "/lib/myfalsejar.jar";
    private final String booksJar = GfxdJarInstallationTest.getResourcesDir() + "/lib/Books.jar";
    public static final String pricejar = GfxdJarInstallationTest.getResourcesDir() + "/lib/myPrice.jar";

    public GfxdJarInstallationTest(String name) {
        super(name);
    }

    public static byte[] getJarBytes(String jar) throws Exception {
        int len;
        FileInputStream fis = new FileInputStream(jar);
        byte[] data = new byte[4096];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = fis.read(data)) != -1) {
            bos.write(data, 0, len);
        }
        return bos.toByteArray();
    }

    public void testResultProcessorFromInstalledJar() throws Exception {
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        GfxdJarInstallationTest.setupConnection(props1);
        Connection conn = TestUtil.getConnection(props1);
        Statement s = conn.createStatement();
        s.execute("CREATE TABLE APP.BOOKS(ID VARCHAR(10) NOT NULL, NAME VARCHAR(25), TAG VARCHAR(25), SIZE BIGINT, LOCATION VARCHAR(25), CONSTRAINT BOOK_PK PRIMARY KEY (ID)) PARTITION BY PRIMARY KEY REDUNDANCY 1 EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW PERSISTENT ASYNCHRONOUS");
        s.execute("insert into APP.BOOKS values ('1', 'Spring1','TAG1',20,'Mumbai')");
        s.execute("insert into APP.BOOKS values ('2', 'Spring2','TAG2',10,'Pune')");
        s.execute("insert into APP.BOOKS values ('3', 'Spring3','TAG3',15,'Bangalore')");
        s.execute("insert into APP.BOOKS values ('4', 'Spring4','TAG4',20,'Chennai')");
        s.execute("insert into APP.BOOKS values ('5', 'Spring5','TAG5',10,'calcutta')");
        s.execute("insert into APP.BOOKS values ('6', 'Spring6','TAG6',15,'Bhubaneswar')");
        s.execute("insert into APP.BOOKS values ('7', 'Spring7','TAG7',20,'Delhi')");
        s.execute("insert into APP.BOOKS values ('8', 'Spring8','TAG8',10,'Cuttack')");
        s.execute("insert into APP.BOOKS values ('9', 'Spring9','TAG9',15,'Balangir')");
        s.execute("insert into APP.BOOKS values ('10', 'Spring10','TAG10',20,'Baleswar')");
        s.execute("insert into APP.BOOKS values ('11', 'Spring11','TAG11',10,'Phulbani')");
        s.execute("insert into APP.BOOKS values ('12', 'Spring12','TAG12',15,'Purushoottampur')");
        s.execute("insert into APP.BOOKS values ('13', 'Spring13','TAG13',20,'Puri')");
        s.execute("insert into APP.BOOKS values ('14', 'Spring14','TAG14',10,'Pipili')");
        s.execute("insert into APP.BOOKS values ('15', 'Spring15','TAG15',15,'Keondujhar')");
        s.execute("insert into APP.BOOKS values ('16', 'Spring16','TAG16',20,'Sundargarh')");
        s.execute("insert into APP.BOOKS values ('17', 'Spring17','TAG17',10,'Baripada')");
        s.execute("insert into APP.BOOKS values ('18', 'Spring18','TAG18',15,'Paradip')");
        s.execute("insert into APP.BOOKS values ('19', 'Spring19','TAG19',20,'Parlakhemundi')");
        s.execute("insert into APP.BOOKS values ('20', 'Spring20','TAG20',10,'Gunpur')");
        s.execute("insert into APP.BOOKS values ('21', 'Spring21','TAG21',15,'Aska')");
        s.execute("CALL SQLJ.INSTALL_JAR('" + this.booksJar + "', 'APP.GFXD_LISTBOOKSP', 0);");
        s.execute("CREATE PROCEDURE LIST_BOOKS(IN ID VARCHAR(100) ) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'com.pivotal.vfabric.booksdb.storedproc.ListBooksStoreProc.execute'");
        CallableStatement stmt = conn.prepareCall("{CALL LIST_BOOKS(?)}");
        stmt.setString(1, "10");
        stmt.execute();
        stmt = conn.prepareCall("{CALL LIST_BOOKS(?) WITH RESULT PROCESSOR com.pivotal.vfabric.booksdb.storedproc.ListBookResultProcessor}");
        stmt.setString(1, "10");
        stmt.execute();
        ResultSet rs = stmt.getResultSet();
        int count = 0;
        while (rs.next()) {
            System.out.println("rs.getString(ID) " + rs.getString(1));
            ++count;
        }
        GfxdJarInstallationTest.assertEquals((int)1, (int)count);
        Properties props = new Properties();
        Connection connClient = GfxdJarInstallationTest.startNetserverAndGetLocalNetConnection(props);
        CallableStatement stmt_client = connClient.prepareCall("{CALL LIST_BOOKS(?)}");
        stmt_client.setString(1, "10");
        stmt_client.execute();
        stmt_client.setString(1, "10");
        stmt_client.execute();
    }

    public void testJarInstallThroughVTI() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        String sql = "call SQLJ.INSTALL_JAR_BYTES(?, ?)";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setBinaryStream(1, new FileInputStream(this.myjar));
        ps.setString(2, "app.sample1");
        ps.executeUpdate();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)";
        stmt.execute(ddl);
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3')");
        stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4')");
        stmt.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
        stmt.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
        sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE WHERE 1=1";
        CallableStatement cs = conn.prepareCall(sql);
        cs.execute();
        ResultSet rs = cs.getResultSet();
        while (rs.next()) {
            System.out.println(rs.getObject(1));
        }
    }

    public void testBasicJarInstallationFromNetClient() throws Exception {
        GfxdJarInstallationTest.setupConnection();
        int netPort = GfxdJarInstallationTest.startNetserverAndReturnPort();
        Connection conn = GfxdJarInstallationTest.getNetConnection(netPort, null, null);
        this.runJarTest(conn, netPort);
    }

    private void runPrepTest(Connection conn) throws Exception {
        Statement stmt = conn.createStatement();
        String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)";
        stmt.execute(ddl);
        stmt.execute("insert into EMP.PARTITIONTESTTABLE values (1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three')");
        PreparedStatement ps = conn.prepareStatement("select * from EMP.PARTITIONTESTTABLE where id = ?");
        ps.setInt(1, 1);
        ps.execute();
        ResultSet rs = ps.getResultSet();
        while (rs.next()) {
            System.out.println(rs.getObject(1) + ", " + rs.getObject(2) + ", " + rs.getObject(3));
        }
    }

    public void testBasicJarInstallRemove() throws Exception {
        Connection conn = TestUtil.getConnection();
        this.runJarTest(conn, -1);
    }

    private void runJarTest(Connection conn, int netPort) throws Exception {
        String localHostName;
        CallableStatement cs;
        block11: {
            block10: {
                Statement stmt;
                block9: {
                    stmt = conn.createStatement();
                    String ddl = "create table EMP.PARTITIONTESTTABLE (ID int NOT NULL, SECONDID int not null, THIRDID varchar(10) not null, PRIMARY KEY (SECONDID, THIRDID)) PARTITION BY COLUMN (ID)";
                    stmt.execute(ddl);
                    stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '3')");
                    stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (3, 3, '3')");
                    stmt.execute("INSERT INTO EMP.PARTITIONTESTTABLE VALUES (2, 2, '4')");
                    stmt.execute("call sqlj.install_jar('" + this.myjar + "', 'app.sample2', 0)");
                    stmt.execute("CREATE PROCEDURE MergeSort () LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'myexamples.MergeSortProcedure.mergeSort' ");
                    stmt.execute("CREATE ALIAS MergeSortProcessor FOR 'myexamples.MergeSortProcessor'");
                    String sql = "CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE WHERE 1=1";
                    cs = conn.prepareCall("CALL MergeSort() WITH RESULT PROCESSOR MergeSortProcessor ON TABLE EMP.PARTITIONTESTTABLE WHERE 1=1");
                    cs.execute();
                    this.checkMergeResults(cs);
                    stmt.execute("call sqlj.remove_jar('app.sample2', 0)");
                    try {
                        cs.execute();
                        cs.getResultSet();
                        GfxdJarInstallationTest.fail("expected exception");
                    }
                    catch (SQLException ex) {
                        if ("42X51".equals(ex.getSQLState())) break block9;
                        throw ex;
                    }
                }
                stmt.execute("call sqlj.install_jar('" + this.myfalsejar + "', 'app.sample2', 0)");
                try {
                    cs.execute();
                    cs.getResultSet();
                    GfxdJarInstallationTest.fail("fail fail");
                }
                catch (SQLException ex) {
                    GfxdJarInstallationTest.assertEquals((String)"42X51", (String)ex.getSQLState());
                }
                stmt.execute("call sqlj.replace_jar('" + this.myjar + "', 'app.sample2')");
                cs.execute();
                this.checkMergeResults(cs);
                localHostName = SocketCreator.getLocalHost().getHostName();
                if (netPort <= 0) {
                    netPort = GfxdJarInstallationTest.startNetserverAndReturnPort();
                }
                JarTools.main((String[])new String[]{"remove-jar", "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
                try {
                    cs.execute();
                    cs.getResultSet();
                    GfxdJarInstallationTest.fail("expected failure with no jar");
                }
                catch (SQLException sqle) {
                    if ("42X51".equals(sqle.getSQLState())) break block10;
                    throw sqle;
                }
            }
            JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myjar, "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
            cs.execute();
            this.checkMergeResults(cs);
            JarTools.main((String[])new String[]{"remove-jar", "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
            JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myfalsejar, "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
            try {
                cs.execute();
                cs.getResultSet();
                GfxdJarInstallationTest.fail("expected failure with incorrect jar");
            }
            catch (SQLException sqle) {
                if ("42X51".equals(sqle.getSQLState())) break block11;
                throw sqle;
            }
        }
        JarTools.main((String[])new String[]{"replace-jar", "-file=" + this.myjar, "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
        cs.execute();
        this.checkMergeResults(cs);
    }

    private void checkMergeResults(CallableStatement cs) throws SQLException {
        ResultSet rs = cs.getResultSet();
        GfxdJarInstallationTest.assertTrue((boolean)rs.next());
        GfxdJarInstallationTest.assertEquals((int)2, (int)rs.getInt(1));
        GfxdJarInstallationTest.assertEquals((int)2, (int)rs.getInt(2));
        GfxdJarInstallationTest.assertTrue((boolean)rs.next());
        GfxdJarInstallationTest.assertEquals((int)2, (int)rs.getInt(1));
        GfxdJarInstallationTest.assertEquals((int)2, (int)rs.getInt(2));
        GfxdJarInstallationTest.assertTrue((boolean)rs.next());
        GfxdJarInstallationTest.assertEquals((int)3, (int)rs.getInt(1));
        GfxdJarInstallationTest.assertEquals((int)3, (int)rs.getInt(2));
        GfxdJarInstallationTest.assertFalse((boolean)rs.next());
    }

    public void testUDTINJarFromPeerClient() throws Exception {
        Connection conn = TestUtil.getConnection();
        GfxdJarInstallationTest.udtTypeTest(conn, false, false, true, true, false);
        GfxdJarInstallationTest.udtTypeTest(conn, true, false, true, true, false);
    }

    public void testUDTINJarFromNetClient() throws Exception {
        GfxdJarInstallationTest.setupConnection();
        Connection conn = GfxdJarInstallationTest.startNetserverAndGetLocalNetConnection();
        GfxdJarInstallationTest.udtTypeTest(conn, true, false, true, true, false);
        GfxdJarInstallationTest.udtTypeTest(conn, false, false, true, true, false);
    }

    public static void udtTypeTest(Connection conn, boolean vti, boolean expectClassLoadEx, boolean createDBObjects, boolean dropDBObjects, boolean persistent) throws Exception {
        ClassLoader origCL;
        Statement stmt;
        block56: {
            Object p;
            int id;
            int numResults;
            ResultSet rs;
            PreparedStatement ps;
            block55: {
                int id2;
                stmt = conn.createStatement();
                if (createDBObjects) {
                    if (!vti) {
                        stmt.execute("call sqlj.install_jar('" + pricejar + "','APP.udtjar', 0)");
                    } else {
                        byte[] jarBytes = GfxdJarInstallationTest.getJarBytes(pricejar);
                        String sql = "call sqlj.install_jar_bytes(?, ?)";
                        ps = conn.prepareStatement(sql);
                        ps.setBytes(1, jarBytes);
                        ps.setString(2, "APP.udtjar");
                        ps.executeUpdate();
                    }
                    GfxdJarInstallationTest.createUDTDBObjects(stmt, persistent);
                    ps = conn.prepareStatement("insert into orders values (?, ?, makePrice('INR', ?, timestamp('2009-10-16 14:24:43')))");
                    for (int id3 = 1; id3 <= 10; ++id3) {
                        ps.setInt(1, id3);
                        ps.setInt(2, id3 + 10);
                        ps.setBigDecimal(3, new BigDecimal(Integer.toString(id3) + ".90000"));
                        ps.execute();
                    }
                }
                rs = stmt.executeQuery("select orderID, customerID, getCurrencyCode(totalPrice), getAmount(totalPrice) from orders order by orderID");
                numResults = 0;
                while (rs.next()) {
                    id2 = ++numResults;
                    GfxdJarInstallationTest.assertEquals((int)id2, (int)rs.getInt(1));
                    GfxdJarInstallationTest.assertEquals((int)(id2 + 10), (int)rs.getInt(2));
                    GfxdJarInstallationTest.assertEquals((String)"INR", (String)rs.getString(3));
                    GfxdJarInstallationTest.assertEquals((Object)new BigDecimal(Integer.toString(id2) + ".90000"), (Object)rs.getBigDecimal(4));
                }
                GfxdJarInstallationTest.assertEquals((int)10, (int)numResults);
                ps = conn.prepareStatement("update orders set customerID = ? where orderID = ?");
                for (id2 = 5; id2 <= 10; ++id2) {
                    ps.setInt(1, id2 + 20);
                    ps.setInt(2, id2);
                    GfxdJarInstallationTest.assertEquals((int)1, (int)ps.executeUpdate());
                }
                rs = stmt.executeQuery("select orderID, customerID, getCurrencyCode(totalPrice), getAmount(totalPrice) from orders order by orderID");
                numResults = 0;
                while (rs.next()) {
                    id2 = ++numResults;
                    GfxdJarInstallationTest.assertEquals((int)id2, (int)rs.getInt(1));
                    if (id2 < 5) {
                        GfxdJarInstallationTest.assertEquals((int)(id2 + 10), (int)rs.getInt(2));
                    } else {
                        GfxdJarInstallationTest.assertEquals((int)(id2 + 20), (int)rs.getInt(2));
                    }
                    GfxdJarInstallationTest.assertEquals((String)"INR", (String)rs.getString(3));
                    GfxdJarInstallationTest.assertEquals((Object)new BigDecimal(Integer.toString(id2) + ".90000"), (Object)rs.getBigDecimal(4));
                }
                GfxdJarInstallationTest.assertEquals((int)10, (int)numResults);
                ps = conn.prepareStatement("update orders set totalPrice = makePrice('INR', ?, timestamp('2010-10-16 14:24:43')) where orderID = ?");
                for (id2 = 1; id2 <= 5; ++id2) {
                    ps.setBigDecimal(1, new BigDecimal(Integer.toString(id2 * 2) + ".88000"));
                    ps.setInt(2, id2);
                    GfxdJarInstallationTest.assertEquals((int)1, (int)ps.executeUpdate());
                }
                rs = stmt.executeQuery("select orderID, customerID, getCurrencyCode(totalPrice), getAmount(totalPrice) from orders order by orderID");
                numResults = 0;
                while (rs.next()) {
                    id2 = ++numResults;
                    GfxdJarInstallationTest.assertEquals((int)id2, (int)rs.getInt(1));
                    if (id2 < 5) {
                        GfxdJarInstallationTest.assertEquals((int)(id2 + 10), (int)rs.getInt(2));
                    } else {
                        GfxdJarInstallationTest.assertEquals((int)(id2 + 20), (int)rs.getInt(2));
                    }
                    GfxdJarInstallationTest.assertEquals((String)"INR", (String)rs.getString(3));
                    if (id2 <= 5) {
                        GfxdJarInstallationTest.assertEquals((Object)new BigDecimal(Integer.toString(id2 * 2) + ".88000"), (Object)rs.getBigDecimal(4));
                        continue;
                    }
                    GfxdJarInstallationTest.assertEquals((Object)new BigDecimal(Integer.toString(id2) + ".90000"), (Object)rs.getBigDecimal(4));
                }
                GfxdJarInstallationTest.assertEquals((int)10, (int)numResults);
                ps = conn.prepareStatement("delete from orders where orderID = ?");
                ps.setInt(1, 4);
                GfxdJarInstallationTest.assertEquals((int)1, (int)ps.executeUpdate());
                rs = stmt.executeQuery("select orderID, customerID, getCurrencyCode(totalPrice), getAmount(totalPrice) from orders order by orderID");
                numResults = 0;
                while (rs.next()) {
                    if (++numResults == 4) {
                        // empty if block
                    }
                    id2 = ++numResults;
                    GfxdJarInstallationTest.assertEquals((int)id2, (int)rs.getInt(1));
                    if (id2 < 5) {
                        GfxdJarInstallationTest.assertEquals((int)(id2 + 10), (int)rs.getInt(2));
                    } else {
                        GfxdJarInstallationTest.assertEquals((int)(id2 + 20), (int)rs.getInt(2));
                    }
                    GfxdJarInstallationTest.assertEquals((String)"INR", (String)rs.getString(3));
                    if (id2 <= 5) {
                        GfxdJarInstallationTest.assertEquals((Object)new BigDecimal(Integer.toString(id2 * 2) + ".88000"), (Object)rs.getBigDecimal(4));
                        continue;
                    }
                    GfxdJarInstallationTest.assertEquals((Object)new BigDecimal(Integer.toString(id2) + ".90000"), (Object)rs.getBigDecimal(4));
                }
                GfxdJarInstallationTest.assertEquals((int)10, (int)numResults);
                if (!dropDBObjects) {
                    stmt.execute("delete from orders");
                    ps = conn.prepareStatement("insert into orders values (?, ?, makePrice('INR', ?, timestamp('2009-10-16 14:24:43')))");
                    for (id2 = 1; id2 <= 10; ++id2) {
                        ps.setInt(1, id2);
                        ps.setInt(2, id2 + 10);
                        ps.setBigDecimal(3, new BigDecimal(Integer.toString(id2) + ".90000"));
                        ps.execute();
                    }
                }
                if (expectClassLoadEx) {
                    Cursor.ALLOW_THREADCONTEXT_CLASSLOADER.set(Boolean.TRUE);
                    System.gc();
                    System.runFinalization();
                }
                rs = stmt.executeQuery("select * from orders where orderID = 1");
                GfxdJarInstallationTest.assertTrue((boolean)rs.next());
                try {
                    GfxdJarInstallationTest.getLogger().info((Object)String.valueOf(rs.getObject(3)));
                    if (expectClassLoadEx) {
                        System.gc();
                        System.runFinalization();
                        Thread.sleep(3000L);
                        System.gc();
                        System.runFinalization();
                        Thread.sleep(3000L);
                        GfxdJarInstallationTest.getLogger().info((Object)String.valueOf(rs.getObject(3)));
                        GfxdJarInstallationTest.fail("expected class load exception");
                    }
                }
                catch (SQLException sqle) {
                    Throwable t = sqle;
                    while (t.getCause() != null) {
                        t = t.getCause();
                    }
                    GfxdJarInstallationTest.assertTrue((String)("unexpected exception " + t), (boolean)(t instanceof ClassNotFoundException));
                    GfxdJarInstallationTest.assertTrue((String)("unexpected exception " + t), (boolean)t.getMessage().contains("udtexamples.Price"));
                }
                GfxdJarInstallationTest.assertFalse((boolean)rs.next());
                try {
                    stmt.execute("drop type Price restrict");
                    GfxdJarInstallationTest.fail("expect exception in type removal due to dependent table");
                }
                catch (SQLException sqle) {
                    if ("X0Y30".equals(sqle.getSQLState())) break block55;
                    throw sqle;
                }
            }
            if (dropDBObjects) {
                GfxdJarInstallationTest.dropUDTDBObjects(stmt);
                stmt.execute("call sqlj.remove_jar('APP.udtjar', 0)");
            }
            if (!expectClassLoadEx) {
                return;
            }
            if (createDBObjects) {
                if (!vti) {
                    stmt.execute("call sqlj.install_jar('" + pricejar + "','APP.udtjar', 0)");
                } else {
                    String sql = "call sqlj.install_jar_bytes(?, ?)";
                    CallableStatement cs = conn.prepareCall(sql);
                    cs.setBinaryStream(1, (InputStream)new FileInputStream(pricejar));
                    cs.setString(2, "APP.udtjar");
                    cs.executeUpdate();
                }
                GfxdJarInstallationTest.createUDTDBObjects(stmt, persistent);
            }
            origCL = Thread.currentThread().getContextClassLoader();
            URLClassLoader cl = new URLClassLoader(new URL[]{new URL(pricejar.charAt(0) == '/' ? "file:" + pricejar : "file:/" + pricejar)}, origCL);
            Thread.currentThread().setContextClassLoader(cl);
            Class<?> priceClazz = cl.loadClass("udtexamples.Price");
            if (createDBObjects) {
                ps = conn.prepareStatement("insert into orders values (?, ?, ?)");
                for (id = 1; id <= 10; ++id) {
                    ps.setInt(1, id);
                    ps.setInt(2, id + 10);
                    p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id) + ".90000"), Timestamp.valueOf("2009-10-16 14:24:43"));
                    ps.setObject(3, p);
                    ps.execute();
                }
            }
            rs = stmt.executeQuery("select * from orders order by orderID");
            numResults = 0;
            while (rs.next()) {
                id = ++numResults;
                GfxdJarInstallationTest.assertEquals((int)id, (int)rs.getInt(1));
                GfxdJarInstallationTest.assertEquals((int)(id + 10), (int)rs.getInt(2));
                p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id) + ".90000"), Timestamp.valueOf("2009-10-16 14:24:43"));
                GfxdJarInstallationTest.assertEquals((Object)p, (Object)rs.getObject(3));
            }
            GfxdJarInstallationTest.assertEquals((int)10, (int)numResults);
            ps = conn.prepareStatement("update orders set customerID = ? where orderID = ?");
            for (id = 5; id <= 10; ++id) {
                ps.setInt(1, id + 20);
                ps.setInt(2, id);
                GfxdJarInstallationTest.assertEquals((int)1, (int)ps.executeUpdate());
            }
            rs = stmt.executeQuery("select * from orders order by orderID");
            numResults = 0;
            while (rs.next()) {
                id = ++numResults;
                GfxdJarInstallationTest.assertEquals((int)id, (int)rs.getInt(1));
                if (id < 5) {
                    GfxdJarInstallationTest.assertEquals((int)(id + 10), (int)rs.getInt(2));
                } else {
                    GfxdJarInstallationTest.assertEquals((int)(id + 20), (int)rs.getInt(2));
                }
                p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id) + ".90000"), Timestamp.valueOf("2009-10-16 14:24:43"));
                GfxdJarInstallationTest.assertEquals((Object)p, (Object)rs.getObject(3));
            }
            GfxdJarInstallationTest.assertEquals((int)10, (int)numResults);
            ps = conn.prepareStatement("update orders set totalPrice = ? where orderID = ?");
            for (id = 1; id <= 5; ++id) {
                p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id * 2) + ".88000"), Timestamp.valueOf("2010-10-16 14:24:43"));
                ps.setObject(1, p);
                ps.setInt(2, id);
                GfxdJarInstallationTest.assertEquals((int)1, (int)ps.executeUpdate());
            }
            rs = stmt.executeQuery("select * from orders order by orderID");
            numResults = 0;
            while (rs.next()) {
                id = ++numResults;
                GfxdJarInstallationTest.assertEquals((int)id, (int)rs.getInt(1));
                if (id < 5) {
                    GfxdJarInstallationTest.assertEquals((int)(id + 10), (int)rs.getInt(2));
                } else {
                    GfxdJarInstallationTest.assertEquals((int)(id + 20), (int)rs.getInt(2));
                }
                if (id <= 5) {
                    p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id * 2) + ".88000"), Timestamp.valueOf("2010-10-16 14:24:43"));
                    GfxdJarInstallationTest.assertEquals((Object)p, (Object)rs.getObject(3));
                    continue;
                }
                p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id) + ".90000"), Timestamp.valueOf("2009-10-16 14:24:43"));
                GfxdJarInstallationTest.assertEquals((Object)p, (Object)rs.getObject(3));
            }
            GfxdJarInstallationTest.assertEquals((int)10, (int)numResults);
            ps = conn.prepareStatement("delete from orders where orderID = ?");
            ps.setInt(1, 4);
            GfxdJarInstallationTest.assertEquals((int)1, (int)ps.executeUpdate());
            rs = stmt.executeQuery("select * from orders order by orderID");
            numResults = 0;
            while (rs.next()) {
                if (++numResults == 4) {
                    // empty if block
                }
                id = ++numResults;
                GfxdJarInstallationTest.assertEquals((int)id, (int)rs.getInt(1));
                if (id < 5) {
                    GfxdJarInstallationTest.assertEquals((int)(id + 10), (int)rs.getInt(2));
                } else {
                    GfxdJarInstallationTest.assertEquals((int)(id + 20), (int)rs.getInt(2));
                }
                if (id <= 5) {
                    p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id * 2) + ".88000"), Timestamp.valueOf("2010-10-16 14:24:43"));
                    GfxdJarInstallationTest.assertEquals((Object)p, (Object)rs.getObject(3));
                    continue;
                }
                p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id) + ".90000"), Timestamp.valueOf("2009-10-16 14:24:43"));
                GfxdJarInstallationTest.assertEquals((Object)p, (Object)rs.getObject(3));
            }
            GfxdJarInstallationTest.assertEquals((int)10, (int)numResults);
            if (!dropDBObjects) {
                stmt.execute("delete from orders");
                ps = conn.prepareStatement("insert into orders values (?, ?, ?)");
                for (id = 1; id <= 10; ++id) {
                    ps.setInt(1, id);
                    ps.setInt(2, id + 10);
                    p = priceClazz.getMethod("makePrice", String.class, BigDecimal.class, Timestamp.class).invoke(null, "INR", new BigDecimal(Integer.toString(id) + ".90000"), Timestamp.valueOf("2009-10-16 14:24:43"));
                    ps.setObject(3, p);
                    ps.execute();
                }
            }
            try {
                stmt.execute("drop type Price restrict");
                GfxdJarInstallationTest.fail("expect exception in type removal due to dependent table");
            }
            catch (SQLException sqle) {
                if ("X0Y30".equals(sqle.getSQLState())) break block56;
                throw sqle;
            }
        }
        Thread.currentThread().setContextClassLoader(origCL);
        if (dropDBObjects) {
            GfxdJarInstallationTest.dropUDTDBObjects(stmt);
            stmt.execute("call sqlj.remove_jar('APP.udtjar', 0)");
        }
    }

    public static void createUDTDBObjects(Statement stmt, boolean persistent) throws SQLException {
        stmt.execute("create type Price external name 'udtexamples.Price' language java");
        stmt.execute("create table orders( orderID int, customerID int, totalPrice price)" + (persistent ? " PERSISTENT" : ""));
        stmt.execute("create function makePrice( currencyCode char( 3 ), amount decimal( 31, 5 ), timeInstant Timestamp ) returns Price language java parameter style java no sql external name 'udtexamples.Price.makePrice'");
        stmt.execute("create function getCurrencyCode( price Price ) returns char( 3 ) language java parameter style java no sql external name 'udtexamples.Price.getCurrencyCode'");
        stmt.execute("create function getAmount( price Price ) returns decimal( 31, 5 ) language java parameter style java no sql external name 'udtexamples.Price.getAmount'");
        stmt.execute("create function getTimeInstant( price Price ) returns timestamp language java parameter style java no sql external name 'udtexamples.Price.getTimeInstant'");
        stmt.execute("create procedure savePrice( in a Price ) language java parameter style java no sql external name 'udtexamples.Price.savePrice'");
        stmt.execute("create function getSavedPrice() returns Price language java parameter style java no sql external name 'udtexamples.Price.getSavedPrice'");
    }

    public static void dropUDTDBObjects(Statement stmt) throws SQLException {
        stmt.execute("drop table orders");
        stmt.execute("drop function makePrice");
        stmt.execute("drop function getCurrencyCode");
        stmt.execute("drop function getAmount");
        stmt.execute("drop function getTimeInstant");
        stmt.execute("drop procedure savePrice");
        stmt.execute("drop function getSavedPrice");
        stmt.execute("drop type Price restrict");
    }

    public void testBug50285() throws SQLException, UnknownHostException {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create type Person external name 'com.pivotal.gemfirexd.jdbc.Person' language java");
        st.execute("CREATE FUNCTION create_person(VARCHAR(32)) RETURNS Person   LANGUAGE JAVA  PARAMETER STYLE JAVA  NO SQL  EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.CreatePerson.newInstance'");
        st.execute("CREATE FUNCTION update_person(Person, VARCHAR(32)) RETURNS Person   LANGUAGE JAVA  PARAMETER STYLE JAVA  NO SQL  EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.CreatePerson.updateInstance'");
        st.execute("CREATE TABLE exampleTable ( DUMMY_ID INT NOT NULL, REAL_ID INT NOT NULL, Person Person, PRIMARY KEY( DUMMY_ID ) ) PARTITION BY COLUMN (DUMMY_ID)");
        st.execute("insert into exampleTable values (1, 1, create_person('one'))");
        st.execute("insert into exampleTable values (2, 2, create_person('two'))");
        conn = TestUtil.getConnection(props);
        String query = "update exampleTable set Person = update_person(Person, ?) where DUMMY_ID = ?";
        PreparedStatement st2 = conn.prepareStatement(query);
        st2.setString(1, "four");
        st2.setInt(2, 2);
        int r = st2.executeUpdate();
        GfxdJarInstallationTest.assertEquals((int)1, (int)r);
        conn = TestUtil.getConnection(props);
        query = "update exampleTable set REAL_ID = ?, Person = update_person(Person, ?) where DUMMY_ID = ?";
        System.out.println(query);
        st2 = conn.prepareStatement(query);
        st2.setInt(1, 3);
        st2.setString(2, "three");
        st2.setInt(3, 1);
        r = st2.executeUpdate();
        GfxdJarInstallationTest.assertEquals((int)1, (int)r);
        conn = TestUtil.getConnection(props);
        query = "Select REAL_ID, person, DUMMY_ID from exampleTable where DUMMY_ID = ?";
        st2 = conn.prepareStatement(query);
        st2.setInt(1, 2);
        ResultSet r2 = st2.executeQuery();
        int count = 0;
        while (r2.next()) {
            GfxdJarInstallationTest.assertEquals((String)"four", (String)r2.getObject(2).toString().toLowerCase());
            ++count;
        }
        GfxdJarInstallationTest.assertEquals((int)1, (int)count);
        r2.close();
        conn = TestUtil.getConnection(props);
        query = "Select REAL_ID, person, DUMMY_ID from exampleTable where DUMMY_ID = ?";
        st2 = conn.prepareStatement(query);
        st2.setInt(1, 1);
        r2 = st2.executeQuery();
        count = 0;
        while (r2.next()) {
            GfxdJarInstallationTest.assertEquals((String)"three", (String)r2.getObject(2).toString().toLowerCase());
            ++count;
        }
        GfxdJarInstallationTest.assertEquals((int)1, (int)count);
        r2.close();
    }
}

