/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.diag.SortedCSVProcedures;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class GfxdDiagsTest
extends JdbcTestBase {
    public GfxdDiagsTest(String name) {
        super(name);
    }

    public void testSingleMember() throws Exception {
        GfxdDiagsTest.setupConnection();
        Statement stmt = GfxdDiagsTest.getStatement();
        ResultSet rs = stmt.executeQuery("select * from SYS.MEMBERS");
        this.checkSingleMemberResult(rs);
        PreparedStatement pstmt = GfxdDiagsTest.getPreparedStatement("select * from SYS.MEMBERS");
        rs = pstmt.executeQuery();
        this.checkSingleMemberResult(rs);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "loner_member", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "loner_member", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where ID = DSID()", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_member", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where KIND <> 'admin'", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_member", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where HOSTDATA IS NOT NULL", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_member", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select distinct KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and HOSTDATA IS NOT NULL ", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "loner_member", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select distinct KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and ID = DSID()", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_member", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select distinct KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and KIND <> 'admin'", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_member", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select distinct KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and KIND <> 'admin' and HOSTDATA IS NULL", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", false, false);
    }

    public void testSingleMemberWithServerGroups() throws Exception {
        Properties props = new Properties();
        props.setProperty("server-groups", " SG1,sg2, Sg3");
        props.setProperty("gemfire.roles", "role1, role2");
        GfxdDiagsTest.setupConnection(props);
        Statement stmt = GfxdDiagsTest.getStatement();
        ResultSet rs = stmt.executeQuery("select * from SYS.MEMBERS");
        this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3");
        PreparedStatement pstmt = GfxdDiagsTest.getPreparedStatement("select * from SYS.MEMBERS");
        rs = pstmt.executeQuery();
        this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3");
        GfxdDiagsTest.sqlExecute("CREATE TABLE TESTTAB (ID int not null primary key, NAME varchar(64)) SERVER GROUPS (SG1, SG3,sg2)", true);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where SERVERGROUPS = GROUPS()", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where KIND <> 'admin'", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where HOSTDATA IS NOT NULL", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and HOSTDATA IS NOT NULL", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and t.SERVERGROUPS = GROUPS()", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and m.KIND <> 'admin'", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and HOSTDATA IS NOT NULL and t.TABLENAME not like 'TEST%'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", false, false);
    }

    public void sb__testSingleMemberWithServerGroupsUpdate() throws Exception {
        Statement updStmt;
        PreparedStatement updPstmt;
        PreparedStatement pstmt;
        ResultSet rs;
        block8: {
            block7: {
                Statement stmt;
                block6: {
                    Properties props = new Properties();
                    props.setProperty("server-groups", " SG1,sg2, Sg3");
                    props.setProperty("gemfire.roles", "role2, role1");
                    GfxdDiagsTest.setupConnection(props);
                    stmt = GfxdDiagsTest.getStatement();
                    rs = stmt.executeQuery("select * from SYS.MEMBERS");
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3");
                    pstmt = GfxdDiagsTest.getPreparedStatement("select * from SYS.MEMBERS");
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3");
                    updPstmt = TestUtil.jdbcConn.prepareStatement("select * from SYS.MEMBERS", 1003, 1008);
                    updStmt = TestUtil.jdbcConn.createStatement(1003, 1008);
                    rs = updStmt.executeQuery("select * from SYS.MEMBERS");
                    GfxdDiagsTest.assertTrue((boolean)rs.next());
                    rs.updateString("SERVERGROUPS", "sg1, Sg3");
                    rs.updateRow();
                    GfxdDiagsTest.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG3");
                    rs = stmt.executeQuery("select * from SYS.MEMBERS where GROUPS() = 'SG1,SG3'");
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG3");
                    rs = updPstmt.executeQuery();
                    GfxdDiagsTest.assertTrue((boolean)rs.next());
                    rs.updateObject("SERVERGROUPS", (Object)"Sg2, SG1 ");
                    rs.updateRow();
                    GfxdDiagsTest.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2");
                    rs = stmt.executeQuery("select * from SYS.MEMBERS where GROUPS() = 'SG1,SG2'");
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2");
                    rs = updStmt.executeQuery("select * from SYS.MEMBERS");
                    GfxdDiagsTest.assertTrue((boolean)rs.next());
                    rs.updateBoolean("HOSTDATA", false);
                    rs.updateRow();
                    GfxdDiagsTest.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2", false);
                    rs = updPstmt.executeQuery();
                    GfxdDiagsTest.assertTrue((boolean)rs.next());
                    rs.updateObject("HOSTDATA", (Object)Boolean.TRUE);
                    rs.updateRow();
                    GfxdDiagsTest.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2", true);
                    rs = updStmt.executeQuery("select KIND, HOSTDATA, SERVERGROUPS, ID from SYS.MEMBERS");
                    GfxdDiagsTest.assertTrue((boolean)rs.next());
                    rs.updateString("SERVERGROUPS", "sg2, Sg3");
                    rs.updateRow();
                    GfxdDiagsTest.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG2,SG3");
                    rs = stmt.executeQuery("select * from SYS.MEMBERS where GROUPS() = 'SG2,SG3'");
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG2,SG3");
                    rs = updStmt.executeQuery("select KIND, HOSTDATA, SERVERGROUPS, ID from SYS.MEMBERS");
                    GfxdDiagsTest.assertTrue((boolean)rs.next());
                    rs.updateString("HOSTDATA", "false");
                    rs.updateRow();
                    GfxdDiagsTest.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG2,SG3", false);
                    rs = updStmt.executeQuery("select HOSTDATA, SERVERGROUPS, ID from SYS.MEMBERS");
                    GfxdDiagsTest.assertTrue((boolean)rs.next());
                    rs.updateObject("HOSTDATA", (Object)Boolean.TRUE);
                    rs.updateRow();
                    GfxdDiagsTest.assertFalse((boolean)rs.next());
                    rs = pstmt.executeQuery();
                    this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG2,SG3", true);
                    try {
                        stmt.execute("update SYS.MEMBERS set SERVERGROUPS='sg2, SG1 '");
                        GfxdDiagsTest.fail("expected update statement to fail");
                    }
                    catch (SQLException ex) {
                        if ("42Y25".equals(ex.getSQLState())) break block6;
                        throw ex;
                    }
                }
                rs = updStmt.executeQuery("select SERVERGROUPS, ID from SYS.MEMBERS");
                GfxdDiagsTest.assertTrue((boolean)rs.next());
                rs.updateString("SERVERGROUPS", "tsg2, tSg4");
                rs.updateRow();
                GfxdDiagsTest.assertFalse((boolean)rs.next());
                rs = pstmt.executeQuery();
                this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "TSG2,TSG4");
                rs = stmt.executeQuery("select * from SYS.MEMBERS where GROUPS() = 'TSG2,TSG4'");
                this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "TSG2,TSG4");
                rs = updStmt.executeQuery("select ROLES, ID from SYS.MEMBERS");
                GfxdDiagsTest.assertTrue((boolean)rs.next());
                try {
                    rs.updateObject("ID", (Object)"newId");
                    rs.updateRow();
                    GfxdDiagsTest.fail("expected an exception in updating a read-only column");
                }
                catch (SQLException ex) {
                    if ("42X31".equals(ex.getSQLState())) break block7;
                    throw ex;
                }
            }
            rs = updStmt.executeQuery("select ROLES, ID from SYS.MEMBERS");
            GfxdDiagsTest.assertTrue((boolean)rs.next());
            try {
                rs.updateObject("ROLES", (Object)"newrole");
                rs.updateRow();
                GfxdDiagsTest.fail("expected an exception in updating a read-only column");
            }
            catch (SQLException ex) {
                if ("42X31".equals(ex.getSQLState())) break block8;
                throw ex;
            }
        }
        GfxdDiagsTest.sqlExecute("CREATE TABLE TESTTAB (ID int not null primary key, NAME varchar(64)) SERVER GROUPS (SG1, SG3,sg2)", true);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and t.TABLENAME = 'TESTTAB'", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "empty", true, false);
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        PartitionAttributes pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        GfxdDiagsTest.verifyRegionProperties(null, "TESTTAB", GfxdDiagsTest.regionAttributesToXML(expectedAttrs));
        rs = updPstmt.executeQuery();
        GfxdDiagsTest.assertTrue((boolean)rs.next());
        rs.updateString("SERVERGROUPS", "  sg2, Sg3 , SG1 ");
        rs.updateRow();
        GfxdDiagsTest.assertFalse((boolean)rs.next());
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, SERVERGROUPS, ISELDER, ROLES from SYS.MEMBERS where SERVERGROUPS = GROUPS()", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where KIND <> 'admin'", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", true, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, SERVERGROUPS, ISELDER from SYS.MEMBERS where HOSTDATA IS NOT NULL", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and HOSTDATA IS NOT NULL", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and m.KIND <> 'admin'", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and m.SERVERGROUPS = GROUPS()", GfxdDiagsTest.getResourcesDir() + "/lib/checkDiags.xml", "loner_sgs", false, false);
        GfxdDiagsTest.sqlExecuteVerifyText("select KIND, HOSTDATA, ROLES, m.SERVERGROUPS, ISELDER from SYS.MEMBERS m, SYS.SYSTABLES t where t.SERVERGROUPS = m.SERVERGROUPS and HOSTDATA IS NOT NULL and t.TABLENAME not like 'TEST%'", TestUtil.getResourcesDir() + "/lib/checkDiags.xml", "empty", false, false);
        rs = updPstmt.executeQuery();
        GfxdDiagsTest.assertTrue((boolean)rs.next());
        rs.updateBoolean("HOSTDATA", false);
        rs.updateRow();
        GfxdDiagsTest.assertFalse((boolean)rs.next());
        rs = pstmt.executeQuery();
        this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3", false);
        GfxdDiagsTest.sqlExecute("CREATE TABLE TESTTAB1 (ID int not null primary key, NAME varchar(64)) SERVER GROUPS (SG1, SG3,sg2)", true);
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).setLocalMaxMemory(0).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        GfxdDiagsTest.verifyRegionProperties(null, "TESTTAB1", GfxdDiagsTest.regionAttributesToXML(expectedAttrs));
        rs = updStmt.executeQuery("select KIND, HOSTDATA, ID from SYS.MEMBERS");
        GfxdDiagsTest.assertTrue((boolean)rs.next());
        rs.updateObject("HOSTDATA", (Object)Boolean.TRUE);
        rs.updateRow();
        GfxdDiagsTest.assertFalse((boolean)rs.next());
        rs = pstmt.executeQuery();
        this.checkSingleMemberResultForServerGroups(rs, "role1,role2", "SG1,SG2,SG3", true);
        GfxdDiagsTest.sqlExecute("CREATE TABLE TESTTAB2 (ID int not null primary key, NAME varchar(64)) SERVER GROUPS (SG1, SG3,sg2)", true);
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        GfxdDiagsTest.verifyRegionProperties(null, "TESTTAB2", GfxdDiagsTest.regionAttributesToXML(expectedAttrs));
    }

    public void testSortedCSVProcedures() throws SQLException {
        String csv1 = "SG1,SG2,SG4";
        String csv2 = "SG2,SG3,SG5";
        this.checkIntersections(csv1, csv2, "SG2");
        this.checkUnions(csv1, csv2, "SG1,SG2,SG3,SG4,SG5");
        csv1 = "SG1,SG3,SG4";
        csv2 = "SG1,SG2,SG4";
        this.checkIntersections(csv1, csv2, "SG1,SG4");
        this.checkUnions(csv1, csv2, "SG1,SG2,SG3,SG4");
        csv1 = "G1,G3,G4";
        csv2 = "S1,S2,S4";
        this.checkIntersections(csv1, csv2, "");
        this.checkUnions(csv1, csv2, "G1,G3,G4,S1,S2,S4");
        csv1 = "SG11,SG2,SG4";
        csv2 = "SG1,SG2,SG44";
        this.checkIntersections(csv1, csv2, "SG2");
        this.checkUnions(csv1, csv2, "SG1,SG11,SG2,SG4,SG44");
        csv1 = "SG11,SG2,SG4";
        csv2 = "SG1,SG22,SG44";
        this.checkIntersections(csv1, csv2, "");
        this.checkUnions(csv1, csv2, "SG1,SG11,SG2,SG22,SG4,SG44");
        csv1 = "SG2,SG3";
        csv2 = "";
        this.checkIntersections(csv1, csv2, "");
        this.checkUnions(csv1, csv2, "SG2,SG3");
        csv1 = "";
        csv2 = "SG1";
        this.checkIntersections(csv1, csv2, "");
        this.checkUnions(csv1, csv2, "SG1");
        csv1 = "";
        csv2 = "";
        this.checkIntersections(csv1, csv2, "");
        this.checkUnions(csv1, csv2, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGroupsBuiltins() throws Exception {
        Properties props = new Properties();
        props.setProperty("server-groups", " SG1,sg2, Sg3");
        props.setProperty("gemfire.roles", "gemfirexd.unknown, role1, role2");
        DistributionDescriptor.TEST_BYPASS_DATASTORE_CHECK = true;
        try {
            GfxdDiagsTest.setupConnection(props);
            GfxdDiagsTest.sqlExecute("create table test1 (id int primary key, addr varchar(20)) server groups (SG4, Sg2)", false);
            GfxdDiagsTest.sqlExecuteVerifyText("select m.servergroups from sys.systables t, SYS.MEMBERS m where t.tablename='TEST1' and groupsintersect(t.servergroups, m.servergroups)", null, "SG1,SG2,SG3", true, false);
            GfxdDiagsTest.sqlExecute("create table test2 (id int primary key, addr varchar(20)) server groups (SG4, Sg)", true);
            GfxdDiagsTest.sqlExecuteVerifyText("select m.servergroups from sys.systables t, SYS.MEMBERS m where t.tablename='TEST2' and groupsintersect(t.servergroups, m.servergroups)", null, null, false, false);
        }
        finally {
            DistributionDescriptor.TEST_BYPASS_DATASTORE_CHECK = false;
        }
    }

    private void checkIntersections(String csv1, String csv2, String expected) {
        GfxdDiagsTest.assertEquals((String)expected, (String)SortedCSVProcedures.intersection((String)csv1, (String)csv2));
        GfxdDiagsTest.assertEquals((String)expected, (String)SortedCSVProcedures.groupsIntersection((String)csv1, (String)csv2));
        if (expected.length() > 0) {
            GfxdDiagsTest.assertTrue((boolean)SortedCSVProcedures.intersect((String)csv1, (String)csv2));
        } else {
            GfxdDiagsTest.assertFalse((boolean)SortedCSVProcedures.intersect((String)csv1, (String)csv2));
        }
        if (expected.length() > 0 || csv1.length() == 0 && csv2.length() == 0) {
            GfxdDiagsTest.assertTrue((boolean)SortedCSVProcedures.groupsIntersect((String)csv1, (String)csv2));
        } else {
            GfxdDiagsTest.assertFalse((boolean)SortedCSVProcedures.groupsIntersect((String)csv1, (String)csv2));
        }
    }

    private void checkUnions(String csv1, String csv2, String expected) {
        String groupExpected = expected;
        if (csv1.length() == 0 || csv2.length() == 0) {
            groupExpected = "";
        }
        GfxdDiagsTest.assertEquals((String)expected, (String)SortedCSVProcedures.union((String)csv1, (String)csv2));
        GfxdDiagsTest.assertEquals((String)groupExpected, (String)SortedCSVProcedures.groupsUnion((String)csv1, (String)csv2));
    }

    private void checkSingleMemberResult(ResultSet rs) throws SQLException {
        this.checkSingleMemberResultForServerGroups(rs, "", "");
    }

    private void checkSingleMemberResultForServerGroups(ResultSet rs, String roles, String sgs) throws SQLException {
        this.checkSingleMemberResultForServerGroups(rs, roles, sgs, true);
    }

    private void checkSingleMemberResultForServerGroups(ResultSet rs, String roles, String sgs, boolean isServer) throws SQLException {
        block10: {
            block9: {
                block8: {
                    String fmt;
                    GfxdDiagsTest.assertTrue((boolean)rs.next());
                    GfxdDiagsTest.assertTrue((boolean)rs.getBoolean("ISELDER"));
                    GfxdDiagsTest.assertEquals((Object)Boolean.TRUE, (Object)rs.getObject("ISELDER"));
                    Object mcastPort = InternalDistributedSystem.getConnectedInstance().getProperties().get("mcast-port");
                    String string = fmt = isServer ? "datastore(%s)" : "accessor(%s)";
                    if (mcastPort == null || "0".equals(mcastPort)) {
                        GfxdDiagsTest.assertEquals((String)String.format(fmt, "loner"), (String)rs.getString("KIND"));
                        GfxdDiagsTest.assertEquals((Object)String.format(fmt, "loner"), (Object)rs.getObject("KIND"));
                    } else {
                        GfxdDiagsTest.assertEquals((String)String.format(fmt, "normal"), (String)rs.getString("KIND"));
                        GfxdDiagsTest.assertEquals((Object)String.format(fmt, "normal"), (Object)rs.getObject("KIND"));
                    }
                    GfxdDiagsTest.assertEquals((boolean)isServer, (boolean)rs.getBoolean("HOSTDATA"));
                    GfxdDiagsTest.assertEquals((Object)isServer, (Object)rs.getObject("HOSTDATA"));
                    GfxdDiagsTest.assertEquals((String)String.valueOf(isServer), (String)rs.getString("HOSTDATA"));
                    GfxdDiagsTest.assertEquals((String)roles, (String)rs.getString("ROLES"));
                    GfxdDiagsTest.assertEquals((Object)roles, (Object)rs.getObject("ROLES"));
                    GfxdDiagsTest.assertEquals((String)sgs, (String)rs.getString("SERVERGROUPS"));
                    GfxdDiagsTest.assertEquals((Object)sgs, (Object)rs.getObject("SERVERGROUPS"));
                    GfxdDiagsTest.getLogger().info((Object)("Got ID as " + rs.getString("ID")));
                    GfxdDiagsTest.getLogger().info((Object)("Got ID as " + rs.getObject("ID")));
                    GfxdDiagsTest.getLogger().info((Object)("Got IPADDRESS as " + rs.getString("IPADDRESS")));
                    GfxdDiagsTest.getLogger().info((Object)("Got IPADDRESS as " + rs.getObject("IPADDRESS")));
                    GfxdDiagsTest.getLogger().info((Object)("Got HOST as " + rs.getString("HOST")));
                    GfxdDiagsTest.getLogger().info((Object)("Got HOST as " + rs.getObject("HOST")));
                    GfxdDiagsTest.getLogger().info((Object)("Got PID as " + rs.getObject("PID")));
                    GfxdDiagsTest.getLogger().info((Object)("Got PID as " + rs.getInt("PID")));
                    GfxdDiagsTest.getLogger().info((Object)("Got PORT as " + rs.getObject("PORT")));
                    GfxdDiagsTest.getLogger().info((Object)("Got PORT as " + rs.getInt("PORT")));
                    try {
                        rs.getObject("VMID");
                        GfxdDiagsTest.fail("expected unknown column get to fail");
                    }
                    catch (SQLException ex) {
                        if ("S0022".equals(ex.getSQLState())) break block8;
                        throw ex;
                    }
                }
                try {
                    rs.getTime("PID");
                    GfxdDiagsTest.fail("expected type conversion error");
                }
                catch (SQLException ex) {
                    if ("22005".equals(ex.getSQLState())) break block9;
                    throw ex;
                }
            }
            try {
                rs.getDate("PORT");
                GfxdDiagsTest.fail("expected type conversion error");
            }
            catch (SQLException ex) {
                if ("22005".equals(ex.getSQLState())) break block10;
                throw ex;
            }
        }
        GfxdDiagsTest.assertFalse((boolean)rs.next());
    }
}

