/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class GfxdCallbacksTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(GfxdCallbacksTest.class));
    }

    public GfxdCallbacksTest(String name) {
        super(name);
    }

    public static void addListener(String listenerID, String schemaName, String tableName, String functionStr, String initInfoStr, String serverGroups) throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        CallableStatement cs = conn.prepareCall("CALL SYS.ADD_LISTENER(?,?,?,?,?,?)");
        cs.setString(1, listenerID);
        cs.setString(2, schemaName);
        cs.setString(3, tableName);
        cs.setString(4, functionStr);
        cs.setString(5, initInfoStr);
        cs.setString(6, serverGroups);
        cs.execute();
    }

    public static void addWriter(String schemaName, String tableName, String functionStr, String initInfoStr, String serverGroups) throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        CallableStatement cs = conn.prepareCall("CALL SYS.ATTACH_WRITER(?,?,?,?,?)");
        cs.setString(1, schemaName);
        cs.setString(2, tableName);
        cs.setString(3, functionStr);
        cs.setString(4, initInfoStr);
        cs.setString(5, serverGroups);
        cs.execute();
    }

    public static void addLoader(String schemaName, String tableName, String functionStr, String initInfoStr) throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        CallableStatement cs = conn.prepareCall("CALL SYS.ATTACH_LOADER(?,?,?,?)");
        cs.setString(1, schemaName);
        cs.setString(2, tableName);
        cs.setString(3, functionStr);
        cs.setString(4, initInfoStr);
        cs.execute();
    }

    public static void removeListener(String listenerID, String schemaName, String tableName) throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        CallableStatement cs = conn.prepareCall("CALL SYS.REMOVE_LISTENER(?,?,?)");
        cs.setString(1, listenerID);
        cs.setString(2, schemaName);
        cs.setString(3, tableName);
        cs.execute();
    }

    public static void removeWriter(String schemaName, String tableName) throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        CallableStatement cs = conn.prepareCall("CALL SYS.REMOVE_WRITER(?,?)");
        cs.setString(1, schemaName);
        cs.setString(2, tableName);
        cs.execute();
    }

    public static void removeLoader(String schemaName, String tableName) throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        CallableStatement cs = conn.prepareCall("CALL SYS.REMOVE_LOADER(?,?)");
        cs.setString(1, schemaName);
        cs.setString(2, tableName);
        cs.execute();
    }

    public void testListenerAddition() throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema emp");
        s.execute("create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addListener("ID1", "EMP", "TESTTABLE", "com.pivotal.gemfirexd.jdbc.GfxdTestCacheListener", "initInfoStrForListener", null);
        s.execute("insert into EMP.TESTTABLE values (1, 2, 3)");
    }

    public void testMultipleListenerAdditionAndRemoval() throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema emp");
        s.execute("create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addListener("ID1", "EMP", "TESTTABLE", "com.pivotal.gemfirexd.jdbc.GfxdTestCacheListener", "initInfoStrForListener", "");
        GfxdCallbacksTest.addListener("ID2", "EMP", "TESTTABLE", "com.pivotal.gemfirexd.jdbc.GfxdTestCacheListener", "initInfoStrForListener_second", "");
        s.execute("insert into EMP.TESTTABLE values (1, 2, 3)");
        GfxdCallbacksTest.removeListener("ID1", "EMP", "TESTTABLE");
        s.execute("insert into EMP.TESTTABLE values (5, 6, 7)");
        s.execute("update EMP.TESTTABLE set thirdid=10 where id=1");
    }

    public void testWriterAddition() throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema emp");
        s.execute("create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addWriter("EMP", "TESTTABLE", "com.pivotal.gemfirexd.jdbc.GfxdTestCacheWriter", "initInfoStrForWriter", "");
        s.execute("insert into EMP.TESTTABLE values (1, 2, 3)");
    }

    public void testMultipleWriterAddition() throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema emp");
        s.execute("create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addWriter("EMP", "TESTTABLE", "com.pivotal.gemfirexd.jdbc.GfxdTestCacheWriter", "initInfoStrForWriter", "");
        GfxdCallbacksTest.addWriter("EMP", "TESTTABLE", "com.pivotal.gemfirexd.jdbc.GfxdTestCacheWriter", "initInfoStrForWriter", null);
        s.execute("insert into EMP.TESTTABLE values (1, 2, 3)");
    }

    public void testWriterRemoval() throws SQLException {
        Connection conn = GfxdCallbacksTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema emp");
        s.execute("create table EMP.TESTTABLE (ID int not null, SECONDID int not null, THIRDID int not null, primary key (ID))");
        GfxdCallbacksTest.addWriter("EMP", "TESTTABLE", "com.pivotal.gemfirexd.jdbc.GfxdTestCacheWriter", "initInfoStrForWriter", "");
        s.execute("insert into EMP.TESTTABLE values (1, 2, 3)");
        s.execute("update EMP.TESTTABLE set secondid=1 where id=1");
        GfxdCallbacksTest.removeWriter("EMP", "TESTTABLE");
        s.execute("insert into EMP.TESTTABLE values (5, 6, 7)");
    }
}

