/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.execute.QueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ForeignKeyTest
extends JdbcTestBase {
    public ForeignKeyTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ForeignKeyTest.class));
    }

    public void testFkInsert() throws SQLException {
        Statement s;
        Connection conn;
        block2: {
            conn = ForeignKeyTest.getConnection();
            s = conn.createStatement();
            int rowCount = 0;
            s.executeUpdate("create table t2(id int not null, primary key(id))" + this.getSuffix());
            s.executeUpdate("create table t1(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t2(id))" + this.getSuffix());
            ForeignKeyTest.assertEquals((int)1, (int)(rowCount += s.executeUpdate("insert into t2 values(1)")));
            ForeignKeyTest.assertEquals((int)2, (int)(rowCount += s.executeUpdate("insert into t1 values(1, 1)")));
            try {
                s.executeUpdate("insert into t1 values(2, 2)");
                ForeignKeyTest.fail("should have thrown an SQLException");
            }
            catch (SQLException ex) {
                if ("23503".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        conn.commit();
        s.close();
    }

    public void _testFkNotOnPK() throws Exception {
        Statement s;
        Connection conn;
        block2: {
            conn = ForeignKeyTest.getConnection();
            s = conn.createStatement();
            s.executeUpdate("create table t2(id int not null)" + this.getSuffix());
            try {
                s.executeUpdate("create table t1(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t2(id))" + this.getSuffix());
                ForeignKeyTest.fail("Create table should fail because table t2 has no primary key or unique which table t1 is pointing in foreign key cosnstraint");
            }
            catch (SQLException ex) {
                if ("X0Y44".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        conn.commit();
        s.close();
    }

    public void _testFkOnUniqueColumn() throws SQLException {
        Connection conn = ForeignKeyTest.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table t2(id int not null unique)" + this.getSuffix());
        s.executeUpdate("create table t1(id int not null, fkId int not null, primary key(id), foreign key (fkId) references t2(id))" + this.getSuffix());
        conn.commit();
        s.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug40025() throws Exception {
        Connection conn = null;
        Statement s = null;
        String updateQuery = "update Child set sector_id2 = ? where id2 = ?";
        conn = ForeignKeyTest.getConnection();
        s = conn.createStatement();
        s.execute("create table INSTRUMENTS (id1 int primary key, sector_id1 int, subsector_id1 int)  replicate" + this.getSuffix());
        s.execute("create table Child ( id2 int primary key, sector_id2 int, subsector_id2 int, foreign key (sector_id2) references instruments (id1) ) replicate" + this.getSuffix());
        try {
            s.execute("insert into instruments values (1,1,1)");
            s.execute("insert into Child values (1,1,1)");
            TestUtil.setupConnection();
            EmbedPreparedStatement es = (EmbedPreparedStatement)TestUtil.jdbcConn.prepareStatement(updateQuery);
            es.setInt(1, 2);
            es.setInt(2, 1);
            try {
                es.executeUpdate();
                ForeignKeyTest.fail("Update should not have occured as foreign key violation would occur");
            }
            catch (SQLException sqle) {
                ForeignKeyTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
            }
        }
        finally {
            GemFireXDQueryObserverHolder.putInstance((QueryObserver)new GemFireXDQueryObserverAdapter());
            conn = ForeignKeyTest.getConnection();
            s = conn.createStatement();
            s.execute("Drop table Child ");
            this.waitTillAllClear();
            s.execute("Drop table INSTRUMENTS ");
            this.waitTillAllClear();
        }
    }

    public void testBug41168() throws Exception {
        Connection conn = ForeignKeyTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table BinaryTree (id int primary key, leftId int, rightId int, depth int not null, foreign key (leftId) references BinaryTree(id), foreign key (rightId) references BinaryTree(id))" + this.getSuffix());
        s.execute("insert into BinaryTree values (3, null, null, 2)");
        s.execute("insert into BinaryTree values (2, null, null, 1)");
        s.execute("insert into BinaryTree values (1, 3, null, 1)");
        s.execute("insert into BinaryTree values (0, 1, 2, 0)");
        this.doOffHeapValidations();
        ForeignKeyTest.addExpectedException(FunctionException.class);
        try {
            s.execute("insert into BinaryTree values (4, 5, null, 2)");
            ForeignKeyTest.fail("insert should throw foreign key violation exception");
        }
        catch (SQLException sqle) {
            ForeignKeyTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
        }
        try {
            s.execute("insert into BinaryTree values (5, null, 4, 2)");
            ForeignKeyTest.fail("insert should throw foreign key violation exception");
        }
        catch (SQLException sqle) {
            ForeignKeyTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
        }
        try {
            s.execute("update BinaryTree set leftId=4 where id=2");
            ForeignKeyTest.fail("update should throw foreign key violation exception");
        }
        catch (SQLException sqle) {
            ForeignKeyTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
        }
        try {
            s.execute("update BinaryTree set rightId=5 where id=2");
            ForeignKeyTest.fail("update should throw foreign key violation exception");
        }
        catch (SQLException sqle) {
            ForeignKeyTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
        }
        this.doOffHeapValidations();
        s.execute("insert into BinaryTree values (4, null, null, 2)");
        s.execute("insert into BinaryTree values (5, null, null, 2)");
        s.execute("update BinaryTree set leftId=4 where id=2");
        s.execute("update BinaryTree set rightId=5 where id=2");
        this.doOffHeapValidations();
        ResultSet rs = null;
        rs = s.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 3");
        ForeignKeyTest.assertTrue((String)"expected one result", (boolean)rs.next());
        ForeignKeyTest.assertEquals((int)1, (int)rs.getInt(1));
        ForeignKeyTest.assertFalse((String)"expected one result", (boolean)rs.next());
        this.doOffHeapValidations();
        try {
            s.execute("delete from BinaryTree where id=4");
            ForeignKeyTest.fail("delete should throw foreign key violation exception");
        }
        catch (SQLException sqle) {
            ForeignKeyTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
        }
        this.doOffHeapValidations();
        try {
            s.execute("delete from BinaryTree where id=5");
            ForeignKeyTest.fail("delete should throw foreign key violation exception");
        }
        catch (SQLException sqle) {
            ForeignKeyTest.assertEquals((String)sqle.toString(), (String)"23503", (String)sqle.getSQLState());
        }
        this.doOffHeapValidations();
        try {
            s.execute("update BinaryTree set depth=null where id=2");
        }
        catch (SQLException sqle) {
            ForeignKeyTest.assertEquals((String)sqle.toString(), (String)"23502", (String)sqle.getSQLState());
        }
        this.doOffHeapValidations();
        s.execute("update BinaryTree set leftId=null where id=2");
        s.execute("update BinaryTree set rightId=null where id=2");
        s.execute("delete from BinaryTree where id=5");
        s.execute("delete from BinaryTree where id=4");
        this.doOffHeapValidations();
        rs = s.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 4");
        ForeignKeyTest.assertFalse((String)"expected no result", (boolean)rs.next());
        rs = s.executeQuery("select t1.id from BinaryTree t1, BinaryTree t2 where t1.leftId = t2.id and t2.id = 5");
        ForeignKeyTest.assertFalse((String)"expected no result", (boolean)rs.next());
        this.doOffHeapValidations();
    }

    protected String getSuffix() {
        return " ";
    }

    public void waitTillAllClear() {
    }
}

