/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class ExportImportTest
extends JdbcTestBase {
    public ExportImportTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testExportTable_defaultSchema() throws SQLException {
        File outfile = new File("myfile.flt");
        if (outfile.exists()) {
            outfile.delete();
        }
        Connection conn = ExportImportTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
        stmt.execute("insert into t1 values (1, 1, 'kingfisher'), (1, 2, 'jet'), (2, 1, 'ai'), (3, 1, 'ial')");
        stmt.execute("CALL SYSCS_UTIL.EXPORT_TABLE(null, 't1', 'myfile.flt', null, null, null)");
        stmt.execute("create table imported_t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT IMPORTED_FLIGHTS_PK PRIMARY KEY (FLIGHT_ID, SEGMENT_NUMBER))");
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE(null, 'imported_t1', 'myfile.flt', null, null, null, 0)");
        stmt.execute("select * from imported_t1");
        ResultSet rs = stmt.getResultSet();
        while (rs.next()) {
            System.out.println(rs.getInt(1) + ", " + rs.getInt(2) + ", " + rs.getString(3));
        }
        stmt.close();
        conn.close();
    }

    public void testExportTable_joinQuery__defaultSchema() throws SQLException {
        File outfile = new File("myfile.flt");
        if (outfile.exists()) {
            outfile.delete();
        }
        Connection conn = ExportImportTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_PK PRIMARY KEY (FLIGHT_ID)) replicate");
        stmt.execute("create table t2(flight_id int not null, segment_number int not null, aircraft varchar(20) not null, CONSTRAINT FLIGHTS_FK foreign KEY (FLIGHT_ID) references t1(flight_id)) replicate");
        stmt.execute("insert into t1 values (1, 1, 'kingfisher'), (2, 2, 'jet'), (3, 1, 'ai'), (4, 1, 'ial')");
        stmt.execute("insert into t2 values (1, 1, 'kingfisher_dep'), (2, 2, 'jet_dep'), (3, 1, 'ai_dep'), (4, 1, 'ial_dep')");
        stmt.execute("CALL SYSCS_UTIL.EXPORT_QUERY('select * from t1, t2 where t1.flight_id = t2.flight_id', 'myfile.flt', null, null, null)");
        stmt.close();
        conn.close();
    }

    public void testImport_bug50128() throws SQLException {
        Connection conn = ExportImportTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by primary key  REDUNDANCY 1");
        String importFile = TestUtil.getResourcesDir() + File.separator + "lib" + File.separator + "ImportData" + File.separator + "SECURITIES.dat";
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TRADE', 'SECURITIES', '" + importFile + "', null, null, null, 0, 0, 6, 0, null, null)");
        ResultSet r = stmt.executeQuery("select count(1) from trade.securities");
        ExportImportTest.assertTrue((boolean)r.next());
        ExportImportTest.assertEquals((int)1179, (int)r.getInt(1));
        ExportImportTest.assertFalse((boolean)r.next());
        r.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug51374_2() throws Exception {
        Properties props = new Properties();
        Connection cxn = TestUtil.getConnection(props);
        Statement stmt = cxn.createStatement();
        String[] s = new String[]{"a\nbc", "p\"q\"\nr", "", "   \"\n\"\"", "", null};
        stmt.execute("CREATE table app.t1(col1 int, col2 varchar(10)) persistent partition by (col1) ");
        PreparedStatement ps = cxn.prepareStatement("insert into app.t1 values (?, ?)");
        for (int j = 0; j < s.length; ++j) {
            ps.setInt(1, j);
            ps.setString(2, s[j]);
            ps.execute();
        }
        try {
            stmt.execute("CALL SYSCS_UTIL.EXPORT_TABLE('APP','T1', 'T1.dat',NULL, NULL, NULL)");
            stmt.execute("CREATE table app.t2(col1 int, col2 varchar(10)) persistent partition by (col1)");
            stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX('APP', 'T2', 'T1.dat', NULL, NULL, NULL, 0, 0, 2, 0, null, null)");
            ResultSet rs = stmt.executeQuery("select col1, col2 from app.t2 order by col1");
            int i = 0;
            while (rs.next()) {
                String output = rs.getString(2);
                ExportImportTest.assertEquals((String)s[i], (String)output);
                System.out.println("output=" + output);
                ++i;
            }
        }
        finally {
            new File("T1.dat").delete();
        }
    }
}

