/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DropIfExistsTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(DropIfExistsTest.class));
    }

    public DropIfExistsTest(String name) {
        super(name);
    }

    public void testDropTableIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE SCHEMA EMP", false);
            DropIfExistsTest.sqlExecute("CREATE TABLE EMP.AVAILABILITY2(ID INT PRIMARY KEY,BOOKING_DATE DATE NOT NULL,ROOMS_TAKEN INT)", false);
            DropIfExistsTest.sqlExecute("DROP TABLE IF EXISTS EMP.AVAILABILITY2", false);
            try {
                DropIfExistsTest.sqlExecute("DROP TABLE EMP.AVAILABILITY2", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP TABLE IF EXISTS APP.NOSUCHTABLE", false);
        DropIfExistsTest.sqlExecute("DROP TABLE IF EXISTS NOSUCHSCHEMA.NOSUCHTABLE", false);
    }

    public void testDropSchemaIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.assertNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
            DropIfExistsTest.sqlExecute("CREATE SCHEMA EMP", true);
            DropIfExistsTest.assertNotNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
            DropIfExistsTest.sqlExecute("DROP SCHEMA IF EXISTS EMP RESTRICT", true);
            DropIfExistsTest.assertNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
            DropIfExistsTest.sqlExecute("CREATE SCHEMA EMP", true);
            DropIfExistsTest.sqlExecute("CREATE TABLE EMP.AVAILABILITY (HOTEL_ID INT NOT NULL, BOOKING_DATE DATE NOT NULL, ROOMS_TAKEN INT, CONSTRAINT HOTELAVAIL_PK PRIMARY KEY (HOTEL_ID, BOOKING_DATE))", false);
            DropIfExistsTest.assertNotNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
            try {
                DropIfExistsTest.sqlExecute("DROP SCHEMA IF EXISTS EMP RESTRICT", true);
            }
            catch (SQLException e) {
                if (e.getSQLState().equalsIgnoreCase("X0Y54")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("drop table EMP.AVAILABILITY", true);
        DropIfExistsTest.sqlExecute("DROP SCHEMA IF EXISTS EMP RESTRICT", true);
        DropIfExistsTest.assertNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
        DropIfExistsTest.sqlExecute("DROP SCHEMA IF EXISTS EMPXX RESTRICT", true);
    }

    public void testBug51005() throws SQLException {
        block5: {
            Statement st;
            block4: {
                Properties props1 = new Properties();
                int mport = AvailablePort.getRandomAvailablePort((int)1);
                props1.put("mcast-port", String.valueOf(mport));
                DropIfExistsTest.setupConnection(props1);
                Connection conn = TestUtil.getConnection(props1);
                st = conn.createStatement();
                st.execute("create table test(col1 int not null, col2 int not null) partition by column(col2)");
                st.execute("create index idx on test(col2)");
                st.execute("drop index if exists idx");
                st.execute("drop index if exists idx");
                try {
                    st.execute("drop index idx");
                    DropIfExistsTest.fail("The above statement should have thrown an exception - 1");
                }
                catch (SQLException ex) {
                    if (ex.getSQLState().equals("42X65")) break block4;
                    throw ex;
                }
            }
            st.execute("drop index if exists idx");
            st.execute("create index idx on test(col2)");
            st.execute("drop index if exists idx");
            try {
                st.execute("drop index idx");
                DropIfExistsTest.fail("The above statement should have thrown an exception - 2");
            }
            catch (SQLException ex) {
                if (ex.getSQLState().equals("42X65")) break block5;
                throw ex;
            }
        }
    }

    public void testBug51005_2() throws SQLException {
        block5: {
            Statement st;
            block4: {
                Properties props1 = new Properties();
                int mport = AvailablePort.getRandomAvailablePort((int)1);
                props1.put("mcast-port", String.valueOf(mport));
                DropIfExistsTest.setupConnection(props1);
                Connection conn = TestUtil.getConnection(props1);
                st = conn.createStatement();
                st.execute("create table test(col1 int not null, col2 int not null) partition by column(col2)");
                st.execute("drop table if exists sch.test");
                st.execute("drop table if exists sch.test");
                st.execute("drop table if exists sch.test");
                st.execute("drop table if exists test");
                try {
                    st.execute("drop table test");
                    DropIfExistsTest.fail("The above statement should have thrown an exception - 1");
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("42Y55")) break block4;
                    throw e;
                }
            }
            st.execute("drop table if exists sch.test");
            st.execute("create table test(col1 int not null, col2 int not null) partition by column(col2)");
            st.execute("drop table if exists test");
            try {
                st.execute("drop table test");
                DropIfExistsTest.fail("The above statement should have thrown an exception - 2");
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block5;
                throw e;
            }
        }
    }

    public void testDropIndexIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE SCHEMA EMP", false);
            DropIfExistsTest.sqlExecute("CREATE TABLE EMP.AVAILABILITY2(ID INT PRIMARY KEY,BOOKING_DATE DATE NOT NULL,ROOMS_TAKEN INT)", false);
            DropIfExistsTest.sqlExecute("CREATE INDEX EMP.IDX_ID ON EMP.AVAILABILITY2(ID)", false);
            DropIfExistsTest.sqlExecute("DROP INDEX EMP.IDX_ID", false);
            try {
                DropIfExistsTest.sqlExecute("DROP INDEX EMP.ABC", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42X65")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP INDEX IF EXISTS EMP.DEF", false);
        DropIfExistsTest.sqlExecute("CREATE INDEX EMP.IDX_ID ON EMP.AVAILABILITY2(ID)", false);
        DropIfExistsTest.sqlExecute("DROP INDEX IF EXISTS EMP.IDX_ID", false);
        DropIfExistsTest.sqlExecute("DROP TABLE IF EXISTS EMP.AVAILABILITY2", false);
        DropIfExistsTest.sqlExecute("DROP SCHEMA IF EXISTS EMP RESTRICT", false);
        DropIfExistsTest.sqlExecute("DROP INDEX IF EXISTS TESTSCHEMA.IDXXXX", false);
    }

    public void testDropProcedureIfExists() throws SQLException {
        block5: {
            block4: {
                DropIfExistsTest.setupConnection();
                String createProc = "CREATE PROCEDURE EXAMPLE_PROC(IN S_MONTH INTEGER,IN S_YEAR INTEGER, OUT TOTAL DECIMAL(10,2)) LANGUAGE JAVA PARAMETER STYLE JAVA READS SQL DATA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.DropIfExistsTest.exampleProc'";
                DropIfExistsTest.sqlExecute(createProc, false);
                DropIfExistsTest.sqlExecute("DROP PROCEDURE IF EXISTS EXAMPLE_PROC", false);
                try {
                    DropIfExistsTest.sqlExecute("DROP PROCEDURE EXAMPLE_PROC", false);
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("42Y55")) break block4;
                    throw e;
                }
            }
            DropIfExistsTest.sqlExecute("DROP PROCEDURE IF EXISTS APP.PROCXXX", false);
            try {
                DropIfExistsTest.sqlExecute("DROP PROCEDURE APP.PROCXXX", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block5;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP PROCEDURE IF EXISTS TESTXX.PROCXXX", false);
    }

    public static void exampleProc(Integer inParam1, Integer inParam2, Float total, ProcedureExecutionContext ctx) throws SQLException {
    }

    public void testDropFunctionIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE FUNCTION R() RETURNS DOUBLE EXTERNAL NAME'java.lang.Math.random' LANGUAGE JAVA PARAMETER STYLE JAVA", false);
            DropIfExistsTest.sqlExecute("DROP FUNCTION IF EXISTS R", false);
            try {
                DropIfExistsTest.sqlExecute("DROP FUNCTION R", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP FUNCTION IF EXISTS APP.FUNCXXX", false);
        DropIfExistsTest.sqlExecute("DROP FUNCTION IF EXISTS TESTXX.FUNCXXX", false);
    }

    public void testDropSynonymIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE TABLE APP.TEMP(C1 INT, C2 INT)", false);
            DropIfExistsTest.sqlExecute("CREATE SYNONYM SYNTEMP FOR APP.TEMP", false);
            DropIfExistsTest.sqlExecute("DROP SYNONYM IF EXISTS APP.SYNTEMP", false);
            try {
                DropIfExistsTest.sqlExecute("DROP SYNONYM SYNTEMP", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP SYNONYM IF EXISTS APP.NOSYNONYM", false);
        DropIfExistsTest.sqlExecute("DROP SYNONYM IF EXISTS NOSCHEMA.NOSYNONYM", false);
    }

    public void testDropAliasIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE ALIAS AL_LISTAGG FOR 'sql.poc.useCase3.LISTAGGPROCESSOR'", false);
            DropIfExistsTest.sqlExecute("DROP ALIAS IF EXISTS AL_LISTAGG", false);
            try {
                DropIfExistsTest.sqlExecute("DROP ALIAS AL_LISTAGG", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP ALIAS IF EXISTS APP.NOALIAS", false);
        DropIfExistsTest.sqlExecute("DROP ALIAS IF EXISTS NOSCHEMA.NOALIAS", false);
    }

    public void testDropTypeIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE TYPE UDT_PRICE EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.lang.Price' LANGUAGE JAVA", false);
            DropIfExistsTest.sqlExecute("DROP TYPE IF EXISTS UDT_PRICE RESTRICT", false);
            try {
                DropIfExistsTest.sqlExecute("DROP TYPE UDT_PRICE RESTRICT", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP TYPE IF EXISTS NOUDT RESTRICT", false);
        DropIfExistsTest.sqlExecute("DROP TYPE IF EXISTS NOSCHEMA.NOUDT RESTRICT", false);
    }

    public void testDropViewIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE SCHEMA T", false);
            DropIfExistsTest.sqlExecute("CREATE TABLE T.TESTTABLE(C1 INT PRIMARY KEY, C2 INT)", false);
            DropIfExistsTest.sqlExecute("CREATE VIEW T.TESTVIEW AS SELECT * FROM T.TESTTABLE", false);
            DropIfExistsTest.sqlExecute("DROP VIEW IF EXISTS T.TESTVIEW", false);
            try {
                DropIfExistsTest.sqlExecute("DROP VIEW T.TESTVIEW", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("X0X05")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP VIEW IF EXISTS T.NOSUCHVIEW", false);
        DropIfExistsTest.sqlExecute("DROP VIEW IF EXISTS NOSUCHSCHEMA.NOSUCHVIEW", false);
    }

    public void testDropTriggerIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE TABLE CURRENT_DATA(ID INT NOT NULL, C1 INT NOT NULL, C2 VARCHAR(12) NOT NULL) REPLICATE", false);
            DropIfExistsTest.sqlExecute("CREATE TABLE ARCHIVED_DATA(ID INT NOT NULL, C2 VARCHAR(12) NOT NULL, COMMENT VARCHAR(20) NOT NULL)", false);
            DropIfExistsTest.sqlExecute("CREATE TRIGGER testtrigger AFTER INSERT ON CURRENT_DATA REFERENCING NEW AS NEWROW FOR EACH ROW MODE DB2SQL INSERT INTO ARCHIVED_DATA VALUES(NEWROW.ID, NEWROW.C2, 'from testtrigger')", false);
            DropIfExistsTest.sqlExecute("INSERT INTO CURRENT_DATA VALUES(1, 5, 'test')", false);
            DropIfExistsTest.sqlExecute("DROP TRIGGER IF EXISTS testtrigger", false);
            try {
                DropIfExistsTest.sqlExecute("DROP TRIGGER testtrigger", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42X94")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP TRIGGER IF EXISTS APP.NOSUCHTRIGGER", false);
        DropIfExistsTest.sqlExecute("DROP TRIGGER IF EXISTS NOSUCHSCHEMA.NOSUCHTRIGGER", false);
    }

    public void testDropGatewaySenderIfExists() throws SQLException {
        block2: {
            Properties props = new Properties();
            props.setProperty("server-groups", "SG1");
            DropIfExistsTest.setupConnection(props);
            DropIfExistsTest.sqlExecute("CREATE GATEWAYSENDER TESTSENDER ( remotedsid 2 socketbuffersize 1000 manualstart true  SOCKETREADTIMEOUT 1000 ENABLEBATCHCONFLATION true BATCHSIZE 10 BATCHTIMEINTERVAL 100 ENABLEPERSISTENCE false MAXQUEUEMEMORY 400  ALERTTHRESHOLD 100) server groups (SG1)", false);
            DropIfExistsTest.sqlExecute("DROP GATEWAYSENDER IF EXISTS TESTSENDER", false);
            try {
                DropIfExistsTest.sqlExecute("DROP GATEWAYSENDER mySender", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP GATEWAYSENDER IF EXISTS NOSUCHGATEWAYSENDER", false);
    }

    public void testDropGatewayReceiverIfExists() throws SQLException {
        block2: {
            Properties props = new Properties();
            props.setProperty("server-groups", "SG1");
            DropIfExistsTest.setupConnection(props);
            DropIfExistsTest.sqlExecute("CREATE GATEWAYRECEIVER TESTRECEIVER (startport 1530 endport 1541) SERVER GROUPS (SG1)", false);
            DropIfExistsTest.sqlExecute("DROP GATEWAYRECEIVER IF EXISTS TESTRECEIVER", false);
            try {
                DropIfExistsTest.sqlExecute("DROP GATEWAYRECEIVER TESTRECEIVER", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP GATEWAYRECEIVER IF EXISTS NOSUCHGATEWAYRECEIVER", false);
    }

    public void testDropAsyncEventListenerIfExists() throws SQLException {
        block2: {
            Properties props = new Properties();
            props.setProperty("server-groups", "SG1");
            DropIfExistsTest.setupConnection(props);
            DropIfExistsTest.sqlExecute("CREATE ASYNCEVENTLISTENER TESTLISTENER ( listenerclass 'com.pivotal.gemfirexd.callbacks.DBSynchronizer' initparams 'org.apache.derby.jdbc.EmbeddedDriver,jdbc:derby:newDB;create=true' manualstart false) server groups (sg1)", false);
            DropIfExistsTest.sqlExecute("DROP ASYNCEVENTLISTENER IF EXISTS TESTLISTENER", false);
            try {
                DropIfExistsTest.sqlExecute("DROP ASYNCEVENTLISTENER TESTLISTENER", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP ASYNCEVENTLISTENER IF EXISTS NOSUCHLISTENER", false);
    }

    public void testDropDiskStoreIfExists() throws SQLException {
        block2: {
            DropIfExistsTest.setupConnection();
            DropIfExistsTest.sqlExecute("CREATE DISKSTORE TESTSTORE", false);
            DropIfExistsTest.sqlExecute("DROP DISKSTORE IF EXISTS TESTSTORE", false);
            try {
                DropIfExistsTest.sqlExecute("DROP DISKSTORE TESTSTORE", false);
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("42Y55")) break block2;
                throw e;
            }
        }
        DropIfExistsTest.sqlExecute("DROP DISKSTORE IF EXISTS TESTSTORE", false);
    }
}

