/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.EvictionAction;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.jdbc.CreateTableOtherAttributesTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DiskStoreTest
extends JdbcTestBase {
    char fileSeparator = System.getProperty("file.separator").charAt(0);

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(CreateTableOtherAttributesTest.class));
    }

    public DiskStoreTest(String name) {
        super(name);
    }

    public void testDiskStoreCreation() throws Exception {
        Connection conn = DiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        File f1 = new File("dir1");
        f1.mkdir();
        File f2 = new File("dir2");
        f2.mkdir();
        File f3 = new File("dir3");
        f3.mkdir();
        s.execute("create DiskStore testDiskStore maxlogsize 128 autocompact true  allowforcecompaction false compactionthreshold 80 TimeInterval 223344 Writebuffersize 19292393 queuesize 17374  ('dir1' 456, 'dir2', 'dir3' 55556 )");
        DiskStoreImpl ds = Misc.getGemFireCache().findDiskStore("TESTDISKSTORE");
        DiskStoreTest.assertNotNull((Object)ds);
        this.cleanUpDirs(new File[]{f1, f2, f3});
        s.execute("create DiskStore testDiskStore1");
        ds = Misc.getGemFireCache().findDiskStore("TESTDISKSTORE1");
        DiskStoreTest.assertNotNull((Object)ds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableDropBehaviour() throws Exception {
        Connection conn = DiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("create diskstore store1");
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2)) persistent 'store1'");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
            s.execute("drop table t1");
            s.execute("create table t1 (c1 int , c2 int, c3 varchar(20), PRIMARY KEY (c1, c2)) persistent 'store1'");
            s.execute("insert into t1 (c1, c2, c3) values (10, 15, 'YYYY')");
            s.execute("insert into t1 (c1, c2, c3) values (20, 25, 'XXXX')");
            s.execute("insert into t1 (c1, c2, c3) values (30, 35, 'ZZZZ')");
        }
        finally {
            try {
                s.execute("drop table t1");
            }
            catch (SQLException sQLException) {}
            conn.close();
        }
    }

    public void testOverflow_43122() throws Exception {
        Connection conn = DiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create diskstore OverflowDiskStore 'overflow'");
        s.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) eviction by lrucount 2 evictaction overflow asynchronous 'OverflowDiskStore'");
        s.execute("insert into trade.securities (sec_id, symbol, exchange, tid) values (1, 'SYM1', 'nasdaq', 2)");
        s.execute("insert into trade.securities (sec_id, symbol, exchange, tid) values (2, 'SYM2', 'tse', 4)");
        s.execute("insert into trade.securities (sec_id, symbol, exchange, tid) values (3, 'SYM3', 'hkse', 3)");
        s.execute("drop table trade.securities");
        conn.close();
    }

    public void testOverflowWithPersistence() throws Exception {
        Connection conn = DiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create diskstore OverflowDiskStore 'overflow'");
        s.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) eviction by lrucount 2 evictaction overflow persistent asynchronous 'OverflowDiskStore'");
        LocalRegion region = (LocalRegion)Misc.getRegion((String)"TRADE/SECURITIES", (boolean)true, (boolean)false);
        RegionAttributes ra = region.getAttributes();
        DiskStoreTest.assertTrue((boolean)ra.getDataPolicy().withPersistence());
        DiskStoreTest.assertEquals((Object)ra.getEvictionAttributes().getAction(), (Object)EvictionAction.OVERFLOW_TO_DISK);
        s.execute("insert into trade.securities (sec_id, symbol, exchange, tid) values (1, 'SYM1', 'nasdaq', 2)");
        s.execute("insert into trade.securities (sec_id, symbol, exchange, tid) values (2, 'SYM2', 'tse', 4)");
        s.execute("insert into trade.securities (sec_id, symbol, exchange, tid) values (3, 'SYM3', 'hkse', 3)");
        TestUtil.shutDown();
        conn = DiskStoreTest.getConnection();
        s = conn.createStatement();
        ResultSet rs = s.executeQuery("select * from trade.securities");
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        DiskStoreTest.assertEquals((int)numRows, (int)3);
        s.execute("drop table trade.securities");
        conn.close();
    }

    public void testOverflowWithPersistenceIncorrectSyntax() throws Exception {
        Connection conn = DiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create diskstore OverflowDiskStore 'overflow'");
        s.execute("create diskstore PersistentDiskStore 'overflow'");
        try {
            s.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) eviction by lrucount 2 evictaction overflow 'OverflowDiskStore' synchronous  persistent 'PersistentDiskStore' ");
            DiskStoreTest.fail("table creation should have failed");
        }
        catch (SQLSyntaxErrorException sqle) {
            DiskStoreTest.assertTrue((sqle.getLocalizedMessage().indexOf("OverflowDiskStore") != -1 ? 1 : 0) != 0);
        }
        try {
            s.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) persistent 'PersistentDiskStore'  eviction by lrucount 2    evictaction overflow   'OverflowDiskStore' synchronous ");
            DiskStoreTest.fail("table creation should have failed");
        }
        catch (SQLSyntaxErrorException sqle) {
            DiskStoreTest.assertTrue((sqle.getLocalizedMessage().indexOf("PersistentDiskStore") != -1 ? 1 : 0) != 0);
        }
        try {
            s.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) persistent 'PersistentDiskStore'  eviction by lrucount 2    evictaction overflow   synchronous   asynchronous ");
            DiskStoreTest.fail("table creation should have failed");
        }
        catch (SQLSyntaxErrorException sqle) {
            sqle.printStackTrace();
            DiskStoreTest.assertTrue((sqle.getLocalizedMessage().indexOf("Synchronous") != -1 ? 1 : 0) != 0);
        }
        conn.close();
    }
}

