/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class DefaultValueTest
extends JdbcTestBase {
    public DefaultValueTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(DefaultValueTest.class));
    }

    public void testDefaultIntAndChar() throws SQLException {
        Connection conn = DefaultValueTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 int DEFAULT 42, c3 char(4) DEFAULT 'cara')");
        s.execute("insert into t1 (c1) values (10)");
        s.execute("insert into t1 (c1) values (20)");
        Object[][] expectedRows = new Object[][]{{10, 42, "cara"}, {20, 42, "cara"}};
        ResultSet rs = s.executeQuery("select * from t1");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        conn.close();
    }

    public void testDefaultWithPreparedStatement() throws SQLException {
        Connection conn = DefaultValueTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 int DEFAULT 42, c3 char(4) DEFAULT 'cara')");
        PreparedStatement ps = conn.prepareStatement("insert into t1 (c1) values (?)");
        ps.setInt(1, 10);
        ps.executeUpdate();
        ps.setInt(1, 20);
        ps.executeUpdate();
        Object[][] expectedRows = new Object[][]{{10, 42, "cara"}, {20, 42, "cara"}};
        ps.close();
        ps = conn.prepareStatement("select * from t1");
        ResultSet rs = ps.executeQuery();
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        conn.close();
    }
}

