/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryOperation;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.internal.cache.EntryOperationImpl;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.jdbc.AlterTableTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DefaultPartitionTest
extends JdbcTestBase {
    public DefaultPartitionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(DefaultPartitionTest.class));
    }

    public void testDefaultPartitionWhenPKFKExists() throws SQLException, StandardException {
        Connection conn = DefaultPartitionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID)) PARTITION BY PRIMARY KEY");
        s.execute("create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null,  SECONDID int not null, THIRDID int not null, foreign key (ID_FK) references EMP.PARTITIONTESTTABLE(ID))");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE_FK");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        DefaultPartitionTest.assertNotNull((Object)pr);
        GfxdPartitionByExpressionResolver scpr = (GfxdPartitionByExpressionResolver)pr;
        DefaultPartitionTest.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)scpr.getMasterTable(false));
        DefaultPartitionTest.assertEquals((int)1, (int)scpr.getColumnNames().length);
        DefaultPartitionTest.assertEquals((String)"ID_FK", (String)scpr.getColumnNames()[0]);
        String colocateTable = rattr.getPartitionAttributes().getColocatedWith();
        DefaultPartitionTest.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)colocateTable);
    }

    public void testDefaultPartitionWhenPKFKExists_composite() throws SQLException, StandardException {
        Connection conn = DefaultPartitionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID, SECONDID)) PARTITION BY PRIMARY KEY");
        s.execute("create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null,  SECONDID_FK int not null, THIRDID int not null, foreign key (ID_FK, SECONDID_FK) references EMP.PARTITIONTESTTABLE(ID, SECONDID))");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE_FK");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        DefaultPartitionTest.assertNotNull((Object)pr);
        GfxdPartitionByExpressionResolver scpr = (GfxdPartitionByExpressionResolver)pr;
        DefaultPartitionTest.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)scpr.getMasterTable(false));
        DefaultPartitionTest.assertEquals((int)2, (int)scpr.getColumnNames().length);
        DefaultPartitionTest.assertEquals((String)"ID_FK", (String)scpr.getColumnNames()[0]);
        DefaultPartitionTest.assertEquals((String)"SECONDID_FK", (String)scpr.getColumnNames()[1]);
        String colocateTable = rattr.getPartitionAttributes().getColocatedWith();
        DefaultPartitionTest.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)colocateTable);
    }

    public void testDefaultPartitionWhenPKFKExists_composite_pkIn2ndtoo() throws SQLException, StandardException {
        Connection conn = DefaultPartitionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID, SECONDID)) PARTITION BY PRIMARY KEY");
        s.execute("create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null,  SECONDID_FK int not null, THIRDID int not null, primary key (THIRDID), foreign key (ID_FK, SECONDID_FK) references EMP.PARTITIONTESTTABLE(ID, SECONDID))");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE_FK");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        DefaultPartitionTest.assertNotNull((Object)pr);
        GfxdPartitionByExpressionResolver scpr = (GfxdPartitionByExpressionResolver)pr;
        DefaultPartitionTest.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)scpr.getMasterTable(false));
        DefaultPartitionTest.assertEquals((int)2, (int)scpr.getColumnNames().length);
        DefaultPartitionTest.assertEquals((String)"ID_FK", (String)scpr.getColumnNames()[0]);
        DefaultPartitionTest.assertEquals((String)"SECONDID_FK", (String)scpr.getColumnNames()[1]);
        String colocateTable = rattr.getPartitionAttributes().getColocatedWith();
        DefaultPartitionTest.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)colocateTable);
    }

    public void testDefaultPartitionWhenNoPKFKExists() throws SQLException, StandardException {
        Connection conn = DefaultPartitionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID, SECONDID))");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        DefaultPartitionTest.assertNotNull((Object)pr);
        GfxdPartitionByExpressionResolver scpr = (GfxdPartitionByExpressionResolver)pr;
        assert (scpr.isDefaultPartitioning());
        DefaultPartitionTest.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)scpr.getMasterTable(false));
        DefaultPartitionTest.assertEquals((int)2, (int)scpr.getColumnNames().length);
        DefaultPartitionTest.assertEquals((String)"ID", (String)scpr.getColumnNames()[0]);
        DefaultPartitionTest.assertEquals((String)"SECONDID", (String)scpr.getColumnNames()[1]);
    }

    public void testDefaultPartition1stUniqKey() throws SQLException, StandardException {
        Connection conn = DefaultPartitionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, unique (ID), unique (SECONDID))");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        DefaultPartitionTest.assertNotNull((Object)pr);
        GfxdPartitionByExpressionResolver scpr = (GfxdPartitionByExpressionResolver)pr;
        assert (scpr.isDefaultPartitioning());
        DefaultPartitionTest.assertEquals((String)"/EMP/PARTITIONTESTTABLE", (String)scpr.getMasterTable(false));
        DefaultPartitionTest.assertEquals((int)1, (int)scpr.getColumnNames().length);
        DefaultPartitionTest.assertEquals((String)"ID", (String)scpr.getColumnNames()[0]);
    }

    public void testDefaultPartitionWhenMultFKExists() throws SQLException, StandardException {
        Connection conn = DefaultPartitionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID))");
        s.execute("create table EMP.PARTITIONTESTTABLE_2nd (ID_2 int not null,  SECONDID_2 int not null, THIRDID_2 int not null, primary key (SECONDID_2))");
        s.execute("create table EMP.PARTITIONTESTTABLE_FK (ID_FK int not null,  SECONDID_FK int not null, THIRDID_FK int not null, foreign key (SECONDID_FK) references EMP.PARTITIONTESTTABLE_2nd(SECONDID_2),foreign key (ID_FK) references EMP.PARTITIONTESTTABLE(ID))");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE_FK");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        DefaultPartitionTest.assertNotNull((Object)pr);
        GfxdPartitionByExpressionResolver scpr = (GfxdPartitionByExpressionResolver)pr;
        assert (scpr.isDefaultPartitioning());
        DefaultPartitionTest.assertEquals((int)1, (int)scpr.getColumnNames().length);
        DefaultPartitionTest.assertEquals((String)"SECONDID_FK", (String)scpr.getColumnNames()[0]);
    }

    public void testDefaultPartitionWhenNoConditionForDefaultExists() throws SQLException, StandardException {
        Connection conn = DefaultPartitionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE (ID int, SECONDID int, THIRDID int)");
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        DefaultPartitionTest.assertNotNull((Object)pr);
        GfxdPartitionByExpressionResolver scpr = (GfxdPartitionByExpressionResolver)pr;
        assert (scpr.isDefaultPartitioning());
        DefaultPartitionTest.assertEquals((int)0, (int)scpr.getColumnNames().length);
        EntryOperationImpl dEntryOp = new EntryOperationImpl(null, null, (Object)new Integer(10), null, null);
        Serializable srobj = scpr.getRoutingObject((EntryOperation)dEntryOp);
        Integer robj = (Integer)srobj;
        DefaultPartitionTest.assertEquals((int)10, (int)robj);
    }

    public void testMultiTableMultiFK() throws Exception {
        block2: {
            DefaultPartitionTest.setupConnection();
            DefaultPartitionTest.sqlExecute("create schema EMP", true);
            DefaultPartitionTest.assertNotNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
            DefaultPartitionTest.sqlExecute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, constraint part_pk primary key (ID))", false);
            try {
                DefaultPartitionTest.sqlExecute("create table EMP.PARTITIONTESTTABLE2 (ID int not null,  SECONDID int not null, THIRDID int not null, constraint part_pk primary key (SECONDID, THIRDID), constraint part_fk foreign key (ID) references EMP.PARTITIONTESTTABLE(ID))", false);
            }
            catch (SQLException ex) {
                if ("X0Y32".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        DefaultPartitionTest.sqlExecute("create table EMP.PARTITIONTESTTABLE2 (ID int not null,  SECONDID int not null, THIRDID int not null, constraint part2_pk primary key (SECONDID, THIRDID), constraint part_fk foreign key (ID) references EMP.PARTITIONTESTTABLE(ID))", false);
        DefaultPartitionTest.sqlExecute("create table EMP.PARTITIONTESTTABLE3 (ID int not null,  SECONDID int not null, THIRDID int not null, constraint part3_pk primary key (ID), constraint part3_fk foreign key (SECONDID, THIRDID) references EMP.PARTITIONTESTTABLE2(SECONDID, THIRDID))", false);
        DefaultPartitionTest.sqlExecuteVerifyText("select TABLENAME, CONSTRAINTNAME from SYS.SYSCONSTRAINTS con, SYS.SYSTABLES tab where con.TABLEID = tab.TABLEID and CONSTRAINTNAME='PART_PK'", DefaultPartitionTest.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_fkconstr1", false, false);
        DefaultPartitionTest.sqlExecuteVerifyText("select TABLENAME, CONSTRAINTNAME from SYS.SYSCONSTRAINTS con, SYS.SYSTABLES tab where con.TABLEID = tab.TABLEID and CONSTRAINTNAME='PART2_PK'", DefaultPartitionTest.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_fkconstr2", true, false);
        DefaultPartitionTest.sqlExecuteVerifyText("select TABLENAME, CONSTRAINTNAME from SYS.SYSCONSTRAINTS con, SYS.SYSTABLES tab where con.TABLEID = tab.TABLEID and CONSTRAINTNAME='PART3_PK'", DefaultPartitionTest.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_fkconstr3", true, false);
        DefaultPartitionTest.sqlExecuteVerifyText("select TABLENAME, CONSTRAINTNAME from SYS.SYSCONSTRAINTS con, SYS.SYSTABLES tab where con.TABLEID = tab.TABLEID and CONSTRAINTNAME='PART3_FK'", DefaultPartitionTest.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_fkconstr4", true, false);
        DefaultPartitionTest.sqlExecute("drop table EMP.PARTITIONTESTTABLE3", false);
        DefaultPartitionTest.sqlExecute("drop table EMP.PARTITIONTESTTABLE2", false);
        DefaultPartitionTest.sqlExecute("drop table EMP.PARTITIONTESTTABLE", false);
        DefaultPartitionTest.sqlExecute("drop schema EMP restrict", false);
    }

    public void testMultiTableMultiFKSubsetPK() throws Exception {
        block2: {
            DefaultPartitionTest.setupConnection();
            DefaultPartitionTest.sqlExecute("create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))", false);
            DefaultPartitionTest.sqlExecute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_port_fk foreign key (cid) references trade.customers (cid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))", false);
            DefaultPartitionTest.sqlExecute("create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, price decimal (10, 2), order_time date, status varchar(10), tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid), constraint status_ch check (status in ('cancelled', 'pending', 'filled')))", false);
            DefaultPartitionTest.sqlExecuteVerifyText("select TABLENAME, CONSTRAINTNAME from SYS.SYSCONSTRAINTS con, SYS.SYSTABLES tab where con.TABLEID = tab.TABLEID and CONSTRAINTNAME='PORTF_PK'", DefaultPartitionTest.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_fkconstr5", false, false);
            DefaultPartitionTest.sqlExecuteVerifyText("select TABLENAME, CONSTRAINTNAME from SYS.SYSCONSTRAINTS con, SYS.SYSTABLES tab where con.TABLEID = tab.TABLEID and CONSTRAINTNAME='CUST_PORT_FK'", DefaultPartitionTest.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_fkconstr6", true, false);
            DefaultPartitionTest.sqlExecuteVerifyText("select TABLENAME, CONSTRAINTNAME from SYS.SYSCONSTRAINTS con, SYS.SYSTABLES tab where con.TABLEID = tab.TABLEID and CONSTRAINTNAME='PORTF_FK'", DefaultPartitionTest.getResourcesDir() + "/lib/checkCreateTable.xml", "emp_fkconstr7", true, false);
            try {
                DefaultPartitionTest.sqlExecute("drop table trade.portfolio", false);
            }
            catch (SQLException ex) {
                if ("X0Y25".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        DefaultPartitionTest.sqlExecute("drop table trade.sellorders", false);
        DefaultPartitionTest.sqlExecute("drop table trade.portfolio", false);
        DefaultPartitionTest.sqlExecute("drop table trade.customers", false);
        DefaultPartitionTest.sqlExecute("drop schema trade restrict", false);
    }

    public void testDefaultReplicate() throws SQLException {
        Statement stmt;
        block2: {
            skipDefaultPartitioned = true;
            Connection conn = DefaultPartitionTest.getConnection();
            stmt = conn.createStatement();
            stmt.execute("create table EMP.TESTTABLE (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null,TID int, primary key (ID), unique (tid))");
            stmt.execute("create index test_idx1 on EMP.testtable(description)");
            try {
                stmt.execute("create global hash index test_idx3 on EMP.testtable(address)");
                DefaultPartitionTest.fail("expected global hash index creation to fail for replicated table");
            }
            catch (SQLException sqle) {
                if ("X0Z15".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
        stmt.execute("create unique index test_idx2 on EMP.testtable(address)");
        Region region = Misc.getRegionForTable((String)"EMP.TESTTABLE", (boolean)true);
        DefaultPartitionTest.assertEquals((Object)DataPolicy.REPLICATE, (Object)region.getAttributes().getDataPolicy());
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALHASH1", "ID");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALSORTEDMAP", "TID");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALSORTEDMAP", "DESCRIPTION");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALSORTEDMAP", "ADDRESS");
    }

    public void testDefaultReplicateSystemProp() throws SQLException {
        Statement stmt;
        block2: {
            System.setProperty(GfxdConstants.TABLE_DEFAULT_PARTITIONED_SYSPROP, "false");
            Connection conn = DefaultPartitionTest.getConnection();
            stmt = conn.createStatement();
            stmt.execute("create table EMP.TESTTABLE (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null,TID int, primary key (ID), unique (tid))");
            stmt.execute("create index test_idx1 on EMP.testtable(description)");
            try {
                stmt.execute("create global hash index test_idx3 on EMP.testtable(address)");
                DefaultPartitionTest.fail("expected global hash index creation to fail for replicated table");
            }
            catch (SQLException sqle) {
                if ("X0Z15".equals(sqle.getSQLState())) break block2;
                throw sqle;
            }
        }
        stmt.execute("create unique index test_idx2 on EMP.testtable(address)");
        Region region = Misc.getRegionForTable((String)"EMP.TESTTABLE", (boolean)true);
        DefaultPartitionTest.assertEquals((Object)DataPolicy.REPLICATE, (Object)region.getAttributes().getDataPolicy());
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALHASH1", "ID");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALSORTEDMAP", "TID");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALSORTEDMAP", "DESCRIPTION");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALSORTEDMAP", "ADDRESS");
    }

    public void testDefaultPartitionedSystemProp() throws SQLException {
        skipDefaultPartitioned = true;
        System.setProperty(GfxdConstants.TABLE_DEFAULT_PARTITIONED_SYSPROP, "true");
        Connection conn = DefaultPartitionTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table EMP.TESTTABLE (ID int, DESCRIPTION varchar(1024) not null, ADDRESS varchar(1024) not null,ADDRESS2 varchar(1024) not null,TID int, primary key (ID), unique (tid))");
        stmt.execute("create index test_idx1 on EMP.testtable(description)");
        stmt.execute("create global hash index test_idx3 on EMP.testtable(address)");
        stmt.execute("create unique index test_idx2 on EMP.testtable(address2)");
        Region region = Misc.getRegionForTable((String)"EMP.TESTTABLE", (boolean)true);
        DefaultPartitionTest.assertEquals((Object)DataPolicy.PARTITION, (Object)region.getAttributes().getDataPolicy());
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALHASH1", "ID");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "GLOBALHASH", "TID");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "LOCALSORTEDMAP", "DESCRIPTION");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "GLOBALHASH", "ADDRESS");
        AlterTableTest.checkIndexType("EMP", "TESTTABLE", "GLOBALHASH", "ADDRESS2");
    }
}

