/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.tools.internal.GfxdDdlUtils;
import io.snappydata.test.dunit.DistributedTestBase;
import io.snappydata.test.dunit.SerializableRunnable;
import io.snappydata.test.dunit.VM;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.ddlutils.PlatformUtils;
import org.apache.ddlutils.task.DatabaseToDdlTask;
import org.apache.ddlutils.task.DdlToDatabaseTask;
import org.apache.ddlutils.task.WriteDataToDatabaseCommand;
import org.apache.ddlutils.task.WriteDataToFileCommand;
import org.apache.ddlutils.task.WriteSchemaToDatabaseCommand;
import org.apache.ddlutils.task.WriteSchemaToFileCommand;

public class DdlUtilsTest
extends JdbcTestBase {
    public DdlUtilsTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testBug51732() throws Throwable {
        Properties props = new Properties();
        props.setProperty("log-level", "config");
        DdlUtilsTest.setupConnection(props);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        String clientUrl = DdlUtilsTest.startNetServer(netPort, null);
        Connection conn = jdbcConn;
        Connection netConn = DdlUtilsTest.getNetConnection(netPort, null, null);
        String schemaGFXDile = "TestSchema.sql";
        String schema = null;
        DdlUtilsTest.runImportExportTest_Create(conn, netConn, 100, 65000, schema);
        String[] commonArgs = new String[]{"write-schema-to-sql", "-driver-class=com.pivotal.gemfirexd.jdbc.ClientDriver", "-url=jdbc:gemfirexd://" + clientUrl, "-file=TestSchema.sql", "-to-database-type=gemfirexd"};
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(commonArgs));
        if (currentUserName != null) {
            args.add("-user=" + currentUserName);
            args.add("-password=" + currentUserPassword);
        }
        GfxdDdlUtils.main((String[])args.toArray(new String[args.size()]));
    }

    public void testSchemaCreation() throws Throwable {
        Properties props = new Properties();
        props.setProperty("log-level", "config");
        DdlUtilsTest.setupConnection(props);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        String clientUrl = DdlUtilsTest.startNetServer(netPort, null);
        Connection conn = jdbcConn;
        Connection netConn = DdlUtilsTest.getNetConnection(netPort, null, null);
        DdlUtilsTest.runImportExportTest(conn, netConn, clientUrl, currentUserName, currentUserPassword, 100, 65000, null);
    }

    public void testFKAutoGenRewrite() throws Throwable {
        Properties props = new Properties();
        props.setProperty("table-default-partitioned", "true");
        props.setProperty("log-level", "config");
        DdlUtilsTest.setupConnection(props);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        String clientUrl = DdlUtilsTest.startNetServer(netPort, null);
        Connection netConn = DdlUtilsTest.getNetConnection(netPort, null, null);
        String[] clientHost = clientUrl.split(":");
        DdlUtilsTest.runImportExportFKTest(netConn, clientHost[0], netPort, currentUserName, currentUserPassword, 100, 65000, true, false, false);
    }

    public void testFKAlterIdentityColumns() throws Throwable {
        Properties props = new Properties();
        props.setProperty("table-default-partitioned", "true");
        props.setProperty("log-level", "config");
        DdlUtilsTest.setupConnection(props);
        int netPort = AvailablePort.getRandomAvailablePort((int)0);
        String clientUrl = DdlUtilsTest.startNetServer(netPort, null);
        Connection netConn = DdlUtilsTest.getNetConnection(netPort, null, null);
        String[] clientHost = clientUrl.split(":");
        DdlUtilsTest.runImportExportFKTest(netConn, clientHost[0], netPort, currentUserName, currentUserPassword, 100, 65000, true, true, true);
    }

    public static void main(String[] args) throws Throwable {
        if (args.length != 4) {
            System.err.println("expected args: <host:port> <alterIdentity(BOOLEAN)> <numEntries> <rowSize>");
            System.exit(1);
            return;
        }
        Connection conn = DriverManager.getConnection("jdbc:gemfirexd://" + args[0]);
        String[] clientUrl = args[0].split(":");
        int port = Integer.parseInt(clientUrl[1]);
        DdlUtilsTest.runImportExportFKTest(conn, clientUrl[0], port, null, null, Integer.parseInt(args[2]), Integer.parseInt(args[3]), true, Boolean.parseBoolean(args[1]), false);
    }

    public static void runImportExportTest(Connection conn, Connection netConn, String clientUrl, String userName, String password, int numEntries, int rowSize, VM vm1) throws Throwable {
        String schemaFileName = "TestSchema.xml";
        String schemaGFXDile = "TestSchema.sql";
        String schemaGFXDile2 = "TestSchema2.sql";
        String dataFileName = "TestSchema-data.xml";
        String schema1 = null;
        String schema2 = "EMP";
        String schema3 = "TEST";
        DdlUtilsTest.runImportExportTest_Create(conn, netConn, numEntries, rowSize, schema1);
        DdlUtilsTest.runImportExportTest_Create(conn, netConn, numEntries, rowSize, "EMP");
        DdlUtilsTest.runImportExportTest_Create(conn, netConn, numEntries, rowSize, "TEST");
        DdlUtilsTest.runImportExportTest_Export(clientUrl, userName, password, "TestSchema.xml", "TestSchema-data.xml");
        DdlUtilsTest.runImportExportTest_Drop(conn, "TEST", "");
        DdlUtilsTest.runImportExportTest_Drop(conn, "EMP", "");
        DdlUtilsTest.runImportExportTest_Drop(conn, schema1, "");
        DdlUtilsTest.runImportExportTest_ImportFail(netConn, clientUrl, userName, password, rowSize, schema1, "TestSchema.xml", "TestSchema-data.xml");
        DdlUtilsTest.runImportExportTest_Drop(conn, "TEST", "film_");
        DdlUtilsTest.runImportExportTest_Drop(conn, "EMP", "film_");
        DdlUtilsTest.runImportExportTest_Drop(conn, schema1, "film_");
        DdlUtilsTest.runImportExportTest_Import(netConn, clientUrl, userName, password, "TestSchema.xml", "TestSchema-data.xml");
        DdlUtilsTest.runImportExportTest_Check(netConn, numEntries, rowSize, schema1, "TestSchema.xml", "TestSchema-data.xml");
        DdlUtilsTest.runImportExportTest_Check(netConn, numEntries, rowSize, "EMP", "TestSchema.xml", "TestSchema-data.xml");
        DdlUtilsTest.runImportExportTest_Check(netConn, numEntries, rowSize, "TEST", "TestSchema.xml", "TestSchema-data.xml");
        DdlUtilsTest.runImportExportTest_Schema_Export(clientUrl, userName, password, "TestSchema.sql", false);
        DdlUtilsTest.runImportExportTest_Drop(netConn, "TEST", "film_");
        DdlUtilsTest.runImportExportTest_Drop(netConn, "EMP", "film_");
        DdlUtilsTest.runImportExportTest_Drop(netConn, schema1, "film_");
        DdlUtilsTest.runImportExportTest_Schema_Import(conn, "TestSchema.sql");
        DdlUtilsTest.runImportExportTest_Schema_Check(netConn, schema1, false);
        DdlUtilsTest.runImportExportTest_Schema_Check(netConn, "EMP", false);
        DdlUtilsTest.runImportExportTest_Schema_Check(netConn, "TEST", false);
        DdlUtilsTest.runImportExportTest_Create_Extensions(conn);
        DdlUtilsTest.runImportExportTest_Schema_Export(clientUrl, userName, password, "TestSchema2.sql", true);
        DdlUtilsTest.runImportExportTest_Drop(netConn, "TEST", "film_");
        DdlUtilsTest.runImportExportTest_Drop(netConn, "EMP", "film_");
        DdlUtilsTest.runImportExportTest_Drop(netConn, schema1, "film_");
        DdlUtilsTest.runImportExportTest_Drop_Extensions(conn, vm1 == null);
        DdlUtilsTest.runImportExportTest_Schema_Import(conn, "TestSchema2.sql");
        if (vm1 == null) {
            DdlUtilsTest.runImportExportTest_Schema_Check(netConn, schema1, true);
        } else {
            vm1.invoke(DdlUtilsTest.class, "runImportExportTest_Schema_Check", new Object[]{null, schema1, true});
        }
        DdlUtilsTest.runImportExportTest_Schema_Check(netConn, "EMP", false);
        DdlUtilsTest.runImportExportTest_Schema_Check(netConn, "TEST", false);
        DdlUtilsTest.runImportExportTest_Drop_Extensions(conn, vm1 == null);
        new File("TestSchema-data.xml").delete();
        new File("TestSchema.xml").delete();
        new File("TestSchema.sql").delete();
        new File("TestSchema2.sql").delete();
    }

    static void runImportExportTest_Create(Connection conn, Connection netConn, int numEntries, int rowSize, String schema) throws Throwable {
        String schemaPrefix = schema != null ? schema + '.' : "";
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE " + schemaPrefix + "language (" + "language_id smallint NOT NULL," + "language_name varchar(20) NOT NULL, PRIMARY KEY (language_id))");
        stmt.execute("CREATE TABLE " + schemaPrefix + "film (" + "film_id smallint NOT NULL," + "title varchar(255) NOT NULL, description clob," + "release_year date DEFAULT NULL, language_id smallint NOT NULL," + "original_language_id smallint DEFAULT NULL," + "rental_duration smallint NOT NULL DEFAULT 3," + "rental_rate decimal(4,2) NOT NULL DEFAULT 4.99," + "length smallint DEFAULT NULL," + "replacement_cost decimal(5,2) NOT NULL DEFAULT 19.99," + "rating char(8) DEFAULT 'G'," + "special_features varchar(20) DEFAULT NULL," + "last_update timestamp DEFAULT CURRENT_TIMESTAMP," + "PRIMARY KEY (film_id), " + "CONSTRAINT ck_rating CHECK (rating in ('G', 'PG', 'PG-13', " + "  'R', 'NC-17')), " + "CONSTRAINT ck_special CHECK (special_features in ('Trailers'," + "  'Commentaries','Deleted Scenes','Behind the Scenes')), " + "CONSTRAINT fk_film_language FOREIGN KEY (language_id) " + "  REFERENCES " + schemaPrefix + "language (language_id), " + "CONSTRAINT fk_film_language_original FOREIGN KEY " + "  (original_language_id) REFERENCES language (language_id))");
        stmt.execute("CREATE INDEX " + schemaPrefix + "idx1 on " + schemaPrefix + "film(title)");
        ResultSet rs = netConn.getMetaData().getIndexInfo(null, schema, "FILM", false, false);
        boolean foundIdx1 = false;
        boolean foundIdx2 = false;
        while (rs.next()) {
            if (!"TITLE".equals(rs.getString("COLUMN_NAME"))) continue;
            DdlUtilsTest.assertEquals((String)"IDX1", (String)rs.getString("INDEX_NAME"));
            foundIdx1 = true;
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        rs = netConn.getMetaData().getImportedKeys(null, schema, "FILM");
        while (rs.next()) {
            if (!"fk_film_language_original".equalsIgnoreCase(rs.getString("FK_NAME"))) continue;
            DdlUtilsTest.assertEquals((String)TestUtil.getCurrentDefaultSchemaName(), (String)rs.getString("PKTABLE_SCHEM"));
            DdlUtilsTest.assertEquals((String)"LANGUAGE", (String)rs.getString("PKTABLE_NAME"));
            DdlUtilsTest.assertEquals((String)"LANGUAGE_ID", (String)rs.getString("PKCOLUMN_NAME"));
            DdlUtilsTest.assertEquals((String)"ORIGINAL_LANGUAGE_ID", (String)rs.getString("FKCOLUMN_NAME"));
            foundIdx2 = true;
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        DdlUtilsTest.assertTrue((boolean)foundIdx1);
        DdlUtilsTest.assertTrue((boolean)foundIdx2);
        int numLanguages = 10;
        for (int langId = 1; langId <= 10; ++langId) {
            stmt.execute("insert into " + schemaPrefix + "language values (" + langId + ", 'lang" + langId + "')");
        }
        PreparedStatement pstmt = netConn.prepareStatement("insert into " + schemaPrefix + "film (film_id, title, description, language_id, " + "original_language_id) values (?, ?, ?, ?, ?)");
        char[] desc = new char[rowSize];
        for (int id = 1; id <= numEntries; ++id) {
            pstmt.setInt(1, id);
            pstmt.setString(2, "film" + id);
            for (int index = 0; index < desc.length; ++index) {
                desc[index] = (char)(60 + index % 32);
            }
            pstmt.setString(3, new String(desc));
            pstmt.setInt(4, id % 10 + 1);
            pstmt.setInt(5, (id + 2) % 10 + 1);
            pstmt.addBatch();
            if (id == numEntries || id % 1000 != 0) continue;
            pstmt.executeBatch();
        }
        pstmt.executeBatch();
    }

    static void runImportExportTest_Export(String clientUrl, String userName, String password, String schemaFileName, String dataFileName) throws Throwable {
        String dbtype = new PlatformUtils().determineDatabaseType("com.pivotal.gemfirexd.jdbc.ClientDriver", "jdbc:gemfirexd://" + clientUrl);
        DdlUtilsTest.getLogger().info((Object)("DB TYPE = " + dbtype));
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.pivotal.gemfirexd.jdbc.ClientDriver");
        dataSource.setUrl("jdbc:gemfirexd://" + clientUrl);
        if (userName != null) {
            dataSource.setUsername(userName);
            dataSource.setPassword(password);
        }
        DatabaseToDdlTask fromDBTask = new DatabaseToDdlTask();
        fromDBTask.addConfiguredDatabase(dataSource);
        fromDBTask.setDatabaseType(dbtype);
        WriteSchemaToFileCommand writeSchemaToFile = new WriteSchemaToFileCommand();
        File schemaFile = new File(schemaFileName);
        writeSchemaToFile.setFailOnError(true);
        writeSchemaToFile.setOutputFile(schemaFile);
        WriteDataToFileCommand writeDataToFile = new WriteDataToFileCommand();
        File dataFile = new File(dataFileName);
        writeDataToFile.setFailOnError(true);
        writeDataToFile.setOutputFile(dataFile);
        fromDBTask.addWriteSchemaToFile(writeSchemaToFile);
        fromDBTask.addWriteDataToFile(writeDataToFile);
        fromDBTask.execute();
        dataSource.close();
    }

    static void runImportExportTest_Drop(Connection conn, String schema, String indexPrefix) throws Throwable {
        String schemaPrefix = schema != null ? schema + '.' : "";
        Statement stmt = conn.createStatement();
        stmt.execute("drop index " + schemaPrefix + indexPrefix + "idx1");
        stmt.execute("drop table " + schemaPrefix + "film");
        stmt.execute("drop table " + schemaPrefix + "language");
    }

    static void runImportExportTest_ImportFail(Connection netConn, String clientUrl, String userName, String password, int rowSize, String schema, String schemaFileName, String dataFileName) throws Throwable {
        int id;
        BasicDataSource dataSource;
        Statement stmt;
        String schemaPrefix;
        block5: {
            schemaPrefix = schema != null ? schema + '.' : "";
            stmt = netConn.createStatement();
            char[] desc = new char[rowSize];
            dataSource = new BasicDataSource();
            dataSource.setDriverClassName("com.pivotal.gemfirexd.jdbc.ClientDriver");
            dataSource.setUrl("jdbc:gemfirexd://" + clientUrl);
            if (userName != null) {
                dataSource.setUsername(userName);
                dataSource.setPassword(password);
            }
            DdlToDatabaseTask toDBTask = new DdlToDatabaseTask();
            toDBTask.addConfiguredDatabase(dataSource);
            File schemaFile = new File(schemaFileName);
            toDBTask.setSchemaFile(schemaFile);
            WriteSchemaToDatabaseCommand writeSchemaToDB = new WriteSchemaToDatabaseCommand();
            writeSchemaToDB.setAlterDatabase(true);
            writeSchemaToDB.setFailOnError(true);
            toDBTask.addWriteSchemaToDatabase(writeSchemaToDB);
            toDBTask.execute();
            WriteDataToDatabaseCommand writeDataToDB = new WriteDataToDatabaseCommand();
            File dataFile = new File(dataFileName);
            writeDataToDB.setIsolationLevel(2);
            writeDataToDB.setUseBatchMode(true);
            writeDataToDB.setBatchSize(1000);
            writeDataToDB.setDataFile(dataFile);
            writeDataToDB.setFailOnError(true);
            id = 10;
            stmt.execute("insert into " + schemaPrefix + "language values (" + id + ", 'lang" + id + "')");
            PreparedStatement pstmt = netConn.prepareStatement("insert into " + schemaPrefix + "film (film_id, title, description, language_id, " + "original_language_id) values (?, ?, ?, ?, ?)");
            pstmt.setInt(1, id);
            pstmt.setString(2, "film" + id);
            for (int index = 0; index < desc.length; ++index) {
                desc[index] = (char)(60 + index % 32);
            }
            pstmt.setString(3, new String(desc));
            pstmt.setInt(4, id);
            pstmt.setInt(5, id);
            pstmt.execute();
            toDBTask = new DdlToDatabaseTask();
            toDBTask.addConfiguredDatabase(dataSource);
            toDBTask.setSchemaFile(schemaFile);
            toDBTask.addWriteDataToDatabase(writeDataToDB);
            try {
                toDBTask.execute();
                DdlUtilsTest.fail("expected constraint violation");
            }
            catch (Throwable t) {
                while (t.getCause() != null && !(t instanceof SQLException)) {
                    t = t.getCause();
                }
                if (t instanceof SQLException && "23505".equals(((SQLException)t).getSQLState())) break block5;
                throw t;
            }
        }
        DdlUtilsTest.assertEquals((int)1, (int)stmt.executeUpdate("delete from " + schemaPrefix + "film where film_id=" + id));
        DdlUtilsTest.assertEquals((int)1, (int)stmt.executeUpdate("delete from " + schemaPrefix + "language where language_id=" + id));
        dataSource.close();
    }

    static void runImportExportTest_Import(Connection netConn, String clientUrl, String userName, String password, String schemaFileName, String dataFileName) throws Throwable {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName("com.pivotal.gemfirexd.jdbc.ClientDriver");
        dataSource.setUrl("jdbc:gemfirexd://" + clientUrl);
        if (userName != null) {
            dataSource.setUsername(userName);
            dataSource.setPassword(password);
        }
        DdlToDatabaseTask toDBTask = new DdlToDatabaseTask();
        toDBTask.addConfiguredDatabase(dataSource);
        File schemaFile = new File(schemaFileName);
        toDBTask.setSchemaFile(schemaFile);
        WriteSchemaToDatabaseCommand writeSchemaToDB = new WriteSchemaToDatabaseCommand();
        writeSchemaToDB.setAlterDatabase(true);
        writeSchemaToDB.setFailOnError(true);
        toDBTask.addWriteSchemaToDatabase(writeSchemaToDB);
        toDBTask.execute();
        WriteDataToDatabaseCommand writeDataToDB = new WriteDataToDatabaseCommand();
        File dataFile = new File(dataFileName);
        writeDataToDB.setIsolationLevel(2);
        writeDataToDB.setUseBatchMode(true);
        writeDataToDB.setBatchSize(1000);
        writeDataToDB.setDataFile(dataFile);
        writeDataToDB.setFailOnError(true);
        toDBTask = new DdlToDatabaseTask();
        toDBTask.addConfiguredDatabase(dataSource);
        toDBTask.setSchemaFile(schemaFile);
        toDBTask.addWriteDataToDatabase(writeDataToDB);
        toDBTask.execute();
        dataSource.close();
    }

    static void runImportExportTest_Check(Connection netConn, int numEntries, int rowSize, String schema, String schemaFileName, String dataFileName) throws Throwable {
        String schemaPrefix = schema != null ? schema + '.' : "";
        int numLanguages = 10;
        char[] desc = new char[rowSize];
        Statement netStmt = netConn.createStatement();
        ResultSet rs = netStmt.executeQuery("select * from " + schemaPrefix + "language order by language_id");
        for (int langId = 1; langId <= 10; ++langId) {
            DdlUtilsTest.assertTrue((boolean)rs.next());
            DdlUtilsTest.assertEquals((int)langId, (int)rs.getInt(1));
            DdlUtilsTest.assertEquals((String)("lang" + langId), (String)rs.getString(2));
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        rs = netStmt.executeQuery("select film_id, title, description, language_id, original_language_id from " + schemaPrefix + "film order by film_id");
        for (int id = 1; id <= numEntries; ++id) {
            DdlUtilsTest.assertTrue((boolean)rs.next());
            DdlUtilsTest.assertEquals((int)id, (int)rs.getInt(1));
            DdlUtilsTest.assertEquals((String)("film" + id), (String)rs.getString(2));
            for (int index = 0; index < desc.length; ++index) {
                desc[index] = (char)(60 + index % 32);
            }
            DdlUtilsTest.assertEquals((String)new String(desc), (String)rs.getString(3));
            DdlUtilsTest.assertEquals((int)(id % 10 + 1), (int)rs.getInt(4));
            DdlUtilsTest.assertEquals((int)((id + 2) % 10 + 1), (int)rs.getInt(5));
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        rs = netConn.getMetaData().getIndexInfo(null, schema, "FILM", false, false);
        boolean foundIdx1 = false;
        boolean foundIdx2 = false;
        while (rs.next()) {
            if (!"TITLE".equals(rs.getString("COLUMN_NAME"))) continue;
            DdlUtilsTest.assertEquals((String)"FILM_IDX1", (String)rs.getString("INDEX_NAME"));
            foundIdx1 = true;
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        rs = netConn.getMetaData().getImportedKeys(null, schema, "FILM");
        while (rs.next()) {
            if (!"fk_film_language_original".equalsIgnoreCase(rs.getString("FK_NAME"))) continue;
            DdlUtilsTest.assertEquals((String)TestUtil.getCurrentDefaultSchemaName(), (String)rs.getString("PKTABLE_SCHEM"));
            DdlUtilsTest.assertEquals((String)"LANGUAGE", (String)rs.getString("PKTABLE_NAME"));
            DdlUtilsTest.assertEquals((String)"LANGUAGE_ID", (String)rs.getString("PKCOLUMN_NAME"));
            DdlUtilsTest.assertEquals((String)"ORIGINAL_LANGUAGE_ID", (String)rs.getString("FKCOLUMN_NAME"));
            foundIdx2 = true;
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        DdlUtilsTest.assertTrue((boolean)foundIdx1);
        DdlUtilsTest.assertTrue((boolean)foundIdx2);
    }

    static void runImportExportTest_Schema_Export(String clientUrl, String userName, String password, String schemaSQL, boolean gfxdExtensions) {
        String[] commonArgs = new String[]{"write-schema-to-sql", "-driver-class=com.pivotal.gemfirexd.jdbc.ClientDriver", "-url=jdbc:gemfirexd://" + clientUrl, "-file=" + schemaSQL};
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(commonArgs));
        if (gfxdExtensions) {
            args.add("-export-all");
        } else {
            args.add("-generic");
        }
        if (userName != null) {
            args.add("-user=" + userName);
            args.add("-password=" + password);
        }
        GfxdDdlUtils.main((String[])args.toArray(new String[args.size()]));
    }

    static void runImportExportTest_Schema_Import(Connection conn, String schemaSQL) throws Exception {
        DdlUtilsTest.addExpectedException(new Object[]{"42Y55", "Exception in execution of command"});
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{new File(schemaSQL).getAbsolutePath()}, (boolean)true, (LogWriter)Misc.getCacheLogWriter(), null, null, (boolean)false);
        DdlUtilsTest.removeExpectedException(new Object[]{"42Y55", "Exception in execution of command"});
    }

    static void runImportExportTest_Create_Extensions(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE language2 (language_id smallint NOT NULL,language_name varchar(20) NOT NULL, PRIMARY KEY (language_name)) PARTITION BY COLUMN (language_id) BUCKETS 73");
        stmt.execute("CREATE TABLE film2 (film_id int NOT NULL GENERATED ALWAYS AS IDENTITY,title varchar(255) NOT NULL, description clob,release_year date DEFAULT NULL, language_id smallint NOT NULL,PRIMARY KEY (film_id)) PARTITION BY COLUMN (language_id) COLOCATE WITH (language2) BUCKETS 73");
        stmt.execute("create diskstore ds1 ('test_ext1')");
    }

    static void runImportExportTest_Drop_Extensions(Connection conn, boolean singleVM) throws SQLException {
        Statement stmt = conn.createStatement();
        stmt.execute("drop table film2");
        stmt.execute("drop table language2");
        if (singleVM) {
            Misc.getGemFireCache().findDiskStore("DS1").destroy();
        } else {
            DistributedTestBase.invokeInEveryVM((SerializableRunnable)new SerializableRunnable(){

                public void run() {
                    GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
                    if (cache != null) {
                        cache.findDiskStore("DS1").destroy();
                    }
                }
            });
        }
    }

    static void runImportExportTest_Schema_Check(Connection conn, String schema, boolean checkGFXDExtensions) throws Exception {
        if (conn == null) {
            conn = DdlUtilsTest.getConnection();
        }
        ResultSet rs = conn.getMetaData().getTables(null, schema, null, new String[]{"TABLE"});
        boolean foundLang = false;
        boolean foundFilm = false;
        boolean foundLang2 = false;
        boolean foundFilm2 = false;
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if ("LANGUAGE".equals(tableName)) {
                foundLang = true;
                continue;
            }
            if ("FILM".equals(tableName)) {
                foundFilm = true;
                continue;
            }
            if ("LANGUAGE2".equals(tableName)) {
                foundLang2 = true;
                continue;
            }
            if (!"FILM2".equals(tableName)) continue;
            foundFilm2 = true;
        }
        DdlUtilsTest.assertTrue((boolean)foundLang);
        DdlUtilsTest.assertTrue((boolean)foundFilm);
        if (checkGFXDExtensions) {
            DdlUtilsTest.assertTrue((boolean)foundLang2);
            DdlUtilsTest.assertTrue((boolean)foundFilm2);
            Region lang2 = Misc.getRegionForTable((String)(TestUtil.getCurrentDefaultSchemaName() + ".LANGUAGE2"), (boolean)true);
            GemFireContainer container = (GemFireContainer)lang2.getUserAttribute();
            int[] pkColumns = container.getExtraTableInfo().getPrimaryKeyColumns();
            DdlUtilsTest.assertNotNull((Object)pkColumns);
            DdlUtilsTest.assertEquals((int)1, (int)pkColumns.length);
            DdlUtilsTest.assertEquals((int)2, (int)pkColumns[0]);
            PartitionAttributes pattrs = lang2.getAttributes().getPartitionAttributes();
            DdlUtilsTest.assertNotNull((Object)pattrs);
            DdlUtilsTest.assertTrue((boolean)(pattrs.getPartitionResolver() instanceof GfxdPartitionByExpressionResolver));
            GfxdPartitionByExpressionResolver resolver = (GfxdPartitionByExpressionResolver)pattrs.getPartitionResolver();
            DdlUtilsTest.assertEquals((int)73, (int)pattrs.getTotalNumBuckets());
            String[] pcols = resolver.getColumnNames();
            DdlUtilsTest.assertNotNull((Object)pcols);
            DdlUtilsTest.assertEquals((int)1, (int)pcols.length);
            DdlUtilsTest.assertEquals((String)"LANGUAGE_ID", (String)pcols[0]);
            Region film2 = Misc.getRegionForTable((String)(TestUtil.getCurrentDefaultSchemaName() + ".FILM2"), (boolean)true);
            container = (GemFireContainer)film2.getUserAttribute();
            pkColumns = container.getExtraTableInfo().getPrimaryKeyColumns();
            DdlUtilsTest.assertNotNull((Object)pkColumns);
            DdlUtilsTest.assertEquals((int)1, (int)pkColumns.length);
            DdlUtilsTest.assertEquals((int)1, (int)pkColumns[0]);
            pattrs = film2.getAttributes().getPartitionAttributes();
            DdlUtilsTest.assertNotNull((Object)pattrs);
            DdlUtilsTest.assertTrue((boolean)(pattrs.getPartitionResolver() instanceof GfxdPartitionByExpressionResolver));
            resolver = (GfxdPartitionByExpressionResolver)pattrs.getPartitionResolver();
            pcols = resolver.getColumnNames();
            DdlUtilsTest.assertNotNull((Object)pcols);
            DdlUtilsTest.assertEquals((int)1, (int)pcols.length);
            DdlUtilsTest.assertEquals((String)"LANGUAGE_ID", (String)pcols[0]);
            DdlUtilsTest.assertEquals((String)("/" + TestUtil.getCurrentDefaultSchemaName() + "/LANGUAGE2"), (String)pattrs.getColocatedWith());
            DdlUtilsTest.assertEquals((int)73, (int)pattrs.getTotalNumBuckets());
            DiskStoreImpl ds = Misc.getGemFireCache().findDiskStore("DS1");
            File[] diskDirs = ds.getDiskDirs();
            DdlUtilsTest.assertNotNull((Object)ds);
            DdlUtilsTest.assertNotNull((Object)diskDirs);
            DdlUtilsTest.assertEquals((int)1, (int)diskDirs.length);
            DdlUtilsTest.assertEquals((String)"test_ext1", (String)diskDirs[0].getName());
        } else {
            DdlUtilsTest.assertFalse((boolean)foundLang2);
            DdlUtilsTest.assertFalse((boolean)foundFilm2);
        }
        rs = conn.getMetaData().getIndexInfo(null, schema, "FILM", false, false);
        boolean foundIdx1 = false;
        boolean foundIdx2 = false;
        while (rs.next()) {
            if (!"TITLE".equals(rs.getString("COLUMN_NAME"))) continue;
            DdlUtilsTest.assertEquals((String)"FILM_IDX1", (String)rs.getString("INDEX_NAME"));
            foundIdx1 = true;
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        rs = conn.getMetaData().getImportedKeys(null, schema, "FILM");
        while (rs.next()) {
            if (!"fk_film_language_original".equalsIgnoreCase(rs.getString("FK_NAME"))) continue;
            DdlUtilsTest.assertEquals((String)TestUtil.getCurrentDefaultSchemaName(), (String)rs.getString("PKTABLE_SCHEM"));
            DdlUtilsTest.assertEquals((String)"LANGUAGE", (String)rs.getString("PKTABLE_NAME"));
            DdlUtilsTest.assertEquals((String)"LANGUAGE_ID", (String)rs.getString("PKCOLUMN_NAME"));
            DdlUtilsTest.assertEquals((String)"ORIGINAL_LANGUAGE_ID", (String)rs.getString("FKCOLUMN_NAME"));
            foundIdx2 = true;
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        DdlUtilsTest.assertTrue((boolean)foundIdx1);
        DdlUtilsTest.assertTrue((boolean)foundIdx2);
    }

    public static void runImportExportFKTest(Connection conn, String host, int port, String userName, String password, int numEntries, int rowSize, boolean singleServer, boolean alterIdentityColumns, boolean usePR) throws Throwable {
        ResultSet rs;
        int id;
        Statement stmt = conn.createStatement();
        stmt.execute("drop table if exists film_details");
        stmt.execute("drop table if exists film");
        stmt.execute("drop table if exists language");
        String partStr = usePR ? " PARTITION BY PRIMARY KEY" : " REPLICATE";
        String colocStr = usePR ? " COLOCATE WITH (FILM)" : "";
        stmt.execute("CREATE TABLE language (language_id smallint NOT NULL,language_name varchar(20) NOT NULL, PRIMARY KEY (language_id))" + partStr);
        stmt.execute("CREATE TABLE film (film_id int NOT NULL GENERATED ALWAYS AS IDENTITY,title varchar(255) NOT NULL, description clob,release_year date DEFAULT NULL, language_id smallint NOT NULL,PRIMARY KEY (film_id))" + partStr);
        stmt.execute("CREATE TABLE film_details (film_id int NOT NULL,row_number int NOT NULL,original_language_id smallint DEFAULT NULL,rental_duration smallint NOT NULL DEFAULT 3,rental_rate decimal(4,2) NOT NULL DEFAULT 4.99,length smallint DEFAULT NULL,replacement_cost decimal(5,2) NOT NULL DEFAULT 19.99,rating char(8) DEFAULT 'G',special_features varchar(20) DEFAULT NULL,last_update timestamp DEFAULT CURRENT_TIMESTAMP,PRIMARY KEY (film_id), CONSTRAINT ck_rating CHECK (rating in ('G', 'PG', 'PG-13',   'R', 'NC-17')), CONSTRAINT ck_special CHECK (special_features in ('Trailers',  'Commentaries','Deleted Scenes','Behind the Scenes')), CONSTRAINT fk_film_id FOREIGN KEY (film_id)   REFERENCES film (film_id), CONSTRAINT fk_film_language_original FOREIGN KEY   (original_language_id) REFERENCES language (language_id))" + partStr + colocStr);
        int numLanguages = 10;
        for (int langId = 1; langId <= 10; ++langId) {
            stmt.execute("insert into language values (" + langId + ", 'lang" + langId + "')");
        }
        PreparedStatement pstmt = conn.prepareStatement("insert into film (title, description, language_id) values (?, ?, ?)", 1);
        ArrayList<Integer> filmIds = new ArrayList<Integer>(numEntries);
        char[] desc = new char[rowSize];
        for (id = 1; id <= numEntries; ++id) {
            pstmt.setString(1, "film" + id);
            for (int index = 0; index < desc.length; ++index) {
                desc[index] = (char)(60 + (index + id) % 32);
            }
            pstmt.setString(2, new String(desc));
            pstmt.setInt(3, id % 10 + 1);
            pstmt.execute();
            rs = pstmt.getGeneratedKeys();
            DdlUtilsTest.assertTrue((boolean)rs.next());
            filmIds.add(rs.getInt(1));
            DdlUtilsTest.assertFalse((boolean)rs.next());
        }
        pstmt = conn.prepareStatement("insert into film_details (film_id, row_number, original_language_id) values (?, ?, ?)");
        for (id = 1; id <= numEntries; ++id) {
            pstmt.setInt(1, (Integer)filmIds.get(id - 1));
            pstmt.setInt(2, id);
            pstmt.setInt(3, (id + 2) % 10 + 1);
            pstmt.addBatch();
            if (id == numEntries || id % 1000 != 0) continue;
            pstmt.executeBatch();
        }
        pstmt.executeBatch();
        String schemaFile = "TestSchema.xml";
        String dataFile = "TestSchema-data.xml";
        List<String> commonArgs = userName != null ? Arrays.asList("-client-bind-address=" + host, "-client-port=" + port, "-user=" + userName, "-password=" + password) : Arrays.asList("-client-bind-address=" + host, "-client-port=" + port);
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList("write-schema-to-xml", "-file=TestSchema.xml"));
        args.addAll(commonArgs);
        GfxdDdlUtils.main((String[])args.toArray(new String[args.size()]));
        args.clear();
        args.addAll(Arrays.asList("write-data-to-xml", "-file=TestSchema-data.xml"));
        args.addAll(commonArgs);
        GfxdDdlUtils.main((String[])args.toArray(new String[args.size()]));
        stmt.execute("drop table film_details");
        stmt.execute("drop table film");
        stmt.execute("drop table language");
        args.clear();
        args.addAll(Arrays.asList("write-schema-to-db", "-files=TestSchema.xml"));
        args.addAll(commonArgs);
        if (alterIdentityColumns) {
            args.add("-alter-identity-columns");
        }
        GfxdDdlUtils.main((String[])args.toArray(new String[args.size()]));
        args.clear();
        args.addAll(Arrays.asList("write-data-to-db", "-files=TestSchema-data.xml"));
        args.addAll(commonArgs);
        if (alterIdentityColumns) {
            args.add("-alter-identity-columns");
            args.add("-ensure-fk-order=false");
            args.add("-batch-size=20");
        } else {
            args.add("-schema-files=TestSchema.xml");
            args.add("-batch-size=1");
        }
        GfxdDdlUtils.main((String[])args.toArray(new String[args.size()]));
        Statement netStmt = conn.createStatement();
        rs = netStmt.executeQuery("select * from language order by language_id");
        for (int langId = 1; langId <= 10; ++langId) {
            DdlUtilsTest.assertTrue((boolean)rs.next());
            DdlUtilsTest.assertEquals((int)langId, (int)rs.getInt(1));
            DdlUtilsTest.assertEquals((String)("lang" + langId), (String)rs.getString(2));
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        TreeSet<Integer> allFilmIds = new TreeSet<Integer>();
        rs = netStmt.executeQuery("select f.film_id, title, description, language_id, row_number from film f, film_details d where f.film_id = d.film_id order by row_number");
        for (id = 1; id <= numEntries; ++id) {
            int fId;
            DdlUtilsTest.assertTrue((boolean)rs.next());
            DdlUtilsTest.assertTrue((boolean)allFilmIds.add(rs.getInt(1)));
            if (alterIdentityColumns) {
                DdlUtilsTest.assertEquals((String)("film" + id), (String)rs.getString(2));
                fId = id;
            } else {
                String filmId = rs.getString(2);
                fId = Integer.parseInt(filmId.substring(4));
            }
            for (int index = 0; index < desc.length; ++index) {
                desc[index] = (char)(60 + (index + fId) % 32);
            }
            DdlUtilsTest.assertEquals((String)new String(desc), (String)rs.getString(3));
            DdlUtilsTest.assertEquals((int)(fId % 10 + 1), (int)rs.getInt(4));
            DdlUtilsTest.assertEquals((int)id, (int)rs.getInt(5));
        }
        DdlUtilsTest.assertFalse((boolean)rs.next());
        if (singleServer) {
            DdlUtilsTest.assertEquals((int)(numEntries - 1), (int)((Integer)allFilmIds.last() - (Integer)allFilmIds.first()));
        }
        if (alterIdentityColumns) {
            DdlUtilsTest.assertEquals((int)filmIds.size(), (int)allFilmIds.size());
            DdlUtilsTest.assertTrue((boolean)allFilmIds.containsAll(filmIds));
        }
        new File("TestSchema-data.xml").delete();
        new File("TestSchema.xml").delete();
    }
}

