/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.internal.AvailablePort;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.jdbc.SimpleAppTest;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DataAwareProcedureTest
extends JdbcTestBase {
    private volatile boolean exceptionOccured = false;

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(SimpleAppTest.class));
    }

    public DataAwareProcedureTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    private void populateTable(Connection conn) throws Exception {
        String INSERTER = "insert into hourly (name, date, value) values (?, ?, ?)";
        int BATCHSIZE = 1000;
        int RECORDS = 10000;
        Calendar cal = Calendar.getInstance();
        Timestamp currentDate = new Timestamp(cal.getTimeInMillis());
        String name = "randomName";
        int j = 0;
        int t = 0;
        PreparedStatement preppedStmt = conn.prepareStatement(INSERTER);
        for (int i = 0; i < RECORDS / BATCHSIZE; ++i) {
            while (j < BATCHSIZE) {
                int value = t % 24;
                preppedStmt.setString(1, name);
                preppedStmt.setTimestamp(2, currentDate);
                preppedStmt.setFloat(3, value);
                preppedStmt.addBatch();
                ++j;
                ++t;
                cal.add(11, 1);
                currentDate.setTime(cal.getTimeInMillis());
            }
            preppedStmt.executeBatch();
            j = 0;
        }
        preppedStmt.close();
    }

    public void testBug46553() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE HOURLY (NAME VARCHAR(20), DATE TIMESTAMP, VALUE FLOAT) PARTITION BY COLUMN (NAME)");
        st.execute("CREATE TABLE DAILY (NAME VARCHAR(20), DATE TIMESTAMP, VALUE FLOAT, MAXV FLOAT, MINV FLOAT) PARTITION BY COLUMN (NAME) COLOCATE with (HOURLY)");
        this.populateTable(conn);
        st.execute("CREATE PROCEDURE ROLLUP() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Rollup.Test1'");
        CallableStatement cs = conn.prepareCall("CALL ROLLUP() ON TABLE HOURLY");
        cs.execute();
    }

    public void testBug46554() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE HOURLY (NAME VARCHAR(20), DATE TIMESTAMP, VALUE FLOAT) PARTITION BY COLUMN (NAME)");
        st.execute("CREATE TABLE DAILY (NAME VARCHAR(20), DATE TIMESTAMP, VALUE FLOAT, MAXV FLOAT, MINV FLOAT) PARTITION BY COLUMN (NAME) COLOCATE with (HOURLY)");
        this.populateTable(conn);
        st.execute("CREATE PROCEDURE ROLLUP() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Rollup.Test2'");
        CallableStatement cs = conn.prepareCall("CALL ROLLUP() ON TABLE HOURLY");
        cs.execute();
    }

    public void testBug46556() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE HOURLY (NAME VARCHAR(20), DATE TIMESTAMP, VALUE FLOAT) PARTITION BY COLUMN (NAME)");
        st.execute("CREATE TABLE DAILY (NAME VARCHAR(20), DATE TIMESTAMP, VALUE FLOAT, MAXV FLOAT, MINV FLOAT) PARTITION BY COLUMN (NAME) COLOCATE with (HOURLY)");
        this.populateTable(conn);
        st.execute("CREATE PROCEDURE ROLLUP() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Rollup.Test3'");
        CallableStatement cs = conn.prepareCall("CALL ROLLUP() ON TABLE HOURLY");
        cs.execute();
    }

    public void testBug49947() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE HOURLY (NAME VARCHAR(20), DATE TIMESTAMP, VALUE FLOAT) PARTITION BY COLUMN (NAME)");
        st.execute("CREATE TABLE DAILY (NAME VARCHAR(20), DATE TIMESTAMP, VALUE FLOAT, MAXV FLOAT, MINV FLOAT) PARTITION BY COLUMN (NAME) COLOCATE with (HOURLY)");
        st.execute("CREATE PROCEDURE ROLLUP() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Rollup.Test3'");
        st.execute("CREATE TRIGGER mt AFTER UPDATE OF value ON daily REFERENCING NEW AS updatedrow FOR EACH ROW CALL rollup() ON TABLE hourly");
        DataAwareProcedureTest.shutDown();
        conn = TestUtil.getConnection();
    }
}

