/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.sql.catalog.DistributionDescriptor;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class CreateTableOtherAttributesTest
extends JdbcTestBase {
    char fileSeparator = System.getProperty("file.separator").charAt(0);

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(CreateTableOtherAttributesTest.class));
    }

    public CreateTableOtherAttributesTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        DistributionDescriptor.TEST_BYPASS_DATASTORE_CHECK = true;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        DistributionDescriptor.TEST_BYPASS_DATASTORE_CHECK = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistentDirAttributesForDataStore() throws Exception {
        Region rgn;
        Connection conn = CreateTableOtherAttributesTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        File file1 = new File("." + this.fileSeparator + "a" + this.fileSeparator + "b" + this.fileSeparator + "c" + this.fileSeparator);
        File file2 = new File("." + this.fileSeparator + "a" + this.fileSeparator + "b" + this.fileSeparator + "d" + this.fileSeparator);
        file1.mkdirs();
        file2.mkdirs();
        File[] expectedDirs = new File[]{file1, file2};
        s.execute("create diskstore teststore ('" + file1.getPath().substring(2) + "','" + file2.getPath().substring(2) + "')");
        String persistentSuffix = "PERSISTENT 'teststore' ";
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   partition by range (cid) (VALUES BETWEEN 0.0 AND 99.0)  " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                CreateTableOtherAttributesTest.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateTableOtherAttributesTest.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                CreateTableOtherAttributesTest.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateTableOtherAttributesTest.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) partition by primary key   " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                CreateTableOtherAttributesTest.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateTableOtherAttributesTest.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid)) partition by column (cust_name)  " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                CreateTableOtherAttributesTest.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateTableOtherAttributesTest.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))PARTITION BY LIST ( tid ) ( VALUES (10, 20 ), VALUES (50, 60), VALUES (12, 34, 45)) " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_PARTITION);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                CreateTableOtherAttributesTest.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateTableOtherAttributesTest.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid int , cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))PARTITION BY column ( cid )  " + persistentSuffix);
        s.execute("create table trade.orders (oid decimal(30, 20), amount int,  tid int, cid int, primary key (oid))PARTITION BY column ( cid )  colocate with ( trade.customers) " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_PARTITION);
            rgn = Misc.getRegionForTable((String)"TRADE.ORDERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_PARTITION);
        }
        finally {
            s.execute("drop table trade.orders");
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                CreateTableOtherAttributesTest.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateTableOtherAttributesTest.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid int , cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))PARTITION BY column ( cid )  " + persistentSuffix);
        s.execute("create table trade.orders (oid decimal(30, 20), amount int,  tid int, cid int, primary key (oid))PARTITION BY column ( cid )  colocate with ( trade.customers) ");
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_PARTITION);
            rgn = Misc.getRegionForTable((String)"TRADE.ORDERS", (boolean)true);
            this.verify(rgn, null, DataPolicy.PARTITION);
        }
        finally {
            s.execute("drop table trade.orders");
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                CreateTableOtherAttributesTest.deleteDir(file);
            }
        }
        for (File file : expectedDirs) {
            file.mkdirs();
            CreateTableOtherAttributesTest.assertTrue((boolean)file.exists());
        }
        s.execute("create table trade.customers (cid decimal(30, 20), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))replicate " + persistentSuffix);
        try {
            rgn = Misc.getRegionForTable((String)"TRADE.CUSTOMERS", (boolean)true);
            this.verify(rgn, expectedDirs, DataPolicy.PERSISTENT_REPLICATE);
        }
        finally {
            s.execute("drop table trade.customers");
            for (File file : expectedDirs) {
                CreateTableOtherAttributesTest.deleteDir(file);
            }
        }
    }

    public void testIllegalTableAttributes() throws Exception {
        Statement s;
        Connection conn;
        try {
            conn = CreateTableOtherAttributesTest.getConnection();
            s = conn.createStatement();
            s.execute("CREATE TABLE BAD1(COL1 INTEGER) BUCKETS 11 REPLICATE");
            CreateTableOtherAttributesTest.fail("CREATE TABLE should have failed as illegal");
        }
        catch (SQLException e) {
            CreateTableOtherAttributesTest.assertEquals((String)e.getSQLState(), (String)"X0Y90");
        }
        try {
            conn = CreateTableOtherAttributesTest.getConnection();
            s = conn.createStatement();
            s.execute("CREATE TABLE BAD1(COL1 INTEGER) MAXPARTSIZE 100 REPLICATE");
            CreateTableOtherAttributesTest.fail("CREATE TABLE should have failed as illegal");
        }
        catch (SQLException e) {
            CreateTableOtherAttributesTest.assertEquals((String)e.getSQLState(), (String)"X0Y90");
        }
        try {
            conn = CreateTableOtherAttributesTest.getConnection();
            s = conn.createStatement();
            s.execute("CREATE TABLE BAD1(COL1 INTEGER) RECOVERYDELAY 11 REPLICATE");
            CreateTableOtherAttributesTest.fail("CREATE TABLE should have failed as illegal");
        }
        catch (SQLException e) {
            CreateTableOtherAttributesTest.assertEquals((String)e.getSQLState(), (String)"X0Y90");
        }
        try {
            conn = CreateTableOtherAttributesTest.getConnection();
            s = conn.createStatement();
            s.execute("CREATE TABLE BAD1(COL1 INTEGER) REDUNDANCY 2 REPLICATE");
            CreateTableOtherAttributesTest.fail("CREATE TABLE should have failed as illegal");
        }
        catch (SQLException e) {
            CreateTableOtherAttributesTest.assertEquals((String)e.getSQLState(), (String)"X0Y90");
        }
        try {
            conn = CreateTableOtherAttributesTest.getConnection();
            s = conn.createStatement();
            s.execute("CREATE TABLE BAD1(COL1 INTEGER) PARTITION BY COLUMN(COL1) REPLICATE");
            CreateTableOtherAttributesTest.fail("CREATE TABLE should have failed as illegal");
        }
        catch (SQLException e) {
            CreateTableOtherAttributesTest.assertEquals((String)e.getSQLState(), (String)"X0Y90");
        }
        try {
            conn = CreateTableOtherAttributesTest.getConnection();
            s = conn.createStatement();
            s.execute("CREATE TABLE BAD1(COL1 INTEGER) REPLICATE BUCKETS 100");
            CreateTableOtherAttributesTest.fail("CREATE TABLE should have failed as illegal");
        }
        catch (SQLException e) {
            CreateTableOtherAttributesTest.assertEquals((String)e.getSQLState(), (String)"X0Y90");
        }
    }

    public void testCreateTableDDLUnitTest() throws Exception {
        Object[][] CreateTableUT = new String[][]{{"CREATE TABLE TA1 (COL1 INTEGER NOT NULL PRIMARY KEY) PARTITION BY PRIMARY KEY", null}, {"CREATE TABLE TA2 (COL1 INTEGER NOT NULL) PARTITION BY COLUMN(COL1) COLOCATE WITH (TA1)", null}, {"DROP TABLE TA1", "X0Y98"}, {"DROP TABLE TA2", null}, {"DROP TABLE TA1", null}, {"CREATE TABLE TB1 (X1 VARCHAR(15)) BUCKETS 10 REPLICATE", "X0Y90"}, {"CREATE TABLE TB2 (X1 VARCHAR(15)) REPLICATE BUCKETS 10", "X0Y90"}, {"CREATE TABLE TB3 (X1 VARCHAR(15)) PARTITION BY COLUMN(X1) BUCKETS 10 REPLICATE", "X0Y90"}, {"CREATE TABLE TB4 (X1 VARCHAR(15)) BUCKETS 10 PARTITION BY COLUMN(X1) REPLICATE", "X0Y90"}, {"CREATE TABLE TB5 (X1 VARCHAR(15)) REPLICATE PARTITION BY COLUMN(X1) MAXPARTSIZE 100", "X0Y90"}, {"CREATE TABLE TC1 (COL1 DECIMAL(5,2) NOT NULL) PARTITION BY COLUMN(COL1) BUCKETS 73 MAXPARTSIZE 200 RECOVERYDELAY 100", null}, {"CREATE TABLE TD1 (C1 INTEGER, C2 SMALLINT, C3 BIGINT NOT NULL PRIMARY KEY) PARTITION BY PRIMARY KEY PARTITION BY COLUMN(COL1)", "42Y49"}, {"CREATE TABLE TD2 (C1 INTEGER, C2 SMALLINT, C3 BIGINT NOT NULL PRIMARY KEY) PARTITION BY COLUMN(COL1) PARTITION BY COLUMN(COL2)", "42Y49"}, {"CREATE TABLE TD3 (C1 INTEGER, C2 SMALLINT, C3 BIGINT NOT NULL PRIMARY KEY) PARTITION BY COLUMN(COL2) PARTITION BY LIST (COL2) (VALUES (1), VALUES(100))", "42Y49"}, {"CREATE TABLE TD4 (C1 INTEGER, C2 SMALLINT, C3 BIGINT NOT NULL PRIMARY KEY) PARTITION BY LIST (COL2) (VALUES (1), VALUES(100)) PARTITION BY (ABS(C3))", "42Y49"}, {"CREATE TABLE TE1 (C1 INTEGER NOT NULL) PARTITION BY PRIMARY KEY", "X0Y97"}, {"CREATE TABLE TE2 (\"PRIMARY KEY\" INTEGER NOT NULL) PARTITION BY PRIMARY KEY", "X0Y97"}, {"CREATE TABLE TE3 (\"PRIMARY KEY\" INTEGER NOT NULL) PARTITION BY COLUMN(\"PRIMARY KEY\")", null}, {"CREATE TABLE TE4 (C1 INTEGER NOT NULL, unique(C1)) PARTITION BY PRIMARY KEY", "X0Y97"}, {"CREATE TABLE TE5 (M1 CHAR(64) NOT NULL CONSTRAINT PK1 PRIMARY KEY) PARTITION BY PRIMARY KEY", null}, {"CREATE TABLE TE6 (C1 INTEGER NOT NULL PRIMARY KEY) PARTITION BY PRIMARY KEY(C1)", "42X01"}, {"CREATE TABLE TF1 (C1 INTEGER) PARTITION BY COLUMN(C2)", "42X01"}, {"CREATE TABLE TF2 (C1 INTEGER, C2 INTEGER) PARTITION BY COLUMN(C1)", null}, {"CREATE TABLE TF3 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(C3, C2, C3, C1)", "42X12"}, {"CREATE TABLE TF4 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(C3, C3)", "42X12"}, {"CREATE TABLE TF5 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(null)", "42X01"}, {"CREATE TABLE TF6 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(C3, 7)", "42X01"}, {"CREATE TABLE TF7 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(C3,'C2')", "42X01"}, {"CREATE TABLE TF8 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN('')", "42X01"}, {"CREATE TABLE TF9 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(C3+1)", "42X01"}, {"CREATE TABLE TF10 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(values('H'))", "42X01"}, {"CREATE TABLE TF11 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(max(C3))", "42X01"}, {"CREATE TABLE TF12 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(select c2 from TF12)", "42X01"}, {"CREATE TABLE TF13 (C1 INTEGER, C2 VARCHAR(200), C3 REAL NOT NULL) PARTITION BY COLUMN(groupsintersect())", "42X01"}, {"CREATE TABLE TF14 (\"lowercase\" varchar(5) not null) PARTITION BY COLUMN (\"lowercase\")", null}, {"CREATE TABLE TF15 (\"lowercase\" varchar(5) not null, lowercase varchar(5)) PARTITION BY COLUMN (\"lowercase\", \"LOWERCASE\")", null}, {"CREATE TABLE TF16 (c5 char(10) for bit data) PARTITION BY COLUMN (C5)", null}, {"CREATE TABLE TF17 (b1 BLOB(100K)) PARTITION BY COLUMN (B1)", null}, {"CREATE TABLE TF19 (id1 INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY) PARTITION BY COLUMN(ID1)", null}, {"CREATE TABLE TF20 (C1 int, c2 int, c3 int, c4 real, c5 double, c6 bigint, c7 double, c8 varchar(100), c9 char(50)) partition by column (c8, c3, c7, c1, c2, c9, c4, c6, c5)", null}, {"CREATE TABLE TF21 (C1 INT) PARTITION BY COLUMN(TF20.C2)", "42X01"}, {"CREATE TABLE TF22 (C1 INTEGER NOT NULL PRIMARY KEY, COL2 DOUBLE) PARTITION BY COLUMN(COL2,C1)", null}, {"CREATE TABLE TG1 (C1 INTEGER NOT NULL) PARTITION BY LIST (C1)", "42X01"}, {"CREATE TABLE TG2 (C1 INTEGER) PARTITION BY LIST (C1) (VALUES(1), VALUES (2), VALUES ())", "42X01"}, {"CREATE TABLE TG3 (C1 INTEGER) PARTITION BY LIST (C1) ()", "42X01"}, {"CREATE TABLE TG4 (C1 INTEGER) PARTITION BY LIST (C1) (VALUES(null))", "42X01"}, {"CREATE TABLE TG5 (C1 SMALLINT) PARTITION BY LIST (C1) (VALUES (60000, 1000000000000))", "22003"}, {"CREATE TABLE TG6 (C1 INTEGER) PARTITION BY LIST(C1) (values (-21474835, 12345678901234))", "22003"}, {"CREATE TABLE TG7 (C1 double) PARTITION BY LIST(C1) (values (-15.0e+715))", "22003"}, {"CREATE TABLE TG8 (C1 double) partition by list(C1) (values (99.0e+999))", "22003"}, {"CREATE TABLE TG9 (C1 BIGINT) PARTITION BY LIST(C1) (values (9999999999999999999999999999999999999999999))", "22003"}, {"CREATE TABLE TG10 (C1 CHAR(10)) partition by list(c1) (values ('Thisisaverylongstring'))", "22003"}, {"CREATE TABLE TG11 (C1 CHAR(10)) partition by list(c1) (values (''))", null}, {"CREATE TABLE TG12 (C1 VARCHAR(10)) partition by list(c1) (values ('thisisanotherverylongstring'))", "22003"}, {"CREATE TABLE TG14 (C1 INTEGER) PARTITION BY LIST (C1) (values ('15'))", "22003"}, {"CREATE TABLE TG15 (C1 CHAR(30)) PARTITION BY LIST (C1) (values (15))", "22003"}, {"CREATE TABLE TG17 (C1 INTEGER) partition by list (c1) (values (max(c1)))", "22003"}, {"CREATE TABLE TG18 (C1 INTEGER) partition by list (c1) (values (c1=5))", "42X01"}, {"CREATE TABLE TG19 (C1 INTEGER) partition by list (c1) (values (values(5)))", "42X01"}, {"CREATE TABLE TG20 (C1 INTEGER) partition by list (c1) (values (c1+5))", "22003"}, {"CREATE TABLE TG21 (C1 INTEGER) partition by list (c1) (values (select 5 from sysibm.sysdummy1))", "42X01"}, {"CREATE TABLE TG22 (C1 INTEGER) partition by list (c1) (values (+infinity))", "42X04"}, {"CREATE TABLE TG23 (C1 INTEGER) partition by list (c1) (values (CAST(5 as integer)))", null}, {"CREATE TABLE TG24 (C1 SMALLINT NOT NULL WITH DEFAULT 10) PARTITION BY LIST(C1) (VALUES (DEFAULT))", "42X01"}, {"CREATE TABLE TG25 (C1 INTEGER) PARTITION BY LIST (C1) (VALUES (1,10), VALUES(1))", "42Y49"}, {"CREATE TABLE TG26 (C1 CHAR(10)) PARTITION BY LIST (C1) (VALUES ('ABC'), VALUES ('ABC   '))", "42Y49"}, {"CREATE TABLE TG27 (C1 INTEGER, C2 INTEGER) PARTITION BY LIST(C1,C2) (VALUES (5,5))", "42X01"}, {"CREATE TABLE TH1 (C1 INTEGER) PARTITION BY RANGE(C1) (VALUES BETWEEN 4 and 2)", "0A000"}, {"CREATE TABLE TH4 (C1 INTEGER) PARTITION BY RANGE(C1) (VALUES BETWEEN 4 and 4)", "0A000"}, {"CREATE TABLE TH5 (C1 INTEGER) PARTITION BY RANGE(C1) (VALUES BETWEEN null and null)", "42X01"}, {"CREATE TABLE TH6 (C1 VARCHAR(10)) PARTITION BY RANGE(C1) (VALUES BETWEEN 'A' and '')", "0A000"}, {"CREATE TABLE TH7 (C1 INTEGER NOT NULL WITH DEFAULT 10) PARTITION BY RANGE(C1) (VALUES BETWEEN 4 and DEFAULT)", "42X01"}, {"CREATE TABLE TH8 (C1 INTEGER) PARTITION BY RANGE(C1) (VALUES BETWEEN 4+C1 and 10)", "22003"}, {"CREATE TABLE TH9 (C1 INTEGER) PARTITION BY RANGE(C1) (VALUES BETWEEN -infinity and +infinity)", "42X77"}, {"CREATE TABLE TH10 (C1 INTEGER) PARTITION BY RANGE(C1) (VALUES BETWEEN MAX(C1) and 7)", "22003"}, {"CREATE TABLE TH11 (C1 INTEGER) PARTITION BY RANGE(C1) (VALUES BETWEEN 4 and 6, VALUES BETWEEN CAST(7 AS INTEGER) AND CAST(11 as INTEGER))", null}, {"CREATE TABLE TH12 (C1 CHAR(5)) PARTITION BY RANGE(C1) (VALUES BETWEEN '' and ' ')", "0A000"}, {"CREATE TABLE TH14 (C1 SMALLINT) PARTITION BY RANGE(C1) (VALUES BETWEEN 18000 and 34000, VALUES BETWEEN 40000 and 100000)", "22003"}, {"CREATE TABLE TH15 (C1 VARCHAR(10)) PARTITION BY RANGE(C1) (VALUES BETWEEN -100 and 'BigValue')", "42818"}, {"CREATE TABLE TI1 (C1 VARCHAR(10) NOT NULL) PARTITION BY (YEAR(C1))", null}, {"CREATE TABLE TI2 (C1 DOUBLE) PARTITION BY (SUBSTR(C1,1,2))", "42X25"}, {"CREATE TABLE TI3 (C1 CLOB(5000)) PARTITION BY (ABS(C1))", "42X25"}, {"CREATE TABLE TI4 (C1 BIGINT) PARTITION BY (DSID())", null}, {"CREATE TABLE TI5 (C1 INT) PARTITION BY (MAX(C1))", "42903"}, {"CREATE TABLE TI6 (C1 INT, C2 INT) PARTITION BY (C1+C2)", null}, {"CREATE TABLE TI7 (C1 BIGINT, C2 SMALLINT) PARTITION BY (C1!=C2)", "42X01"}, {"CREATE TABLE TI8 (C1 DATE, C2 TIME) PARTITION BY (TIMESTAMP(C1,C2))", null}, {"CREATE TABLE TI9 (C1 INT) PARTITION BY (EXISTS (SELECT * FROM SYS.MEMBERS))", "42X01"}, {"CREATE TABLE TI10 (C1 INT, C2 BIGINT) PARTITION BY (C2+1)", null}, {"CREATE TABLE TI12 (C1 INT) PARTITION BY (VALUES(5))", "42X01"}, {"CREATE TABLE TI13 (C1 DOUBLE) PARTITION BY (SELECT C1 FROM TI13)", "42X01"}, {"CREATE TABLE TI14 (C1 DOUBLE) PARTITION BY (SUM(C1)/COUNT(C1))", "42903"}, {"CREATE TABLE TI17 (C1 DOUBLE) PARTITION BY (RANDOM())", null}, {"CREATE TABLE TI18 (C1 DOUBLE) PARTITION BY (PI())", null}, {"CREATE TABLE TI21 (C1 INT) PARTITION BY (TAN(C1))", null}, {"CREATE TABLE TI22 (C1 INT, C2 VARCHAR(100)) PARTITION BY (C1/C2)", null}, {"CREATE TABLE TI23 (C1 INT) PARTITION BY (C1/0)", null}, {"CREATE TABLE TI24 (C1 SMALLINT) PARTITION BY (C1>5)", "42X01"}, {"CREATE TABLE TI25 (C1 VARCHAR(100)) PARTITION BY (GROUPSINTERSECT(C1,'MYGROUPS'))", null}, {"CREATE TABLE TI26 (C1 INT) PARTITION BY (mod(C1,5))", null}, {"CREATE TABLE TI29 (COL1 CHAR(10)) PARTITION BY (COL1)", null}, {"CREATE TABLE TJ1 (C1 SMALLINT, C2 INTEGER, C3 BIGINT, C4 DOUBLE, C5 DECIMAL(10,2), C6 CHAR(100), C7 VARCHAR(200), C8 CHAR(100) FOR BIT DATA, C9 VARCHAR(100) FOR BIT DATA, C10 TIME, C11 DATE, C12 TIMESTAMP, C13 CLOB(100), C14 BLOB(100)) PARTITION BY COLUMN (C14, c13, c12, c11, c10, c9, c8, c7, c6, c5, c4, c3, c2, c1)", null}, {"CREATE TABLE TK1 AS SELECT * FROM TJ1 WITH NO DATA PARTITION BY COLUMN(C1, C2, C3, C4, C5, C6, C7, C8, C9, C10, C11, C12, C13, C14)", null}, {"CREATE TABLE TK2(C1) AS VALUES(5) WITH NO DATA", null}, {"CREATE TABLE TK3(C1) AS VALUES('Hello') WITH NO DATA", null}, {"CREATE TABLE TK4(C1) AS VALUES(9.9) WITH NO DATA", null}, {"CREATE TABLE TK41(C1 INTEGER) AS VALUES(10.55) WITH NO DATA", "42X01"}, {"CREATE TABLE TK5 AS SELECT PORT FROM SYS.MEMBERS WITH NO DATA", null}, {"CREATE SYNONYM S1 FOR SYS.JARS", null}, {"CREATE TABLE TK6 AS SELECT * FROM S1 WITH NO DATA", null}, {"DECLARE GLOBAL TEMPORARY TABLE G1 (COL1 DOUBLE) NOT LOGGED", null}, {"CREATE TABLE TK7 AS SELECT COL1 FROM SESSION.G1 WITH NO DATA", null}, {"CREATE TABLE TK8 AS SELECT TABLESCHEMANAME FROM SYS.SYSTABLES WITH NO DATA", null}, {"CREATE TABLE TK9 AS SELECT * FROM TK9 WITH NO DATA", "42X05"}, {"CREATE TABLE TK10 AS VALUES(NULL) WITH NO DATA", "42X07"}, {"CREATE TABLE SOURCE1 (COL1 INTEGER NOT NULL PRIMARY KEY)", null}, {"CREATE TABLE TK11 AS SELECT * FROM SOURCE1 WITH NO DATA PARTITION BY PRIMARY KEY", "X0Y97"}, {"CREATE TABLE TK12(X) AS SELECT DSID() FROM SOURCE1 WITH NO DATA", null}, {"CREATE TABLE TK13(X) AS SELECT '' FROM SYSIBM.SYSDUMMY1 with no data", "42X44"}, {"create table employee2 (employee_number int not null, x int not null, employee_name varchar(20), manager_employee_number int, y int not null, primary key(employee_number,x), constraint man2 foreign key (manager_employee_number,y) references employee2 on delete restrict)", null}, {"insert into employee2 values (5, 6, 'Randy', 1, 2)", "23503"}, {"insert into employee2 values (5, 6, 'Randy', 5, 6)", null}, {"create table z3 (x int, y int generated always as identity (start with 2))", "0A000"}, {"create table z3 (x int, y int generated always as identity (increment by 5))", "0A000"}, {"create table z3 (x int, y int generated always as identity (start with 2, increment by 6))", "0A000"}, {"create table nn1 (col1 int null null)", "42Y49"}, {"create table nn2 (col1 int not null not null)", "42Y49"}, {"create table e1 (col1 integer) REPLICATE eviction by lrumemsize 100", "38000"}, {"create table e2 (col1 integer) eviction by lrumemsize 100 evictaction overflow", null}, {"create table e3 (col1 integer) eviction by lrumemsize 100 evictaction destroy", null}, {"create table e4 (col1 integer) partition by column(col1) eviction by lrumemsize 100", null}, {"create table e5 (col1 integer) eviction by lrumemsize 100 evictaction overflow eviction by lrumemsize 200 evictaction overflow", "42Y49"}, {"create table e6 (col1 integer) eviction by lrumemsize 100 evictaction overflow eviction by lruheappercent evictaction overflow", "42Y49"}, {"create table e7 (col1 integer) eviction by lrumemsize 100 evictaction overflow eviction by lrucount 5 evictaction overflow", "42Y49"}, {"create table e8 (col1 integer) partition by column(col1) eviction by lrumemsize -100", "42X44"}, {"create table e9 (col1 integer) partition by column(col1) eviction by lrumemsize 0", "42X44"}, {"create table e10 (col1 integer) partition by column(col1) eviction by lrucount -6", "42X44"}, {"create table e11 (col1 integer) REPLICATE expire table with timetolive 5000 action destroy", null}, {"create table e12 (col1 integer) REPLICATE expire table with idletime 5000 action destroy", null}, {"create table e13 (col1 integer) REPLICATE expire entry with timetolive 5000 action destroy", null}, {"create table e14 (col1 integer) REPLICATE expire entry with idletime 5000 action destroy", null}, {"create table e15 (col1 integer) expire table with timetolive 500 action invalidate", "42X01"}, {"create table e16 (col1 integer) REPLICATE expire table with timetolive 500 action destroy expire table with timetolive 400 action destroy", "42Y49"}, {"create table e17 (col1 integer) REPLICATE expire entry with idletime 100 action destroy expire entry with idletime 500 action destroy", "42Y49"}};
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        JDBC.SQLUnitTestHelper(stmt, CreateTableUT);
    }

    private void verify(Region rgn, File[] expectedDirs, DataPolicy expectedDP) {
        RegionAttributes ra = rgn.getAttributes();
        CreateTableOtherAttributesTest.assertEquals((Object)expectedDP, (Object)ra.getDataPolicy());
        if (expectedDirs == null) {
            CreateTableOtherAttributesTest.assertNull((Object)ra.getDiskStoreName());
            return;
        }
        File[] actualDirs = Misc.getGemFireCache().findDiskStore("TESTSTORE").getDiskDirs();
        CreateTableOtherAttributesTest.assertEquals((int)actualDirs.length, (int)expectedDirs.length);
        HashSet<String> expected = new HashSet<String>(expectedDirs.length);
        for (File file : expectedDirs) {
            expected.add(file.getAbsolutePath());
        }
        for (File file : actualDirs) {
            CreateTableOtherAttributesTest.assertTrue((boolean)expected.remove(file.getAbsolutePath()));
        }
        CreateTableOtherAttributesTest.assertTrue((boolean)expected.isEmpty());
    }
}

