/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CreateTableAsQueryExpressionTest
extends JdbcTestBase {
    private final String goldenTextFile = TestUtil.getResourcesDir() + "/lib/checkQuery.xml";
    private final String[] xmlOutPutTags_one = new String[]{"leftouterJoin_one", "rightouterJoin_one"};

    public CreateTableAsQueryExpressionTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(CreateTableAsQueryExpressionTest.class));
    }

    public void testCreateTableAsQueryExpression() throws SQLException {
        Connection conn = CreateTableAsQueryExpressionTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1(id int not null, cid varchar(20))");
        stmt.execute("create table t2 as select * from t1 with no data");
    }

    public void testCreateTableAsQueryExpressionRCGiven() throws SQLException {
        Connection conn = CreateTableAsQueryExpressionTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1(id int not null, cid varchar(20))");
        stmt.execute("create table t2 (id_der, cid_der)as select * from t1 with no data");
    }

    public void testOuterJoin() throws Exception {
        Connection conn = CreateTableAsQueryExpressionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema emp");
        s.execute("create table emp.EMPLOYEE(lastname varchar(30) primary key, depid int) replicate");
        s.execute("create table emp.DEPT1(deptname varchar(30), depid int primary key) partition by column (depid)");
        s.execute("create table emp.DEPT as select * from emp.dept1 with no data");
        s.execute("insert into emp.employee values ('Jones', 33), ('Rafferty', 31), ('Robinson', 34), ('Steinberg', 33), ('Smith', 34), ('John', null)");
        s.execute("insert into emp.dept values ('sales', 31), ('engineering', 33), ('clerical', 34), ('marketing', 35)");
        s.execute("SELECT *  FROM emp.employee LEFT OUTER JOIN emp.dept ON emp.employee.depid = emp.dept.depid");
        String jdbcSQL = "SELECT emp.Employee.LastName as lname, emp.Employee.DepID as did1, emp.Dept.DeptName as depname, emp.Dept.DepID as did2  FROM emp.employee  LEFT OUTER JOIN emp.dept ON emp.employee.depID = emp.dept.DepID";
        TestUtil.sqlExecuteVerifyText(jdbcSQL, this.goldenTextFile, this.xmlOutPutTags_one[0], false, false);
        s.execute("create table emp.DEPT3 as select * from emp.dept with no data replicate");
        jdbcSQL = "select tablename, datapolicy from sys.systables where tableschemaname = 'EMP'";
        s.execute(jdbcSQL);
        ResultSet rs = s.getResultSet();
        TestUtil.sqlExecuteVerifyText(jdbcSQL, this.goldenTextFile, "datapolicy_createTableTableExpr", false, false);
    }

    public void testCreateTable() throws SQLException, StandardException {
        Connection conn = CreateTableAsQueryExpressionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE_BASE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (ID, SECONDID)) PARTITION BY COLUMN (ID)");
        s.execute("create table EMP.PARTITIONTESTTABLE as select * from EMP.PARTITIONTESTTABLE_BASE with no data");
        s.execute("alter table EMP.PARTITIONTESTTABLE add primary key(ID, SECONDID)");
        s.execute("select tablename, datapolicy from sys.systables where tableschemaname = 'EMP'");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            String datapolicy = rs.getString(2);
            CreateTableAsQueryExpressionTest.assertTrue((boolean)datapolicy.equalsIgnoreCase("partition"));
        }
        CreateTableAsQueryExpressionTest.assertEquals((int)2, (int)cnt);
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        CreateTableAsQueryExpressionTest.assertNotNull((Object)pr);
        GfxdPartitionByExpressionResolver scpr = (GfxdPartitionByExpressionResolver)pr;
        CreateTableAsQueryExpressionTest.assertNotNull((Object)scpr);
        CreateTableAsQueryExpressionTest.assertTrue((boolean)scpr.columnsSubsetOfPrimary());
        CreateTableAsQueryExpressionTest.assertEquals((int)2, (int)scpr.getColumnNames().length);
        CreateTableAsQueryExpressionTest.assertEquals((String)"ID", (String)scpr.getColumnNames()[0]);
        CreateTableAsQueryExpressionTest.assertEquals((String)"SECONDID", (String)scpr.getColumnNames()[1]);
        CreateTableAsQueryExpressionTest.assertTrue((boolean)scpr.isPartitioningKeyThePrimaryKey());
    }

    public void testRangesWithExpression() throws SQLException, StandardException {
        Connection conn = CreateTableAsQueryExpressionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        Cache cache = CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE_BASE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))");
        s.execute("create table EMP.PARTITIONTESTTABLE as select * from EMP.PARTITIONTESTTABLE_BASE with no data PARTITION BY RANGE ( ID ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 )");
        s.execute("alter table EMP.PARTITIONTESTTABLE add primary key(ID)");
        s.execute("select tablename, datapolicy from sys.systables where tableschemaname = 'EMP'");
        ResultSet rs = s.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
            String datapolicy = rs.getString(2);
            CreateTableAsQueryExpressionTest.assertTrue((boolean)datapolicy.equalsIgnoreCase("partition"));
        }
        CreateTableAsQueryExpressionTest.assertEquals((int)2, (int)cnt);
        Region regtwo = cache.getRegion("/EMP/PARTITIONTESTTABLE");
        RegionAttributes rattr = regtwo.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        GfxdRangePartitionResolver rpr = (GfxdRangePartitionResolver)pr;
        CreateTableAsQueryExpressionTest.assertNotNull((Object)rpr);
        SQLInteger lowerBound = null;
        SQLInteger upperBound = null;
        Object[] routingObjects = null;
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        CreateTableAsQueryExpressionTest.assertEquals((int)3, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)1, (Object)routingObjects[0]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)2, (Object)routingObjects[1]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)3, (Object)routingObjects[2]);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, false);
        CreateTableAsQueryExpressionTest.assertEquals((int)3, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)1, (Object)routingObjects[0]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)2, (Object)routingObjects[1]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)3, (Object)routingObjects[2]);
        upperBound = new SQLInteger(60);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, false);
        CreateTableAsQueryExpressionTest.assertEquals((int)2, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)1, (Object)routingObjects[0]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)2, (Object)routingObjects[1]);
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, false, (DataValueDescriptor)upperBound, true);
        CreateTableAsQueryExpressionTest.assertEquals((int)3, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)1, (Object)routingObjects[0]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)2, (Object)routingObjects[1]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)3, (Object)routingObjects[2]);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        CreateTableAsQueryExpressionTest.assertEquals((int)2, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)2, (Object)routingObjects[0]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)3, (Object)routingObjects[1]);
        lowerBound = new SQLInteger(25);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        CreateTableAsQueryExpressionTest.assertEquals((int)3, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)1, (Object)routingObjects[0]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)2, (Object)routingObjects[1]);
        CreateTableAsQueryExpressionTest.assertEquals((Object)3, (Object)routingObjects[2]);
        lowerBound = new SQLInteger(15);
        upperBound = new SQLInteger(75);
        routingObjects = rpr.getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        CreateTableAsQueryExpressionTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(60);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, false, (DataValueDescriptor)upperBound, false);
        CreateTableAsQueryExpressionTest.assertEquals((int)1, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)2, (Object)routingObjects[0]);
        lowerBound = new SQLInteger(40);
        upperBound = new SQLInteger(95);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        CreateTableAsQueryExpressionTest.assertNull((Object)routingObjects);
        lowerBound = new SQLInteger(20);
        upperBound = new SQLInteger(30);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        CreateTableAsQueryExpressionTest.assertEquals((int)1, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)1, (Object)routingObjects[0]);
        lowerBound = new SQLInteger(60);
        upperBound = new SQLInteger(60);
        routingObjects = ((GfxdRangePartitionResolver)pr).getRoutingObjectsForRange((DataValueDescriptor)lowerBound, true, (DataValueDescriptor)upperBound, true);
        CreateTableAsQueryExpressionTest.assertEquals((int)1, (int)routingObjects.length);
        CreateTableAsQueryExpressionTest.assertEquals((Object)3, (Object)routingObjects[0]);
        s.close();
        conn.close();
    }

    public void testInvalidColumnGivenAsPartitioningColumn() throws SQLException, StandardException {
        Connection conn = CreateTableAsQueryExpressionTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema EMP");
        CacheFactory.getAnyInstance();
        s.execute("create table EMP.PARTITIONTESTTABLE_BASE (ID int not null,  DESCRIPTION varchar(1024) not null, primary key (ID))");
        boolean gotException = false;
        try {
            s.execute("create table EMP.PARTITIONTESTTABLE as select * from EMP.PARTITIONTESTTABLE_BASE with no data PARTITION BY RANGE ( ID1 ) ( VALUES BETWEEN 20 and 40, VALUES BETWEEN 40 and 60, VALUES BETWEEN 60 and 80, VALUES BETWEEN 90 and 100 )");
        }
        catch (SQLException e) {
            gotException = true;
        }
        CreateTableAsQueryExpressionTest.assertTrue((boolean)gotException);
    }

    public void testDummy() {
    }
}

