/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.PartitionAttributesFactory;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.SQLException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CreateSchemaTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(CreateSchemaTest.class));
    }

    public CreateSchemaTest(String name) {
        super(name);
    }

    public void testCreateAndDropSchema() throws SQLException {
        block2: {
            CreateSchemaTest.setupConnection();
            CreateSchemaTest.assertNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
            CreateSchemaTest.sqlExecute("CREATE SCHEMA EMP", true);
            CreateSchemaTest.assertNotNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
            CreateSchemaTest.sqlExecute("CREATE TABLE EMP.AVAILABILITY (HOTEL_ID INT NOT NULL, BOOKING_DATE DATE NOT NULL, ROOMS_TAKEN INT, CONSTRAINT HOTELAVAIL_PK PRIMARY KEY (HOTEL_ID, BOOKING_DATE))", false);
            try {
                CreateSchemaTest.sqlExecute("CREATE SCHEMA EMP", true);
                CreateSchemaTest.fail("Unexpectedly did not get exception when trying to create a schema that already exists");
            }
            catch (SQLException ex) {
                if ("X0Y68".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        CreateSchemaTest.sqlExecute("drop table EMP.AVAILABILITY", true);
        CreateSchemaTest.sqlExecute("DROP SCHEMA EMP RESTRICT", true);
        CreateSchemaTest.assertNull((Object)Misc.getRegionForTable((String)"EMP.AVAILABILITY", (boolean)false));
        CreateSchemaTest.assertNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
        CreateSchemaTest.sqlExecute("CREATE TABLE EMP.AVAILABILITY (HOTEL_ID INT NOT NULL, BOOKING_DATE DATE NOT NULL, ROOMS_TAKEN INT, CONSTRAINT HOTELAVAIL_PK PRIMARY KEY (HOTEL_ID, BOOKING_DATE))", false);
        CreateSchemaTest.assertNotNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
        CreateSchemaTest.sqlExecute("drop table EMP.AVAILABILITY", true);
        CreateSchemaTest.sqlExecute("DROP SCHEMA EMP RESTRICT", false);
        CreateSchemaTest.assertNull((Object)Misc.getRegionForTable((String)"EMP.AVAILABILITY", (boolean)false));
        CreateSchemaTest.assertNull((Object)Misc.getRegionForTable((String)"EMP", (boolean)false));
    }

    public void testSYSSCHEMAS() throws Exception {
        CreateSchemaTest.setupConnection();
        CreateSchemaTest.sqlExecute("CREATE SCHEMA EMP DEFAULT SERVER GROUPS (SG1)", Boolean.TRUE);
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        expectedAttrs.setDataPolicy(DataPolicy.EMPTY);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        CreateSchemaTest.verifyRegionProperties("EMP", null, TestUtil.regionAttributesToXML(expectedAttrs));
        CreateSchemaTest.sqlExecuteVerifyText("SELECT SCHEMANAME, DEFAULTSERVERGROUPS FROM SYS.SYSSCHEMAS WHERE SCHEMANAME='EMP'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_sg", Boolean.TRUE, Boolean.FALSE);
        CreateSchemaTest.sqlExecuteVerifyText("SELECT SCHEMANAME, DEFAULTSERVERGROUPS FROM SYS.SYSSCHEMAS WHERE DEFAULTSERVERGROUPS='SG1'", CreateSchemaTest.getResourcesDir() + "/lib/checkSchema.xml", "emp_sg", Boolean.TRUE, Boolean.FALSE);
    }

    public void testDefaultServerGroup() throws Exception {
        Properties props = new Properties();
        props.setProperty("server-groups", "sg1");
        CreateSchemaTest.setupConnection(props);
        CreateSchemaTest.sqlExecute("CREATE SCHEMA EMP DEFAULT SERVER GROUPS (SG1)", Boolean.TRUE);
        RegionAttributesCreation expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setScope(Scope.DISTRIBUTED_NO_ACK);
        expectedAttrs.setDataPolicy(DataPolicy.EMPTY);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        CreateSchemaTest.verifyRegionProperties("EMP", null, TestUtil.regionAttributesToXML(expectedAttrs));
        CreateSchemaTest.sqlExecuteVerifyText("SELECT SCHEMANAME, DEFAULTSERVERGROUPS FROM SYS.SYSSCHEMAS WHERE SCHEMANAME='EMP'", TestUtil.getResourcesDir() + "/lib/checkSchema.xml", "emp_sg", Boolean.TRUE, Boolean.FALSE);
        CreateSchemaTest.sqlExecuteVerifyText("SELECT SCHEMANAME, DEFAULTSERVERGROUPS FROM SYS.SYSSCHEMAS WHERE DEFAULTSERVERGROUPS='SG1'", CreateSchemaTest.getResourcesDir() + "/lib/checkSchema.xml", "emp_sg", Boolean.TRUE, Boolean.FALSE);
        CreateSchemaTest.sqlExecute("create table EMP.PARTITIONTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (SECONDID)) PARTITION BY COLUMN (ID, SECONDID)", Boolean.TRUE);
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.PARTITION);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasScope(false);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        PartitionAttributes pattrs = new PartitionAttributesFactory().setPartitionResolver((PartitionResolver)new GfxdPartitionByExpressionResolver()).create();
        expectedAttrs.setPartitionAttributes(pattrs);
        CreateSchemaTest.verifyRegionProperties("EMP", "PARTITIONTESTTABLE", TestUtil.regionAttributesToXML(expectedAttrs));
        CreateSchemaTest.sqlExecute("create table EMP.REPLICATEDTESTTABLE (ID int not null,  SECONDID int not null, THIRDID int not null, primary key (SECONDID)) REPLICATE", Boolean.TRUE);
        expectedAttrs = new RegionAttributesCreation();
        expectedAttrs.setDataPolicy(DataPolicy.REPLICATE);
        expectedAttrs.setScope(Scope.DISTRIBUTED_ACK);
        expectedAttrs.setInitialCapacity(5);
        expectedAttrs.setConcurrencyChecksEnabled(false);
        expectedAttrs.setAllHasFields(true);
        expectedAttrs.setHasDiskDirs(false);
        expectedAttrs.setHasDiskWriteAttributes(false);
        CreateSchemaTest.verifyRegionProperties("EMP", "REPLICATEDTESTTABLE", TestUtil.regionAttributesToXML(expectedAttrs));
    }
}

