/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.cache.hdfs.internal.hoplog.HDFSRegionDirector;
import com.gemstone.gemfire.cache.partition.PartitionMemberInfo;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.partition.PartitionRegionInfo;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionStats;
import com.gemstone.gemfire.internal.cache.persistence.soplog.SortedOplogStatistics;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.jdbc.SimpleAppTest;
import io.snappydata.test.dunit.AvailablePortHelper;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class CreateHDFSStoreTest
extends JdbcTestBase {
    int port;
    MiniDFSCluster cluster;
    FileSystem fs = null;

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(SimpleAppTest.class));
    }

    public CreateHDFSStoreTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.port = AvailablePortHelper.getRandomAvailableTCPPort();
        this.cluster = CreateHDFSStoreTest.initMiniCluster(this.port, 1);
        this.fs = FileSystem.get((URI)URI.create("hdfs://localhost:" + this.port), (Configuration)new Configuration());
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.delete(new File("./myhdfs"));
        this.delete(new File("./gemfire"));
        if (this.cluster != null) {
            this.cluster.getFileSystem().close();
            this.cluster.shutdown();
        }
        this.deleteMiniClusterDir();
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    private void delete(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                file.delete();
            } else {
                File[] files;
                for (File f : files = file.listFiles()) {
                    this.delete(f);
                }
                file.delete();
            }
        } else {
            file.delete();
        }
    }

    private void checkDirExistence(String path) throws IOException {
        File dir;
        Path pathOnHdfs = new Path(path);
        if (this.fs.exists(pathOnHdfs)) {
            this.fs.delete(pathOnHdfs, true);
        }
        if ((dir = new File(path)).exists()) {
            this.delete(dir);
        }
    }

    private void checkHDFSIteratorResultSet(ResultSet rs, int expectedSize) throws Exception {
        Vector<Object> v = new Vector<Object>();
        while (rs.next()) {
            v.add(rs.getObject(1));
        }
        Object[] arr = v.toArray();
        Arrays.sort(arr);
        CreateHDFSStoreTest.assertEquals((int)expectedSize, (int)arr.length);
        for (int i = 0; i < expectedSize; ++i) {
            CreateHDFSStoreTest.assertEquals((int)i, (int)((Integer)arr[i]));
        }
    }

    public void testQueryHDFS() throws Exception {
        int i;
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'  BatchTimeInterval 100 milliseconds");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i2 = 0; i2 < NUM_ROWS; ++i2) {
            ps.setInt(1, i2);
            ps.setInt(2, i2 + 1);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection();
        ps = conn.prepareStatement("select * from t1 where col1 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        ps = conn.prepareStatement("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=false \n where col1 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        ps = conn.prepareStatement("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertTrue((boolean)rs.next());
            CreateHDFSStoreTest.assertEquals((int)(i + 1), (int)rs.getInt(2));
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        ps = conn.prepareStatement("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=false \n where col1 = ? ");
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        st = conn.createStatement();
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testQueryHDFS2() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n order by col1");
        rs = st.getResultSet();
        this.checkHDFSIteratorResultSet(rs, NUM_ROWS);
        st.execute("select * from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n order by col1");
        rs = st.getResultSet();
        this.checkHDFSIteratorResultSet(rs, NUM_ROWS);
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testConnectionProperties() throws Exception {
        int i;
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i2 = 0; i2 < NUM_ROWS; ++i2) {
            ps.setInt(1, i2);
            ps.setInt(2, i2 + 1);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("query-HDFS", "true");
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=false \n");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from t1 order by col1");
        rs = st.getResultSet();
        this.checkHDFSIteratorResultSet(rs, NUM_ROWS);
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=false \n");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=false \n");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        CreateHDFSStoreTest.shutDown();
        props = new Properties();
        mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("query-HDFS", "false");
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("select * from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        ps = conn.prepareStatement("select * from t1 where col1 = ? ");
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        ps = conn.prepareStatement("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertTrue((boolean)rs.next());
            CreateHDFSStoreTest.assertEquals((int)(i + 1), (int)rs.getInt(2));
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n order by col1");
        rs = st.getResultSet();
        this.checkHDFSIteratorResultSet(rs, NUM_ROWS);
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testDDLConflation() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("drop hdfsstore myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testSYSHDFSSTORE_AllAttributes() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' HomeDir './myhdfs'" + " QueuePersistent true DiskSynchronous false MaxQueueMemory 123 BatchSize 7 BatchTimeInterval 5678 seconds DiskStoreName mydisk " + " MinorCompact false MajorCompact false MaxInputFileSize 678 MinInputFileCount 9 " + "MaxInputFileCount 20 MinorCompactionThreads 20 MajorCompactionInterval 360 minutes MajorCompactionThreads 14 MaxWriteOnlyFileSize 6 " + "writeonlyfilerolloverinterval 7seconds BlockCacheSize 5 ClientConfigFile './file1' PurgeInterval 360 minutes DispatcherThreads 10");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((String)"MYHDFS", (String)rs.getString(1));
        CreateHDFSStoreTest.assertEquals((String)("hdfs://127.0.0.1:" + this.port + ""), (String)rs.getString(2));
        CreateHDFSStoreTest.assertEquals((String)"././myhdfs", (String)rs.getString(3));
        CreateHDFSStoreTest.assertEquals((int)123, (int)rs.getInt(4));
        CreateHDFSStoreTest.assertEquals((int)7, (int)rs.getInt(5));
        CreateHDFSStoreTest.assertEquals((int)5678000, (int)rs.getInt(6));
        CreateHDFSStoreTest.assertTrue((boolean)rs.getBoolean(7));
        CreateHDFSStoreTest.assertFalse((boolean)rs.getBoolean(8));
        CreateHDFSStoreTest.assertEquals((String)"MYDISK", (String)rs.getString(9));
        CreateHDFSStoreTest.assertFalse((boolean)rs.getBoolean(10));
        CreateHDFSStoreTest.assertFalse((boolean)rs.getBoolean(11));
        CreateHDFSStoreTest.assertEquals((int)678, (int)rs.getInt(12));
        CreateHDFSStoreTest.assertEquals((int)9, (int)rs.getInt(13));
        CreateHDFSStoreTest.assertEquals((int)20, (int)rs.getInt(14));
        CreateHDFSStoreTest.assertEquals((int)20, (int)rs.getInt(15));
        CreateHDFSStoreTest.assertEquals((int)360, (int)rs.getInt(16));
        CreateHDFSStoreTest.assertEquals((int)14, (int)rs.getInt(17));
        CreateHDFSStoreTest.assertEquals((String)"./file1", (String)rs.getString(18));
        CreateHDFSStoreTest.assertEquals((int)5, (int)rs.getInt(19));
        CreateHDFSStoreTest.assertEquals((int)6, (int)rs.getInt(20));
        CreateHDFSStoreTest.assertEquals((int)7, (int)rs.getInt(21));
        CreateHDFSStoreTest.assertEquals((int)360, (int)rs.getInt(22));
        CreateHDFSStoreTest.assertEquals((int)10, (int)rs.getInt(23));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select purgeintervalmins from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)360, (int)rs.getInt(1));
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        this.delete(new File("./myhdfs"));
    }

    public void testSYSHDFSSTORE_TimeUnitConversion() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' PurgeInterval 360 minutes");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)360, (int)rs.getInt("PURGEINTERVALMINS"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' PurgeInterval 360 seconds");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)6, (int)rs.getInt("PURGEINTERVALMINS"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' PurgeInterval 120000 milliseconds");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)2, (int)rs.getInt("PURGEINTERVALMINS"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' PurgeInterval 3 hours");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)180, (int)rs.getInt("PURGEINTERVALMINS"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' MAJORCOMPACTIONINTERVAL 1000 days");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)1440000, (int)rs.getInt("MAJORCOMPACTIONINTERVALMINS"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' writeonlyfilerolloverinterval 10 days");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)864000, (int)rs.getInt("writeonlyfilerolloverintervalsecs"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' writeonlyfilerolloverinterval 3600 milliseconds");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)3, (int)rs.getInt("writeonlyfilerolloverintervalsecs"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' writeonlyfilerolloverinterval 3600 seconds");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)3600, (int)rs.getInt("writeonlyfilerolloverintervalsecs"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' BATCHTIMEINTERVAL 1 hours");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)3600000, (int)rs.getInt("BATCHTIMEINTERVALMILLIS"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' BATCHTIMEINTERVAL 1 milliseconds");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)1, (int)rs.getInt("BATCHTIMEINTERVALMILLIS"));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        this.delete(new File("./myhdfs"));
    }

    public void testSYSHDFSSTORE_InvalidTimeInterval() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        try {
            st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' PurgeInterval -2 minutes");
            CreateHDFSStoreTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        try {
            st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' Purgeinterval 59 seconds");
            CreateHDFSStoreTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        try {
            st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' Purgeinterval 999 milliseconds");
            CreateHDFSStoreTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        try {
            st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' BATCHTIMEINTERVAL -2 milliseconds");
            CreateHDFSStoreTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        try {
            st.execute("create HDFSStore myhdfs NameNode 'hdfs://127.0.0.1:" + this.port + "' writeonlyfilerolloverinterval 999 milliseconds");
            CreateHDFSStoreTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        this.delete(new File("./myhdfs"));
    }

    public void testSYSHDFSSTORE_DefaultAttributes() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./gemfire");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "'");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((String)"MYHDFS", (String)rs.getString(1));
        CreateHDFSStoreTest.assertEquals((String)("hdfs://127.0.0.1:" + this.port + ""), (String)rs.getString(2));
        CreateHDFSStoreTest.assertEquals((String)"./MYHDFS", (String)rs.getString(3));
        CreateHDFSStoreTest.assertEquals((int)100, (int)rs.getInt(4));
        CreateHDFSStoreTest.assertEquals((int)32, (int)rs.getInt(5));
        CreateHDFSStoreTest.assertEquals((int)60000, (int)rs.getInt(6));
        CreateHDFSStoreTest.assertFalse((boolean)rs.getBoolean(7));
        CreateHDFSStoreTest.assertTrue((boolean)rs.getBoolean(8));
        CreateHDFSStoreTest.assertNull((Object)rs.getString(9));
        CreateHDFSStoreTest.assertTrue((boolean)rs.getBoolean(10));
        CreateHDFSStoreTest.assertTrue((boolean)rs.getBoolean(11));
        CreateHDFSStoreTest.assertEquals((int)512, (int)rs.getInt(12));
        CreateHDFSStoreTest.assertEquals((int)4, (int)rs.getInt(13));
        CreateHDFSStoreTest.assertEquals((int)10, (int)rs.getInt(14));
        CreateHDFSStoreTest.assertEquals((int)10, (int)rs.getInt(15));
        CreateHDFSStoreTest.assertEquals((int)720, (int)rs.getInt(16));
        CreateHDFSStoreTest.assertEquals((int)2, (int)rs.getInt(17));
        CreateHDFSStoreTest.assertNull((Object)rs.getString(18));
        CreateHDFSStoreTest.assertEquals((int)10, (int)rs.getInt(19));
        CreateHDFSStoreTest.assertEquals((long)256L, (long)rs.getLong(20));
        CreateHDFSStoreTest.assertEquals((long)3600L, (long)rs.getLong(21));
        CreateHDFSStoreTest.assertEquals((long)30L, (long)rs.getLong(22));
        CreateHDFSStoreTest.assertEquals((long)5L, (long)rs.getLong(23));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        this.delete(new File("./myhdfs"));
    }

    public void testSYSHDFSSTORE_AddAndDelete() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs1");
        this.checkDirExistence("./myhdfs2");
        st.execute("create hdfsstore myhdfs1 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs1'" + " queuepersistent true disksynchronous false maxqueuememory 123 batchsize 7 batchtimeinterval 5678 milliseconds diskstorename mydisk " + " minorcompact false majorcompact false maxinputfilesize 678 mininputfilecount 9 " + "maxinputfilecount 20 MinorCompactionThreads 20 majorcompactioninterval 360 minutes majorcompactionThreads 14");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((String)"MYHDFS1", (String)rs.getString(1));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("create hdfsstore myhdfs2 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs2'");
        st.execute("select count(*) from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)2, (int)rs.getInt(1));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.syshdfsstores where name = 'MYHDFS1'");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((String)"MYHDFS1", (String)rs.getString(1));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from sys.syshdfsstores where name = 'MYHDFS2'");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((String)"MYHDFS2", (String)rs.getString(1));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs2");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((String)"MYHDFS1", (String)rs.getString(1));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop hdfsstore myhdfs1");
        st.execute("select * from sys.syshdfsstores");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        this.delete(new File("./myhdfs1"));
        this.delete(new File("./myhdfs2"));
    }

    public void testHDFSStoreDDLSyntax() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        Object rs = null;
        for (int i = 1; i < 7; ++i) {
            String fn = new String("./hs" + i);
            this.checkDirExistence(fn);
        }
        Object[][] CreateHDFSStoreDDL = new Object[][]{{"create hdfsstore hs1 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './hs1'", null}, {"create hdfsstore hs2 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './hs2' queuepersistent true diskstorename mydisk", null}, {"create hdfsstore hs3 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './hs3' MinorCompact false MinorCompactionThreads 5", null}, {"create hdfsstore hs4 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './hs4' batchsize 14 majorcompactionThreads 3", null}, {"create hdfsstore hs5 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './hs5' blockcachesize 23 majorcompactionThreads 3", null}, {"create hdfsstore hs6 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './hs6' clientconfigfile './file1' blockcachesize 78", null}, {"create hdfsstore hs7 namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './hs6' maxWriteOnlyfilesize 6 WriteOnlyfilerolloverinterval 7 seconds", null}};
        JDBC.SQLUnitTestHelper(st, CreateHDFSStoreDDL);
        Object[][] DropHDFSStoreDDL = new Object[][]{{"drop hdfsstore hs1", null}, {"drop hdfsstore hs2", null}, {"drop hdfsstore hs3", null}, {"drop hdfsstore hs4", null}, {"drop hdfsstore hs5", null}, {"drop hdfsstore hs6", null}, {"drop hdfsstore hs7", null}};
        JDBC.SQLUnitTestHelper(st, DropHDFSStoreDDL);
        for (int i = 1; i <= 7; ++i) {
            String fn = new String("./hs" + i);
            this.delete(new File(fn));
        }
    }

    public void testPartitionHDFSStore() throws Exception {
        int i;
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds");
        st.execute("create table mytab (col1 int primary key) hdfsstore (myhdfs) enable concurrency checks");
        PreparedStatement ps = conn.prepareStatement("insert into mytab values (?)");
        boolean NUM_ROWS = true;
        for (i = 0; i < 1; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        st.execute("select * from mytab order by col1");
        rs = st.getResultSet();
        i = 0;
        while (rs.next()) {
            CreateHDFSStoreTest.assertEquals((int)i, (int)rs.getInt(1));
            ++i;
        }
        CreateHDFSStoreTest.assertEquals((int)1, (int)i);
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        int count = 0;
        for (i = 0; i < 1; ++i) {
            st.execute("select * from mytab where col1 = " + i);
            rs = st.getResultSet();
            while (rs.next()) {
                CreateHDFSStoreTest.assertEquals((int)i, (int)rs.getInt(1));
                ++count;
            }
            CreateHDFSStoreTest.assertEquals((int)0, (int)count);
        }
        st.execute("drop table mytab");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testReplicatedHDFSStore() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        try {
            st.execute("create table mytab (col1 int primary key) replicate hdfsstore (myhdfs) enable concurrency checks");
            CreateHDFSStoreTest.fail("Expected SQLException");
        }
        catch (SQLException se) {
            if (se.getCause() instanceof UnsupportedOperationException) {
                CreateHDFSStoreTest.assertTrue((boolean)se.getMessage().contains(LocalizedStrings.HDFSSTORE_IS_USED_IN_REPLICATED_TABLE.toLocalizedString()));
            }
            se.printStackTrace();
        }
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testHDFSEventQueuePersistence() throws Exception {
    }

    public void testHDFSWriteOnly() throws Exception {
        Statement st;
        Connection conn;
        block3: {
            Properties props = new Properties();
            int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            props.put("mcast-port", String.valueOf(mcastPort));
            props.put("mcast-ttl", "0");
            conn = TestUtil.getConnection(props);
            st = conn.createStatement();
            this.checkDirExistence("./myhdfs");
            st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds");
            st.execute("create table mytab (col1 int primary key) hdfsstore (myhdfs) writeonly");
            LocalRegion region = (LocalRegion)Misc.getRegion((String)"APP/MYTAB", (boolean)true, (boolean)false);
            RegionAttributes ra = region.getAttributes();
            CreateHDFSStoreTest.assertTrue((boolean)ra.getHDFSWriteOnly());
            try {
                st.execute("drop hdfsstore myhdfs");
            }
            catch (SQLException stde) {
                if (stde.getSQLState().equals("X0Y25")) break block3;
                throw stde;
            }
        }
        PreparedStatement ps = conn.prepareStatement("insert into mytab values (?)");
        int NUM_ROWS = 200;
        for (int i = 0; i < 200; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/MYTAB");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        st.execute("drop table mytab");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testNoHDFSReadIfNoEvictionCriteria() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("create schema hdfs");
        this.doNoHDFSReadIfNoEvicttionCriteriaWork(conn, st, false);
        st.execute("drop table hdfs.t1");
        this.doNoHDFSReadIfNoEvicttionCriteriaWork(conn, st, true);
        st.execute("drop table hdfs.t1");
        st.execute("drop hdfsstore myhdfs");
    }

    private void doNoHDFSReadIfNoEvicttionCriteriaWork(Connection conn, Statement st, boolean isPersistent) throws Exception {
        String persistStr = isPersistent ? " persistent " : "";
        st.execute("create table hdfs.t1 (col1 int primary key, col2 int) partition by primary key buckets 5" + persistStr + " hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into hdfs.t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        SortedOplogStatistics stats = HDFSRegionDirector.getInstance().getHdfsRegionStats("/HDFS/T1");
        CreateHDFSStoreTest.assertEquals((long)(isPersistent ? 0L : 100L), (long)stats.getRead().getCount());
    }

    public void testPutDML() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement s = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        s.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds ");
        s.execute("create table m1 (col1 int primary key , col2 int)  hdfsstore (myhdfs)");
        s.execute("create index idx1 on m1(col2)");
        s.execute("insert into m1 values (11, 22)");
        s.execute("put into m1 values (11, 33)");
        s.execute("put into m1 values (66, 77)");
        s.execute("select * from m1 where col2 = 22");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        s.execute("select * from m1 where col2 = 33");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)33, (int)rs.getInt(2));
        s.execute("select * from m1 where col2 = 77");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)77, (int)rs.getInt(2));
        s.execute("select * from m1");
        rs = s.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)2, (int)count);
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/M1");
        s.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        Properties props2 = new Properties();
        mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props2.put("mcast-port", String.valueOf(mcastPort));
        props2.put("mcast-ttl", "0");
        conn = TestUtil.getConnection(props2);
        s = conn.createStatement();
        s.execute("select * from m1");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        s.execute("select * from m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 11");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)33, (int)rs.getInt(2));
        s.execute("select * from m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 66");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)77, (int)rs.getInt(2));
        s.execute("select * from m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = s.getResultSet();
        count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)2, (int)count);
        s.execute("drop table m1");
        s.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testPutDML_Loner() throws Exception {
        Connection conn = CreateHDFSStoreTest.getConnection();
        Statement s = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        s.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'  BatchTimeInterval 100 milliseconds");
        s.execute("create table m1 (col1 int primary key , col2 int)  hdfsstore (myhdfs)");
        s.execute("create index idx1 on m1(col2)");
        s.execute("insert into m1 values (11, 22)");
        s.execute("put into m1 values (11, 33)");
        s.execute("put into m1 values (66, 77)");
        s.execute("select * from m1 where col2 = 22");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        s.execute("select * from m1 where col2 = 33");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)33, (int)rs.getInt(2));
        s.execute("select * from m1 where col2 = 77");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)77, (int)rs.getInt(2));
        s.execute("select * from m1");
        rs = s.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)2, (int)count);
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/M1");
        s.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection();
        s = conn.createStatement();
        s.execute("select * from m1");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        s.execute("select * from m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 11");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)33, (int)rs.getInt(2));
        s.execute("select * from m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = 66");
        rs = s.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)77, (int)rs.getInt(2));
        s.execute("select * from m1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = s.getResultSet();
        count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)2, (int)count);
        s.execute("drop table m1");
        s.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testTruncateTableHDFS() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'  BatchTimeInterval 100 milliseconds");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n order by col1");
        rs = st.getResultSet();
        this.checkHDFSIteratorResultSet(rs, NUM_ROWS);
        st.execute("truncate table t1");
        st.execute("select * from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n order by col1");
        rs = st.getResultSet();
        this.checkHDFSIteratorResultSet(rs, 0);
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testUpdateDeletePrimaryKeyHDFS() throws Exception {
        int i;
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i2 = 0; i2 < NUM_ROWS; ++i2) {
            ps.setInt(1, i2);
            ps.setInt(2, i2 + 1);
            ps.executeUpdate();
        }
        PreparedStatement ps1 = conn.prepareStatement("update t1 set col2 = ? where col1 = ?");
        PreparedStatement ps2 = conn.prepareStatement("delete from t1 where col1 = ?");
        for (int i3 = 0; i3 < NUM_ROWS; ++i3) {
            if (i3 % 2 == 0) {
                ps1.setInt(1, i3 + 10);
                ps1.setInt(2, i3);
                ps1.executeUpdate();
                continue;
            }
            ps2.setInt(1, i3);
            ps2.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        ps = conn.prepareStatement("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            if (i % 2 == 0) {
                CreateHDFSStoreTest.assertTrue((boolean)rs.next());
                CreateHDFSStoreTest.assertEquals((int)(i + 10), (int)rs.getInt(2));
                CreateHDFSStoreTest.assertFalse((boolean)rs.next());
                continue;
            }
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        ps1 = conn.prepareStatement("update t1 set col2 = ? where col1 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            if (i % 2 != 0) continue;
            ps1.setInt(1, i + 20);
            ps1.setInt(2, i);
            ps1.executeUpdate();
        }
        for (i = 0; i < NUM_ROWS; ++i) {
            if (i % 2 != 0) continue;
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertTrue((boolean)rs.next());
            CreateHDFSStoreTest.assertEquals((int)(i + 20), (int)rs.getInt(2));
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        ps2 = conn.prepareStatement("delete from t1 where col1 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            if (i % 2 != 0) continue;
            ps2.setInt(1, i);
            ps2.executeUpdate();
        }
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testUpdateDeleteNonPrimaryKeyHDFS() throws Exception {
        int i;
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds");
        st.execute("create table t1 (col1 int primary key, col2 int, col3 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?, ?)");
        int NUM_ROWS = 100;
        for (int i2 = 0; i2 < NUM_ROWS; ++i2) {
            ps.setInt(1, i2);
            ps.setInt(2, i2 + 1);
            ps.setInt(3, i2 + 10);
            ps.executeUpdate();
        }
        PreparedStatement ps1 = conn.prepareStatement("update t1 set col2 = ? where col3 = ?");
        PreparedStatement ps2 = conn.prepareStatement("delete from t1 where col3 = ?");
        for (int i3 = 0; i3 < NUM_ROWS; ++i3) {
            if (i3 % 2 == 0) {
                ps1.setInt(1, i3 + 100);
                ps1.setInt(2, i3 + 10);
                ps1.executeUpdate();
                continue;
            }
            ps2.setInt(1, i3 + 10);
            ps2.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        ps = conn.prepareStatement("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            if (i % 2 == 0) {
                CreateHDFSStoreTest.assertTrue((boolean)rs.next());
                CreateHDFSStoreTest.assertEquals((int)(i + 100), (int)rs.getInt(2));
                CreateHDFSStoreTest.assertFalse((boolean)rs.next());
                continue;
            }
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        ps1 = conn.prepareStatement("update t1 set col2 = ? where col3 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            if (i % 2 != 0) continue;
            ps1.setInt(1, i + 200);
            ps1.setInt(2, i + 10);
            ps1.executeUpdate();
        }
        for (i = 0; i < NUM_ROWS; ++i) {
            if (i % 2 != 0) continue;
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertTrue((boolean)rs.next());
            CreateHDFSStoreTest.assertEquals((int)(i + 200), (int)rs.getInt(2));
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        ps2 = conn.prepareStatement("delete from t1 where col3 = ?");
        for (i = 0; i < NUM_ROWS; ++i) {
            if (i % 2 != 0) continue;
            ps2.setInt(1, i + 10);
            ps2.executeUpdate();
        }
        for (i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            rs = ps.executeQuery();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        }
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testReadTombstoneFromHDFS() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BATCHTIMEINTERVAL 10 milliseconds");
        st.execute("create table t1 (col1 int primary key, col2 int, col3 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?, ?)");
        int NUM_ROWS = 2;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.setInt(3, i + 10);
            ps.addBatch();
        }
        ps.executeBatch();
        Thread.sleep(1000L);
        PreparedStatement ps2 = conn.prepareStatement("delete from t1 where col1 = ?");
        ps2.setInt(1, 1);
        ps2.executeUpdate();
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select count(*) from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)0, (int)rs.getInt(1));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
            CreateHDFSStoreTest.assertEquals((int)0, (int)rs.getInt(1));
        }
        CreateHDFSStoreTest.assertEquals((int)1, (int)count);
        st.close();
        conn.setTransactionIsolation(4);
        st = conn.createStatement();
        st.executeUpdate("delete from t1 where col3=5\n");
        conn.commit();
        conn.setTransactionIsolation(0);
        st.execute("select count(*) from t1");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)0, (int)rs.getInt(1));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testDropStore() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        try {
            st.execute("drop hdfsstore myhdfs");
            CreateHDFSStoreTest.fail("Should have received an exception");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
    }

    public void testPutDML_ReplicatedTable() throws Exception {
        Connection conn = CreateHDFSStoreTest.getConnection();
        Statement s = conn.createStatement();
        Object rs = null;
        s.execute("create table hdfsCustomer (warehouseId integer not null, districtId integer not null, districtBalance decimal(12,2)) replicate");
        s.execute("alter table hdfsCustomer add constraint pk_hdfsCustomer primary key (warehouseId, districtId)");
        s.execute("put into hdfsCustomer values (1, 1, 1)");
        s.execute("put into hdfsCustomer values (1, 1, 2)");
        s.execute("create table test2 (col1 int primary key) replicate");
        s.execute("insert into test2 values (5), (4), (3)");
        s.execute("create table test3 (col1 int primary key) replicate ");
        s.execute("insert into test3 values (1), (2), (3)");
        s.execute("put into test2 values (3)");
        s.execute("put into test2 select * from test3 where col1 <= 2");
        s.execute("put into test2 select * from test3");
    }

    public void testEvictionSyntaxHDFSTable() throws Exception {
        Statement s;
        block8: {
            block7: {
                block6: {
                    Connection conn = CreateHDFSStoreTest.getConnection();
                    s = conn.createStatement();
                    Object rs = null;
                    this.checkDirExistence("./myhdfs");
                    s.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' ");
                    s.execute("create table evictTable(id varchar(20) primary key, qty int, ts timestamp) partition by column(id) persistent hdfsstore (myhdfs) eviction by criteria ({fn TIMESTAMPDIFF(SQL_TSI_SECOND, ts, CURRENT_TIMESTAMP)} > 10) eviction frequency 5 seconds");
                    try {
                        s.execute("create table m1 (col1 int primary key , col2 int)  hdfsstore (myhdfs) EVICTION BY LRUMEMSIZE 1000 EVICTACTION DESTROY");
                        CreateHDFSStoreTest.fail("Expect a failure. Reason: LRU eviction is not supported for HDFS tables.");
                    }
                    catch (SQLException e) {
                        if (e.getSQLState().compareTo("0A000") == 0) break block6;
                        throw e;
                    }
                }
                try {
                    s.execute("create table m1 (col1 int primary key , col2 int)  hdfsstore (myhdfs) EVICTION BY LRUCOUNT 2 EVICTACTION DESTROY");
                    CreateHDFSStoreTest.fail("Expect a failure. Reason: LRU eviction is not supported for HDFS tables.");
                }
                catch (SQLException e) {
                    if (e.getSQLState().compareTo("0A000") == 0) break block7;
                    throw e;
                }
            }
            try {
                s.execute("create table m1 (col1 int primary key , col2 int)  hdfsstore (myhdfs) EVICTION BY LRUHEAPPERCENT EVICTACTION DESTROY");
                CreateHDFSStoreTest.fail("Expect a failure. Reason: LRU eviction is not supported for HDFS tables.");
            }
            catch (SQLException e) {
                if (e.getSQLState().compareTo("0A000") == 0) break block8;
                throw e;
            }
        }
        s.execute("drop table evictTable");
        s.execute("drop hdfsstore myhdfs");
    }

    public void testBatchUpdateHDFS() throws Exception {
        int i;
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into app.t1 values (?, ?)");
        for (i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.addBatch();
        }
        ps.executeBatch();
        ps = conn.prepareStatement("update app.t1 set col2 = ? where col1 = ?");
        for (i = 0; i < 2; ++i) {
            ps.setInt(1, i + 2);
            ps.setInt(2, i);
            ps.addBatch();
        }
        ps.executeBatch();
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testBug48939() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = CreateHDFSStoreTest.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("create table mytab (col1 varchar(5) primary key) partition by primary key persistent hdfsstore (myhdfs) writeonly");
        st.execute("insert into mytab values ('abc3')");
        PreparedStatement ps = conn.prepareStatement("delete from mytab where col1 >= ? and col1 <= ?");
        ps.setString(1, "abc0");
        ps.setString(2, "abc5");
        int i = ps.executeUpdate();
        CreateHDFSStoreTest.assertEquals((int)1, (int)i);
        st.execute("drop table mytab");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testBug48944_Replicate() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = CreateHDFSStoreTest.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("create table trade.securities (sec_id int primary key) replicate");
        st.execute("create table trade.customers (cid int primary key) replicate");
        st.execute("create table trade.buyorders (oid int primary key, cid int, sid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id)) replicate");
        st.execute("insert into trade.securities values (11)");
        st.execute("insert into trade.customers values (12)");
        st.execute("put into trade.buyorders values (1, 12, 11)");
        st.execute("put into trade.buyorders values (1, 12, 11)");
    }

    public void testBug48944_Partition() throws Exception {
        block8: {
            Statement st;
            block7: {
                block6: {
                    SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
                    Connection conn = CreateHDFSStoreTest.getConnection();
                    st = conn.createStatement();
                    Object rs = null;
                    st.execute("create table trade.securities (sec_id int primary key) ");
                    st.execute("create table trade.customers (cid int primary key) ");
                    st.execute("create table trade.buyorders (oid int primary key, cid int, sid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id)) ");
                    st.execute("insert into trade.securities values (11)");
                    st.execute("insert into trade.customers values (12)");
                    st.execute("put into trade.buyorders values (1, 12, 11)");
                    st.execute("put into trade.buyorders values (1, 12, 11)");
                    st.execute("create table trade.portfolio (cid int, sid int, tid int, constraint portf_pk primary key (cid, sid)) partition by column (tid)");
                    st.execute("create table trade.sellorders (oid int primary key, cid int, sid int, constraint so_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict) partition by primary key");
                    st.execute("insert into trade.portfolio values (1, 11, 111)");
                    st.execute("put into trade.sellorders values (2, 1, 11)");
                    st.execute("put into trade.sellorders values (3, 1, 11)");
                    st.execute("put into trade.sellorders values (3, 1, 11)");
                    st.execute("create table t1 (col1 int primary key, col2 int, constraint t1_uq unique (col2))");
                    st.execute("put into t1 values (1, 11)");
                    st.execute("put into t1 values (2, 22)");
                    try {
                        st.execute("put into t1 values (1, 22)");
                        CreateHDFSStoreTest.fail("Expect unique constraint violation");
                    }
                    catch (SQLException sqle) {
                        if (sqle.getSQLState().compareTo("23505") == 0) break block6;
                        throw sqle;
                    }
                }
                try {
                    st.execute("put into t1 values (1, 11)");
                    CreateHDFSStoreTest.fail("Expect unique constraint violation");
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState().compareTo("23505") == 0) break block7;
                    throw sqle;
                }
            }
            st.execute("create table t2 (col1 int primary key, col2 int) partition by column (col2)");
            st.execute("put into t2 values (1, 11)");
            st.execute("put into t2 values (1, 11)");
            try {
                st.execute("insert into t2 values (1, 22)");
                CreateHDFSStoreTest.fail("Expect primary key (unique) constraint violation");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().compareTo("23505") == 0) break block8;
                throw sqle;
            }
        }
    }

    public void testBug49004() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = CreateHDFSStoreTest.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("CREATE TABLE trade (t_id BIGINT NOT NULL GENERATED BY DEFAULT AS IDENTITY,  t_st_id CHAR(4) NOT NULL,  t_is_cash SMALLINT NOT NULL CHECK (t_is_cash in (0, 1))) EVICTION BY CRITERIA ( t_st_id = 'CMPT') EVICT INCOMING HDFSSTORE (myhdfs)");
        st.execute("drop table trade");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testBug48983() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds");
        st.execute("create table trade.customers (cid int primary key) partition by primary key hdfsstore (myhdfs)");
        st.execute("create table trade.securities (sec_id int primary key) partition by primary key hdfsstore (myhdfs)");
        st.execute("create table trade.buyorders (oid int primary key, cid int, sid int, bid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid), constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id)) partition by column (bid) hdfsstore (myhdfs)");
        st.execute("insert into trade.customers values (1)");
        st.execute("insert into trade.securities values (11)");
        PreparedStatement ps = conn.prepareStatement("insert into trade.buyorders values (?, 1, 11, ?)");
        for (int i = 0; i < 100; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        st.execute("select * from trade.buyorders");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)100, (int)count);
        String qname = null;
        qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/TRADE/CUSTOMERS");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/TRADE/SECURITIES");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/TRADE/BUYORDERS");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("insert into trade.customers values (2)");
        st.execute("insert into trade.securities values (22)");
        ps = conn.prepareStatement("insert into trade.buyorders values (?, 2, 22, ?)");
        for (int i = 100; i < 200; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i);
            ps.executeUpdate();
        }
        st.execute("select * from trade.buyorders");
        rs = st.getResultSet();
        count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)100, (int)count);
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props2 = new Properties();
        props2.put("query-HDFS", "true");
        conn = TestUtil.getConnection(props2);
        st = conn.createStatement();
        st.execute("select * from trade.buyorders");
        rs = st.getResultSet();
        count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)200, (int)count);
        st.execute("drop table trade.buyorders");
        st.execute("drop table trade.customers");
        st.execute("drop table trade.securities");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThinClientConnectionProperties() throws Exception {
        int i;
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' BatchTimeInterval 100 milliseconds");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i2 = 0; i2 < NUM_ROWS; ++i2) {
            ps.setInt(1, i2);
            ps.setInt(2, i2 + 1);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        CreateHDFSStoreTest.setupConnection();
        Properties props = new Properties();
        props.setProperty("query-HDFS", "true");
        conn = CreateHDFSStoreTest.startNetserverAndGetLocalNetConnection(props);
        st = conn.createStatement();
        final boolean[] callbackInvoked = new boolean[]{false, false, false};
        GemFireXDQueryObserverAdapter gfxdAdapter = new GemFireXDQueryObserverAdapter(){

            public void beforeQueryExecution(GenericPreparedStatement stmt, LanguageConnectionContext lcc) {
                if (stmt != null) {
                    callbackInvoked[0] = stmt.hasQueryHDFS();
                    callbackInvoked[1] = stmt.getQueryHDFS();
                }
                if (lcc != null) {
                    callbackInvoked[2] = lcc.getQueryHDFS();
                }
            }
        };
        GemFireXDQueryObserverHolder nullHolder = new GemFireXDQueryObserverHolder();
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)gfxdAdapter);
            st.execute("select * from t1 order by col1");
            rs = st.getResultSet();
            this.checkHDFSIteratorResultSet(rs, NUM_ROWS);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[0]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[1]);
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[2]);
        }
        finally {
            callbackInvoked[2] = false;
            callbackInvoked[1] = false;
            callbackInvoked[0] = false;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)nullHolder);
        }
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)gfxdAdapter);
            ps = conn.prepareStatement("select * from t1 where col1 = ?");
            for (i = 0; i < NUM_ROWS; ++i) {
                ps.setInt(1, i);
                rs = ps.executeQuery();
                CreateHDFSStoreTest.assertTrue((boolean)rs.next());
                CreateHDFSStoreTest.assertEquals((int)(i + 1), (int)rs.getInt(2));
                CreateHDFSStoreTest.assertFalse((boolean)rs.next());
            }
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[0]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[1]);
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[2]);
        }
        finally {
            callbackInvoked[2] = false;
            callbackInvoked[1] = false;
            callbackInvoked[0] = false;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)nullHolder);
        }
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)gfxdAdapter);
            st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=false \n");
            rs = st.getResultSet();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[0]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[1]);
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[2]);
        }
        finally {
            callbackInvoked[2] = false;
            callbackInvoked[1] = false;
            callbackInvoked[0] = false;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)nullHolder);
        }
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)gfxdAdapter);
            st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=false \n");
            rs = st.getResultSet();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[0]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[1]);
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[2]);
        }
        finally {
            callbackInvoked[2] = false;
            callbackInvoked[1] = false;
            callbackInvoked[0] = false;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)nullHolder);
        }
        CreateHDFSStoreTest.shutDown();
        CreateHDFSStoreTest.setupConnection();
        props = new Properties();
        props.setProperty("query-HDFS", "false");
        conn = CreateHDFSStoreTest.startNetserverAndGetLocalNetConnection(props);
        st = conn.createStatement();
        try {
            callbackInvoked[2] = true;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)gfxdAdapter);
            st.execute("select * from t1");
            rs = st.getResultSet();
            CreateHDFSStoreTest.assertFalse((boolean)rs.next());
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[0]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[1]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[2]);
        }
        finally {
            callbackInvoked[2] = false;
            callbackInvoked[1] = false;
            callbackInvoked[0] = false;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)nullHolder);
        }
        try {
            callbackInvoked[2] = true;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)gfxdAdapter);
            ps = conn.prepareStatement("select * from t1 where col1 = ? ");
            for (i = 0; i < NUM_ROWS; ++i) {
                ps.setInt(1, i);
                rs = ps.executeQuery();
                CreateHDFSStoreTest.assertFalse((boolean)rs.next());
            }
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[0]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[1]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[2]);
        }
        finally {
            callbackInvoked[2] = false;
            callbackInvoked[1] = false;
            callbackInvoked[0] = false;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)nullHolder);
        }
        try {
            callbackInvoked[2] = true;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)gfxdAdapter);
            ps = conn.prepareStatement("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n where col1 = ?");
            for (i = 0; i < NUM_ROWS; ++i) {
                ps.setInt(1, i);
                rs = ps.executeQuery();
                CreateHDFSStoreTest.assertTrue((boolean)rs.next());
                CreateHDFSStoreTest.assertEquals((int)(i + 1), (int)rs.getInt(2));
                CreateHDFSStoreTest.assertFalse((boolean)rs.next());
            }
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[0]);
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[1]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[2]);
        }
        finally {
            callbackInvoked[2] = false;
            callbackInvoked[1] = false;
            callbackInvoked[0] = false;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)nullHolder);
        }
        try {
            callbackInvoked[2] = true;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)gfxdAdapter);
            st.execute("select * from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true \n order by col1");
            rs = st.getResultSet();
            this.checkHDFSIteratorResultSet(rs, NUM_ROWS);
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[0]);
            CreateHDFSStoreTest.assertTrue((boolean)callbackInvoked[1]);
            CreateHDFSStoreTest.assertFalse((boolean)callbackInvoked[2]);
        }
        finally {
            callbackInvoked[2] = false;
            callbackInvoked[1] = false;
            callbackInvoked[0] = false;
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)nullHolder);
        }
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testBug48983_1() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        props.put("query-HDFS", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'  BatchTimeInterval 100 milliseconds");
        st.execute("create table trade.securities (sec_id int primary key) partition by primary key hdfsstore (myhdfs)");
        st.execute("create table trade.buyorders(oid int primary key, cid int, sid int, qty int, bid int, tid int, constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id) on delete restrict) partition by primary key hdfsstore (myhdfs)");
        st.execute("insert into trade.securities values (123)");
        st.execute("insert into trade.buyorders values (1, 11, 123, 10, 10, 1)");
        st.execute("insert into trade.buyorders values (2, 11, 123, 11, 11, 1)");
        st.execute("insert into trade.buyorders values (3, 22, 123, 10, 10, 1)");
        st.execute("insert into trade.buyorders values (4, 22, 123, 11, 11, 1)");
        st.execute("insert into trade.buyorders values (5, 33, 123, 12, 12, 2)");
        PreparedStatement ps = conn.prepareStatement("select cid, max(qty*bid) as largest_order from trade.buyorders where tid =?  GROUP BY cid HAVING max(qty*bid) > 20 ORDER BY largest_order DESC, cid DESC");
        ps.setInt(1, 1);
        rs = ps.executeQuery();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)22, (int)rs.getInt(1));
        CreateHDFSStoreTest.assertEquals((int)121, (int)rs.getInt(2));
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)11, (int)rs.getInt(1));
        CreateHDFSStoreTest.assertEquals((int)121, (int)rs.getInt(2));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/TRADE/SECURITIES");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/TRADE/BUYORDERS");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props2 = new Properties();
        props2.put("query-HDFS", "true");
        conn = TestUtil.getConnection(props2);
        ps = conn.prepareStatement("insert into trade.buyorders values (?, 33, 123, 12, 12, 2)");
        for (int i = 0; i < 100; ++i) {
            ps.setInt(1, i + 6);
            ps.executeUpdate();
        }
        ps = conn.prepareStatement("select cid, max(qty*bid) as largest_order from trade.buyorders where tid =?  GROUP BY cid HAVING max(qty*bid) > 20 ORDER BY largest_order DESC, cid DESC");
        ps.setInt(1, 1);
        rs = ps.executeQuery();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)22, (int)rs.getInt(1));
        CreateHDFSStoreTest.assertEquals((int)121, (int)rs.getInt(2));
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)11, (int)rs.getInt(1));
        CreateHDFSStoreTest.assertEquals((int)121, (int)rs.getInt(2));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st = conn.createStatement();
        st.execute("drop table trade.buyorders");
        st.execute("drop table trade.securities");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testBug49277() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("create table trade.customers (cid int primary key) partition by primary key");
        st.execute("create table trade.securities (sec_id int primary key) partition by primary key");
        st.execute("create table trade.buyorders (oid int primary key, cid int, sid int, bid int, note varchar(10), constraint bo_cust_fk foreign key (cid) references trade.customers (cid), constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id)) partition by column (bid)");
        st.execute("create table trade.buyorders_fulldataset (oid int primary key, cid int, sid int, bid int, note varchar(10), constraint bo_cust_fk2 foreign key (cid) references trade.customers (cid), constraint bo_sec_fk2 foreign key (sid) references trade.securities (sec_id)) partition by column (bid)");
        st.execute(" CREATE  TRIGGER  trade.buyorders_INSERTTRIGGER AFTER INSERT ON trade.buyorders REFERENCING NEW AS NEWROW FOR EACH ROW   INSERT INTO TRADE.BUYORDERS_FULLDATASET  VALUES (NEWROW.OID, NEWROW.CID, NEWROW.SID, NEWROW.BID, NEWROW.NOTE)");
        st.execute("insert into trade.customers values (11)");
        st.execute("insert into trade.securities values (22)");
        PreparedStatement ps = conn.prepareStatement("put into trade.buyorders values (?, ?, ?, ?, ?)");
        ps.setInt(1, 33);
        ps.setInt(2, 11);
        ps.setInt(3, 22);
        ps.setInt(4, 44);
        ps.setString(5, null);
        ps.executeUpdate();
    }

    public void test48641() throws Exception {
        Connection conn = CreateHDFSStoreTest.getConnection();
        Statement s = conn.createStatement();
        Object rs = null;
        this.checkDirExistence("./myhdfs");
        s.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'  BatchTimeInterval 100 milliseconds");
        s.execute("create table m1 (col11 int primary key , col12 int) partition by primary key hdfsstore (myhdfs)");
        s.execute("create table m2 (col21 int primary key, col22 int, constraint fk1 foreign key (col22) references m1 (col11)) partition by primary key colocate with (m1) hdfsstore (myhdfs)");
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/M1");
        s.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection();
        s = conn.createStatement();
        s.execute("drop table m2");
        s.execute("drop table m1");
        s.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testBug49294() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        props.put("query-HDFS", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs' ");
        st.execute("create table t1 (col1 int primary key, col2 int) partition by column (col2) eviction by criteria (col2 > 0) evict incoming hdfsstore (myhdfs)");
        st.execute("insert into t1 values (1, 11)");
        st.execute("select * from t1 --GEMFIREXD-PROPERTIES queryHDFS=false \n");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("select * from t1 --GEMFIREXD-PROPERTIES queryHDFS=true \n");
        rs = st.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)11, (int)rs.getInt(2));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("CREATE PROCEDURE QUERY_TABLE() LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA DYNAMIC RESULT SETS 1 EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Rollup.queryTable'");
        CallableStatement cs = conn.prepareCall("CALL QUERY_TABLE() ON TABLE T1");
        cs.execute();
        rs = cs.getResultSet();
        CreateHDFSStoreTest.assertTrue((boolean)rs.next());
        CreateHDFSStoreTest.assertEquals((int)11, (int)rs.getInt(2));
        CreateHDFSStoreTest.assertFalse((boolean)rs.next());
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testRootDirSysProperty() throws Exception {
        boolean dirStatus = this.fs.exists(new Path("."));
        CreateHDFSStoreTest.assertFalse((boolean)dirStatus);
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir 'myhdfs' ");
        dirStatus = this.fs.exists(new Path("./myhdfs"));
        CreateHDFSStoreTest.assertTrue((boolean)dirStatus);
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.close();
        CreateHDFSStoreTest.shutDown();
        dirStatus = this.fs.exists(new Path("/xd"));
        CreateHDFSStoreTest.assertFalse((boolean)dirStatus);
        props = new Properties();
        props.put("hdfs-root-dir", "/xd");
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir 'myhdfs' ");
        dirStatus = this.fs.exists(new Path("/xd/myhdfs"));
        CreateHDFSStoreTest.assertTrue((boolean)dirStatus);
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.close();
        CreateHDFSStoreTest.shutDown();
        this.fs.delete(new Path("/xd"), true);
        dirStatus = this.fs.exists(new Path("/xd"));
        CreateHDFSStoreTest.assertFalse((boolean)dirStatus);
        dirStatus = this.fs.exists(new Path("/absolute"));
        CreateHDFSStoreTest.assertFalse((boolean)dirStatus);
        props = new Properties();
        props.put("hdfs-root-dir", "/xd");
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir '/absolute' ");
        dirStatus = this.fs.exists(new Path("/absolute"));
        CreateHDFSStoreTest.assertTrue((boolean)dirStatus);
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.close();
        CreateHDFSStoreTest.shutDown();
        dirStatus = this.fs.exists(new Path("/xd/relative"));
        CreateHDFSStoreTest.assertFalse((boolean)dirStatus);
        props = new Properties();
        props.put("hdfs-root-dir", "/xd/");
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './relative' ");
        dirStatus = this.fs.exists(new Path("/xd/relative"));
        CreateHDFSStoreTest.assertTrue((boolean)dirStatus);
        st.execute("drop hdfsstore myhdfs");
        st.close();
        conn.close();
        CreateHDFSStoreTest.shutDown();
    }

    public void testBug48894() throws Exception {
        block2: {
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            Object rs = null;
            try {
                st.execute("create table t1 (col1 int primary key, col2 int) partition by column (col2)");
                st.execute("put into t1 values (11, 33)");
                st.execute("put into t1 values (11, 44)");
                CreateHDFSStoreTest.fail("PUT DML is updating the partitioning column");
            }
            catch (SQLException e) {
                if (e.getSQLState().compareTo("0A000") == 0) break block2;
                throw e;
            }
        }
    }

    public void testBug49788() throws Exception {
        Properties props = new Properties();
        props.setProperty("skip-constraint-checks", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("create table t1 (co1 int primary key, col2 int) partition by primary key");
        st.execute("insert into t1 values (11, 12)");
        st.execute("insert into t1 values (11, 34)");
        st.execute("insert into t1 values (11, 12), (11, 34)");
    }

    public void testBug49661_QueryHint() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("create table trade.txhistory(cid int, tid int) partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))  PERSISTENT SYNCHRONOUS EVICTION BY CRITERIA ( CID >= 20 ) EVICT INCOMING HDFSSTORE (myhdfs)");
        st.execute("create  index index_11 on trade.txhistory ( TID desc  )");
        st.execute("create index index_17 on trade.txhistory ( CID   )");
        PreparedStatement ps = conn.prepareStatement("insert into trade.txhistory values (?, ?)");
        for (int i = 0; i < 100; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        Thread.sleep(10000L);
        st.execute("select * from TRADE.TXHISTORY -- GEMFIREXD-PROPERTIES queryHDFS=true \n where TID >= 0  or CID >= 0");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)100, (int)count);
        st.execute("drop table trade.txhistory");
        st.execute("drop hdfsstore myhdfs");
    }

    public void testBug49661_ConnectionProperty() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("query-HDFS", "true");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("create table trade.txhistory(cid int, tid int) partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))  PERSISTENT SYNCHRONOUS EVICTION BY CRITERIA ( CID >= 20 ) EVICT INCOMING HDFSSTORE (myhdfs)");
        st.execute("create  index index_11 on trade.txhistory ( TID desc  )");
        st.execute("create index index_17 on trade.txhistory ( CID   )");
        PreparedStatement ps = conn.prepareStatement("insert into trade.txhistory values (?, ?)");
        for (int i = 0; i < 100; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        Thread.sleep(10000L);
        st.execute("select * from TRADE.TXHISTORY where TID >= 0  or CID >= 0");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        CreateHDFSStoreTest.assertEquals((int)100, (int)count);
        st.execute("drop table trade.txhistory");
        st.execute("drop hdfsstore myhdfs");
    }

    public void testRowExpiration() throws Exception {
        Connection conn = TestUtil.getConnection();
        if (isTransactional) {
            return;
        }
        Statement st = conn.createStatement();
        ResultSet rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("create table t1 (col1 int primary key, col2 int) expire entry with timetolive 15 action destroy hdfsstore (myhdfs)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        rs = st.executeQuery("select count(*) from t1");
        rs.next();
        CreateHDFSStoreTest.assertEquals((int)NUM_ROWS, (int)rs.getInt(1));
        rs.close();
        st.execute("CALL SYS.HDFS_FLUSH_QUEUE('APP.T1', 0)");
        Thread.sleep(30000L);
        rs = st.executeQuery("select count(*) from t1");
        rs.next();
        CreateHDFSStoreTest.assertEquals((int)0, (int)rs.getInt(1));
        rs.close();
        rs = st.executeQuery("select count(*) from t1 -- GEMFIREXD-PROPERTIES queryHDFS=true");
        rs.next();
        CreateHDFSStoreTest.assertEquals((int)NUM_ROWS, (int)rs.getInt(1));
        rs.close();
        st = conn.createStatement();
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testBug49794() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        ResultSet rs = null;
        st.execute("create table t1 (col1 int primary key, col2 int) partition by primary key");
        st.execute("create table t3 (col1 int primary key, col2 int) partition by primary key");
        st.execute("create trigger tg3 AFTER INSERT on t1 referencing new as newinsert for each ROW insert into t3 values (newinsert.col1, newinsert.col2)");
        st.execute("create trigger tg7 AFTER UPDATE on t1 referencing new as newupdate for each ROW update t3 set col2 = col2 + 1 where col1 = newupdate.col1");
        st.execute("insert into t1 values (12, 34)");
        st.execute("update t1 set col2 = col2 + 1 where col1 = 12");
        st.execute("put into t1 values (12, 56)");
        st.execute("put into t1 values (78, 90)");
        Object[][] expectedOutput1 = new Object[][]{{12, 56}, {78, 90}};
        Object[][] expectedOutput3 = new Object[][]{{12, 35}};
        st.execute("select * from t1");
        rs = st.getResultSet();
        JDBC.assertUnorderedResultSet(rs, expectedOutput1, false);
        st.execute("select * from t3");
        rs = st.getResultSet();
        JDBC.assertUnorderedResultSet(rs, expectedOutput3, false);
    }

    public static MiniDFSCluster initMiniCluster(int port, int numDN) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dfs.replication", "1");
        return CreateHDFSStoreTest.initMiniCluster(port, numDN, map);
    }

    public static MiniDFSCluster initMiniCluster(int port, int numDN, HashMap<String, String> map) throws Exception {
        System.setProperty("test.build.data", "hdfs-test-cluster");
        HdfsConfiguration hconf = new HdfsConfiguration();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            hconf.set(entry.getKey(), entry.getValue());
        }
        MiniDFSCluster.Builder builder = new MiniDFSCluster.Builder((Configuration)hconf);
        builder.numDataNodes(numDN);
        builder.nameNodePort(port);
        MiniDFSCluster cluster = builder.build();
        return cluster;
    }

    public void deleteMiniClusterDir() throws Exception {
        File clusterDir = new File("hdfs-test-cluster");
        this.delete(clusterDir);
    }

    public void testStats() throws Exception {
        int i;
        Properties props = new Properties();
        props.setProperty("mcast-port", AvailablePort.getRandomAvailablePort((int)1) + "");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        Object rs = null;
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'hdfs://127.0.0.1:" + this.port + "' homedir './myhdfs'");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs) persistent");
        PreparedStatement ps = conn.prepareStatement("insert into app.t1 values (?, ?)");
        for (i = 0; i < 100; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.addBatch();
        }
        ps.executeBatch();
        ps = conn.prepareStatement("update app.t1 set col2 = ? where col1 = ?");
        for (i = 0; i < 2; ++i) {
            ps.setInt(1, i + 2);
            ps.setInt(2, i);
            ps.addBatch();
        }
        ps.executeBatch();
        LogWriterI18n logger = GemFireCacheImpl.getExisting().getLoggerI18n();
        TestUtil.shutDown();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        Thread.sleep(5000L);
        GemFireCacheImpl cache = GemFireCacheImpl.getExisting();
        Set infos = PartitionRegionHelper.getPartitionRegionInfo((Cache)cache);
        long bytesFromInfo = -1L;
        for (PartitionRegionInfo info : infos) {
            if (!info.getRegionPath().contains("/APP/T1")) continue;
            PartitionMemberInfo memberInfo = (PartitionMemberInfo)info.getPartitionMemberInfo().iterator().next();
            bytesFromInfo = memberInfo.getSize();
        }
        PartitionedRegion region = (PartitionedRegion)cache.getRegion("/APP/T1");
        DiskRegionStats drStats = region.getDiskRegionStats();
        PartitionedRegionStats prStats = region.getPrStats();
        CreateHDFSStoreTest.assertEquals((long)0L, (long)drStats.getNumOverflowOnDisk());
        CreateHDFSStoreTest.assertEquals((long)bytesFromInfo, (long)prStats.getDataStoreBytesInUse());
        st.execute("select * from app.t1 where col1=5");
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testWarningWhenTableNotPersistent() throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("set schema emp");
        this.checkDirExistence("./myhdfs");
        st.execute("create hdfsstore myhdfs namenode 'localhost" + this.port + "' homedir './myhdfs'");
        st.execute("create table mytab1 (col1 int primary key)");
        SQLWarning sw = st.getWarnings();
        CreateHDFSStoreTest.assertNull((Object)sw);
        st.execute("create table mytab (col1 int primary key) persistent hdfsstore (myhdfs) ");
        sw = st.getWarnings();
        CreateHDFSStoreTest.assertNull((Object)sw);
        st.execute("create DiskStore testDiskStore");
        st.execute("create table mytab2 (col1 int primary key) persistent 'testDiskStore' hdfsstore (myhdfs) writeonly");
        sw = st.getWarnings();
        CreateHDFSStoreTest.assertNull((Object)sw);
        st.execute("create table mytab3 (col1 int primary key) persistent 'testDiskStore' ");
        sw = st.getWarnings();
        CreateHDFSStoreTest.assertNull((Object)sw);
        st.execute("create table mytab4 (col1 int primary key)  hdfsstore (myhdfs) ");
        sw = st.getWarnings();
        String sqlState = sw.getSQLState();
        CreateHDFSStoreTest.assertEquals((String)sqlState, (String)"0150A");
        CreateHDFSStoreTest.assertTrue((boolean)sw.getMessage().contains(" MYTAB4 "));
        CreateHDFSStoreTest.assertNull((Object)sw.getNextWarning());
        st.execute("create table mytab5 (col1 int primary key)  hdfsstore (myhdfs) writeonly");
        sw = st.getWarnings();
        sqlState = sw.getSQLState();
        CreateHDFSStoreTest.assertEquals((String)sqlState, (String)"0150A");
        CreateHDFSStoreTest.assertTrue((boolean)sw.getMessage().contains(" MYTAB5 "));
        CreateHDFSStoreTest.assertNull((Object)sw.getNextWarning());
        st.execute("drop table mytab");
        st.execute("drop table mytab1");
        st.execute("drop table mytab2");
        st.execute("drop table mytab3");
        st.execute("drop table mytab5");
        st.execute("drop table mytab4");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    public void testIteratorReturnsRemovedQueueEvents() throws Exception {
        this.reduceLogLevelForTest("config");
        CreateHDFSStoreTest.setupConnection();
        Connection conn = jdbcConn;
        conn.setAutoCommit(false);
        Statement stmt = conn.createStatement();
        this.checkDirExistence("./myhdfs");
        stmt.execute("create hdfsstore hdfsdata namenode 'hdfs://localhost:" + this.port + "' homedir './myhdfs' " + "batchtimeinterval 100000 seconds");
        stmt.execute("create table t1(id int)  persistent hdfsstore (hdfsdata) buckets 1");
        for (int i = 1; i <= 100; ++i) {
            stmt.executeUpdate("insert into t1 values (" + i + " )");
        }
        CreateHDFSStoreTest.assertTrue((boolean)stmt.execute("select * from  t1 -- GEMFIREXD-PROPERTIES queryHDFS=true"));
        ResultSet rs = stmt.getResultSet();
        int index = 0;
        HashSet<Integer> ids = new HashSet<Integer>();
        while (rs.next()) {
            ids.add(rs.getInt("id"));
            if (index > 10) break;
            ++index;
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        Statement stmt1 = conn.createStatement();
        stmt1.execute("call SYS.HDFS_FLUSH_QUEUE('APP.T1', 30000)");
        stmt1.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        while (rs.next()) {
            ids.add(rs.getInt("id"));
        }
        CreateHDFSStoreTest.assertEquals((int)100, (int)ids.size());
        for (int i = 1; i <= 100; ++i) {
            CreateHDFSStoreTest.assertTrue((boolean)ids.contains(i));
        }
        conn.commit();
        stmt.execute("drop table t1");
        stmt.execute("drop hdfsstore hdfsdata");
        this.delete(new File("./myhdfs"));
    }

    public void testforcefilerollover() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("create hdfsstore myhdfs namenode 'hdfs://localhost:" + this.port + "' homedir './myhdfs'  batchtimeinterval 1 milliseconds ");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs) writeonly buckets 73");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 300;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        CreateHDFSStoreTest.assertEquals((int)this.getExtensioncount("MYHDFS", ".shop.tmp"), (int)73);
        CreateHDFSStoreTest.assertEquals((int)this.getExtensioncount("MYHDFS", ".shop"), (int)0);
        st.execute("CALL SYS.HDFS_FORCE_WRITEONLY_FILEROLLOVER('APP.t1', 100)");
        CreateHDFSStoreTest.assertEquals((int)this.getExtensioncount("MYHDFS", ".shop.tmp"), (int)73);
        CreateHDFSStoreTest.assertEquals((int)this.getExtensioncount("MYHDFS", ".shop"), (int)0);
        st.execute("CALL SYS.HDFS_FORCE_WRITEONLY_FILEROLLOVER('APP.t1' , 0)");
        CreateHDFSStoreTest.assertEquals((int)this.getExtensioncount("MYHDFS", ".shop.tmp"), (int)0);
        CreateHDFSStoreTest.assertEquals((int)this.getExtensioncount("MYHDFS", ".shop"), (int)73);
        st.execute("drop table t1");
        st.execute("drop hdfsstore myhdfs");
        this.delete(new File("./myhdfs"));
    }

    protected int getExtensioncount(String hdfsstore, String extension) throws Exception {
        int counter = 0;
        HDFSStoreImpl hdfsStore = GemFireCacheImpl.getInstance().findHDFSStore(hdfsstore);
        FileSystem fs = hdfsStore.getFileSystem();
        try {
            Path basePath = new Path(hdfsStore.getHomeDir());
            RemoteIterator files = fs.listFiles(basePath, true);
            while (files.hasNext()) {
                HashMap entriesMap = new HashMap();
                LocatedFileStatus next = (LocatedFileStatus)files.next();
                if (!next.getPath().getName().endsWith(extension)) continue;
                ++counter;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return counter;
    }

    public void testforcefilerolloverexceptions() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("create hdfsstore myhdfs namenode 'hdfs://localhost:" + this.port + "' homedir './myhdfs'  batchtimeinterval 1 milliseconds ");
        st.execute("create table t1 (col1 int primary key, col2 int) hdfsstore (myhdfs) writeonly");
        st.execute("create table t2 (col1 int primary key, col2 int) hdfsstore (myhdfs) ");
        st.execute("create table t3 (col1 int primary key, col2 int)");
        PreparedStatement ps = conn.prepareStatement("insert into t1 values (?, ?)");
        int NUM_ROWS = 100;
        for (int i = 0; i < NUM_ROWS; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, i + 1);
            ps.executeUpdate();
        }
        String qname = HDFSStoreFactoryImpl.getEventQueueName((String)"/APP/T1");
        st.execute("CALL SYS.WAIT_FOR_SENDER_QUEUE_FLUSH('" + qname + "', 1, 0)");
        boolean exThrown = false;
        try {
            st.execute("CALL SYS.HDFS_FORCE_WRITEONLY_FILEROLLOVER('APP.T2', 0)");
        }
        catch (SQLFeatureNotSupportedException e) {
            exThrown = true;
        }
        CreateHDFSStoreTest.assertTrue((String)"Should have thrown exception for non write only table", (boolean)exThrown);
        exThrown = false;
        try {
            st.execute("CALL SYS.HDFS_FORCE_WRITEONLY_FILEROLLOVER('APP.t3', 0)");
        }
        catch (SQLFeatureNotSupportedException e) {
            exThrown = true;
        }
        CreateHDFSStoreTest.assertTrue((String)"Should have thrown exception for non hdfs table", (boolean)exThrown);
        exThrown = false;
        this.delete(new File("./hdfs-test-cluster"));
        CreateHDFSStoreTest.addExpectedException(IOException.class);
        CreateHDFSStoreTest.addExpectedException(EOFException.class);
        CreateHDFSStoreTest.addExpectedException(FileNotFoundException.class);
        try {
            st.execute("CALL SYS.HDFS_FORCE_WRITEONLY_FILEROLLOVER('APP.T1', 0)");
        }
        catch (SQLException e) {
            CreateHDFSStoreTest.assertTrue((String)"Should be a IOException", (boolean)(e.getCause() instanceof IOException));
            exThrown = true;
        }
        CreateHDFSStoreTest.assertTrue((String)"Should fail with an IOException", (boolean)exThrown);
        exThrown = false;
        st.execute("drop table t1");
        st.execute("drop table t2");
        st.execute("drop table t3");
        st.execute("drop hdfsstore myhdfs");
        this.tearDown();
        CreateHDFSStoreTest.removeExpectedException(IOException.class);
        CreateHDFSStoreTest.removeExpectedException(EOFException.class);
        CreateHDFSStoreTest.removeExpectedException(FileNotFoundException.class);
    }
}

