/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.jdbc.SimpleAppTest;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class CreateDiskStoreTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(SimpleAppTest.class));
    }

    public CreateDiskStoreTest(String name) {
        super(name);
    }

    public void testDiskStoreWithDefaultConfig() throws SQLException {
        Connection conn = CreateDiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create DiskStore testDiskStore1");
        DiskStoreImpl ds = Misc.getGemFireCache().findDiskStore("TESTDISKSTORE1");
        CreateDiskStoreTest.assertEquals((boolean)ds.getAllowForceCompaction(), (boolean)false);
        CreateDiskStoreTest.assertEquals((boolean)ds.getAutoCompact(), (boolean)true);
        CreateDiskStoreTest.assertEquals((int)ds.getCompactionThreshold(), (int)50);
        CreateDiskStoreTest.assertEquals((long)ds.getMaxOplogSize(), (long)DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE);
        CreateDiskStoreTest.assertEquals((int)ds.getQueueSize(), (int)0);
        CreateDiskStoreTest.assertEquals((long)ds.getTimeInterval(), (long)1000L);
        CreateDiskStoreTest.assertEquals((int)ds.getWriteBufferSize(), (int)32768);
        CreateDiskStoreTest.assertEquals((int)ds.getDiskDirs().length, (int)1);
        CreateDiskStoreTest.assertEquals((String)ds.getDiskDirs()[0].getAbsolutePath(), (String)new File(".").getAbsolutePath());
        CreateDiskStoreTest.assertNotNull((Object)ds);
        s = conn.createStatement();
        s.execute("drop DiskStore testDiskStore1");
    }

    public void testDiskStoreConfig1() throws Exception {
        Connection conn = CreateDiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        File f1 = new File("dir1");
        f1.mkdir();
        File f2 = new File("dir2");
        f2.mkdir();
        File f3 = new File("dir3");
        f3.mkdir();
        s.execute("create DiskStore testDiskStore2 maxlogsize 448 autocompact false  allowforcecompaction true compactionthreshold 80 TimeInterval 23344 Writebuffersize 192923 queuesize 1734  ('dir1' 456, 'dir2', 'dir3' 55556 )");
        DiskStoreImpl ds = Misc.getGemFireCache().findDiskStore("TESTDISKSTORE2");
        CreateDiskStoreTest.assertNotNull((Object)ds);
        CreateDiskStoreTest.assertEquals((boolean)ds.getAllowForceCompaction(), (boolean)true);
        CreateDiskStoreTest.assertEquals((boolean)ds.getAutoCompact(), (boolean)false);
        CreateDiskStoreTest.assertEquals((int)ds.getCompactionThreshold(), (int)80);
        CreateDiskStoreTest.assertEquals((long)448L, (long)ds.getMaxOplogSize());
        CreateDiskStoreTest.assertEquals((int)ds.getQueueSize(), (int)1734);
        CreateDiskStoreTest.assertEquals((long)ds.getTimeInterval(), (long)23344L);
        CreateDiskStoreTest.assertEquals((int)ds.getWriteBufferSize(), (int)192923);
        CreateDiskStoreTest.assertEquals((int)ds.getDiskDirs().length, (int)3);
        HashSet<String> files = new HashSet<String>();
        files.add(new File(".", "dir1").getAbsolutePath());
        files.add(new File(".", "dir2").getAbsolutePath());
        files.add(new File(".", "dir3").getAbsolutePath());
        CreateDiskStoreTest.assertEquals((int)ds.getDiskDirs().length, (int)3);
        for (File file : ds.getDiskDirs()) {
            CreateDiskStoreTest.assertTrue((boolean)files.remove(file.getAbsolutePath()));
        }
        CreateDiskStoreTest.assertTrue((boolean)files.isEmpty());
        ArrayList<Long> sizes = new ArrayList<Long>();
        int i = 0;
        sizes.add(456L);
        sizes.add(0L);
        sizes.add(55556L);
        int[] arr$ = ds.getDiskDirSizes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long size = arr$[i$];
            CreateDiskStoreTest.assertEquals((long)size, (long)((Long)sizes.get(i++)));
        }
        s.execute("drop DiskStore testDiskStore2");
    }

    public void testDiskStoreConfig2() throws SQLException {
        Connection conn = CreateDiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        File f1 = new File("dir1");
        f1.mkdir();
        File f2 = new File("dir2");
        f2.mkdir();
        s.execute("create DiskStore testDiskStore3 ('dir1', 'dir2') WriteBufferSize 7878");
        DiskStoreImpl ds = Misc.getGemFireCache().findDiskStore("TESTDISKSTORE3");
        CreateDiskStoreTest.assertEquals((boolean)ds.getAllowForceCompaction(), (boolean)false);
        CreateDiskStoreTest.assertEquals((boolean)ds.getAutoCompact(), (boolean)true);
        CreateDiskStoreTest.assertEquals((int)ds.getCompactionThreshold(), (int)50);
        CreateDiskStoreTest.assertEquals((long)ds.getMaxOplogSize(), (long)DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE);
        CreateDiskStoreTest.assertEquals((int)ds.getQueueSize(), (int)0);
        CreateDiskStoreTest.assertEquals((long)ds.getTimeInterval(), (long)1000L);
        CreateDiskStoreTest.assertEquals((int)ds.getWriteBufferSize(), (int)7878);
        CreateDiskStoreTest.assertEquals((int)ds.getDiskDirs().length, (int)2);
        HashSet<String> files = new HashSet<String>();
        files.add(new File(".", "dir1").getAbsolutePath());
        files.add(new File(".", "dir2").getAbsolutePath());
        CreateDiskStoreTest.assertEquals((int)ds.getDiskDirs().length, (int)2);
        for (File file : ds.getDiskDirs()) {
            CreateDiskStoreTest.assertTrue((boolean)files.remove(file.getAbsolutePath()));
        }
        CreateDiskStoreTest.assertTrue((boolean)files.isEmpty());
        CreateDiskStoreTest.assertNotNull((Object)ds);
        s = conn.createStatement();
        s.execute("drop DiskStore testDiskStore3");
    }

    public void testSysDiskstoreTable() throws Exception {
        Connection conn = CreateDiskStoreTest.getConnection();
        Statement s = conn.createStatement();
        File f1 = new File(".", "dir1");
        f1.mkdir();
        File f2 = new File(".", "dir2");
        f2.mkdir();
        File f3 = new File(".", "dir3");
        f3.mkdir();
        s.execute("create DiskStore testDiskStore1 maxlogsize 128 autocompact false  allowforcecompaction true compactionthreshold 80 TimeInterval 23344 Writebuffersize 192923 queuesize 1734  ('dir1' 456, 'dir2', 'dir3' 55556 )");
        ResultSet rs = s.executeQuery("select * from SYS.SYSDISKSTORES where NAME = 'TESTDISKSTORE1'");
        ResultSetMetaData rsmd = rs.getMetaData();
        CreateDiskStoreTest.assertEquals((int)rsmd.getColumnCount(), (int)9);
        block11: for (int i = 1; i < 10; ++i) {
            String name = rsmd.getColumnName(i);
            switch (i) {
                case 1: {
                    CreateDiskStoreTest.assertEquals((String)"NAME", (String)name);
                    continue block11;
                }
                case 2: {
                    CreateDiskStoreTest.assertEquals((String)"MAXLOGSIZE", (String)name);
                    continue block11;
                }
                case 3: {
                    CreateDiskStoreTest.assertEquals((String)"AUTOCOMPACT", (String)name);
                    continue block11;
                }
                case 4: {
                    CreateDiskStoreTest.assertEquals((String)"ALLOWFORCECOMPACTION", (String)name);
                    continue block11;
                }
                case 5: {
                    CreateDiskStoreTest.assertEquals((String)"COMPACTIONTHRESHOLD", (String)name);
                    continue block11;
                }
                case 6: {
                    CreateDiskStoreTest.assertEquals((String)"TIMEINTERVAL", (String)name);
                    continue block11;
                }
                case 7: {
                    CreateDiskStoreTest.assertEquals((String)"WRITEBUFFERSIZE", (String)name);
                    continue block11;
                }
                case 8: {
                    CreateDiskStoreTest.assertEquals((String)"QUEUESIZE", (String)name);
                    continue block11;
                }
                case 9: {
                    CreateDiskStoreTest.assertEquals((String)"DIR_PATH_SIZE", (String)name);
                }
            }
        }
        int numRows = 0;
        while (rs.next()) {
            ++numRows;
            CreateDiskStoreTest.assertEquals((String)"TESTDISKSTORE1", (String)rs.getString("NAME"));
            CreateDiskStoreTest.assertEquals((String)"TESTDISKSTORE1", (String)rs.getString(1));
            CreateDiskStoreTest.assertEquals((long)128L, (long)rs.getLong("MAXLOGSIZE"));
            CreateDiskStoreTest.assertEquals((long)128L, (long)rs.getLong(2));
            CreateDiskStoreTest.assertEquals((String)"false", (String)rs.getString("AUTOCOMPACT"));
            CreateDiskStoreTest.assertEquals((String)"false", (String)rs.getString(3));
            CreateDiskStoreTest.assertEquals((String)"true", (String)rs.getString("ALLOWFORCECOMPACTION"));
            CreateDiskStoreTest.assertEquals((String)"true", (String)rs.getString(4));
            CreateDiskStoreTest.assertEquals((int)80, (int)rs.getInt("COMPACTIONTHRESHOLD"));
            CreateDiskStoreTest.assertEquals((int)80, (int)rs.getInt(5));
            CreateDiskStoreTest.assertEquals((long)23344L, (long)rs.getLong("TIMEINTERVAL"));
            CreateDiskStoreTest.assertEquals((long)23344L, (long)rs.getLong(6));
            CreateDiskStoreTest.assertEquals((int)192923, (int)rs.getInt("WRITEBUFFERSIZE"));
            CreateDiskStoreTest.assertEquals((int)192923, (int)rs.getInt(7));
            CreateDiskStoreTest.assertEquals((int)1734, (int)rs.getInt("QUEUESIZE"));
            CreateDiskStoreTest.assertEquals((int)1734, (int)rs.getInt(8));
            String str = f1.getAbsolutePath() + "(456)," + f2.getAbsolutePath() + "," + f3.getAbsolutePath() + "(55556)";
            CreateDiskStoreTest.assertEquals((String)str, (String)rs.getString("DIR_PATH_SIZE"));
            CreateDiskStoreTest.assertEquals((String)str, (String)rs.getString(9));
        }
        CreateDiskStoreTest.assertEquals((int)1, (int)numRows);
        s.execute("drop DiskStore testDiskStore1");
        rs = s.executeQuery("select * from SYS.SYSDISKSTORES where NAME = 'TESTDISKSTORE1'");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        CreateDiskStoreTest.assertEquals((int)0, (int)numRows);
        rs = s.executeQuery("select * from SYS.SYSDISKSTORES where NAME <> 'TESTDISKSTORE1' ");
        HashSet<String> names = new HashSet<String>();
        names.add("GFXD-DD-DISKSTORE");
        names.add("GFXD-DEFAULT-DISKSTORE");
        numRows = 0;
        while (rs.next()) {
            ++numRows;
            String diskStoreName = rs.getString("NAME");
            CreateDiskStoreTest.assertTrue((boolean)names.remove(diskStoreName));
            CreateDiskStoreTest.assertEquals((String)Boolean.toString(false), (String)rs.getString("ALLOWFORCECOMPACTION"));
            CreateDiskStoreTest.assertEquals((String)Boolean.toString(true), (String)rs.getString("AUTOCOMPACT"));
            CreateDiskStoreTest.assertEquals((int)50, (int)rs.getInt("COMPACTIONTHRESHOLD"));
            if (diskStoreName.equals("GFXD-DD-DISKSTORE")) {
                CreateDiskStoreTest.assertEquals((long)rs.getLong("MAXLOGSIZE"), (long)10L);
            } else {
                CreateDiskStoreTest.assertEquals((long)rs.getLong("MAXLOGSIZE"), (long)DiskStoreFactory.DEFAULT_MAX_OPLOG_SIZE);
            }
            CreateDiskStoreTest.assertEquals((int)rs.getInt("QUEUESIZE"), (int)0);
            CreateDiskStoreTest.assertEquals((long)rs.getLong("TIMEINTERVAL"), (long)1000L);
            CreateDiskStoreTest.assertEquals((int)rs.getInt("WRITEBUFFERSIZE"), (int)32768);
            if (diskStoreName.equals("GFXD-DD-DISKSTORE")) {
                CreateDiskStoreTest.assertEquals((String)rs.getString("DIR_PATH_SIZE"), (String)new File(".", "datadictionary").getAbsolutePath());
                continue;
            }
            CreateDiskStoreTest.assertEquals((String)rs.getString("DIR_PATH_SIZE"), (String)new File(".").getAbsolutePath());
        }
        CreateDiskStoreTest.assertEquals((int)2, (int)numRows);
        CreateDiskStoreTest.assertTrue((boolean)names.isEmpty());
    }

    public void testDataPersistenceOfPRWithRangePartitioning() throws Exception {
        String prClause = " partition by range (cid) ( VALUES BETWEEN 0 AND 10, VALUES BETWEEN 10 AND 20, VALUES BETWEEN 20 AND 30 )  ";
        this.dataPersistenceOfPR(prClause);
    }

    private void dataPersistenceOfPR(String partitionClause) throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        char fileSeparator = System.getProperty("file.separator").charAt(0);
        GemFireCacheImpl cache = Misc.getGemFireCache();
        Statement stmt = conn.createStatement();
        if (cache.findDiskStore("TestPersistenceDiskStore") == null) {
            String path = "." + fileSeparator + "test_dir";
            File file = new File(path);
            if (!file.mkdirs() && !file.isDirectory()) {
                throw new DiskAccessException("Could not create directory for  default disk store : " + file.getAbsolutePath(), (Region)null);
            }
            try {
                Connection conn1 = TestUtil.getConnection();
                Statement stmt1 = conn1.createStatement();
                stmt1.execute("Create DiskStore TestPersistenceDiskStore'" + path + "'");
                conn1.close();
            }
            catch (SQLException e) {
                throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
            }
        }
        stmt.execute("create schema trade");
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid))   " + partitionClause + "  PERSISTENT " + "'" + "TestPersistenceDiskStore" + "'");
        PreparedStatement ps = conn.prepareStatement("insert into trade.customers values (?,?,?)");
        for (int i = 1; i < 31; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "name" + i);
            ps.setInt(3, i);
            ps.executeUpdate();
        }
        conn.close();
        CreateDiskStoreTest.shutDown();
        conn = TestUtil.getConnection();
        stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("select * from trade.customers");
        int expected = 465;
        int actual = 0;
        while (rs.next()) {
            int val = rs.getInt(1);
            actual += val;
        }
        CreateDiskStoreTest.assertEquals((int)expected, (int)actual);
    }

    public void testBug42750() throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        char fileSeparator = System.getProperty("file.separator").charAt(0);
        Misc.getGemFireCache();
        conn.createStatement();
        String path = "." + fileSeparator + "test_dir";
        File file = new File(path);
        if (!file.mkdirs() && !file.isDirectory()) {
            throw new DiskAccessException("Could not create directory for  default disk store : " + file.getAbsolutePath(), (Region)null);
        }
        try {
            Connection conn1 = TestUtil.getConnection();
            Statement stmt1 = conn1.createStatement();
            stmt1.execute("Create DiskStore TestPersistenceDiskStore'" + path + "'");
            conn1.close();
            TestUtil.shutDown();
            conn1 = TestUtil.getConnection();
            stmt1 = conn1.createStatement();
            stmt1.execute("Create DiskStore TestPersistenceDiskStore'" + path + "'");
            CreateDiskStoreTest.fail("Disk store creation should fail as the disk store already exists");
        }
        catch (SQLException e) {
            CreateDiskStoreTest.assertEquals((String)e.getSQLState(), (String)"X0Y68");
        }
    }

    public void testBug45816() throws Exception {
        try {
            Connection conn = TestUtil.getConnection();
            Statement stmt = conn.createStatement();
            stmt.execute("create table mytab1 (col1 int not null)");
            stmt.execute("Create diskstore MYDISKSTORE1");
            stmt.execute("Drop diskstore MYDISKSTORE1");
            stmt.execute("drop table mytab1");
            conn.close();
        }
        catch (SQLException e) {
            throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)e);
        }
    }

    public void testBug45897() throws Exception {
        Statement stmt;
        Connection conn;
        try {
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute("Drop DiskStore \"GFXD-DD-DISKSTORE\"");
            CreateDiskStoreTest.fail("Disk store drop should fail because diskstore is a default one");
        }
        catch (SQLException e) {
            CreateDiskStoreTest.assertEquals((String)e.getSQLState(), (String)"0A000");
        }
        try {
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute("Drop DiskStore \"GFXD-DEFAULT-DISKSTORE\"");
            CreateDiskStoreTest.fail("Disk store drop should fail because diskstore is a default one");
        }
        catch (SQLException e) {
            CreateDiskStoreTest.assertEquals((String)e.getSQLState(), (String)"0A000");
        }
    }

    public void testCreateDiskStoreDDLUT() throws Exception {
        Object[][] CreateDiskStoreUT = new Object[][]{{"CREATE DISKSTORE \"GFXD-DD-DISKSTORE\"", "X0Y68"}, {"CREATE DISKSTORE \"GFXD-DEFAULT-DISKSTORE\"", "X0Y68"}, {"CREATE DISKSTORE DISKSTORE", null}, {"CREATE DISKSTORE MYSTORE1", null}, {"CREATE DISKSTORE MYSTORE1", "X0Y68"}, {"CREATE DISKSTORE NULL", "42X01"}, {"CREATE DISKSTORE ''", "42X01"}, {"CREATE DISKSTORE \"*\"", "0A000"}, {"CREATE DISKSTORE SYS.MYDISKSTORE", "42X01"}, {"CREATE DISKSTORE QUEUESIZE QUEUESIZE 5", null}, {"CREATE DISKSTORE QUEUESIZE2 QUEUESIZE 5 QUEUESIZE 99", "42Y49"}, {"CREATE DISKSTORE BADSIZE ('MYDIR' -5000)", "42X44"}, {"CREATE DISKSTORE BADSIZE3 ('MYDIR' +infinity)", "42X01"}, {"CREATE DISKSTORE BADSIZE4 ('MYDIR' x'41')", "22018"}, {"CREATE DISKSTORE BADSIZE5 ('MYDIR' 2147483648)", "22018"}, {"CREATE DISKSTORE BADSIZE6 ('MYDIR' 2147483647)", null}, {"CREATE DISKSTORE ML1 MAXLOGSIZE -5", "42X44"}, {"CREATE DISKSTORE ML3 MAXLOGSIZE 2147483647", null}, {"CREATE DISKSTORE ML4 MAXLOGSIZE 'hello'", "42X01"}, {"CREATE DISKSTORE AC1 AUTOCOMPACT true", null}, {"CREATE DISKSTORE AC2 AUTOCOMPACT false", null}, {"CREATE DISKSTORE AC3 AUTOCOMPACT 5", "42X01"}, {"CREATE DISKSTORE AC4 AUTOCOMPACT maybe", "42X01"}, {"CREATE DISKSTORE AC5 AUTOCOMPACT 'true'", "42X01"}, {"CREATE DISKSTORE AC6 AUTOCOMPACT \"false\"", "42X01"}, {"CREATE DISKSTORE AFC1 ALLOWFORCECOMPACTION true", null}, {"CREATE DISKSTORE AFC2 ALLOWFORCECOMPACTION false", null}, {"CREATE DISKSTORE AFC3 ALLOWFORCECOMPACTION 11", "42X01"}, {"CREATE DISKSTORE AFC4 ALLOWFORCECOMPACTION maybe", "42X01"}, {"CREATE DISKSTORE AFC5 ALLOWFORCECOMPACTION 'true'", "42X01"}, {"CREATE DISKSTORE AFC6 ALLOWFORCECOMPACTION \"false\"", "42X01"}, {"CREATE DISKSTORE AFC7 ALLOWFORCECOMPACTION true AUTOCOMPACT false", null}, {"CREATE DISKSTORE CT1 COMPACTIONTHRESHOLD -5", "42X44"}, {"CREATE DISKSTORE CT2 COMPACTIONTHRESHOLD 0", null}, {"CREATE DISKSTORE CT3 COMPACTIONTHRESHOLD 100", null}, {"CREATE DISKSTORE CT4 COMPACTIONTHRESHOLD 55.2", "42X20"}, {"CREATE DISKSTORE CT5 COMPACTIONTHRESHOLD 175", "0A000"}, {"CREATE DISKSTORE CT6 COMPACTIONTHRESHOLD 'big'", "42X01"}, {"CREATE DISKSTORE CT7 COMPACTIONTHRESHOLD zero", "42X01"}, {"CREATE DISKSTORE CT8 COMPACTIONTHRESHOLD 50 AUTOCOMPACT false", null}, {"CREATE DISKSTORE CT9 COMPACTIONTHRESHOLD 50 AUTOCOMPACT false ALLOWFORCECOMPACTION true", null}, {"CREATE DISKSTORE TI1 TIMEINTERVAL -5", "42X44"}, {"CREATE DISKSTORE TI2 TIMEINTERVAL 0", null}, {"CREATE DISKSTORE TI3 TIMEINTERVAL 2147473648", null}, {"CREATE DISKSTORE TI4 TIMEINTERVAL '4'", "42X01"}, {"CREATE DISKSTORE TI5 TIMEINTERVAL five", "42X01"}, {"CREATE DISKSTORE WB1 WRITEBUFFERSIZE -5", "42X44"}, {"CREATE DISKSTORE WB2 WRITEBUFFERSIZE 0", null}, {"CREATE DISKSTORE WB3 WRITEBUFFERSIZE 2147473648", null}, {"CREATE DISKSTORE WB4 WRITEBUFFERSIZE 'awholelot'", "42X01"}, {"CREATE DISKSTORE WB5 WRITEBUFFERSIZE many", "42X01"}, {"CREATE DISKSTORE QS1 QUEUESIZE -5", "42X44"}, {"CREATE DISKSTORE QS2 QUEUESIZE 0", null}, {"CREATE DISKSTORE QS3 QUEUESIZE 2147473648", null}, {"CREATE DISKSTORE QS4 QUEUESIZE '10'", "42X01"}, {"CREATE DISKSTORE QS5 QUEUESIZE fifteen", "42X01"}, {"CREATE DISKSTORE DIRTEST1 ('D1', 'D1')", "X0Z19"}, {"CREATE DISKSTORE DIRTEST2 ('../D1', '../D1')", "X0Z19"}, {"CREATE DISKSTORE DIRTEST5 ('')", "0A000"}, {"CREATE DISKSTORE DIRTEST8 'DIR1' 700 TIMEINTERVAL 1000 'DIR2' 1000", null}, {"CREATE DISKSTORE DIRTEST9 'DIR1' 0", "42X01"}, {"CREATE DISKSTORE EVERYTHING1 'DIR1' 700 TIMEINTERVAL 1000 AUTOCOMPACT false QUEUESIZE 75 WRITEBUFFERSIZE 32767 COMPACTIONTHRESHOLD 25 MAXLOGSIZE 699 ALLOWFORCECOMPACTION false", null}, {"CREATE DISKSTORE EVERYTHING2 TIMEINTERVAL 999 WRITEBUFFERSIZE 19776 QUEUESIZE 0 AUTOCOMPACT true COMPACTIONTHRESHOLD 55 ALLOWFORCECOMPACTION true MAXLOGSIZE 125000 ('EVERYTHING1' 500, 'EVERYTHING2' 1500, 'EVERYTHING3')", "X0Z33"}, {"CREATE DISKSTORE EVERYTHING2 TIMEINTERVAL 999 WRITEBUFFERSIZE 19776 QUEUESIZE 0 AUTOCOMPACT true COMPACTIONTHRESHOLD 55 ALLOWFORCECOMPACTION true MAXLOGSIZE 500 ('EVERYTHING1' 500, 'EVERYTHING2' 1500, 'EVERYTHING3')", null}};
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        JDBC.SQLUnitTestHelper(stmt, CreateDiskStoreUT);
    }
}

