/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ConnectionURLTest
extends JdbcTestBase {
    private static final String protocol = "jdbc:gemfirexd:";
    private static final String dbName = "gemfireCxn";
    private static final String dbName2 = "GemFireXD";
    private static final String dbName3 = "gemfirexd";
    private static final String dbName4 = "GEMFIREXD";

    public ConnectionURLTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ConnectionURLTest.class));
    }

    public void testConnectionURLWithoutName() throws SQLException {
        Connection conn = null;
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        conn = DriverManager.getConnection("jdbc:gemfirexd:;host-data=true;create=true", props);
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 char(200))");
        s.execute("insert into t1 (c1, c2) values (10, 'YYYY')");
        s.execute("insert into t1 (c1, c2) values (20, 'YYYY')");
        s.executeQuery("select * from t1 where t1.c1=10");
        conn.close();
    }

    public void testConnectionURLWithName() throws SQLException {
        Properties props = new Properties();
        props.setProperty("mcast-port", "0");
        this.checkExceptionForURL("jdbc:gemfirexd:gemfireCxn;host-data=true", props);
        Connection conn = DriverManager.getConnection("jdbc:gemfirexd:GemFireXD;host-data=true;create=true;mcast-port=0");
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select id from sys.members");
        ConnectionURLTest.assertTrue((boolean)rs.next());
        ConnectionURLTest.assertFalse((boolean)rs.next());
        conn.close();
        conn = DriverManager.getConnection("jdbc:gemfirexd:gemfirexd;host-data=true;create=true;mcast-port=0");
        s = conn.createStatement();
        rs = s.executeQuery("select id from sys.members");
        ConnectionURLTest.assertTrue((boolean)rs.next());
        ConnectionURLTest.assertFalse((boolean)rs.next());
        conn.close();
        conn = DriverManager.getConnection("jdbc:gemfirexd:GEMFIREXD;host-data=true;create=true;mcast-port=0");
        s = conn.createStatement();
        rs = s.executeQuery("select id from sys.members");
        ConnectionURLTest.assertTrue((boolean)rs.next());
        ConnectionURLTest.assertFalse((boolean)rs.next());
        conn.close();
    }

    public void testMultiConnectionURLWithoutName() throws SQLException {
        Connection conn = null;
        Properties prop = new Properties();
        prop.setProperty("host-data", "true");
        prop.setProperty("mcast-port", "0");
        conn = DriverManager.getConnection(protocol, prop);
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 char(200))");
        s.execute("insert into t1 (c1, c2) values (10, 'YYYY')");
        s.execute("insert into t1 (c1, c2) values (20, 'YYYY')");
        s.executeQuery("select * from t1 where t1.c1=10");
        conn.close();
        conn = DriverManager.getConnection(protocol, prop);
        s = conn.createStatement();
        s.executeQuery("select * from t1 where t1.c1=10");
    }

    public void testMultiConnectionURLWithName() throws SQLException {
        Connection conn = null;
        Properties props = new Properties();
        props.setProperty("host-data", "true");
        props.setProperty("mcast-port", "0");
        conn = DriverManager.getConnection(protocol, props);
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int primary key, c2 char(200))");
        s.execute("insert into t1 (c1, c2) values (10, 'YYYY')");
        s.execute("insert into t1 (c1, c2) values (20, 'YYYY')");
        s.executeQuery("select * from t1 where t1.c1=10");
        conn.close();
        this.checkExceptionForURL("jdbc:gemfirexd:gemfireCxn", props);
        conn = DriverManager.getConnection("jdbc:gemfirexd:GemFireXD", props);
        s = conn.createStatement();
        ResultSet rs = s.executeQuery("select id from sys.members");
        ConnectionURLTest.assertTrue((boolean)rs.next());
        ConnectionURLTest.assertFalse((boolean)rs.next());
        conn.close();
        conn = DriverManager.getConnection("jdbc:gemfirexd:gemfirexd", props);
        s = conn.createStatement();
        rs = s.executeQuery("select id from sys.members");
        ConnectionURLTest.assertTrue((boolean)rs.next());
        ConnectionURLTest.assertFalse((boolean)rs.next());
        conn.close();
        conn = DriverManager.getConnection("jdbc:gemfirexd:GEMFIREXD", props);
        s = conn.createStatement();
        rs = s.executeQuery("select id from sys.members");
        ConnectionURLTest.assertTrue((boolean)rs.next());
        ConnectionURLTest.assertFalse((boolean)rs.next());
        conn.close();
        this.checkExceptionForURL("jdbc:gemfirexd:net:", props);
        this.checkExceptionForURL("jdbc:gemfirexd:net:gemfireCxn", props);
        this.checkExceptionForURL("jdbc:gemfirexd:net:GemFireXD", props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkExceptionForURL(String url, Properties props) throws SQLException {
        Monitor.getStream().println("<ExpectedException action=add>java.sql.SQLException</ExpectedException>");
        Monitor.getStream().flush();
        try {
            DriverManager.getConnection(url, props);
            ConnectionURLTest.fail("exception is expected!");
        }
        catch (SQLException ex) {
            if (!"XJ040".equals(ex.getSQLState()) && !"XJ004".equals(ex.getSQLState())) {
                throw ex;
            }
        }
        finally {
            Monitor.getStream().println("<ExpectedException action=remove>java.sql.SQLException</ExpectedException>");
            Monitor.getStream().flush();
        }
    }
}

