/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.internal.tools.ij;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ConcurrentConnTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(ConcurrentConnTest.class));
    }

    public ConcurrentConnTest(String name) {
        super(name);
    }

    public void testConcConnectionsOne() throws Exception {
        Connection conn1 = ConcurrentConnTest.getConnection();
        Connection conn4 = ConcurrentConnTest.getConnection();
        Connection conn5 = ConcurrentConnTest.getConnection();
        Connection conn6 = ConcurrentConnTest.getConnection();
        Connection conn7 = ConcurrentConnTest.getConnection();
        if (conn1 == null || conn4 == null || conn5 == null || conn6 == null || conn7 == null) {
            ConcurrentConnTest.fail("Concurrent connections test one - Failed to open a connection");
        }
        System.out.println("Conc Connections Test One opened 5 connections");
        Connection conn8 = ConcurrentConnTest.getConnection();
        Connection conn9 = ConcurrentConnTest.getConnection();
        Connection conn10 = ConcurrentConnTest.getConnection();
        ConcurrentConnTest.metadataCalls(conn1);
        Connection conn2 = ConcurrentConnTest.getConnection();
        ConcurrentConnTest.metadataCalls(conn2);
        Connection conn3 = ConcurrentConnTest.getConnection();
        ConcurrentConnTest.metadataCalls(conn3);
        if (conn2 == null || conn3 == null || conn8 == null || conn9 == null || conn10 == null) {
            ConcurrentConnTest.fail("Concurrent connections test one - Failed to open a connection");
        }
        System.out.println("Conc Connections Test One opened 10 connections");
        conn1.commit();
        conn2.commit();
        conn3.commit();
        conn4.commit();
        conn5.commit();
        conn6.commit();
        conn7.commit();
        conn8.commit();
        conn9.commit();
        conn10.commit();
        System.out.println("Conc Connections Test One committed  10 connections");
        System.out.println("Conc Connections Test One finishes.");
    }

    public void testConcConnectionsTwo() throws Exception {
        System.out.println("Conc Connections Test Two starting");
        Connection conn1 = ConcurrentConnTest.getConnection();
        Connection conn4 = ConcurrentConnTest.getConnection();
        Connection conn5 = ConcurrentConnTest.getConnection();
        Connection conn6 = ConcurrentConnTest.getConnection();
        Connection conn7 = ConcurrentConnTest.getConnection();
        if (conn1 == null || conn4 == null || conn5 == null || conn6 == null || conn7 == null) {
            ConcurrentConnTest.fail("Concurrent connections test two - Failed to open a connection");
        }
        System.out.println("Conc Connections Test Two opened 5 connections");
        Connection conn8 = ConcurrentConnTest.getConnection();
        Connection conn9 = ConcurrentConnTest.getConnection();
        Connection conn10 = ConcurrentConnTest.getConnection();
        ConcurrentConnTest.metadataCalls(conn1);
        Connection conn2 = ConcurrentConnTest.getConnection();
        ConcurrentConnTest.metadataCalls(conn2);
        Connection conn3 = ConcurrentConnTest.getConnection();
        ConcurrentConnTest.metadataCalls(conn3);
        if (conn2 == null || conn3 == null || conn8 == null || conn9 == null || conn10 == null) {
            ConcurrentConnTest.fail("Concurrent connections test two - Failed to open a connection");
        }
        System.out.println("Conc Connections Test Two opened 10 connections");
        conn1.commit();
        conn2.commit();
        conn3.commit();
        conn4.commit();
        conn5.commit();
        conn6.commit();
        conn7.commit();
        conn8.commit();
        conn9.commit();
        conn10.commit();
        System.out.println("Conc Connections Test Two committed  10 connections");
        System.out.println("Conc Connections Test Two finishes.");
    }

    public static Connection getConnection(String[] args, boolean autoCommit) throws Exception {
        ij.getPropertyArg((String[])args);
        Connection conn = ij.startJBMS();
        conn.setAutoCommit(autoCommit);
        return conn;
    }

    public static void metadataCalls(Connection conn) throws Exception {
        System.out.println("A new connection is doing metadata calls, but never commit...");
        DatabaseMetaData dmd = conn.getMetaData();
        ConcurrentConnTest.getTypeInfo(dmd, System.out);
        ConcurrentConnTest.getTables(dmd, System.out);
        ConcurrentConnTest.getColumnInfo(dmd, "%", System.out);
        ConcurrentConnTest.getPrimaryKeys(dmd, "%", System.out);
        ConcurrentConnTest.getExportedKeys(dmd, "%", System.out);
    }

    public static void getTypeInfo(DatabaseMetaData dmd, PrintStream out) throws SQLException {
        ResultSet rs = dmd.getTypeInfo();
        out.println("Submitted getTypeInfo request");
        while (rs.next()) {
            String typeName = rs.getString(1);
            short dataType = rs.getShort(2);
            int precision = rs.getInt(3);
            String literalPrefix = rs.getString(4);
            String literalSuffix = rs.getString(5);
            String createParams = rs.getString(6);
            short nullable = rs.getShort(7);
            boolean caseSensitive = rs.getBoolean(8);
            short searchable = rs.getShort(9);
            boolean unsignedAttribute = rs.getBoolean(10);
            boolean fixedPrecScale = rs.getBoolean(11);
            boolean autoIncrement = rs.getBoolean(12);
            String localTypeName = rs.getString(13);
            short minimumScale = rs.getShort(14);
            short s = rs.getShort(15);
        }
        rs.close();
    }

    public static void getTables(DatabaseMetaData dmd, PrintStream out) throws SQLException {
        String[] types = new String[]{"TABLE"};
        ResultSet rs = dmd.getTables(null, null, null, types);
        while (rs.next()) {
            String tableCat = rs.getString(1);
            String tableSchem = rs.getString(2);
            String tableName = rs.getString(3);
            String tableType = rs.getString(4);
            String string = rs.getString(5);
        }
        rs.close();
    }

    public static void getColumnInfo(DatabaseMetaData dmd, String tablePattern, PrintStream out) throws SQLException {
        out.println("Getting column info for " + tablePattern);
        ResultSet rs = dmd.getColumns(null, null, tablePattern, "%");
        while (rs.next()) {
            String tableCat = rs.getString(1);
            String tableSchem = rs.getString(2);
            String tableName = rs.getString(3);
            String columnName = rs.getString(4);
            short dataType = rs.getShort(5);
            String typeName = rs.getString(6);
            int columnSize = rs.getInt(7);
            int decimalDigits = rs.getInt(9);
            int numPrecRadix = rs.getInt(10);
            int nullable = rs.getInt(11);
            String remarks = rs.getString(12);
            String columnDef = rs.getString(13);
            int n = rs.getInt(16);
        }
        rs.close();
    }

    public static void getPrimaryKeys(DatabaseMetaData dmd, String tablePattern, PrintStream out) throws SQLException {
        ResultSet rs = dmd.getPrimaryKeys(null, null, tablePattern);
        while (rs.next()) {
            String tableCat = rs.getString(1);
            String tableSchem = rs.getString(2);
            String tableName = rs.getString(3);
            String columnName = rs.getString(4);
            short keySeq = rs.getShort(5);
            String string = rs.getString(6);
        }
        rs.close();
    }

    public static void getExportedKeys(DatabaseMetaData dmd, String tablePattern, PrintStream out) throws SQLException {
        ResultSet rs = dmd.getExportedKeys(null, null, tablePattern);
        while (rs.next()) {
            String pkTableCat = rs.getString(1);
            String pkTableSchem = rs.getString(2);
            String pkTableName = rs.getString(3);
            String pkColumnName = rs.getString(4);
            String fkTableCat = rs.getString(5);
            String fkTableSchem = rs.getString(6);
            String fkTableName = rs.getString(7);
            String fkColumnName = rs.getString(8);
            short keySeq = rs.getShort(9);
            short updateRule = rs.getShort(10);
            short deleteRule = rs.getShort(11);
            String fkName = rs.getString(12);
            String pkName = rs.getString(13);
            short s = rs.getShort(14);
        }
        rs.close();
    }
}

