/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.asyncqueue.internal.AsyncEventQueueImpl;
import com.gemstone.gemfire.cache.persistence.PartitionOfflineException;
import com.gemstone.gemfire.cache.util.CacheWriterAdapter;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.GemFireTerminateError;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.LocalDataSet;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegionHelper;
import com.gemstone.gemfire.internal.shared.NativeCalls;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.GfxdIndexManager;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2Index;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.distributed.MultipleInsertsLeveragingPutAllDUnit;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SelectQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireSelectActivation;
import com.pivotal.gemfirexd.internal.engine.store.CompactCompositeRegionKey;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.UserType;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.jdbc.GfxdJarInstallationTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import com.pivotal.gemfirexd.jdbc.ProcedureTest;
import com.pivotal.gemfirexd.jdbc.SimpleAppTest;
import com.pivotal.gemfirexd.procedure.ProcedureExecutionContext;
import com.pivotal.gemfirexd.tools.internal.JarTools;
import com.pivotal.gemfirexd.tools.utils.ExecutionPlanUtils;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.log4j.Logger;
import udtexamples.UDTPrice;

public class BugsTest
extends JdbcTestBase {
    private volatile boolean exceptionOccured = false;
    protected boolean callbackInvoked;
    private static final String TRIGGER_DEPENDS_ON_TYPE = "X0Y24";
    private static String proc = "CREATE PROCEDURE RETRIEVE_DYNAMIC_RESULTS(number INT) LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + BugsTest.class.getName() + ".retrieveDynamicResults' " + "DYNAMIC RESULT SETS 2";
    private final String myjar = BugsTest.getResourcesDir() + "/lib/myjar.jar";
    private final String booksJar = BugsTest.getResourcesDir() + "/lib/Books.jar";

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(SimpleAppTest.class));
    }

    public BugsTest(String name) {
        super(name);
    }

    public void testGEMXD_3_TMG16663_IndexRecoveryNPE() throws Exception {
        int i;
        int i2;
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("Create table ODS.POSTAL_ADDRESS(cntc_id bigint NOT NULL,pstl_addr_id bigint GENERATED BY DEFAULT AS IDENTITY  NOT NULL,ver bigint NOT NULL,client_id bigint NOT NULL,str_ln1 varchar(100),str_ln2 varchar(100),str_ln3 varchar(100),cnty varchar(50),pstl_cd varchar(20),cntry varchar(100),vldtd SMALLINT,vldtn_dt DATE,vld_frm_dt TIMESTAMP NOT NULL,vld_to_dt TIMESTAMP,src_sys_ref_id varchar(10) NOT NULL,src_sys_rec_id varchar(150),PRIMARY KEY (client_id,cntc_id,pstl_addr_id)) PARTITION BY COLUMN (cntc_id) REDUNDANCY 1 EVICTION BY LRUHEAPPERCENT EVICTACTION OVERFLOW PERSISTENT ASYNCHRONOUS");
        for (i2 = 200; i2 < 250; ++i2) {
            st.execute("insert into ODS.POSTAL_ADDRESS(cntc_id, ver, client_id, str_ln2, cnty, vld_frm_dt, src_sys_ref_id) values (" + i2 * 74 + ", " + (i2 + 14) + ", " + (i2 + 20) + ", 'STR_LN2', 'CNTY" + i2 * 42 + "', CURRENT_TIMESTAMP, 'REFID" + i2 + "')");
        }
        st.execute("ALTER TABLE ODS.POSTAL_ADDRESS ADD COLUMN cty varchar(75)");
        st.execute("CREATE INDEX IX_POSTAL_ADDRESS_02 ON ODS.POSTAL_ADDRESS (CTY, CLIENT_ID) -- GEMFIREXD-PROPERTIES caseSensitive=false");
        for (i2 = 150; i2 < 200; ++i2) {
            st.execute("insert into ODS.POSTAL_ADDRESS(cntc_id, ver, client_id, str_ln2, cty, cnty, vld_frm_dt, src_sys_ref_id) values (" + i2 * 74 + ", " + (i2 + 14) + ", " + (i2 + 20) + ", 'STR_LN2', 'CTY" + (i2 + 20) + "', 'CNTY" + i2 * 42 + "', CURRENT_TIMESTAMP, 'REFID" + i2 + "')");
        }
        st.execute("ALTER TABLE ODS.POSTAL_ADDRESS ADD COLUMN st varchar(50) default ''");
        st.execute("CREATE INDEX IX_POSTAL_ADDRESS_03 ON ODS.POSTAL_ADDRESS (ST, CLIENT_ID) -- GEMFIREXD-PROPERTIES caseSensitive=false");
        for (i2 = 100; i2 < 150; ++i2) {
            st.execute("insert into ODS.POSTAL_ADDRESS(cntc_id, ver, client_id, str_ln2, cnty, st, vld_frm_dt, src_sys_ref_id) values (" + i2 * 74 + ", " + (i2 + 14) + ", " + (i2 + 20) + ", 'STR_LN2', 'CNTY" + i2 * 42 + "', 'ST" + (i2 + 20) + "', " + "CURRENT_TIMESTAMP, 'REFID" + i2 + "')");
        }
        for (i2 = 0; i2 < 100; ++i2) {
            st.execute("insert into ODS.POSTAL_ADDRESS(cntc_id, ver, client_id, str_ln2, cty, cnty, st, vld_frm_dt, src_sys_ref_id) values (" + i2 * 74 + ", " + (i2 + 14) + ", " + (i2 + 20) + ", 'STR_LN2', 'CTY" + (i2 + 20) + "', 'CNTY" + i2 * 42 + "', 'ST" + (i2 + 20) + "', " + "CURRENT_TIMESTAMP, 'REFID" + i2 + "')");
        }
        BugsTest.shutDown();
        BugsTest.setupConnection();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        for (i = 0; i < 250; ++i) {
            java.sql.ResultSet rs = st.executeQuery("select st, cty, client_id from ODS.POSTAL_ADDRESS where CTY='CTY" + (i + 20) + "' AND CLIENT_ID=" + (i + 20));
            if (i >= 200 && i < 250 || i >= 100 && i < 150) {
                BugsTest.assertFalse((boolean)rs.next());
            } else {
                BugsTest.assertTrue((boolean)rs.next());
                if (i >= 0 && i < 150) {
                    BugsTest.assertEquals((String)("ST" + (i + 20)), (String)rs.getString(1));
                } else {
                    BugsTest.assertEquals((String)"", (String)rs.getString(1));
                }
                BugsTest.assertEquals((String)("CTY" + (i + 20)), (String)rs.getString(2));
            }
            rs.close();
        }
        for (i = 0; i < 250; ++i) {
            java.sql.ResultSet rs = st.executeQuery("select st, cty, client_id from ODS.POSTAL_ADDRESS where ST='ST" + (i + 20) + "' AND CLIENT_ID=" + (i + 20));
            if (i >= 0 && i < 150) {
                BugsTest.assertTrue((boolean)rs.next());
                BugsTest.assertEquals((String)("ST" + (i + 20)), (String)rs.getString(1));
                if (i < 100) {
                    BugsTest.assertEquals((String)("CTY" + (i + 20)), (String)rs.getString(2));
                } else {
                    BugsTest.assertNull((Object)rs.getString(2));
                }
            } else {
                BugsTest.assertFalse((boolean)rs.next());
            }
            rs.close();
        }
    }

    public void testBug51188() throws Exception {
        DMLQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public void afterResultSetOpen(GenericPreparedStatement stmt, LanguageConnectionContext lcc, ResultSet resultSet) {
                if (resultSet != null) {
                    TestCase.assertTrue((resultSet.getClass().getSimpleName().compareTo("HashJoinResultSet") == 0 || resultSet instanceof GemFireDistributedResultSet ? 1 : 0) != 0);
                }
            }
        };
        st.execute("CREATE TABLE t1 (c1 BIGINT NOT NULL) PARTITION BY COLUMN (c1)");
        st.execute("CREATE TABLE t2 (c1 BIGINT NOT NULL) PARTITION BY COLUMN (c1) COLOCATE WITH (t1)");
        PreparedStatement ps1 = conn.prepareStatement("insert into t1 values (?)");
        int i = 0;
        for (i = 0; i < 100000; ++i) {
            ps1.setLong(1, i);
            ps1.addBatch();
            if (i % 1000 != 0) continue;
            ps1.executeBatch();
        }
        if (i % 1000 == 0) {
            ps1.executeBatch();
        }
        PreparedStatement ps2 = conn.prepareStatement("insert into t2 values (?)");
        for (i = 0; i < 100000; ++i) {
            ps2.setLong(1, i);
            ps2.addBatch();
            if (i % 1000 != 0) continue;
            ps2.executeBatch();
        }
        if (i % 1000 == 0) {
            ps2.executeBatch();
        }
        st.execute("select count(*) from t1");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertTrue((rs.getLong(1) == 100000L ? 1 : 0) != 0);
        st.execute("select count(*) from t2");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertTrue((rs.getLong(1) == 100000L ? 1 : 0) != 0);
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        st.execute("SELECT t1.c1, t2.c1 FROM t1 JOIN t2 ON t1.c1 = t2.c1");
        GemFireXDQueryObserverHolder.clearInstance();
        rs = st.getResultSet();
        long count = 0L;
        while (rs.next()) {
            ++count;
        }
        BugsTest.assertTrue((count == 100000L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug51284() throws Exception {
        System.setProperty(GfxdConstants.DML_MAX_CHUNK_SIZE_PROP, "7");
        try {
            Statement st2;
            java.sql.ResultSet rs;
            Statement st;
            Connection conn;
            block8: {
                block7: {
                    conn = BugsTest.getConnection();
                    conn.setAutoCommit(true);
                    conn.setTransactionIsolation(2);
                    st = conn.createStatement();
                    st.execute("create table isuspectabug(id int primary key, name varchar(20)) partition by primary key");
                    try {
                        st.execute("insert into isuspectabug values(1, 'one'), (3, 'three'), (3, 'three')");
                        BugsTest.fail("expected a primary key constraint violation");
                    }
                    catch (SQLException sqle) {
                        if ("23505".equals(sqle.getSQLState())) break block7;
                        throw sqle;
                    }
                }
                rs = st.executeQuery("select * from isuspectabug");
                BugsTest.assertFalse((boolean)rs.next());
                rs = st.executeQuery("select count(*) from isuspectabug");
                BugsTest.assertTrue((boolean)rs.next());
                BugsTest.assertEquals((int)0, (int)rs.getInt(1));
                BugsTest.assertFalse((boolean)rs.next());
                Connection conn2 = BugsTest.getConnection();
                st2 = conn2.createStatement();
                rs = st2.executeQuery("select * from isuspectabug");
                BugsTest.assertFalse((boolean)rs.next());
                rs = st2.executeQuery("select count(*) from isuspectabug");
                BugsTest.assertTrue((boolean)rs.next());
                BugsTest.assertEquals((int)0, (int)rs.getInt(1));
                BugsTest.assertFalse((boolean)rs.next());
                conn.setAutoCommit(false);
                st.execute("create table isuspectabug2(id int primary key, name varchar(20)) partition by primary key");
                try {
                    st.execute("insert into isuspectabug2 values(1, 'one'), (3, 'three'), (3, 'three')");
                    BugsTest.fail("expected a primary key constraint violation");
                }
                catch (SQLException sqle) {
                    if ("23505".equals(sqle.getSQLState())) break block8;
                    throw sqle;
                }
            }
            conn.rollback();
            rs = st.executeQuery("select * from isuspectabug2");
            BugsTest.assertFalse((boolean)rs.next());
            rs = st.executeQuery("select count(*) from isuspectabug2");
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((int)0, (int)rs.getInt(1));
            BugsTest.assertFalse((boolean)rs.next());
            rs = st2.executeQuery("select * from isuspectabug2");
            BugsTest.assertFalse((boolean)rs.next());
            rs = st2.executeQuery("select count(*) from isuspectabug2");
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((int)0, (int)rs.getInt(1));
            BugsTest.assertFalse((boolean)rs.next());
        }
        finally {
            System.clearProperty(GfxdConstants.DML_MAX_CHUNK_SIZE_PROP);
        }
    }

    public void testBug51463() throws Exception {
        block2: {
            Connection conn = BugsTest.getConnection();
            Statement st = conn.createStatement();
            try {
                st.execute("create table t1 (col1 int primary key, col2 varchar(10), col3 varchar(10), constraint t1_uq unique (col2, col3)) partition by primary key");
                st.execute("put into t1 values (202, 'a0', 'lse')");
                st.execute("put into t1 values (303, 'a0', 'lse')");
                BugsTest.fail("Expect unique constraint violation");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().compareTo("23505") == 0) break block2;
                throw sqle;
            }
        }
    }

    public void testBug51230() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE t1 (c1 VARCHAR(2048))");
        st.execute("CREATE TABLE t2 AS SELECT * FROM t1 WITH NO DATA");
        st.execute("ALTER TABLE t2 ADD COLUMN c2 VARCHAR(1)");
        conn.close();
    }

    public void testBug51064() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Properties props = new Properties();
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TABLE APP.PERSON (CLNT_OBJ_ID VARCHAR(100) NOT NULL, PERS_OBJ_ID VARCHAR(100) NOT NULL) PARTITION BY COLUMN (CLNT_OBJ_ID, PERS_OBJ_ID) BUCKETS 163");
        st.execute("CREATE TABLE APP.EARN_ROLLUP_PERSON (CLNT_OBJ_ID VARCHAR(100) NOT NULL,PERS_OBJ_ID VARCHAR(100) NOT NULL,PAYRL_EARN_KY INT NOT NULL,EARN_CD VARCHAR(200) NOT NULL,EARN_DSC VARCHAR(200) NOT NULL,PAY_GRP_CD VARCHAR(200) NOT NULL,WORK_LOC_SHRT_DSC VARCHAR(200) NOT NULL,EARNING DECIMAL(20,5) NOT NULL,MONTH VARCHAR(100) NOT NULL,QTR VARCHAR(100) NOT NULL,YEAR_NR INT NOT NULL) PARTITION BY COLUMN (CLNT_OBJ_ID,PERS_OBJ_ID) COLOCATE WITH (APP.PERSON) BUCKETS 163");
        st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('APP', 'PERSON', '" + BugsTest.getResourcesDir() + "/lib/useCase9/person_data.tbl', ',', " + "null, null, 0, 0 , 6 , 0 , null , null )");
        st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('APP', 'EARN_ROLLUP_PERSON', '" + BugsTest.getResourcesDir() + "/lib/useCase9/earn_rollup_data.tbl', ',', " + "null, null, 0, 0 , 6 , 0 , null , null )");
        st.execute("SELECT  t1.YEAR_nr, sum(t1.EARNING)/cast((count(DISTINCT t2.pers_obj_id)) as decimal) as avg_earnings ,earn_cd ,earn_dsc FROM app.EARN_ROLLUP_PERSON t1 ,app.person t2 WHERE t1.clnt_obj_id = t2.clnt_obj_id AND t1.pers_obj_id = t2.pers_obj_id AND t1.CLNT_OBJ_ID = 'G3H02MPK5NQRXJ9N_0041' AND work_loc_shrt_dsc in ('AZ') AND pay_grp_cd = 'LXG' AND YEAR_nr = 2012 GROUP BY earn_cd, earn_dsc,YEAR_nr ORDER BY year_nr,earn_cd, earn_dsc");
        rs = st.getResultSet();
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        BugsTest.assertEquals((int)13, (int)count);
    }

    public void testBug50428() throws Exception {
        this.reduceLogLevelForTest("config");
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("CREATE TABLE ORDERS  ( O_ORDERKEY INTEGER NOT NULL, O_CUSTKEY INTEGER NOT NULL, O_ORDERSTATUS CHAR(1) NOT NULL, O_TOTALPRICE DECIMAL(15,2) NOT NULL, O_ORDERDATE DATE NOT NULL, O_ORDERPRIORITY CHAR(15) NOT NULL, O_CLERK CHAR(15) NOT NULL, O_SHIPPRIORITY INTEGER NOT NULL, O_COMMENT VARCHAR(79) NOT NULL) PARTITION BY COLUMN (O_ORDERKEY)");
        st.execute("ALTER TABLE ORDERS ADD PRIMARY KEY (O_ORDERKEY)");
        st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX (null, 'ORDERS', '" + BugsTest.getResourcesDir() + "/lib/tpch/orders.tbl" + "', '|', null, null, 0, 0, 2, 0, null, null)");
    }

    public void testOplogPreBlow() throws Exception {
        this.reduceLogLevelForTest("config");
        if (Platform.isLinux()) {
            String remDirName;
            boolean hasExportDir;
            this.deleteDirs = new String[2];
            Connection conn = TestUtil.getConnection();
            NativeCalls.TEST_CHK_FALLOC_DIRS = new HashSet();
            Statement st = conn.createStatement();
            long currTime = System.nanoTime();
            String locDirName = "/tmp/" + System.getenv().get("USER") + "-" + currTime;
            File locDir = new File(locDirName);
            BugsTest.assertTrue((boolean)locDir.mkdir());
            this.deleteDirs[0] = locDir.getAbsolutePath();
            String exportDir = "/srv/users/" + System.getenv().get("USER");
            if (new File(exportDir).exists()) {
                hasExportDir = true;
                remDirName = exportDir + "/preBlow-" + currTime;
            } else {
                hasExportDir = false;
                remDirName = "/home/" + System.getenv().get("USER") + "/preBlow-" + currTime;
            }
            File remDir = new File(remDirName);
            BugsTest.assertTrue((boolean)remDir.mkdir());
            this.deleteDirs[1] = remDir.getAbsolutePath();
            st.execute("create diskstore teststore_loc ('" + locDirName + "') MAXLOGSIZE 2");
            String str1k = new String();
            for (int i = 0; i < 1024; ++i) {
                str1k = str1k + "a";
            }
            st.execute("create table emp(id int not null primary key, name varchar(20) not null, addr varchar(2000) not null) persistent 'teststore_loc'");
            PreparedStatement ps = conn.prepareStatement("insert into emp values(?, ?, ?)");
            for (int i = 0; i < 5000; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "name" + i);
                ps.setString(3, str1k);
                int j = ps.executeUpdate();
                BugsTest.assertEquals((int)1, (int)j);
            }
            st.execute("select count(*) from emp");
            java.sql.ResultSet rs = st.getResultSet();
            rs.next();
            BugsTest.assertEquals((int)5000, (int)rs.getInt(1));
            HashSet preBlowDoneDirs = new HashSet();
            preBlowDoneDirs.addAll(NativeCalls.TEST_CHK_FALLOC_DIRS);
            NativeCalls.TEST_CHK_FALLOC_DIRS.clear();
            NativeCalls.TEST_NO_FALLOC_DIRS = new HashSet();
            st.execute("create diskstore teststore_rem ('" + remDirName + "') MAXLOGSIZE 2");
            st.execute("create table emp2(id int not null primary key, name varchar(20) not null, addr varchar(2000) not null) persistent 'teststore_rem'");
            ps = conn.prepareStatement("insert into emp2 values(?, ?, ?)");
            for (int i = 0; i < 5000; ++i) {
                ps.setInt(1, i);
                ps.setString(2, "name" + i);
                ps.setString(3, str1k);
                int j = ps.executeUpdate();
                BugsTest.assertEquals((int)1, (int)j);
            }
            st.execute("select count(*) from emp2");
            rs = st.getResultSet();
            rs.next();
            BugsTest.assertEquals((int)5000, (int)rs.getInt(1));
            HashSet preBlowNotDoneDirs = new HashSet();
            preBlowNotDoneDirs.addAll(NativeCalls.TEST_NO_FALLOC_DIRS);
            if (hasExportDir) {
                BugsTest.assertTrue((boolean)NativeCalls.TEST_CHK_FALLOC_DIRS.isEmpty());
                BugsTest.assertEquals((int)preBlowDoneDirs.size(), (int)preBlowNotDoneDirs.size());
            } else {
                BugsTest.assertFalse((boolean)NativeCalls.TEST_CHK_FALLOC_DIRS.isEmpty());
                BugsTest.assertEquals((int)0, (int)preBlowNotDoneDirs.size());
            }
            NativeCalls.TEST_CHK_FALLOC_DIRS = null;
            NativeCalls.TEST_NO_FALLOC_DIRS.clear();
            NativeCalls.TEST_NO_FALLOC_DIRS = null;
            BugsTest.assertTrue((preBlowDoneDirs.size() > 0 ? 1 : 0) != 0);
        }
    }

    public void testBug50100() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        String sql = "CREATE TABLE app.test ( id bigint not null generated by default as identity (start with 1, increment by 1), batch_id bigint, constraint app_test_pk primary key (id) ) PARTITION BY PRIMARY KEY";
        st.execute(sql);
        st.execute("CREATE UNIQUE INDEX idx_app_test_id ON app.test ( id )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("select * from app.test where id in (1,2,3,4,5) or batch_id < 4");
        java.sql.ResultSet rs = st.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        BugsTest.assertEquals((int)5, (int)cnt);
        st.execute("CREATE INDEX idx_app_test_batch_id ON app.test ( batch_id )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("insert into app.test(batch_id) values( null )");
        st.execute("select * from app.test where id in (6,7,8,9,10) or batch_id < 4");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        BugsTest.assertEquals((int)5, (int)cnt);
    }

    public void testBug50100_1() throws Exception {
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        DMLQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        props1.put("mcast-port", String.valueOf(mport));
        BugsTest.setupConnection(props1);
        Connection conn = TestUtil.getConnection(props1);
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        String sql = "CREATE table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))  partition by range (since) (VALUES BETWEEN CAST('1998-01-01'  AS DATE) AND CAST('2000-08-11' AS DATE),  VALUES BETWEEN CAST('2003-09-01' AS DATE) AND  CAST('2007-12-31' AS DATE) )";
        st.execute(sql);
        st.execute("create  index index_2 on trade.customers ( SINCE desc  )");
        st.execute("create  index index_96 on trade.customers ( SINCE )");
        st.execute("create  index index_16 on trade.customers ( CUST_NAME   )");
        st.execute("insert into trade.customers values (1, 'name1', '1998-04-18', 'a', 1)");
        st.execute("insert into trade.customers values (2, 'name2', '2006-05-25', 'a', 1), (3, 'name3', '2007-06-12', 'a', 1), (4, 'name4', '2003-06-12', 'a', 1)");
        conn.commit();
        st.execute("select cid, since, cust_name from trade.customers where cust_name = 'name2' or since = '2003-06-12'");
        java.sql.ResultSet rs = st.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        BugsTest.assertEquals((int)2, (int)cnt);
        st.execute("select cid, since, cust_name from trade.customers where cust_name = 'name2' or since in ('2003-06-12', '2007-06-12', '2005-01-02')");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        BugsTest.assertEquals((int)3, (int)cnt);
        st.execute("select cid, since, cust_name from trade.customers where since in ('2003-06-12', '2007-06-12', '2005-01-02') or cust_name = 'name2'");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        BugsTest.assertEquals((int)3, (int)cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46851() throws Exception {
        if (isTransactional) {
            return;
        }
        this.reduceLogLevelForTest("config");
        try {
            File file = new File("perf.txt");
            PrintStream bw = System.out;
            System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
            System.setProperty("gemfire.off-heap-memory-size", "500m");
            Properties props = new Properties();
            props.setProperty("log-level", "config");
            props.setProperty("table-default-partitioned", "false");
            Connection conn = BugsTest.getConnection(props);
            Statement st = conn.createStatement();
            String resourcesDir = BugsTest.getResourcesDir();
            String schemaScript = resourcesDir + "/lib/tpch/create_tpch_tables_no_constraints.sql";
            String alterTableScript = resourcesDir + "/lib/tpch/alter_table_add_constraints.sql";
            String indexScript = resourcesDir + "/lib/tpch/create_indexes.sql";
            GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{schemaScript, alterTableScript, indexScript}, (boolean)false, (Logger)BugsTest.getLogger(), null, null, (boolean)false);
            st.executeUpdate("SET SCHEMA TPCHGFXD");
            st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TPCHGFXD', 'REGION', '" + resourcesDir + "/lib/tpch/region.tbl', '|', null, null, 0, 0, 4, 0, null, null)");
            st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TPCHGFXD', 'NATION', '" + resourcesDir + "/lib/tpch/nation.tbl', '|', null, null, 0, 0, 4, 0, null, null)");
            st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TPCHGFXD', 'PART', '" + resourcesDir + "/lib/tpch/part.tbl', '|', null, null, 0, 0, 4, 0, null, null)");
            st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TPCHGFXD', 'SUPPLIER', '" + resourcesDir + "/lib/tpch/supplier.tbl', '|', null, null, 0, 0, 4, 0, null, null)");
            st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TPCHGFXD', 'PARTSUPP', '" + resourcesDir + "/lib/tpch/partsupp.tbl', '|', null, null, 0, 0, 4, 0, null, null)");
            st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TPCHGFXD', 'CUSTOMER', '" + resourcesDir + "/lib/tpch/customer.tbl', '|', null, null, 0, 0, 4, 0, null, null)");
            st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TPCHGFXD', 'ORDERS', '" + resourcesDir + "/lib/tpch/orders.tbl', '|', null, null, 0, 0, 4, 0, null, null)");
            st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX ('TPCHGFXD', 'LINEITEM', '" + resourcesDir + "/lib/tpch/lineitem.tbl', '|', null, null, 0, 0, 4, 0, null, null)");
            String query9 = "select nation, o_year, sum(amount) as sum_profit  from (  select n_name as nation, year(o_orderdate) as o_year,  l_extendedprice * (1 - l_discount) - ps_supplycost * l_quantity as amount  from    part, supplier ,lineitem, partsupp, orders, nation  where  s_suppkey = l_suppkey and ps_suppkey = l_suppkey and  ps_partkey = l_partkey and p_partkey = l_partkey and o_orderkey = l_orderkey   and s_nationkey = n_nationkey and p_name like '%green%'  ) as profit group by  nation, o_year order by   nation, o_year desc";
            long start = System.currentTimeMillis();
            java.sql.ResultSet rs = st.executeQuery(query9);
            while (rs.next()) {
                rs.getObject(1);
            }
            long end = System.currentTimeMillis();
            bw.println("query 9 time=" + (end - start) + "milliseconds");
            BugsTest.assertTrue((end - start < 8000L ? 1 : 0) != 0);
            String query5 = "select n_name, sum(l_extendedprice * (1 - l_discount)) as revenue from   customer, orders  , lineitem, supplier  , nation, region where  c_custkey = o_custkey and l_orderkey = o_orderkey  and l_suppkey = s_suppkey and c_nationkey = s_nationkey   and s_nationkey = n_nationkey and n_regionkey = r_regionkey and r_name = 'ASIA'   and o_orderdate >= '1994-01-01'   and o_orderdate < cast({fn timestampadd(SQL_TSI_YEAR, 1, timestamp('1994-01-01 23:59:59'))} as DATE) group by   n_name order by   revenue desc";
            start = System.currentTimeMillis();
            rs = st.executeQuery(query5);
            while (rs.next()) {
                rs.getObject(1);
            }
            end = System.currentTimeMillis();
            bw.println("query 5 time=" + (end - start) + "milliseconds");
            BugsTest.assertTrue((end - start < 8000L ? 1 : 0) != 0);
            st.executeUpdate("drop table lineitem");
            st.executeUpdate("drop table  orders");
            st.executeUpdate("drop table partsupp");
            st.executeUpdate("drop table supplier");
            st.executeUpdate("drop table part");
            bw.flush();
            bw.close();
        }
        finally {
            System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
            System.setProperty("gemfire.off-heap-memory-size", "");
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug50729() throws Exception {
        this.reduceLogLevelForTest("config");
        try {
            String[] data;
            System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
            System.setProperty("gemfire.off-heap-memory-size", "500m");
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
            Properties props = new Properties();
            props.setProperty("log-level", "config");
            Connection conn = BugsTest.getConnection(props);
            Statement st = conn.createStatement();
            st.execute("create table networthv1 (cid bigint not null, cash decimal (30, 1), securities decimal (30, 1), loanlimit int, availloan decimal (30, 1),  tid int, constraint cash_ch_v1 check (cash>=0), constraint sec_ch_v1 check (securities >=0) , constraint availloan_ck_v1 check (loanlimit>=availloan and availloan >=0))  offheap ");
            String query = "update networthv1 set cash=cash-?, round = ?  where cid in (select min(cid) from networthv1 where (securities>? and cash > ? and cid >=?)and round < ?)";
            PreparedStatement insert = conn.prepareStatement("insert into networthv1 values(?,?,?,?,?,?)");
            for (String line : data = new String[]{"struct(CID:92,CASH:null,SECURITIES:null,LOANLIMIT:10000,AVAILLOAN:10000.0,TID:13,ROUND:0,C_CID:92)", "struct(CID:431,CASH:null,SECURITIES:null,LOANLIMIT:1000,AVAILLOAN:1000.0,TID:5,ROUND:0,C_CID:431)"}) {
                line = line.substring(7, line.length() - 1);
                StringTokenizer stz = new StringTokenizer(line, ":,");
                stz.nextToken();
                int cid = Integer.parseInt(stz.nextToken());
                insert.setInt(1, cid);
                stz.nextToken();
                String cashStr = stz.nextToken();
                if (cashStr.equalsIgnoreCase("null")) {
                    insert.setNull(2, 3);
                } else {
                    insert.setFloat(2, Float.parseFloat(cashStr));
                }
                stz.nextToken();
                String secStr = stz.nextToken();
                if (secStr.equalsIgnoreCase("null")) {
                    insert.setNull(3, 3);
                } else {
                    insert.setFloat(3, Float.parseFloat(secStr));
                }
                stz.nextToken();
                String llStr = stz.nextToken();
                if (llStr.equalsIgnoreCase("null")) {
                    insert.setNull(4, 4);
                } else {
                    insert.setInt(4, Integer.parseInt(llStr));
                }
                stz.nextToken();
                String avlStr = stz.nextToken();
                if (avlStr.equalsIgnoreCase("null")) {
                    insert.setNull(5, 6);
                } else {
                    insert.setFloat(5, Float.parseFloat(avlStr));
                }
                stz.nextToken();
                String tidStr = stz.nextToken();
                if (tidStr.equalsIgnoreCase("null")) {
                    insert.setNull(6, 4);
                } else {
                    insert.setInt(6, Integer.parseInt(tidStr));
                }
                insert.executeUpdate();
            }
            st.execute("alter table networthv1 add column round int  DEFAULT 0");
            st.execute("alter table networthv1 add column c_cid bigint DEFAULT 1");
            st.execute("update networthv1 set c_cid = cid");
            PreparedStatement psQuery = conn.prepareStatement(query);
            psQuery.setFloat(1, 46.8f);
            psQuery.setInt(2, 1);
            psQuery.setFloat(3, 205796.1f);
            psQuery.setInt(4, 2);
            psQuery.setInt(5, 266);
            psQuery.setInt(6, 1);
            psQuery.executeUpdate();
        }
        finally {
            System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
            System.setProperty("gemfire.off-heap-memory-size", "");
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
        }
    }

    public void testFlavourOf50729_1() throws Exception {
        Connection conn = BugsTest.getConnection();
        PreparedStatement prepStmt = conn.prepareStatement("create schema trade");
        prepStmt.execute();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (cust_name varchar(100), tid int)");
        stmt.execute("alter table trade.customers add column cid int not null default 1");
        stmt.execute("alter table trade.customers add constraint cust_pk primary key (cid)");
        stmt.executeUpdate("insert into trade.customers (cid, cust_name, tid) values(1,'name1',1)");
        int n = stmt.executeUpdate("delete from trade.customers where cid = 1");
        BugsTest.assertEquals((int)1, (int)n);
    }

    public void testFlavourOf50729_2() throws Exception {
        Connection conn = BugsTest.getConnection();
        PreparedStatement prepStmt = conn.prepareStatement("create schema trade");
        prepStmt.execute();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (cid int not null default 1,cust_name varchar(100), tid int)");
        stmt.execute("alter table trade.customers add constraint cust_pk primary key (cid)");
        stmt.execute("create table trade.portfolio (cid int not null, qty int not null,  tid int, constraint portf_pk primary key (cid))");
        stmt.execute("alter table trade.portfolio add constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict");
        stmt.executeUpdate("insert into trade.customers (cid, cust_name, tid) values(1,'name1',1)");
        stmt.executeUpdate("insert into trade.portfolio (cid, qty, tid) values(1,1,1)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug50756() throws Exception {
        this.reduceLogLevelForTest("config");
        try {
            String line;
            System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "500m");
            System.setProperty("gemfire.off-heap-memory-size", "500m");
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
            Properties props = new Properties();
            props.setProperty("log-level", "config");
            Connection conn = BugsTest.getConnection(props);
            Statement st = conn.createStatement();
            st.execute("create table customersv1 (cid bigint not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))  partition by column (cust_name)   offheap ");
            st.execute("create index indexcustomerv1tid on customersv1 (tid)");
            PreparedStatement insertCustomer = conn.prepareStatement("insert into customersv1 values(?,?,?,?,?)");
            String dataFile = BugsTest.getResourcesDir() + "/lib/bug50756/customers.dat";
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(dataFile)));
            while ((line = br.readLine()) != null && !line.trim().equals("")) {
                line = line.trim();
                line = line.substring(7, line.length() - 1);
                StringTokenizer stz = new StringTokenizer(line, ":,");
                stz.nextToken();
                long cid = Long.parseLong(stz.nextToken());
                insertCustomer.setLong(1, cid);
                stz.nextToken();
                String cust_nameStr = stz.nextToken();
                if (cust_nameStr.equalsIgnoreCase("null")) {
                    insertCustomer.setNull(2, 12);
                } else {
                    insertCustomer.setString(2, cust_nameStr);
                }
                stz.nextToken();
                String sinceStr = stz.nextToken();
                if (sinceStr.equalsIgnoreCase("null")) {
                    insertCustomer.setNull(3, 91);
                } else {
                    insertCustomer.setDate(3, Date.valueOf(sinceStr));
                }
                stz.nextToken();
                String addStr = stz.nextToken();
                if (addStr.equalsIgnoreCase("null")) {
                    insertCustomer.setNull(4, 12);
                } else {
                    insertCustomer.setString(4, addStr);
                }
                stz.nextToken();
                String tidStr = stz.nextToken();
                if (tidStr.equalsIgnoreCase("null")) {
                    insertCustomer.setNull(5, 4);
                } else {
                    insertCustomer.setInt(5, Integer.parseInt(tidStr));
                }
                insertCustomer.executeUpdate();
            }
            st.execute("alter table customersv1 add column round int DEFAULT 0");
            st.execute("create table networthv1 (cid bigint not null, cash decimal (30, 1), securities decimal (30, 1), loanlimit int, availloan decimal (30, 1),  tid int, constraint netw_pk_v1 primary key (cid), constraint cust_newt_fk_v1 foreign key (cid) references customersv1 (cid) on delete restrict, constraint cash_ch_v1 check (cash>=0), constraint sec_ch_v1 check (securities >=0), constraint availloan_ck_v1 check (loanlimit>=availloan and availloan >=0))  partition by range (cid) ( VALUES BETWEEN 0 AND 699, VALUES BETWEEN 699 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1577, VALUES BETWEEN 1577 AND 1800, VALUES BETWEEN 1800 AND 100000)   offheap ");
            st.execute("alter table networthv1 drop CHECK availloan_ck_v1");
            PreparedStatement insert = conn.prepareStatement("insert into networthv1 values(?,?,?,?,?,?)");
            dataFile = BugsTest.getResourcesDir() + "/lib/bug50756/networth.dat";
            br.close();
            br = new BufferedReader(new InputStreamReader(new FileInputStream(dataFile)));
            while ((line = br.readLine()) != null && !line.trim().equals("")) {
                line = line.trim();
                line = line.substring(7, line.length() - 1);
                StringTokenizer stz = new StringTokenizer(line, ":,");
                stz.nextToken();
                long cid = Long.parseLong(stz.nextToken());
                insert.setLong(1, cid);
                stz.nextToken();
                String cashStr = stz.nextToken();
                if (cashStr.equalsIgnoreCase("null")) {
                    insert.setNull(2, 3);
                } else {
                    insert.setFloat(2, Float.parseFloat(cashStr));
                }
                stz.nextToken();
                String secStr = stz.nextToken();
                if (secStr.equalsIgnoreCase("null")) {
                    insert.setNull(3, 3);
                } else {
                    insert.setFloat(3, Float.parseFloat(secStr));
                }
                stz.nextToken();
                String llStr = stz.nextToken();
                if (llStr.equalsIgnoreCase("null")) {
                    insert.setNull(4, 4);
                } else {
                    insert.setInt(4, Integer.parseInt(llStr));
                }
                stz.nextToken();
                String avlStr = stz.nextToken();
                if (avlStr.equalsIgnoreCase("null")) {
                    insert.setNull(5, 6);
                } else {
                    insert.setFloat(5, Float.parseFloat(avlStr));
                }
                stz.nextToken();
                String tidStr = stz.nextToken();
                if (tidStr.equalsIgnoreCase("null")) {
                    insert.setNull(6, 4);
                } else {
                    insert.setInt(6, Integer.parseInt(tidStr));
                }
                insert.executeUpdate();
            }
            st.execute("alter table networthv1 add column round int DEFAULT 0");
            st.execute("alter table networthv1 add column c_cid bigint with DEFAULT 1");
            st.executeUpdate("update networthv1 set c_cid = cid");
            st.execute("alter table networthv1 add constraint cust_newt_fk_v1_2 FOREIGN KEY (c_cid) references customersv1 (cid) on delete restrict");
            st.execute("alter table networthv1 drop constraint cust_newt_fk_v1");
            st.execute("alter table customersv1 ALTER COLUMN cid SET GENERATED ALWAYS AS IDENTITY");
            PreparedStatement updtNtw = conn.prepareStatement("update networthv1 set cash=cash-?, round = ?  where cid in (select min(cid) from networthv1 where (securities>? and cash > ? and cid >=?)and round < ?)");
            updtNtw.setFloat(1, 505.2f);
            updtNtw.setInt(2, 1);
            updtNtw.setFloat(3, 144574.8f);
            updtNtw.setFloat(4, 9.0f);
            updtNtw.setLong(5, 61L);
            updtNtw.setInt(6, 1);
            updtNtw.executeUpdate();
            updtNtw.setFloat(1, 39.7f);
            updtNtw.setInt(2, 1);
            updtNtw.setFloat(3, 17494.6f);
            updtNtw.setFloat(4, 9.0f);
            updtNtw.setLong(5, 59L);
            updtNtw.setInt(6, 1);
            updtNtw.executeUpdate();
            PreparedStatement updtCust = conn.prepareStatement(" update customersv1 set addr = ?, round = ? where (cust_name=? or since = ? ) and round < ?");
            updtCust.setString(1, "address is name16");
            updtCust.setInt(2, 1);
            updtCust.setString(3, "name16");
            updtCust.setDate(4, Date.valueOf("2005-09-14"));
            updtCust.setInt(5, 1);
            updtCust.executeUpdate();
            updtNtw.setFloat(1, 505.2f);
            updtNtw.setInt(2, 1);
            updtNtw.setFloat(3, 144574.8f);
            updtNtw.setFloat(4, 9.0f);
            updtNtw.setLong(5, 61L);
            updtNtw.setInt(6, 1);
            updtNtw.executeUpdate();
            java.sql.ResultSet rs = st.executeQuery("select count(*) from networthv1 where c_cid = 45 or c_cid=44");
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((int)2, (int)rs.getInt(1));
            PreparedStatement deleteCust = conn.prepareStatement(" delete from customersv1 where cid in (? , ?)");
            deleteCust.setLong(1, 45L);
            deleteCust.setLong(2, 44L);
            try {
                deleteCust.executeUpdate();
                BugsTest.fail("delete should fail due to FK constraint violation");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().indexOf("23503") == -1) {
                    throw sqle;
                }
            }
        }
        finally {
            System.setProperty("gemfire.OFF_HEAP_TOTAL_SIZE", "");
            System.setProperty("gemfire.off-heap-memory-size", "");
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49995() throws Exception {
        try {
            System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "true");
            Properties props1 = new Properties();
            int mport = AvailablePort.getRandomAvailablePort((int)1);
            props1.put("mcast-port", String.valueOf(mport));
            BugsTest.setupConnection(props1);
            Connection conn = TestUtil.getConnection(props1);
            Properties props = new Properties();
            props.setProperty("single-hop-enabled", "true");
            props.setProperty("single-hop-max-connections", "5");
            Connection connClient = BugsTest.startNetserverAndGetLocalNetConnection(props);
            Statement st = conn.createStatement();
            st.execute("drop table if exists history");
            st.execute("create table history(house_id integer, household_id integer, plug_id integer, time_slice smallint, load_total float(23), load_count integer) partition by column (house_id)");
            st.execute("create index history_idx on history (house_id, household_id, plug_id, time_slice)");
            st.execute("insert into history (house_id, household_id, plug_id, time_slice, load_total, load_count) values(0, 8, 9, 190, 44.868, 1), (0, 8, 9, 191, 44.868, 1), (0, 8, 9, 192, 44.868, 1), (0, 8, 9, 193, 44.868, 1), (0, 8, 9, 194, 44.868, 1)");
            Statement stclient = connClient.createStatement();
            stclient.execute("select * from history where house_id = 0 and household_id = 8 and plug_id = 9 and time_slice = 193");
            stclient.execute("explain select * from history where house_id = 0 and household_id = 8 and plug_id = 9");
            stclient.execute("select * from history where house_id = 0 and household_id = 8 and plug_id = 9  and time_slice = 193");
        }
        finally {
            System.setProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING, "false");
        }
    }

    public void testBug48976() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))  REDUNDANCY 2 PERSISTENT SYNCHRONOUS");
        st.execute("insert into trade.portfolio values(100, 100, 100, 100, 10.2, 100)");
        st.execute("create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10), tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict, constraint status_ch check (status in ('cancelled', 'open', 'filled')))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))  REDUNDANCY 2 PERSISTENT SYNCHRONOUS");
        st.execute("insert into trade.sellorders values(100, 100, 100, 100, 10.2, '2013-12-13 10:10:10', 'open', 100)");
        st.execute("select * from TRADE.SELLORDERS where OID >= 10  or CID >= 100");
        java.sql.ResultSet rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((int)100, (int)rs.getInt(1));
        BugsTest.assertFalse((boolean)rs.next());
    }

    public void testBug47329_more() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("create table t1 (c1 int primary key, c2 long varchar, c3 int)");
        st.execute("create index idx on t1(c2)");
        st.executeUpdate("insert into t1 values(0,'',3)");
        st.executeUpdate("insert into t1 values(1,' ',3)");
        st.executeUpdate("insert into t1 values(2,'aaaa',4)");
        st.executeUpdate("insert into t1 values(3,'aa aa',5)");
        st.executeUpdate("insert into t1 values(4,'aa  aa',6)");
        st.executeUpdate("insert into t1 values(5,'aa  ab',7)");
        st.executeUpdate("insert into t1 values(6,'aa  bb',8)");
        st.executeUpdate("insert into t1 values(7,'aa ab',9)");
        st.executeUpdate("insert into t1 values(8,'aa a~',9)");
        st.executeUpdate("insert into t1 values(9,'`a a@',9)");
        st.executeUpdate("insert into t1 values(10,'  aa  ',9)");
        int totalRows = 11;
        st.executeQuery("select * from t1 where c2 like '%'");
        rs = st.getResultSet();
        this.assertSize(rs, totalRows);
        st.executeQuery("select * from t1 where c2 like '%%'");
        rs = st.getResultSet();
        this.assertSize(rs, totalRows);
        PreparedStatement ps = conn.prepareStatement("select * from t1 where c2 like ?");
        ps.setString(1, "%a%");
        rs = ps.executeQuery();
        this.assertSize(rs, totalRows - 2);
        st.executeQuery("select * from t1 where c2 like '%a%'");
        rs = st.getResultSet();
        this.assertSize(rs, totalRows - 2);
        st.executeQuery("select * from t1 where c2 like '%aa%'");
        rs = st.getResultSet();
        this.assertSize(rs, totalRows - 3);
        st.executeQuery("select * from t1 where c2 like '%a a%'");
        rs = st.getResultSet();
        this.assertSize(rs, 4);
        st.executeQuery("select * from t1 where c2 like '%a  a%'");
        rs = st.getResultSet();
        this.assertSize(rs, 2);
        st.executeQuery("select * from t1 where c2 like '% %'");
        rs = st.getResultSet();
        this.assertSize(rs, 9);
        st.executeQuery("select * from t1 where c2 like '%  %'");
        rs = st.getResultSet();
        this.assertSize(rs, 4);
        st.executeQuery("select * from t1 where c2 like '  aa  '");
        rs = st.getResultSet();
        this.assertSize(rs, 1);
        st.executeQuery("select * from t1 where c2 like ' '");
        rs = st.getResultSet();
        this.assertSize(rs, 1);
        st.executeQuery("select * from t1 where c2 like '%  aa  '");
        rs = st.getResultSet();
        this.assertSize(rs, 1);
    }

    public void assertSize(java.sql.ResultSet resultSet, int size) throws SQLException {
        int count = 0;
        while (resultSet.next()) {
            ++count;
        }
        BugsTest.assertEquals((String)"ResultSet size mismatch", (int)size, (int)count);
    }

    public void _testBug46792() throws Exception {
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        BugsTest.setupConnection(props1);
        Connection conn = TestUtil.getConnection(props1);
        Statement s = conn.createStatement();
        s.execute("create table t1 (c1 int, c2 int) partition by column(c1)");
        s.execute("create table empty (c1 int, c2 int) partition by column(c1)");
        s.execute("insert into t1 values (null,null),(1,1),(null,null),(2,1),(3,1),(10,10)");
        s.execute("select max((select c1 from empty)) from t1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug48533() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema emp");
        st.execute("create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int) partition by (depId) redundancy 0");
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public boolean throwPutAllPartialException() {
                return true;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        PreparedStatement pstmnt = conn.prepareStatement("INSERT INTO emp.employee VALUES (?, ?)");
        for (int i = 0; i < 10; ++i) {
            pstmnt.setString(1, "Jones" + i);
            pstmnt.setInt(2, i);
            pstmnt.addBatch();
        }
        try {
            pstmnt.executeBatch();
            BugsTest.fail("Test should not reach here");
        }
        catch (SQLException se) {
            System.out.println("state is: " + se.getSQLState());
            BugsTest.assertTrue((boolean)"X0Z09".equals(se.getSQLState()));
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testDeleteInPersistentRegion() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int not null unique, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty)) PERSISTENT SYNCHRONOUS");
        st.execute("insert into trade.portfolio values(938, 329, 756, 756, 49956.48000000000000000000, 1)");
        st.execute("delete from trade.portfolio where cid = 938 and sid = 329 and tid = 1");
        st.execute("insert into trade.portfolio values(938, 329, 756, 756, 49956.48000000000000000000, 1)");
    }

    public void testBug47329() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("create table t1 (c1 int primary key, c2  varchar(10))");
        st.execute("create index idx on  t1(c2)");
        PreparedStatement pstmt = conn.prepareStatement("insert into t1 values(?,?)");
        pstmt.setInt(1, 111);
        pstmt.setString(2, "aaaaa");
        pstmt.executeUpdate();
        pstmt.setInt(1, 222);
        pstmt.setString(2, "");
        pstmt.executeUpdate();
        st.execute("select c1 from t1 where c2 like '%a%'");
        rs = st.getResultSet();
        System.out.println("rs=" + rs);
        BugsTest.assertEquals((boolean)true, (boolean)rs.next());
        BugsTest.assertEquals((int)111, (int)rs.getInt(1));
    }

    public void testBug46979() throws Exception {
        block2: {
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("create table app.customers (ccid int) replicate");
            st.execute("create table app.networth (ncid int) partition by column (ncid)");
            st.execute("insert into app.customers values (11)");
            st.execute("insert into app.customers values (22)");
            st.execute("insert into app.customers values (33)");
            st.execute("insert into app.customers values (44)");
            st.execute("insert into app.customers values (55)");
            st.execute("insert into app.networth values (11)");
            st.execute("insert into app.networth values (22)");
            st.execute("insert into app.networth values (44)");
            st.execute("insert into app.networth values (55)");
            try {
                st.execute("select * from app.customers c left outer join app.networth n on c.ccid = n.ncid where n.ncid is null");
                BugsTest.fail("Left outer join with RR and PR and IS NULL is not supported. Expect exception 0A000.");
            }
            catch (SQLException sqle) {
                if (!(sqle instanceof DerbySQLException ? !((DerbySQLException)sqle).getMessageId().equals("0A000.S") : !"0A000".equals(sqle.getSQLState()))) break block2;
                throw sqle;
            }
        }
    }

    public void testBug47464_NPE() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table t1 (col1 int, col2 clob)");
        st.execute("insert into t1 values (123, cast('abc' as clob))");
        st.execute("create index idx on t1(col1)");
        st.execute("update t1 set col1 = 789 where col1 = 123");
    }

    public void test48074_TSMC() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        conn.createStatement().execute("CREATE TABLE COMSPC.COM_SPC_SYS_MGMT_HIST  (   SYS_NAME VARCHAR(12 ) NOT NULL,   OPER_TIME DATE DEFAULT CURRENT_DATE,   FAB_NAME VARCHAR(12 ),  PRIMARY KEY (SYS_NAME,OPER_TIME))PARTITION BY (cast( MONTH(OPER_TIME) AS CHAR(3))||SYS_NAME)  REDUNDANCY 1  PERSISTENT ASYNCHRONOUS");
        conn.createStatement().execute("insert into COMSPC.COM_SPC_SYS_MGMT_HIST (SYS_NAME, FAB_NAME) values ('1', '1')");
        conn.createStatement().execute("insert into COMSPC.COM_SPC_SYS_MGMT_HIST (SYS_NAME, FAB_NAME) values ('2', '2'), ('3', '3'), ('4', '4') ");
        java.sql.ResultSet rs = conn.createStatement().executeQuery("select * from COMSPC.COM_SPC_SYS_MGMT_HIST where ( cast(MONTH(OPER_TIME) as char(3)) || SYS_NAME ) = (cast(MONTH(CURRENT_DATE) as char(3)) || '3') ");
        while (rs.next()) {
            BugsTest.assertEquals((String)"3", (String)rs.getString(1));
            BugsTest.assertEquals((String)"3", (String)rs.getString(3));
        }
        conn.close();
    }

    public void testVMRestart_Char() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table chartab (col1 char(5) primary key) persistent");
        st.execute("insert into chartab values ('one ')");
        BugsTest.shutDown();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from chartab where col1 = 'one'");
        java.sql.ResultSet rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"one  ", (String)rs.getString(1));
    }

    public void testVMRestart_Varchar() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table varchartab (col1 varchar(5) primary key) persistent");
        st.execute("insert into varchartab values ('one ')");
        BugsTest.shutDown();
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        st.execute("select * from varchartab where col1 = 'one'");
        java.sql.ResultSet rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"one ", (String)rs.getString(1));
        rs.close();
        st.execute("select * from varchartab where col1 = 'one '");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"one ", (String)rs.getString(1));
    }

    public void test48278_51000() throws Exception {
        this.reduceLogLevelForTest("config");
        Properties props = new Properties();
        props.setProperty("mcast-port", String.valueOf(AvailablePort.getRandomAvailablePort((int)1)));
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table t1 (col1 bigint)");
        int numRows = 500001;
        PreparedStatement ps = conn.prepareStatement("insert into t1 values(?)");
        for (int col1 = 0; col1 < 500001; ++col1) {
            ps.setLong(1, col1);
            ps.addBatch();
            if (col1 % 1000 != 0) continue;
            ps.executeBatch();
            conn.commit();
        }
        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)"Creating index idx");
        st.execute("create index idx on t1(col1)");
        SanityManager.DEBUG_PRINT((String)"TraceIndex", (String)"Created index idx");
        java.sql.ResultSet rs = st.executeQuery("select count(*) from t1 where col1 > 1");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((int)499999, (int)rs.getInt(1));
        BugsTest.assertFalse((boolean)rs.next());
        PreparedStatement pstmt = conn.prepareStatement("select col1 from t1 where col1=?");
        for (int col1 = 0; col1 < 500001; ++col1) {
            pstmt.setLong(1, col1);
            rs = pstmt.executeQuery();
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((long)col1, (long)rs.getLong(1));
            BugsTest.assertFalse((boolean)rs.next());
            rs.close();
        }
    }

    public void testBug47671() throws Exception {
        block2: {
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            try {
                st.execute("create table customers (id varchar(10) primary key, name char(40))");
                st.execute("insert into customers values ('', 'abc')");
                st.execute("insert into customers values ('', 'def')");
                BugsTest.fail("java.sql.SQLException(23505): primary key constraint violation is expected.");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("23505")) break block2;
                throw sqle;
            }
        }
    }

    public void testBug46933() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("create table customers (id int primary key, name char(40))");
        st.execute("insert into customers values (123, 'abc')");
        st.execute("update customers set name = 'def' where id = 123");
        st.execute("select name from customers where id = 123");
        rs = st.getResultSet();
        while (rs.next()) {
            BugsTest.assertEquals((int)40, (int)rs.getString(1).length());
        }
        PreparedStatement ps = conn.prepareStatement("update customers set name = ? where id = 123");
        ps.setString(1, null);
        ps.executeUpdate();
        st.execute("select name from customers where id = 123");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertNull((Object)rs.getString(1));
    }

    public void testBug47148() throws Exception {
        BugsTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Connection conn2 = BugsTest.startNetserverAndGetLocalNetConnection();
        Statement stmt = conn.createStatement();
        java.sql.ResultSet rs = null;
        stmt.execute("Create Table TEST_TABLE(idx numeric(12),AccountID varchar(10),OrderNo varchar(20),primary key(idx))PARTITION BY COLUMN ( AccountID )");
        stmt.execute("CREATE INDEX idx_AccountID ON test_Table (AccountID ASC)");
        stmt.execute("insert into test_table values(9, '8', '8')");
        String query = "select accountid from test_table where accountid like '8'";
        Statement stmt2 = conn2.createStatement();
        rs = stmt2.executeQuery(query);
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"8", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery(query);
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"8", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
        rs.close();
        stmt.close();
        stmt2.close();
        conn.close();
        conn2.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49193_1() throws Exception {
        BugsTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("create table customers (cid int not null, cust_name varchar(100), col1 int , col2 int not null unique ,tid int, primary key (cid))  partition by range(tid)   ( values between 0  and 10    ,values between 10  and 100)");
            stmt.execute("create index i1 on customers(col1)");
            PreparedStatement psInsert = conn.prepareStatement("insert into customers values (?,?,?,?,?)");
            for (int i = 1; i < 20; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setInt(3, i % 4);
                psInsert.setInt(4, i);
                psInsert.setInt(5, 1);
                psInsert.executeUpdate();
            }
            conn = TestUtil.getConnection();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGlobalIndexDelete() {
                    throw new PartitionOfflineException(null, "test ignore");
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                    return Double.MIN_VALUE;
                }
            });
            BugsTest.addExpectedException(PartitionOfflineException.class);
            try {
                stmt.executeUpdate("delete from customers where cid > 0");
                BugsTest.fail("Test should fail due to problem in global index maintenance");
            }
            catch (Exception ignore) {
                BugsTest.removeExpectedException(PartitionOfflineException.class);
            }
            GemFireXDQueryObserverHolder.clearInstance();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                    return Double.MIN_VALUE;
                }
            });
            stmt.executeUpdate("delete from customers where cid > 0");
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug49193_2() throws Exception {
        BugsTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("create table customers (cid int not null, cust_name varchar(100), col1 int , col2 int not null unique ,tid int, primary key (cid))  partition by range(tid)   ( values between 0  and 10    ,values between 10  and 100)");
            stmt.execute("create index i1 on customers(col1)");
            PreparedStatement psInsert = conn.prepareStatement("insert into customers values (?,?,?,?,?)");
            for (int i = 1; i < 2; ++i) {
                psInsert.setInt(1, i);
                psInsert.setString(2, "name" + i);
                psInsert.setInt(3, i % 4);
                psInsert.setInt(4, i);
                psInsert.setInt(5, 1);
                psInsert.executeUpdate();
            }
            conn = TestUtil.getConnection();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void beforeGlobalIndexDelete() {
                    throw new PartitionOfflineException(null, "test ignore");
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                    return Double.MIN_VALUE;
                }
            });
            BugsTest.addExpectedException(PartitionOfflineException.class);
            try {
                stmt.executeUpdate("delete from customers where cid > 0");
                BugsTest.fail("Test should fail due to problem in global index maintenance");
            }
            catch (Exception ignore) {
                BugsTest.removeExpectedException(PartitionOfflineException.class);
            }
            GemFireXDQueryObserverHolder.clearInstance();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimizerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimizerEvalutatedCost) {
                    return Double.MIN_VALUE;
                }
            });
            stmt.executeUpdate("delete from customers where cid > 0");
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testBug46584() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) replicate");
        st.execute("create view trade.securities_vw (sec_id, symbol, exchange) as select sec_id, symbol, exchange from trade.securities");
        st.execute("insert into trade.securities values (1, 'VMW', 'nye')");
        st.execute("select length(symbol) from trade.securities_vw where symbol = 'VMW'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((int)3, (int)rs.getInt(1));
        st.execute("insert into trade.securities values (2, 'EMC ', 'nye')");
        st.execute("select length(symbol) from trade.securities_vw where symbol = 'EMC'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((int)4, (int)rs.getInt(1));
    }

    public void testBug46568() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("create table chartab(tsn char(10) primary key)");
        st.execute("insert into chartab values('1')");
        st.execute("select * from chartab where tsn = '1'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"1         ", (String)rs.getString(1));
        st.execute("select * from chartab where tsn = '1   '");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"1         ", (String)rs.getString(1));
        st.execute("select * from chartab where tsn in ('1')");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"1         ", (String)rs.getString(1));
        st.execute("select * from chartab where tsn in ('1   ')");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"1         ", (String)rs.getString(1));
        st.execute("create table chartab2(tsn char(10))");
        st.execute("insert into chartab2 values('1')");
        st.execute("select * from chartab2 where tsn = '1'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"1         ", (String)rs.getString(1));
        st.execute("select * from chartab2 where tsn = '1   '");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"1         ", (String)rs.getString(1));
        st.execute("select * from chartab2 where tsn in ('1')");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"1         ", (String)rs.getString(1));
        st.execute("select * from chartab2 where tsn in ('1   ')");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"1         ", (String)rs.getString(1));
        st.execute("create table x9 (col1 char(10) for bit data primary key)");
        st.execute("insert into x9 values (x'102030')");
        st.execute("select * from x9 where col1=x'102030'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        byte[] expectedBytes = new byte[]{16, 32, 48, 32, 32, 32, 32, 32, 32, 32};
        BugsTest.assertTrue((boolean)Arrays.equals(expectedBytes, rs.getBytes(1)));
        st.execute("create table x10 (col1 char(10) for bit data)");
        st.execute("insert into x10 values (x'102030')");
        st.execute("select * from x10 where col1=x'102030'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(expectedBytes, rs.getBytes(1)));
        st.execute("create table x11 (col1 varchar(10) for bit data primary key)");
        st.execute("insert into x11 values (x'102030')");
        st.execute("select * from x11 where col1=x'102030'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        byte[] expectedBytes2 = new byte[]{16, 32, 48};
        BugsTest.assertTrue((boolean)Arrays.equals(expectedBytes2, rs.getBytes(1)));
        st.execute("create table x12 (col1 varchar(10) for bit data)");
        st.execute("insert into x12 values (x'102030')");
        st.execute("select * from x12 where col1=x'102030'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(expectedBytes2, rs.getBytes(1)));
        st.execute("create table pvarcharfbd (tsn varchar(10) for bit data) partition by column(tsn);");
        st.execute("insert into pvarcharfbd values (x'414243')");
        st.execute("insert into pvarcharfbd values (x'414244')");
        st.execute("select * from pvarcharfbd where tsn=x'414243'");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
    }

    public void testBug46490() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("create table chartab(tsn char(5))");
        st.execute("insert into chartab values('test1')");
        st.execute("select * from chartab where tsn = 'test1aaa'");
        rs = st.getResultSet();
        BugsTest.assertFalse((boolean)rs.next());
        st.execute("create table varchartab(tsn varchar(5))");
        st.execute("insert into varchartab values('test1')");
        st.execute("select * from varchartab where tsn = 'test1aaa'");
        rs = st.getResultSet();
        BugsTest.assertFalse((boolean)rs.next());
        st.execute("create table charfbdtab(tsn char(5) for bit data)");
        st.execute("insert into charfbdtab values(x'1011121314')");
        st.execute("select * from charfbdtab where tsn = x'1011121314151617'");
        rs = st.getResultSet();
        BugsTest.assertFalse((boolean)rs.next());
        st.execute("create table varcharfbdtab(tsn varchar(5) for bit data)");
        st.execute("insert into varcharfbdtab values(x'1011121314')");
        st.execute("select * from varcharfbdtab where tsn = x'1011121314151617'");
        rs = st.getResultSet();
        BugsTest.assertFalse((boolean)rs.next());
        st.execute("create table chartab2(tsn char(5) primary key)");
        st.execute("insert into chartab2 values('test1')");
        st.execute("select * from chartab2 where tsn = 'test1aaa'");
        rs = st.getResultSet();
        BugsTest.assertFalse((boolean)rs.next());
        st.execute("create table varchartab2(tsn varchar(5) primary key)");
        st.execute("insert into varchartab2 values('test1')");
        st.execute("select * from varchartab2 where tsn = 'test1aaa'");
        rs = st.getResultSet();
        BugsTest.assertFalse((boolean)rs.next());
        st.execute("create table charfbdtab2(tsn char(5) for bit data primary key)");
        st.execute("insert into charfbdtab2 values(x'1011121314')");
        st.execute("select * from charfbdtab2 where tsn = x'1011121314151617'");
        rs = st.getResultSet();
        BugsTest.assertFalse((boolean)rs.next());
        st.execute("create table varcharfbdtab2(tsn varchar(5) for bit data primary key)");
        st.execute("insert into varcharfbdtab2 values(x'1011121314')");
        st.execute("select * from varcharfbdtab2 where tsn = x'1011121314151617'");
        rs = st.getResultSet();
        BugsTest.assertFalse((boolean)rs.next());
        st.execute("create table vt1 (col1 varchar(10) primary key, col2 char(5))");
        st.execute("insert into vt1 values ('b', 'abc')");
        st.execute("select * from vt1 where col1 = 'b '");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"b", (String)rs.getString(1));
        BugsTest.assertEquals((String)"abc  ", (String)rs.getString(2));
        st.execute("create table vt2 (col1 varchar(10) , col2 char(5), primary key(col1, col2))");
        st.execute("insert into vt2 values ('b', 'abc')");
        st.execute("select * from vt2 where col1 = 'b   ' and col2 = 'abc'");
        rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"b", (String)rs.getString(1));
        BugsTest.assertEquals((String)"abc  ", (String)rs.getString(2));
    }

    public void testBug46508() throws Exception {
        Properties prop = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        prop.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(prop);
        Statement s = conn.createStatement();
        Object rs = null;
        try {
            s.execute("create table ct (c1 char(1), c2 char(5) not null, c3 char(30) default null)");
            s.execute("insert into ct values ('1', '11111', '111111111111111111111111111111')");
            s.execute("insert into ct values ('44', '4', '4')");
        }
        catch (SQLException se) {
            BugsTest.assertEquals((String)"22001", (String)se.getSQLState());
        }
        try {
            s.execute("create table vct (c1 varchar(1), c2 varchar(5) not null, c3 varchar(30) default null)");
            s.execute("insert into vct values ('1', '11111', '111111111111111111111111111111')");
            s.execute("insert into vct values ('44', '4', '4')");
        }
        catch (SQLException se) {
            BugsTest.assertEquals((String)"22001", (String)se.getSQLState());
        }
        try {
            s.execute("create table cfbdt (c1 char(1) for bit data)");
            s.execute("insert into cfbdt values (x'10')");
            s.execute("insert into cfbdt values (x'1010')");
        }
        catch (SQLException se) {
            BugsTest.assertEquals((String)"22001", (String)se.getSQLState());
        }
        try {
            s.execute("create table vcfbdt (c1 varchar(1) for bit data)");
            s.execute("insert into vcfbdt values (x'10')");
            s.execute("insert into vcfbdt values (x'1010')");
        }
        catch (SQLException se) {
            BugsTest.assertEquals((String)"22001", (String)se.getSQLState());
        }
    }

    public void testBug46444() throws Exception {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        Properties props = new Properties();
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE ap.account_balances (account_id           BIGINT NOT NULL, balance_type         SMALLINT NOT NULL, account_balance          BIGINT NOT NULL, locked_by                INT NOT NULL DEFAULT -1, PRIMARY KEY (account_id, balance_type)) PARTITION BY COLUMN (account_id)");
        st.execute("insert into ap.account_balances values(744, 0, 99992000, -1)");
        st.execute("CREATE TABLE ap.betting_user_accounts(account_id           BIGINT NOT NULL, account_number       CHAR(50) NOT NULL, PRIMARY KEY (account_id)) PARTITION BY COLUMN (account_id)");
        st.execute("insert into ap.betting_user_accounts values(744, '2e7')");
        st.execute("CREATE TABLE ap.account_allowed_bet_type(account_id           BIGINT NOT NULL, allow_bet_type       SMALLINT NOT NULL, FOREIGN KEY (account_id) REFERENCES ap.betting_user_accounts (account_id)) PARTITION BY COLUMN (account_id) COLOCATE WITH (ap.betting_user_accounts)");
        st.execute("CREATE UNIQUE INDEX betting_user_accounts_udx01 ON ap.betting_user_accounts(account_number)");
        st.execute("insert into ap.account_allowed_bet_type values(744, 0)");
        st.execute("UPDATE ap.account_balances SET locked_by = 1 WHERE ap.account_balances.balance_type=0 AND ap.account_balances.account_balance >= 1000 AND ap.account_balances.account_id IN (SELECT b.account_id FROM ap.betting_user_accounts b, ap.account_allowed_bet_type t WHERE b.account_id = t.account_id AND b.account_number='2e7' AND t.allow_bet_type=0 )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPrepStatementBatchUpdate() throws Exception {
        Properties props1 = new Properties();
        int mport = AvailablePort.getRandomAvailablePort((int)1);
        props1.put("mcast-port", String.valueOf(mport));
        BugsTest.setupConnection(props1);
        long initialvalueofmaxbatchsize = GemFireXDUtils.DML_MAX_CHUNK_SIZE;
        try {
            for (int txntxitr = 0; txntxitr < 2; ++txntxitr) {
                GemFireXDUtils.DML_MAX_CHUNK_SIZE = 50L;
                System.setProperty("gemfirexd.dml-max-chunk-size", "50");
                Connection conn = TestUtil.getConnection(props1);
                if (txntxitr > 0) {
                    conn.setTransactionIsolation(2);
                }
                Statement s = conn.createStatement();
                s.execute("create schema emp");
                MultipleInsertsLeveragingPutAllDUnit.BatchInsertObserver bos = new MultipleInsertsLeveragingPutAllDUnit.BatchInsertObserver();
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)bos);
                for (int type = 0; type < 6; ++type) {
                    String tableType = type % 3 == 0 ? "partition by primary key" : (type % 3 == 1 ? "partition by column (firstname)" : "replicate");
                    s.execute("create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int, firstname varchar(30)) " + tableType);
                    PreparedStatement pstmnt = conn.prepareStatement("INSERT INTO emp.employee VALUES (?, ?, ?)");
                    pstmnt.setString(1, "Jones");
                    pstmnt.setInt(2, 33);
                    pstmnt.setString(3, "Brendon");
                    pstmnt.addBatch();
                    pstmnt.setString(1, "Rafferty");
                    pstmnt.setInt(2, 31);
                    pstmnt.setString(3, "Bill");
                    pstmnt.addBatch();
                    pstmnt.setString(1, "Robinson");
                    pstmnt.setInt(2, 34);
                    pstmnt.setString(3, "Ken");
                    pstmnt.addBatch();
                    pstmnt.setString(1, "Steinberg");
                    pstmnt.setInt(2, 33);
                    pstmnt.setString(3, "Richard");
                    pstmnt.addBatch();
                    pstmnt.setString(1, "Smith");
                    pstmnt.setInt(2, 34);
                    pstmnt.setString(3, "Robin");
                    pstmnt.addBatch();
                    pstmnt.setString(1, "John");
                    pstmnt.setNull(2, 4);
                    pstmnt.setString(3, "Wright");
                    pstmnt.addBatch();
                    int[] status = pstmnt.executeBatch();
                    bos.clear();
                    PreparedStatement pstmnt2 = conn.prepareStatement("update emp.employee set depId = ? where lastname = ?");
                    pstmnt2.setInt(1, 100);
                    pstmnt2.setString(2, "Jones");
                    pstmnt2.addBatch();
                    pstmnt2.setInt(1, 100);
                    pstmnt2.setString(2, "Rafferty");
                    pstmnt2.addBatch();
                    pstmnt2.setInt(1, 100);
                    if (type < 3) {
                        pstmnt2.setString(2, "Robinson");
                    } else {
                        pstmnt2.setString(2, "Armstrong");
                    }
                    pstmnt2.addBatch();
                    BugsTest.assertEquals((int)0, (int)bos.getBatchSize());
                    status = pstmnt2.executeBatch();
                    BugsTest.assertTrue((bos.getBatchSize() >= 1 ? 1 : 0) != 0);
                    bos.clear();
                    java.sql.ResultSet rs = s.executeQuery("select * from emp.employee where depId = 100");
                    int cnt = 0;
                    boolean JonesDone = false;
                    boolean RaffertyDone = false;
                    boolean RobinsonDone = false;
                    while (rs.next()) {
                        ++cnt;
                        String lastName = rs.getString(1);
                        if (lastName.equalsIgnoreCase("Jones")) {
                            BugsTest.assertFalse((boolean)JonesDone);
                            JonesDone = true;
                            continue;
                        }
                        if (lastName.equalsIgnoreCase("Rafferty")) {
                            BugsTest.assertFalse((boolean)RaffertyDone);
                            RaffertyDone = true;
                            continue;
                        }
                        if (lastName.equalsIgnoreCase("Robinson")) {
                            BugsTest.assertFalse((boolean)RobinsonDone);
                            RobinsonDone = true;
                            continue;
                        }
                        BugsTest.fail("unexpected lastName: " + lastName);
                    }
                    if (type < 3) {
                        BugsTest.assertEquals((int)3, (int)cnt);
                    } else {
                        BugsTest.assertEquals((int)2, (int)cnt);
                    }
                    conn.commit();
                    s.execute("drop table emp.employee");
                }
                s.execute("drop schema emp restrict");
                conn.close();
            }
        }
        finally {
            GemFireXDUtils.DML_MAX_CHUNK_SIZE = initialvalueofmaxbatchsize;
        }
    }

    public void testBug46046() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table chartab (tsn char(10))");
        st.execute("insert into chartab values ('2011')");
        st.execute("insert into chartab values ('2014')");
        st.execute("insert into chartab values ('2017')");
        st.execute("select * from chartab where tsn='2011'");
        java.sql.ResultSet rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2011"));
        st.execute("select * from chartab where tsn>'2012' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2014"));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2017"));
        st.execute("select * from chartab where tsn<'2020' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2011"));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2014"));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2017"));
        st.execute("create table varchartab (tsn varchar(10))");
        st.execute("insert into varchartab values ('2012')");
        st.execute("insert into varchartab values ('2014')");
        st.execute("insert into varchartab values ('2016')");
        st.execute("select * from varchartab where tsn='2012'");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2012"));
        st.execute("select * from varchartab where tsn>'2010' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2012"));
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2014"));
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2016"));
        st.execute("select * from varchartab where tsn<'2015' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2012"));
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2014"));
        st.execute("create table pchartab (tsn char(10)) partition by column(tsn)");
        st.execute("insert into pchartab values ('2013')");
        st.execute("insert into pchartab values ('2013')");
        st.execute("insert into pchartab values ('2015')");
        st.execute("insert into pchartab values ('2017')");
        st.execute("select * from pchartab where tsn='2013'");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2013"));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2013"));
        st.execute("insert into pchartab values ('')");
        st.execute("select * from pchartab where tsn=''");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals(""));
        st.execute("select * from pchartab where tsn>'2013' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2015"));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2017"));
        st.execute("select * from pchartab where tsn<'2014' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals(""));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2013"));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).trim().equals("2013"));
        st.execute("create table pvarchartab (tsn varchar(10)) partition by column(tsn)");
        st.execute("insert into pvarchartab values ('2014')");
        st.execute("insert into pvarchartab values ('2014')");
        st.execute("select * from pvarchartab where tsn='2014'");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2014"));
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2014"));
        st.execute("insert into pvarchartab values ('')");
        st.execute("select * from pvarchartab where tsn=''");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)0, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals(""));
        st.execute("select * from pvarchartab where tsn>='' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)0, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals(""));
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2014"));
        rs.next();
        BugsTest.assertEquals((int)4, (int)rs.getString(1).length());
        BugsTest.assertTrue((boolean)rs.getString(1).equals("2014"));
        byte[] expectedBytes = new byte[]{65, 66, 67, 32, 32, 32, 32, 32, 32, 32};
        byte[] spaceBytes = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
        byte[] varcharBytes = new byte[]{65, 66, 67};
        st.execute("create table charfbd (tsn char(10) for bit data)");
        st.execute("insert into charfbd values (x'414243')");
        st.execute("insert into charfbd values (x'414244')");
        st.execute("select * from charfbd where tsn=x'414243'");
        rs = st.getResultSet();
        rs.next();
        rs.getBytes(1);
        BugsTest.assertEquals((int)10, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(expectedBytes, rs.getBytes(1)));
        st.execute("insert into charfbd values (x'')");
        st.execute("select * from charfbd where tsn=x''");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(spaceBytes, rs.getBytes(1)));
        st.execute("select * from charfbd where tsn>x'41' and tsn<x'414245' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(expectedBytes, rs.getBytes(1)));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getBytes(1).length);
        byte[] expected = new byte[]{65, 66, 68, 32, 32, 32, 32, 32, 32, 32};
        BugsTest.assertTrue((boolean)Arrays.equals(expected, rs.getBytes(1)));
        st.execute("create table pcharfbd (tsn char(10) for bit data) partition by column(tsn);");
        st.execute("insert into pcharfbd values (x'414243')");
        st.execute("insert into pcharfbd values (x'414244')");
        st.execute("select * from pcharfbd where tsn=x'414243'");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(expectedBytes, rs.getBytes(1)));
        st.execute("insert into pcharfbd values (x'')");
        st.execute("select * from pcharfbd where tsn=x''");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(spaceBytes, rs.getBytes(1)));
        st.execute("select * from pcharfbd where tsn>x'41' and tsn<x'414245' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(expectedBytes, rs.getBytes(1)));
        rs.next();
        BugsTest.assertEquals((int)10, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(expected, rs.getBytes(1)));
        st.execute("create table varcharfbd (tsn varchar(10) for bit data)");
        st.execute("insert into varcharfbd values (x'414243')");
        st.execute("insert into varcharfbd values (x'414244')");
        st.execute("select * from varcharfbd where tsn=x'414243'");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(varcharBytes, rs.getBytes(1)));
        st.execute("insert into varcharfbd values (x'')");
        st.execute("select * from varcharfbd where tsn=x''");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)0, (int)rs.getBytes(1).length);
        st.execute("select * from varcharfbd where tsn>x'41' and tsn<x'414245' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(varcharBytes, rs.getBytes(1)));
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
        byte[] expectedVarchar = new byte[]{65, 66, 68};
        BugsTest.assertTrue((boolean)Arrays.equals(expectedVarchar, rs.getBytes(1)));
        st.execute("create table pvarcharfbd (tsn varchar(10) for bit data) partition by column(tsn);");
        st.execute("insert into pvarcharfbd values (x'414243')");
        st.execute("insert into pvarcharfbd values (x'414244')");
        st.execute("select * from pvarcharfbd where tsn=x'414243'");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(varcharBytes, rs.getBytes(1)));
        st.execute("insert into pvarcharfbd values (x'')");
        st.execute("select * from pvarcharfbd where tsn=x''");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)0, (int)rs.getBytes(1).length);
        st.execute("select * from varcharfbd where tsn>x'41' and tsn<x'414245' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(varcharBytes, rs.getBytes(1)));
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(expectedVarchar, rs.getBytes(1)));
        st.execute("select * from varcharfbd where tsn<x'414245' order by tsn");
        rs = st.getResultSet();
        rs.next();
        BugsTest.assertEquals((int)0, (int)rs.getBytes(1).length);
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(varcharBytes, rs.getBytes(1)));
        rs.next();
        BugsTest.assertEquals((int)3, (int)rs.getBytes(1).length);
        BugsTest.assertTrue((boolean)Arrays.equals(expectedVarchar, rs.getBytes(1)));
    }

    public void test_08_triggerDependencies() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t_08_a( a int )");
        s.execute("create table t_08_b( a int )");
        byte[] jarBytes = GfxdJarInstallationTest.getJarBytes(GfxdJarInstallationTest.pricejar);
        String sql = "call sqlj.install_jar_bytes(?, ?)";
        PreparedStatement ps = conn.prepareStatement(sql);
        ps.setBytes(1, jarBytes);
        ps.setString(2, "APP.udtjar");
        ps.executeUpdate();
        String createTypeStatement = "create type price_08_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java";
        String dropTypeStatement = "drop type price_08_a restrict\n";
        String createObjectStatement = "create trigger trig_08_a after insert on t_08_a\n for each row   insert into t_08_b( a ) select ( a ) from t_08_a where ( cast( null as price_08_a ) ) is not null\n";
        String dropObjectStatement = "drop trigger trig_08_a";
        String badDropSQLState = TRIGGER_DEPENDS_ON_TYPE;
        s.execute(createTypeStatement);
        s.execute(createObjectStatement);
        try {
            s.execute(dropTypeStatement);
            BugsTest.fail("expected DROP TYPE to fail with X0Y24");
        }
        catch (SQLException ex) {
            BugsTest.assertTrue((boolean)badDropSQLState.equalsIgnoreCase(TRIGGER_DEPENDS_ON_TYPE));
        }
        s.execute(dropObjectStatement);
        s.execute(dropTypeStatement);
    }

    public void testTriggerSetXML() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1(c1 int primary key, x int not null)");
        s.execute("create table t2(c1 int primary key, x int not null)");
        try {
            s.execute("create trigger tr2 after insert on t1 for each row mode db2sql update t1 set x = 'hmm'");
            BugsTest.fail("The test should have failed");
        }
        catch (SQLException ex) {
            System.out.println(ex.getSQLState());
        }
        try {
            s.executeUpdate("create trigger tr1 after insert on t1 for each row mode db2sql update t1 set x = null");
            BugsTest.fail("should not have succeeded as the table and the target table are same");
        }
        catch (SQLException ex) {
            BugsTest.assertTrue((boolean)ex.getSQLState().equalsIgnoreCase("0A000"));
        }
        s.executeUpdate("create trigger tr1 after insert on t1 for each row mode db2sql update t2 set x = null");
        s.close();
    }

    public void testBug45664() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("create table z (col1 integer) replicate partition by column(col1)");
            BugsTest.fail("the above create should have failed");
        }
        catch (SQLException ex) {
            BugsTest.assertTrue((boolean)ex.getSQLState().equalsIgnoreCase("X0Y90"));
        }
    }

    public void testBug42613() throws Exception {
        Properties prop = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        prop.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(prop);
        Statement s = conn.createStatement();
        s.execute("create table portfolio (cid int, sid int, tid int)");
        s.execute("insert into portfolio values (11, 12, 77)");
        s.execute("insert into portfolio values (22, 12, 77)");
        s.execute("insert into portfolio values (33, 34, 77)");
        s.execute("insert into portfolio values (44, 34, 77)");
        s.execute("insert into portfolio values (55, 56, 88)");
        s.execute("create table customers (cid int, sid int, tid int)");
        s.execute("insert into customers values (66, 67, 99)");
        s.execute("insert into customers values (16, 17, 77)");
        s.execute("insert into customers values (38, 40, 77)");
        java.sql.ResultSet rs = s.executeQuery("select * from customers where tid = 77 and cid IN (select avg(cid) from portfolio where tid = 77 and sid > 0 group by sid )");
        while (rs.next()) {
            System.out.println(rs.getInt(1) + "\t" + rs.getInt(2) + "\t" + rs.getInt(3));
        }
        String query = "select * from customers where tid = ? and cid IN (select avg(cid) from portfolio where tid = ? and sid > ? group by sid )";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 77);
        ps.setInt(2, 77);
        ps.setInt(3, 0);
        rs = ps.executeQuery();
        while (rs.next()) {
            System.out.println(rs.getInt(1) + "\t" + rs.getInt(2) + "\t" + rs.getInt(3));
        }
    }

    public void testDataMissing() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        String ddl = "create table customer ( c_id int not null,c_d_id int not null,c_w_id smallint not null,c_first varchar(16),c_middle char(2),c_last varchar(16),c_street_1 varchar(20),c_street_2 varchar(20),c_city varchar(20),c_state char(2),c_zip char(9),c_phone char(16),c_since timestamp,c_credit char(2),c_credit_lim bigint,c_discount decimal(4,2),c_balance decimal(12,2),c_ytd_payment decimal(12,2),c_payment_cnt smallint,c_delivery_cnt smallint,c_data clob(4096),PRIMARY KEY(c_w_id, c_d_id, c_id) ) replicate";
        stmt.execute(ddl);
        String dml = "INSERT INTO customer (c_id, c_d_id, c_w_id, c_first, c_middle, c_last, c_street_1, c_street_2, c_city, c_state, c_zip, c_phone, c_since, c_credit, c_credit_lim, c_discount, c_balance, c_ytd_payment, c_payment_cnt, c_delivery_cnt, c_data) VALUES (641,1,14,'V5RLQ5YkhxfpzZ','OE','ANTIPRESBAR','kpajbLlJYM0UWeYQ8drT','uzmauRNuyocoMMNf5','DPegtHEJPq9qs1pebj3','b0','424455309','8159960776939583','2012-05-01 15:15:52','GC',50000,0.18,-10.00,10.00,1,0,'9bCvhi2QHqLFHw4wkD3LUxpnhug61V6A6J3l16CHuXW9Sb6Co9XG4K2jFgpEBwPGDQzCUBTPhyY9XcJLjqZo9bXMHLaRFxfSOeesq6FV4mcbOvu8lTus3PEKkpjzkOP832zr8CMCyynLtfTc8LT9khUTUBQDaqLbsISyVmARivmZaD9gYcqHIIikR6x1wHcmZ2k2osSUlE3LSD0ynoD54vqV2nVw27ha8PcuI4P3HQNhbLfP9rUBmIgm4Bh6HOgNlHH1Je3a5QHgjv3smY1WohHsryx8KdV3sk5CP8kSY06FvA5fg6BSnQLcOIk')";
        stmt.execute(dml);
        stmt.execute("select c_first, c_last, c_w_id  from customer where c_id = 641 and c_d_id = 1 and c_w_id = 14");
        java.sql.ResultSet rs = stmt.getResultSet();
        int cnt = 0;
        while (rs.next()) {
            ++cnt;
        }
        BugsTest.assertEquals((int)1, (int)cnt);
    }

    public void testBug44613() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement s = conn.createStatement();
        s.execute("create schema trade");
        s.execute("create table trade.portfolio (cid int not null, sid int not null, tid int)");
        s.execute("create table trade.networth (cid int not null, securities int, tid int, constraint netw_pk primary key (cid))partition by range (securities)  ( VALUES BETWEEN 1 AND 30, VALUES BETWEEN 40 AND 60, VALUES BETWEEN 70 AND 100)");
        PreparedStatement ps1 = conn.prepareStatement("insert into trade.portfolio values (?, ?, ?)");
        for (int i = 1; i < 10; ++i) {
            ps1.setInt(1, i * 11);
            ps1.setInt(2, i * 11 + 1);
            ps1.setInt(3, i * 11 + 2);
            ps1.executeUpdate();
        }
        PreparedStatement ps2 = conn.prepareStatement("insert into trade.networth values (?, ?, ?)");
        for (int i = 1; i < 10; ++i) {
            ps2.setInt(1, i * 11);
            ps2.setInt(2, i * 11 + 1);
            ps2.setInt(3, i * 11 + 2);
            ps2.executeUpdate();
        }
        PreparedStatement ps4 = conn.prepareStatement("select cid from trade.networth n where tid = ? and n.cid IN (select cid from trade.portfolio where tid =? and sid >? and sid < ? )");
        ps4.setInt(1, 46);
        ps4.setInt(2, 46);
        ps4.setInt(3, 33);
        ps4.setInt(4, 77);
        java.sql.ResultSet rs4 = ps4.executeQuery();
        while (rs4.next()) {
            System.out.println(rs4.getInt(1));
        }
    }

    public void testRecursiveTriggersDisallowed() throws SQLException {
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table flights(flight_id int not null, segment_number int not null, aircraft varchar(20) not null) replicate");
        stmt.execute("create table flights_history(flight_id int not null, aircraft varchar(20) not null, status varchar(50) not null)");
        String triggerStmnt = "CREATE TRIGGER trig1 AFTER INSERT ON flights REFERENCING NEW AS NEWROW FOR EACH ROW MODE DB2SQL INSERT INTO flights_history VALUES (NEWROW.FLIGHT_ID, NEWROW.AIRCRAFT, 'INSERTED FROM trig1')";
        stmt.execute(triggerStmnt);
        triggerStmnt = "CREATE TRIGGER trig2 AFTER UPDATE ON flights_history REFERENCING NEW AS NEWROW FOR EACH ROW MODE DB2SQL DELETE FROM flights where segment_number = NEWROW.flight_id";
        try {
            stmt.execute(triggerStmnt);
            BugsTest.fail("recursive trigger declaration should fail");
        }
        catch (SQLException ex) {
            BugsTest.assertTrue((boolean)ex.getSQLState().equalsIgnoreCase("0A000"));
        }
    }

    public void testBug44678() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement stmnt = conn.createStatement();
        stmnt.execute("create schema trade");
        stmnt.execute("create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, ask decimal (30, 20), order_time timestamp, status varchar(10) default 'open', tid int, constraint status_ch check (status in ('cancelled', 'open', 'filled')))");
        stmnt.execute("create table trade.sellordersdup as select * from trade.sellorders with no data");
    }

    public void testForumBugFromPgibb_RR_PR() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement stmnt = conn.createStatement();
        stmnt.execute("create table Customers(CustomerId integer not null generated always as identity, CustomerCode varchar(8) not null, constraint PKCustomers primary key (CustomerId), constraint UQCustomers unique (CustomerCode))  replicate");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC1')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC2')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC3')");
        stmnt.execute("insert into Customers (CustomerCode) values ('CC4')");
        stmnt.execute("create table Devices(DeviceId integer not null generated always as identity, CustomerId integer not null, MACAddress varchar(12) not null, constraint PKDevices primary key (DeviceId), constraint UQDevices unique (CustomerId, MACAddress), constraint FKDevicesCustomers foreign key (CustomerId) references Customers (CustomerId)) partition by column (CustomerId) redundancy 1");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (1, '000000000001')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (1, '000000000002')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (2, '000000000001')");
        stmnt.execute("insert into Devices (CustomerId, MACAddress) values (2, '000000000002')");
        String[] queries = new String[]{"select c.CustomerCode, count(d.DeviceId) from Customers c left outer join Devices d on c.CustomerId = d.CustomerId group by c.CustomerCode", "select c.*, d.DeviceId from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by c.CustomerId", "select c.*, d.DeviceId from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by d.DeviceId", "select c.*, d.MACAddress from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by c.CustomerId", "select c.*, d.MACAddress from Customers c left outer join Devices d on c.CustomerId = d.CustomerId order by d.DeviceId"};
        int[] numRows = new int[]{4, 6, 6, 6, 6};
        for (int i = 0; i < queries.length; ++i) {
            System.out.println("executing query(" + i + "): " + queries[i]);
            stmnt.execute(queries[i]);
            java.sql.ResultSet rs = stmnt.getResultSet();
            int numcols = rs.getMetaData().getColumnCount();
            System.out.println("--------------------------------------");
            int cnt = 0;
            while (rs.next()) {
                ++cnt;
                String result = "";
                for (int j = 0; j < numcols; ++j) {
                    result = j == numcols - 1 ? result + rs.getObject(j + 1) : result + rs.getObject(j + 1) + ", ";
                }
                System.out.println(result);
            }
            BugsTest.assertEquals((int)numRows[i], (int)cnt);
            System.out.println("--------------------------------------\n\n");
        }
    }

    public void testMultipleInsert() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null)");
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data");
        int actual = s.executeUpdate("insert into backup select * from account");
        BugsTest.assertEquals((int)4, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null) replicate");
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate");
        actual = s.executeUpdate("insert into backup select * from account");
        BugsTest.assertEquals((int)4, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null) replicate");
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data");
        actual = s.executeUpdate("insert into backup select * from account");
        BugsTest.assertEquals((int)4, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null)");
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data replicate");
        actual = s.executeUpdate("insert into backup select * from account");
        BugsTest.assertEquals((int)4, (int)actual);
        s.execute("drop table account");
        s.execute("drop table backup");
    }

    public void testMultipleInsertWithWhereClause() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance int not null) partition by range(balance) (values between 100 and 350, values between 350 and 450)");
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data");
        int actual = s.executeUpdate("insert into backup select * from account where balance >= 100 and balance <= 300");
        BugsTest.assertEquals((int)3, (int)actual);
    }

    public void testMultipleInsert_prepStmnt() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table account (id int not null primary key, name varchar(20) not null, addr varchar(20) not null, balance2 int not null)");
        s.execute("insert into account values (1, 'name1', 'addr1', 100), (2, 'name2', 'addr2', 200),(3, 'name3', 'addr3', 300), (4, 'name4', 'addr4', 400) ");
        s.execute("create table backup as select * from account with no data");
        PreparedStatement ps = conn.prepareStatement("insert into backup select * from account where id > ?");
        ps.setInt(1, 0);
        int actual = ps.executeUpdate();
        BugsTest.assertEquals((int)4, (int)actual);
    }

    public static void retrieveDynamicResults(int arg, java.sql.ResultSet[] rs1, java.sql.ResultSet[] rs2, ProcedureExecutionContext ctx) {
        Connection conn = ctx.getConnection();
        try {
            PreparedStatement ps1 = conn.prepareStatement("<local> select * from t1 where balance2 > ?");
            ps1.setInt(1, arg);
            rs1[0] = ps1.executeQuery();
            PreparedStatement ps2 = conn.prepareStatement("<local> select * from t2 where balance2 > ?");
            ps2.setInt(1, arg);
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new ReprepareObserver());
            rs2[0] = ps2.executeQuery();
        }
        catch (SQLException e) {
            System.out.println("KN: got exception: " + e);
        }
    }

    public void testDAPNPE() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (balance int not null, balance2 int not null)");
        s.execute("create table t2 (balance int not null, balance2 int not null)");
        s.execute("create index idx on t1(balance2)");
        s.execute("create index idx2 on t2(balance2)");
        s.execute("insert into t1 values(1, 2), (3, 4)");
        s.execute("insert into t2 values(1, 2), (3, 4)");
        s.execute(proc);
        CallableStatement cs = conn.prepareCall("call RETRIEVE_DYNAMIC_RESULTS(?) ON TABLE t1");
        cs.setInt(1, 0);
        cs.execute();
        do {
            java.sql.ResultSet rs = cs.getResultSet();
            while (rs.next()) {
            }
        } while (cs.getMoreResults());
    }

    public void testDAPNPE2() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (balance int not null, balance2 int not null)");
        s.execute("create table t2 (balance int not null, balance2 int not null)");
        s.execute("create index idx on t1(balance2)");
        s.execute("create index idx2 on t2(balance2)");
        s.execute("insert into t1 values(1, 2), (3, 4)");
        s.execute("insert into t2 values(1, 2), (3, 4)");
        ReprepareObserver rpos = new ReprepareObserver();
        try {
            Connection conn_nest = ((EmbedConnection)conn).getLocalDriver().getNewNestedConnection((EmbedConnection)conn);
            PreparedStatement ps1 = conn_nest.prepareStatement("select * from t1 where balance2 > ?");
            ps1.setInt(1, 0);
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)rpos);
            java.sql.ResultSet rs1 = ps1.executeQuery();
            while (rs1.next()) {
                System.out.println(rs1.getInt(1) + " : " + rs1.getInt(2));
            }
        }
        catch (SQLException e) {
            System.out.println("KN: got exception: " + e);
            throw e;
        }
    }

    public void testExecBatchFromNetClient() throws Exception {
        BugsTest.setupConnection();
        Connection conn = BugsTest.startNetserverAndGetLocalNetConnection();
        Statement s = conn.createStatement();
        s.execute("create schema emp");
        s.execute("create table emp.EMPLOYEE(lastname varchar(30) primary key, depId int) partition by (depId)");
        PreparedStatement pstmnt = conn.prepareStatement("INSERT INTO emp.employee VALUES (?, ?)");
        pstmnt.setString(1, "Jones");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        pstmnt.setString(1, "Rafferty");
        pstmnt.setInt(2, 31);
        pstmnt.addBatch();
        pstmnt.setString(1, "Robinson");
        pstmnt.setInt(2, 34);
        pstmnt.addBatch();
        pstmnt.setString(1, "Steinberg");
        pstmnt.setInt(2, 33);
        pstmnt.addBatch();
        pstmnt.setString(1, "Smith");
        pstmnt.setInt(2, 34);
        pstmnt.addBatch();
        pstmnt.setString(1, "John");
        pstmnt.setNull(2, 4);
        pstmnt.addBatch();
        pstmnt.executeBatch();
    }

    public void testDecimalPrecision_43290() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (balance decimal(12,2))");
        s.execute("insert into t1 values(0.0)");
        PreparedStatement ps = conn.prepareStatement("update t1 set balance = ?");
        ps.setFloat(1, 5559.09f);
        ps.executeUpdate();
        PreparedStatement ps2 = conn.prepareStatement("update t1 set balance = balance + ?");
        ps2.setFloat(1, 1596.15f);
        ps2.executeUpdate();
        java.sql.ResultSet rs = null;
        s.execute("select balance from t1");
        rs = s.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        boolean notequal = false;
        if (!rs.getString(1).equalsIgnoreCase("7155.24")) {
            notequal = true;
        }
        BugsTest.assertTrue((boolean)notequal);
        s.execute("delete from t1");
        s.execute("insert into t1 values(0.0)");
        ps2 = conn.prepareStatement("update t1 set balance = balance + ?");
        ps2.setString(1, "5559.09");
        ps2.executeUpdate();
        ps2 = conn.prepareStatement("update t1 set balance = balance + ?");
        ps2.setString(1, "1596.15");
        ps2.executeUpdate();
        s.execute("select balance from t1");
        rs = s.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"7155.24", (String)rs.getString(1));
    }

    public void testBug_40504_updateCase() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table t1 (col1 int, col2 int not null, col3 varchar(20) not null)");
        s.execute("insert into t1 values(1, 1, 'one'), (2, 2, 'two'), (3, 3, 'three'), (4, 4, 'four')");
        PreparedStatement ps = conn.prepareStatement("update t1 set col1 = ?, col2 = ?, col3 = ? where col1 = 1");
        ps.setInt(2, 2);
        ps.setString(3, "modified");
        try {
            ps.executeUpdate();
            BugsTest.fail("should not proceed");
        }
        catch (SQLException e) {
            BugsTest.assertTrue((boolean)"07000".equalsIgnoreCase(e.getSQLState()));
        }
    }

    public void testBug_40504_procedureCase() throws Exception {
        String showGfxdPortfolio = "create procedure trade.showGfxdPortfolio(IN DP1 Integer, IN DP2 Integer, IN DP3 Integer, IN DP4 Integer, OUT DP5 Integer) PARAMETER STYLE JAVA LANGUAGE JAVA READS SQL DATA DYNAMIC RESULT SETS 3 EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.Procedure2Test.selectInAsWellASOut'";
        Connection conn = TestUtil.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table trade.portfolio (cid int not null, tid int not null)");
        s.execute(showGfxdPortfolio);
        CallableStatement cs = conn.prepareCall(" call trade.showGfxdPortfolio(?, ?, ?, ?, ?) ON Table trade.portfolio where cid > 258 and cid< 1113 and tid=2");
        cs.setInt(1, 1);
        cs.setInt(2, 2);
        cs.setInt(4, 4);
        cs.registerOutParameter(5, 4);
        try {
            cs.execute();
        }
        catch (SQLException e) {
            BugsTest.assertTrue((boolean)"07000".equalsIgnoreCase(e.getSQLState()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUseCase8Ticket_6024_1() throws Exception {
        Statement stmt = null;
        Connection conn = null;
        BugsTest.setupConnection();
        try {
            conn = TestUtil.startNetserverAndGetLocalNetConnection();
            stmt = conn.createStatement();
            stmt.execute(" create table sample (id varchar(16) primary key, num integer ) ");
            stmt.execute("CREATE PROCEDURE PROC( IN account varchar(8) )MODIFIES SQL DATA  DYNAMIC RESULT SETS 1  PARAMETER STYLE JAVA  LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.BugsTest.proc'");
            stmt.execute("insert into sample values('a', 1)");
            stmt.execute("insert into sample values('b', 2)");
            stmt.execute("insert into sample values('c', 3)");
            CallableStatement cs = conn.prepareCall("call PROC(?)");
            cs.setString(1, "b");
            cs.execute();
            java.sql.ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugsTest.fail("Test failed because of exception " + e);
        }
        finally {
            if (conn != null) {
                TestUtil.stopNetServer();
            }
        }
    }

    public void testUseCase8Ticket_6024_2() {
        Statement stmt = null;
        Connection conn = null;
        try {
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute(" create table sample (id varchar(16) primary key, num integer ) ");
            stmt.execute("CREATE PROCEDURE PROC( IN account varchar(8) )MODIFIES SQL DATA  DYNAMIC RESULT SETS 1  PARAMETER STYLE JAVA  LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.BugsTest.proc'");
            stmt.execute("insert into sample values('a', 1)");
            stmt.execute("insert into sample values('b', 2)");
            stmt.execute("insert into sample values('c', 3)");
            CallableStatement cs = conn.prepareCall("call PROC(?)");
            cs.setString(1, "b");
            cs.execute();
            java.sql.ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugsTest.fail("Test failed because of exception " + e);
        }
    }

    public static void proc(String param1, java.sql.ResultSet[] outResults) throws SQLException {
        java.sql.ResultSet rs;
        String queryString = "<local>SELECT * FROM SAMPLE WHERE id = ?";
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        PreparedStatement ps = conn.prepareStatement(queryString);
        ps.setString(1, param1);
        outResults[0] = rs = ps.executeQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testBug41272() throws SQLException {
        int i;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        java.sql.ResultSet rs = null;
        Connection conn = null;
        try {
            conn = BugsTest.getConnection();
            s = conn.createStatement();
            statements.add(s);
            s.execute(" create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))");
            s.execute(" create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
            s.execute(" create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references trade.securities (sec_id), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))");
            s.execute(" create table trade.sellorders (oid int not null constraint orders_pk primary key, cid int, sid int, qty int, tid int, constraint portf_fk foreign key (cid, sid) references trade.portfolio (cid, sid) on delete restrict )");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            statements.add(psInsert4);
            for (i = -2; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, "lse");
                psInsert4.setInt(5, 2);
                BugsTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            PreparedStatement psInsert1 = conn.prepareStatement("insert into trade.customers values (?, ?,?,?,?)");
            statements.add(psInsert1);
            for (i = 1; i < 2; ++i) {
                psInsert1.setInt(1, i);
                psInsert1.setString(2, "name" + i);
                psInsert1.setDate(3, new Date(2004, 12, 1));
                psInsert1.setString(4, "address" + i);
                psInsert1.setInt(5, 2);
                BugsTest.assertEquals((int)1, (int)psInsert1.executeUpdate());
            }
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.portfolio values (?, ?,?,?,?,?)");
            statements.add(psInsert2);
            for (i = 1; i < 2; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(3, i + 10000);
                psInsert2.setInt(4, i + 1000);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setInt(6, 2);
                for (int j = -2; j < 0; ++j) {
                    psInsert2.setInt(2, j);
                    BugsTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
                }
            }
            PreparedStatement psInsert3 = conn.prepareStatement("insert into trade.sellorders values (?, ?,?,?,?)");
            statements.add(psInsert3);
            int j = -1;
            for (int i2 = 1; i2 < 2; ++i2) {
                psInsert3.setInt(1, i2);
                psInsert3.setInt(2, i2);
                psInsert3.setInt(3, j--);
                if (j == -3) {
                    j = -1;
                }
                psInsert3.setInt(4, i2 + 100);
                psInsert3.setInt(5, 2);
                BugsTest.assertEquals((int)1, (int)psInsert3.executeUpdate());
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                    if (gfContainer.getRegion().getName().toLowerCase().indexOf("customer") != -1) {
                        return 200.0;
                    }
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    if (memIndex.getBaseContainer().getRegion().getName().toLowerCase().indexOf("portfolio") != -1) {
                        if (memIndex.getGemFireContainer().getQualifiedTableName().toLowerCase().indexOf("__portfolio__cid:") != -1) {
                            return 200.0;
                        }
                    } else if (memIndex.getBaseContainer().getRegion().getName().toLowerCase().indexOf("sellorders") != -1) {
                        return 10.0;
                    }
                    return Double.MAX_VALUE;
                }
            });
            rs = s.executeQuery(" select c.cid, f.sid,so.sid from trade.customers c, trade.portfolio f, trade.sellorders so where c.cid = f.cid and c.cid = so.cid and f.tid = so.tid and c.tid=2 order by f.sid desc");
            ResultSetMetaData rsmd = rs.getMetaData();
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((int)1, (int)((Integer)rs.getObject(rsmd.getColumnName(1))));
            int f_sid = (Integer)rs.getObject(rsmd.getColumnName(2));
            int so_sid = (Integer)rs.getObject(rsmd.getColumnName(2));
            BugsTest.assertEquals((int)so_sid, (int)f_sid);
            BugsTest.assertEquals((int)f_sid, (int)-1);
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((int)1, (int)((Integer)rs.getObject(rsmd.getColumnName(1))));
            f_sid = (Integer)rs.getObject(rsmd.getColumnName(2));
            so_sid = (Integer)rs.getObject(rsmd.getColumnName(2));
            BugsTest.assertTrue((so_sid != f_sid ? 1 : 0) != 0);
            BugsTest.assertEquals((int)f_sid, (int)-2);
            BugsTest.assertEquals((int)so_sid, (int)-1);
            conn.commit();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            if (conn != null) {
                conn.close();
                conn = null;
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    public void testBug41262() throws Exception {
        final Connection conn = BugsTest.getConnection();
        DatabaseMetaData metadata = conn.getMetaData();
        java.sql.ResultSet rs = metadata.getTypeInfo();
        BugsTest.assertTrue((boolean)rs.next());
        while (rs.next()) {
        }
        Runnable run2 = new Runnable(){

            @Override
            public void run() {
                try {
                    Statement stmt = conn.createStatement();
                    stmt.execute("create table ctstable1 (TYPE_ID int, TYPE_DESC varchar(32) ,primary key(TYPE_ID))");
                    stmt.execute("create table ctstable2 (KEY_ID int, COF_NAME varchar(32), PRICE float, TYPE_ID int, primary key(KEY_ID), foreign key(TYPE_ID) references ctstable1)");
                }
                catch (Exception ex) {
                    BugsTest.this.exceptionOccured = true;
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)ex);
                }
            }
        };
        Thread thr = new Thread(run2);
        thr.start();
        thr.join();
        BugsTest.assertFalse((boolean)this.exceptionOccured);
        rs = metadata.getSchemas();
        BugsTest.assertTrue((boolean)rs.next());
        while (rs.next()) {
        }
        run2 = new Runnable(){

            @Override
            public void run() {
                try {
                    Statement stmt = conn.createStatement();
                    stmt.execute("Insert into ctstable1 values(1,'addr')");
                }
                catch (Exception ex) {
                    BugsTest.this.exceptionOccured = true;
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)ex);
                }
            }
        };
        thr = new Thread(run2);
        thr.start();
        thr.join();
        BugsTest.assertFalse((boolean)this.exceptionOccured);
        rs = metadata.getTableTypes();
        BugsTest.assertTrue((boolean)rs.next());
        while (rs.next()) {
        }
        run2 = new Runnable(){

            @Override
            public void run() {
                try {
                    Statement stmt = conn.createStatement();
                    TestCase.assertEquals((int)1, (int)stmt.executeUpdate("update ctstable1 set type_desc ='addr1' where type_id =1"));
                }
                catch (Exception ex) {
                    BugsTest.this.exceptionOccured = true;
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)ex);
                }
            }
        };
        thr = new Thread(run2);
        thr.start();
        thr.join();
        BugsTest.assertFalse((boolean)this.exceptionOccured);
        rs = metadata.getPrimaryKeys(null, null, "CTSTABLE1");
        BugsTest.assertTrue((boolean)rs.next());
        while (rs.next()) {
        }
        run2 = new Runnable(){

            @Override
            public void run() {
                try {
                    PreparedStatement ps = conn.prepareStatement("select * from ctstable1 where type_id = ?");
                    ps.setInt(1, 1);
                    java.sql.ResultSet rs1 = ps.executeQuery();
                    TestCase.assertTrue((boolean)rs1.next());
                    TestCase.assertFalse((boolean)rs1.next());
                }
                catch (Exception ex) {
                    BugsTest.this.exceptionOccured = true;
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)ex);
                }
            }
        };
        thr = new Thread(run2);
        thr.start();
        thr.join();
        BugsTest.assertFalse((boolean)this.exceptionOccured);
        rs = metadata.getPrimaryKeys(null, null, "CTSTABLE1");
        BugsTest.assertTrue((boolean)rs.next());
        while (rs.next()) {
        }
        run2 = new Runnable(){

            @Override
            public void run() {
                try {
                    Statement stmt = conn.createStatement();
                    try {
                        stmt.execute("create table ctstable3 (TYPE_ID int, TYPE_ID varchar(32) ,primary key(TYPE_ID))");
                        throw new AssertionError((Object)"table creation should  have failed");
                    }
                    catch (SQLException sQLException) {
                        stmt.execute("create table ctstable3 (KEY_ID int, COF_NAME varchar(32), PRICE float, TYPE_ID int, primary key(KEY_ID), foreign key(TYPE_ID) references ctstable1)");
                    }
                }
                catch (Throwable ex) {
                    BugsTest.this.exceptionOccured = true;
                    throw GemFireXDRuntimeException.newRuntimeException(null, (Throwable)ex);
                }
            }
        };
        thr = new Thread(run2);
        thr.start();
        thr.join();
        BugsTest.assertFalse((boolean)this.exceptionOccured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41642() throws Exception {
        Statement stmt = null;
        Connection conn = null;
        Statement derbyStmt = null;
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute(" create table derby_sample (id varchar(16) primary key, num integer ) ");
            Statement derbyStmt1 = derbyConn.createStatement();
            derbyStmt1.executeUpdate("insert into derby_sample values('asif',1)");
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute(" create table sample (id varchar(16) primary key, num integer ) ");
            stmt.execute("CREATE PROCEDURE PROC1( IN account varchar(8) )MODIFIES SQL DATA  DYNAMIC RESULT SETS 1  PARAMETER STYLE JAVA  LANGUAGE JAVA EXTERNAL NAME 'com.pivotal.gemfirexd.jdbc.BugsTest.proc1'");
            stmt.execute("insert into sample values('a', 1)");
            stmt.execute("insert into sample values('b', 2)");
            stmt.execute("insert into sample values('c', 3)");
            CallableStatement cs = conn.prepareCall("call PROC1(?)");
            cs.setString(1, "b");
            cs.execute();
            java.sql.ResultSet rs = cs.getResultSet();
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugsTest.fail("Test failed because of exception " + e);
        }
        finally {
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table derby_sample");
                }
                catch (Exception exception) {}
                try {
                    derbyStmt.execute("drop procedure PROC1");
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForDeleteEvent(boolean[] ok) throws InterruptedException {
        BugsTest bugsTest = this;
        synchronized (bugsTest) {
            for (int maxWait = 60000; !ok[0] && maxWait > 0; maxWait -= 100) {
                ((Object)((Object)this)).wait(100L);
            }
            if (!ok[0]) {
                BugsTest.fail("failed to get AFTER_DELETE event");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41027() throws Exception {
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Properties props = new Properties();
        props.setProperty("server-groups", "SG1");
        Connection conn = null;
        String derbyDbUrl = "jdbc:derby:newDB;create=true;";
        conn = BugsTest.getConnection(props);
        final int isolation = conn.getTransactionIsolation();
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        s = conn.createStatement();
        try {
            int i;
            String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))";
            String tab2 = " create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))";
            String tab3 = " create table trade.buyorders(oid int not null constraint buyorders_pk primary key, cid int, sid int, qty int, bid decimal (30, 20), ordertime timestamp, status varchar(10), tid int, constraint bo_cust_fk foreign key (cid) references trade.customers (cid), constraint bo_sec_fk foreign key (sid) references trade.securities (sec_id) on delete restrict, constraint bo_qty_ck check (qty>=0))  ";
            if (currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
            }
            derbyStmt.execute(tab1);
            derbyStmt.execute(tab2);
            derbyStmt.execute(tab3);
            JdbcTestBase.addAsyncEventListener("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", new Integer(2), null, null, null, null, Boolean.FALSE, Boolean.FALSE, null, "org.apache.derby.jdbc.EmbeddedDriver," + derbyDbUrl);
            JdbcTestBase.startAsyncEventListener("WBCL1");
            String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            s.execute(tab1 + "AsyncEventListener(WBCL1)");
            s.execute(tab2 + "AsyncEventListener(WBCL1)");
            s.execute(tab3 + " partition by range (bid) (VALUES BETWEEN 0.0 AND 25.0,  " + "VALUES BETWEEN 25.0  AND 35.0 , VALUES BETWEEN 35.0  AND 49.0," + " VALUES BETWEEN 49.0  AND 69.0 , VALUES BETWEEN 69.0 AND 100.0) " + "AsyncEventListener(WBCL1)");
            final boolean[] ok = new boolean[]{false};
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsModified, Statement ps, String dml) {
                    if (isolation != 0 && dml.startsWith("delete from ")) {
                        BugsTest bugsTest = BugsTest.this;
                        synchronized (bugsTest) {
                            ok[0] = true;
                            ((Object)((Object)BugsTest.this)).notify();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterPKBasedDBSynchExecution(Event.Type type, int numRowsModified, Statement ps) {
                    if (isolation == 0 && type.equals((Object)Event.Type.AFTER_DELETE)) {
                        BugsTest bugsTest = BugsTest.this;
                        synchronized (bugsTest) {
                            ok[0] = true;
                            ((Object)((Object)BugsTest.this)).notify();
                        }
                    }
                }
            });
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            for (i = -30; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i * -1);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, exchange[-1 * i % 7]);
                psInsert4.setInt(5, 2);
                BugsTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            PreparedStatement psInsert1 = conn.prepareStatement("insert into trade.customers values (?, ?,?,?,?)");
            for (i = 1; i < 30; ++i) {
                psInsert1.setInt(1, i);
                psInsert1.setString(2, "name" + i);
                psInsert1.setDate(3, new Date(2004, 12, 1));
                psInsert1.setString(4, "address" + i);
                psInsert1.setInt(5, 2);
                BugsTest.assertEquals((int)1, (int)psInsert1.executeUpdate());
            }
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.buyorders values (?, ?,?,?,?,?,?,?)");
            for (i = 1; i < 20; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, -1 * i);
                psInsert2.setInt(4, 100 * i);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setTimestamp(6, new Timestamp(System.currentTimeMillis()));
                psInsert2.setString(7, "open");
                psInsert2.setInt(8, 5);
                BugsTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            String updateStr = "update trade.buyorders set status = 'cancelled' , cid = 1 +cid  where cid >? and cid <?";
            PreparedStatement psInsert3 = conn.prepareStatement(updateStr);
            psInsert3.setInt(1, 5);
            psInsert3.setInt(2, 28);
            psInsert3.executeUpdate();
            PreparedStatement ps = conn.prepareStatement("delete from trade.buyorders where oid = 1 ");
            ps.executeUpdate();
            this.waitForDeleteEvent(ok);
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table trade.buyorders");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    derbyStmt.execute("drop table trade.customers");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    derbyStmt.execute("drop table trade.securities");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (s != null) {
                s.execute("drop table if exists trade.buyorders");
                s.execute("drop table if exists trade.customers");
                s.execute("drop table if exists trade.securities");
            }
        }
        finally {
            block20: {
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block20;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41620_1() throws Exception {
        Connection conn = null;
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            Properties info = new Properties();
            info.setProperty("server-groups", "SG1");
            conn = BugsTest.getConnection(info);
            conn = TestUtil.startNetserverAndGetLocalNetConnection();
            JdbcTestBase.addAsyncEventListenerWithConn("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", new Integer(2), null, null, null, null, null, null, null, "org.apache.derby.jdbc.EmbeddedDriver," + derbyDbUrl, conn);
            JdbcTestBase.startAsyncEventListener("WBCL1");
            AsyncEventQueueImpl queue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
            BugsTest.assertNotNull((Object)queue);
            BugsTest.assertTrue((boolean)queue.isRunning());
        }
        finally {
            block8: {
                TestUtil.stopNetServer();
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block8;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41620_2() throws Exception {
        Connection conn = null;
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            Properties info = new Properties();
            info.setProperty("server-groups", "SG1");
            conn = BugsTest.getConnection(info);
            conn = TestUtil.startNetserverAndGetLocalNetConnection();
            JdbcTestBase.addAsyncEventListenerWithConn("SG1", "WBCL1", "com.pivotal.gemfirexd.callbacks.DBSynchronizer", new Integer(2), null, Boolean.TRUE, null, null, null, null, null, "org.apache.derby.jdbc.EmbeddedDriver," + derbyDbUrl, conn);
            JdbcTestBase.startAsyncEventListener("WBCL1");
            AsyncEventQueueImpl queue = (AsyncEventQueueImpl)Misc.getGemFireCache().getAsyncEventQueue("WBCL1");
            BugsTest.assertNotNull((Object)queue);
            BugsTest.assertTrue((queue.getSender().getCancelCriterion().cancelInProgress() == null ? 1 : 0) != 0);
        }
        finally {
            block8: {
                TestUtil.stopNetServer();
                try {
                    DriverManager.getConnection("jdbc:derby:;shutdown=true");
                }
                catch (SQLException sqle) {
                    if (sqle.getMessage().indexOf("shutdown") != -1) break block8;
                    sqle.printStackTrace();
                    throw sqle;
                }
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void testDataPersistenceOfPR() throws Exception {
        Properties props = new Properties();
        this.deleteDirs = new String[]{"datadictionary", "test_dir"};
        Connection conn = TestUtil.getConnection(props);
        TestUtil.deletePersistentFiles = false;
        Statement stmt = conn.createStatement();
        stmt.execute("create schema trade");
        stmt.execute("create diskstore teststore './test_dir'");
        stmt.execute(" create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid))   partition by range (cid) ( VALUES BETWEEN 0 AND 10, VALUES BETWEEN 10 AND 20, VALUES BETWEEN 20 AND 30 )  PERSISTENT 'teststore'");
        PreparedStatement ps = conn.prepareStatement("insert into trade.customers values (?,?,?)");
        for (int i = 1; i < 31; ++i) {
            ps.setInt(1, i);
            ps.setString(2, "name" + i);
            ps.setInt(3, i);
            ps.executeUpdate();
        }
        TestUtil.shutDown();
        TestUtil.deletePersistentFiles = true;
        TestUtil.setupConnection();
        conn = TestUtil.getConnection();
        stmt = conn.createStatement();
        java.sql.ResultSet rs = stmt.executeQuery("select * from trade.customers");
        int expected = 465;
        int actual = 0;
        while (rs.next()) {
            int val = rs.getInt(1);
            actual += val;
        }
        BugsTest.assertEquals((int)expected, (int)actual);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41804() throws Exception {
        int i;
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        java.sql.ResultSet rs = null;
        Connection conn = null;
        try {
            conn = BugsTest.getConnection();
            s = conn.createStatement();
            statements.add(s);
            s.execute(" create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))");
            s.execute(" create table trade.customers (cid int not null, cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))");
            new File("persistPortf");
            s.execute("create diskstore teststore 'persistPortf'");
            s.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references trade.securities (sec_id) on delete restrict, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by column (cid, sid) PERSISTENT SYNCHRONOUS 'teststore'");
            psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?)");
            statements.add(psInsert4);
            for (i = -2; i < 0; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i);
                psInsert4.setFloat(3, 68.94f);
                psInsert4.setString(4, "lse");
                psInsert4.setInt(5, 2);
                BugsTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            PreparedStatement psInsert1 = conn.prepareStatement("insert into trade.customers values (?, ?,?,?,?)");
            statements.add(psInsert1);
            for (i = 1; i < 2; ++i) {
                psInsert1.setInt(1, i);
                psInsert1.setString(2, "name" + i);
                psInsert1.setDate(3, new Date(2004, 12, 1));
                psInsert1.setString(4, "address" + i);
                psInsert1.setInt(5, 2);
                BugsTest.assertEquals((int)1, (int)psInsert1.executeUpdate());
            }
            PreparedStatement psInsert2 = conn.prepareStatement("insert into trade.portfolio values (?, ?,?,?,?,?)");
            statements.add(psInsert2);
            for (i = 1; i < 2; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(3, i + 10000);
                psInsert2.setInt(4, i + 1000);
                psInsert2.setFloat(5, 30.4f);
                psInsert2.setInt(6, 2);
                for (int j = -2; j < 0; ++j) {
                    psInsert2.setInt(2, j);
                    BugsTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
                }
            }
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    if (memIndex.getBaseContainer().getRegion().getName().toLowerCase().indexOf("portfolio") != -1) {
                        return 0.0;
                    }
                    return Double.MAX_VALUE;
                }
            });
            rs = s.executeQuery(" SELECT *  FROM TRADE.PORTFOLIO WHERE CID > 0 AND SID >-3 AND TID = 2");
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((int)1, (int)rs.getInt(1));
            conn.commit();
        }
        finally {
            if (rs != null) {
                rs.close();
                rs = null;
            }
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            TestUtil.shutDown();
            BugsTest.deleteDir(new File("persistPortf"));
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug41926() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table numeric_family (id int primary key, type_int int)");
        s.execute("insert into numeric_family values (1, 2), (2, 4), (3, 6), (4, 8)");
        try {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                }
            });
            String query = "select id from numeric_family where id <= 4 order by id asc fetch first 1 rows only";
            s.execute(query);
        }
        finally {
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    public void testBug41936() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table numeric_family (id int primary key, type_int int)");
        String query = "select * from numeric_family where ? <> ALL (values(1))";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setInt(1, 1);
        ps.executeQuery();
    }

    public void testBug41873_1() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null, primary key(c1)) replicate");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1)");
        conn.commit();
        st.execute("update t1 set c2 =2 where c2 =1");
        st.execute("update t1 set c3 =3 where c3 =1");
        st.execute("update t1 set c4 =4 where c4 =1");
        conn.commit();
        java.sql.ResultSet rs = st.executeQuery("Select * from t1");
        rs.next();
        BugsTest.assertEquals((int)1, (int)rs.getInt(1));
        BugsTest.assertEquals((int)2, (int)rs.getInt(2));
        BugsTest.assertEquals((int)3, (int)rs.getInt(3));
        BugsTest.assertEquals((int)4, (int)rs.getInt(4));
    }

    public void testBug41873_3() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null, primary key(c1)) ");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1)");
        conn.commit();
        st.execute("update t1 set c2 =2 where c2 =1");
        st.execute("update t1 set c3 =3 where c3 =1");
        st.execute("update t1 set c4 =4 where c4 =1");
        conn.commit();
        java.sql.ResultSet rs = st.executeQuery("Select * from t1");
        rs.next();
        BugsTest.assertEquals((int)1, (int)rs.getInt(1));
        BugsTest.assertEquals((int)2, (int)rs.getInt(2));
        BugsTest.assertEquals((int)3, (int)rs.getInt(3));
        BugsTest.assertEquals((int)4, (int)rs.getInt(4));
    }

    public void testBug41873_2() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null, primary key(c1)) replicate");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1)");
        st.execute("update t1 set c2 =2 where c2 =1");
        st.execute("update t1 set c3 =3 where c3 =1");
        st.execute("update t1 set c4 =4 where c4 =1");
        conn.commit();
        java.sql.ResultSet rs = st.executeQuery("Select * from t1");
        rs.next();
        BugsTest.assertEquals((int)1, (int)rs.getInt(1));
        BugsTest.assertEquals((int)2, (int)rs.getInt(2));
        BugsTest.assertEquals((int)3, (int)rs.getInt(3));
        BugsTest.assertEquals((int)4, (int)rs.getInt(4));
    }

    public void testBug41873_4() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null, primary key(c1)) ");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1)");
        st.execute("update t1 set c2 =2 where c2 =1");
        st.execute("update t1 set c3 =3 where c3 =1");
        st.execute("update t1 set c4 =4 where c4 =1");
        conn.commit();
        java.sql.ResultSet rs = st.executeQuery("Select * from t1");
        rs.next();
        BugsTest.assertEquals((int)1, (int)rs.getInt(1));
        BugsTest.assertEquals((int)2, (int)rs.getInt(2));
        BugsTest.assertEquals((int)3, (int)rs.getInt(3));
        BugsTest.assertEquals((int)4, (int)rs.getInt(4));
    }

    public void testBug42099_1() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null, c5 int not null, primary key(c1)) ");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1,1)");
        conn.commit();
        st.execute("update t1 set c2 =2 where c2 =1");
        st.execute("update t1 set c3 =3 where c3 =1");
        st.execute("update t1 set c4 =4 where c4 =1");
        st.execute("update t1 set c5 =5 where c5 =1");
        java.sql.ResultSet rs = st.executeQuery("Select * from t1");
        this.validateForBug42099(rs, false);
        conn.commit();
    }

    public void testBug42099_2() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null, c5 int not null, primary key(c1)) ");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1,1)");
        conn.commit();
        st.execute("update t1 set c2 =2 where c2 =1");
        st.execute("update t1 set c3 =3 where c3 =1");
        st.execute("update t1 set c4 =4 where c4 =1");
        st.execute("update t1 set c5 =5 where c5 =1");
        java.sql.ResultSet rs = st.executeQuery("Select * from t1 where c1 =1");
        this.validateForBug42099(rs, false);
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42099_3() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null,c6 int not null,  primary key(c1)) ");
        st.execute("create index i1 on t1 (c6)");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1,1,1)");
        conn.commit();
        st.execute("update t1 set c2 =2 where c2 =1");
        st.execute("update t1 set c3 =3 where c3 =1");
        st.execute("update t1 set c4 =4 where c4 =1");
        st.execute("update t1 set c5 =5 where c5 =1");
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        try {
            java.sql.ResultSet rs = st.executeQuery("Select * from t1 where c6 =1");
            this.validateForBug42099(rs, false);
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42430_1() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = BugsTest.getConnection(info);
        final int isolation = conn.getTransactionIsolation();
        Statement s = conn.createStatement();
        Statement derbyStmt = null;
        final int[] numInserts = new int[]{0};
        final int[] numPKDeletes = new int[]{0};
        final int[] numBulkOp = new int[]{0};
        final boolean[] ok = new boolean[]{false};
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute("create table testtable (id int primary key, type_int int) ");
            JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.callbacks.DBSynchronizer", new Integer(10), null, null, null, null, Boolean.FALSE, Boolean.FALSE, null, "org.apache.derby.jdbc.EmbeddedDriver," + derbyDbUrl);
            JdbcTestBase.startAsyncEventListener(currentTest);
            s.execute("create table testtable (id int primary key, type_int int) AsyncEventListener (" + currentTest + ')');
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsModified, Statement ps, String dml) {
                    numBulkOp[0] = numBulkOp[0] + 1;
                    if (dml.startsWith("insert into ")) {
                        numInserts[0] = numInserts[0] + numRowsModified;
                    } else if (isolation != 0 && dml.startsWith("delete from ")) {
                        numPKDeletes[0] = numPKDeletes[0] + numRowsModified;
                        BugsTest bugsTest = BugsTest.this;
                        synchronized (bugsTest) {
                            ok[0] = true;
                            ((Object)((Object)BugsTest.this)).notify();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterPKBasedDBSynchExecution(Event.Type type, int numRowsModified, Statement ps) {
                    if (isolation == 0 && type.equals((Object)Event.Type.AFTER_DELETE)) {
                        numPKDeletes[0] = numPKDeletes[0] + numRowsModified;
                        BugsTest bugsTest = BugsTest.this;
                        synchronized (bugsTest) {
                            ((Object)((Object)BugsTest.this)).notify();
                            ok[0] = true;
                        }
                    } else if (type.equals((Object)Event.Type.AFTER_INSERT)) {
                        numInserts[0] = numInserts[0] + numRowsModified;
                    }
                }
            });
            String schema = TestUtil.getCurrentDefaultSchemaName();
            String path = Misc.getRegionPath((String)schema, (String)"TESTTABLE", null);
            LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            final boolean[] callbackExecuted = new boolean[]{false};
            rgn.getAttributesMutator().setCacheWriter((CacheWriter)new CacheWriterAdapter(){

                public void beforeCreate(EntryEvent event) throws CacheWriterException {
                    callbackExecuted[0] = true;
                    Object callbackArg = event.getCallbackArgument();
                    assert (callbackArg != null && callbackArg instanceof GfxdCallbackArgument);
                }
            });
            s.execute("insert into TESTTABLE values (1, 2), (2, 4), (3, 6), (4, 8)");
            BugsTest.assertTrue((boolean)callbackExecuted[0]);
            BugsTest.assertEquals((int)1, (int)s.executeUpdate("delete from testtable where ID = 1"));
            this.waitForDeleteEvent(ok);
            BugsTest.assertEquals((int)4, (int)numInserts[0]);
            BugsTest.assertEquals((int)1, (int)numPKDeletes[0]);
            JdbcTestBase.stopAsyncEventListener(currentTest);
            BugsTest.validateResults(derbyStmt, s, "select * from testtable", false);
        }
        finally {
            if (derbyStmt != null) {
                derbyStmt.execute("drop table TESTTABLE");
            }
            if (s != null) {
                s.execute("drop table TESTTABLE");
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42430_2() throws Exception {
        Properties info = new Properties();
        info.setProperty("server-groups", "SG1");
        Connection conn = BugsTest.getConnection(info);
        final int isolation = conn.getTransactionIsolation();
        Statement s = conn.createStatement();
        Statement derbyStmt = null;
        final int[] numInserts = new int[]{0};
        final int[] numPKDeletes = new int[]{0};
        final int[] numBulkOp = new int[]{0};
        final boolean[] ok = new boolean[]{false};
        try {
            String derbyDbUrl = "jdbc:derby:newDB;create=true;";
            if (currentUserName != null) {
                derbyDbUrl = derbyDbUrl + "user=" + currentUserName + ";password=" + currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute("create table testtable (id int primary key, type_int int) ");
            JdbcTestBase.addAsyncEventListener("SG1", currentTest, "com.pivotal.gemfirexd.callbacks.DBSynchronizer", new Integer(10), null, null, null, null, Boolean.FALSE, Boolean.FALSE, null, "org.apache.derby.jdbc.EmbeddedDriver," + derbyDbUrl);
            JdbcTestBase.startAsyncEventListener(currentTest);
            s.execute("create table testtable (id int primary key, type_int int) replicate  AsyncEventListener (" + currentTest + ')');
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterBulkOpDBSynchExecution(Event.Type type, int numRowsModified, Statement ps, String dml) {
                    numBulkOp[0] = numBulkOp[0] + 1;
                    if (dml.startsWith("insert into ")) {
                        numInserts[0] = numInserts[0] + numRowsModified;
                    } else if (isolation != 0 && dml.startsWith("delete from ")) {
                        numPKDeletes[0] = numPKDeletes[0] + numRowsModified;
                        BugsTest bugsTest = BugsTest.this;
                        synchronized (bugsTest) {
                            ok[0] = true;
                            ((Object)((Object)BugsTest.this)).notify();
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void afterPKBasedDBSynchExecution(Event.Type type, int numRowsModified, Statement ps) {
                    if (isolation == 0 && type.equals((Object)Event.Type.AFTER_DELETE)) {
                        numPKDeletes[0] = numPKDeletes[0] + numRowsModified;
                        BugsTest bugsTest = BugsTest.this;
                        synchronized (bugsTest) {
                            ok[0] = true;
                            ((Object)((Object)BugsTest.this)).notify();
                        }
                    } else if (type.equals((Object)Event.Type.AFTER_INSERT)) {
                        numInserts[0] = numInserts[0] + numRowsModified;
                    }
                }
            });
            String schema = TestUtil.getCurrentDefaultSchemaName();
            String path = Misc.getRegionPath((String)schema, (String)"TESTTABLE", null);
            LocalRegion rgn = (LocalRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            final boolean[] callbackExecuted = new boolean[]{false};
            rgn.getAttributesMutator().setCacheWriter((CacheWriter)new CacheWriterAdapter(){

                public void beforeCreate(EntryEvent event) throws CacheWriterException {
                    callbackExecuted[0] = true;
                    Object callbackArg = event.getCallbackArgument();
                    assert (callbackArg != null && callbackArg instanceof GfxdCallbackArgument) : callbackArg;
                }
            });
            s.execute("insert into TESTTABLE values (1, 2), (2, 4), (3, 6), (4, 8)");
            BugsTest.assertTrue((boolean)callbackExecuted[0]);
            s.execute("delete from testtable where ID = 1");
            this.waitForDeleteEvent(ok);
            BugsTest.assertEquals((int)4, (int)numInserts[0]);
            BugsTest.assertEquals((int)1, (int)numPKDeletes[0]);
            JdbcTestBase.stopAsyncEventListener(currentTest);
            BugsTest.validateResults(derbyStmt, s, "select * from testtable", false);
        }
        finally {
            if (derbyStmt != null) {
                derbyStmt.execute("drop table TESTTABLE");
            }
            if (s != null && !conn.isClosed()) {
                s.execute("drop table TESTTABLE");
            }
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    private void validateForBug42099(java.sql.ResultSet rs, boolean expectCommittedData) throws SQLException {
        rs.next();
        if (expectCommittedData) {
            BugsTest.assertEquals((int)1, (int)rs.getInt(1));
            BugsTest.assertEquals((int)1, (int)rs.getInt(2));
            BugsTest.assertEquals((int)1, (int)rs.getInt(3));
            BugsTest.assertEquals((int)1, (int)rs.getInt(4));
            BugsTest.assertEquals((int)1, (int)rs.getInt(5));
        } else {
            BugsTest.assertEquals((int)1, (int)rs.getInt(1));
            BugsTest.assertEquals((int)2, (int)rs.getInt(2));
            BugsTest.assertEquals((int)3, (int)rs.getInt(3));
            BugsTest.assertEquals((int)4, (int)rs.getInt(4));
            BugsTest.assertEquals((int)5, (int)rs.getInt(5));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42100() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1,1)");
        conn.commit();
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        st.execute("update t1 set c2 =2 where c2 =1");
        st.execute("update t1 set c3 =3 where c3 =1");
        st.execute("update t1 set c4 =4 where c4 =1");
        st.execute("update t1 set c5 =5 where c5 =1");
        try {
            java.sql.ResultSet rs = st.executeQuery("Select * from t1 where c1 > 0");
            this.validateForBug42099(rs, false);
            rs = st.executeQuery("Select * from t1 where c1 =1");
            this.validateForBug42099(rs, false);
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42100_1() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("Create table t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
        st.execute("create index i1 on t1 (c5)");
        conn.commit();
        st.execute("insert into t1 values (1, 1,1,1,1)");
        st.execute("insert into t1 values (2, 2,2,2,2)");
        st.execute("insert into t1 values (3, 3,3,3,3)");
        st.execute("insert into t1 values (4, 4,4,4,4)");
        conn.commit();
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForHash1IndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                return Double.MAX_VALUE;
            }

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                return 1.0;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        BugsTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 =5 where c5 =1"));
        BugsTest.assertEquals((int)1, (int)st.executeUpdate("update t1 set c5 =6 where c5 = 5"));
        conn.commit();
        try {
            java.sql.ResultSet rs = st.executeQuery("Select c5 from t1 where c1 =1");
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((int)6, (int)rs.getInt(1));
            conn.commit();
        }
        finally {
            GemFireXDQueryObserverHolder.clearInstance();
        }
    }

    public void DISABLED_testNewBug_42323_1() throws Exception {
        String indexName;
        Connection conn = BugsTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("Create table trade.t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
        st.execute("create index trade.index7_4 on trade.t1 ( c5 )");
        st.execute("rename index trade.index7_4 to index7_4a ");
        java.sql.ResultSet rs = conn.getMetaData().getIndexInfo(null, "TRADE", "T1", false, true);
        boolean foundOld = false;
        boolean foundNew = false;
        while (rs.next()) {
            indexName = rs.getString(6);
            if (indexName.equals("INDEX7_4A")) {
                foundNew = true;
                continue;
            }
            if (!indexName.equals("INDEX7_4")) continue;
            foundOld = true;
        }
        BugsTest.assertTrue((boolean)foundNew);
        BugsTest.assertFalse((boolean)foundOld);
        rs.close();
        conn.commit();
        foundNew = false;
        foundOld = false;
        conn.setTransactionIsolation(2);
        rs = conn.getMetaData().getIndexInfo(null, "TRADE", "T1", false, true);
        while (rs.next()) {
            indexName = rs.getString(6);
            if (indexName.equals("INDEX7_4A")) {
                foundNew = true;
                continue;
            }
            if (!indexName.equals("INDEX7_4")) continue;
            foundOld = true;
        }
        BugsTest.assertTrue((boolean)foundNew);
        BugsTest.assertFalse((boolean)foundOld);
    }

    public void DISABLED_testNewBug_42323_2() throws Exception {
        Connection conn = BugsTest.getConnection();
        conn.setTransactionIsolation(2);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("Create table trade.t1 (c1 int not null , c2 int not null, c3 int not null, c4 int not null , c5 int not null , primary key(c1)) ");
        st.execute("create index trade.index7_4 on trade.t1 ( c5 )");
        st.execute("rename index trade.index7_4 to index7_4a ");
        java.sql.ResultSet rs = conn.getMetaData().getIndexInfo(null, "TRADE", "T1", false, true);
        boolean foundOld = false;
        boolean foundNew = false;
        while (rs.next()) {
            String indexName = rs.getString(6);
            if (indexName.equals("INDEX7_4A")) {
                foundNew = true;
                continue;
            }
            if (!indexName.equals("INDEX7_4")) continue;
            foundOld = true;
        }
        BugsTest.assertTrue((boolean)foundNew);
        BugsTest.assertFalse((boolean)foundOld);
        rs.close();
        conn.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42783_1() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement st = conn.createStatement();
        try {
            st.executeUpdate("create table test(id char(10), c10 char(10), vc10 varchar(10)) replicate");
            PreparedStatement insert = BugsTest.getConnection().prepareStatement("insert into test values (?,?,?)");
            String[][] values = new String[][]{{"1", "abc", "def"}, {"2", "ghi", "jkl"}, {"3", "mno", "pqr"}, {"4", "stu", "vwx"}, {"5", "yza", "bcd"}, {"8", "abc dkp", "hij"}, {"9", "ab", "hij"}, {"9", "abcd efg", "hij"}};
            for (int i = 0; i < values.length; ++i) {
                String[] elements = values[i];
                for (int j = 0; j <= 2; ++j) {
                    insert.setString(j + 1, elements[j]);
                }
                insert.executeUpdate();
            }
            insert.setString(1, "V-NULL");
            insert.setString(2, null);
            insert.setString(3, null);
            insert.executeUpdate();
            insert.setString(1, "MAX_CHAR");
            insert.setString(2, "\ufa2d");
            insert.setString(3, "\ufa2d");
            insert.executeUpdate();
            PreparedStatement ps1 = conn.prepareStatement("select id from test where c10 like ?");
            java.sql.ResultSet rs = null;
            int count = 0;
            ps1.setObject(1, "");
            rs = ps1.executeQuery();
            rs.next();
            ps1.setObject(1, "%");
            rs = ps1.executeQuery();
            count = 0;
            while (rs.next()) {
                ++count;
            }
            BugsTest.assertEquals((int)count, (int)9);
            ps1.setObject(1, "ab%");
            rs = ps1.executeQuery();
            count = 0;
            while (rs.next()) {
                ++count;
            }
            BugsTest.assertEquals((int)count, (int)4);
            rs.close();
            PreparedStatement ps2 = conn.prepareStatement("select id from test where vc10 like ?");
            count = 0;
            ps2.setObject(1, "%");
            rs = ps2.executeQuery();
            while (rs.next()) {
                ++count;
            }
            BugsTest.assertEquals((int)count, (int)9);
            rs.close();
        }
        finally {
            st.execute("drop table test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42977() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = BugsTest.getConnection();
        Statement st = conn.createStatement();
        String schema = TestUtil.getCurrentDefaultSchemaName();
        try {
            st.executeUpdate(" create table customers (cid int not null, cust_name varchar(100),  addr varchar(100), tid int, primary key (cid))  partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))");
            String path = Misc.getRegionPath((String)schema, (String)"CUSTOMERS", null);
            PartitionedRegion rgn = (PartitionedRegion)Misc.getRegion((String)path, (boolean)true, (boolean)false);
            GfxdPartitionResolver spr = (GfxdPartitionResolver)rgn.getPartitionResolver();
            ((Integer)spr.getRoutingKeyForColumn((DataValueDescriptor)new SQLInteger(55))).intValue();
            PreparedStatement insert = BugsTest.getConnection().prepareStatement("insert into customers values (?,?,?,?)");
            insert.setInt(1, 97);
            insert.setString(2, "name_97");
            insert.setString(3, "addr_97");
            insert.setInt(4, 55);
            insert.executeUpdate();
            java.sql.ResultSet rs = st.executeQuery("select  addr, cust_name from customers where  tid = 55");
            BugsTest.assertTrue((boolean)rs.next());
        }
        finally {
            SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
            st.execute("drop table customers");
        }
    }

    public void testBug43006_1() throws Exception {
        Properties props = new Properties();
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        TestUtil.getCurrentDefaultSchemaName();
        try {
            st.executeUpdate(" CREATE TABLE owners(id INTEGER NOT NULL, first_name VARCHAR(30), last_name VARCHAR(30), address VARCHAR(255), city VARCHAR(80),  telephone VARCHAR(20),   PRIMARY KEY (id))");
            st.executeUpdate("CREATE INDEX last_name ON owners (last_name)");
            st.executeUpdate(" CREATE TABLE pets(id INTEGER, name VARCHAR(30), birth_date DATE, type_id INTEGER, owner_id INTEGER , PRIMARY KEY (id))");
            st.executeUpdate("CREATE INDEX owner_id ON pets (owner_id)");
            st.executeUpdate(" ALTER TABLE pets  ADD CONSTRAINT pets_ibfk_1 FOREIGN KEY (owner_id) REFERENCES owners (id) ");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        finally {
            st.execute("drop table pets");
            st.execute("drop table owners");
        }
    }

    public void testBug43006_2() throws Exception {
        Properties props = new Properties();
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        TestUtil.getCurrentDefaultSchemaName();
        try {
            st.executeUpdate(" CREATE TABLE owners(id INTEGER NOT NULL, first_name VARCHAR(30), last_name VARCHAR(30), address VARCHAR(255), city VARCHAR(80),  telephone VARCHAR(20),   PRIMARY KEY (id)) ");
            st.executeUpdate("CREATE INDEX last_name ON owners (last_name)");
            st.executeUpdate(" CREATE TABLE pets(id INTEGER, name VARCHAR(30), birth_date DATE, type_id INTEGER, owner_id INTEGER , PRIMARY KEY (id))");
            st.executeUpdate("CREATE INDEX owner_id ON pets (owner_id)");
            st.executeUpdate(" ALTER TABLE pets add CONSTRAINT unique_constr1 UNIQUE (owner_id)");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        finally {
            st.execute("drop table pets");
            st.execute("drop table owners");
        }
    }

    public void testBug43003_1() throws Exception {
        Properties props = new Properties();
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        TestUtil.getCurrentDefaultSchemaName();
        try {
            st.executeUpdate(" CREATE TABLE \"owners\"(\"id\" INTEGER NOT NULL,\"first_name\" VARCHAR(30), \"last_name\" VARCHAR(30), \"address\" VARCHAR(255),    \"city\" VARCHAR(80),  \"telephone\" VARCHAR(20),   PRIMARY KEY (\"id\")) ");
            st.executeUpdate(" CREATE TABLE \"pets\"(    \"id\" INTEGER NOT NULL,    \"name\" VARCHAR(30), \"birth_date\" DATE,    \"type_id\" INTEGER NOT NULL,    \"owner_id\" INTEGER NOT NULL,    PRIMARY KEY (\"id\"))");
            st.executeUpdate(" ALTER TABLE \"pets\"  ADD CONSTRAINT \"pets_ibfk_1\" FOREIGN KEY (\"owner_id\") REFERENCES \"owners\" (\"id\") ");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        finally {
            st.execute("drop table \"pets\"");
            st.execute("drop table \"owners\"");
        }
    }

    public void testBug43003_2() throws Exception {
        Properties props = new Properties();
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        TestUtil.getCurrentDefaultSchemaName();
        try {
            st.executeUpdate(" CREATE TABLE \"owners\"(\"id\" INTEGER NOT NULL,\"first_name\" VARCHAR(30), \"last_name\" VARCHAR(30), \"address\" VARCHAR(255),    \"city\" VARCHAR(80),  \"telephone\" VARCHAR(20),   PRIMARY KEY (\"id\")) ");
            st.executeUpdate(" CREATE TABLE \"pets\"(    \"id\" INTEGER NOT NULL,    \"name\" VARCHAR(30), \"birth_date\" DATE,    \"type_id\" INTEGER NOT NULL,    \"owner_id\" INTEGER NOT NULL,    PRIMARY KEY (\"id\"))");
            st.executeUpdate(" ALTER TABLE \"pets\"  ADD CONSTRAINT \"pets_ibfk_1\" FOREIGN KEY (\"owner_id\") REFERENCES \"owners\" (\"id\") ");
            st.executeQuery("select * from \"pets\"");
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            throw sqle;
        }
        finally {
            st.execute("drop table \"pets\"");
            st.execute("drop table \"owners\"");
        }
    }

    public void testSynonym() throws Exception {
        int cnt;
        System.clearProperty(GfxdConstants.GFXD_DISABLE_STATEMENT_MATCHING);
        Properties props = new Properties();
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create synonym synForSale for sale");
        st.execute("create table sale (timestamp timestamp, store_id int, id int,  PRIMARY KEY(id)) partition by column (store_id)");
        PreparedStatement ps = conn.prepareStatement("insert into synForSale (id, timestamp, store_id) values (?, ?, ?)");
        String timestamp = "2005-01-";
        String time = " 00:00:00";
        st.execute("create index tdx on sale(timestamp)");
        for (int i = 1; i < 32; ++i) {
            ps.setInt(1, i);
            if (i > 9) {
                ps.setTimestamp(2, Timestamp.valueOf(timestamp + i + time));
            } else {
                ps.setTimestamp(2, Timestamp.valueOf(timestamp + "0" + i + time));
            }
            ps.setInt(3, i % 2);
            cnt = ps.executeUpdate();
            BugsTest.assertEquals((int)1, (int)cnt);
        }
        st.execute("create synonym syn2ForSale for sale");
        st.execute("select max(timestamp) from synForSale");
        java.sql.ResultSet rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((String)"2005-01-31 00:00:00.0", (String)rs.getTimestamp(1).toString());
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("update syn2ForSale set timestamp = '2006-01-31 00:00:00' where id = 1");
        st.execute("select max(timestamp) from synForSale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((String)"2006-01-31 00:00:00.0", (String)rs.getTimestamp(1).toString());
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("delete from synForSale");
        st.execute("select * from syn2ForSale");
        rs = st.getResultSet();
        while (rs.next()) {
            BugsTest.fail("no result should come");
        }
    }

    public void testMaxBugcshanklin_43418() throws Exception {
        int cnt;
        Properties props = new Properties();
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create table sale (timestamp timestamp, store_id int, id int,  PRIMARY KEY(id)) partition by column (store_id)");
        PreparedStatement ps = conn.prepareStatement("insert into sale (id, timestamp, store_id) values (?, ?, ?)");
        String timestamp = "2005-01-";
        String time = " 00:00:00";
        st.execute("create index tdx on sale(timestamp)");
        for (int i = 1; i < 32; ++i) {
            ps.setInt(1, i);
            if (i > 9) {
                ps.setTimestamp(2, Timestamp.valueOf(timestamp + i + time));
            } else {
                ps.setTimestamp(2, Timestamp.valueOf(timestamp + "0" + i + time));
            }
            ps.setInt(3, i % 2);
            cnt = ps.executeUpdate();
            BugsTest.assertEquals((int)1, (int)cnt);
        }
        st.execute("select max(timestamp) from sale");
        java.sql.ResultSet rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((String)"2005-01-31 00:00:00.0", (String)rs.getTimestamp(1).toString());
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("select min(timestamp) from sale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((String)"2005-01-01 00:00:00.0", (String)rs.getTimestamp(1).toString());
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("create index tdxMult on sale(id, timestamp)");
        st.execute("select max(id) from sale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((int)31, (int)rs.getInt(1));
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("drop index tdxMult");
        st.execute("create index tdx2 on sale(id asc)");
        st.execute("select max(id) from sale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((int)31, (int)rs.getInt(1));
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("drop index tdx2");
        st.execute("drop index tdx");
        st.execute("create index tdxMult on sale(id asc, timestamp desc)");
        st.execute("select max(id) from sale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((int)31, (int)rs.getInt(1));
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("drop index tdxMult");
        st.execute("create index tdxMult on sale(id desc, timestamp asc)");
        st.execute("select max(id) from sale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((int)31, (int)rs.getInt(1));
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("drop index tdxMult");
        st.execute("create index tdxMult on sale(timestamp desc, id asc)");
        st.execute("select max(id) from sale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((int)31, (int)rs.getInt(1));
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("drop index tdxMult");
        st.execute("create index tdxMult on sale(timestamp asc, id desc)");
        st.execute("select max(id) from sale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((int)31, (int)rs.getInt(1));
        }
        BugsTest.assertEquals((int)1, (int)cnt);
        st.execute("drop index tdxMult");
        st.execute("create index tdxMult on sale(timestamp desc, id desc)");
        st.execute("select max(id) from sale");
        rs = st.getResultSet();
        cnt = 0;
        while (rs.next()) {
            ++cnt;
            BugsTest.assertEquals((int)31, (int)rs.getInt(1));
        }
        BugsTest.assertEquals((int)1, (int)cnt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void __testBug42783_2() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement st = conn.createStatement();
        try {
            st.executeUpdate("create table test(id char(10), c10 char(10), vc10 varchar(10)) replicate");
            PreparedStatement insert = BugsTest.getConnection().prepareStatement("insert into test values (?,?,?)");
            String[][] values = new String[][]{{"6", "efg", "hij"}, {"7", "abcdefg", "hijklm"}};
            for (int i = 0; i < values.length; ++i) {
                String[] elements = values[i];
                for (int j = 0; j <= 2; ++j) {
                    insert.setString(j + 1, elements[j]);
                }
                insert.executeUpdate();
            }
            insert.setString(1, "V-NULL");
            insert.setString(2, null);
            insert.setString(3, null);
            insert.executeUpdate();
            insert.setString(1, "MAX_CHAR");
            insert.setString(2, "\ufa2d");
            insert.setString(3, "\ufa2d");
            PreparedStatement ps = conn.prepareStatement("select id from test where c10 like ?");
            java.sql.ResultSet rs = null;
            int count = 0;
            ps.setObject(1, "%fg");
            rs = ps.executeQuery();
            count = 0;
            while (rs.next()) {
                ++count;
            }
            BugsTest.assertEquals((int)count, (int)2);
            rs.close();
        }
        finally {
            st.execute("drop table test");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug42828() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("create table t (i int, s smallint, r real, f float, d date, t time, ts timestamp, c char(10), v varchar(20))");
            s.execute("delete from t");
            s.execute("insert into t (i) values (null)");
            s.execute("insert into t (i) values (null)");
            java.sql.ResultSet rs = s.executeQuery("select * from t where c = (select distinct v from t)");
            int numRows = 0;
            while (rs.next()) {
                ++numRows;
            }
            BugsTest.assertEquals((int)0, (int)numRows);
        }
        finally {
            s.execute("drop table t");
        }
    }

    public void testBug43735() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.networth (cid int not null, cash decimal (30, 20), securities decimal (30, 20), loanlimit int, availloan decimal (30, 20),  tid int, constraint netw_pk primary key (cid), constraint cash_ch check (cash>=0), constraint sec_ch check (securities >=0), constraint availloan_ck check (loanlimit>=availloan and availloan >=0))partition by list (tid) (VALUES (0, 1, 2, 3, 4, 5), VALUES (6, 7, 8, 9, 10, 11), VALUES (12, 13, 14, 15, 16, 17))");
        stmt.execute("insert into trade.networth values (859, 37099.0, 0.0, 5000, 5000.0, 43)");
        stmt.execute("insert into trade.networth values (4797, 16287.0, 308331.30, 20000, 10000.0, 43)");
        stmt.execute("create index trade.nw_al on trade.networth(availloan)");
        GemFireContainer container = (GemFireContainer)Misc.getRegion((String)"/TRADE/NETWORTH", (boolean)true, (boolean)false).getUserAttribute();
        byte[] expectedVbytes = new byte[]{2, 0, 0, 18, -67, 20, 1, 1, 88, -28, 1, 0, -87, -111, 118, -16, 0, 0, 20, 1, 25, -127, 43, 83, -105, 59, -19, 69, 104, 0, 0, 0, 0, 78, 32, 20, 1, -45, -62, 27, -50, -52, -19, -95, 0, 0, 0, 0, 0, 0, 43, 5, 18, 31, 35, 47};
        byte[] actualVbytes = (byte[])container.getRegion().get((Object)new CompactCompositeRegionKey((DataValueDescriptor)new SQLInteger(4797), container.getExtraTableInfo()));
        BugsTest.assertTrue((boolean)Arrays.equals(expectedVbytes, actualVbytes));
        byte[] expectedVbytes1 = new byte[]{2, 0, 0, 3, 91, 20, 1, 3, 17, -102, 20, -4, -5, 98, -17, -80, 0, 0, 20, 0, 0, 0, 19, -120, 20, 1, 105, -31, 13, -25, 102, 118, -48, -128, 0, 0, 0, 0, 0, 43, 5, 18, 20, 24, 36};
        byte[] actualVbytes1 = (byte[])container.getRegion().get((Object)new CompactCompositeRegionKey((DataValueDescriptor)new SQLInteger(859), container.getExtraTableInfo()));
        BugsTest.assertTrue((boolean)Arrays.equals(expectedVbytes1, actualVbytes1));
        conn.setTransactionIsolation(2);
        stmt.execute("update trade.networth set securities=565707.9 where securities=0.0");
        stmt.execute("update trade.networth set loanlimit=50000 where availloan > 1000.0");
        conn.commit();
        java.sql.ResultSet rs = stmt.executeQuery("select cid, loanlimit, securities from trade.networth");
        int numRows = 0;
        while (rs.next()) {
            if (rs.getInt(1) == 859) {
                BugsTest.assertEquals((String)"565707.90000000000000000000", (String)rs.getString(3));
                BugsTest.assertEquals((int)50000, (int)rs.getInt(2));
            } else {
                BugsTest.assertEquals((int)4797, (int)rs.getInt(1));
                BugsTest.assertEquals((String)"308331.30000000000000000000", (String)rs.getString(3));
                BugsTest.assertEquals((int)50000, (int)rs.getInt(2));
            }
            ++numRows;
        }
        BugsTest.assertEquals((int)2, (int)numRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistinctWithBigInt_Bug42821() throws SQLException {
        Connection conn = BugsTest.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("create table li (l bigint, i int)");
            s.execute("insert into li values(1, 1)");
            s.execute("insert into li values(1, 1)");
            s.execute("insert into li values(9223372036854775807, 2147483647)");
        }
        finally {
            s.execute("drop table li");
            s.close();
        }
    }

    public void testUpdDelOnSysVTIs() throws SQLException {
        Connection conn = BugsTest.getConnection();
        Statement s = conn.createStatement();
        try {
            s.execute("delete from sys.members");
        }
        catch (SQLException ex) {
            BugsTest.assertTrue((boolean)ex.getSQLState().equalsIgnoreCase("42Y25"));
        }
        try {
            s.execute("update sys.indexes set indextype='X'");
        }
        catch (SQLException ex) {
            BugsTest.assertTrue((boolean)ex.getSQLState().equalsIgnoreCase("42Y25"));
        }
    }

    public void test43510_UDFAndInsertBatchUpdates() throws SQLException {
        Connection conn = BugsTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create function myhash (value Integer) returns integer language java external name 'com.pivotal.gemfirexd.jdbc.BugsTest.myhash' parameter style java no sql returns null on null input");
        st.execute("create table customer (c_w_id         integer        not null,c_id           integer        not null) partition by (myhash(c_w_id)) redundancy 1");
        st.execute("create table history (h_c_id   integer,h_c_w_id integer) partition by (myhash(h_c_w_id)) redundancy 1");
        PreparedStatement cps = conn.prepareStatement("insert into customer values (?,?) ");
        PreparedStatement hps = conn.prepareStatement("insert into history values (?,?) ");
        hps.setInt(1, 1);
        hps.setInt(2, 1);
        hps.addBatch();
        hps.setInt(1, 1);
        hps.setInt(2, 1);
        hps.addBatch();
        hps.setInt(1, 1);
        hps.setInt(2, 1);
        hps.addBatch();
        hps.executeBatch();
        hps.clearBatch();
        cps.setInt(1, 1);
        cps.setInt(2, 1);
        cps.addBatch();
        cps.setInt(1, 1);
        cps.setInt(2, 1);
        cps.addBatch();
        cps.setInt(1, 1);
        cps.setInt(2, 1);
        cps.addBatch();
        cps.executeBatch();
        cps.clearBatch();
    }

    public void test43897() throws SQLException {
        block6: {
            int i;
            this.reduceLogLevelForTest("config");
            Properties props = new Properties();
            props.setProperty("log-level", "config");
            props.setProperty("host-data", "true");
            props.setProperty("mcast-port", Integer.toString(AvailablePort.getRandomAvailablePort((int)0)));
            BugsTest.assertTrue((String)"must self distributed", (Integer.parseInt(props.getProperty("mcast-port")) != 0 ? 1 : 0) != 0);
            Connection conn = BugsTest.getConnection(props);
            Statement st = conn.createStatement();
            st.execute("create schema hi_fi");
            st.execute("create table customer (c_w_id         integer        not null,c_id           integer        not null) replicate ");
            st.execute("create table history (h_c_id   integer,h_c_w_id integer) partition by column (h_c_w_id) ");
            PreparedStatement cps = conn.prepareStatement("insert into customer values (?,?) ");
            PreparedStatement hps = conn.prepareStatement("insert into history values (?,?) ");
            for (i = 1; i < 3; ++i) {
                hps.setInt(1, 1);
                hps.setInt(2, 1);
                hps.addBatch();
            }
            hps.executeBatch();
            hps.clearBatch();
            for (i = 1; i < 3; ++i) {
                cps.setInt(1, 1);
                cps.setInt(2, 1);
                cps.addBatch();
            }
            cps.executeBatch();
            cps.clearBatch();
            GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

                public void onGetNextRowCore(ResultSet resultSet) {
                    throw new NullPointerException();
                }
            };
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
            PreparedStatement sps = conn.prepareStatement("select * from customer, history");
            try {
                java.sql.ResultSet rs = sps.executeQuery();
                while (rs.next()) {
                }
            }
            catch (SQLException sqle) {
                BugsTest.assertTrue((boolean)"XJ001".equals(sqle.getSQLState()));
                Throwable t = sqle.getCause();
                while (!(t instanceof NullPointerException) && (t = t.getCause()) != null) {
                }
                if (t != null && t instanceof NullPointerException) break block6;
                BugsTest.fail("must have found NullPointerException propagated outside, instead found ", sqle);
            }
        }
    }

    public void test43309() throws SQLException {
        Properties cp = new Properties();
        cp.setProperty("host-data", "true");
        cp.setProperty("mcast-port", "0");
        cp.setProperty("gemfire.enable-time-statistics", "true");
        cp.setProperty("statistic-sample-rate", "100");
        cp.setProperty("statistic-sampling-enabled", "true");
        cp.setProperty("enable-stats", "true");
        cp.setProperty("enable-timestats", "true");
        cp.setProperty("statistic-archive-file", "loner-1.gfs");
        cp.put("user", "Soubhik");
        cp.put("password", "Soubhik");
        Connection conn = TestUtil.getConnection(cp);
        Statement st = conn.createStatement();
        st.execute("create table CHEESE (CHEESE_CODE VARCHAR(5), CHEESE_NAME VARCHAR(20), CHEESE_COST DECIMAL(7,4))");
        st.execute("create index cheese_index on CHEESE (CHEESE_CODE DESC, CHEESE_NAME DESC, CHEESE_COST DESC)");
        st.execute("INSERT INTO CHEESE (CHEESE_CODE, CHEESE_NAME, CHEESE_COST) VALUES ('00000', 'GOUDA', 001.1234), ('00000', 'EDAM', 002.1111), ('54321', 'EDAM', 008.5646), ('12345', 'GORGONZOLA', 888.2309), ('AAAAA', 'EDAM', 999.8888), ('54321', 'MUENSTER', 077.9545)");
        java.sql.ResultSet rs = st.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 DESC, 5 DESC, 6 DESC");
        String[][] expRS3 = new String[][]{{"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}, {"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}};
        int i = 0;
        while (rs.next()) {
            BugsTest.assertEquals((String)expRS3[i][0], (String)rs.getString(4));
            ++i;
        }
    }

    public void test43818() throws Exception {
        Connection eConn = TestUtil.getConnection();
        Connection conn = TestUtil.startNetserverAndGetLocalNetConnection();
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = st.executeQuery("select count(*) from sys.sysaliases where javaclassname like 'com.pivotal%'");
        while (rs.next()) {
        }
        rs.close();
        conn.close();
        eConn.close();
    }

    public void testStatistics() throws SQLException {
        this.reduceLogLevelForTest("config");
        Properties props = new Properties();
        props.setProperty("statistic-sampling-enabled", "true");
        props.setProperty("log-level", "config");
        props.setProperty("host-data", "true");
        props.setProperty("mcast-port", Integer.toString(AvailablePort.getRandomAvailablePort((int)0)));
        props.setProperty("enable-stats", "true");
        props.setProperty("enable-timestats", "true");
        Connection conn = BugsTest.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema hi_fi");
        st.execute("create table customer (c_w_id         integer        not null,c_id           integer        not null) replicate ");
        st.execute("create table history (h_c_id   integer,h_c_w_id integer) partition by column (h_c_w_id) ");
        PreparedStatement cps = conn.prepareStatement("insert into customer values (?,?) ");
        PreparedStatement hps = conn.prepareStatement("insert into history values (?,?) ");
        hps.setInt(1, 1);
        hps.setInt(2, 1);
        hps.addBatch();
        hps.setInt(1, 1);
        hps.setInt(2, 1);
        hps.addBatch();
        hps.setInt(1, 1);
        hps.setInt(2, 1);
        hps.addBatch();
        hps.executeBatch();
        hps.clearBatch();
        cps.setInt(1, 1);
        cps.setInt(2, 1);
        cps.addBatch();
        cps.setInt(1, 1);
        cps.setInt(2, 1);
        cps.addBatch();
        cps.setInt(1, 1);
        cps.setInt(2, 1);
        cps.addBatch();
        cps.executeBatch();
        cps.clearBatch();
        Statement s = conn.createStatement();
        PreparedStatement ps = conn.prepareStatement("insert into customer values (?, ?) ");
        ps.setInt(1, 44);
        ps.setInt(2, 43);
        int updateCount = ps.executeUpdate();
        System.out.println(updateCount);
        PreparedStatement sps = conn.prepareStatement("select * from customer, history");
        java.sql.ResultSet rs = sps.executeQuery();
        while (rs.next()) {
        }
        rs.close();
        for (int i = 0; i < 1; ++i) {
            java.sql.ResultSet r = s.executeQuery("select * from customer, history");
            while (r.next()) {
            }
            r.close();
        }
        s.execute("call syscs_util.set_explain_connection(1)");
        java.sql.ResultSet r = s.executeQuery("select * from customer, history");
        while (r.next()) {
        }
        r.close();
        s.execute("call syscs_util.set_explain_connection(0)");
        java.sql.ResultSet rp = s.executeQuery("select stmt_id from sys.statementplans");
        while (rp.next()) {
            String stmt_id = rp.getString(1);
            ExecutionPlanUtils ex = new ExecutionPlanUtils(conn, stmt_id, null, true);
            System.out.println(ex.getPlanAsText(null));
        }
        s.execute("call SYSCS_UTIL.SET_STATEMENT_STATISTICS(0)");
    }

    public void _test45655_45666() throws SQLException {
        BugsTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.portfolio (cid int not null, sid int, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))  partition by column (cid, sid)");
        stmt.execute("create index idx_tot on trade.portfolio(subtotal, tid)");
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.portfolio values (?,?,?,?,?,?)");
        for (int i = 1; i <= 20; ++i) {
            pstmt.setInt(1, i);
            pstmt.setInt(2, i + 10);
            pstmt.setInt(3, i + 10000);
            pstmt.setInt(4, i + 1000);
            pstmt.setBigDecimal(5, new BigDecimal(String.valueOf(i * 5) + '.' + String.valueOf(i * 2)));
            pstmt.setInt(6, 2);
            BugsTest.assertEquals((int)1, (int)pstmt.executeUpdate());
        }
        pstmt = conn.prepareStatement("select distinct cid from trade.portfolio where subTotal < ? or subTotal >= ?");
        pstmt.setBigDecimal(1, new BigDecimal("15"));
        pstmt.setBigDecimal(2, new BigDecimal("80"));
        java.sql.ResultSet rs = pstmt.executeQuery();
        int cid = 1;
        while (rs.next()) {
            if (cid == 3) {
                cid = 16;
            }
            BugsTest.assertEquals((int)cid, (int)rs.getInt(1));
            ++cid;
        }
        BugsTest.assertEquals((int)21, (int)cid);
        String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        stmt.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by primary key");
        pstmt = conn.prepareStatement("insert into trade.securities values (?, ?, ?, ?, ?)");
        for (int i = 1; i <= 20; ++i) {
            pstmt.setInt(1, i);
            pstmt.setString(2, "sym" + i);
            pstmt.setBigDecimal(3, new BigDecimal(String.valueOf(i * 5) + '.' + String.valueOf(i * 2)));
            pstmt.setString(4, exchanges[i % exchanges.length]);
            pstmt.setInt(5, i + 10);
            BugsTest.assertEquals((int)1, (int)pstmt.executeUpdate());
        }
        for (int c = 1; c <= 4; ++c) {
            if (c == 1) {
                stmt.execute("create index idxprice on trade.securities(PRICE asc)");
            } else if (c == 2) {
                stmt.execute("create index idxprice on trade.securities(PRICE desc)");
            } else if (c == 3) {
                stmt.execute("create index idxprice on trade.securities(PRICE asc)");
                stmt.execute("create index idxprice2 on trade.securities(PRICE desc)");
            } else {
                stmt.execute("create index idxprice on trade.securities(PRICE desc)");
                stmt.execute("create index idxprice2 on trade.securities(PRICE asc)");
            }
            pstmt = conn.prepareStatement("select price, symbol, exchange from trade.securities where (price<? or price >=?)");
            pstmt.setBigDecimal(1, new BigDecimal("15"));
            pstmt.setBigDecimal(2, new BigDecimal("80"));
            THashSet prices = new THashSet();
            for (int sid = 1; sid <= 20; ++sid) {
                if (sid == 3) {
                    sid = 16;
                }
                prices.add((Object)new BigDecimal(String.valueOf(sid * 5) + '.' + String.valueOf(sid * 2)).setScale(20));
            }
            TestUtil.ScanTypeQueryObserver scanObserver = new TestUtil.ScanTypeQueryObserver();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)scanObserver);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (prices.remove(rs.getObject(1))) continue;
                BugsTest.fail("unexpected price: " + rs.getObject(1));
            }
            rs.close();
            BugsTest.assertEquals((int)0, (int)prices.size());
            scanObserver.addExpectedScanType("TRADE.SECURITIES", TestUtil.ScanType.SORTEDMAPINDEX);
            scanObserver.checkAndClear();
            stmt.execute("drop index trade.idxprice");
            if (c <= 2) continue;
            stmt.execute("drop index trade.idxprice2");
        }
        GemFireXDQueryObserverHolder.clearInstance();
    }

    public void test45924() throws Exception {
        BugsTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Connection conn2 = BugsTest.startNetserverAndGetLocalNetConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table works (empnum char(3) not null, pnum char(3) not null, hours decimal(5), unique (empnum,pnum)) replicate");
        stmt.execute("insert into works values ('E1','P1',40)");
        Statement stmt2 = conn2.createStatement();
        java.sql.ResultSet rs = stmt2.executeQuery("select empnum from works where empnum='E1'");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((Object)"E1 ", (Object)rs.getObject(1));
        BugsTest.assertEquals((String)"E1 ", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select empnum from works where empnum='E1'");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((Object)"E1 ", (Object)rs.getObject(1));
        BugsTest.assertEquals((String)"E1 ", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
    }

    public void test47018() throws Exception {
        BugsTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Connection conn2 = BugsTest.startNetserverAndGetLocalNetConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table t1 (col1 char(100), col2 char(1), col3 int, col4 int) partition by (col2)");
        stmt.execute("insert into t1 values (NULL, 'a', 1, 2)");
        stmt.execute("create index index_1 on t1 (col1 asc)");
        Statement stmt2 = conn2.createStatement();
        java.sql.ResultSet rs = stmt2.executeQuery("select col1, col2, col3, col4 from t1 where col1 is null and col3 = 1");
        BugsTest.assertTrue((boolean)rs.next());
        rs.getString(1);
        BugsTest.assertTrue((boolean)rs.wasNull());
        BugsTest.assertEquals((String)"a", (String)rs.getString(2));
        BugsTest.assertEquals((int)1, (int)rs.getInt(3));
        BugsTest.assertEquals((int)2, (int)rs.getInt(4));
        BugsTest.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select col1, col2, col3, col4 from t1 where col1 is null and col3 = 1");
        BugsTest.assertTrue((boolean)rs.next());
        rs.getString(1);
        BugsTest.assertTrue((boolean)rs.wasNull());
        BugsTest.assertEquals((String)"a", (String)rs.getString(2));
        BugsTest.assertEquals((int)1, (int)rs.getInt(3));
        BugsTest.assertEquals((int)2, (int)rs.getInt(4));
        BugsTest.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46803_1() throws Exception {
        int i;
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Object rs = null;
        Connection conn = null;
        try {
            int n;
            block14: {
                block13: {
                    block12: {
                        conn = BugsTest.getConnection();
                        s = conn.createStatement();
                        statements.add(s);
                        s.execute(" create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) ");
                        s.execute(" create table companies (symbol varchar(10) not null,  exchange varchar(10) not null,  companyname char(100),  tid int, constraint comp_pk primary key (symbol, exchange) ,constraint comp_fk foreign key (symbol, exchange) references securities (symbol, exchange) on delete restrict)");
                        psInsert4 = conn.prepareStatement("insert into securities values (?, ?, ?,?)");
                        statements.add(psInsert4);
                        for (i = 1; i < 4; ++i) {
                            psInsert4.setInt(1, i);
                            psInsert4.setString(2, "symbol" + i);
                            psInsert4.setString(3, "lse");
                            psInsert4.setInt(4, 1);
                            BugsTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
                        }
                        PreparedStatement psInsert1 = conn.prepareStatement("insert into companies values (?, ?,?,?)");
                        statements.add(psInsert1);
                        for (i = 1; i < 4; ++i) {
                            psInsert1.setString(1, "symbol" + i);
                            psInsert1.setString(2, "lse");
                            psInsert1.setString(3, "name" + i);
                            psInsert1.setInt(4, 1);
                            BugsTest.assertEquals((int)1, (int)psInsert1.executeUpdate());
                        }
                        n = s.executeUpdate("update securities set tid=7  where sec_id = 1");
                        BugsTest.assertEquals((int)1, (int)n);
                        try {
                            s.executeUpdate("update securities set symbol = 'random1' , exchange = 'amex' where sec_id = 1");
                            BugsTest.fail("Should have thrown constraint violation exception");
                        }
                        catch (SQLException expected) {
                            if (expected.getSQLState().equals("23503")) break block12;
                            expected.printStackTrace();
                            BugsTest.fail("unexpected sql state for sql exception =" + expected);
                        }
                    }
                    try {
                        s.executeUpdate("update securities set exchange = 'amex'  where sec_id = 1");
                        BugsTest.fail("Should have thrown constraint violation exception");
                    }
                    catch (SQLException expected) {
                        if (expected.getSQLState().equals("23503")) break block13;
                        expected.printStackTrace();
                        BugsTest.fail("unexpected sql state for sql exception =" + expected);
                    }
                }
                try {
                    s.executeUpdate("update securities set symbol = 'random1'  where sec_id = 1");
                    BugsTest.fail("Should have thrown constraint violation exception");
                }
                catch (SQLException expected) {
                    if (expected.getSQLState().equals("23503")) break block14;
                    expected.printStackTrace();
                    BugsTest.fail("unexpected sql state for sql exception =" + expected);
                }
            }
            n = s.executeUpdate("update securities set symbol = 'symbol1'  where sec_id = 1");
            BugsTest.assertEquals((int)1, (int)n);
        }
        finally {
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46803_2() throws Exception {
        int i;
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Object rs = null;
        Connection conn = null;
        try {
            conn = BugsTest.getConnection();
            s = conn.createStatement();
            statements.add(s);
            s.execute(" create table securities (sec_id int not null, symbol varchar(10) not null,exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) ");
            s.execute(" create table companies (symbol varchar(10) not null,  exchange varchar(10) not null,  companyname char(100),  tid int, constraint comp_pk primary key (symbol, exchange) ,constraint comp_fk foreign key (symbol, exchange) references securities (symbol, exchange) on delete restrict)");
            s.execute("create table buyorders(oid int not null constraint buyorders_pk primary key, sid int,  tid int,  constraint bo_sec_fk foreign key (sid) references securities (sec_id)  on delete restrict)");
            psInsert4 = conn.prepareStatement("insert into securities values (?, ?, ?,?)");
            statements.add(psInsert4);
            for (i = 1; i < 10; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setString(2, "symbol" + i);
                psInsert4.setString(3, "lse");
                psInsert4.setInt(4, 1);
                BugsTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            PreparedStatement psInsert1 = conn.prepareStatement("insert into companies values (?, ?,?,?)");
            statements.add(psInsert1);
            for (i = 1; i < 4; ++i) {
                psInsert1.setString(1, "symbol" + i);
                psInsert1.setString(2, "lse");
                psInsert1.setString(3, "name" + i);
                psInsert1.setInt(4, 1);
                BugsTest.assertEquals((int)1, (int)psInsert1.executeUpdate());
            }
            PreparedStatement psInsert2 = conn.prepareStatement("insert into buyorders values (?, ?,?)");
            statements.add(psInsert2);
            for (i = 1; i < 10; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, 1);
                BugsTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            int n = s.executeUpdate("update securities set tid = 7 where sec_id = 3");
            BugsTest.assertEquals((int)1, (int)n);
            n = s.executeUpdate("update securities set exchange = 'amex' where sec_id = 9");
            BugsTest.assertEquals((int)1, (int)n);
            n = s.executeUpdate("update securities set exchange = 'hkse', symbol ='random_n'  where sec_id = 9 and tid = 1");
            BugsTest.assertEquals((int)1, (int)n);
            PreparedStatement psUpdate = conn.prepareStatement("update securities set exchange = ?, symbol =?  where sec_id = ? and tid = ?");
            psUpdate.setString(1, "fse");
            psUpdate.setString(2, "random_2");
            psUpdate.setInt(3, 9);
            psUpdate.setInt(4, 1);
            n = psUpdate.executeUpdate();
            BugsTest.assertEquals((int)1, (int)n);
        }
        finally {
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47465() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsertDerby = null;
        Statement s = null;
        Object rs = null;
        Connection conn = null;
        conn = BugsTest.getConnection();
        s = conn.createStatement();
        statements.add(s);
        String tableBuyOrders = " create table buyorders(oid int not null constraint buyorders_pk primary key, cid int, qty int, bid decimal (30, 20), status varchar (10) , constraint bo_qty_ck check (qty>=0))  ";
        String tempDerbyUrl = "jdbc:derby:newDB;create=true;";
        if (TestUtil.currentUserName != null) {
            tempDerbyUrl = tempDerbyUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
        }
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        String derbyDbUrl = tempDerbyUrl;
        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
        Statement derbyStmt = derbyConn.createStatement();
        String query = "select cid,  avg(qty*bid)  as amount from buyorders  where status =?  GROUP BY cid ORDER BY amount";
        java.sql.ResultSet rsDerby = null;
        try {
            s.execute(tableBuyOrders);
            derbyStmt.execute(tableBuyOrders);
            String index1 = "create index buyorders_cid on buyorders(cid)";
            s.execute(index1);
            derbyStmt.execute(index1);
            PreparedStatement psInsert = conn.prepareStatement("insert into buyorders values (?, ?, ?,?,?)");
            psInsertDerby = derbyConn.prepareStatement("insert into buyorders values (?, ?, ?,?,?)");
            statements.add(psInsert);
            int cid = 1;
            int cidIncrementor = 0;
            boolean constant = true;
            for (int i = 1; i < 500; ++i) {
                if (cidIncrementor % 5 == 0) {
                    ++cid;
                }
                ++cidIncrementor;
                psInsert.setInt(1, i);
                psInsert.setInt(2, cid);
                psInsert.setInt(3, i * 23);
                psInsert.setFloat(4, (float)(i * cid) * 73.5f);
                psInsert.setString(5, "open");
                psInsertDerby.setInt(1, i);
                psInsertDerby.setInt(2, cid);
                psInsertDerby.setInt(3, i * 23);
                psInsertDerby.setFloat(4, (float)(i * cid) * 73.5f);
                psInsertDerby.setString(5, "open");
                BugsTest.assertEquals((int)1, (int)psInsert.executeUpdate());
                BugsTest.assertEquals((int)1, (int)psInsertDerby.executeUpdate());
            }
            GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                    return Double.MAX_VALUE;
                }

                public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                    return 1.0;
                }
            });
            PreparedStatement derbyQuery = derbyConn.prepareStatement(query);
            derbyQuery.setString(1, "open");
            PreparedStatement gfxdQuery = conn.prepareStatement(query);
            gfxdQuery.setString(1, "open");
            BugsTest.validateResults(derbyQuery, gfxdQuery, query, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            BugsTest.fail("Test failed because of exception " + e);
        }
        finally {
            if (rsDerby != null) {
                rsDerby.close();
            }
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table buyorders");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (s != null) {
                try {
                    s.execute("drop table buyorders");
                }
                catch (Exception exception) {}
            }
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46803_3() throws Exception {
        int i;
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Object rs = null;
        Connection conn = null;
        try {
            conn = TestUtil.getConnection();
            s = conn.createStatement();
            statements.add(s);
            s.execute(" create table securities ( id int primary key, sec_id int not null, symbol varchar(10) not null, exchange varchar(10) not null, tid int, sec_id2 int, constraint sec_id_uq unique (sec_id),constraint sec_id2_uq unique (sec_id2), constraint  exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) ");
            s.execute("create table buyorders(oid int not null constraint buyorders_pk primary key, sid int,  tid int, sec_id2 int, constraint bo_sec_fk foreign key (sid) references securities (sec_id)  on delete restrict,   constraint bo_sec_fk2 foreign key (sec_id2) references securities (sec_id2)  on delete restrict)");
            psInsert4 = conn.prepareStatement("insert into securities values (?,?, ?, ?,?,?)");
            statements.add(psInsert4);
            for (i = 1; i < 3; ++i) {
                psInsert4.setInt(1, i);
                psInsert4.setInt(2, i);
                psInsert4.setString(3, "symbol" + i);
                psInsert4.setString(4, "lse");
                psInsert4.setInt(5, 1);
                psInsert4.setInt(6, i * 3);
                BugsTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
            }
            PreparedStatement psInsert2 = conn.prepareStatement("insert into buyorders values (?, ?,?,?)");
            statements.add(psInsert2);
            for (i = 1; i < 2; ++i) {
                psInsert2.setInt(1, i);
                psInsert2.setInt(2, i);
                psInsert2.setInt(3, 1);
                psInsert2.setNull(4, 4);
                BugsTest.assertEquals((int)1, (int)psInsert2.executeUpdate());
            }
            int n = s.executeUpdate("update securities set sec_id = sec_id * sec_id , sec_id2 = sec_id2*4 ");
            BugsTest.assertEquals((int)2, (int)n);
        }
        finally {
            i = 0;
            while (!statements.isEmpty()) {
                Statement st = (Statement)statements.remove(i);
                if (st == null) continue;
                st.close();
                st = null;
            }
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug46843_3() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        final ArrayList exceptions = new ArrayList();
        Statement stmt = null;
        String query = "select sid, count(*) from txhistory  where cid>? and sid<? and tid =?  GROUP BY sid HAVING count(*) >=1";
        Connection conn = null;
        Statement derbyStmt = null;
        String table = "create table txhistory(oid int ,cid int,  sid int, qty int, type varchar(10), tid int)";
        String index1 = "create index txhistory_type on txhistory(type)";
        String index2 = "create index txhistory_cid on txhistory(cid)";
        String index3 = "create index txhistory_sid on txhistory(sid)";
        String index4 = "create index txhistory_oid on txhistory(oid)";
        String index5 = "create index txhistory_tid on txhistory(tid)";
        try {
            String tempDerbyUrl = "jdbc:derby:newDB;create=true;";
            if (TestUtil.currentUserName != null) {
                tempDerbyUrl = tempDerbyUrl + "user=" + TestUtil.currentUserName + ";password=" + TestUtil.currentUserPassword + ';';
            }
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            final String derbyDbUrl = tempDerbyUrl;
            Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
            derbyStmt = derbyConn.createStatement();
            derbyStmt.execute(table);
            derbyStmt.execute(index5);
            Statement derbyStmt1 = derbyConn.createStatement();
            conn = TestUtil.getConnection();
            stmt = conn.createStatement();
            stmt.execute(table);
            stmt.execute(index5);
            PreparedStatement ps_insert_derby = derbyConn.prepareStatement("insert into txhistory  values(?,?,?,?,?,?)");
            PreparedStatement ps_insert_gfxd = conn.prepareStatement("insert into txhistory values(?,?,?,?,?,?)");
            ps_insert_derby.setInt(1, 1);
            ps_insert_derby.setInt(2, 1);
            ps_insert_derby.setInt(3, 1);
            ps_insert_derby.setInt(4, 100);
            ps_insert_derby.setNull(5, 12);
            ps_insert_derby.setInt(6, 10);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 1);
            ps_insert_gfxd.setInt(2, 1);
            ps_insert_gfxd.setInt(3, 1);
            ps_insert_gfxd.setInt(4, 100);
            ps_insert_gfxd.setNull(5, 12);
            ps_insert_gfxd.setInt(6, 10);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 2);
            ps_insert_derby.setInt(2, 11);
            ps_insert_derby.setInt(3, 3);
            ps_insert_derby.setInt(4, 300);
            ps_insert_derby.setString(5, "sell");
            ps_insert_derby.setInt(6, 10);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 2);
            ps_insert_gfxd.setInt(2, 11);
            ps_insert_gfxd.setInt(3, 3);
            ps_insert_gfxd.setInt(4, 300);
            ps_insert_gfxd.setString(5, "sell");
            ps_insert_gfxd.setInt(6, 10);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 3);
            ps_insert_derby.setInt(2, 11);
            ps_insert_derby.setInt(3, 3);
            ps_insert_derby.setInt(4, 300);
            ps_insert_derby.setString(5, "buy");
            ps_insert_derby.setInt(6, 10);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 3);
            ps_insert_gfxd.setInt(2, 11);
            ps_insert_gfxd.setInt(3, 3);
            ps_insert_gfxd.setInt(4, 300);
            ps_insert_gfxd.setString(5, "buy");
            ps_insert_gfxd.setInt(6, 10);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 7);
            ps_insert_derby.setInt(2, 6);
            ps_insert_derby.setInt(3, 4);
            ps_insert_derby.setInt(4, 2400);
            ps_insert_derby.setNull(5, 12);
            ps_insert_derby.setInt(6, 10);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 7);
            ps_insert_gfxd.setInt(2, 6);
            ps_insert_gfxd.setInt(3, 4);
            ps_insert_gfxd.setInt(4, 2400);
            ps_insert_gfxd.setNull(5, 12);
            ps_insert_gfxd.setInt(6, 10);
            ps_insert_gfxd.executeUpdate();
            ps_insert_derby.setInt(1, 8);
            ps_insert_derby.setInt(2, 12);
            ps_insert_derby.setInt(3, 4);
            ps_insert_derby.setInt(4, 4800);
            ps_insert_derby.setNull(5, 12);
            ps_insert_derby.setInt(6, 10);
            ps_insert_derby.executeUpdate();
            ps_insert_gfxd.setInt(1, 8);
            ps_insert_gfxd.setInt(2, 12);
            ps_insert_gfxd.setInt(3, 4);
            ps_insert_gfxd.setInt(4, 4800);
            ps_insert_gfxd.setNull(5, 12);
            ps_insert_gfxd.setInt(6, 10);
            ps_insert_gfxd.executeUpdate();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        Connection gfxdConn = TestUtil.getConnection();
                        Connection derbyConn = DriverManager.getConnection(derbyDbUrl);
                        PreparedStatement derbyStmt = derbyConn.prepareStatement("select sid, count(*) from txhistory  where cid>? and sid<? and tid =?  GROUP BY sid HAVING count(*) >=1");
                        PreparedStatement stmt = gfxdConn.prepareStatement("select sid, count(*) from txhistory  where cid>? and sid<? and tid =?  GROUP BY sid HAVING count(*) >=1");
                        Random random = new Random();
                        int cid = 10;
                        int sid = 100;
                        stmt.setInt(1, cid);
                        stmt.setInt(2, sid);
                        stmt.setInt(3, 10);
                        derbyStmt.setInt(1, cid);
                        derbyStmt.setInt(2, sid);
                        derbyStmt.setInt(3, 10);
                        TestUtil.validateResults(derbyStmt, stmt, "select sid, count(*) from txhistory  where cid>? and sid<? and tid =?  GROUP BY sid HAVING count(*) >=1", false);
                        String query2 = "select cid, sum(qty) as amount from txhistory  where sid = ?  GROUP BY cid";
                        GemFireXDQueryObserver old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                            public double overrideDerbyOptimizerCostForMemHeapScan(GemFireContainer gfContainer, double optimzerEvalutatedCost) {
                                return Double.MAX_VALUE;
                            }

                            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                                return 1.0;
                            }
                        });
                        stmt = gfxdConn.prepareStatement(query2);
                        derbyStmt = derbyConn.prepareStatement(query2);
                        stmt.setInt(1, 3);
                        derbyStmt.setInt(1, 3);
                        TestUtil.validateResults(derbyStmt, stmt, "select sid, count(*) from txhistory  where cid>? and sid<? and tid =?  GROUP BY sid HAVING count(*) >=1", false);
                    }
                    catch (Throwable th) {
                        exceptions.add(th);
                    }
                }
            };
            runnable.run();
            if (!exceptions.isEmpty()) {
                for (Throwable e : exceptions) {
                    e.printStackTrace();
                }
                BugsTest.fail(((Object)exceptions).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugsTest.fail("Test failed because of exception " + e);
        }
        finally {
            if (derbyStmt != null) {
                try {
                    derbyStmt.execute("drop table txhistory");
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug47114() throws Exception {
        this.reduceLogLevelForTest("config");
        String query = "select sec_id, exchange, s.tid, cid, cust_name, c.tid from trade.securities s, trade.customers c where c.cid = (select f.cid from trade.portfolio f  where c.cid = f.cid and f.tid = 1 group by f.cid having count(*) >= 1) and sec_id in (select sid from trade.portfolio f where availQty > 0 and availQty < 10000) ";
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        try {
            String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
            java.sql.ResultSet rs = null;
            st.execute("create table trade.securities (sec_id int not null, exchange varchar(10) not null,  tid int, constraint sec_pk primary key (sec_id),  constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  replicate");
            PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?)");
            int sec_limit = 200;
            for (int i = 0; i < 200; ++i) {
                psSec.setInt(1, i);
                psSec.setString(2, exchanges[i % exchanges.length]);
                psSec.setInt(3, 1);
                psSec.executeUpdate();
            }
            Random random = new Random(200L);
            st.execute("create table trade.customers (cid int primary key, sid int, cust_name varchar(100), tid int)");
            PreparedStatement psCust = conn.prepareStatement("insert into trade.customers values (?, ?, ?,?)");
            int cust_limit = 200;
            HashMap<Integer, Integer> pfMap = new HashMap<Integer, Integer>();
            for (int i = 1; i < 200; ++i) {
                psCust.setInt(1, i);
                int sec = random.nextInt(200);
                pfMap.put(i, sec);
                psCust.setInt(2, sec);
                psCust.setString(3, "" + i);
                psCust.setInt(4, 1);
                psCust.executeUpdate();
            }
            st.execute(" create table trade.portfolio (cid int not null, sid int not null,  availQty int not null, tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references trade.securities (sec_id) )");
            st.execute(" create index portfolio_cid on trade.portfolio(cid)");
            PreparedStatement psPF = conn.prepareStatement("insert into trade.portfolio values (?, ?,?,?)");
            for (Map.Entry entry : pfMap.entrySet()) {
                psPF.setInt(1, (Integer)entry.getKey());
                psPF.setInt(2, (Integer)entry.getValue());
                psPF.setInt(3, 1000);
                psPF.setInt(4, 1);
                psPF.executeUpdate();
            }
            final boolean[] indexUsed = new boolean[]{false};
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void scanControllerOpened(Object sc, Conglomerate conglom) {
                    SortedMap2Index sortedIndex;
                    GemFireContainer container;
                    if (conglom instanceof SortedMap2Index && (container = (sortedIndex = (SortedMap2Index)conglom).getGemFireContainer()).isLocalIndex() && container.getName().equals("TRADE.6__PORTFOLIO__CID:base-table:TRADE.PORTFOLIO")) {
                        indexUsed[0] = true;
                    }
                }
            });
            rs = st.executeQuery(query);
            int count = 0;
            while (rs.next()) {
                rs.getInt(1);
                ++count;
            }
            BugsTest.assertTrue((boolean)indexUsed[0]);
            BugsTest.assertTrue((count > 5 ? 1 : 0) != 0);
        }
        finally {
            TestUtil.shutDown();
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug45998() throws Exception {
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)true);
        Connection conn = BugsTest.getConnection();
        String subquery = "SELECT b.account_id FROM ap.betting_user_accounts b, ap.account_allowed_bet_type t WHERE b.account_id = t.account_id AND b.account_number='2e7' AND t.allow_bet_type=0 and b.account_id = 744";
        String dml = "UPDATE ap.account_balances SET locked_by = 1 WHERE ap.account_balances.balance_type=0 AND ap.account_balances.account_balance >= 1000 AND ap.account_balances.account_id IN(" + subquery + ")";
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE ap.account_balances (account_id           BIGINT NOT NULL, balance_type         SMALLINT NOT NULL, account_balance          BIGINT NOT NULL, locked_by                INT NOT NULL DEFAULT -1, PRIMARY KEY (account_id, balance_type)) PARTITION BY COLUMN (account_id)");
        st.execute("insert into ap.account_balances values(744, 0, 99992000, -1)");
        st.execute("CREATE TABLE ap.betting_user_accounts(account_id           BIGINT NOT NULL, account_number       CHAR(50) NOT NULL, PRIMARY KEY (account_id)) PARTITION BY COLUMN (account_id)");
        st.execute("insert into ap.betting_user_accounts values(744, '2e7')");
        st.execute("CREATE TABLE ap.account_allowed_bet_type(account_id           BIGINT NOT NULL, allow_bet_type       SMALLINT NOT NULL, FOREIGN KEY (account_id) REFERENCES ap.betting_user_accounts (account_id)) PARTITION BY COLUMN (account_id) COLOCATE WITH (ap.betting_user_accounts)");
        st.execute("CREATE UNIQUE INDEX betting_user_accounts_udx01 ON ap.betting_user_accounts(account_number)");
        st.execute("insert into ap.account_allowed_bet_type values(744, 0)");
        LanguageConnectionContext lcc = ((EmbedConnection)jdbcConn).getLanguageConnection();
        GemFireXDQueryObserver old = null;
        try {
            old = GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter(){

                public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
                    if (qInfo instanceof SelectQueryInfo && ((SelectQueryInfo)qInfo).isSubQuery()) {
                        BugsTest.this.callbackInvoked = true;
                        TestCase.assertTrue((boolean)(qInfo instanceof SelectQueryInfo));
                        if (qInfo.getParameterCount() == 0) {
                            SelectQueryInfo sqi = (SelectQueryInfo)qInfo;
                            HashSet<Object> actualRoutingKeys = new HashSet<Object>();
                            actualRoutingKeys.add(ResolverUtils.TOK_ALL_NODES);
                            try {
                                GemFireSelectActivation act = new GemFireSelectActivation((ExecPreparedStatement)gps, lcc, (DMLQueryInfo)qInfo, null, false);
                                ((BaseActivation)act).initFromContext(lcc, true, (ExecPreparedStatement)gps);
                                sqi.computeNodes(actualRoutingKeys, (Activation)act, false);
                                TestCase.assertFalse((boolean)actualRoutingKeys.isEmpty());
                                TestCase.assertTrue((boolean)actualRoutingKeys.contains(744));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                TestUtil.fail(e.toString());
                            }
                        }
                    }
                }
            });
            try {
                st.execute(dml);
            }
            catch (SQLException e) {
                throw new SQLException(e.toString() + " Exception in executing query = " + dml, e.getSQLState());
            }
            BugsTest.assertTrue((boolean)this.callbackInvoked);
        }
        finally {
            this.callbackInvoked = false;
            if (old != null) {
                GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)old);
            }
        }
    }

    public void testBug48245() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table app.test1(col1 int, col2 int, constraint p1_pk primary key (col1))");
        st.execute("insert into app.test1 values (1, 1)");
        PreparedStatement pst = conn.prepareStatement("update app.test1 set col2 = ? where col1 = ?");
        for (int i = 2; i <= 5; ++i) {
            pst.setInt(1, i);
            pst.setInt(2, 1);
            pst.addBatch();
        }
        pst.executeBatch();
        conn.commit();
        java.sql.ResultSet rs = st.executeQuery("select col2 from app.test1 where col1 = 1");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((int)5, (int)rs.getInt(1));
        BugsTest.assertFalse((boolean)rs.next());
    }

    public void test46976() throws Exception {
        BugsTest.getConnection(new Properties());
        GemFireCacheImpl cache = Misc.getGemFireCache();
        AttributesFactory fact = new AttributesFactory();
        fact.setDataPolicy(DataPolicy.PARTITION);
        PartitionedRegion pr = (PartitionedRegion)cache.createRegion("myPR", fact.create());
        pr.put((Object)1, (Object)"one");
        pr.invalidate((Object)1);
        HashSet<Integer> buckets = new HashSet<Integer>();
        buckets.add(1);
        LocalDataSet lds = new LocalDataSet(pr, buckets, null);
        BugsTest.assertTrue((lds.get((Object)1) == null ? 1 : 0) != 0);
    }

    public void testBug47289_1() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  replicate");
        PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?, ?)");
        DataGenerator dg = new DataGenerator();
        for (int i = 1; i < 2; ++i) {
            dg.insertIntoSecurities(psSec, i);
        }
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange))");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        rs = st.executeQuery("select * from trade.securities");
        int k = 0;
        while (rs.next()) {
            String symbol = rs.getString(2);
            String exchange = rs.getString(4);
            dg.insertIntoCompanies(psComp, symbol, exchange);
            ++k;
        }
        BugsTest.assertTrue((k >= 1 ? 1 : 0) != 0);
        st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict");
    }

    public void testBug47289_2() throws Exception {
        block4: {
            Properties props = new Properties();
            int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            props.put("mcast-port", String.valueOf(mcastPort));
            Connection conn = TestUtil.getConnection(props);
            Statement st = conn.createStatement();
            java.sql.ResultSet rs = null;
            st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
            st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
            st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by column (symbol) ");
            PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?, ?)");
            DataGenerator dg = new DataGenerator();
            for (int i = 1; i < 2; ++i) {
                dg.insertIntoSecurities(psSec, i);
            }
            st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange))");
            PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
            rs = st.executeQuery("select * from trade.securities");
            int k = 0;
            while (rs.next()) {
                String symbol = rs.getString(2);
                String exchange = rs.getString(4);
                dg.insertIntoCompanies(psComp, symbol, exchange);
                ++k;
            }
            BugsTest.assertTrue((k >= 1 ? 1 : 0) != 0);
            try {
                st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict");
                BugsTest.fail("FK constraint addition should fail");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("0A000")) break block4;
                throw sqle;
            }
        }
    }

    public void testBug47289_4() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        Object rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by column (symbol) ");
        PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?, ?)");
        DataGenerator dg = new DataGenerator();
        for (int i = 1; i < 2; ++i) {
            dg.insertIntoSecurities(psSec, i);
        }
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange))");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict");
    }

    public void testBug47289_5() throws Exception {
        block4: {
            Properties props = new Properties();
            int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            props.put("mcast-port", String.valueOf(mcastPort));
            Connection conn = TestUtil.getConnection(props);
            Statement st = conn.createStatement();
            java.sql.ResultSet rs = null;
            st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
            st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
            st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by column (symbol) ");
            PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?, ?)");
            DataGenerator dg = new DataGenerator();
            for (int i = 1; i < 2; ++i) {
                dg.insertIntoSecurities(psSec, i);
            }
            st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, symbol1 varchar(10) not null, tid int, constraint comp_pk primary key (symbol, exchange)) partition by column ( symbol) colocate with (trade.securities)");
            PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, symbol1 , tid) values (?,?,?,?)");
            rs = st.executeQuery("select * from trade.securities");
            int k = 0;
            while (rs.next()) {
                String symbol = rs.getString(2);
                String exchange = rs.getString(4);
                psComp.setString(1, symbol);
                psComp.setString(2, exchange);
                psComp.setString(3, symbol);
                psComp.setInt(4, 10);
                psComp.executeUpdate();
                ++k;
            }
            BugsTest.assertTrue((k >= 1 ? 1 : 0) != 0);
            try {
                st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol1, exchange) references trade.securities (symbol, exchange) on delete restrict");
                BugsTest.fail("FK constraint addition should fail");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("0A000")) break block4;
                throw sqle;
            }
        }
    }

    public void testBug47289_6() throws Exception {
        block4: {
            Properties props = new Properties();
            int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
            props.put("mcast-port", String.valueOf(mcastPort));
            Connection conn = TestUtil.getConnection(props);
            Statement st = conn.createStatement();
            java.sql.ResultSet rs = null;
            st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
            st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
            st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by column (symbol, exchange) ");
            PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?, ?)");
            DataGenerator dg = new DataGenerator();
            for (int i = 1; i < 2; ++i) {
                dg.insertIntoSecurities(psSec, i);
            }
            st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, symbol1 varchar(10) not null, tid int, constraint comp_pk primary key (symbol, exchange)) partition by column ( symbol, exchange) colocate with (trade.securities)");
            PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, symbol1 , tid) values (?,?,?,?)");
            rs = st.executeQuery("select * from trade.securities");
            int k = 0;
            while (rs.next()) {
                String symbol = rs.getString(2);
                String exchange = rs.getString(4);
                psComp.setString(1, symbol);
                psComp.setString(2, exchange);
                psComp.setString(3, symbol);
                psComp.setInt(4, 10);
                psComp.executeUpdate();
                ++k;
            }
            BugsTest.assertTrue((k >= 1 ? 1 : 0) != 0);
            try {
                st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol1, exchange) references trade.securities (symbol, exchange) on delete restrict");
                BugsTest.fail("FK constraint addition should fail");
            }
            catch (SQLException sqle) {
                if (sqle.getSQLState().equals("0A000")) break block4;
                throw sqle;
            }
        }
    }

    public void testBug47289_3() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        java.sql.ResultSet rs = null;
        st.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        st.execute("CREATE TYPE trade.UUID EXTERNAL NAME 'java.util.UUID' LANGUAGE JAVA");
        st.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse'))) partition by column (exchange) ");
        PreparedStatement psSec = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?, ?)");
        DataGenerator dg = new DataGenerator();
        for (int i = 1; i < 2; ++i) {
            dg.insertIntoSecurities(psSec, i);
        }
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid trade.UUID, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, asset bigint, logo varchar(100) for bit data, tid int, constraint comp_pk primary key (symbol, exchange)) partition by column(exchange) colocate with ( trade.securities)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histprice, asset, logo, tid) values (?,?,?,?,?,?,?,?,?,?,?,?)");
        rs = st.executeQuery("select * from trade.securities");
        int k = 0;
        while (rs.next()) {
            String symbol = rs.getString(2);
            String exchange = rs.getString(4);
            dg.insertIntoCompanies(psComp, symbol, exchange);
            ++k;
        }
        BugsTest.assertTrue((k >= 1 ? 1 : 0) != 0);
        st.execute("alter table trade.companies add constraint comp_fk foreign key (symbol, exchange) references trade.securities (symbol, exchange) on delete restrict");
    }

    public void testBug47426() throws Exception {
        Connection conn = BugsTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (cid int not null GENERATED BY DEFAULT AS IDENTITY (INCREMENT BY 1 ), cust_name varchar(100), since date, addr varchar(100), tid int, primary key (cid))   REDUNDANCY 1");
        stmt.execute("alter table trade.customers ALTER column cid SET GENERATED ALWAYS AS IDENTITY");
        stmt.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))  partition by range (price) (VALUES BETWEEN 0.0 AND 25.0,  VALUES BETWEEN 25.0  AND 35.0 , VALUES BETWEEN 35.0  AND 49.0, VALUES BETWEEN 49.0  AND 69.0 , VALUES BETWEEN 69.0 AND 100.0)  REDUNDANCY 1");
        stmt.execute("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, subTotal decimal(30,20), tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint sec_fk foreign key (sid) references trade.securities (sec_id) on delete restrict, constraint qty_ck check (qty>=0), constraint avail_ch check (availQty>=0 and availQty<=qty))   REDUNDANCY 1");
        BugsTest.shutDown();
        conn = BugsTest.getConnection();
        GfxdIndexManager indexManager = (GfxdIndexManager)((LocalRegion)Misc.getRegion((String)"/TRADE/PORTFOLIO", (boolean)true, (boolean)false)).getIndexUpdater();
        List indexes = indexManager.getAllIndexes();
        BugsTest.assertEquals((int)2, (int)indexes.size());
        boolean foundCID = false;
        boolean foundSID = false;
        for (GemFireContainer c : indexes) {
            if (!foundCID) {
                foundCID = c.getQualifiedTableName().contains("__PORTFOLIO__CID");
            }
            if (foundSID) continue;
            foundSID = c.getQualifiedTableName().contains("__PORTFOLIO__SID");
        }
        BugsTest.assertTrue((boolean)foundCID);
        BugsTest.assertTrue((boolean)foundSID);
    }

    public void testBugs47389() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, companyname varchar(100), constraint comp_pk primary key (symbol, exchange))");
        st.execute("insert into trade.companies values('vmw', 'nasdaq', 0, 'vmware')");
        PreparedStatement ps2 = conn.prepareStatement("update trade.companies set companytype = ? where symbol = ? and exchange in ('tse', 'nasdaq')");
        ps2.setInt(1, 1);
        ps2.setString(2, "vmw");
        int count = ps2.executeUpdate();
        BugsTest.assertEquals((int)1, (int)count);
        st.execute("select * from trade.companies");
        java.sql.ResultSet rs = st.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((int)1, (int)rs.getInt(3));
        BugsTest.assertFalse((boolean)rs.next());
    }

    public void testUseCase10IndexUsage() throws Exception {
        if (isTransactional) {
            return;
        }
        this.reduceLogLevelForTest("config");
        SelectQueryInfo.setTestFlagIgnoreSingleVMCriteria((boolean)false);
        Properties props = new Properties();
        props.setProperty("log-level", "config");
        props.setProperty("table-default-partitioned", "false");
        Connection conn = BugsTest.getConnection(props);
        String resourcesDir = BugsTest.getResourcesDir();
        String indexScript = resourcesDir + "/lib/useCase10/04_indices_gemfirexd.sql";
        String schemaScript = resourcesDir + "/lib/useCase10/02_ddl_gemfirexd_2.sql";
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{schemaScript}, (boolean)false, (Logger)BugsTest.getLogger(), null, null, (boolean)false);
        Statement stmt = conn.createStatement();
        String query = "SELECT     d.NOM_MES,tp.NOM_TIPO_PRODUTO,SUM(VLR_ITEM_NF) as SUM_VLR_NF FROM    APP.ITEM_NOTA_FISCAL n INNER JOIN  APP.TIPO_PRODUTO tp ON (tp.COD_TIPO_PRODUTO = n.COD_TIPO_PRODUTO) INNER JOIN  APP.PRODUTO p ON (n.COD_PRODUTO = p.COD_PRODUTO AND n.COD_TIPO_PRODUTO = p.COD_TIPO_PRODUTO )INNER JOIN    APP.TEMPO d ON (n.DAT_DIA = d.DAT_DIA)  GROUP BY    d.NOM_MES, tp.NOM_TIPO_PRODUTO;";
        stmt.execute("TRUNCATE TABLE APP.ITEM_NOTA_FISCAL");
        stmt.execute("TRUNCATE TABLE APP.NOTA_FISCAL");
        stmt.execute("TRUNCATE TABLE APP.TEMPO");
        stmt.execute("TRUNCATE TABLE APP.VENDEDOR");
        stmt.execute("TRUNCATE TABLE APP.REVENDA");
        stmt.execute("TRUNCATE TABLE APP.PRODUTO");
        stmt.execute("TRUNCATE TABLE APP.TIPO_PRODUTO");
        stmt.execute("TRUNCATE TABLE APP.CLIENTE");
        int numRows = 0;
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE ( 'APP','CLIENTE','" + resourcesDir + "/lib/useCase10/dm_cliente.dat', ';', null, null, 0)");
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE ( 'APP','TIPO_PRODUTO', '" + resourcesDir + "/lib/useCase10/dm_tipo_prod.dat', ';', null, null, 0)");
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE ( 'APP','PRODUTO', '" + resourcesDir + "/lib/useCase10/dm_prod.dat', ';', null, null, 0)");
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE ( 'APP','REVENDA', '" + resourcesDir + "/lib/useCase10/dm_revenda.dat', ';', null, null, 0)");
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE ( 'APP','VENDEDOR', '" + resourcesDir + "/lib/useCase10/dm_vendedor.dat', ';', null, null, 0)");
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE ( 'APP','TEMPO', '" + resourcesDir + "/lib/useCase10/dm_tempo.dat', ';', null, null, 0)");
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE ( 'APP','NOTA_FISCAL', '" + resourcesDir + "/lib/useCase10/dm_nf.dat', ';', null, null, 0)");
        stmt.execute("CALL SYSCS_UTIL.IMPORT_TABLE ( 'APP','ITEM_NOTA_FISCAL', '" + resourcesDir + "/lib/useCase10/dm_item_nf.dat', ';', null, null, 0)");
        long start = System.currentTimeMillis();
        java.sql.ResultSet rs = stmt.executeQuery(query);
        numRows = 0;
        while (rs.next()) {
            ++numRows;
        }
        long end = System.currentTimeMillis();
        BugsTest.assertTrue((numRows > 0 ? 1 : 0) != 0);
        long timeTakenInSec = (end - start) / 1000L;
        BugsTest.getLogger().info((Object)("time taken to execute query=" + timeTakenInSec + " seconds."));
        BugsTest.assertTrue((timeTakenInSec < 10L ? 1 : 0) != 0);
    }

    public void testMultipleRowsUpdate() throws Exception {
        Connection conn = BugsTest.getConnection();
        this.runTestMultipleRowsUpdate(conn);
        conn.close();
        Connection netConn = BugsTest.startNetserverAndGetLocalNetConnection();
        this.runTestMultipleRowsUpdate(netConn);
        netConn.close();
    }

    public void testBug46799() throws Exception {
        Connection conn = TestUtil.getConnection();
        int netPort = TestUtil.startNetserverAndReturnPort();
        Connection conn2 = TestUtil.getNetConnection(netPort, null, null);
        Statement st = conn.createStatement();
        Statement st2 = conn2.createStatement();
        st.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, uid CHAR(16) FOR BIT DATA, uuid char(36), companyname char(100), companyinfo clob, note long varchar, histprice decimal(20,5), asset bigint, logo varchar(100) for bit data, tid int, pvt blob, constraint comp_pk primary key (symbol, exchange)) partition by column(logo)");
        PreparedStatement psComp = conn.prepareStatement("insert into trade.companies (symbol, exchange, companytype, uid, uuid, companyname, companyInfo, note, histprice, asset, logo, tid, pvt) values (?,?,?,?,?,?,?,?,?,?,?,?,?)");
        Random rnd = PartitionedRegion.rand;
        char[] clobChars = new char[10000];
        byte[] blobBytes = new byte[20000];
        char[] chooseChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_".toCharArray();
        for (int i = 0; i < clobChars.length; ++i) {
            clobChars[i] = chooseChars[rnd.nextInt(chooseChars.length)];
        }
        rnd.nextBytes(blobBytes);
        SerialClob clob = new SerialClob(clobChars);
        SerialBlob blob = new SerialBlob(blobBytes);
        Object[] row = new Object[]{"mzto109", "fse", (short)8, new byte[]{62, -73, -54, 72, 34, -24, 69, -63, -110, 24, 50, 105, 62, 53, -17, -90}, "3eb7ca48-22e8-45c1-9218-32693e35efa6", "`8vCV`;=h;6s/W$e 0h0^eh", clob, "BB(BfoRJWVYh'&6dU `gb2*||Yz>=2+!:7C jz->F1}V", "50.29", 8397740485201787197L, new byte[]{127, -18, -85, 16, 79, 86, 50, 90, -70, 121, -38, -97, -114, -62, -54, -43, 109, -14, -22, 62, -70, 51, 71, -17, 83, -70, 21, 126, -73, -113, -7, 121, 43, -24, -53, -44, 38, -93, -87, -86, 13, -61, -7, -47, 37, 18, -51, 101, 47, 34, -14, 77, 45, 70, -123, 7, -117, -36, 35, 73, 73, 127, 117, 17}, 109, blob};
        int col = 1;
        for (Object o : row) {
            psComp.setObject(col, o);
            ++col;
        }
        psComp.executeUpdate();
        java.sql.ResultSet rs = st.executeQuery("select symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histPrice, asset, logo, tid, pvt from TRADE.COMPANIES where tid >= 105 and tid < 110");
        BugsTest.checkLobs(rs, clobChars, blobBytes);
        rs = st2.executeQuery("select symbol, exchange, companytype, uid, uuid, companyname, companyinfo, note, histPrice, asset, logo, tid, pvt from TRADE.COMPANIES where tid >= 105 and tid < 110");
        BugsTest.checkLobs(rs, clobChars, blobBytes);
    }

    public void testSecuritasException_1() throws Exception {
        TestUtil.getConnection();
        int netPort = TestUtil.startNetserverAndReturnPort();
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        Statement st = conn.createStatement();
        st.execute("create table test (id int, time1 timestamp, time2 timestamp)");
        PreparedStatement psComp = conn.prepareStatement("insert into test  values (?,?,?)");
        String createProcUpdateSQLStr_WITH_MODIFIES = "CREATE PROCEDURE PROC_UPDATE_SQL_WITH_MODIFIES(time Timestamp) LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procSecuritasBug' ";
        st.execute(createProcUpdateSQLStr_WITH_MODIFIES);
        Random rnd = PartitionedRegion.rand;
        char[] clobChars = new char[10000];
        byte[] blobBytes = new byte[20000];
        char[] chooseChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890_".toCharArray();
        for (int i = 0; i < clobChars.length; ++i) {
            clobChars[i] = chooseChars[rnd.nextInt(chooseChars.length)];
        }
        rnd.nextBytes(blobBytes);
        SerialClob clob = new SerialClob(clobChars);
        SerialBlob blob = new SerialBlob(blobBytes);
        Object[] row = new Object[]{"mzto109", "fse", (short)8, new byte[]{62, -73, -54, 72, 34, -24, 69, -63, -110, 24, 50, 105, 62, 53, -17, -90}, "3eb7ca48-22e8-45c1-9218-32693e35efa6", "`8vCV`;=h;6s/W$e 0h0^eh", clob, "BB(BfoRJWVYh'&6dU `gb2*||Yz>=2+!:7C jz->F1}V", "50.29", 8397740485201787197L, new byte[]{127, -18, -85, 16, 79, 86, 50, 90, -70, 121, -38, -97, -114, -62, -54, -43, 109, -14, -22, 62, -70, 51, 71, -17, 83, -70, 21, 126, -73, -113, -7, 121, 43, -24, -53, -44, 38, -93, -87, -86, 13, -61, -7, -47, 37, 18, -51, 101, 47, 34, -14, 77, 45, 70, -123, 7, -117, -36, 35, 73, 73, 127, 117, 17}, 109, blob};
        boolean col = true;
        psComp.setInt(1, 1);
        psComp.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        psComp.setNull(3, 93);
        psComp.executeUpdate();
        CallableStatement update = conn.prepareCall("call PROC_UPDATE_SQL_WITH_MODIFIES(?)");
        update.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
        update.execute();
    }

    public void _testSecuritasException_2() throws Exception {
        Connection embedded = TestUtil.getConnection();
        int netPort = TestUtil.startNetserverAndReturnPort();
        Connection conn = TestUtil.getNetConnection(netPort, null, null);
        Statement st = conn.createStatement();
        Statement embeddedStmt = embedded.createStatement();
        embeddedStmt.execute("create table test (id int, time1 timestamp, time2 timestamp default null, text  clob)");
        PreparedStatement psComp = embedded.prepareStatement("insert into test(id,time1, time2, text)  values (?,?,?,?)");
        String createProcSQLStr = "CREATE PROCEDURE PROC_SQL() LANGUAGE JAVA PARAMETER STYLE JAVA EXTERNAL NAME '" + ProcedureTest.class.getName() + ".procSecuritasBug_2' DYNAMIC RESULT SETS 1";
        st.execute(createProcSQLStr);
        boolean col = true;
        psComp.setInt(1, 1);
        psComp.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
        psComp.setNull(3, 93);
        psComp.setNull(4, 2005);
        psComp.executeUpdate();
        CallableStatement sql = conn.prepareCall("call PROC_SQL()");
        sql.execute();
        java.sql.ResultSet rs = sql.getResultSet();
        while (rs.next()) {
            rs.getTimestamp(1);
        }
    }

    public void testBug48010_1() throws Exception {
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Properties props = new Properties();
        props.setProperty("server-groups", "SG1");
        Connection conn = null;
        conn = BugsTest.getConnection(props);
        conn.setTransactionIsolation(2);
        s = conn.createStatement();
        String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, time timestamp, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))";
        String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        s.execute(tab1);
        psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?,?)");
        for (int i = -30; i < 0; ++i) {
            psInsert4.setInt(1, i);
            psInsert4.setString(2, "symbol" + i * -1);
            psInsert4.setFloat(3, (float)i * 131.46f);
            psInsert4.setString(4, exchange[5]);
            psInsert4.setInt(5, 2);
            psInsert4.setDate(6, new Date(System.currentTimeMillis()));
            BugsTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
        }
        conn.commit();
        s.execute("create index sec_price on trade.securities(price)");
        s.execute("create index sec_id on trade.securities(sec_id)");
        s.execute("create index sec_tid on trade.securities(tid)");
        s.execute("create index sec_exchange on trade.securities(exchange)");
        GemFireXDQueryObserverAdapter observer = new GemFireXDQueryObserverAdapter(){

            public double overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(OpenMemIndex memIndex, double optimzerEvalutatedCost) {
                if (memIndex.getGemFireContainer().getTableName().toLowerCase().indexOf("sec_price") != -1) {
                    return Double.MAX_VALUE;
                }
                return Double.MIN_VALUE;
            }
        };
        GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)observer);
        String query = "select tid, exchange from trade.securities where (price<? or price >=?)";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setFloat(1, 50.0f);
        ps.setFloat(2, 60.0f);
        java.sql.ResultSet rs = ps.executeQuery();
        int numRows = 0;
        while (rs.next()) {
            rs.getInt(1);
            ++numRows;
        }
        BugsTest.assertEquals((int)30, (int)numRows);
    }

    public void testBug48010_2() throws Exception {
        PreparedStatement psInsert4 = null;
        Statement s = null;
        Properties props = new Properties();
        props.setProperty("server-groups", "SG1");
        Connection conn = null;
        conn = BugsTest.getConnection(props);
        conn.setTransactionIsolation(2);
        s = conn.createStatement();
        String tab1 = " create table trade.securities (sec_id int not null, symbol varchar(10) not null, price decimal (30, 20), exchange varchar(10) not null, tid int, time timestamp, constraint sec_pk primary key (sec_id), constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))";
        String[] exchange = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        s.execute(tab1);
        psInsert4 = conn.prepareStatement("insert into trade.securities values (?, ?, ?,?,?,?)");
        for (int i = -30; i < 0; ++i) {
            psInsert4.setInt(1, i);
            psInsert4.setString(2, "symbol" + i * -1);
            psInsert4.setFloat(3, (float)i * 131.46f);
            psInsert4.setString(4, exchange[5]);
            psInsert4.setInt(5, i * -2);
            psInsert4.setDate(6, new Date(System.currentTimeMillis()));
            BugsTest.assertEquals((int)1, (int)psInsert4.executeUpdate());
        }
        conn.commit();
        s.execute("create index sec_price on trade.securities(price)");
        s.execute("create index sec_id on trade.securities(sec_id)");
        s.execute("create index sec_tid on trade.securities(tid)");
        s.execute("create index sec_exchange on trade.securities(exchange)");
        String query = "select tid, exchange from trade.securities where (price >? or tid >=?)";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setFloat(1, -132.0f);
        ps.setFloat(2, 59.0f);
        java.sql.ResultSet rs = ps.executeQuery();
        int numRows = 0;
        while (rs.next()) {
            rs.getInt(1);
            ++numRows;
        }
        BugsTest.assertEquals((int)2, (int)numRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysRoutinePermissions_48279() throws Throwable {
        Throwable sqle;
        Statement stmt2;
        Statement stmt;
        int netPort;
        block86: {
            java.sql.ResultSet rs;
            block85: {
                block84: {
                    block83: {
                        block82: {
                            block81: {
                                Properties props;
                                block80: {
                                    block79: {
                                        block78: {
                                            block77: {
                                                block76: {
                                                    block75: {
                                                        Statement stmt3;
                                                        Connection conn3;
                                                        block74: {
                                                            block73: {
                                                                block72: {
                                                                    block71: {
                                                                        block70: {
                                                                            block69: {
                                                                                block68: {
                                                                                    block67: {
                                                                                        block66: {
                                                                                            System.setProperty("gemfire.off-heap-memory-size", "500m");
                                                                                            props = new Properties();
                                                                                            props.setProperty("auth-provider", "BUILTIN");
                                                                                            props.setProperty("gemfirexd.user.admin", "pass");
                                                                                            props.setProperty("user", "admin");
                                                                                            props.setProperty("password", "pass");
                                                                                            BugsTest.setupConnection(props);
                                                                                            netPort = BugsTest.startNetserverAndReturnPort();
                                                                                            props.clear();
                                                                                            props.setProperty("user", "admin");
                                                                                            props.setProperty("password", "pass");
                                                                                            Connection conn = TestUtil.getNetConnection(netPort, null, props);
                                                                                            stmt = conn.createStatement();
                                                                                            stmt.execute("call sys.create_user('scott', 'pass')");
                                                                                            props.clear();
                                                                                            props.setProperty("user", "scott");
                                                                                            props.setProperty("password", "pass");
                                                                                            Connection conn2 = TestUtil.getNetConnection(netPort, null, props);
                                                                                            stmt2 = conn2.createStatement();
                                                                                            try {
                                                                                                stmt2.execute("call sys.create_user('ramesh', 'pass')");
                                                                                                BugsTest.fail("expected create_user to fail");
                                                                                            }
                                                                                            catch (SQLException sqle2) {
                                                                                                if ("42504".equals(sqle2.getSQLState())) break block66;
                                                                                                throw sqle2;
                                                                                            }
                                                                                        }
                                                                                        props.clear();
                                                                                        props.setProperty("user", "ramesh");
                                                                                        props.setProperty("password", "pass");
                                                                                        try {
                                                                                            TestUtil.getConnection(props);
                                                                                            BugsTest.fail("expected connection to fail with auth exception");
                                                                                        }
                                                                                        catch (SQLException sqle3) {
                                                                                            if ("08004".equals(sqle3.getSQLState())) break block67;
                                                                                            throw sqle3;
                                                                                        }
                                                                                    }
                                                                                    stmt.execute("GRANT execute on procedure sys.create_user to scott");
                                                                                    stmt2.execute("call sys.create_user('ramesh', 'pass')");
                                                                                    try {
                                                                                        stmt.execute("call sys.create_user('RaMesh', 'pASS')");
                                                                                        BugsTest.fail("expected create_user to fail with user already exists");
                                                                                    }
                                                                                    catch (SQLException sqle4) {
                                                                                        if ("28504".equals(sqle4.getSQLState())) break block68;
                                                                                        throw sqle4;
                                                                                    }
                                                                                }
                                                                                conn3 = TestUtil.getConnection(props);
                                                                                stmt3 = conn3.createStatement();
                                                                                try {
                                                                                    stmt3.execute("call sys.create_user('chen', 'pass2')");
                                                                                    BugsTest.fail("expected create_user to fail");
                                                                                }
                                                                                catch (SQLException sqle5) {
                                                                                    if ("42504".equals(sqle5.getSQLState())) break block69;
                                                                                    throw sqle5;
                                                                                }
                                                                            }
                                                                            try {
                                                                                stmt2.execute("GRANT execute on procedure sys.create_user to ramesh");
                                                                                BugsTest.fail("expected grant to fail");
                                                                            }
                                                                            catch (SQLException sqle6) {
                                                                                if ("42506".equals(sqle6.getSQLState())) break block70;
                                                                                throw sqle6;
                                                                            }
                                                                        }
                                                                        stmt.execute("GRANT execute on procedure sys.create_user to Ramesh");
                                                                        stmt3.execute("call sys.create_user('chen', 'pass2')");
                                                                        props.clear();
                                                                        props.setProperty("user", "chen");
                                                                        props.setProperty("password", "pass2");
                                                                        TestUtil.getConnection(props);
                                                                        stmt.execute("revoke execute on procedure sys.create_user from ramesh restrict");
                                                                        try {
                                                                            stmt3.execute("call sys.create_user('chen2', 'pass2')");
                                                                            BugsTest.fail("expected create_user to fail");
                                                                        }
                                                                        catch (SQLException sqle7) {
                                                                            if ("42504".equals(sqle7.getSQLState())) break block71;
                                                                            throw sqle7;
                                                                        }
                                                                    }
                                                                    stmt2.execute("call sys.create_user('chen2', 'pass2')");
                                                                    try {
                                                                        stmt2.execute("call sys.change_password('ramesh', 'pass', 'pass2')");
                                                                        BugsTest.fail("expected authz exception");
                                                                    }
                                                                    catch (SQLException sqle8) {
                                                                        if ("42504".equals(sqle8.getSQLState())) break block72;
                                                                        throw sqle8;
                                                                    }
                                                                }
                                                                stmt.execute("GRANT execute on procedure sys.change_password to scott");
                                                                stmt2.execute("call sys.change_password('ramesh', 'pass', 'pass2')");
                                                                props.clear();
                                                                props.setProperty("user", "RAMESH");
                                                                props.setProperty("password", "pass");
                                                                try {
                                                                    TestUtil.getConnection(props);
                                                                    BugsTest.fail("expected auth exception");
                                                                }
                                                                catch (SQLException sqle9) {
                                                                    if ("08004".equals(sqle9.getSQLState())) break block73;
                                                                    throw sqle9;
                                                                }
                                                            }
                                                            props.setProperty("password", "pass2");
                                                            conn3.close();
                                                            conn3 = TestUtil.getConnection(props);
                                                            stmt3 = conn3.createStatement();
                                                            try {
                                                                stmt3.execute("call sys.change_password('ramesh', 'pass', 'pass3')");
                                                                BugsTest.fail("expected exception due to old password mismatch");
                                                            }
                                                            catch (SQLException sqle10) {
                                                                if ("08004".equals(sqle10.getSQLState())) break block74;
                                                                throw sqle10;
                                                            }
                                                        }
                                                        stmt3.execute("call sys.change_password('Ramesh', 'pass2', 'pass3')");
                                                        conn3.close();
                                                        try {
                                                            TestUtil.getConnection(props);
                                                            BugsTest.fail("expected auth exception");
                                                        }
                                                        catch (SQLException sqle11) {
                                                            if ("08004".equals(sqle11.getSQLState())) break block75;
                                                            throw sqle11;
                                                        }
                                                    }
                                                    props.setProperty("password", "pass3");
                                                    TestUtil.getConnection(props);
                                                    try {
                                                        stmt2.execute("call sys.change_password('ramesh', 'p', 'pass4')");
                                                        BugsTest.fail("expected exception due to old password mismatch");
                                                    }
                                                    catch (SQLException sqle12) {
                                                        if ("08004".equals(sqle12.getSQLState())) break block76;
                                                        throw sqle12;
                                                    }
                                                }
                                                TestUtil.getConnection(props);
                                                stmt2.execute("call sys.change_password('ramesh', null, 'pass4')");
                                                try {
                                                    TestUtil.getConnection(props);
                                                    BugsTest.fail("expected auth exception");
                                                }
                                                catch (SQLException sqle13) {
                                                    if ("08004".equals(sqle13.getSQLState())) break block77;
                                                    throw sqle13;
                                                }
                                            }
                                            props.setProperty("password", "pass4");
                                            TestUtil.getConnection(props);
                                            try {
                                                stmt.execute("call sys.change_password('ramesh', 'p', 'pass5')");
                                                BugsTest.fail("expected auth exception");
                                            }
                                            catch (SQLException sqle14) {
                                                if ("08004".equals(sqle14.getSQLState())) break block78;
                                                throw sqle14;
                                            }
                                        }
                                        TestUtil.getConnection(props);
                                        stmt.execute("call sys.change_password('raMesh', null, 'pass5')");
                                        try {
                                            TestUtil.getConnection(props);
                                            BugsTest.fail("expected auth exception");
                                        }
                                        catch (SQLException sqle15) {
                                            if ("08004".equals(sqle15.getSQLState())) break block79;
                                            throw sqle15;
                                        }
                                    }
                                    props.setProperty("password", "pass5");
                                    TestUtil.getConnection(props);
                                    try {
                                        stmt2.execute("call sys.drop_user('chen')");
                                        BugsTest.fail("expected authz exception");
                                    }
                                    catch (SQLException sqle16) {
                                        if ("42504".equals(sqle16.getSQLState())) break block80;
                                        throw sqle16;
                                    }
                                }
                                stmt.execute("GRANT execute on procedure sys.drop_user to scott");
                                props.clear();
                                props.setProperty("user", "chen");
                                props.setProperty("password", "pass2");
                                TestUtil.getConnection(props);
                                stmt2.execute("call sys.drop_user('chen')");
                                try {
                                    TestUtil.getNetConnection(netPort, null, props);
                                    BugsTest.fail("expected auth exception");
                                }
                                catch (SQLException sqle17) {
                                    if ("08004".equals(sqle17.getSQLState())) break block81;
                                    throw sqle17;
                                }
                            }
                            try {
                                stmt2.execute("call SYS.SET_CRITICAL_HEAP_PERCENTAGE(92.0)");
                                BugsTest.fail("expected authz exception");
                            }
                            catch (SQLException sqle18) {
                                if ("42504".equals(sqle18.getSQLState())) break block82;
                                throw sqle18;
                            }
                        }
                        stmt.execute("GRANT execute on procedure sys.set_critical_heap_percentage to scott");
                        stmt2.execute("call SYS.SET_CRITICAL_HEAP_PERCENTAGE(92.0)");
                        rs = stmt2.executeQuery("values SYS.GET_CRITICAL_HEAP_PERCENTAGE()");
                        BugsTest.assertTrue((boolean)rs.next());
                        BugsTest.assertEquals((int)92, (int)rs.getInt(1));
                        BugsTest.assertFalse((boolean)rs.next());
                        try {
                            stmt2.execute("call SYS.SET_EVICTION_HEAP_PERCENTAGE(70.0)");
                            BugsTest.fail("expected authz exception");
                        }
                        catch (SQLException sqle19) {
                            if ("42504".equals(sqle19.getSQLState())) break block83;
                            throw sqle19;
                        }
                    }
                    stmt.execute("GRANT execute on procedure sys.set_eviction_heap_percentage to scott");
                    stmt2.execute("call SYS.SET_EVICTION_HEAP_PERCENTAGE(70.0)");
                    rs = stmt2.executeQuery("values SYS.GET_EVICTION_HEAP_PERCENTAGE()");
                    BugsTest.assertTrue((boolean)rs.next());
                    BugsTest.assertEquals((int)70, (int)rs.getInt(1));
                    BugsTest.assertFalse((boolean)rs.next());
                    try {
                        stmt2.execute("call SYS.SET_CRITICAL_OFFHEAP_PERCENTAGE(92.0)");
                        BugsTest.fail("expected authz exception");
                    }
                    catch (SQLException sqle20) {
                        if ("42504".equals(sqle20.getSQLState())) break block84;
                        throw sqle20;
                    }
                }
                stmt.execute("GRANT execute on procedure sys.set_critical_offheap_percentage to scott");
                stmt2.execute("call SYS.SET_CRITICAL_OFFHEAP_PERCENTAGE(92.0)");
                rs = stmt2.executeQuery("values SYS.GET_CRITICAL_OFFHEAP_PERCENTAGE()");
                BugsTest.assertTrue((boolean)rs.next());
                BugsTest.assertEquals((int)92, (int)rs.getInt(1));
                BugsTest.assertFalse((boolean)rs.next());
                try {
                    stmt2.execute("call SYS.SET_EVICTION_OFFHEAP_PERCENTAGE(70.0)");
                    BugsTest.fail("expected authz exception");
                }
                catch (SQLException sqle21) {
                    if ("42504".equals(sqle21.getSQLState())) break block85;
                    throw sqle21;
                }
            }
            stmt.execute("GRANT execute on procedure sys.set_eviction_offheap_percentage to scott");
            stmt2.execute("call SYS.SET_EVICTION_OFFHEAP_PERCENTAGE(70.0)");
            rs = stmt2.executeQuery("values SYS.GET_EVICTION_OFFHEAP_PERCENTAGE()");
            BugsTest.assertTrue((boolean)rs.next());
            BugsTest.assertEquals((int)70, (int)rs.getInt(1));
            BugsTest.assertFalse((boolean)rs.next());
            try {
                stmt2.execute("call SYS.REBALANCE_ALL_BUCKETS()");
                BugsTest.fail("expected authz exception");
            }
            catch (SQLException sqle22) {
                if ("42504".equals(sqle22.getSQLState())) break block86;
                throw sqle22;
            }
        }
        stmt.execute("GRANT execute on procedure sys.REBALANCE_ALL_BUCKETS to scott");
        stmt2.execute("call SYS.REBALANCE_ALL_BUCKETS()");
        Object[] expectedexceptionlist = new Class[]{SQLNonTransientConnectionException.class};
        String localHostName = SocketCreator.getLocalHost().getHostName();
        try {
            TestUtil.addExpectedException(expectedexceptionlist);
            JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myjar, "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName});
            BugsTest.fail("expected auth exception");
        }
        catch (GemFireTerminateError err) {
            sqle = err.getCause();
            if (!(sqle instanceof SQLException) || !"08004".equals(((SQLException)sqle).getSQLState())) {
                throw sqle;
            }
        }
        finally {
            TestUtil.removeExpectedException(expectedexceptionlist);
        }
        expectedexceptionlist = new Class[]{SQLSyntaxErrorException.class};
        try {
            TestUtil.addExpectedException(expectedexceptionlist);
            JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myjar, "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName, "-user=scott", "-password=pass"});
            BugsTest.fail("expected authz exception");
        }
        catch (GemFireTerminateError err) {
            sqle = err.getCause();
            if (!(sqle instanceof SQLException) || !"42504".equals(((SQLException)sqle).getSQLState())) {
                throw sqle;
            }
        }
        finally {
            TestUtil.removeExpectedException(expectedexceptionlist);
        }
        stmt.execute("GRANT execute on procedure sqlj.install_jar_bytes to scott");
        JarTools.main((String[])new String[]{"install-jar", "-file=" + this.myjar, "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName, "-user=scott", "-password=pass"});
        try {
            TestUtil.addExpectedException(expectedexceptionlist);
            JarTools.main((String[])new String[]{"replace-jar", "-file=" + this.booksJar, "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName, "-user=scott", "-password=pass"});
            BugsTest.fail("expected authz exception");
        }
        catch (GemFireTerminateError err) {
            sqle = err.getCause();
            if (!(sqle instanceof SQLException) || !"42504".equals(((SQLException)sqle).getSQLState())) {
                throw sqle;
            }
        }
        finally {
            TestUtil.removeExpectedException(expectedexceptionlist);
        }
        stmt.execute("GRANT execute on procedure sqlj.replace_jar_bytes to scott");
        JarTools.main((String[])new String[]{"replace-jar", "-file=" + this.booksJar, "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName, "-user=scott", "-password=pass"});
        try {
            TestUtil.addExpectedException(expectedexceptionlist);
            JarTools.main((String[])new String[]{"remove-jar", "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName, "-user=scott", "-password=pass"});
            BugsTest.fail("expected authz exception");
        }
        catch (GemFireTerminateError err) {
            sqle = err.getCause();
            if (!(sqle instanceof SQLException) || !"42504".equals(((SQLException)sqle).getSQLState())) {
                throw sqle;
            }
        }
        finally {
            TestUtil.removeExpectedException(expectedexceptionlist);
        }
        stmt.execute("GRANT execute on procedure sqlj.remove_jar to scott");
        JarTools.main((String[])new String[]{"remove-jar", "-name=app.sample2", "-client-port=" + netPort, "-client-bind-address=" + localHostName, "-user=scott", "-password=pass"});
    }

    public void testAdminChangePassword_47917() throws Throwable {
        Connection conn3;
        int netPort;
        Properties props;
        block8: {
            block7: {
                Statement stmt;
                block6: {
                    props = new Properties();
                    props.setProperty("auth-provider", "BUILTIN");
                    props.setProperty("gemfirexd.sql-authorization", "false");
                    props.setProperty("gemfirexd.user.admin", "pass");
                    props.setProperty("user", "admin");
                    props.setProperty("password", "pass");
                    BugsTest.setupConnection(props);
                    netPort = BugsTest.startNetserverAndReturnPort();
                    props.clear();
                    props.setProperty("user", "admin");
                    props.setProperty("password", "pass");
                    Connection conn = TestUtil.getNetConnection(netPort, null, props);
                    stmt = conn.createStatement();
                    stmt.execute("call sys.create_user('scott', 'pass')");
                    stmt.execute("call sys.create_user('ramesh', 'pass')");
                    props.clear();
                    props.setProperty("user", "scott");
                    props.setProperty("password", "pass");
                    Connection conn2 = TestUtil.getNetConnection(netPort, null, props);
                    Statement stmt2 = conn2.createStatement();
                    stmt2.execute("call sys.change_password('scott', 'pass', 'pass2')");
                    try {
                        stmt2.execute("call sys.change_password('ramesh', '', 'pass2')");
                        BugsTest.fail("expected failure in changing ramesh's password");
                    }
                    catch (SQLException sqle) {
                        if ("08004".equals(sqle.getSQLState())) break block6;
                        throw sqle;
                    }
                }
                stmt.execute("call sys.change_password('scott', '', 'pass2')");
                stmt.execute("call sys.change_password('scott', null, 'pass3')");
                stmt.execute("call sys.change_password('ramesh', '', 'pass2')");
                stmt.execute("call sys.change_password('ramesh', null, 'pass3')");
                try {
                    stmt.execute("call sys.change_password('scott', 'pass', 'pass4')");
                    BugsTest.fail("expected failure in changing password");
                }
                catch (SQLException sqle) {
                    if ("08004".equals(sqle.getSQLState())) break block7;
                    throw sqle;
                }
            }
            try {
                conn3 = TestUtil.getNetConnection(netPort, null, props);
                BugsTest.fail("expected auth failure");
            }
            catch (SQLException sqle) {
                if ("08004".equals(sqle.getSQLState())) break block8;
                throw sqle;
            }
        }
        props.clear();
        props.setProperty("user", "scott");
        props.setProperty("password", "pass3");
        conn3 = TestUtil.getNetConnection(netPort, null, props);
    }

    public static void checkLobs(java.sql.ResultSet rs, char[] clobChars, byte[] blobBytes) throws Exception {
        int read;
        BugsTest.assertTrue((boolean)rs.next());
        Clob clob = rs.getClob(7);
        Blob blob = rs.getBlob("PVT");
        BufferedReader reader = new BufferedReader(clob.getCharacterStream());
        int cLen = (int)clob.length();
        char[] charArray = new char[cLen];
        int offset = 0;
        while ((read = reader.read(charArray, offset, cLen - offset)) != -1 && (offset += read) < cLen) {
        }
        if (reader.read() != -1) {
            BugsTest.fail("extra characters in CLOB after its length " + cLen);
        }
        reader.close();
        InputStream is = blob.getBinaryStream();
        int bLen = (int)blob.length();
        byte[] byteArray = new byte[bLen];
        offset = 0;
        while ((read = is.read(byteArray, offset, bLen - offset)) != -1 && (offset += read) < bLen) {
        }
        if (is.read() != -1) {
            BugsTest.fail("extra characters in BLOB after its length " + bLen);
        }
        is.close();
        BugsTest.assertEquals((String)new String(clobChars), (String)new String(charArray));
        BugsTest.assertTrue((boolean)Arrays.equals(blobBytes, byteArray));
        BugsTest.assertFalse((boolean)rs.next());
    }

    public void runTestMultipleRowsUpdate(Connection conn) throws Exception {
        int i;
        Statement stmt = conn.createStatement();
        stmt.execute("create table testlob (id int primary key, text clob, text2 varchar(10), text3 long varchar, bin blob, bin2 long varchar for bit data) partition by primary key persistent");
        stmt.execute("insert into testlob values (1, 'one', '1', 'ONE', X'a0b0', X'0a')");
        stmt.execute("insert into testlob values (2, 'two', '2', 'TWO', X'a1b1', X'1a')");
        PreparedStatement pstmt = conn.prepareStatement("insert into testlob values (?,?,?,?,?,?)");
        pstmt.setInt(1, 3);
        Clob clob = conn.createClob();
        clob.setCharacterStream(1L).write("three");
        pstmt.setClob(2, clob);
        CharArrayReader reader = new CharArrayReader("3".toCharArray());
        pstmt.setCharacterStream(3, reader);
        reader = new CharArrayReader("THREE".toCharArray());
        pstmt.setCharacterStream(4, reader);
        byte[] buf = new byte[]{1, 2, 3};
        Blob blob = conn.createBlob();
        blob.setBinaryStream(1L).write(buf);
        pstmt.setBlob(5, blob);
        buf = new byte[]{4, 5, 6};
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        pstmt.setBinaryStream(6, is);
        pstmt.addBatch();
        pstmt.setInt(1, 4);
        reader = new CharArrayReader("four".toCharArray());
        pstmt.setCharacterStream(2, reader);
        pstmt.setString(3, "4");
        reader = new CharArrayReader("FOUR".toCharArray());
        pstmt.setCharacterStream(4, reader);
        buf = new byte[]{4, 5, 6};
        is = new ByteArrayInputStream(buf);
        pstmt.setBinaryStream(5, is);
        buf = new byte[]{7, 8, 9};
        is = new ByteArrayInputStream(buf);
        pstmt.setBinaryStream(6, is);
        pstmt.addBatch();
        pstmt.executeBatch();
        java.sql.ResultSet rs = stmt.executeQuery("select * from testlob order by id");
        BugsTest.checkLobColumns(rs, 1, "one", "1", "ONE", new byte[]{-96, -80}, new byte[]{10});
        BugsTest.checkLobColumns(rs, 2, "two", "2", "TWO", new byte[]{-95, -79}, new byte[]{26});
        BugsTest.checkLobColumns(rs, 3, "three", "3", "THREE", new byte[]{1, 2, 3}, new byte[]{4, 5, 6});
        BugsTest.checkLobColumns(rs, 4, "four", "4", "FOUR", new byte[]{4, 5, 6}, new byte[]{7, 8, 9});
        BugsTest.assertFalse((boolean)rs.next());
        rs.close();
        pstmt = conn.prepareStatement("update testlob set text=?");
        clob = conn.createClob();
        clob.setCharacterStream(1L).write("text");
        pstmt.setClob(1, clob);
        BugsTest.assertEquals((int)4, (int)pstmt.executeUpdate());
        conn.commit();
        rs = stmt.executeQuery("select text from testlob");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set text=?");
        reader = new CharArrayReader("text2".toCharArray());
        pstmt.setCharacterStream(1, reader);
        BugsTest.assertEquals((int)4, (int)pstmt.executeUpdate());
        conn.commit();
        rs = stmt.executeQuery("select text from testlob");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text2", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text2", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text2", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text2", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set text2=?");
        reader = new CharArrayReader("text3".toCharArray());
        pstmt.setCharacterStream(1, reader);
        BugsTest.assertEquals((int)4, (int)pstmt.executeUpdate());
        conn.commit();
        rs = stmt.executeQuery("select text2 from testlob");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text3", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text3", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text3", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text3", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set bin=?");
        buf = new byte[]{10, 20, 30};
        blob = conn.createBlob();
        blob.setBinaryStream(1L).write(buf);
        pstmt.setBlob(1, blob);
        BugsTest.assertEquals((int)4, (int)pstmt.executeUpdate());
        conn.commit();
        rs = stmt.executeQuery("select bin from testlob");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set bin=?");
        buf = new byte[]{30, 40, 50};
        is = new ByteArrayInputStream(buf);
        pstmt.setBinaryStream(1, is);
        BugsTest.assertEquals((int)4, (int)pstmt.executeUpdate());
        conn.commit();
        rs = stmt.executeQuery("select bin from testlob");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set bin2=?");
        buf = new byte[]{5, 6, 7, 8, 9};
        is = new ByteArrayInputStream(buf);
        pstmt.setBinaryStream(1, is);
        BugsTest.assertEquals((int)4, (int)pstmt.executeUpdate());
        conn.commit();
        rs = stmt.executeQuery("select bin2 from testlob");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(buf, rs.getBytes(1)));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set text2=? where id=?");
        for (i = 1; i <= 2; ++i) {
            pstmt.setString(1, "text" + i);
            pstmt.setInt(2, i);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        conn.commit();
        rs = stmt.executeQuery("select text2 from testlob order by id");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text1", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text2", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text3", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text3", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set text=? where id=?");
        for (i = 1; i <= 2; ++i) {
            reader = new CharArrayReader(("text" + i).toCharArray());
            pstmt.setCharacterStream(1, reader);
            pstmt.setInt(2, i);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        conn.commit();
        rs = stmt.executeQuery("select text from testlob order by id");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text1", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text2", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text2", (String)rs.getString(1));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((String)"text2", (String)rs.getString(1));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set bin=? where id=?");
        for (i = 1; i <= 2; ++i) {
            blob = conn.createBlob();
            blob.setBinaryStream(1L).write(new byte[]{(byte)(30 + i), (byte)(31 + i), (byte)(32 + i), (byte)(33 + i)});
            pstmt.setBlob(1, blob);
            pstmt.setInt(2, i);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        conn.commit();
        rs = stmt.executeQuery("select bin from testlob order by id");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(new byte[]{31, 32, 33, 34}, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(new byte[]{32, 33, 34, 35}, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(new byte[]{30, 40, 50}, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(new byte[]{30, 40, 50}, rs.getBytes(1)));
        BugsTest.assertFalse((boolean)rs.next());
        pstmt = conn.prepareStatement("update testlob set bin2=? where id=?");
        for (i = 1; i <= 2; ++i) {
            is = new ByteArrayInputStream(new byte[]{(byte)(40 + i), (byte)(41 + i), (byte)(42 + i), (byte)(43 + i)});
            pstmt.setBinaryStream(1, is);
            pstmt.setInt(2, i);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        conn.commit();
        rs = stmt.executeQuery("select bin2 from testlob order by id");
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(new byte[]{41, 42, 43, 44}, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(new byte[]{42, 43, 44, 45}, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(new byte[]{5, 6, 7, 8, 9}, rs.getBytes(1)));
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertTrue((boolean)Arrays.equals(new byte[]{5, 6, 7, 8, 9}, rs.getBytes(1)));
        BugsTest.assertFalse((boolean)rs.next());
        stmt.execute("drop table testlob");
    }

    private static void checkLobColumns(java.sql.ResultSet rs, int col1, String col2, String col3, String col4, byte[] col5, byte[] col6) throws Exception {
        int i;
        BugsTest.assertTrue((boolean)rs.next());
        BugsTest.assertEquals((int)col1, (int)rs.getInt(1));
        BugsTest.assertEquals((String)col2, (String)rs.getString(2));
        Clob clob = rs.getClob(2);
        BugsTest.assertEquals((String)col2, (String)clob.getSubString(1L, (int)clob.length()));
        clob = rs.getClob(2);
        Reader reader = clob.getCharacterStream();
        for (i = 0; i < col2.length(); ++i) {
            BugsTest.assertEquals((int)col2.charAt(i), (int)reader.read());
        }
        BugsTest.assertEquals((int)-1, (int)reader.read());
        reader = rs.getCharacterStream(2);
        for (i = 0; i < col2.length(); ++i) {
            BugsTest.assertEquals((int)col2.charAt(i), (int)reader.read());
        }
        BugsTest.assertEquals((int)-1, (int)reader.read());
        BugsTest.assertEquals((String)col3, (String)rs.getString(3));
        BugsTest.assertEquals((String)col4, (String)rs.getString(4));
        reader = rs.getCharacterStream(4);
        for (i = 0; i < col4.length(); ++i) {
            BugsTest.assertEquals((int)col4.charAt(i), (int)reader.read());
        }
        BugsTest.assertEquals((int)-1, (int)reader.read());
        Blob blob = rs.getBlob(5);
        InputStream is = blob.getBinaryStream();
        for (i = 0; i < col5.length; ++i) {
            BugsTest.assertEquals((byte)col5[i], (byte)((byte)is.read()));
        }
        BugsTest.assertEquals((int)-1, (int)is.read());
        is = rs.getBinaryStream(5);
        for (i = 0; i < col5.length; ++i) {
            BugsTest.assertEquals((byte)col5[i], (byte)((byte)is.read()));
        }
        BugsTest.assertEquals((int)-1, (int)is.read());
        is = rs.getBinaryStream(6);
        for (i = 0; i < col6.length; ++i) {
            BugsTest.assertEquals((byte)col6[i], (byte)((byte)is.read()));
        }
        BugsTest.assertEquals((int)-1, (int)is.read());
    }

    public static int myhash(int value) {
        return value;
    }

    public static void proc1(String param1, java.sql.ResultSet[] outResults) throws SQLException {
        java.sql.ResultSet rs;
        String queryString = "<local>SELECT * FROM SAMPLE WHERE id = ?";
        Connection conn = null;
        conn = DriverManager.getConnection("jdbc:default:gemfirexd:connection");
        PreparedStatement ps = conn.prepareStatement(queryString);
        ps.setString(1, param1);
        outResults[0] = rs = ps.executeQuery();
    }

    public static Integer maxFunc(Integer val1, Integer val2) throws SQLException {
        return val1 > val2 ? val1 : val2;
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.exceptionOccured = false;
    }

    public void testBug47066() throws Exception {
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        Properties props = new Properties();
        props.put("mcast-port", String.valueOf(mcastPort));
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema trade");
        st.execute("create table trade.customerrep (c_next varchar(40),c_id int  primary key) replicate");
        PreparedStatement psInsert = conn.prepareStatement("insert into trade.customerrep values (?, ?)");
        psInsert.setString(1, "aaa'sss");
        psInsert.setInt(2, 1);
        psInsert.executeUpdate();
        psInsert.setString(1, "bbb''sss");
        psInsert.setInt(2, 2);
        psInsert.executeUpdate();
        psInsert.setString(1, "ccc'''sss");
        psInsert.setInt(2, 3);
        psInsert.executeUpdate();
        psInsert.setString(1, "ddd'sss");
        psInsert.setInt(2, 4);
        psInsert.executeUpdate();
        Statement ins = conn.createStatement();
        ins.execute("insert into trade.customerrep values ('xxx''sss', 22)");
        ins.execute("insert into trade.customerrep values ('xxx''sss''ds ddd''', 23)");
        PreparedStatement ps1 = conn.prepareStatement("Select c_next from trade.customerrep");
        java.sql.ResultSet rs = ps1.executeQuery();
        HashSet<String> hashs = new HashSet<String>();
        hashs.add("aaa'sss");
        hashs.add("bbb''sss");
        hashs.add("ddd'sss");
        hashs.add("xxx'sss");
        hashs.add("xxx'sss'ds ddd'");
        hashs.add("ccc'''sss");
        while (rs.next()) {
            String val = rs.getString(1);
            BugsTest.assertTrue((String)("Removed failed for " + val), (boolean)hashs.remove(val));
        }
        BugsTest.assertTrue((boolean)hashs.isEmpty());
        rs.close();
    }

    public void test48808() throws Exception {
        int i;
        Connection conn = BugsTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TYPE trade.UDTPrice EXTERNAL NAME 'udtexamples.UDTPrice' LANGUAGE JAVA");
        stmt.execute("create function trade.getLowPrice(DP1 trade.UDTPrice) RETURNS NUMERIC PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'udtexamples.UDTPrice.getLowPrice'");
        stmt.execute("create function trade.createPrice(low NUMERIC(6,2), high NUMERIC(6,2)) RETURNS trade.UDTPrice PARAMETER STYLE JAVA LANGUAGE JAVA NO SQL EXTERNAL NAME 'udtexamples.UDTPrice.setPrice'");
        stmt.execute("create table trade.companies (symbol varchar(10) not null, exchange varchar(10) not null, companytype smallint, companyname char(100), companyinfo clob, note long varchar, histprice trade.udtprice, tid int,constraint comp_pk primary key (companyname)) partition by column(histprice)");
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.companies values (?,?,?,?,?,?,?,?)");
        UDTPrice udt = new UDTPrice(new BigDecimal("27.58"), new BigDecimal("37.58"));
        for (int i2 = 1; i2 < 20; ++i2) {
            pstmt.setString(1, "sym" + i2);
            pstmt.setString(2, "e" + i2);
            pstmt.setInt(3, i2);
            pstmt.setString(4, "c" + i2);
            pstmt.setString(5, "ci" + i2);
            pstmt.setString(6, "Q" + i2 + "\"6>$?3-D=T");
            pstmt.setObject(7, udt);
            pstmt.setInt(8, i2 * 2);
            BugsTest.assertEquals((int)1, (int)pstmt.executeUpdate());
        }
        PartitionedRegion pr = (PartitionedRegion)Misc.getRegionForTable((String)"TRADE.COMPANIES", (boolean)true);
        int expectedBucketId = PartitionedRegionHelper.getHashKey((PartitionedRegion)pr, (Object)new UserType((Object)udt).computeHashCode(-1, 0));
        Iterator iter = pr.getAppropriateLocalEntriesIterator(null, true, false, true, null, false);
        int numEntries = 19;
        while (iter.hasNext()) {
            RowLocation rl = (RowLocation)iter.next();
            BugsTest.assertEquals((int)expectedBucketId, (int)rl.getBucketID());
            --numEntries;
        }
        BugsTest.assertEquals((int)0, (int)numEntries);
        pstmt = conn.prepareStatement("update trade.companies set tid=? where histprice=? and symbol=?");
        for (i = 1; i < 20; ++i) {
            pstmt.setInt(1, i);
            pstmt.setObject(2, udt);
            pstmt.setString(3, "sym" + i);
            BugsTest.assertEquals((String)("failed for i=" + i), (int)1, (int)pstmt.executeUpdate());
        }
        pstmt = conn.prepareStatement("delete from trade.companies where tid=? and trade.getLowPrice(histPrice) <=? and note like ? and companyType = ?");
        for (i = 1; i < 20; ++i) {
            pstmt.setInt(1, i);
            pstmt.setBigDecimal(2, new BigDecimal("27.58"));
            pstmt.setString(3, "%" + i + "\"%");
            pstmt.setInt(4, i);
            BugsTest.assertEquals((String)("failed for i=" + i), (int)1, (int)pstmt.executeUpdate());
        }
        java.sql.ResultSet rs = stmt.executeQuery("select * from trade.companies");
        JDBC.assertEmpty(rs);
    }

    public static void proc3(ProcedureExecutionContext ctx) throws SQLException, InterruptedException {
        Connection c = ctx.getConnection();
        Statement s = c.createStatement();
        s.execute("insert into mytable values(2)");
        s.close();
        c.close();
    }

    public void testBug50840() throws Exception {
        Properties props = new Properties();
        Connection cxn = TestUtil.getConnection(props);
        Statement stmt = cxn.createStatement();
        stmt.execute("CREATE PROCEDURE Proc3 ()LANGUAGE JAVA PARAMETER STYLE JAVA MODIFIES SQL DATA DYNAMIC RESULT SETS 0 EXTERNAL NAME '" + BugsTest.class.getName() + ".proc3'");
        stmt.execute("CREATE TABLE MYTABLE(COL1 INT)");
        cxn.createStatement().execute("call proc3()");
        stmt.execute("select * from mytable");
        java.sql.ResultSet rs = stmt.getResultSet();
        BugsTest.assertTrue((boolean)rs.next());
    }

    public void testSELECT_CASE_Bug51286() throws Exception {
        Properties p = new Properties();
        p.setProperty("mcast-port", String.valueOf(AvailablePort.getRandomAvailablePort((int)1)));
        BugsTest.setupConnection(p);
        int port = TestUtil.startNetserverAndReturnPort();
        Connection conn = TestUtil.getNetConnection(port, null, null);
        Statement st = conn.createStatement();
        st.execute("create table Customer (cust_id varchar(32), cust_type char(1), primary key(cust_id, cust_type)) partition by primary key");
        st.execute("create table Product (p_id varchar(32), p_type varchar(60), primary key(p_id, p_type) ) partition by column (p_type, p_id)");
        st.execute("create table OOrder (o_id varchar(32) primary key, cust_id varchar(32), cust_type char(1), p_id varchar(32), p_type varchar(60), o_dt date default CURRENT_DATE, foreign key (cust_id, cust_type) references customer(cust_id, cust_type), foreign key (p_id, p_type) references product(p_id, p_type)) partition by column (o_dt) ");
        st.execute("insert into customer values ('c-1', 'a'), ('c-2', 'a'), ('c-3', 'b'), ('c-4', 'b')");
        st.execute("insert into product values ('p-1', 'typ1'), ('p-2', 'typ2'),  ('p-3', 'typ1'), ('p-4', 'typ2'),  ('p-5', 'typ1'), ('p-6', 'typ2'),  ('p-7', 'typ1'), ('p-8', 'typ2'),  ('p-9', 'typ1'), ('p-10', 'typ2'),  ('p-11', 'typ1'), ('p-12', 'typ2'),  ('p-13', 'typ1'), ('p-14', 'typ2'),  ('p-15', 'typ1'), ('p-16', 'typ2'),  ('p-17', 'typ1'), ('p-18', 'typ2'),  ('p-19', 'typ1'), ('p-20', 'typ2'), ('p-21', 'typ3'), ('p-22', 'typ3'),  ('p-23', 'typ4'), ('p-24', 'typ4') ");
        st.execute("insert into oorder (o_id, cust_id, cust_type, p_id, p_type) values ('o-1' , 'c-1', 'a', 'p-1', 'typ1'), ('o-2', 'c-1', 'a', 'p-2', 'typ2'), ('o-3' , 'c-1', 'a', 'p-1', 'typ1'), ('o-4', 'c-1', 'a', 'p-2', 'typ2'), ('o-5' , 'c-1', 'a', 'p-1', 'typ1'), ('o-6', 'c-1', 'a', 'p-2', 'typ2'), ('o-7' , 'c-1', 'a', 'p-1', 'typ1'), ('o-8', 'c-1', 'a', 'p-2', 'typ2'), ('o-9' , 'c-1', 'a', 'p-1', 'typ1'), ('o-10', 'c-1','a', 'p-2', 'typ2'), ('o-11' , 'c-1','a', 'p-1', 'typ1'), ('o-12', 'c-1','a', 'p-2', 'typ2'), ('o-13' , 'c-1','a', 'p-1', 'typ1'), ('o-14', 'c-1','a', 'p-2', 'typ2'), ('o-15' , 'c-1','a', 'p-1', 'typ1'), ('o-16', 'c-1','a', 'p-2', 'typ2'), ('o-17' , 'c-1','a', 'p-1', 'typ1'), ('o-18', 'c-1','a', 'p-2', 'typ2'), ('o-19' , 'c-1','a', 'p-1', 'typ1'), ('o-20', 'c-1','a', 'p-2', 'typ2'), ('o-21' , 'c-1','a', 'p-21', 'typ3'), ('o-22', 'c-1','a', 'p-21', 'typ3'), ('o-23' , 'c-1','a', 'p-23', 'typ4'), ('o-24', 'c-1','a', 'p-23', 'typ4') ");
        PreparedStatement ps = conn.prepareStatement("select case  when p_type = 'typ1' then 'type 1'  when p_type = 'typ2' then 'type 2'  else 'long string' end  from product fetch first 10 rows only");
        java.sql.ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String v = rs.getString(1);
            BugsTest.assertTrue((v.equals("type 1") || v.equals("type 2") || v.equals("long string") ? 1 : 0) != 0);
        }
        rs.close();
        rs = st.executeQuery("select decode (p_type, 'typ1', 'TYPE ONE', 'typ2', 'TYPE ID TWO', 'typ3', 'TYPE3')  from product");
        int typ1 = 0;
        int typ2 = 0;
        int typ3 = 0;
        int others = 0;
        while (rs.next()) {
            String val = rs.getString(1);
            if ("TYPE ONE".equals(val)) {
                ++typ1;
                continue;
            }
            if ("TYPE ID TWO".equals(val)) {
                ++typ2;
                continue;
            }
            if ("TYPE3".equals(val)) {
                ++typ3;
                continue;
            }
            ++others;
        }
        BugsTest.assertEquals((int)10, (int)typ1);
        BugsTest.assertEquals((int)10, (int)typ2);
        BugsTest.assertEquals((int)2, (int)typ3);
        BugsTest.assertEquals((int)2, (int)others);
    }

    public void testCASE_IN_Bug_51249() throws Exception {
        Properties p = new Properties();
        p.setProperty("mcast-port", String.valueOf(AvailablePort.getRandomAvailablePort((int)1)));
        p.setProperty("SKIP_SPS_PRECOMPILE", "true");
        BugsTest.setupConnection(p);
        int port = TestUtil.startNetserverAndReturnPort();
        Connection conn = TestUtil.getNetConnection(port, null, null);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE PRODUCT_CUR (ROW_WID bigint NOT NULL,ITEM_11I_ID bigint,FMLY varchar(60),FORECAST_CATEGORY varchar(40),PROFIT_CTR_CD varchar(30),PROD_LN varchar(60),RPTG_PROD_TYPE varchar(180),FORECAST_CATEGORY_GROUP varchar(40)) ");
        PreparedStatement ins = conn.prepareStatement("insert into product_cur (ROW_WID, FMLY) values (?, ?)");
        for (int i = 0; i < 100; ++i) {
            ins.setInt(1, i);
            ins.setString(2, i % 2 == 0 ? "ATMOS" : (i % 3 == 0 ? "CENTERA" : "VENTURA CAP"));
            ins.addBatch();
        }
        ins.executeBatch();
        ins.clearBatch();
        PreparedStatement ps = conn.prepareStatement("SELECT CASE WHEN PRODUCT_CUR.FMLY IN ('ATMOS', 'CENTERA') THEN 'FOUND' ELSE 'NOT FOUND' END , PRODUCT_CUR.FMLY from PRODUCT_CUR FETCH FIRST 10 ROWS ONLY ");
        java.sql.ResultSet rs = ps.executeQuery();
        int foundRows = 0;
        int notFoundRows = 0;
        while (rs.next()) {
            String fmly = rs.getString(2);
            if ("ATMOS".equals(fmly) || "CENTERA".equals(fmly)) {
                ++foundRows;
                BugsTest.assertTrue((boolean)"FOUND".equals(rs.getString(1)));
                continue;
            }
            ++notFoundRows;
            BugsTest.assertTrue((boolean)"NOT FOUND".equals(rs.getString(1)));
        }
        BugsTest.assertEquals((int)7, (int)foundRows);
        BugsTest.assertEquals((int)3, (int)notFoundRows);
    }

    public void createTables51718(Connection conn, Statement st) throws Exception {
        String extra_jtests = BugsTest.getResourcesDir();
        GemFireXDUtils.executeSQLScripts((Connection)conn, (String[])new String[]{extra_jtests + "/lib/rtrddl.sql", extra_jtests + "/lib/sales_credits_ddl.sql", extra_jtests + "/lib/003_create_gdw_table_indexes.sql"}, (boolean)false, (Logger)BugsTest.getLogger(), null, null, (boolean)false);
    }

    public void importData51718(Statement st) throws Exception {
        String extra_jtests = BugsTest.getResourcesDir();
        String importFile1 = extra_jtests + "/lib/rtr.dat";
        String importFile2 = extra_jtests + "/lib/SALES_CREDITS20000.dat";
        st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX('RTRADM', 'RTR_REPORT_DATA', '" + importFile1 + "', " + "NULL, NULL, NULL, 0, 0, 4, 0, null, null)");
        st.execute("CALL SYSCS_UTIL.IMPORT_TABLE_EX('RTRADM', 'SALES_CREDITS', '" + importFile2 + "', " + "NULL, NULL, NULL, 0, 0, 6, 0, null, null)");
    }

    public void testBug51718() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("table-default-partitioned", "false");
        props.put("mcast-port", String.valueOf(mcastPort));
        props.setProperty("user", "RTRADM");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        this.createTables51718(conn, st);
        this.importData51718(st);
        String query = "SELECT RTRADM.RTR_REPORT_DATA.ORD_NUM, SUM(RTRADM.RTR_REPORT_DATA.REVENUE*RTRADM.SALES_CREDITS.PERCENT/100) FROM RTRADM.RTR_REPORT_DATA, RTRADM.SALES_CREDITS WHERE ( RTRADM.SALES_CREDITS.SO_NUMBER=RTRADM.RTR_REPORT_DATA.ORD_NUM ) AND ( RTRADM.RTR_REPORT_DATA.RECORD_STATUS= '  ' ) AND ( RTRADM.SALES_CREDITS.EFFECTIVE_END_DATE IS NULL ) GROUP BY RTRADM.RTR_REPORT_DATA.ORD_NUM";
        java.sql.ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
        }
    }

    public void testBug51958() throws Exception {
        int count;
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.setProperty("table-default-partitioned", "false");
        props.put("mcast-port", String.valueOf(mcastPort));
        props.setProperty("user", "RTI");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("CREATE TABLE rti.test_table (identifier varchar (500), PRIMARY KEY(identifier)) PERSISTENT ASYNCHRONOUS");
        st.execute("insert into rti.test_table values ('1')");
        st.execute("insert into rti.test_table values ('2')");
        st.execute("select count(*) from rti.test_table tt where tt.identifier is null");
        java.sql.ResultSet rs = st.getResultSet();
        while (rs.next()) {
            count = rs.getInt(1);
            BugsTest.assertEquals((int)0, (int)count);
            System.out.println("count1 " + rs.getInt(1));
        }
        st.execute("select count(*) from rti.test_table tt");
        rs = st.getResultSet();
        while (rs.next()) {
            count = rs.getInt(1);
            BugsTest.assertEquals((int)2, (int)count);
            System.out.println("count2 " + rs.getInt(1));
        }
        st.execute("select count(*) from rti.test_table tt where tt.identifier is not null");
        rs = st.getResultSet();
        while (rs.next()) {
            count = rs.getInt(1);
            BugsTest.assertEquals((int)2, (int)count);
        }
        st.execute("select * from rti.test_table tt where tt.identifier is null");
        rs = st.getResultSet();
        int c = 0;
        while (rs.next()) {
            ++c;
        }
        BugsTest.assertEquals((int)0, (int)c);
    }

    public void helperBug52352(Properties props, String in, String out) throws Exception {
        String firstSchema = "TRADE";
        String firstTable = firstSchema + "." + "orders";
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema " + firstSchema);
        st.execute("create table " + firstTable + " (OVID varchar(10)) replicate");
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("insert into " + firstTable + " values (" + in + ")");
        String query = "Select A.OVID from " + firstTable + " A";
        Connection conn2 = TestUtil.getConnection(props);
        PreparedStatement st2 = conn2.prepareStatement(query);
        java.sql.ResultSet r = st2.executeQuery();
        int count = 0;
        while (r.next()) {
            BugsTest.assertEquals((String)out, (String)r.getString(1));
            ++count;
        }
        BugsTest.assertEquals((int)1, (int)count);
        r.close();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("drop table " + firstTable);
        st.execute("drop schema trade restrict");
    }

    public void helper2Bug52352(Properties props, String in, String out) throws Exception {
        String firstSchema = "TRADE";
        String firstTable = firstSchema + "." + "orders";
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create schema " + firstSchema);
        st.execute("create table " + firstTable + " (OVID varchar(10)) replicate");
        String query = "insert into " + firstTable + " values (?)";
        Connection conn2 = TestUtil.getConnection(props);
        PreparedStatement st2 = conn2.prepareStatement(query);
        st2.setString(1, in);
        st2.executeUpdate();
        query = "Select A.OVID from " + firstTable + " A";
        conn2 = TestUtil.getConnection(props);
        st2 = conn2.prepareStatement(query);
        java.sql.ResultSet r = st2.executeQuery();
        int count = 0;
        while (r.next()) {
            BugsTest.assertEquals((String)out, (String)r.getString(1));
            ++count;
        }
        BugsTest.assertEquals((int)1, (int)count);
        r.close();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
        st.execute("drop table " + firstTable);
        st.execute("drop schema trade restrict");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBug52352() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        try {
            this.helperBug52352(props, "'''test'''", "'test'");
            this.helperBug52352(props, "'test'", "test");
            this.helper2Bug52352(props, "''test''", "''test''");
            this.helper2Bug52352(props, "test", "test");
        }
        finally {
            TestUtil.shutDown();
        }
    }

    public static class DataGenerator {
        protected static String[] exchanges = new String[]{"nasdaq", "nye", "amex", "lse", "fse", "hkse", "tse"};
        private Random rand = new Random();

        public void insertIntoSecurities(PreparedStatement ps, int sec_id) throws SQLException {
            block2: {
                ps.setInt(1, sec_id);
                ps.setString(2, this.getSymbol(1, 8));
                ps.setBigDecimal(3, this.getPrice());
                ps.setString(4, this.getExchange());
                ps.setInt(5, 50);
                try {
                    ps.executeUpdate();
                }
                catch (SQLException sqle) {
                    if (sqle.getSQLState().equals("23505")) break block2;
                    throw sqle;
                }
            }
        }

        public void insertIntoCompanies(PreparedStatement ps, String symbol, String exchange) throws SQLException {
            UUID uid = UUID.fromString("3f90bd11-dfc3-4fd0-b758-08ed895b5c02");
            short companyType = 8;
            String companyName = "+=uqGd1w]bR6z[!j]|Chc>WTdf";
            Clob[] companyInfo = this.getClob(100);
            String note = this.getString(31000, 32700);
            UDTPrice price = this.getRandomPrice();
            long asset = this.rand.nextLong();
            byte[] logo = this.getByteArray(100);
            ps.setString(1, symbol);
            ps.setString(2, exchange);
            ps.setShort(3, companyType);
            ps.setBytes(4, DataGenerator.getUidBytes(uid));
            ps.setObject(5, uid);
            ps.setString(6, companyName);
            if (companyInfo == null) {
                ps.setNull(7, 2005);
            } else {
                ps.setClob(7, companyInfo[0]);
            }
            ps.setString(8, note);
            ps.setObject(9, price);
            ps.setLong(10, asset);
            ps.setBytes(11, logo);
            ps.setInt(12, 10);
            ps.executeUpdate();
        }

        protected BigDecimal getPrice() {
            return new BigDecimal(Double.toString((double)(this.rand.nextInt(10000) + 1) * 0.01));
        }

        protected String getExchange() {
            return exchanges[this.rand.nextInt(exchanges.length)];
        }

        public static byte[] getUidBytes(UUID uuid) {
            if (uuid == null) {
                return null;
            }
            long[] longArray = new long[]{uuid.getMostSignificantBits(), uuid.getLeastSignificantBits()};
            byte[] bytes = new byte[16];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            bb.putLong(longArray[0]);
            bb.putLong(longArray[1]);
            return bytes;
        }

        protected byte[] getByteArray(int maxLength) {
            int arrayLength = this.rand.nextInt(maxLength) + 1;
            byte[] byteArray = new byte[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                byteArray[j] = (byte)this.rand.nextInt(256);
            }
            return byteArray;
        }

        protected UDTPrice getRandomPrice() {
            BigDecimal low = new BigDecimal(Double.toString((double)(this.rand.nextInt(3000) + 1) * 0.01)).add(new BigDecimal("20"));
            BigDecimal high = new BigDecimal("10").add(low);
            return new UDTPrice(low, high);
        }

        protected String getString(int minLength, int maxLength) {
            int length = this.rand.nextInt(maxLength - minLength + 1) + minLength;
            return this.getRandPrintableVarChar(length);
        }

        protected String getSymbol(int minLength, int maxLength) {
            int aVal = 97;
            int symbolLength = this.rand.nextInt(maxLength - minLength + 1) + minLength;
            char[] charArray = new char[symbolLength];
            for (int j = 0; j < symbolLength; ++j) {
                charArray[j] = (char)(this.rand.nextInt(26) + aVal);
            }
            return new String(charArray);
        }

        protected String getRandPrintableVarChar(int length) {
            if (length == 0) {
                return "";
            }
            int sp = 32;
            int tilde = 126;
            char[] charArray = new char[length];
            for (int j = 0; j < length; ++j) {
                charArray[j] = (char)(this.rand.nextInt(tilde - sp) + sp);
            }
            return new String(charArray);
        }

        protected char[] getCharArray(int length) {
            int arrayLength = this.rand.nextInt(length) + 1;
            char[] charArray = new char[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                charArray[j] = this.getValidChar();
            }
            return charArray;
        }

        protected char getValidChar() {
            return (char)this.rand.nextInt(1319);
        }

        protected char[] getAsciiCharArray(int length) {
            int arrayLength = this.rand.nextInt(length) + 1;
            char[] charArray = new char[arrayLength];
            for (int j = 0; j < arrayLength; ++j) {
                charArray[j] = (char)this.rand.nextInt(128);
            }
            return charArray;
        }

        protected Clob[] getClob(int size) {
            Clob[] profile = new Clob[size];
            int maxClobSize = 1000000;
            try {
                for (int i = 0; i < size; ++i) {
                    char[] chars;
                    if (this.rand.nextBoolean()) {
                        chars = this.rand.nextInt(10) != 0 ? this.getAsciiCharArray(this.rand.nextInt(maxClobSize) + 1) : this.getCharArray(this.rand.nextInt(maxClobSize) + 1);
                        profile[i] = new SerialClob(chars);
                        continue;
                    }
                    if (this.rand.nextInt(10) != 0) continue;
                    chars = new char[]{};
                    profile[i] = new SerialClob(chars);
                }
            }
            catch (SQLException se) {
                TestUtil.fail("unexpected SQLException: " + se, se);
            }
            return profile;
        }
    }

    public static class ReprepareObserver
    extends GemFireXDQueryObserverAdapter {
        public void afterResultSetOpen(GenericPreparedStatement stmt, LanguageConnectionContext lcc, ResultSet resultSet) {
        }

        public void afterQueryExecution(GenericPreparedStatement stmt, Activation activation) throws StandardException {
            stmt.makeInvalid(23, activation.getLanguageConnectionContext());
            GemFireXDQueryObserverHolder.setInstance((GemFireXDQueryObserver)new GemFireXDQueryObserverAdapter());
        }
    }
}

