/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.concurrent.CyclicBarrier;
import java.util.zip.CRC32;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.functionTests.tests.jdbc4.ClobTest;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;

public class BlobTest
extends JdbcTestBase {
    private static final byte[] BYTES1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
    private static final byte[] BYTES2 = new byte[]{105, 104, 103, 102, 101, 101, 102, 103, 104, 105};
    private final int key = -1;
    private static final int JOBDATA_LEN = 500000;

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(BlobTest.class));
    }

    public BlobTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public void testBlobAsString() throws SQLException {
        BlobTest.setupConnection();
        Statement stmt = BlobTest.getStatement();
        stmt.executeUpdate("create table b (blob blob(3K))" + this.getSuffix());
        stmt.executeUpdate("insert into b values(cast(X'0031' as blob(3K)))");
        ResultSet rs = stmt.executeQuery("select blob from b");
        BlobTest.assertEquals((boolean)true, (boolean)rs.next());
        BlobTest.assertEquals((String)"0031", (String)rs.getString(1));
        rs.close();
        stmt.close();
    }

    public void testBug43623() throws Exception {
        int i;
        BlobTest.setupConnection();
        final int netPort = BlobTest.startNetserverAndReturnPort();
        Connection conn = BlobTest.getNetConnection(netPort, "", null);
        String tableDDL = "create table QUARTZ_TRIGGERS (TRIGGER_NAME varchar(80) not null, TRIGGER_GROUP varchar(80) not null, JOB_NAME varchar(80) not null, JOB_GROUP varchar(80) not null, IS_VOLATILE smallint, DESCRIPTION varchar(120), NEXT_FIRE_TIME bigint, PREV_FIRE_TIME bigint,  PRIORITY integer, TRIGGER_STATE varchar(16) not null, TRIGGER_TYPE varchar(8), START_TIME bigint, END_TIME bigint, CALENDAR_NAME varchar(80), MISFIRE_INSTR integer, JOB_DATA blob, primary key(TRIGGER_NAME, TRIGGER_GROUP))" + this.getSuffix();
        Statement stmt = conn.createStatement();
        stmt.execute(tableDDL);
        int numThreads = 50;
        Thread[] ts = new Thread[50];
        final Exception[] failure = new Exception[1];
        final CyclicBarrier barrier = new CyclicBarrier(50);
        for (i = 0; i < 50; ++i) {
            ts[i] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Connection c = TestUtil.getNetConnection(netPort, "", null);
                        barrier.await();
                        byte[] jobData = new byte[500000];
                        PartitionedRegion.rand.nextBytes(jobData);
                        String group = Thread.currentThread().getName();
                        try {
                            for (int i = 1; i <= 200; ++i) {
                                BlobTest.insertData_43623_2(c, jobData, group);
                                BlobTest.selectData_43623_2(c, group);
                                BlobTest.deleteData_43623_2(c, group);
                                if (i % 40 != 0) continue;
                                Statement s = c.createStatement();
                                ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM QUARTZ_TRIGGERS");
                                rs.next();
                                System.out.println(group + ": completed " + i + " ops with size=" + rs.getInt(1));
                                rs.close();
                                s.close();
                            }
                        }
                        finally {
                            c.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        failure[0] = e;
                    }
                }
            });
        }
        for (i = 0; i < 50; ++i) {
            ts[i].start();
        }
        for (i = 0; i < 50; ++i) {
            ts[i].join();
        }
        if (failure[0] != null) {
            throw failure[0];
        }
        stmt.execute("delete from QUARTZ_TRIGGERS where 1=1");
        conn.commit();
        byte[] jobData = new byte[10000000];
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        stmt.execute("drop table QUARTZ_TRIGGERS");
        this.waitTillAllClear();
        stmt.execute(tableDDL + " partition by primary key");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        stmt.execute("drop table QUARTZ_TRIGGERS");
        this.waitTillAllClear();
        stmt.execute(tableDDL + " partition by column (JOB_NAME)");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        stmt.execute("drop table QUARTZ_TRIGGERS");
        this.waitTillAllClear();
        stmt.execute(tableDDL);
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        stmt.execute("drop table QUARTZ_TRIGGERS");
        this.waitTillAllClear();
        stmt.execute(tableDDL + " partition by primary key");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        stmt.execute("drop table QUARTZ_TRIGGERS");
        this.waitTillAllClear();
        stmt.execute(tableDDL + " partition by column (JOB_NAME)");
        BlobTest.insertData_43623(conn, jobData);
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
        BlobTest.checkQueries_43623(conn, jobData);
        conn.commit();
    }

    public void testUpdateBinaryStream() throws Exception {
        BlobTest.setupConnection();
        Statement stmt = BlobTest.getStatement();
        stmt.execute("create table UpdateTestTableResultSet (sno int not null unique,dBlob BLOB,dClob CLOB,dLongVarchar LONG VARCHAR,dLongBit LONG VARCHAR FOR BIT DATA)" + this.getSuffix());
        byte[] bytes_ret = new byte[10];
        ByteArrayInputStream is = new ByteArrayInputStream(BYTES1);
        ByteArrayInputStream is_for_update = new ByteArrayInputStream(BYTES2);
        PreparedStatement ps_sb = this.prep("dLongBit");
        ps_sb.setInt(1, -1);
        ps_sb.setBinaryStream(2, (InputStream)is, BYTES1.length);
        ps_sb.executeUpdate();
        ps_sb.close();
        ResultSet rs1 = this.fetchUpd("dLongBit", -1);
        rs1.next();
        rs1.updateBinaryStream(1, (InputStream)is_for_update, BYTES2.length);
        rs1.updateRow();
        rs1.close();
        rs1 = this.fetch("dLongBit", -1);
        rs1.next();
        InputStream is_ret = rs1.getBinaryStream(1);
        is_ret.read(bytes_ret);
        is_ret.close();
        for (int i = 0; i < BYTES2.length; ++i) {
            BlobTest.assertEquals((String)"Error in updateBinaryStream", (byte)BYTES2[i], (byte)bytes_ret[i]);
        }
        rs1.close();
        stmt.execute("drop table UpdateTestTableResultSet");
        this.waitTillAllClear();
        stmt.close();
    }

    public void testGetBinaryStream() throws Exception {
        BlobTest.setupConnection();
        this.createBlobClobTables();
        this.insertDefaultData();
        Statement stmt = BlobTest.getStatement();
        ResultSet rs = stmt.executeQuery("select a, b, crc32 from testBlob");
        this.checkBlobContents(rs);
        stmt.close();
    }

    public void testFreeandMethodsAfterCallingFree() throws Exception {
        BlobTest.setupConnection();
        this.createBlobClobTable();
        new ClobTest("tmp").testFreeandMethodsAfterCallingFree();
    }

    private PreparedStatement prep(String colName) throws SQLException {
        return BlobTest.getPreparedStatement("insert into UpdateTestTableResultSet (sno, " + colName + ") values (?,?)");
    }

    private ResultSet fetchUpd(String colName, int key) throws SQLException {
        Statement stmt = jdbcConn.createStatement(1003, 1008);
        return stmt.executeQuery("select " + colName + " from UpdateTestTableResultSet where sno = " + key + " for update");
    }

    private ResultSet fetch(String colName, int key) throws SQLException {
        Statement stmt = BlobTest.getStatement();
        return stmt.executeQuery("select " + colName + " from UpdateTestTableResultSet where sno = " + key);
    }

    private void createBlobClobTables() throws SQLException {
        Statement stmt = BlobTest.getStatement();
        stmt.executeUpdate("CREATE TABLE testClob (b INT, c INT)" + this.getSuffix());
        stmt.executeUpdate("ALTER TABLE testClob ADD COLUMN a CLOB(300K)");
        stmt.executeUpdate("CREATE TABLE testBlob (b INT)" + this.getSuffix());
        stmt.executeUpdate("ALTER TABLE testBlob ADD COLUMN a blob(300k)");
        stmt.executeUpdate("ALTER TABLE testBlob ADD COLUMN crc32 BIGINT");
        stmt.close();
    }

    private void createBlobClobTable() throws SQLException {
        Statement stmt = BlobTest.getStatement();
        stmt.execute("create table BLOBCLOB (ID int primary key, BLOBDATA blob,CLOBDATA clob)" + this.getSuffix());
        stmt.execute("insert into BLOBCLOB VALUES (1, null, null)");
        stmt.execute("insert into BLOBCLOB VALUES (2, null, null)");
        stmt.close();
    }

    private void insertDefaultData() throws Exception {
        PreparedStatement ps = BlobTest.getPreparedStatement("INSERT INTO testClob (a, b, c) VALUES (?, ?, ?)");
        String clobValue = "";
        ps.setString(1, clobValue);
        ps.setInt(2, clobValue.length());
        ps.setLong(3, 0L);
        ps.addBatch();
        clobValue = "you can lead a horse to water but you can't form it into beverage";
        ps.setString(1, clobValue);
        ps.setInt(2, clobValue.length());
        ps.setLong(3, 0L);
        ps.addBatch();
        clobValue = "a stitch in time says ouch";
        ps.setString(1, clobValue);
        ps.setInt(2, clobValue.length());
        ps.setLong(3, 0L);
        ps.addBatch();
        clobValue = "here is a string with a return \n character";
        ps.setString(1, clobValue);
        ps.setInt(2, clobValue.length());
        ps.setLong(3, 0L);
        ps.addBatch();
        ps.executeBatch();
        ps.clearBatch();
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 0);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 56);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 5000);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 10000);
        this.insertLoopingAlphabetStreamData(ps, CharAlphabet.modernLatinLowercase(), 300000);
        ps.setNull(1, 2005);
        ps.setInt(2, 0);
        ps.setLong(3, 0L);
        ps.executeUpdate();
        ps.close();
        ps = BlobTest.getPreparedStatement("INSERT INTO testBlob (a, b, crc32) VALUES (?, ?, ?)");
        byte[] blobValue = "".getBytes("US-ASCII");
        ps.setBytes(1, blobValue);
        ps.setInt(2, blobValue.length);
        ps.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(blobValue)));
        ps.addBatch();
        blobValue = "you can lead a horse to water but you can't form it into beverage".getBytes("US-ASCII");
        ps.setBytes(1, blobValue);
        ps.setInt(2, blobValue.length);
        ps.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(blobValue)));
        ps.addBatch();
        blobValue = "a stitch in time says ouch".getBytes("US-ASCII");
        ps.setBytes(1, blobValue);
        ps.setInt(2, blobValue.length);
        ps.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(blobValue)));
        ps.addBatch();
        blobValue = "here is a string with a return \n character".getBytes("US-ASCII");
        ps.setBytes(1, blobValue);
        ps.setInt(2, blobValue.length);
        ps.setLong(3, this.getStreamCheckSum(new ByteArrayInputStream(blobValue)));
        ps.addBatch();
        ps.executeBatch();
        ps.clearBatch();
        this.insertLoopingAlphabetStreamData(ps, 0);
        this.insertLoopingAlphabetStreamData(ps, 56);
        this.insertLoopingAlphabetStreamData(ps, 5000);
        this.insertLoopingAlphabetStreamData(ps, 10000);
        this.insertLoopingAlphabetStreamData(ps, 300000);
        ps.setNull(1, 2004);
        ps.setInt(2, 0);
        ps.setNull(3, -5);
        ps.executeUpdate();
        ps.close();
    }

    public void checkBlobContents(ResultSet rs) throws Exception {
        int nullCount = 0;
        int rowCount = 0;
        byte[] buff = new byte[128];
        int blobLength = 0;
        int i = 0;
        while (rs.next()) {
            int size;
            ++i;
            Blob blob = rs.getBlob(1);
            long crc32 = rs.getLong(3);
            boolean crc2Null = rs.wasNull();
            if (blob == null) {
                BlobTest.assertTrue((String)"FAIL - NULL BLOB but non-NULL checksum", (boolean)crc2Null);
                ++nullCount;
                continue;
            }
            ++rowCount;
            long blobcrc32 = this.getStreamCheckSum(blob.getBinaryStream());
            BlobTest.assertEquals((String)("FAIL - mismatched checksums for blob with length " + blob.length()), (long)blobcrc32, (long)crc32);
            InputStream fin = blob.getBinaryStream();
            int columnSize = 0;
            while ((size = fin.read(buff)) != -1) {
                columnSize += size;
            }
            blobLength = rs.getInt(2);
            BlobTest.assertEquals((String)"FAIL - wrong column size", (int)blobLength, (int)columnSize);
            BlobTest.assertEquals((String)"FAIL - wrong column length", (long)blobLength, (long)blob.length());
        }
        BlobTest.assertEquals((String)("FAIL - wrong not null row count null:" + nullCount), (int)9, (int)rowCount);
        BlobTest.assertEquals((String)"FAIL - wrong null blob count", (int)1, (int)nullCount);
    }

    private void insertLoopingAlphabetStreamData(PreparedStatement ps, int lobLength) throws Exception {
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(lobLength), lobLength);
        ps.setInt(2, lobLength);
        ps.setLong(3, this.getStreamCheckSum(new LoopingAlphabetStream(lobLength)));
        ps.executeUpdate();
    }

    private void insertLoopingAlphabetStreamData(PreparedStatement ps, CharAlphabet alphabet, int lobLength) throws Exception {
        ps.setCharacterStream(1, (Reader)new LoopingAlphabetReader((long)lobLength, alphabet), lobLength);
        ps.setInt(2, lobLength);
        ps.setLong(3, -1L);
        ps.executeUpdate();
    }

    private long getStreamCheckSum(InputStream in) throws Exception {
        int read;
        CRC32 sum = new CRC32();
        byte[] buf = new byte[32768];
        while ((read = in.read(buf)) != -1) {
            sum.update(buf, 0, read);
        }
        in.close();
        return sum.getValue();
    }

    public static void insertData_43623(Connection conn, byte[] jobData) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("insert into QUARTZ_TRIGGERS(TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_STATE, JOB_NAME, JOB_GROUP, JOB_DATA) values(?, ?, ?, ?, ?, ?)");
        PartitionedRegion.rand.nextBytes(jobData);
        int numRows = 10;
        for (int cnt = 1; cnt <= 10; ++cnt) {
            pstmt.setString(1, "trig" + cnt);
            pstmt.setString(2, "grp" + cnt);
            pstmt.setString(3, "st" + cnt);
            pstmt.setString(4, "job" + cnt);
            pstmt.setString(5, "jgrp" + cnt);
            pstmt.setBytes(6, jobData);
            pstmt.execute();
        }
    }

    public static void insertData_43623_2(Connection conn, byte[] jobData, String group) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("insert into QUARTZ_TRIGGERS (TRIGGER_NAME, TRIGGER_GROUP, TRIGGER_STATE, JOB_NAME, JOB_GROUP, JOB_DATA) values(?, ?, ?, ?, ?, ?)");
        int numRows = 10;
        for (int cnt = 1; cnt <= 10; ++cnt) {
            pstmt.setString(1, "trig" + cnt);
            pstmt.setString(2, "grp_" + group + '_' + cnt);
            pstmt.setString(3, "st" + cnt);
            pstmt.setString(4, "job" + cnt);
            pstmt.setString(5, "jgrp" + cnt);
            pstmt.setBytes(6, jobData);
            pstmt.execute();
        }
    }

    public static void selectData_43623_2(Connection conn, String group) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("select TRIGGER_STATE, JOB_DATA from QUARTZ_TRIGGERS where TRIGGER_NAME = ? AND TRIGGER_GROUP = ?");
        int numRows = 10;
        for (int cnt = 1; cnt <= 10; ++cnt) {
            pstmt.setString(1, "trig" + cnt);
            pstmt.setString(2, "grp_" + group + '_' + cnt);
            ResultSet rs = pstmt.executeQuery();
            BlobTest.assertTrue((boolean)rs.next());
            BlobTest.assertEquals((String)("st" + cnt), (String)rs.getString(1));
            byte[] jobData = rs.getBytes(2);
            BlobTest.assertEquals((int)500000, (int)jobData.length);
            BlobTest.assertFalse((boolean)rs.next());
        }
    }

    public static void deleteData_43623_2(Connection conn, String group) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("delete from QUARTZ_TRIGGERS where TRIGGER_NAME = ? AND TRIGGER_GROUP = ?");
        int numRows = 10;
        for (int cnt = 1; cnt <= 10; ++cnt) {
            pstmt.setString(1, "trig" + cnt);
            pstmt.setString(2, "grp_" + group + '_' + cnt);
            pstmt.execute();
        }
    }

    public static void checkQueries_43623(Connection conn, byte[] jobData) throws Exception {
        ResultSet rs;
        int cnt;
        int numRows = 10;
        PreparedStatement pstmt = conn.prepareStatement("SELECT TRIGGER_STATE FROM QUARTZ_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?");
        for (cnt = 1; cnt <= 10; ++cnt) {
            pstmt.setString(1, "trig" + cnt);
            pstmt.setString(2, "grp" + cnt);
            rs = pstmt.executeQuery();
            BlobTest.assertTrue((boolean)rs.next());
            BlobTest.assertEquals((String)("st" + cnt), (String)rs.getString(1));
            BlobTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        pstmt = conn.prepareStatement("SELECT TRIGGER_STATE, JOB_DATA FROM QUARTZ_TRIGGERS WHERE TRIGGER_NAME = ? AND TRIGGER_GROUP = ?");
        for (cnt = 1; cnt <= 10; ++cnt) {
            pstmt.setString(1, "trig" + cnt);
            pstmt.setString(2, "grp" + cnt);
            rs = pstmt.executeQuery();
            BlobTest.assertTrue((boolean)rs.next());
            BlobTest.assertEquals((String)("st" + cnt), (String)rs.getString(1));
            if (!Arrays.equals(jobData, rs.getBytes(2))) {
                BlobTest.fail("LOB column not expected value");
            }
            BlobTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        pstmt = conn.prepareStatement("SELECT TRIGGER_STATE FROM QUARTZ_TRIGGERS WHERE JOB_NAME = ?");
        for (cnt = 1; cnt <= 10; ++cnt) {
            pstmt.setString(1, "job" + cnt);
            rs = pstmt.executeQuery();
            BlobTest.assertTrue((boolean)rs.next());
            BlobTest.assertEquals((String)("st" + cnt), (String)rs.getString(1));
            BlobTest.assertFalse((boolean)rs.next());
            rs.close();
        }
        pstmt = conn.prepareStatement("SELECT TRIGGER_STATE, JOB_DATA FROM QUARTZ_TRIGGERS WHERE JOB_NAME = ?");
        for (cnt = 1; cnt <= 10; ++cnt) {
            pstmt.setString(1, "job" + cnt);
            rs = pstmt.executeQuery();
            BlobTest.assertTrue((boolean)rs.next());
            BlobTest.assertEquals((String)("st" + cnt), (String)rs.getString(1));
            if (!Arrays.equals(jobData, rs.getBytes(2))) {
                BlobTest.fail("LOB column not expected value");
            }
            BlobTest.assertFalse((boolean)rs.next());
            rs.close();
        }
    }

    public String getSuffix() {
        return " ";
    }

    public void waitTillAllClear() {
    }
}

