/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BlobSetMethodsTest
extends JdbcTestBase {
    private static int BUFFER_SIZE = 1024;
    private static int UPDATE_SIZE = 100;

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(BlobSetMethodsTest.class));
    }

    public BlobSetMethodsTest(String name) {
        super(name);
    }

    public void testSetBytesLargeBlob() throws SQLException {
        int i;
        int i2;
        Connection con = TestUtil.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("create table blobtest (id integer, data Blob)" + this.getSuffix());
        stmt.close();
        con.setAutoCommit(false);
        PreparedStatement pstmt = con.prepareStatement("insert into blobtest (id, data) values (?,?)");
        Blob blob = con.createBlob();
        byte[] data = new byte[BUFFER_SIZE];
        for (i2 = 0; i2 < BUFFER_SIZE; ++i2) {
            data[i2] = (byte)(i2 % 255);
        }
        for (i2 = 0; i2 < 5; ++i2) {
            blob.setBytes(i2 * BUFFER_SIZE + 1, data);
        }
        BlobSetMethodsTest.assertEquals((long)(BUFFER_SIZE * 5), (long)blob.length());
        byte[] data1 = new byte[UPDATE_SIZE];
        for (int i3 = 0; i3 < UPDATE_SIZE; ++i3) {
            data1[i3] = 120;
        }
        blob.setBytes(BUFFER_SIZE + 1, data1);
        blob.setBytes(BUFFER_SIZE * 5 + 1, data1);
        BlobSetMethodsTest.assertEquals((long)(5 * BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        pstmt.setInt(1, 3);
        pstmt.setBlob(2, blob);
        pstmt.executeUpdate();
        stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select data from blobtest where id = 3");
        BlobSetMethodsTest.assertEquals((boolean)true, (boolean)rs.next());
        blob = rs.getBlob(1);
        byte[] data2 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        BlobSetMethodsTest.assertEquals((long)(5 * BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobSetMethodsTest.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        data2 = blob.getBytes(5 * BUFFER_SIZE + 1, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobSetMethodsTest.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        blob.truncate(BUFFER_SIZE);
        BlobSetMethodsTest.assertEquals((String)"truncate failed", (long)BUFFER_SIZE, (long)blob.length());
        rs.close();
        con.commit();
        stmt.close();
        pstmt.close();
    }

    public void testSetBytesSmallBlob() throws SQLException {
        int i;
        Connection con = TestUtil.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("create table blobtest (id integer, data Blob)" + this.getSuffix());
        stmt.close();
        con.setAutoCommit(false);
        PreparedStatement pstmt = con.prepareStatement("insert into blobtest (id, data) values (?,?)");
        pstmt.setInt(1, 1);
        Blob blob = con.createBlob();
        byte[] data = new byte[BUFFER_SIZE];
        for (int i2 = 0; i2 < BUFFER_SIZE; ++i2) {
            data[i2] = (byte)(i2 % 255);
        }
        blob.setBytes(1L, data);
        BlobSetMethodsTest.assertEquals((long)BUFFER_SIZE, (long)blob.length());
        pstmt.setBlob(2, blob);
        pstmt.executeUpdate();
        stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select data from blobtest where id = 1");
        BlobSetMethodsTest.assertEquals((boolean)true, (boolean)rs.next());
        blob = rs.getBlob(1);
        BlobSetMethodsTest.assertEquals((long)BUFFER_SIZE, (long)blob.length());
        byte[] data1 = new byte[UPDATE_SIZE];
        for (int i3 = 0; i3 < UPDATE_SIZE; ++i3) {
            data1[i3] = 120;
        }
        blob.setBytes(UPDATE_SIZE, data1);
        byte[] data2 = blob.getBytes(100L, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobSetMethodsTest.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        blob.setBytes(BUFFER_SIZE + 1, data1);
        BlobSetMethodsTest.assertEquals((long)(BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        data2 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobSetMethodsTest.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        pstmt.setInt(1, 2);
        pstmt.setBlob(2, blob);
        pstmt.executeUpdate();
        rs = stmt.executeQuery("select data from blobtest where id = 2");
        BlobSetMethodsTest.assertEquals((boolean)true, (boolean)rs.next());
        blob = rs.getBlob(1);
        BlobSetMethodsTest.assertEquals((long)(BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        data2 = blob.getBytes(100L, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobSetMethodsTest.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        data2 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        for (i = 0; i < UPDATE_SIZE; ++i) {
            BlobSetMethodsTest.assertEquals((byte)data1[i], (byte)data2[i]);
        }
        blob = con.createBlob();
        data = new byte[100];
        for (i = 0; i < 100; ++i) {
            data[i] = (byte)i;
        }
        blob.setBytes(1L, data);
        BlobSetMethodsTest.assertEquals((long)blob.length(), (long)100L);
        blob.truncate(50L);
        BlobSetMethodsTest.assertEquals((long)blob.length(), (long)50L);
        blob.setBytes(1L, data);
        BlobSetMethodsTest.assertEquals((String)"set failed", (long)blob.length(), (long)100L);
        blob.truncate(50L);
        BlobSetMethodsTest.assertEquals((String)"truncation failed", (long)blob.length(), (long)50L);
        rs.close();
        con.commit();
        stmt.close();
        pstmt.close();
        stmt = con.createStatement();
        stmt.execute("drop table blobtest");
        this.waitTillAllClear();
        stmt.close();
    }

    public void testGetBinaryStreamLong_42711() throws Exception {
        Connection conn = BlobSetMethodsTest.getConnection();
        Statement st = conn.createStatement();
        st.execute("create table BLOBCLOB(ID int primary key, BLOBDATA blob)" + this.getSuffix());
        byte[] bytes1 = new byte[]{101, 102, 103, 104, 105, 105, 104, 103, 102, 101};
        ByteArrayInputStream is = new ByteArrayInputStream(bytes1);
        PreparedStatement ps = conn.prepareStatement("insert into BLOBCLOB(ID, BLOBDATA) values(?,?)");
        int id = 10;
        ps.setInt(1, id);
        ps.setBinaryStream(2, is);
        ps.execute();
        ps.close();
        ResultSet rs = st.executeQuery("select BLOBDATA from BLOBCLOB where ID=" + id);
        BlobSetMethodsTest.assertTrue((boolean)rs.next());
        Blob blob = rs.getBlob(1);
        byte[] bytes2 = blob.getBytes(1L, bytes1.length);
        BlobSetMethodsTest.assertTrue((boolean)Arrays.equals(bytes1, bytes2));
        BlobSetMethodsTest.assertFalse((boolean)rs.next());
    }

    public void testDummy() {
    }

    public void waitTillAllClear() {
    }

    public String getSuffix() {
        return "  ";
    }
}

