/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.PartitionResolver;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.GlobalHashIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.Hash1Index;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2Index;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionByExpressionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdRangePartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.jdbc.CreateTableTest;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBC;

public class AlterTableTest
extends JdbcTestBase {
    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(AlterTableTest.class));
    }

    public AlterTableTest(String name) {
        super(name);
    }

    @Override
    protected String reduceLogging() {
        return "config";
    }

    public static void checkConstraints(Statement stmt, ConstraintNumber ... validConstraints) throws SQLException {
        AlterTableTest.checkConstraints(stmt, null, validConstraints);
    }

    public static void checkConstraints(Statement stmt, ConstraintNumber[] skipConstraints, ConstraintNumber ... validConstraints) throws SQLException {
        assert (validConstraints != null);
        ConstraintNumber[] allConstraints = ConstraintNumber.values();
        HashSet<ConstraintNumber> invalidConstraints = new HashSet<ConstraintNumber>();
        for (ConstraintNumber constraint : allConstraints) {
            if (constraint.defaultIgnore()) continue;
            invalidConstraints.add(constraint);
        }
        for (ConstraintNumber constraint : validConstraints) {
            AlterTableTest.getLogger().info((Object)("Checking that the constraint " + (Object)((Object)constraint) + " is being applied"));
            constraint.checkConstraint(stmt, true);
            invalidConstraints.remove((Object)constraint);
        }
        if (skipConstraints != null) {
            invalidConstraints.removeAll(Arrays.asList(skipConstraints));
        }
        for (ConstraintNumber constraint : invalidConstraints) {
            AlterTableTest.getLogger().info((Object)("Checking that the constraint " + (Object)((Object)constraint) + " is *not* being applied"));
            constraint.checkConstraint(stmt, false);
        }
    }

    public static GfxdPartitionResolver checkPartitioningColumns(String tableName, String ... columnNames) {
        tableName = tableName.toUpperCase();
        Region reg = CacheFactory.getAnyInstance().getRegion("/" + tableName.replace('.', '/'));
        AlterTableTest.assertNotNull((String)("Could not find region for table " + tableName), (Object)reg);
        RegionAttributes rattr = reg.getAttributes();
        PartitionResolver pr = rattr.getPartitionAttributes().getPartitionResolver();
        AlterTableTest.assertTrue((boolean)(pr instanceof GfxdPartitionResolver));
        GfxdPartitionResolver rpr = (GfxdPartitionResolver)pr;
        Object[] columns = rpr.getColumnNames();
        if (columns == null) {
            columns = new String[]{};
        }
        AlterTableTest.assertEquals((String)("unexpected columns: " + Arrays.toString(columns)), (int)columnNames.length, (int)columns.length);
        for (int index = 0; index < columns.length; ++index) {
            AlterTableTest.assertTrue((String)("Expected column: " + columnNames[index] + "; found: " + (String)columns[index]), (boolean)columnNames[index].equalsIgnoreCase((String)columns[index]));
        }
        return rpr;
    }

    public static void checkDefaultPartitioning(String tableName, String ... columnNames) {
        GfxdPartitionResolver rpr = AlterTableTest.checkPartitioningColumns(tableName, columnNames);
        AlterTableTest.assertTrue((rpr instanceof GfxdPartitionByExpressionResolver && ((GfxdPartitionByExpressionResolver)rpr).isDefaultPartitioning() ? 1 : 0) != 0);
    }

    public static void checkColumnPartitioning(String tableName, String ... columnNames) {
        GfxdPartitionResolver rpr = AlterTableTest.checkPartitioningColumns(tableName, columnNames);
        AlterTableTest.assertTrue((boolean)(rpr instanceof GfxdPartitionByExpressionResolver));
    }

    public static void checkRangePartitioning(String tableName, String ... columnNames) {
        GfxdPartitionResolver rpr = AlterTableTest.checkPartitioningColumns(tableName, columnNames);
        AlterTableTest.assertTrue((boolean)(rpr instanceof GfxdRangePartitionResolver));
    }

    public static MemIndex getMemIndex(long indexNumber) throws SQLException {
        EmbedConnection conn = null;
        boolean contextSet = false;
        try {
            conn = GemFireXDUtils.getTSSConnection((boolean)true, (boolean)false, (boolean)false);
            conn.getTR().setupContextStack();
            contextSet = true;
            LanguageConnectionContext lcc = conn.getLanguageConnection();
            TransactionController tc = lcc.getTransactionCompile();
            MemIndex memIndex = (MemIndex)((GemFireTransaction)tc).findExistingConglomerate(indexNumber);
            return memIndex;
        }
        catch (StandardException ex) {
            ex.printStackTrace();
            throw new SQLException("failed with exception: " + (Object)((Object)ex));
        }
        finally {
            if (contextSet) {
                conn.getTR().restoreContextStack();
            }
        }
    }

    public static TableDescriptor getTableDescriptor(String schemaName, String tableName) throws SQLException {
        EmbedConnection conn = null;
        boolean contextSet = false;
        try {
            schemaName = StringUtil.SQLToUpperCase((String)schemaName);
            tableName = StringUtil.SQLToUpperCase((String)tableName);
            conn = GemFireXDUtils.getTSSConnection((boolean)true, (boolean)false, (boolean)false);
            conn.getTR().setupContextStack();
            contextSet = true;
            LanguageConnectionContext lcc = conn.getLanguageConnection();
            DataDictionary dd = lcc.getDataDictionary();
            TransactionController tc = lcc.getTransactionCompile();
            SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, true);
            TableDescriptor td = dd.getTableDescriptor(tableName, sd, tc);
            dd.getConstraintDescriptors(td);
            TableDescriptor tableDescriptor = td;
            return tableDescriptor;
        }
        catch (StandardException ex) {
            ex.printStackTrace();
            throw new SQLException("failed with exception: " + (Object)((Object)ex));
        }
        finally {
            if (contextSet) {
                conn.getTR().restoreContextStack();
            }
        }
    }

    private static void columnsSQLUpperCase(String[] columnNames) {
        for (int index = 0; index < columnNames.length; ++index) {
            columnNames[index] = StringUtil.SQLToUpperCase((String)columnNames[index]);
        }
    }

    private static String[] getColumnNames(ConglomerateDescriptor conglom, TableDescriptor td) {
        IndexRowGenerator irg = conglom.getIndexDescriptor();
        int[] baseCols = irg.baseColumnPositions();
        String[] columnNames = new String[baseCols.length];
        ColumnDescriptorList colDL = td.getColumnDescriptorList();
        for (int i = 0; i < baseCols.length; ++i) {
            columnNames[i] = colDL.elementAt(baseCols[i] - 1).getColumnName();
        }
        return columnNames;
    }

    public static void checkIndexType(String schemaName, String tableName, String expectedType, String ... columnNames) throws SQLException {
        AlterTableTest.columnsSQLUpperCase(columnNames);
        TableDescriptor td = AlterTableTest.getTableDescriptor(schemaName, tableName);
        String fullTableName = td.getQualifiedName();
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        boolean indexFound = false;
        String indexTypeFound = null;
        Arrays.sort(columnNames);
        for (ConglomerateDescriptor cd : cds) {
            if (!cd.isIndex()) continue;
            Object[] indexCols = AlterTableTest.getColumnNames(cd, td);
            Arrays.sort(indexCols);
            if (!Arrays.equals(columnNames, indexCols) || !expectedType.equals(indexTypeFound = cd.getIndexDescriptor().indexType())) continue;
            indexFound = true;
            MemIndex mi = AlterTableTest.getMemIndex(cd.getConglomerateNumber());
            if ("LOCALHASH1".equals(expectedType)) {
                AlterTableTest.assertTrue((String)("Expected underlying conglomerate LOCALHASH1 but found: " + mi), (boolean)(mi instanceof Hash1Index));
                break;
            }
            if ("GLOBALHASH".equals(expectedType)) {
                AlterTableTest.assertTrue((String)("Expected underlying conglomerate GLOBALHASH but found: " + mi), (boolean)(mi instanceof GlobalHashIndex));
                break;
            }
            if ("LOCALSORTEDMAP".equals(expectedType)) {
                AlterTableTest.assertTrue((String)("Expected underlying conglomerate LOCALSORTEDMAP but found: " + mi), (boolean)(mi instanceof SortedMap2Index));
                break;
            }
            AlterTableTest.fail("Unknown index type: " + expectedType);
            break;
        }
        if (!indexFound) {
            if (indexTypeFound == null) {
                AlterTableTest.fail("Did not find index on columns " + Arrays.toString(columnNames) + " in table " + fullTableName);
            } else {
                AlterTableTest.fail("Did not find the expected index type [" + expectedType + "] found [" + indexTypeFound + "] in table " + fullTableName);
            }
        }
    }

    public static void checkNoIndexType(String schemaName, String tableName, String expectedType, String ... columnNames) throws SQLException {
        AlterTableTest.columnsSQLUpperCase(columnNames);
        TableDescriptor td = AlterTableTest.getTableDescriptor(schemaName, tableName);
        String fullTableName = td.getQualifiedName();
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        String indexTypeFound = null;
        Arrays.sort(columnNames);
        for (ConglomerateDescriptor cd : cds) {
            if (!cd.isIndex()) continue;
            Object[] indexCols = AlterTableTest.getColumnNames(cd, td);
            Arrays.sort(indexCols);
            if (!Arrays.equals(columnNames, indexCols)) continue;
            indexTypeFound = cd.getIndexDescriptor().indexType();
            if (expectedType != null && !expectedType.equals(indexTypeFound)) continue;
            AlterTableTest.fail("Did not expect to find index type [" + expectedType + "] found [" + indexTypeFound + "] in table " + fullTableName);
        }
    }

    public static void checkNoIndex(String schemaName, String tableName, String ... columnNames) throws SQLException {
        AlterTableTest.checkNoIndexType(schemaName, tableName, null, columnNames);
    }

    public static void checkDefaultIndexTypes() throws SQLException {
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "qty");
        AlterTableTest.checkNoIndex("trade", "portfolio", "availQty");
    }

    public void testAddConstraints() throws SQLException {
        Statement stmt;
        PreparedStatement prepStmt;
        Connection conn;
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            conn = AlterTableTest.getConnection();
                            prepStmt = conn.prepareStatement("create schema trade");
                            prepStmt.execute();
                            stmt = conn.createStatement();
                            AlterTableTest.addExpectedException(EntryExistsException.class);
                            prepStmt = conn.prepareStatement("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
                            prepStmt.execute();
                            CreateTableTest.populateData(conn, false, true);
                            AlterTableTest.checkDefaultPartitioning("trade.customers", new String[0]);
                            prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_pk primary key (cid)");
                            try {
                                prepStmt.execute();
                                AlterTableTest.fail("Expected unsupported exception for PK add in ALTER TABLE");
                            }
                            catch (SQLException ex) {
                                if ("0A000".equals(ex.getSQLState())) break block11;
                                throw ex;
                            }
                        }
                        AlterTableTest.checkDefaultPartitioning("trade.customers", new String[0]);
                        stmt.execute("truncate table trade.customers");
                        AlterTableTest.checkDefaultPartitioning("trade.customers", new String[0]);
                        stmt.execute("drop table trade.customers");
                        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
                        prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_pk primary key (cid)");
                        prepStmt.execute();
                        AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
                        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                        CreateTableTest.populateData(conn, false, true);
                        ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
                        AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
                        stmt.execute("truncate table trade.customers");
                        prepStmt = conn.prepareStatement("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid, sid))");
                        prepStmt.execute();
                        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid", "sid");
                        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                        prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict");
                        prepStmt.execute();
                        AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
                        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid", "sid");
                        AlterTableTest.checkColocation("trade.portfolio", null, null);
                        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
                        CreateTableTest.populateData(conn, true, false);
                        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK);
                        stmt.execute("delete from trade.portfolio where 1=1");
                        prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint cust_fk");
                        prepStmt.execute();
                        prepStmt = conn.prepareStatement("alter table trade.customers drop constraint cust_pk");
                        try {
                            prepStmt.execute();
                            AlterTableTest.fail("Expected unsupported exception for PK drop in ALTER TABLE");
                        }
                        catch (SQLException ex) {
                            if ("0A000".equals(ex.getSQLState())) break block12;
                            throw ex;
                        }
                    }
                    stmt.execute("delete from trade.customers where 1=1");
                    AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
                    AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid", "sid");
                    AlterTableTest.checkColocation("trade.portfolio", null, null);
                    AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                    AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                    AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
                    stmt.execute("drop table trade.portfolio");
                    stmt.execute("drop table trade.customers");
                    prepStmt = conn.prepareStatement("create table trade.customers (cid int primary key, cust_name varchar(100), addr varchar(100), tid int)");
                    prepStmt.execute();
                    prepStmt = conn.prepareStatement("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid, sid))");
                    prepStmt.execute();
                    stmt.execute("alter table trade.portfolio drop primary key");
                    AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                    AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid", "sid");
                    AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
                    AlterTableTest.checkColocation("trade.portfolio", null, null);
                    AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                    AlterTableTest.checkNoIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                    AlterTableTest.checkNoIndex("trade", "portfolio", "cid", "sid");
                    CreateTableTest.populateData(conn, true, false);
                    stmt.execute("delete from trade.portfolio where 1=1");
                    stmt.execute("delete from trade.customers where 1=1");
                    prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint portf_pk primary key (sid)");
                    try {
                        prepStmt.execute();
                        AlterTableTest.fail("Expected unsupported exception for PK add in ALTER TABLE");
                    }
                    catch (SQLException ex) {
                        if ("0A000".equals(ex.getSQLState())) break block13;
                        throw ex;
                    }
                }
                stmt.execute("drop table trade.portfolio");
                stmt.execute("drop table trade.customers");
                prepStmt = conn.prepareStatement("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
                prepStmt.execute();
                prepStmt = conn.prepareStatement("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid, sid))");
                prepStmt.execute();
                prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_pk primary key (cid)");
                prepStmt.execute();
                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
                CreateTableTest.populateData(conn, true, false);
                AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.PORT_PK);
                stmt.execute("insert into trade.portfolio values (101, 7, 50, 45, 102)");
                prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict");
                try {
                    prepStmt.execute();
                    AlterTableTest.fail("Expected FK violation with missing referenced key");
                }
                catch (SQLException ex) {
                    if ("X0Y45".equals(ex.getSQLState())) break block14;
                    throw ex;
                }
            }
            AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
            AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
            for (int cid = 40; cid <= 101; ++cid) {
                stmt.execute("delete from trade.portfolio where cid=" + String.valueOf(cid));
            }
            stmt.execute("insert into trade.customers values (101, 'CUST20', 'ADDR20', 25)");
            prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_uk unique (tid)");
            AlterTableTest.addExpectedException("23505");
            try {
                prepStmt.execute();
                AlterTableTest.fail("Expected UK constraint violation");
            }
            catch (SQLException ex) {
                if ("23505".equals(ex.getSQLState())) break block15;
                throw ex;
            }
        }
        AlterTableTest.removeExpectedException("23505");
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkNoIndex("trade", "customers", "tid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
        stmt.execute("delete from trade.customers where cid=101 and tid=25");
        prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_uk unique (tid)");
        prepStmt.execute();
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.PORT_PK);
        prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict");
        prepStmt.execute();
        AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid", "sid");
        AlterTableTest.checkColocation("trade.portfolio", null, null);
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK);
        prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint qty_ck check (qty >= 0)");
        prepStmt.execute();
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1);
        prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint avail_ck check (availQty <= qty)");
        prepStmt.execute();
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "qty");
        AlterTableTest.checkNoIndex("trade", "portfolio", "availQty");
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2);
        AlterTableTest.removeExpectedException(EntryExistsException.class);
    }

    public void testDropConstraints() throws SQLException {
        PreparedStatement prepStmt;
        Statement stmt;
        Connection conn;
        block11: {
            block10: {
                block9: {
                    block8: {
                        conn = AlterTableTest.getConnection();
                        stmt = conn.createStatement();
                        AlterTableTest.addExpectedException(EntryExistsException.class);
                        prepStmt = conn.prepareStatement("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid),constraint cust_uk unique (tid))");
                        prepStmt.execute();
                        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
                        AlterTableTest.checkNoIndex("trade", "customers", "addr");
                        prepStmt = conn.prepareStatement("alter table trade.customers drop primary key");
                        prepStmt.execute();
                        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                        AlterTableTest.checkNoIndex("trade", "customers", "cid");
                        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                        prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_pk primary key (cid)");
                        prepStmt.execute();
                        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                        CreateTableTest.populateData(conn, false, true);
                        ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
                        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                        stmt.execute("delete from trade.customers where 1=1");
                        prepStmt = conn.prepareStatement("alter table trade.customers drop primary key");
                        try {
                            prepStmt.execute();
                            AlterTableTest.fail("Expected unsupported exception for PK drop in ALTER TABLE");
                        }
                        catch (SQLException ex) {
                            if ("0A000".equals(ex.getSQLState())) break block8;
                            throw ex;
                        }
                    }
                    AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                    AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                    AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                    stmt.execute("drop table trade.customers");
                    stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid),constraint cust_uk unique (tid))");
                    prepStmt.execute();
                    AlterTableTest.checkNoIndex("trade", "customers", "cid");
                    AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                    CreateTableTest.populateData(conn, false, true);
                    ConstraintNumber.CUST_PK.checkConstraint(stmt, false);
                    stmt.execute("drop table trade.customers");
                    CreateTableTest.createTables(conn);
                    AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                    AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                    AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                    AlterTableTest.checkDefaultIndexTypes();
                    prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint cust_fk");
                    prepStmt.execute();
                    prepStmt = conn.prepareStatement("alter table trade.customers drop primary key");
                    prepStmt.execute();
                    AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                    AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                    AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                    AlterTableTest.checkNoIndex("trade", "customers", "cid");
                    AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                    AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                    AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
                    prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_pk primary key (cid)");
                    prepStmt.execute();
                    prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict");
                    prepStmt.execute();
                    AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                    AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                    AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                    AlterTableTest.checkDefaultIndexTypes();
                    CreateTableTest.populateData(conn, true, false);
                    prepStmt = conn.prepareStatement("alter table trade.customers drop primary key");
                    try {
                        prepStmt.execute();
                        AlterTableTest.fail("Expected unsupported exception for PK drop in ALTER TABLE");
                    }
                    catch (SQLException ex) {
                        if ("0A000".equals(ex.getSQLState())) break block9;
                        throw ex;
                    }
                }
                prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint portf_pk");
                try {
                    prepStmt.execute();
                    AlterTableTest.fail("Expected unsupported exception for PK drop in ALTER TABLE");
                }
                catch (SQLException ex) {
                    if ("0A000".equals(ex.getSQLState())) break block10;
                    throw ex;
                }
            }
            AlterTableTest.checkDefaultIndexTypes();
            stmt.execute("delete from trade.portfolio where 1=1");
            stmt.execute("delete from trade.customers where 1=1");
            prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint cust_fk");
            prepStmt.execute();
            prepStmt = conn.prepareStatement("alter table trade.customers drop primary key");
            try {
                prepStmt.execute();
                AlterTableTest.fail("Expected unsupported exception for PK drop in ALTER TABLE");
            }
            catch (SQLException ex) {
                if ("0A000".equals(ex.getSQLState())) break block11;
                throw ex;
            }
        }
        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
        AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
        stmt.execute("drop table trade.portfolio");
        stmt.execute("drop table trade.customers");
        CreateTableTest.createTables(conn);
        CreateTableTest.populateData(conn, true, false);
        AlterTableTest.checkDefaultIndexTypes();
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2);
        prepStmt = conn.prepareStatement("alter table trade.customers drop constraint cust_uk");
        prepStmt.execute();
        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
        AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkNoIndex("trade", "customers", "tid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2);
        prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint cust_fk");
        prepStmt.execute();
        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
        AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkNoIndex("trade", "customers", "tid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2);
        prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint qty_ck");
        prepStmt.execute();
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkNoIndex("trade", "customers", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "qty");
        AlterTableTest.checkNoIndex("trade", "portfolio", "availQty");
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK2);
        prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint avail_ck");
        prepStmt.execute();
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkNoIndex("trade", "customers", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
        AlterTableTest.checkNoIndex("trade", "portfolio", "qty");
        AlterTableTest.checkNoIndex("trade", "portfolio", "availQty");
        AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.PORT_PK);
        AlterTableTest.removeExpectedException(EntryExistsException.class);
    }

    public void testAddColumns() throws SQLException {
        PreparedStatement prepStmt;
        Connection conn;
        block5: {
            Statement stmt;
            block4: {
                conn = AlterTableTest.getConnection();
                prepStmt = conn.prepareStatement("create schema trade");
                prepStmt.execute();
                stmt = conn.createStatement();
                AlterTableTest.addExpectedException(EntryExistsException.class);
                prepStmt = conn.prepareStatement("create table trade.customers (cust_name varchar(100), tid int)");
                prepStmt.execute();
                stmt.execute("insert into trade.customers values ('CUST1', 1)");
                AlterTableTest.checkDefaultPartitioning("trade.customers", new String[0]);
                AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
                AlterTableTest.checkNoIndex("trade", "customers", "tid");
                AlterTableTest.checkAddColumnWithData(conn);
                stmt.execute("drop table trade.customers");
                stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int)");
                CreateTableTest.populateData(conn, false, true);
                stmt.execute("alter table trade.customers drop column cid");
                stmt.execute("alter table trade.customers drop column tid");
                stmt.execute("alter table trade.customers add column tid int not null default 1");
                stmt.execute("alter table trade.customers add column cid int not null default 1");
                AlterTableTest.verifyAddColumnWithData(conn, 100, false);
                stmt.execute("drop table trade.customers");
                stmt.execute("create table trade.customers (cust_name varchar(100), tid int)");
                prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_uk unique (tid)");
                prepStmt.execute();
                AlterTableTest.checkDefaultPartitioning("trade.customers", new String[0]);
                AlterTableTest.checkNoIndex("trade", "customers", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                prepStmt = conn.prepareStatement("alter table trade.customers add column cid int not null default 1");
                prepStmt.execute();
                AlterTableTest.checkDefaultPartitioning("trade.customers", new String[0]);
                AlterTableTest.checkNoIndex("trade", "customers", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_pk primary key (cid)");
                prepStmt.execute();
                prepStmt = conn.prepareStatement("alter table trade.customers add column addr varchar(100)");
                prepStmt.execute();
                AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                CreateTableTest.populateData(conn, false, true);
                ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
                ConstraintNumber.CUST_UK.checkConstraint(stmt, true);
                AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                stmt.execute("truncate table trade.customers");
                prepStmt = conn.prepareStatement("create table trade.portfolio (cid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid))");
                prepStmt.execute();
                AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid");
                AlterTableTest.checkNoIndex("trade", "portfolio", "tid");
                prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict");
                prepStmt.execute();
                AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
                AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                AlterTableTest.checkColocation("trade.portfolio", null, null);
                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
                AlterTableTest.checkNoIndex("trade", "portfolio", "tid");
                prepStmt = conn.prepareStatement("alter table trade.portfolio add column sid int not null default 1");
                prepStmt.execute();
                prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint portf_pk");
                prepStmt.execute();
                prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint portf_pk primary key (cid, sid)");
                prepStmt.execute();
                AlterTableTest.checkColumnPartitioning("trade.customers", "cid");
                AlterTableTest.checkColocation("trade.portfolio", null, null);
                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                AlterTableTest.checkNoIndexType("trade", "portfolio", "LOCALHASH1", "cid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                CreateTableTest.populateData(conn, true, false);
                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK);
                stmt.execute("delete from trade.portfolio where 1=1");
                stmt.execute("delete from trade.customers where 1=1");
                prepStmt = conn.prepareStatement("alter table trade.portfolio drop column cid");
                try {
                    prepStmt.execute();
                    AlterTableTest.fail("Expected unsupported exception for PK column drop in ALTER TABLE");
                }
                catch (SQLException ex) {
                    if ("0A000".equals(ex.getSQLState())) break block4;
                    throw ex;
                }
            }
            CreateTableTest.populateData(conn, true, false);
            AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
            AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
            AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK);
            stmt.execute("delete from trade.portfolio where 1=1");
            stmt.execute("delete from trade.customers where 1=1");
            prepStmt = conn.prepareStatement("alter table trade.customers drop constraint cust_uk");
            prepStmt.execute();
            AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
            AlterTableTest.checkNoIndex("trade", "customers", "tid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
            CreateTableTest.populateData(conn, true, false);
            AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK);
            prepStmt = conn.prepareStatement("alter table trade.customers drop column tid");
            prepStmt.execute();
            AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
            AlterTableTest.checkNoIndex("trade", "customers", "tid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
            AlterTableTest.checkConstraints(stmt, new ConstraintNumber[]{ConstraintNumber.CUST_UK}, new ConstraintNumber[]{ConstraintNumber.CUST_PK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK});
            stmt.execute("drop table trade.portfolio");
            stmt.execute("drop table trade.customers");
            prepStmt = conn.prepareStatement("create table trade.customers (cust_name varchar(100), tid int) partition by column (tid)");
            prepStmt.execute();
            prepStmt = conn.prepareStatement("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid, sid))");
            prepStmt.execute();
            AlterTableTest.checkColumnPartitioning("trade.customers", "tid");
            AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid", "sid");
            AlterTableTest.checkNoIndex("trade", "customers", "cid");
            AlterTableTest.checkNoIndex("trade", "customers", "tid");
            AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
            prepStmt = conn.prepareStatement("alter table trade.customers add column cid int not null default 1");
            prepStmt.execute();
            AlterTableTest.checkColumnPartitioning("trade.customers", "tid");
            prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_uk unique (tid)");
            prepStmt.execute();
            AlterTableTest.checkColumnPartitioning("trade.customers", "tid");
            AlterTableTest.checkNoIndex("trade", "customers", "cid");
            AlterTableTest.checkIndexType("trade", "customers", "LOCALSORTEDMAP", "tid");
            prepStmt = conn.prepareStatement("alter table trade.customers add constraint cust_pk primary key (cid)");
            prepStmt.execute();
            AlterTableTest.checkColumnPartitioning("trade.customers", "tid");
            AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "cid");
            AlterTableTest.checkIndexType("trade", "customers", "LOCALSORTEDMAP", "tid");
            prepStmt = conn.prepareStatement("alter table trade.customers add column addr varchar(100)");
            prepStmt.execute();
            AlterTableTest.checkColumnPartitioning("trade.customers", "tid");
            AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "cid");
            AlterTableTest.checkIndexType("trade", "customers", "LOCALSORTEDMAP", "tid");
            prepStmt = conn.prepareStatement("alter table trade.customers drop column tid cascade");
            try {
                prepStmt.execute();
                AlterTableTest.fail("expected failure in partitioning column drop");
            }
            catch (SQLException sqle) {
                if ("0A000".equals(sqle.getSQLState())) break block5;
                throw sqle;
            }
        }
        prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict");
        prepStmt.execute();
        AlterTableTest.checkColumnPartitioning("trade.customers", "tid");
        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid", "sid");
        AlterTableTest.checkColocation("trade.portfolio", null, null);
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "LOCALSORTEDMAP", "tid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
        AlterTableTest.removeExpectedException(EntryExistsException.class);
    }

    public void testDropColumns() throws Exception {
        block41: {
            PreparedStatement prepStmt;
            Connection conn;
            block40: {
                block39: {
                    block38: {
                        Statement stmt;
                        Connection embedConn;
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        block29: {
                                                            block28: {
                                                                embedConn = AlterTableTest.getConnection();
                                                                conn = AlterTableTest.startNetserverAndGetLocalNetConnection();
                                                                stmt = conn.createStatement();
                                                                AlterTableTest.addExpectedException(EntryExistsException.class);
                                                                CreateTableTest.createTables(conn);
                                                                AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                                                AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                                                                AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                                                                AlterTableTest.checkDefaultIndexTypes();
                                                                ConstraintNumber.CUST_PK.checkConstraint(stmt, false);
                                                                prepStmt = conn.prepareStatement("alter table trade.customers drop column cid");
                                                                try {
                                                                    prepStmt.execute();
                                                                    AlterTableTest.fail("Expected unsupported exception for PK column drop in ALTER TABLE");
                                                                }
                                                                catch (SQLException ex) {
                                                                    if ("0A000".equals(ex.getSQLState())) break block28;
                                                                    throw ex;
                                                                }
                                                            }
                                                            prepStmt = conn.prepareStatement("alter table trade.portfolio drop column cid");
                                                            try {
                                                                prepStmt.execute();
                                                                AlterTableTest.fail("Expected unsupported exception for column drop in ALTER TABLE");
                                                            }
                                                            catch (SQLException ex) {
                                                                if ("0A000".equals(ex.getSQLState())) break block29;
                                                                throw ex;
                                                            }
                                                        }
                                                        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                                        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                                                        AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                                                        AlterTableTest.checkDefaultIndexTypes();
                                                        prepStmt = conn.prepareStatement("alter table trade.portfolio drop column sid");
                                                        try {
                                                            prepStmt.execute();
                                                            AlterTableTest.fail("Expected unsupported exception for column drop in ALTER TABLE");
                                                        }
                                                        catch (SQLException ex) {
                                                            if ("0A000".equals(ex.getSQLState())) break block30;
                                                            throw ex;
                                                        }
                                                    }
                                                    AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                                    AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                                                    AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                                                    AlterTableTest.checkDefaultIndexTypes();
                                                    stmt.execute("truncate table trade.portfolio");
                                                    stmt.execute("delete from trade.customers where 1=1");
                                                    prepStmt = conn.prepareStatement("alter table trade.customers drop column cid");
                                                    try {
                                                        prepStmt.execute();
                                                        AlterTableTest.fail("Expected unsupported exception for PK column drop in ALTER TABLE");
                                                    }
                                                    catch (SQLException ex) {
                                                        if ("0A000".equals(ex.getSQLState())) break block31;
                                                        throw ex;
                                                    }
                                                }
                                                AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                                AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                                                AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                                                AlterTableTest.checkDefaultIndexTypes();
                                                stmt.execute("drop table trade.portfolio");
                                                stmt.execute("drop table trade.customers");
                                                stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid),constraint cust_uk unique (tid))");
                                                prepStmt = conn.prepareStatement("alter table trade.customers drop column addr");
                                                prepStmt.execute();
                                                AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                                                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                                                AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
                                                AlterTableTest.checkNoIndex("trade", "customers", "addr");
                                                stmt.execute("insert into trade.customers values (1, 'CUST1', 2)");
                                                try {
                                                    stmt.execute("insert into trade.customers values (1, 'CUST1', 1)");
                                                    AlterTableTest.fail("Expected PK constraint violation");
                                                }
                                                catch (SQLException ex) {
                                                    if ("23505".equals(ex.getSQLState())) break block32;
                                                    throw ex;
                                                }
                                            }
                                            try {
                                                stmt.execute("insert into trade.customers values (3, 'CUST3', 2)");
                                                AlterTableTest.fail("Expected UK constraint violation");
                                            }
                                            catch (SQLException ex) {
                                                if ("23505".equals(ex.getSQLState())) break block33;
                                                throw ex;
                                            }
                                        }
                                        stmt.execute("drop table trade.customers");
                                        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), tid int, primary key (cid),constraint cust_uk unique (tid))");
                                        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                        prepStmt = conn.prepareStatement("alter table trade.customers add column addr varchar(100)");
                                        prepStmt.execute();
                                        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                                        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                                        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
                                        AlterTableTest.checkNoIndex("trade", "customers", "addr");
                                        CreateTableTest.populateData(conn, false, true);
                                        ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
                                        ConstraintNumber.CUST_UK.checkConstraint(stmt, true);
                                        prepStmt = conn.prepareStatement("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint qty_ck check (qty >= 0), constraint avail_ck check (availQty <= qty))");
                                        prepStmt.execute();
                                        AlterTableTest.addExpectedException(UnsupportedOperationException.class);
                                        try {
                                            stmt.execute("drop table trade.customers");
                                            AlterTableTest.fail("Expected colocated table drop to fail");
                                        }
                                        catch (SQLException ex) {
                                            if ("X0Y98".equals(ex.getSQLState())) break block34;
                                            throw ex;
                                        }
                                    }
                                    AlterTableTest.removeExpectedException(UnsupportedOperationException.class);
                                    stmt.execute("drop table trade.portfolio");
                                    stmt.execute("drop table trade.customers");
                                    CreateTableTest.createTables(conn);
                                    prepStmt = conn.prepareStatement("alter table trade.portfolio drop constraint cust_fk");
                                    prepStmt.execute();
                                    AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                    AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                                    AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                                    AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                                    AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                                    AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                                    AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
                                    prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint cust_fk foreign key (tid) references trade.customers (cid) on delete restrict");
                                    prepStmt.execute();
                                    AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                    AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                                    AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                                    AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                                    AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                                    AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                                    AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
                                    AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "tid");
                                    prepStmt = conn.prepareStatement("alter table trade.portfolio drop column sid");
                                    try {
                                        prepStmt.execute();
                                    }
                                    catch (SQLException ex) {
                                        if ("0A000".equals(ex.getSQLState())) break block35;
                                        throw ex;
                                    }
                                }
                                prepStmt = conn.prepareStatement("alter table trade.portfolio drop column tid cascade");
                                prepStmt.execute();
                                AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                                AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                                AlterTableTest.checkNoIndex("trade", "portfolio", "tid");
                                prepStmt = conn.prepareStatement("alter table trade.portfolio add column tid int not null default 1");
                                prepStmt.execute();
                                prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint cust_fk foreign key (tid) references trade.customers (cid) on delete restrict");
                                prepStmt.execute();
                                AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
                                AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
                                AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
                                AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
                                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
                                AlterTableTest.checkNoIndex("trade", "portfolio", "cid");
                                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "tid");
                                CreateTableTest.populateData(conn, true, false);
                                stmt.execute("delete from trade.portfolio where 1=1");
                                stmt.execute("delete from trade.customers where 1=1");
                                prepStmt = conn.prepareStatement("alter table trade.customers drop column cid");
                                try {
                                    prepStmt.execute();
                                    AlterTableTest.fail("Expected unsupported exception for PK column drop in ALTER TABLE");
                                }
                                catch (SQLException ex) {
                                    if ("0A000".equals(ex.getSQLState())) break block36;
                                    throw ex;
                                }
                            }
                            prepStmt = conn.prepareStatement("alter table trade.portfolio drop column tid");
                            try {
                                prepStmt.execute();
                                AlterTableTest.fail("Expected unsupported exception for partitioning column drop in ALTER TABLE with data");
                            }
                            catch (SQLException ex) {
                                if ("X0Y25".equals(ex.getSQLState())) break block37;
                                throw ex;
                            }
                        }
                        stmt.execute("drop table trade.portfolio");
                        stmt.execute("drop table trade.customers");
                        CreateTableTest.createTables(conn);
                        AlterTableTest.checkDropColumnWithData(conn);
                        stmt.execute("drop table trade.portfolio");
                        stmt.execute("drop table trade.customers");
                        CreateTableTest.createTables(conn);
                        AlterTableTest.checkDropColumnWithData(embedConn);
                        stmt.execute("drop table trade.portfolio");
                        stmt.execute("drop table trade.customers");
                        prepStmt = conn.prepareStatement("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid),constraint cust_uk unique (tid)) partition by column (cust_name)");
                        prepStmt.execute();
                        prepStmt = conn.prepareStatement("create table trade.portfolio (cid int not null, sid int not null, qty int not null, availQty int not null, tid int, constraint portf_pk primary key (cid, sid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint qty_ck check (qty >= 0), constraint avail_ck check (availQty <= qty)) partition by range (qty) (values between 0 and 20, values between 20 and 40, values between 40 and 100)");
                        prepStmt.execute();
                        AlterTableTest.checkColumnPartitioning("trade.customers", "cust_name");
                        AlterTableTest.checkRangePartitioning("trade.portfolio", "qty");
                        AlterTableTest.checkColocation("trade.portfolio", null, null);
                        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "cid");
                        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
                        AlterTableTest.checkNoIndex("trade", "customers", "addr");
                        AlterTableTest.checkIndexType("trade", "portfolio", "GLOBALHASH", "cid", "sid");
                        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
                        AlterTableTest.checkNoIndex("trade", "portfolio", "qty");
                        AlterTableTest.checkNoIndex("trade", "portfolio", "availQty");
                        prepStmt = conn.prepareStatement("alter table trade.customers drop column cust_name");
                        try {
                            prepStmt.execute();
                            AlterTableTest.fail("expected failure in dropping partitioning column");
                        }
                        catch (SQLException sqle) {
                            if ("0A000".equals(sqle.getSQLState())) break block38;
                            throw sqle;
                        }
                    }
                    AlterTableTest.checkColumnPartitioning("trade.customers", "cust_name");
                    AlterTableTest.checkRangePartitioning("trade.portfolio", "qty");
                    AlterTableTest.checkColocation("trade.portfolio", null, null);
                    AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "cid");
                    AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                    AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
                    AlterTableTest.checkNoIndex("trade", "customers", "addr");
                    AlterTableTest.checkIndexType("trade", "portfolio", "GLOBALHASH", "cid", "sid");
                    AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
                    prepStmt = conn.prepareStatement("alter table trade.portfolio drop column qty cascade");
                    try {
                        prepStmt.execute();
                        AlterTableTest.fail("expected failure in dropping partitioning column");
                    }
                    catch (SQLException sqle) {
                        if ("0A000".equals(sqle.getSQLState())) break block39;
                        throw sqle;
                    }
                }
                AlterTableTest.checkColumnPartitioning("trade.customers", "cust_name");
                AlterTableTest.checkRangePartitioning("trade.portfolio", "qty");
                AlterTableTest.checkColocation("trade.portfolio", null, null);
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "cid");
                AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
                AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
                AlterTableTest.checkNoIndex("trade", "customers", "addr");
                AlterTableTest.checkIndexType("trade", "portfolio", "GLOBALHASH", "cid", "sid");
                AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
                prepStmt = conn.prepareStatement("alter table trade.customers drop column cid");
                try {
                    prepStmt.execute();
                    AlterTableTest.fail("Expected unsupported exception for PK column drop in ALTER TABLE");
                }
                catch (SQLException ex) {
                    if ("0A000".equals(ex.getSQLState())) break block40;
                    throw ex;
                }
            }
            prepStmt = conn.prepareStatement("alter table trade.portfolio drop column cid");
            try {
                prepStmt.execute();
                AlterTableTest.fail("Expected unsupported exception for PK column drop in ALTER TABLE");
            }
            catch (SQLException ex) {
                if ("0A000".equals(ex.getSQLState())) break block41;
                throw ex;
            }
        }
        AlterTableTest.checkColumnPartitioning("trade.customers", "cust_name");
        AlterTableTest.checkRangePartitioning("trade.portfolio", "qty");
        AlterTableTest.checkColocation("trade.portfolio", null, null);
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        AlterTableTest.checkIndexType("trade", "portfolio", "GLOBALHASH", "cid", "sid");
        AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
        AlterTableTest.removeExpectedException(EntryExistsException.class);
    }

    public void testDropColumnsAffectingIndexes() throws Exception {
        int i;
        Connection embedConn = AlterTableTest.getConnection();
        Connection conn = AlterTableTest.startNetserverAndGetLocalNetConnection();
        Statement stmt = embedConn.createStatement();
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, primary key (cid, tid),constraint cust_uk unique (tid))");
        stmt.execute("create table trade.portfolio (cid int not null, sid int, qty int not null, availQty int not null, tid int not null, constraint portf_pk primary key (tid), constraint cust_fk foreign key (cid, tid) references trade.customers (cid, tid) on delete restrict, constraint qty_ck check (qty >= 0), constraint avail_ck check (availQty <= qty))");
        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid", "tid");
        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid", "tid");
        AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
        stmt.execute("create index idx_cid on trade.customers(cid)");
        stmt.execute("create index idx_name on trade.customers(cust_name, tid)");
        stmt.execute("create index idxp_sid on trade.portfolio(sid, cid)");
        stmt.execute("create index idxp_cid on trade.portfolio(cid)");
        stmt.execute("create index idxp_qty on trade.portfolio(qty, tid)");
        CreateTableTest.populateData(embedConn, true, false, false, false, true, "trade.customers", "trade.portfolio");
        ResultSet rs = stmt.executeQuery("select qty, c.cid, p.tid, cust_name, availQty from trade.portfolio p, trade.customers c where qty = 950 and p.cid = c.cid");
        JDBC.assertFullResultSet(rs, new Object[][]{{950, 95, 96, "CUST95", 855}}, false, true);
        PreparedStatement pstmt = conn.prepareStatement("select cid, cust_name from trade.customers where tid = ?");
        PreparedStatement pstmt2 = embedConn.prepareStatement("select cid, qty from trade.portfolio where tid = ?");
        PreparedStatement pstmt3 = conn.prepareStatement("select qty, cid, tid from trade.portfolio where qty = ? and tid = ?");
        stmt.execute("alter table trade.customers drop column addr");
        AlterTableTest.addExpectedException("01506");
        stmt.execute("alter table trade.portfolio drop column sid cascade");
        AlterTableTest.removeExpectedException("01506");
        PreparedStatement prepStmt = conn.prepareStatement("insert into trade.customers(cid, cust_name, tid) values (?, ?, ?)");
        for (i = 190; i <= 300; ++i) {
            prepStmt.setInt(1, i);
            prepStmt.setString(2, "ADDR" + i / 2);
            prepStmt.setInt(3, i + 1);
            prepStmt.execute();
        }
        prepStmt = embedConn.prepareStatement("insert into trade.portfolio(qty, cid, tid, availQty) values (?, ?, ?, ?)");
        for (i = 190; i <= 300; ++i) {
            prepStmt.setInt(1, i * 5);
            prepStmt.setInt(2, i);
            prepStmt.setInt(3, i + 1);
            prepStmt.setInt(4, i * 4);
            prepStmt.execute();
        }
        rs = stmt.executeQuery("select * from trade.customers where cid = 50 and tid = 51");
        JDBC.assertFullResultSet(rs, new Object[][]{{50, "CUST50", 51}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where cid = 250 and tid = 251");
        JDBC.assertFullResultSet(rs, new Object[][]{{250, "ADDR125", 251}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where tid = 80");
        JDBC.assertFullResultSet(rs, new Object[][]{{79, "CUST79", 80}}, false, true);
        rs = stmt.executeQuery("select cid, cust_name from trade.customers where tid = 260");
        JDBC.assertFullResultSet(rs, new Object[][]{{259, "ADDR129"}}, false, true);
        pstmt.setInt(1, 280);
        rs = pstmt.executeQuery();
        JDBC.assertFullResultSet(rs, new Object[][]{{279, "ADDR139"}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where tid = 180");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select * from trade.customers where cid = 60");
        JDBC.assertFullResultSet(rs, new Object[][]{{60, "CUST60", 61}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where cid = 200");
        JDBC.assertFullResultSet(rs, new Object[][]{{200, "ADDR100", 201}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 50 and tid = 51");
        JDBC.assertFullResultSet(rs, new Object[][]{{50, 500, 450, 51}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 240 and tid = 241");
        JDBC.assertFullResultSet(rs, new Object[][]{{240, 1200, 960, 241}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where tid = 80");
        JDBC.assertFullResultSet(rs, new Object[][]{{79, 790, 711, 80}}, false, true);
        rs = stmt.executeQuery("select cid, qty from trade.portfolio where tid = 260");
        JDBC.assertFullResultSet(rs, new Object[][]{{259, 1295}}, false, true);
        pstmt2.setInt(1, 280);
        rs = pstmt2.executeQuery();
        JDBC.assertFullResultSet(rs, new Object[][]{{279, 1395}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where tid = 150");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 60");
        JDBC.assertFullResultSet(rs, new Object[][]{{60, 600, 540, 61}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 200");
        JDBC.assertFullResultSet(rs, new Object[][]{{200, 1000, 800, 201}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where qty = 945 and tid = 190");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select qty, cid, tid from trade.portfolio where qty = 1000 and tid = 201");
        JDBC.assertFullResultSet(rs, new Object[][]{{1000, 200, 201}}, false, true);
        pstmt3.setInt(1, 1200);
        pstmt3.setInt(2, 241);
        rs = pstmt3.executeQuery();
        JDBC.assertFullResultSet(rs, new Object[][]{{1200, 240, 241}}, false, true);
        rs = stmt.executeQuery("select qty, p.tid, c.cid, cust_name, availQty from trade.portfolio p, trade.customers c where c.tid = p.tid and c.cid = p.cid and qty = 950 and availQty = 760");
        JDBC.assertFullResultSet(rs, new Object[][]{{950, 191, 190, "ADDR95", 760}}, false, true);
        rs = stmt.executeQuery("select qty, c.cid, p.tid, cust_name, availQty from trade.portfolio p, trade.customers c where qty = 950 and p.cid = c.cid");
        JDBC.assertUnorderedResultSet(rs, new Object[][]{{950, 190, 191, "ADDR95", 760}, {950, 95, 96, "CUST95", 855}}, false, true);
    }

    public void testAddDropColumnsAffectingStoreType() throws Exception {
        int i;
        Connection embedConn = AlterTableTest.getConnection();
        Connection conn = AlterTableTest.startNetserverAndGetLocalNetConnection();
        Statement stmt = embedConn.createStatement();
        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, note clob, primary key (cid)) PARTITION BY COLUMN (cust_name)");
        stmt.execute("create table trade.portfolio (cid int not null, sid int, qty int not null, availQty int not null, tid int not null, constraint portf_pk primary key (tid), constraint cust_fk foreign key (cid) references trade.customers (cid) on delete restrict, constraint qty_ck check (qty >= 0), constraint avail_ck check (availQty <= qty))");
        AlterTableTest.checkColumnPartitioning("trade.customers", "cust_name");
        AlterTableTest.checkDefaultPartitioning("trade.portfolio", "tid");
        AlterTableTest.checkColocation("trade.portfolio", null, null);
        stmt.execute("create index idx_cid on trade.customers(cid)");
        stmt.execute("create index idx_name on trade.customers(cust_name, tid)");
        stmt.execute("create index idxp_sid on trade.portfolio(sid, cid)");
        stmt.execute("create index idxp_cid on trade.portfolio(cid)");
        stmt.execute("create index idxp_qty on trade.portfolio(qty, tid)");
        CreateTableTest.populateData(embedConn, true, false, false, false, true, "trade.customers", "trade.portfolio");
        stmt.execute("update trade.customers set note='NONE'");
        ResultSet rs = stmt.executeQuery("select qty, c.cid, p.tid, cust_name, availQty from trade.portfolio p, trade.customers c where qty = 950 and p.cid = c.cid");
        JDBC.assertFullResultSet(rs, new Object[][]{{950, 95, 96, "CUST95", 855}}, false, true);
        PreparedStatement pstmt = conn.prepareStatement("select cid, cust_name from trade.customers where tid = ?");
        PreparedStatement pstmt2 = embedConn.prepareStatement("select cid, qty from trade.portfolio where tid = ?");
        PreparedStatement pstmt3 = conn.prepareStatement("select qty, cid, tid from trade.portfolio where qty = ? and tid = ?");
        stmt.execute("alter table trade.customers drop column addr");
        stmt.execute("alter table trade.customers drop column note");
        AlterTableTest.addExpectedException("01506");
        stmt.execute("alter table trade.portfolio drop column sid cascade");
        AlterTableTest.removeExpectedException("01506");
        stmt.execute("alter table trade.portfolio add column note clob default 'NONE'");
        PreparedStatement prepStmt = conn.prepareStatement("insert into trade.customers(cid, cust_name, tid) values (?, ?, ?)");
        for (i = 190; i <= 200; ++i) {
            prepStmt.setInt(1, i);
            prepStmt.setString(2, "ADDR" + i / 2);
            prepStmt.setInt(3, i + 1);
            prepStmt.execute();
        }
        prepStmt = embedConn.prepareStatement("insert into trade.portfolio(qty, cid, tid, availQty, note) values (?, ?, ?, ?, ?)");
        for (i = 190; i <= 200; ++i) {
            prepStmt.setInt(1, i * 5);
            prepStmt.setInt(2, i);
            prepStmt.setInt(3, i + 1);
            prepStmt.setInt(4, i * 4);
            prepStmt.setString(5, "NOTE" + i);
            prepStmt.execute();
        }
        stmt.execute("update trade.customers set tid = 200 where cid > 190");
        stmt.execute("update trade.portfolio set note = 'NOTE' where cid < 50 or cid > 195");
        rs = stmt.executeQuery("select * from trade.customers where cid = 50 and tid = 51");
        JDBC.assertFullResultSet(rs, new Object[][]{{50, "CUST50", 51}}, false, true);
        rs = stmt.executeQuery("select count(*) from trade.customers where cust_name is not null");
        JDBC.assertFullResultSet(rs, new Object[][]{{111}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where cust_name = 'CUST50' or cust_name = 'ADDR96'");
        JDBC.assertUnorderedResultSet(rs, new Object[][]{{50, "CUST50", 51}, {192, "ADDR96", 200}, {193, "ADDR96", 200}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where tid = 80 and cust_name is not null");
        JDBC.assertFullResultSet(rs, new Object[][]{{79, "CUST79", 80}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where tid = 180");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select * from trade.customers where cid = 60");
        JDBC.assertFullResultSet(rs, new Object[][]{{60, "CUST60", 61}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where cid = 200 and cust_name is not null");
        JDBC.assertFullResultSet(rs, new Object[][]{{200, "ADDR100", 200}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 50 and tid = 51");
        JDBC.assertFullResultSet(rs, new Object[][]{{50, 500, 450, 51, "NONE"}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where tid = 80");
        JDBC.assertFullResultSet(rs, new Object[][]{{79, 790, 711, 80, "NONE"}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where tid = 150");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 60");
        JDBC.assertFullResultSet(rs, new Object[][]{{60, 600, 540, 61, "NONE"}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 200 and note is not null");
        JDBC.assertFullResultSet(rs, new Object[][]{{200, 1000, 800, 201, "NOTE"}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where qty = 945 and tid = 190");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where tid = 195 and note is not null");
        JDBC.assertFullResultSet(rs, new Object[][]{{194, 970, 776, 195, "NOTE194"}}, false, true);
        rs = stmt.executeQuery("select qty, p.tid, c.cid, cust_name, availQty from trade.portfolio p, trade.customers c where c.tid = p.tid and c.cid = p.cid and qty = 950 and availQty = 760");
        JDBC.assertFullResultSet(rs, new Object[][]{{950, 191, 190, "ADDR95", 760}}, false, true);
        rs = stmt.executeQuery("select qty, c.cid, p.tid, cust_name, availQty, note from trade.portfolio p, trade.customers c where qty = 950 and p.cid = c.cid order by cust_name");
        JDBC.assertFullResultSet(rs, new Object[][]{{950, 190, 191, "ADDR95", 760, "NOTE190"}, {950, 95, 96, "CUST95", 855, "NONE"}}, false, true);
        stmt.execute("alter table trade.customers add column note clob default 'NULL'");
        stmt.execute("alter table trade.portfolio drop column note");
        prepStmt = conn.prepareStatement("insert into trade.customers(cid, cust_name, tid, note) values (?, ?, ?, ?)");
        for (i = 201; i <= 300; ++i) {
            prepStmt.setInt(1, i);
            prepStmt.setString(2, "ADDR" + i / 2);
            prepStmt.setInt(3, i + 1);
            prepStmt.setString(4, "CUSTNOTE" + i);
            prepStmt.execute();
        }
        prepStmt = embedConn.prepareStatement("insert into trade.portfolio(qty, cid, tid, availQty) values (?, ?, ?, ?)");
        for (i = 201; i <= 300; ++i) {
            prepStmt.setInt(1, i * 5);
            prepStmt.setInt(2, i);
            prepStmt.setInt(3, i + 1);
            prepStmt.setInt(4, i * 4);
            prepStmt.execute();
        }
        stmt.execute("update trade.customers set note = 'NOTE' where cid < 50 or cid > 256 or (cid > 192 and cid < 200)");
        stmt.execute("update trade.portfolio set qty = availQty*2 where cid > 250");
        rs = stmt.executeQuery("select * from trade.customers where cid = 50 and tid = 51");
        JDBC.assertFullResultSet(rs, new Object[][]{{50, "CUST50", 51, "NULL"}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where cid = 250 and tid = 251");
        JDBC.assertFullResultSet(rs, new Object[][]{{250, "ADDR125", 251, "CUSTNOTE250"}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where (cid = 250 and tid = 251) or tid = 300 or cid = 80 order by cust_name");
        JDBC.assertFullResultSet(rs, new Object[][]{{250, "ADDR125", 251, "CUSTNOTE250"}, {299, "ADDR149", 300, "NOTE"}, {80, "CUST80", 81, "NULL"}}, false, true);
        rs = stmt.executeQuery("select cid, cust_name from trade.customers where tid = 260");
        JDBC.assertFullResultSet(rs, new Object[][]{{259, "ADDR129"}}, false, true);
        pstmt.setInt(1, 280);
        rs = pstmt.executeQuery();
        JDBC.assertFullResultSet(rs, new Object[][]{{279, "ADDR139"}}, false, true);
        rs = stmt.executeQuery("select count(*) from trade.customers where cust_name is not null");
        JDBC.assertFullResultSet(rs, new Object[][]{{211}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where cust_name = 'CUST50' or cust_name = 'ADDR96'");
        JDBC.assertUnorderedResultSet(rs, new Object[][]{{50, "CUST50", 51, "NULL"}, {192, "ADDR96", 200, "NULL"}, {193, "ADDR96", 200, "NOTE"}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where tid = 80 and cust_name is not null");
        JDBC.assertFullResultSet(rs, new Object[][]{{79, "CUST79", 80, "NULL"}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where tid = 180");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select * from trade.customers where cid = 60");
        JDBC.assertFullResultSet(rs, new Object[][]{{60, "CUST60", 61, "NULL"}}, false, true);
        rs = stmt.executeQuery("select * from trade.customers where cid = 200 and cust_name is not null");
        JDBC.assertFullResultSet(rs, new Object[][]{{200, "ADDR100", 200, "NULL"}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 50 and tid = 51");
        JDBC.assertFullResultSet(rs, new Object[][]{{50, 500, 450, 51}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where tid = 80");
        JDBC.assertFullResultSet(rs, new Object[][]{{79, 790, 711, 80}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where tid = 150");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 60");
        JDBC.assertFullResultSet(rs, new Object[][]{{60, 600, 540, 61}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 200");
        JDBC.assertFullResultSet(rs, new Object[][]{{200, 1000, 800, 201}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where qty = 945 and tid = 190");
        JDBC.assertFullResultSet(rs, new Object[0][], false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where tid = 195");
        JDBC.assertFullResultSet(rs, new Object[][]{{194, 970, 776, 195}}, false, true);
        rs = stmt.executeQuery("select * from trade.portfolio where cid = 240 and tid = 241");
        JDBC.assertFullResultSet(rs, new Object[][]{{240, 1200, 960, 241}}, false, true);
        rs = stmt.executeQuery("select cid, qty from trade.portfolio where tid = 260");
        JDBC.assertFullResultSet(rs, new Object[][]{{259, 2072}}, false, true);
        pstmt2.setInt(1, 280);
        rs = pstmt2.executeQuery();
        JDBC.assertFullResultSet(rs, new Object[][]{{279, 2232}}, false, true);
        pstmt3.setInt(1, 1200);
        pstmt3.setInt(2, 241);
        rs = pstmt3.executeQuery();
        JDBC.assertFullResultSet(rs, new Object[][]{{1200, 240, 241}}, false, true);
        rs = stmt.executeQuery("select qty, p.tid, c.cid, cust_name, availQty from trade.portfolio p, trade.customers c where c.tid = p.tid and c.cid = p.cid and qty = 950 and availQty = 760");
        JDBC.assertFullResultSet(rs, new Object[][]{{950, 191, 190, "ADDR95", 760}}, false, true);
        rs = stmt.executeQuery("select qty, c.cid, p.tid, cust_name, availQty, note from trade.portfolio p, trade.customers c where (qty = 950 or qty = 1100) and p.cid = c.cid");
        JDBC.assertUnorderedResultSet(rs, new Object[][]{{950, 190, 191, "ADDR95", 760, "NULL"}, {1100, 220, 221, "ADDR110", 880, "CUSTNOTE220"}, {950, 95, 96, "CUST95", 855, "NULL"}}, false, true);
    }

    public void testTruncateTable() throws SQLException {
        Statement stmt;
        Connection conn;
        block2: {
            conn = AlterTableTest.getConnection();
            stmt = conn.createStatement();
            AlterTableTest.addExpectedException(EntryExistsException.class);
            CreateTableTest.createTables(conn);
            AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
            AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
            AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
            AlterTableTest.checkDefaultIndexTypes();
            PreparedStatement prepStmt = conn.prepareStatement("alter table trade.portfolio add constraint port_uk unique (tid)");
            prepStmt.execute();
            AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
            AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
            AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
            AlterTableTest.checkDefaultIndexTypes();
            AlterTableTest.checkIndexType("trade", "portfolio", "GLOBALHASH", "tid");
            CreateTableTest.populateData(conn, true, false);
            AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
            AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
            AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
            AlterTableTest.checkDefaultIndexTypes();
            AlterTableTest.checkIndexType("trade", "portfolio", "GLOBALHASH", "tid");
            AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2);
            stmt.execute("truncate table trade.portfolio");
            stmt.execute("delete from trade.customers where 1=1");
            AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
            AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
            AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
            AlterTableTest.checkDefaultIndexTypes();
            AlterTableTest.checkIndexType("trade", "portfolio", "GLOBALHASH", "tid");
            CreateTableTest.populateData(conn, true, false);
            AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
            AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
            AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
            AlterTableTest.checkDefaultIndexTypes();
            AlterTableTest.checkIndexType("trade", "portfolio", "GLOBALHASH", "tid");
            AlterTableTest.checkConstraints(stmt, ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2);
            try {
                stmt.execute("truncate table trade.customers");
                AlterTableTest.fail("Expected exception in truncate table due to child table");
            }
            catch (SQLException ex) {
                if ("XCL48".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        stmt.execute("drop table trade.portfolio");
        stmt.execute("truncate table trade.customers");
        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        CreateTableTest.populateData(conn, false, true);
        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
        AlterTableTest.checkColocation("trade.customers", null, null);
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
        ConstraintNumber.CUST_UK.checkConstraint(stmt, true);
        stmt.execute("truncate table trade.customers");
        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        CreateTableTest.populateData(conn, false, true);
        AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
        AlterTableTest.checkColocation("trade.customers", null, null);
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "cust_name");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        ConstraintNumber.CUST_PK.checkConstraint(stmt, true);
        ConstraintNumber.CUST_UK.checkConstraint(stmt, true);
        stmt.execute("drop table trade.customers");
        AlterTableTest.removeExpectedException(EntryExistsException.class);
    }

    public void testBug41062_1() throws Exception {
        Connection conn = AlterTableTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create schema TEST");
        s.execute("create table TEST.TESTTABLE1 (ID int primary key, TYPE int, ADDRESS varchar(1024),DESCRIPTION varchar(1024))");
        s.execute("alter table TEST.TESTTABLE1 add constraint cust_fk1 foreign key (type) references TEST.TESTTABLE1 ");
        s.execute("create table TEST.TESTTABLE2 (ID int primary key,  TYPE int, ADDRESS varchar(1024), DESCRIPTION varchar(1024), constraint cust_fk2 foreign key (type) references TEST.TESTTABLE2(ID))");
    }

    public void testBug41062_2() throws Exception {
        Connection conn = AlterTableTest.getConnection();
        Statement s = conn.createStatement();
        s.execute("create table TESTTABLE1 (ID int primary key,  TYPE int, ADDRESS varchar(1024), DESCRIPTION varchar(1024), constraint cust_fk1 foreign key (type) references TESTTABLE1(ID))");
        s.execute("create schema TEST");
        s.execute("create table TEST.TESTTABLE2 (ID int primary key, TYPE int, ADDRESS varchar(1024), DESCRIPTION varchar(1024), constraint cust_fk2 foreign key (type) references TEST.TESTTABLE2(ID))");
    }

    public void testUnsupportedFeatures_40712() throws Exception {
        block11: {
            Statement stmt;
            block10: {
                block9: {
                    block8: {
                        Connection conn = AlterTableTest.getConnection();
                        stmt = conn.createStatement();
                        stmt.execute("create table trade.customers (cid int not null, cust_name varchar(100), addr varchar(100), tid int, rid int GENERATED ALWAYS AS IDENTITY, primary key (cid), constraint cust_uk unique (tid))");
                        try {
                            stmt.execute("alter table trade.customers alter column cust_name set data type varchar(200)");
                            AlterTableTest.fail("exepected unsupported exception");
                        }
                        catch (SQLException sqle) {
                            if ("0A000".equals(sqle.getSQLState())) break block8;
                            throw sqle;
                        }
                    }
                    try {
                        stmt.execute("alter table trade.customers alter column addr not null");
                        AlterTableTest.fail("exepected unsupported exception");
                    }
                    catch (SQLException sqle) {
                        if ("0A000".equals(sqle.getSQLState())) break block9;
                        throw sqle;
                    }
                }
                try {
                    stmt.execute("alter table trade.customers alter column cid null");
                    AlterTableTest.fail("exepected unsupported exception");
                }
                catch (SQLException sqle) {
                    if ("42Z20".equals(sqle.getSQLState())) break block10;
                    throw sqle;
                }
            }
            try {
                stmt.execute("alter table trade.customers alter column tid default 10");
                AlterTableTest.fail("exepected unsupported exception");
            }
            catch (SQLException sqle) {
                if ("0A000".equals(sqle.getSQLState())) break block11;
                throw sqle;
            }
        }
    }

    public void testAlterTableDisAllowed() throws SQLException {
        block2: {
            Properties p = new Properties();
            p.setProperty("host-data", "true");
            p.setProperty("mcast-port", "0");
            p.setProperty("gemfire.enable-time-statistics", "true");
            p.setProperty("statistic-sample-rate", "100");
            p.setProperty("statistic-sampling-enabled", "true");
            p.setProperty("enable-stats", "true");
            p.setProperty("enable-timestats", "true");
            p.setProperty("statistic-archive-file", "client-1.gfs");
            p.put("user", "Soubhik");
            p.put("password", "Soubhik");
            Connection conn = TestUtil.getConnection();
            Statement st = conn.createStatement();
            st.execute("create table CHEESE (CHEESE_CODE VARCHAR(5) not null, CHEESE_NAME VARCHAR(20), CHEESE_COST DECIMAL(7,4))");
            st.execute("INSERT INTO CHEESE (CHEESE_CODE, CHEESE_NAME, CHEESE_COST) VALUES ('00000', 'GOUDA', 001.1234), ('00000', 'EDAM', 002.1111), ('54321', 'EDAM', 008.5646), ('12345', 'GORGONZOLA', 888.2309), ('AAAAA', 'EDAM', 999.8888), ('54321', 'MUENSTER', 077.9545)");
            st.execute("create index cheese_index on CHEESE (CHEESE_CODE DESC, CHEESE_NAME DESC, CHEESE_COST DESC)");
            try {
                st.execute("alter table CHEESE add constraint pk_cheese PRIMARY KEY (CHEESE_CODE)");
                AlterTableTest.fail("alter table exception must have occurred");
            }
            catch (SQLException e) {
                if ("0A000".equalsIgnoreCase(e.getSQLState())) break block2;
                AlterTableTest.fail("Alter table exception should have occurred but have different exception", e);
            }
        }
    }

    public void testIdentityColumnWithWAN() throws Exception {
        block2: {
            AlterTableTest.setupConnection();
            Connection conn = TestUtil.jdbcConn;
            Statement stmt = conn.createStatement();
            stmt.execute("create table trade.customers (tid int, cid int not null, primary key (cid), constraint cust_ck check (cid >= 0))");
            stmt.execute("alter table trade.customers alter column cid SET GENERATED ALWAYS AS IDENTITY");
            stmt.execute("drop table trade.customers");
            stmt.execute("create table trade.customers (tid int, cid bigint not null GENERATED ALWAYS AS IDENTITY, primary key (cid), constraint cust_ck check (cid >= 0))");
            stmt.execute("alter table trade.customers SET GATEWAYSENDER (MYSENDER)");
            stmt.execute("drop table trade.customers");
            try {
                stmt.execute("create table trade.customers (tid int, cid int not null GENERATED ALWAYS AS IDENTITY, primary key (cid), constraint cust_ck check (cid >= 0))");
                stmt.execute("alter table trade.customers SET GATEWAYSENDER (MYSENDER)");
            }
            catch (Exception e) {
                if (e.getMessage().contains("LTER TABLE statement cannot add gatewaysender to a table")) break block2;
                AlterTableTest.fail("Unexpected exception", e);
            }
        }
    }

    public void testAddGeneratedIdentityColumn() throws Exception {
        AlterTableTest.setupConnection();
        Connection conn = TestUtil.jdbcConn;
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (tid int, cid int not null, primary key (cid), constraint cust_ck check (cid >= 0))");
        int maxValue = 1000;
        int stepValue = 3;
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.customers (tid, cid) values (?, ?)");
        for (int v = 1; v <= 1000; v += stepValue) {
            pstmt.setInt(1, v * stepValue);
            pstmt.setInt(2, v);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        stmt.execute("alter table trade.customers alter column cid SET GENERATED ALWAYS AS IDENTITY");
        SQLWarning sw = stmt.getWarnings();
        AlterTableTest.assertNull((Object)sw);
        int numRows = 2000;
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, -1000, 0, null, true);
        stmt.execute("drop table trade.customers");
        stmt.execute("create table trade.customers (tid int, cid bigint not null, addr varchar(100), primary key (cid), constraint cust_ck check (cid >= 0))");
        stepValue = 2;
        pstmt = conn.prepareStatement("insert into trade.customers (cid, tid) values (?, ?)");
        for (int v = 1; v <= 1000; v += stepValue) {
            pstmt.setInt(2, v);
            pstmt.setInt(1, v * stepValue);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        stmt.execute("alter table trade.customers alter cid SET GENERATED ALWAYS AS IDENTITY");
        AlterTableTest.assertNull((Object)stmt.getWarnings());
        CreateTableTest.runIdentityChecksForCustomersTable(conn, 2000, new int[]{2}, new String[]{"CID"}, 1, -(1000 * stepValue), 0, null, true);
        stmt.execute("drop table trade.customers");
    }

    public void testSetGeneratedAlways() throws Exception {
        Connection conn = AlterTableTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table IDTABLE (ID int not null, phone int not null)");
        stmt.execute("alter table IDTABLE alter column id SET GENERATED always AS IDENTITY");
        conn.createStatement().execute("insert into IDTABLE (id, phone) values (default,1)");
        conn.createStatement().execute("insert into IDTABLE (phone) values (1)");
        ResultSet rs = conn.createStatement().executeQuery("select max(id) from IDTABLE ");
        rs.next();
        AlterTableTest.assertEquals((int)2, (int)rs.getInt(1));
    }

    public void testChangeStartWith() throws Exception {
        Connection conn = AlterTableTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table IDTABLE (ID int not null generated by default as identity (start with 5, increment by 2), phone int not null)");
        conn.createStatement().execute("insert into IDTABLE (phone) values (1)");
        conn.createStatement().execute("insert into IDTABLE (phone) values (2)");
        stmt.execute("alter table IDTABLE alter column id restart with 20");
        stmt.execute("alter table IDTABLE alter column id set increment by 10");
        conn.createStatement().execute("insert into IDTABLE (phone) values (3)");
        conn.createStatement().execute("insert into IDTABLE (phone) values (4)");
        ResultSet rs = conn.createStatement().executeQuery("select id from IDTABLE order by phone");
        rs.next();
        AlterTableTest.assertEquals((int)5, (int)rs.getInt(1));
        rs.next();
        AlterTableTest.assertEquals((int)7, (int)rs.getInt(1));
        rs.next();
        AlterTableTest.assertEquals((int)20, (int)rs.getInt(1));
        rs.next();
        AlterTableTest.assertEquals((int)30, (int)rs.getInt(1));
    }

    public void testNWEA() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.customers (tid int, cid int not null, primary key (cid), constraint cust_ck check (cid >= 0))");
        int maxValue = 1000;
        int stepValue = 3;
        PreparedStatement pstmt = conn.prepareStatement("insert into trade.customers values (?, ?)");
        for (int v = 1; v <= 1000; v += stepValue) {
            pstmt.setInt(1, v * stepValue);
            pstmt.setInt(2, v);
            pstmt.addBatch();
        }
        pstmt.executeBatch();
        stmt.execute("create table trade.customers1 (tid int, cid int not null, primary key (cid), constraint cust1_ck check (cid >= 0))");
        int maxValue1 = 1000;
        int stepValue1 = 3;
        PreparedStatement pstmt1 = conn.prepareStatement("insert into trade.customers1 values (?, ?)");
        for (int v = 1; v <= 1000; v += stepValue1) {
            pstmt1.setInt(1, v * stepValue1);
            pstmt1.setInt(2, v);
            pstmt1.addBatch();
        }
        pstmt1.executeBatch();
        stmt.execute("alter table trade.customers alter column cid SET GENERATED ALWAYS AS IDENTITY");
        stmt.execute("alter table trade.customers1 alter column cid SET GENERATED ALWAYS AS IDENTITY");
    }

    public void testAlterRestrictCKUndo() throws Exception {
        Statement stmt;
        block2: {
            Connection conn = AlterTableTest.getConnection();
            stmt = conn.createStatement();
            stmt.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null,price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id),constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))partition by range (sec_id) ( VALUES BETWEEN 0 AND 409, VALUES BETWEEN 409 AND 1102, VALUES BETWEEN 1102 AND 1251, VALUES BETWEEN 1251 AND 1477, VALUES BETWEEN 1477 AND 1700, VALUES BETWEEN 1700 AND 10000)");
            try {
                stmt.execute("alter table trade.securities drop column symbol restrict");
                AlterTableTest.fail("alter table drop column restrict should have failed w/sqlstate X0Y25");
            }
            catch (SQLException e) {
                if ("X0Y25".equalsIgnoreCase(e.getSQLState())) break block2;
                AlterTableTest.fail("Alter table exception should have occurred but have different exception", e);
            }
        }
        stmt.execute("alter table trade.securities drop unique SEC_UQ");
        stmt.execute("alter table trade.securities drop column symbol restrict");
        stmt.execute("alter table trade.securities add column symbol varchar(10)");
        stmt.execute("alter table trade.securities add constraint sec_uq unique (symbol,exchange)");
        stmt.execute("update trade.securities set price = 5.0 where sec_id = 5 and tid=5");
    }

    public void testAlterTableIndexTypes() throws Exception {
        Connection conn = AlterTableTest.getConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("create table trade.securities (sec_id int not null, symbol varchar(10) not null,price decimal (30, 20), exchange varchar(10) not null, tid int, constraint sec_pk primary key (sec_id),constraint sec_uq unique (symbol, exchange), constraint exc_ch check (exchange in ('nasdaq', 'nye', 'amex', 'lse', 'fse', 'hkse', 'tse')))partition by range (price) (VALUES BETWEEN 0.0 AND 25.0,  VALUES BETWEEN 25.0  AND 35.0 , VALUES BETWEEN 35.0  AND 49.0, VALUES BETWEEN 49.0  AND 69.0 ,VALUES BETWEEN 69.0 AND 100.0)");
        AlterTableTest.checkIndexType("trade", "securities", "GLOBALHASH", "symbol", "exchange");
        stmt.execute("alter table trade.securities drop unique SEC_UQ");
        stmt.execute("alter table trade.securities drop column symbol restrict");
        stmt.execute("alter table trade.securities add column symbol varchar(10) not null default 'a'");
        stmt.execute("alter table trade.securities add constraint sec_uq unique (symbol,exchange)");
        AlterTableTest.checkIndexType("trade", "securities", "GLOBALHASH", "symbol", "exchange");
    }

    public static void checkAddColumnWithData(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        PreparedStatement prepStmt = conn.prepareStatement("alter table trade.customers add column cid int not null default 1");
        prepStmt.execute();
        stmt.execute("insert into trade.customers (cust_name, tid) values ('CUST1', 1)");
        stmt.execute("insert into trade.customers (cust_name, tid) values ('CUST2', 2)");
        stmt.execute("insert into trade.customers values ('CUST3', 3, 3)");
        Object[][] expectedRows = new Object[][]{{"CUST1", 1, 1}, {"CUST1", 1, 1}, {"CUST2", 2, 1}, {"CUST3", 3, 3}};
        ResultSet rs = stmt.executeQuery("select * from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        expectedRows = new Object[][]{{"CUST1", 1}, {"CUST1", 1}, {"CUST2", 1}, {"CUST3", 3}};
        rs = stmt.executeQuery("select cust_name, cid from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        AlterTableTest.assertEquals((int)2, (int)stmt.executeUpdate("update trade.customers set cid=2 where tid=1"));
        expectedRows = new Object[][]{{"CUST1", 1, 2}, {"CUST1", 1, 2}, {"CUST2", 2, 1}, {"CUST3", 3, 3}};
        rs = stmt.executeQuery("select * from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        expectedRows = new Object[][]{{"CUST1", 2}, {"CUST1", 2}, {"CUST2", 1}, {"CUST3", 3}};
        rs = stmt.executeQuery("select cust_name, cid from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        AlterTableTest.assertEquals((int)2, (int)stmt.executeUpdate("update trade.customers set tid=2 where cid=2"));
        AlterTableTest.assertEquals((int)1, (int)stmt.executeUpdate("update trade.customers set tid=20 where cust_name='CUST2'"));
        expectedRows = new Object[][]{{"CUST1", 2, 2}, {"CUST1", 2, 2}, {"CUST2", 20, 1}, {"CUST3", 3, 3}};
        rs = stmt.executeQuery("select * from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        expectedRows = new Object[][]{{"CUST1", 2}, {"CUST1", 2}, {"CUST2", 20}, {"CUST3", 3}};
        rs = stmt.executeQuery("select cust_name, tid from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        prepStmt = conn.prepareStatement("alter table trade.customers add column addr varchar(100)");
        prepStmt.execute();
        AlterTableTest.checkDefaultPartitioning("trade.customers", new String[0]);
        AlterTableTest.checkNoIndex("trade", "customers", "cid");
        AlterTableTest.checkNoIndex("trade", "customers", "tid");
        AlterTableTest.checkNoIndex("trade", "customers", "addr");
        stmt.execute("insert into trade.customers (cust_name, tid) values ('CUST1', 1)");
        stmt.execute("insert into trade.customers (cust_name, tid, cid) values ('CUST2', 2, 2)");
        stmt.execute("insert into trade.customers values ('CUST3', 3, 3, 'ADDR3')");
        expectedRows = new Object[][]{{"CUST1", 2, 2, null}, {"CUST1", 2, 2, null}, {"CUST2", 20, 1, null}, {"CUST3", 3, 3, null}, {"CUST1", 1, 1, null}, {"CUST2", 2, 2, null}, {"CUST3", 3, 3, "ADDR3"}};
        rs = stmt.executeQuery("select * from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        expectedRows = new Object[][]{{"CUST1", 2, null}, {"CUST1", 2, null}, {"CUST2", 20, null}, {"CUST3", 3, null}, {"CUST1", 1, null}, {"CUST2", 2, null}, {"CUST3", 3, "ADDR3"}};
        rs = stmt.executeQuery("select cust_name, tid, addr from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        AlterTableTest.assertEquals((int)2, (int)stmt.executeUpdate("update trade.customers set cid=2 where tid=3"));
        expectedRows = new Object[][]{{"CUST1", 2, 2, null}, {"CUST1", 2, 2, null}, {"CUST2", 20, 1, null}, {"CUST3", 3, 2, null}, {"CUST1", 1, 1, null}, {"CUST2", 2, 2, null}, {"CUST3", 3, 2, "ADDR3"}};
        rs = stmt.executeQuery("select * from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        expectedRows = new Object[][]{{"CUST1", 2, null}, {"CUST1", 2, null}, {"CUST2", 1, null}, {"CUST3", 2, null}, {"CUST1", 1, null}, {"CUST2", 2, null}, {"CUST3", 2, "ADDR3"}};
        rs = stmt.executeQuery("select cust_name, cid, addr from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        AlterTableTest.assertEquals((int)2, (int)stmt.executeUpdate("update trade.customers set addr='ADDR30' where cust_name='CUST3'"));
        AlterTableTest.assertEquals((int)2, (int)stmt.executeUpdate("update trade.customers set tid=30 where addr='ADDR30'"));
        AlterTableTest.verifyAddColumnWithData(conn);
    }

    public static void verifyAddColumnWithData(Connection conn) throws SQLException {
        Statement stmt = conn.createStatement();
        Object[][] expectedRows = new Object[][]{{"CUST1", 2, 2, null}, {"CUST1", 2, 2, null}, {"CUST2", 20, 1, null}, {"CUST3", 30, 2, "ADDR30"}, {"CUST1", 1, 1, null}, {"CUST2", 2, 2, null}, {"CUST3", 30, 2, "ADDR30"}};
        ResultSet rs = stmt.executeQuery("select * from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
        expectedRows = new Object[][]{{"CUST1", 2, null}, {"CUST1", 2, null}, {"CUST2", 20, null}, {"CUST3", 30, "ADDR30"}, {"CUST1", 1, null}, {"CUST2", 2, null}, {"CUST3", 30, "ADDR30"}};
        rs = stmt.executeQuery("select cust_name, tid, addr from trade.customers");
        JDBC.assertUnorderedResultSet(rs, expectedRows, false);
    }

    public static void verifyAddColumnWithData(Connection conn, int numExpected, boolean afterUpdate) throws SQLException {
        int tid;
        int index;
        String addr;
        String custName;
        Statement stmt = conn.createStatement();
        Object[] foundResults = new Integer[numExpected];
        ResultSet rs = stmt.executeQuery("select * from trade.customers");
        int numResults = 0;
        while (rs.next()) {
            custName = rs.getString(1);
            addr = rs.getString(2);
            index = Integer.parseInt(custName.substring(4));
            tid = rs.getInt(3);
            int cid = rs.getInt(4);
            if (foundResults[index] != null) {
                AlterTableTest.fail("duplicate results in customers table for index=" + index);
            }
            foundResults[index] = cid;
            if (afterUpdate && (index == 2 || index == 3 || index == 10 || index == 30)) {
                switch (index) {
                    case 2: {
                        AlterTableTest.assertEquals((String)"ADDR2", (String)addr);
                        AlterTableTest.assertEquals((int)20, (int)tid);
                        AlterTableTest.assertEquals((int)1, (int)cid);
                        break;
                    }
                    case 3: 
                    case 30: {
                        AlterTableTest.assertEquals((String)"ADDR30", (String)addr);
                        AlterTableTest.assertEquals((int)30, (int)tid);
                        AlterTableTest.assertEquals((int)3, (int)cid);
                        break;
                    }
                    case 10: {
                        AlterTableTest.assertEquals((String)"ADDR10", (String)addr);
                        AlterTableTest.assertEquals((int)1, (int)tid);
                        AlterTableTest.assertEquals((int)10, (int)cid);
                        break;
                    }
                    default: {
                        AlterTableTest.fail("unexpected index=" + index);
                        break;
                    }
                }
            } else {
                AlterTableTest.assertEquals((String)("ADDR" + index), (String)addr);
                AlterTableTest.assertEquals((int)1, (int)tid);
                AlterTableTest.assertEquals((int)1, (int)cid);
            }
            ++numResults;
        }
        AlterTableTest.assertEquals((int)numExpected, (int)numResults);
        AlterTableTest.clearArray(foundResults);
        rs.close();
        rs = stmt.executeQuery("select cust_name, tid, addr from trade.customers");
        numResults = 0;
        while (rs.next()) {
            custName = rs.getString(1);
            addr = rs.getString(3);
            index = Integer.parseInt(custName.substring(4));
            tid = rs.getInt(2);
            if (foundResults[index] != null) {
                AlterTableTest.fail("duplicate results in customers table for index=" + index);
            }
            foundResults[index] = tid;
            if (afterUpdate && (index == 2 || index == 3 || index == 10 || index == 30)) {
                switch (index) {
                    case 2: {
                        AlterTableTest.assertEquals((String)"ADDR2", (String)addr);
                        AlterTableTest.assertEquals((int)20, (int)tid);
                        break;
                    }
                    case 3: 
                    case 30: {
                        AlterTableTest.assertEquals((String)"ADDR30", (String)addr);
                        AlterTableTest.assertEquals((int)30, (int)tid);
                        break;
                    }
                    case 10: {
                        AlterTableTest.assertEquals((String)"ADDR10", (String)addr);
                        AlterTableTest.assertEquals((int)1, (int)tid);
                        break;
                    }
                    default: {
                        AlterTableTest.fail("unexpected index=" + index);
                        break;
                    }
                }
            } else {
                AlterTableTest.assertEquals((String)("ADDR" + index), (String)addr);
                AlterTableTest.assertEquals((int)1, (int)tid);
            }
            ++numResults;
        }
        AlterTableTest.assertEquals((int)numExpected, (int)numResults);
        AlterTableTest.clearArray(foundResults);
        rs.close();
        if (!afterUpdate) {
            AlterTableTest.assertEquals((int)1, (int)stmt.executeUpdate("update trade.customers set addr='ADDR30' where cust_name='CUST3'"));
            AlterTableTest.assertEquals((int)2, (int)stmt.executeUpdate("update trade.customers set tid=30 where addr='ADDR30'"));
            AlterTableTest.assertEquals((int)2, (int)stmt.executeUpdate("update trade.customers set cid=3 where tid=30"));
            AlterTableTest.assertEquals((int)1, (int)stmt.executeUpdate("update trade.customers set cid=10 where cust_name='CUST10'"));
            AlterTableTest.assertEquals((int)1, (int)stmt.executeUpdate("update trade.customers set tid=20 where addr='ADDR2'"));
            AlterTableTest.verifyAddColumnWithData(conn, numExpected, true);
        }
    }

    public static void checkDropColumnWithData(Connection conn) throws SQLException {
        PreparedStatement prepStmt;
        Statement stmt;
        block2: {
            stmt = conn.createStatement();
            CreateTableTest.populateData(conn, true, false);
            prepStmt = conn.prepareStatement("alter table trade.customers drop column addr");
            prepStmt.execute();
            prepStmt = conn.prepareStatement("alter table trade.portfolio drop column qty cascade");
            prepStmt.execute();
            AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
            AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
            AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
            AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
            AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
            AlterTableTest.checkConstraints(stmt, new ConstraintNumber[]{ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2}, new ConstraintNumber[]{ConstraintNumber.CUST_PK2, ConstraintNumber.CUST_UK2, ConstraintNumber.CUST_FK2, ConstraintNumber.PORT_PK2});
            AlterTableTest.verifyDropColumnWithData(conn, false, false, false, false);
            stmt.execute("alter table trade.customers add column addr varchar(100) not null default 'NO_ADDRESS'");
            stmt.execute("alter table trade.portfolio add column qty int not null default 0");
            AlterTableTest.verifyDropColumnWithData(conn, false, true, false, true);
            stmt.execute("alter table trade.customers drop column addr");
            stmt.execute("alter table trade.portfolio drop column qty");
            stmt.execute("alter table trade.portfolio add column qty int default 0");
            stmt.execute("alter table trade.customers add column addr varchar(100) default 'NO_ADDRESS'");
            AlterTableTest.verifyDropColumnWithData(conn, false, true, false, true);
            stmt.execute("alter table trade.customers drop column addr");
            stmt.execute("alter table trade.portfolio drop column qty");
            stmt.execute("alter table trade.customers add column addr char(10) not null default 'NO_ADDRESS'");
            stmt.execute("alter table trade.portfolio add column qty bigint not null default 0");
            AlterTableTest.verifyDropColumnWithData(conn, false, true, false, true);
            stmt.execute("alter table trade.customers drop column addr");
            stmt.execute("alter table trade.portfolio drop column qty");
            stmt.execute("alter table trade.portfolio add column qty int");
            stmt.execute("alter table trade.customers add column addr char(100)");
            AlterTableTest.verifyDropColumnWithData(conn, false, true, true, true);
            stmt.execute("alter table trade.customers drop column addr");
            stmt.execute("alter table trade.portfolio drop column qty");
            stmt.execute("alter table trade.portfolio add column qty int");
            stmt.execute("alter table trade.customers add column addr varchar(100)");
            CreateTableTest.populateData(conn, true, false, false, true, false, "trade.customers", "trade.portfolio");
            AlterTableTest.checkDefaultPartitioning("trade.customers", "cid");
            AlterTableTest.checkDefaultPartitioning("trade.portfolio", "cid");
            AlterTableTest.checkColocation("trade.portfolio", "trade", "customers");
            AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
            AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALHASH1", "cid", "sid");
            AlterTableTest.checkIndexType("trade", "portfolio", "LOCALSORTEDMAP", "cid");
            AlterTableTest.checkConstraints(stmt, new ConstraintNumber[]{ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2}, new ConstraintNumber[]{ConstraintNumber.CUST_PK2, ConstraintNumber.CUST_UK2, ConstraintNumber.CUST_FK2, ConstraintNumber.PORT_PK2});
            AlterTableTest.verifyDropColumnWithData(conn, true, true, true, false);
            stmt.execute("alter table trade.customers drop column addr cascade");
            stmt.execute("alter table trade.portfolio drop column qty cascade");
            stmt.execute("alter table trade.customers add column addr varchar(100) not null default 'NO_ADDRESS'");
            stmt.execute("alter table trade.portfolio add column qty int not null default 0");
            AlterTableTest.verifyDropColumnWithData(conn, true, true, false, true);
            stmt.execute("alter table trade.customers drop column addr");
            stmt.execute("alter table trade.portfolio drop column qty");
            stmt.execute("alter table trade.portfolio add column qty int default 0");
            stmt.execute("alter table trade.customers add column addr varchar(100) default 'NO_ADDRESS'");
            AlterTableTest.verifyDropColumnWithData(conn, true, true, false, true);
            stmt.execute("alter table trade.customers drop column addr");
            stmt.execute("alter table trade.portfolio drop column qty");
            stmt.execute("alter table trade.customers add column addr char(10) not null default 'NO_ADDRESS'");
            stmt.execute("alter table trade.portfolio add column qty bigint not null default 0");
            AlterTableTest.verifyDropColumnWithData(conn, true, true, false, true);
            stmt.execute("alter table trade.customers drop column addr");
            stmt.execute("alter table trade.portfolio drop column qty");
            stmt.execute("alter table trade.portfolio add column qty int");
            stmt.execute("alter table trade.customers add column addr char(100)");
            AlterTableTest.verifyDropColumnWithData(conn, true, true, true, true);
            stmt.execute("drop table trade.portfolio");
            stmt.execute("drop table trade.customers");
            CreateTableTest.createTables(conn);
            CreateTableTest.populateData(conn, true, false);
            prepStmt = conn.prepareStatement("alter table trade.customers drop column cust_name");
            prepStmt.execute();
            AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
            AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
            prepStmt = conn.prepareStatement("alter table trade.customers drop column cid");
            try {
                prepStmt.execute();
                AlterTableTest.fail("Expected unsupported exception for PK column drop in ALTER TABLE");
            }
            catch (SQLException ex) {
                if ("0A000".equals(ex.getSQLState())) break block2;
                throw ex;
            }
        }
        prepStmt = conn.prepareStatement("alter table trade.portfolio drop column qty cascade");
        prepStmt.execute();
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkConstraints(stmt, new ConstraintNumber[]{ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2}, new ConstraintNumber[]{ConstraintNumber.CUST_PK3, ConstraintNumber.CUST_UK3, ConstraintNumber.CUST_FK2, ConstraintNumber.PORT_PK2});
        CreateTableTest.populateData(conn, true, false, true, true, false, "trade.customers", "trade.portfolio");
        AlterTableTest.checkIndexType("trade", "customers", "LOCALHASH1", "cid");
        AlterTableTest.checkIndexType("trade", "customers", "GLOBALHASH", "tid");
        AlterTableTest.checkConstraints(stmt, new ConstraintNumber[]{ConstraintNumber.CUST_PK, ConstraintNumber.CUST_UK, ConstraintNumber.CUST_FK, ConstraintNumber.PORT_PK, ConstraintNumber.PORT_CK1, ConstraintNumber.PORT_CK2}, new ConstraintNumber[]{ConstraintNumber.CUST_PK3, ConstraintNumber.CUST_UK3, ConstraintNumber.CUST_FK2, ConstraintNumber.PORT_PK2});
        AlterTableTest.verifyDropColumnWithData(conn, true, false, false, false);
    }

    public static void verifyDropColumnWithData(Connection conn, boolean fullData, boolean hasDefaults, boolean nullDefaults, boolean allDefaults) throws SQLException {
        int tid;
        int sid;
        int qtyCol;
        int tid2;
        int addrCol;
        int numExpected;
        Object[] foundResults;
        Statement stmt = conn.createStatement();
        if (fullData) {
            foundResults = new Integer[200];
            numExpected = 190;
        } else {
            foundResults = new Integer[100];
            numExpected = 100;
        }
        ResultSet rs = stmt.executeQuery("select * from trade.customers");
        int numResults = 0;
        try {
            addrCol = rs.findColumn("ADDR");
        }
        catch (SQLException sqle) {
            if ("S0022".equals(sqle.getSQLState()) || "XIE08".equals(sqle.getSQLState())) {
                addrCol = -1;
            }
            throw sqle;
        }
        while (rs.next()) {
            int cid = rs.getInt(1);
            tid2 = rs.getInt(3);
            if (foundResults[cid] != null) {
                AlterTableTest.fail("duplicate results in customers table for cid=" + cid);
            }
            foundResults[cid] = tid2;
            AlterTableTest.assertTrue((String)Integer.toString(cid), (cid < 100 || cid >= 110 ? 1 : 0) != 0);
            AlterTableTest.assertEquals((int)(cid + 1), (int)tid2);
            if (addrCol > 0) {
                if (hasDefaults && (cid < 100 || allDefaults)) {
                    if (nullDefaults) {
                        AlterTableTest.assertNull((Object)rs.getObject(addrCol));
                        AlterTableTest.assertNull((Object)rs.getString(addrCol));
                        AlterTableTest.assertTrue((boolean)rs.wasNull());
                    } else {
                        AlterTableTest.assertEquals((Object)"NO_ADDRESS", (Object)rs.getObject(addrCol));
                        AlterTableTest.assertEquals((String)"NO_ADDRESS", (String)rs.getString(addrCol));
                    }
                } else if (hasDefaults || cid < 100) {
                    AlterTableTest.assertEquals((Object)("ADDR" + cid), (Object)rs.getObject(addrCol));
                    AlterTableTest.assertEquals((String)("ADDR" + cid), (String)rs.getString(addrCol));
                } else {
                    AlterTableTest.assertNull((Object)rs.getObject(addrCol));
                    AlterTableTest.assertNull((Object)rs.getString(addrCol));
                    AlterTableTest.assertTrue((boolean)rs.wasNull());
                }
            } else if (cid < 100) {
                AlterTableTest.assertEquals((Object)("CUST" + cid), (Object)rs.getObject(2));
                AlterTableTest.assertEquals((String)("CUST" + cid), (String)rs.getString(2));
            } else {
                AlterTableTest.assertNull((Object)rs.getObject(2));
                AlterTableTest.assertNull((Object)rs.getString(2));
                AlterTableTest.assertTrue((boolean)rs.wasNull());
            }
            ++numResults;
        }
        AlterTableTest.assertEquals((int)numExpected, (int)numResults);
        AlterTableTest.clearArray(foundResults);
        rs.close();
        if (addrCol > 0 && hasDefaults) {
            rs = fullData ? stmt.executeQuery("select addr, cid from trade.customers") : stmt.executeQuery("select addr from trade.customers");
            numResults = 0;
            while (rs.next()) {
                int cid;
                if (fullData && !allDefaults && (cid = rs.getInt(2)) >= 100) {
                    AlterTableTest.assertEquals((Object)("ADDR" + cid), (Object)rs.getObject(1));
                    AlterTableTest.assertEquals((String)("ADDR" + cid), (String)rs.getString(1));
                } else if (nullDefaults) {
                    AlterTableTest.assertNull((Object)rs.getObject(1));
                    AlterTableTest.assertNull((Object)rs.getString(1));
                    AlterTableTest.assertTrue((boolean)rs.wasNull());
                } else {
                    AlterTableTest.assertEquals((Object)"NO_ADDRESS", (Object)rs.getObject(1));
                    AlterTableTest.assertEquals((String)"NO_ADDRESS", (String)rs.getString(1));
                }
                ++numResults;
            }
            AlterTableTest.assertEquals((int)numExpected, (int)numResults);
            rs.close();
        }
        rs = stmt.executeQuery("select cid, tid from trade.customers");
        numResults = 0;
        while (rs.next()) {
            int cid = rs.getInt(1);
            tid2 = rs.getInt(2);
            if (foundResults[cid] != null) {
                AlterTableTest.fail("duplicate results in customers table for cid=" + cid);
            }
            foundResults[cid] = tid2;
            AlterTableTest.assertTrue((String)Integer.toString(cid), (cid < 100 || cid >= 110 ? 1 : 0) != 0);
            AlterTableTest.assertEquals((int)(cid + 1), (int)tid2);
            ++numResults;
        }
        AlterTableTest.assertEquals((int)numExpected, (int)numResults);
        AlterTableTest.clearArray(foundResults);
        rs.close();
        rs = stmt.executeQuery("select * from trade.portfolio");
        numResults = 0;
        int tidCol = rs.findColumn("TID");
        boolean qtyIsBigInt = false;
        try {
            qtyCol = rs.findColumn("QTY");
            qtyIsBigInt = rs.getMetaData().getColumnType(qtyCol) == -5;
        }
        catch (SQLException sqle) {
            if ("S0022".equals(sqle.getSQLState()) || "XIE08".equals(sqle.getSQLState())) {
                qtyCol = -1;
            }
            throw sqle;
        }
        while (rs.next()) {
            int cid = rs.getInt(1);
            sid = rs.getInt(2);
            tid = rs.getInt(tidCol);
            if (foundResults[cid] != null) {
                AlterTableTest.fail("duplicate results in portfolio table for cid=" + cid);
            }
            foundResults[cid] = tid;
            AlterTableTest.assertTrue((String)Integer.toString(cid), (cid < 100 || cid >= 110 ? 1 : 0) != 0);
            AlterTableTest.assertEquals((int)(cid + 2), (int)sid);
            AlterTableTest.assertEquals((int)cid, (int)tid);
            if (hasDefaults && (cid < 100 || allDefaults)) {
                if (nullDefaults) {
                    AlterTableTest.assertEquals(null, (Object)rs.getObject(qtyCol));
                    AlterTableTest.assertEquals((long)0L, (long)rs.getLong(qtyCol));
                    AlterTableTest.assertTrue((boolean)rs.wasNull());
                } else {
                    if (qtyIsBigInt) {
                        AlterTableTest.assertEquals((Object)0L, (Object)rs.getObject(qtyCol));
                    } else {
                        AlterTableTest.assertEquals((Object)0, (Object)rs.getObject(qtyCol));
                    }
                    AlterTableTest.assertEquals((long)0L, (long)rs.getLong(qtyCol));
                }
            } else if (qtyCol > 0) {
                if (hasDefaults || cid < 100) {
                    AlterTableTest.assertEquals((Object)(cid * 10), (Object)rs.getObject(qtyCol));
                    AlterTableTest.assertEquals((long)(cid * 10), (long)rs.getLong(qtyCol));
                } else {
                    AlterTableTest.assertEquals(null, (Object)rs.getObject(qtyCol));
                    AlterTableTest.assertEquals((long)0L, (long)rs.getLong(qtyCol));
                    AlterTableTest.assertTrue((boolean)rs.wasNull());
                }
            }
            ++numResults;
        }
        AlterTableTest.assertEquals((int)numExpected, (int)numResults);
        AlterTableTest.clearArray(foundResults);
        rs.close();
        if (qtyCol > 0 && hasDefaults) {
            rs = fullData ? stmt.executeQuery("select qty, cid from trade.portfolio") : stmt.executeQuery("select qty from trade.portfolio");
            numResults = 0;
            while (rs.next()) {
                int cid;
                if (fullData && !allDefaults && (cid = rs.getInt(2)) >= 100) {
                    AlterTableTest.assertEquals((Object)(cid * 10), (Object)rs.getObject(1));
                    AlterTableTest.assertEquals((long)(cid * 10), (long)rs.getLong(1));
                } else if (nullDefaults) {
                    AlterTableTest.assertEquals(null, (Object)rs.getObject(1));
                    AlterTableTest.assertTrue((boolean)rs.wasNull());
                    AlterTableTest.assertEquals((long)0L, (long)rs.getLong(1));
                } else if (qtyIsBigInt) {
                    AlterTableTest.assertEquals((Object)0L, (Object)rs.getObject(1));
                    AlterTableTest.assertEquals((long)0L, (long)rs.getLong(1));
                } else {
                    AlterTableTest.assertEquals((Object)0, (Object)rs.getObject(1));
                    AlterTableTest.assertEquals((long)0L, (long)rs.getLong(1));
                }
                ++numResults;
            }
            AlterTableTest.assertEquals((int)numExpected, (int)numResults);
            rs.close();
        }
        rs = stmt.executeQuery("select cid, sid, tid from trade.portfolio");
        numResults = 0;
        while (rs.next()) {
            int cid = rs.getInt(1);
            sid = rs.getInt(2);
            tid = rs.getInt(3);
            if (foundResults[cid] != null) {
                AlterTableTest.fail("duplicate results in portfolio table for cid=" + cid);
            }
            foundResults[cid] = tid;
            AlterTableTest.assertTrue((String)Integer.toString(cid), (cid < 100 || cid >= 110 ? 1 : 0) != 0);
            AlterTableTest.assertEquals((int)(cid + 2), (int)sid);
            AlterTableTest.assertEquals((int)cid, (int)tid);
            ++numResults;
        }
        AlterTableTest.assertEquals((int)numExpected, (int)numResults);
        AlterTableTest.clearArray(foundResults);
        rs.close();
    }

    private static void clearArray(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = null;
        }
    }

    public void testBug50116_1() throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        Statement stmnt = conn.createStatement();
        stmnt.execute("create table p1(col1 int primary key, col2 int) partition by (col1) persistent");
        stmnt.execute("create table c1(a int, b int, constraint fk_c1 foreign key (a) references p1(col1)) partition by (a)");
        stmnt.execute("alter table c1 drop constraint app.fk_c1");
        stmnt.execute("drop table p1");
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
        stmnt = conn.createStatement();
        stmnt.execute("insert into c1 values(1, 1)");
        stmnt.execute("insert into c1 values(2, 2)");
        stmnt.execute("select * from c1");
        ResultSet rs = stmnt.getResultSet();
        AlterTableTest.assertTrue((boolean)rs.next());
        AlterTableTest.assertTrue((boolean)rs.next());
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
    }

    public void testBug50116_2() throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        Statement stmnt = conn.createStatement();
        stmnt.execute("create table p1(col1 int primary key, col2 int) partition by (col1) persistent");
        stmnt.execute("create table p2(col1 int primary key, col2 int) partition by (col1) persistent");
        stmnt.execute("create table c1(a1 int, b1 int, constraint fk_c1_1 foreign key (a1) references p1(col1), constraint fk_c1_2 foreign key (b1) references p2(col1)) partition by (a1)");
        stmnt.execute("create table c2(a2 int primary key, b2 int, constraint fk_c2 foreign key (a2) references p1(col1)) partition by (a2)");
        stmnt.execute("alter table c1 drop constraint fk_c1_1");
        stmnt.execute("alter table c1 drop constraint fk_c1_2");
        stmnt.execute("alter table c2 drop constraint fk_c2");
        stmnt.execute("alter table c2 drop primary key");
        stmnt.execute("drop table p2");
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
        stmnt = conn.createStatement();
        stmnt.execute("insert into c1 values(1, 1)");
        stmnt.execute("insert into c1 values(2, 2)");
        stmnt.execute("select * from c1");
        ResultSet rs = stmnt.getResultSet();
        AlterTableTest.assertTrue((boolean)rs.next());
        AlterTableTest.assertTrue((boolean)rs.next());
        stmnt.execute("insert into c2 values(1, 1)");
        stmnt.execute("insert into c2 values(2, 2)");
        stmnt.execute("select * from c2");
        rs = stmnt.getResultSet();
        AlterTableTest.assertTrue((boolean)rs.next());
        AlterTableTest.assertTrue((boolean)rs.next());
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
    }

    public void testBug50116_3() throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        Statement stmnt = conn.createStatement();
        stmnt.execute("create table p1(col1 int primary key, col2 int) partition by (col1) persistent");
        stmnt.execute("create table p2(col1 int primary key, col2 int) partition by (col1) persistent");
        stmnt.execute("create table p3(col1 int primary key, col2 int) partition by (col1) persistent");
        stmnt.execute("insert into p1 values(1, 1)");
        stmnt.execute("insert into p2 values(1, 1)");
        stmnt.execute("insert into p3 values(1, 1)");
        stmnt.execute("create table c1(a1 int, b1 int, c1 int, constraint fk_c1_1 foreign key (a1) references p1(col1))  partition by (a1)");
        stmnt.execute("alter table c1 add constraint fk_c1_2 foreign key (b1) references p2(col1)");
        stmnt.execute("alter table c1 add constraint fk_c1_3 foreign key (c1) references p3(col1)");
        stmnt.execute("alter table c1 drop constraint fk_c1_2");
        stmnt.execute("alter table c1 drop constraint fk_c1_3");
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
        stmnt = conn.createStatement();
        stmnt.execute("insert into c1 values(1, 1, 1)");
        stmnt.execute("select * from c1");
        ResultSet rs = stmnt.getResultSet();
        AlterTableTest.assertTrue((boolean)rs.next());
        stmnt.execute("alter table c1 drop constraint fk_c1_1");
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
        stmnt = conn.createStatement();
        stmnt.execute("drop table c1");
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
    }

    public void testBug50116_4() throws Exception {
        Properties props = new Properties();
        Connection conn = TestUtil.getConnection(props);
        Statement stmnt = conn.createStatement();
        stmnt.execute("create table p1(col1 int primary key, col2 int) partition by (col1) persistent");
        stmnt.execute("create table p2(col1 int primary key, col2 int) partition by (col1) persistent");
        stmnt.execute("insert into p1 values(1, 1)");
        stmnt.execute("insert into p2 values(1, 1)");
        stmnt.execute("create table c1(a1 int, b1 int, c1 int)  partition by (a1)");
        stmnt.execute("alter table c1 add constraint fk_c1_1 foreign key (a1) references p1(col1)");
        stmnt.execute("alter table c1 add constraint fk_c1_2 foreign key (b1) references p2(col1)");
        stmnt.execute("alter table c1 drop constraint fk_c1_1");
        stmnt.execute("alter table c1 drop constraint fk_c1_2");
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
        stmnt = conn.createStatement();
        stmnt.execute("insert into c1 values(1, 1, 1)");
        stmnt.execute("select * from c1");
        ResultSet rs = stmnt.getResultSet();
        AlterTableTest.assertTrue((boolean)rs.next());
        stmnt.execute("alter table c1 add constraint fk_c1_1 foreign key (a1) references p1(col1)");
        stmnt.execute("alter table c1 add constraint fk_c1_2 foreign key (b1) references p2(col1)");
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
        stmnt = conn.createStatement();
        stmnt.execute("alter table c1 drop constraint fk_c1_1");
        stmnt.execute("alter table c1 drop constraint fk_c1_2");
        stmnt.execute("drop table p1");
        AlterTableTest.shutDown();
        conn = TestUtil.getConnection();
        stmnt = conn.createStatement();
    }

    public static enum ConstraintNumber {
        CUST_PK{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.customers (cid, cust_name, addr) values (1, 'CUST1', 'ADDR200')");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.customers where cid=1 and addr='ADDR200'");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23505".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }
        }
        ,
        CUST_PK2{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.customers (cid, cust_name, tid) values (1, 'CUST1', 200)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.customers where cid=1 and tid=200");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23505".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }

            @Override
            public boolean defaultIgnore() {
                return true;
            }
        }
        ,
        CUST_PK3{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.customers (cid, addr) values (1, 'ADDR200')");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.customers where cid=1 and addr='ADDR200'");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23505".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }

            @Override
            public boolean defaultIgnore() {
                return true;
            }
        }
        ,
        CUST_UK{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.customers (cid, cust_name, addr, tid) values (200, 'CUST200', 'ADDR200', 50)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.customers where cid=200");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23505".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }
        }
        ,
        CUST_UK2{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.customers (cid, cust_name, tid) values (200, 'CUST200', 50)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.customers where cid=200");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23505".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }

            @Override
            public boolean defaultIgnore() {
                return true;
            }
        }
        ,
        CUST_UK3{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.customers (cid, addr, tid) values (200, 'ADDR200', 50)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.customers where cid=200");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23505".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }

            @Override
            public boolean defaultIgnore() {
                return true;
            }
        }
        ,
        CUST_FK{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.portfolio (cid, sid, qty, availQty, tid) values (101, 7, 50, 45, 102)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.portfolio where cid=101");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23503".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }
        }
        ,
        CUST_FK2{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.portfolio (cid, sid, availQty, tid) values (101, 7, 45, 102)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.portfolio where cid=101");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23503".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }

            @Override
            public boolean defaultIgnore() {
                return true;
            }
        }
        ,
        PORT_PK{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.portfolio (cid, sid, qty, availQty, tid) values (5, 7, 50, 45, 10)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.customers where cid=5 and tid=10");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23505".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }
        }
        ,
        PORT_PK2{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.portfolio (cid, sid, availQty, tid) values (5, 7, 45, 10)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.customers where cid=5 and tid=10");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23505".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }

            @Override
            public boolean defaultIgnore() {
                return true;
            }
        }
        ,
        PORT_CK1{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.portfolio (cid, sid, qty, availQty, tid) values (50, 7, -10, -20, 50)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.portfolio where cid=50");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23513".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }
        }
        ,
        PORT_CK2{

            @Override
            public void checkConstraint(Statement stmt, boolean valid) throws SQLException {
                block4: {
                    try {
                        stmt.execute("insert into trade.portfolio (cid, sid, qty, availQty, tid) values (52, 7, 45, 50, 52)");
                        if (valid) {
                            TestUtil.fail("expected constraint violation in insert");
                        } else {
                            stmt.execute("delete from trade.portfolio where cid=52");
                        }
                    }
                    catch (SQLException ex) {
                        if (valid && "23513".equals(ex.getSQLState())) break block4;
                        throw ex;
                    }
                }
            }
        };


        public abstract void checkConstraint(Statement var1, boolean var2) throws SQLException;

        public boolean defaultIgnore() {
            return false;
        }
    }
}

