/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.jdbc;

import com.gemstone.gemfire.cache.hdfs.HDFSEventQueueAttributes;
import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.gemstone.gemfire.internal.AvailablePort;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class AlterHDFSStoreTest
extends JdbcTestBase {
    public AlterHDFSStoreTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        System.setProperty("gemfire.ALLOW_STANDALONE_HDFS_FILESYSTEM", "true");
        this.deleteIfDirExists();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.deleteIfDirExists();
    }

    private void deleteIfDirExists() throws IOException {
        String[] dirs;
        for (String dir : dirs = new String[]{"MYHDFS", "MYHDFS1", "MYHDFS2"}) {
            File hdfsDir = new File(dir);
            if (!hdfsDir.exists()) continue;
            FileUtils.deleteDirectory((File)hdfsDir);
        }
    }

    public void testAlterAllMutableAttributes() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost'");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ArrayList stores = cache.getAllHDFSStores();
        AlterHDFSStoreTest.assertEquals((int)1, (int)stores.size());
        HDFSStoreImpl hdfsStore = cache.findHDFSStore("MYHDFS");
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore);
        AlterHDFSStoreTest.assertEquals((int)256, (int)hdfsStore.getMaxFileSize());
        AlterHDFSStoreTest.assertEquals((int)3600, (int)hdfsStore.getFileRolloverInterval());
        HDFSStore.HDFSCompactionConfig compConfig = hdfsStore.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)10, (int)compConfig.getMaxInputFileCount());
        AlterHDFSStoreTest.assertEquals((int)512, (int)compConfig.getMaxInputFileSizeMB());
        AlterHDFSStoreTest.assertEquals((int)10, (int)compConfig.getMaxThreads());
        AlterHDFSStoreTest.assertEquals((int)4, (int)compConfig.getMinInputFileCount());
        AlterHDFSStoreTest.assertTrue((boolean)compConfig.getAutoCompaction());
        AlterHDFSStoreTest.assertEquals((int)720, (int)compConfig.getMajorCompactionIntervalMins());
        AlterHDFSStoreTest.assertEquals((int)2, (int)compConfig.getMajorCompactionMaxThreads());
        AlterHDFSStoreTest.assertTrue((boolean)compConfig.getAutoMajorCompaction());
        AlterHDFSStoreTest.assertEquals((int)30, (int)compConfig.getOldFilesCleanupIntervalMins());
        HDFSEventQueueAttributes qAttr = hdfsStore.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)32, (int)qAttr.getBatchSizeMB());
        AlterHDFSStoreTest.assertEquals((int)60000, (int)qAttr.getBatchTimeInterval());
        st.execute("alter hdfsstore myhdfs SET MaxWriteOnlyFileSize 47 SET WriteOnlyFileRolloverInterval 347 minutes SET MaxInputFileCount 98 SET MaxInputFileSize 38 SET MinorCompactionThreads 35 SET MinInputFileCount 24 SET MinorCompact false SET MajorCompactionInterval 372 minutes SET MajorCompactionThreads 29 SET MajorCompact false SET PurgeInterval 2392 minutes SET BatchSize 23 SET BatchTimeInterval 2 seconds ");
        AlterHDFSStoreTest.assertEquals((int)47, (int)hdfsStore.getMaxFileSize());
        AlterHDFSStoreTest.assertEquals((int)20820, (int)hdfsStore.getFileRolloverInterval());
        compConfig = hdfsStore.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)98, (int)compConfig.getMaxInputFileCount());
        AlterHDFSStoreTest.assertEquals((int)38, (int)compConfig.getMaxInputFileSizeMB());
        AlterHDFSStoreTest.assertEquals((int)35, (int)compConfig.getMaxThreads());
        AlterHDFSStoreTest.assertEquals((int)24, (int)compConfig.getMinInputFileCount());
        AlterHDFSStoreTest.assertFalse((boolean)compConfig.getAutoCompaction());
        AlterHDFSStoreTest.assertEquals((int)372, (int)compConfig.getMajorCompactionIntervalMins());
        AlterHDFSStoreTest.assertEquals((int)29, (int)compConfig.getMajorCompactionMaxThreads());
        AlterHDFSStoreTest.assertFalse((boolean)compConfig.getAutoMajorCompaction());
        AlterHDFSStoreTest.assertEquals((int)2392, (int)compConfig.getOldFilesCleanupIntervalMins());
        qAttr = hdfsStore.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)23, (int)qAttr.getBatchSizeMB());
        AlterHDFSStoreTest.assertEquals((int)2000, (int)qAttr.getBatchTimeInterval());
    }

    public void testAlterTwoHdfsStores() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs1 namenode 'localhost'");
        st.execute("create hdfsstore myhdfs2 namenode 'localhost'");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ArrayList stores = cache.getAllHDFSStores();
        AlterHDFSStoreTest.assertEquals((int)2, (int)stores.size());
        HDFSStoreImpl hdfsStore1 = cache.findHDFSStore("MYHDFS1");
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore1);
        AlterHDFSStoreTest.assertEquals((int)256, (int)hdfsStore1.getMaxFileSize());
        HDFSStore.HDFSCompactionConfig compConfig = hdfsStore1.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)10, (int)compConfig.getMaxInputFileCount());
        HDFSEventQueueAttributes qAttr = hdfsStore1.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)32, (int)qAttr.getBatchSizeMB());
        HDFSStoreImpl hdfsStore2 = cache.findHDFSStore("MYHDFS2");
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore2);
        AlterHDFSStoreTest.assertEquals((int)256, (int)hdfsStore2.getMaxFileSize());
        compConfig = hdfsStore2.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)10, (int)compConfig.getMaxInputFileCount());
        qAttr = hdfsStore2.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)32, (int)qAttr.getBatchSizeMB());
        st.execute("alter hdfsstore myhdfs1 SET MaxWriteOnlyFileSize 47 SET MaxInputFileCount 98 SET BatchSize 23 ");
        st.execute("alter hdfsstore myhdfs2 SET MaxWriteOnlyFileSize 74 SET MaxInputFileCount 89 SET BatchSize 32 ");
        AlterHDFSStoreTest.assertEquals((int)47, (int)hdfsStore1.getMaxFileSize());
        compConfig = hdfsStore1.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)98, (int)compConfig.getMaxInputFileCount());
        qAttr = hdfsStore1.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)23, (int)qAttr.getBatchSizeMB());
        AlterHDFSStoreTest.assertEquals((int)74, (int)hdfsStore2.getMaxFileSize());
        compConfig = hdfsStore2.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)89, (int)compConfig.getMaxInputFileCount());
        qAttr = hdfsStore2.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)32, (int)qAttr.getBatchSizeMB());
    }

    public void testAlterOneOfTwoHdfsStores() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs1 namenode 'localhost'");
        st.execute("create hdfsstore myhdfs2 namenode 'localhost'");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ArrayList stores = cache.getAllHDFSStores();
        AlterHDFSStoreTest.assertEquals((int)2, (int)stores.size());
        HDFSStoreImpl hdfsStore1 = cache.findHDFSStore("MYHDFS1");
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore1);
        AlterHDFSStoreTest.assertEquals((int)256, (int)hdfsStore1.getMaxFileSize());
        HDFSStore.HDFSCompactionConfig compConfig = hdfsStore1.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)10, (int)compConfig.getMaxInputFileCount());
        HDFSEventQueueAttributes qAttr = hdfsStore1.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)32, (int)qAttr.getBatchSizeMB());
        HDFSStoreImpl hdfsStore2 = cache.findHDFSStore("MYHDFS2");
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore2);
        AlterHDFSStoreTest.assertEquals((int)256, (int)hdfsStore2.getMaxFileSize());
        compConfig = hdfsStore2.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)10, (int)compConfig.getMaxInputFileCount());
        qAttr = hdfsStore2.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)32, (int)qAttr.getBatchSizeMB());
        st.execute("alter hdfsstore myhdfs1 SET MaxWriteOnlyFileSize 47 SET MaxInputFileCount 98 SET BatchSize 23 ");
        AlterHDFSStoreTest.assertEquals((int)47, (int)hdfsStore1.getMaxFileSize());
        compConfig = hdfsStore1.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)98, (int)compConfig.getMaxInputFileCount());
        qAttr = hdfsStore1.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)23, (int)qAttr.getBatchSizeMB());
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore2);
        AlterHDFSStoreTest.assertEquals((int)256, (int)hdfsStore2.getMaxFileSize());
        compConfig = hdfsStore2.getHDFSCompactionConfig();
        AlterHDFSStoreTest.assertEquals((int)10, (int)compConfig.getMaxInputFileCount());
        qAttr = hdfsStore2.getHDFSEventQueueAttributes();
        AlterHDFSStoreTest.assertEquals((int)32, (int)qAttr.getBatchSizeMB());
    }

    public void testAlterInvalidValue() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost'");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ArrayList stores = cache.getAllHDFSStores();
        AlterHDFSStoreTest.assertEquals((int)1, (int)stores.size());
        HDFSStoreImpl hdfsStore = cache.findHDFSStore("MYHDFS");
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore);
        try {
            st.execute("alter hdfsstore myhdfs SET MaxWriteOnlyFileSize -1 ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        try {
            st.execute("alter hdfsstore myhdfs SET WriteOnlyFileRolloverInterval 347 ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        try {
            st.execute("alter hdfsstore myhdfs SET MinorCompact noop ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn = TestUtil.getConnection();
        st = conn.createStatement();
        try {
            st.execute("alter hdfsstore myhdfs SET MajorCompactionInterval 5 milliseconds ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testAlterImmutableAttributes() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost'");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ArrayList stores = cache.getAllHDFSStores();
        AlterHDFSStoreTest.assertEquals((int)1, (int)stores.size());
        HDFSStoreImpl hdfsStore = cache.findHDFSStore("MYHDFS");
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore);
        try {
            st.execute("alter hdfsstore myhdfs SET MaxQueueMemory 47 ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            st.execute("alter hdfsstore myhdfs SET DispatcherThreads 47 ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            st.execute("alter hdfsstore myhdfs SET QueuePersistent false ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            st.execute("alter hdfsstore myhdfs SET DiskSynchronous false ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            st.execute("alter hdfsstore myhdfs SET BlockCacheSize 1 ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            st.execute("alter hdfsstore myhdfs SET ClientConfigFile 'abcd' ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testAlterOfMissingStore() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ArrayList stores = cache.getAllHDFSStores();
        AlterHDFSStoreTest.assertEquals((int)0, (int)stores.size());
        HDFSStoreImpl hdfsStore = cache.findHDFSStore("MYHDFS");
        AlterHDFSStoreTest.assertNull((Object)hdfsStore);
        try {
            st.execute("alter hdfsstore myhdfs SET BatchSize 47 ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testAlterAfterDropStore() throws Exception {
        Connection conn = TestUtil.getConnection();
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost'");
        GemFireCacheImpl cache = Misc.getGemFireCache();
        ArrayList stores = cache.getAllHDFSStores();
        AlterHDFSStoreTest.assertEquals((int)1, (int)stores.size());
        HDFSStoreImpl hdfsStore = cache.findHDFSStore("MYHDFS");
        AlterHDFSStoreTest.assertNotNull((Object)hdfsStore);
        st.execute("drop hdfsstore myhdfs");
        stores = cache.getAllHDFSStores();
        AlterHDFSStoreTest.assertEquals((int)0, (int)stores.size());
        hdfsStore = cache.findHDFSStore("MYHDFS");
        AlterHDFSStoreTest.assertNull((Object)hdfsStore);
        try {
            st.execute("alter hdfsstore myhdfs SET BatchSize 47 ");
            AlterHDFSStoreTest.fail("alter statement should have failed");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void testDDLConflation() throws Exception {
        Properties props = new Properties();
        int mcastPort = AvailablePort.getRandomAvailablePort((int)1);
        props.put("mcast-port", String.valueOf(mcastPort));
        props.put("mcast-ttl", "0");
        Connection conn = TestUtil.getConnection(props);
        Statement st = conn.createStatement();
        st.execute("create hdfsstore myhdfs namenode 'localhost' ");
        st.execute("alter hdfsstore myhdfs SET BatchSize 47 ");
        st.execute("drop hdfsstore myhdfs");
        AlterHDFSStoreTest.shutDown();
        conn = TestUtil.getConnection(props);
        st = conn.createStatement();
    }
}

