/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor;

import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.tools.dataextractor.domain.ServerInfo;
import com.pivotal.gemfirexd.internal.tools.dataextractor.extractor.GemFireXDDataExtractorImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.ReportGenerator;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import com.pivotal.gemfirexd.internal.tools.dataextractor.utils.ExtractorUtils;
import com.pivotal.gemfirexd.jdbc.JdbcTestBase;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class GemFireXDDataExtractorJUnit
extends JdbcTestBase {
    private Connection connection;
    private Statement statement;
    private File ddCopy = new File("dd-copy");
    private File oplogCopy = new File("oplog-copy");
    private File outputDir = new File("export-dir");
    private String testDiskStoreName = "TESTDISKSTORE";

    public GemFireXDDataExtractorJUnit(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        TestUtil.deletePersistentFiles = true;
        this.connection = JdbcTestBase.getConnection();
        this.statement = this.connection.createStatement();
        this.outputDir.mkdirs();
        this.ddCopy.mkdirs();
        this.oplogCopy.mkdirs();
        EmbedConnection embeddedConnection = (EmbedConnection)this.connection;
        embeddedConnection.getTR().setupContextStack();
        this.deleteDirs = new String[0];
    }

    @Override
    public void tearDown() throws Exception {
        this.connection.close();
        this.deleteAllTestOpLogs();
        TestUtil.shutDown();
        super.tearDown();
    }

    private void deleteAllTestOpLogs() throws Exception {
        FileUtils.forceDelete((File)this.oplogCopy);
        FileUtils.forceDelete((File)this.ddCopy);
        FileUtils.forceDelete((File)this.outputDir);
    }

    public void testDDLExport() throws Exception {
        HashMap<ServerInfo, List> hostToDdlMap = new HashMap<ServerInfo, List>();
        int numDDL = 5;
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable("PERSIST_REPLICATE", this.testDiskStoreName);
        this.createPersistentPartitionedTable("PERSIST_PARTITIONED", this.testDiskStoreName);
        this.createIndex("PERSIST_REPLICATE");
        this.createIndex("PERSIST_PARTITIONED");
        this.copyDataDictionary();
        String server1OutputDirPath = FilenameUtils.concat((String)this.outputDir.getCanonicalPath(), (String)"s1");
        String server2OutputDirPath = FilenameUtils.concat((String)this.outputDir.getCanonicalPath(), (String)"s2");
        File server1OutputDir = new File(server1OutputDirPath);
        File server2OutputDir = new File(server2OutputDirPath);
        server1OutputDir.mkdirs();
        server2OutputDir.mkdirs();
        List stats = GemFireXDDataExtractorImpl.exportOfflineDDL((String)this.ddCopy.getCanonicalPath(), (String)server1OutputDir.getCanonicalPath());
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        List ddls = ExtractorUtils.readSqlStatements((String)stat.getFileName());
        GemFireXDDataExtractorJUnit.assertEquals((int)numDDL, (int)ddls.size());
        ServerInfo.Builder builder = new ServerInfo.Builder();
        builder.serverName("s1");
        ServerInfo s1 = builder.build();
        hostToDdlMap.put(s1, stats);
        this.dropTable("PERSIST_REPLICATE");
        this.copyDataDictionary();
        stats = GemFireXDDataExtractorImpl.exportOfflineDDL((String)this.ddCopy.getCanonicalPath(), (String)server2OutputDir.getCanonicalPath());
        builder = new ServerInfo.Builder();
        builder.serverName("s2");
        ServerInfo s2 = builder.build();
        hostToDdlMap.put(s2, stats);
        List rankedDDLs = ReportGenerator.rankAndGroupDdlStats(hostToDdlMap);
        GemFireXDDataExtractorJUnit.assertFalse((boolean)rankedDDLs.isEmpty());
        GemFireXDDataExtractorJUnit.assertTrue((rankedDDLs.size() == 2 ? 1 : 0) != 0);
    }

    public void testDDLSchemaChangeExport() throws Exception {
        int numDDL = 7;
        this.createSchema("firstSchema");
        this.setCurrentSchema("firstSchema");
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable("PERSIST_REPLICATE", this.testDiskStoreName);
        this.createPersistentPartitionedTable("PERSIST_PARTITIONED", this.testDiskStoreName);
        this.createIndex("PERSIST_REPLICATE");
        this.createIndex("PERSIST_PARTITIONED");
        this.copyDataDictionary();
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        List stats = GemFireXDDataExtractorImpl.exportOfflineDDL((String)this.ddCopy.getCanonicalPath(), (String)this.outputDir.getCanonicalPath());
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        List ddls = ExtractorUtils.readSqlStatements((String)stat.getFileName());
        GemFireXDDataExtractorJUnit.assertEquals((int)numDDL, (int)ddls.size());
    }

    public void testNoDDLToExport() throws Exception {
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable("PERSIST_REPLICATE", this.testDiskStoreName);
        this.createPersistentPartitionedTable("PERSIST_PARTITIONED", this.testDiskStoreName);
        this.createIndex("PERSIST_REPLICATE");
        this.createIndex("PERSIST_PARTITIONED");
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        try {
            List list = GemFireXDDataExtractorImpl.exportOfflineDDL((String)this.ddCopy.getCanonicalPath(), (String)this.outputDir.getCanonicalPath());
        }
        catch (IllegalStateException e) {
            return;
        }
        GemFireXDDataExtractorJUnit.fail("expected an exception to be thrown due to missing ddl");
    }

    public void testCSVExportNoOplogsFound() throws Exception {
        String schemaName = "APP";
        String tableName = "REPLICATED_TABLE";
        Object bucketName = null;
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 1000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        try {
            List list = GemFireXDDataExtractorImpl.exportDataOpLog((String)this.testDiskStoreName, (String)this.oplogCopy.getCanonicalPath(), (String)this.outputDir.getCanonicalPath(), (boolean)false);
        }
        catch (IllegalStateException e) {
            return;
        }
        GemFireXDDataExtractorJUnit.fail("should have received an exception due to no oplogs present");
    }

    public void testExportOnOnlineNode() throws Exception {
        String schemaName = "APP";
        String tableName = "REPLICATED_TABLE";
        Object bucketName = null;
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 1000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        boolean ok = false;
        this.copyDataDictionary();
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        try {
            List list = GemFireXDDataExtractorImpl.exportDataOpLog((String)this.testDiskStoreName, (String)("./" + this.testDiskStoreName), (String)this.outputDir.getCanonicalPath(), (boolean)false);
        }
        catch (Exception e) {
            ok = true;
        }
        if (!ok) {
            GemFireXDDataExtractorJUnit.fail();
        }
    }

    public void testCSVExportSingleNodeReplicate() throws Exception {
        String schemaName = "APP";
        String tableName = "REPLICATED_TABLE";
        String bucketName = null;
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 1000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        this.copyOplogs();
        List stats = GemFireXDDataExtractorImpl.exportDataOpLog((String)this.testDiskStoreName, (String)this.oplogCopy.getCanonicalPath(), (String)this.outputDir.getCanonicalPath(), (boolean)false);
        GFXDSnapshotExportStat expectedStat = new GFXDSnapshotExportStat(schemaName, tableName, bucketName, null);
        expectedStat.setNumValuesDecoded(700);
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        GemFireXDDataExtractorJUnit.assertEquals((int)1, (int)stats.size());
        GemFireXDDataExtractorJUnit.assertEquals((int)0, (int)stat.getEntryDecodeErrors().size());
        GemFireXDDataExtractorJUnit.assertTrue((boolean)this.areStatsEqual(expectedStat, stat));
        File csvFile = new File(stat.getFileName());
        GemFireXDDataExtractorJUnit.assertTrue((boolean)csvFile.exists());
        GemFireXDDataExtractorJUnit.assertEquals((int)expectedStat.getNumValuesDecoded(), (int)GemFireXDDataExtractorJUnit.numLines(csvFile));
    }

    public void testCSVExportSingleNodeReplicateDropTable() throws Exception {
        String schemaName = "APP";
        String tableName = "REPLICATE_TABLE";
        String dropTableName = "REPLICATE_DROP_TABLE";
        String bucketName = null;
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 1000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.createPersistentReplicateTable(dropTableName, this.testDiskStoreName);
        this.insertData(dropTableName, 0, 1000);
        this.updateData(dropTableName, 0, 300);
        this.deleteData(dropTableName, 300, 600);
        this.dropTable(dropTableName);
        this.copyDataDictionary();
        this.copyOplogs();
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        List stats = GemFireXDDataExtractorImpl.exportDataOpLog((String)this.testDiskStoreName, (String)this.oplogCopy.getCanonicalPath(), (String)this.outputDir.getCanonicalPath(), (boolean)false);
        GFXDSnapshotExportStat expectedStat = new GFXDSnapshotExportStat(schemaName, tableName, bucketName, null);
        expectedStat.setNumValuesDecoded(700);
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        GemFireXDDataExtractorJUnit.assertEquals((int)1, (int)stats.size());
        GemFireXDDataExtractorJUnit.assertEquals((int)0, (int)stat.getEntryDecodeErrors().size());
        GemFireXDDataExtractorJUnit.assertTrue((boolean)this.areStatsEqual(expectedStat, stat));
        File csvFile = new File(stat.getFileName());
        GemFireXDDataExtractorJUnit.assertTrue((boolean)csvFile.exists());
        GemFireXDDataExtractorJUnit.assertEquals((int)expectedStat.getNumValuesDecoded(), (int)GemFireXDDataExtractorJUnit.numLines(csvFile));
    }

    public void testCSVExportSingleNodeReplicateOplogCrfCorrupt() throws Exception {
        String tableName = "REPLICATED_TABLE";
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 10000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        this.copyOplogs();
        Iterator oplogIterator = FileUtils.iterateFiles((File)this.oplogCopy, (String[])new String[]{"crf"}, (boolean)true);
        while (oplogIterator.hasNext()) {
            GemFireXDDataExtractorJUnit.corruptFile(500, (File)oplogIterator.next());
        }
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        ArrayList<String> diskStoreList = new ArrayList<String>();
        diskStoreList.add(this.oplogCopy.getCanonicalPath());
        List stats = extractor.extractDiskStores(this.testDiskStoreName, diskStoreList, this.outputDir.getCanonicalPath());
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        GemFireXDDataExtractorJUnit.assertEquals((int)1, (int)stats.size());
        GemFireXDDataExtractorJUnit.assertTrue((boolean)stat.isCorrupt());
    }

    public void testCSVExportSingleNodeReplicateOplogCrfDelete() throws Exception {
        String tableName = "REPLICATED_TABLE";
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 10000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        this.copyOplogs();
        Iterator oplogIterator = FileUtils.iterateFiles((File)this.oplogCopy, (String[])new String[]{"crf"}, (boolean)true);
        while (oplogIterator.hasNext()) {
            this.deleteFile((File)oplogIterator.next());
        }
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        ArrayList<String> diskStoreList = new ArrayList<String>();
        diskStoreList.add(this.oplogCopy.getCanonicalPath());
        List stats = extractor.extractDiskStores(this.testDiskStoreName, diskStoreList, this.outputDir.getCanonicalPath());
        GemFireXDDataExtractorJUnit.assertEquals((int)0, (int)stats.size());
    }

    public void DISABLEtestCSVExportSingleNodeReplicateOplogKrfCorrupt() throws Exception {
        String tableName = "REPLICATED_TABLE";
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 10000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        this.copyOplogs();
        Iterator oplogIterator = FileUtils.iterateFiles((File)this.oplogCopy, (String[])new String[]{"krf"}, (boolean)true);
        while (oplogIterator.hasNext()) {
            GemFireXDDataExtractorJUnit.corruptFile(500, (File)oplogIterator.next());
        }
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        ArrayList<String> diskStoreList = new ArrayList<String>();
        diskStoreList.add(this.oplogCopy.getCanonicalPath());
        List stats = extractor.extractDiskStores(this.testDiskStoreName, diskStoreList, this.outputDir.getCanonicalPath());
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        GemFireXDDataExtractorJUnit.assertEquals((int)1, (int)stats.size());
        GemFireXDDataExtractorJUnit.assertTrue((boolean)stat.isCorrupt());
    }

    public void DISABLEtestCSVExportSingleNodeReplicateOplogKrfMissing() throws Exception {
        String tableName = "REPLICATED_TABLE";
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 10000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        this.copyOplogs();
        Iterator oplogIterator = FileUtils.iterateFiles((File)this.oplogCopy, (String[])new String[]{"krf"}, (boolean)true);
        while (oplogIterator.hasNext()) {
            this.deleteFile((File)oplogIterator.next());
        }
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        ArrayList<String> diskStoreList = new ArrayList<String>();
        diskStoreList.add(this.oplogCopy.getCanonicalPath());
        List stats = extractor.extractDiskStores(this.testDiskStoreName, diskStoreList, this.outputDir.getCanonicalPath());
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        GemFireXDDataExtractorJUnit.assertEquals((int)1, (int)stats.size());
    }

    public void testCSVExportSingleNodeReplicateOplogDrfCorrupt() throws Exception {
        String tableName = "REPLICATED_TABLE";
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 10000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        this.copyOplogs();
        Iterator oplogIterator = FileUtils.iterateFiles((File)this.oplogCopy, (String[])new String[]{"drf"}, (boolean)true);
        while (oplogIterator.hasNext()) {
            GemFireXDDataExtractorJUnit.corruptFile(21, (File)oplogIterator.next());
        }
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        ArrayList<String> diskStoreList = new ArrayList<String>();
        diskStoreList.add(this.oplogCopy.getCanonicalPath());
        List stats = extractor.extractDiskStores(this.testDiskStoreName, diskStoreList, this.outputDir.getCanonicalPath());
        GemFireXDDataExtractorJUnit.assertEquals((int)0, (int)stats.size());
    }

    public void testCSVExportSingleNodeReplicateOplogDrfMissing() throws Exception {
        GemFireXDDataExtractorJUnit.addExpectedException("Unable to recover the following tables, possibly due to a missing .drf file:");
        String tableName = "REPLICATED_TABLE";
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 10000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        this.copyOplogs();
        Iterator oplogIterator = FileUtils.iterateFiles((File)this.oplogCopy, (String[])new String[]{"drf"}, (boolean)true);
        while (oplogIterator.hasNext()) {
            this.deleteFile((File)oplogIterator.next());
        }
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        ArrayList<String> diskStoreList = new ArrayList<String>();
        diskStoreList.add(this.oplogCopy.getCanonicalPath());
        List stats = extractor.extractDiskStores(this.testDiskStoreName, diskStoreList, this.outputDir.getCanonicalPath());
        GemFireXDDataExtractorJUnit.assertEquals((int)0, (int)stats.size());
    }

    public void testCSVExportSingleNodePartitioned() throws Exception {
        String schemaName = "APP";
        String tableName = "PARTITIONED_TABLE";
        String bucketName = null;
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentPartitionedTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 1000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.copyDataDictionary();
        this.copyOplogs();
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        List stats = GemFireXDDataExtractorImpl.exportDataOpLog((String)this.testDiskStoreName, (String)this.oplogCopy.getCanonicalPath(), (String)this.outputDir.getCanonicalPath(), (boolean)false);
        GFXDSnapshotExportStat expectedStat = new GFXDSnapshotExportStat(schemaName, tableName, bucketName, null);
        expectedStat.setNumValuesDecoded(700);
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        GemFireXDDataExtractorJUnit.assertEquals((int)113, (int)stats.size());
        GemFireXDDataExtractorJUnit.assertEquals((int)0, (int)stat.getEntryDecodeErrors().size());
        int total = 0;
        Iterator listIterator = stats.iterator();
        while (listIterator.hasNext()) {
            total += ((GFXDSnapshotExportStat)listIterator.next()).getNumValuesDecoded();
        }
        GemFireXDDataExtractorJUnit.assertEquals((int)700, (int)total);
    }

    public void testCSVExportSingleNodePartitionedDropTable() throws Exception {
        String schemaName = "APP";
        String tableName = "PARTITIONED_TABLE";
        String dropTableName = "PARTITIONED_DROP_TABLE";
        String bucketName = null;
        this.createDiskStore(this.testDiskStoreName);
        this.createPersistentPartitionedTable(tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 1000);
        this.updateData(tableName, 0, 300);
        this.deleteData(tableName, 300, 600);
        this.createPersistentPartitionedTable(dropTableName, this.testDiskStoreName);
        this.insertData(dropTableName, 0, 1000);
        this.updateData(dropTableName, 0, 300);
        this.deleteData(dropTableName, 300, 600);
        this.dropTable(dropTableName);
        this.copyDataDictionary();
        this.copyOplogs();
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        extractor.createTestConnection();
        extractor.retrieveAllRowFormatters();
        List stats = GemFireXDDataExtractorImpl.exportDataOpLog((String)this.testDiskStoreName, (String)this.oplogCopy.getCanonicalPath(), (String)this.outputDir.getCanonicalPath(), (boolean)false);
        GFXDSnapshotExportStat expectedStat = new GFXDSnapshotExportStat(schemaName, tableName, bucketName, null);
        expectedStat.setNumValuesDecoded(700);
        GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
        GemFireXDDataExtractorJUnit.assertEquals((int)113, (int)stats.size());
        GemFireXDDataExtractorJUnit.assertEquals((int)0, (int)stat.getEntryDecodeErrors().size());
        int total = 0;
        Iterator listIterator = stats.iterator();
        while (listIterator.hasNext()) {
            total += ((GFXDSnapshotExportStat)listIterator.next()).getNumValuesDecoded();
        }
        GemFireXDDataExtractorJUnit.assertEquals((int)700, (int)total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCSVExportSingleNodeNoIndexExportTable() throws Exception {
        try {
            String schemaName = "APP";
            String tableName = "REPLICATE_TABLE";
            String bucketName = null;
            System.setProperty("persist-indexes", "true");
            this.createDiskStore(this.testDiskStoreName);
            this.createPersistentReplicateTable(tableName, this.testDiskStoreName);
            this.createIndex(tableName);
            this.insertData(tableName, 0, 1000);
            this.deleteData(tableName, 300, 600);
            this.copyDataDictionary();
            this.copyOplogs();
            GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
            extractor.createTestConnection();
            extractor.retrieveAllRowFormatters();
            List stats = GemFireXDDataExtractorImpl.exportDataOpLog((String)this.testDiskStoreName, (String)this.oplogCopy.getCanonicalPath(), (String)this.outputDir.getCanonicalPath(), (boolean)false);
            GFXDSnapshotExportStat expectedStat = new GFXDSnapshotExportStat(schemaName, tableName, bucketName, null);
            expectedStat.setNumValuesDecoded(700);
            GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)stats.get(0);
            GemFireXDDataExtractorJUnit.assertEquals((int)1, (int)stats.size());
            GemFireXDDataExtractorJUnit.assertEquals((int)0, (int)stat.getEntryDecodeErrors().size());
            GemFireXDDataExtractorJUnit.assertTrue((boolean)this.areStatsEqual(expectedStat, stat));
        }
        finally {
            System.setProperty("persist-indexes", "false");
        }
    }

    public void testextractorArgs() {
        GemFireXDDataExtractorImpl extractor = new GemFireXDDataExtractorImpl();
        boolean exceptionThrown = false;
        try {
            extractor.consumeProperties();
            extractor.extract();
        }
        catch (Exception e) {
            exceptionThrown = true;
        }
        GemFireXDDataExtractorJUnit.assertTrue((boolean)exceptionThrown);
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("property-file=salvage.properties");
        try {
            extractor.processArgs(argsList.toArray(new String[argsList.size()]));
            extractor.consumeProperties();
            extractor.extract();
        }
        catch (Exception e) {
            GemFireXDDataExtractorJUnit.assertTrue((boolean)(e instanceof FileNotFoundException));
        }
        argsList.clear();
        String propFilePath = "salvage.properties";
        String logLevelString = "FINE";
        String logFilePath = "extractor.log";
        String delimiter = ",";
        String outputDirPath = "/kuwait1/salvage";
        String numThreads = "3";
        argsList.add("property-file=" + propFilePath);
        argsList.add("--log-level=" + logLevelString);
        argsList.add("--log-file=" + logFilePath);
        argsList.add("--string-delimiter=,");
        argsList.add("--output-dir=" + outputDirPath);
        argsList.add("--num-threads=" + numThreads);
        try {
            extractor.processArgs(argsList.toArray(new String[argsList.size()]));
            extractor.consumeProperties();
            GemFireXDDataExtractorJUnit.assertEquals((String)extractor.getLogLevelString(), (String)logLevelString);
            GemFireXDDataExtractorJUnit.assertEquals((String)extractor.getStringDelimiter(), (String)delimiter);
            System.out.println(extractor.getLogFilePath());
            GemFireXDDataExtractorJUnit.assertTrue((boolean)extractor.getLogFilePath().contains(logFilePath));
            GemFireXDDataExtractorJUnit.assertFalse((boolean)extractor.isShowHelp());
            GemFireXDDataExtractorJUnit.assertFalse((boolean)extractor.isUseSingleDDL());
            GemFireXDDataExtractorJUnit.assertFalse((boolean)extractor.isSalvageInServerDir());
            GemFireXDDataExtractorJUnit.assertTrue((boolean)extractor.useOverrodeNumThreads());
            GemFireXDDataExtractorJUnit.assertTrue((extractor.getUserNumThreads() == 3 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyDataDictionary() throws IOException {
        FileUtils.copyDirectory((File)new File("./datadictionary"), (File)this.ddCopy);
    }

    private void copyOplogs() throws IOException {
        this.copyOplogs("./" + this.testDiskStoreName);
    }

    private void copyOplogs(String diskStoreLocation) throws IOException {
        FileUtils.copyDirectory((File)new File(diskStoreLocation), (File)this.oplogCopy);
    }

    private boolean areStatsEqual(GFXDSnapshotExportStat expectedStat, GFXDSnapshotExportStat stat) throws Exception {
        if (expectedStat.getNumValuesDecoded() != stat.getNumValuesDecoded()) {
            throw new Exception("Expected values decoded:" + expectedStat.getNumValuesDecoded() + " but was " + stat.getNumValuesDecoded());
        }
        if (!expectedStat.getSchemaTableName().equals(stat.getSchemaTableName())) {
            throw new Exception("Expected schema/table name:" + expectedStat.getSchemaTableName() + " but was " + stat.getSchemaTableName());
        }
        return true;
    }

    static int numLines(File csvFile) throws IOException {
        int numLines = 0;
        BufferedReader reader = new BufferedReader(new FileReader(csvFile));
        String line = reader.readLine();
        while (line != null) {
            ++numLines;
            line = reader.readLine();
        }
        return numLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void corruptFile(int sizeToCopy, File file) throws IOException {
        File parent = file.getParentFile();
        File corruptFile = new File(parent, "corruptOplog");
        RandomAccessFile raf = null;
        FileOutputStream fos = null;
        try {
            raf = new RandomAccessFile(file, "r");
            byte[] bytesRead = new byte[sizeToCopy];
            long remainingSize = file.length() - (long)sizeToCopy;
            raf.read(bytesRead);
            byte[] randomStuff = new byte[(int)remainingSize];
            int i = 0;
            while ((long)i < remainingSize) {
                randomStuff[i] = 1;
                ++i;
            }
            fos = new FileOutputStream(corruptFile);
            fos.write(bytesRead);
            fos.write(randomStuff);
        }
        finally {
            fos.close();
            raf.close();
        }
        FileUtils.forceDelete((File)file);
        corruptFile.renameTo(file);
    }

    private void deleteFile(File file) throws IOException {
        FileUtils.forceDelete((File)file);
    }

    private void insertData(String tableName, int startIndex, int endIndex) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement("INSERT INTO " + tableName + "(bigIntegerField, blobField, charField," + "charForBitData, clobField, dateField, decimalField, doubleField, floatField, longVarcharForBitDataField, numericField," + "realField, smallIntField, timeField, timestampField, varcharField, varcharForBitData, xmlField) values( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, xmlparse(document cast (? as clob) PRESERVE WHITESPACE))");
        for (int i = startIndex; i < endIndex; ++i) {
            int lessThan10 = i % 10;
            ps.setLong(1, i);
            ps.setBlob(2, new ByteArrayInputStream(new byte[]{(byte)i, (byte)i, (byte)i, (byte)i}));
            ps.setString(3, "" + lessThan10);
            ps.setBytes(4, ("" + lessThan10).getBytes());
            ps.setClob(5, new StringReader("SOME CLOB " + i));
            ps.setDate(6, new Date(System.currentTimeMillis()));
            ps.setBigDecimal(7, new BigDecimal((double)lessThan10 + 0.8));
            ps.setDouble(8, (double)i + 0.88);
            ps.setFloat(9, (float)i + 0.9f);
            ps.setBytes(10, ("A" + lessThan10).getBytes());
            ps.setBigDecimal(11, new BigDecimal(i));
            ps.setFloat(12, lessThan10 * 1111);
            ps.setShort(13, (short)i);
            ps.setTime(14, new Time(System.currentTimeMillis()));
            ps.setTimestamp(15, new Timestamp(System.currentTimeMillis()));
            ps.setString(16, "HI" + lessThan10);
            ps.setBytes(17, ("" + lessThan10).getBytes());
            ps.setClob(18, new StringReader("<xml><sometag>SOME XML CLOB " + i + "</sometag></xml>"));
            ps.execute();
        }
    }

    private void deleteData(String tableName, int startIndex, int endIndex) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement("delete from " + tableName + " where bigIntegerField = ?");
        for (int i = startIndex; i < endIndex; ++i) {
            ps.setLong(1, i);
            ps.execute();
        }
    }

    private void updateData(String tableName, int startIndex, int endIndex) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement("UPDATE " + tableName + " set blobField=?, charField=?," + "charForBitData=?, clobField=?, dateField=?, decimalField=?, doubleField=?, floatField=?, longVarcharForBitDataField=?, numericField=?," + "realField=?, smallIntField=?, timeField=?, timestampField=?, varcharField=?, varcharForBitData=?, xmlField=xmlparse(document cast (? as clob) PRESERVE WHITESPACE) where bigIntegerField=?");
        for (int i = startIndex; i < endIndex; ++i) {
            int lessThan10 = i % 10;
            ps.setBlob(1, new ByteArrayInputStream(new byte[]{(byte)i, (byte)i, (byte)i, (byte)i}));
            ps.setString(2, "" + lessThan10);
            ps.setBytes(3, ("" + lessThan10).getBytes());
            ps.setClob(4, new StringReader("UPDATE CLOB " + i));
            ps.setDate(5, new Date(System.currentTimeMillis()));
            ps.setBigDecimal(6, new BigDecimal((double)lessThan10 + 0.8));
            ps.setDouble(7, (double)i + 0.88);
            ps.setFloat(8, (float)i + 0.9f);
            ps.setBytes(9, ("B" + lessThan10).getBytes());
            ps.setBigDecimal(10, new BigDecimal(i));
            ps.setFloat(11, lessThan10 * 1111);
            ps.setShort(12, (short)i);
            ps.setTime(13, new Time(System.currentTimeMillis()));
            ps.setTimestamp(14, new Timestamp(System.currentTimeMillis()));
            ps.setString(15, "BY" + lessThan10);
            ps.setBytes(16, ("" + lessThan10).getBytes());
            ps.setClob(17, new StringReader("<xml><sometag>UPDATE XML CLOB " + i + "</sometag></xml>"));
            ps.setLong(18, i);
            ps.execute();
        }
    }

    private void createSchema(String schemaName) throws SQLException {
        this.statement.execute("CREATE SCHEMA " + schemaName);
    }

    private void setCurrentSchema(String schemaName) throws SQLException {
        this.statement.execute("SET CURRENT SCHEMA " + schemaName);
    }

    private void createDiskStore(String diskStoreName) throws SQLException {
        String createDiskStore = "CREATE DISKSTORE " + diskStoreName + "('" + diskStoreName + "') MAXLOGSIZE 1";
        String[] newDeleteDirs = new String[this.deleteDirs.length + 1];
        for (int i = 0; i < this.deleteDirs.length; ++i) {
            newDeleteDirs[i] = this.deleteDirs[i];
        }
        newDeleteDirs[this.deleteDirs.length] = "./" + diskStoreName;
        this.deleteDirs = newDeleteDirs;
        this.statement.execute(createDiskStore);
    }

    private void createDiskStoreAllowForceCompaction(String diskStoreName) throws SQLException {
        String createDiskStore = "CREATE DISKSTORE " + diskStoreName + " ALLOWFORCECOMPACTION TRUE  COMPACTIONTHRESHOLD  1('" + diskStoreName + "') MAXLOGSIZE 1";
        String[] newDeleteDirs = new String[this.deleteDirs.length + 1];
        for (int i = 0; i < this.deleteDirs.length; ++i) {
            newDeleteDirs[i] = this.deleteDirs[i];
        }
        newDeleteDirs[this.deleteDirs.length] = "./" + diskStoreName;
        this.deleteDirs = newDeleteDirs;
        this.statement.execute(createDiskStore);
    }

    private void createPersistentReplicateTable(String tableName, String diskStoreName) throws SQLException {
        String create = "CREATE TABLE " + tableName + "(bigIntegerField BIGINT, blobField BLOB(1K), charField CHAR(1)," + "charForBitData CHAR(1) FOR BIT DATA, clobField CLOB(1K), dateField DATE, decimalField DECIMAL(10,1)," + "doubleField DOUBLE, floatField FLOAT(10), longVarcharForBitDataField LONG VARCHAR FOR BIT DATA," + "numericField NUMERIC(10,1), realField REAL, smallIntField SMALLINT, timeField TIME, timestampField TIMESTAMP," + "varcharField VARCHAR(10), varcharForBitData VARCHAR(1) FOR BIT DATA, xmlField XML) REPLICATE persistent '" + diskStoreName + "'";
        this.statement.execute(create);
    }

    private void createPersistentPartitionedTable(String tableName, String diskStoreName) throws SQLException {
        String create = "CREATE TABLE " + tableName + "(bigIntegerField BIGINT, blobField BLOB(1K), charField CHAR(1)," + "charForBitData CHAR(1) FOR BIT DATA, clobField CLOB(1K), dateField DATE, decimalField DECIMAL(10,1)," + "doubleField DOUBLE, floatField FLOAT(10), longVarcharForBitDataField LONG VARCHAR FOR BIT DATA," + "numericField NUMERIC(10,1), realField REAL, smallIntField SMALLINT, timeField TIME, timestampField TIMESTAMP," + "varcharField VARCHAR(10), varcharForBitData VARCHAR(1) FOR BIT DATA, xmlField XML, " + "PRIMARY KEY(bigIntegerField)) PARTITION BY PRIMARY KEY persistent '" + diskStoreName + "'";
        this.statement.execute(create);
    }

    private void dropTable(String tableName) throws SQLException {
        String drop = "DROP TABLE " + tableName;
        this.statement.execute(drop);
    }

    private void createIndex(String tableName) throws SQLException {
        String index = "CREATE INDEX " + tableName + "_INDEX on " + tableName + "(bigIntegerField)";
        this.statement.execute(index);
    }
}

