/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor;

import com.gemstone.gemfire.cache.CacheException;
import com.pivotal.gemfirexd.DistributedSQLTestBase;
import com.pivotal.gemfirexd.TestUtil;
import com.pivotal.gemfirexd.internal.tools.dataextractor.GemFireXDDataExtractorJUnit;
import com.pivotal.gemfirexd.internal.tools.dataextractor.extractor.GemFireXDDataExtractorImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import com.pivotal.gemfirexd.internal.tools.dataextractor.utils.ExtractorUtils;
import io.snappydata.test.dunit.SerializableRunnable;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class GemFireXDDataExtractorDUnit
extends DistributedSQLTestBase {
    private String testDiskStoreName = "TESTDISKSTORE";
    private String secondDiskStoreName = "SECONDDISKSTORE";
    private String copyDirectory = "copyWorkingDirectory";

    public GemFireXDDataExtractorDUnit(String name) {
        super(name);
    }

    private void disconnectTestInstanceAndCleanUp() throws SQLException {
        ExtractorUtils.cleanWorkingDirectory();
        TestUtil.shutDown();
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.configureDefaultOffHeap(true);
        ExtractorUtils.cleanWorkingDirectory();
    }

    @Override
    public void tearDown2() throws Exception {
        super.tearDown2();
        this.stopAllVMs();
        this.shutDownAll();
    }

    public void testDummy() throws Exception {
    }

    public void testHappyPathDataSalvager() throws Exception {
        String tableName = "REPLICATE_TABLE";
        String server1Name = "server1";
        String server2Name = "server2";
        int numDDL = 3;
        this.startVMs(1, 2);
        this.clientCreateDiskStore(1, this.testDiskStoreName);
        String[] jsonStrings = new String[]{"{\"f1\":1,\"f2\":true}", "{\"f3\":1,\"f4\":true}", "{\"f5\":1,\"f6\":true}", null, "{\"f6\":1,\"f7\":true}", "{\"f7\":1,\"f8\":true}"};
        String createTable = "CREATE table t1(col1 int, col2 json) REPLICATE persistent 'TESTDISKSTORE'";
        this.clientSQLExecute(1, createTable);
        this.clientSQLExecute(1, "insert into t1 values (1, '" + jsonStrings[0] + "')");
        this.clientSQLExecute(1, "insert into t1 values (2, '{\"JSON\":\"JSON\"}')");
        this.clientCreatePersistentReplicateTable(1, tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 1000);
        this.updateData(tableName, 300, 600);
        this.deleteData(tableName, 600, 900);
        String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
        String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
        this.serverExecute(1, this.getCopyDataDictionary(server1Directory));
        this.serverExecute(2, this.getCopyDataDictionary(server2Directory));
        this.serverExecute(1, this.getCopyOplogsRunnable(server1Directory, this.testDiskStoreName));
        this.serverExecute(2, this.getCopyOplogsRunnable(server2Directory, this.testDiskStoreName));
        String propertiesFileName = "test_salvage.properties";
        Properties properties = new Properties();
        String server1CopyDir = server1Directory + File.separator + this.copyDirectory;
        String server2CopyDir = server2Directory + File.separator + this.copyDirectory;
        properties.setProperty(server1Name, server1CopyDir + "," + server1CopyDir + File.separator + this.testDiskStoreName);
        properties.setProperty(server2Name, server2CopyDir + "," + server2CopyDir + File.separator + this.testDiskStoreName);
        properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
        String userName = TestUtil.currentUserName == null ? "APP" : TestUtil.currentUserName;
        String[] args = new String[]{"property-file=" + propertiesFileName, "--user-name=" + userName};
        this.disconnectTestInstanceAndCleanUp();
        GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
        String outputDirectoryString = salvager.getOutputDirectory();
        File outputDirectory = new File(outputDirectoryString);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)outputDirectory.exists());
        File server1OutputDirectory = new File(outputDirectory, server1Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server1OutputDirectory, new String[]{tableName}, numDDL));
        File server2OutputDirectory = new File(outputDirectory, server2Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server2OutputDirectory, new String[]{tableName}, numDDL));
        File summaryFile = new File(outputDirectory, "Summary.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)summaryFile.exists());
        File recommended = new File(outputDirectory, "Recommended.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)recommended.exists());
        FileUtils.deleteDirectory((File)outputDirectory);
    }

    public void testMultiDiskStore() throws Exception {
        String tableName = "REPLICATE_TABLE";
        String secondTableName = "REPLICATE_2_TABLE";
        String server1Name = "server1";
        String server2Name = "server2";
        int numDDL = 4;
        this.startVMs(1, 2);
        this.clientCreateDiskStore(1, this.testDiskStoreName);
        this.clientCreateDiskStore(1, this.secondDiskStoreName);
        this.clientCreatePersistentReplicateTable(1, tableName, this.testDiskStoreName);
        this.clientCreatePersistentReplicateTable(1, secondTableName, this.secondDiskStoreName);
        this.insertData(tableName, 0, 1000);
        this.updateData(tableName, 300, 600);
        this.deleteData(tableName, 600, 900);
        this.insertData(secondTableName, 0, 1000);
        this.updateData(secondTableName, 300, 600);
        this.deleteData(secondTableName, 600, 900);
        String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
        String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
        this.serverExecute(1, this.getCopyDataDictionary(server1Directory));
        this.serverExecute(2, this.getCopyDataDictionary(server2Directory));
        this.serverExecute(1, this.getCopyOplogsRunnable(server1Directory, this.testDiskStoreName));
        this.serverExecute(2, this.getCopyOplogsRunnable(server2Directory, this.testDiskStoreName));
        this.serverExecute(1, this.getCopyOplogsRunnable(server1Directory, this.secondDiskStoreName));
        this.serverExecute(2, this.getCopyOplogsRunnable(server2Directory, this.secondDiskStoreName));
        String propertiesFileName = "test_salvage.properties";
        Properties properties = new Properties();
        String server1CopyDir = server1Directory + File.separator + this.copyDirectory;
        String server2CopyDir = server2Directory + File.separator + this.copyDirectory;
        properties.setProperty(server1Name, server1CopyDir + "," + server1CopyDir + File.separator + this.testDiskStoreName + "," + server1CopyDir + File.separator + this.secondDiskStoreName);
        properties.setProperty(server2Name, server2CopyDir + "," + server2CopyDir + File.separator + this.testDiskStoreName + "," + server2CopyDir + File.separator + this.secondDiskStoreName);
        properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
        String userName = TestUtil.currentUserName == null ? "APP" : TestUtil.currentUserName;
        String[] args = new String[]{"property-file=" + propertiesFileName, "--user-name=" + userName};
        this.disconnectTestInstanceAndCleanUp();
        GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
        String outputDirectoryString = salvager.getOutputDirectory();
        File outputDirectory = new File(outputDirectoryString);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)outputDirectory.exists());
        File server1OutputDirectory = new File(outputDirectory, server1Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server1OutputDirectory, new String[]{tableName, secondTableName}, numDDL));
        File server2OutputDirectory = new File(outputDirectory, server2Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server2OutputDirectory, new String[]{tableName, secondTableName}, numDDL));
        File summaryFile = new File(outputDirectory, "Summary.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)summaryFile.exists());
        File recommended = new File(outputDirectory, "Recommended.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)recommended.exists());
        FileUtils.deleteDirectory((File)outputDirectory);
    }

    public void testCorruptCRFOnOneNode() throws Exception {
        String tableName = "REPLICATE_TABLE";
        String server1Name = "server1";
        String server2Name = "server2";
        int numDDL = 2;
        this.startVMs(1, 2);
        this.clientCreateDiskStore(1, this.testDiskStoreName);
        this.clientCreatePersistentReplicateTable(1, tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 100);
        this.updateData(tableName, 30, 60);
        this.deleteData(tableName, 60, 90);
        String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
        String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
        this.serverExecute(1, this.getCopyDataDictionary(server1Directory));
        this.serverExecute(2, this.getCopyDataDictionary(server2Directory));
        this.serverExecute(1, this.getCopyOplogsRunnable(server1Directory, this.testDiskStoreName));
        this.serverExecute(1, this.getCorruptOplogsRunnable(server1Directory, this.testDiskStoreName, new String[]{".crf"}, 400));
        this.serverExecute(2, this.getCopyOplogsRunnable(server2Directory, this.testDiskStoreName));
        String propertiesFileName = "test_salvage.properties";
        Properties properties = new Properties();
        String server1CopyDir = server1Directory + File.separator + this.copyDirectory;
        String server2CopyDir = server2Directory + File.separator + this.copyDirectory;
        properties.setProperty(server1Name, server1CopyDir + "," + server1CopyDir + File.separator + this.testDiskStoreName);
        properties.setProperty(server2Name, server2CopyDir + "," + server2CopyDir + File.separator + this.testDiskStoreName);
        properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
        String userName = TestUtil.currentUserName == null ? "APP" : TestUtil.currentUserName;
        String[] args = new String[]{"property-file=" + propertiesFileName, "--user-name=" + userName};
        this.disconnectTestInstanceAndCleanUp();
        GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
        String outputDirectoryString = salvager.getOutputDirectory();
        File outputDirectory = new File(outputDirectoryString);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)outputDirectory.exists());
        File server1OutputDirectory = new File(outputDirectory, server1Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server1OutputDirectory, new String[0], numDDL));
        File server2OutputDirectory = new File(outputDirectory, server2Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server2OutputDirectory, new String[]{tableName}, numDDL));
        File summaryFile = new File(outputDirectory, "Summary.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)summaryFile.exists());
        File recommended = new File(outputDirectory, "Recommended.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)recommended.exists());
        FileUtils.deleteDirectory((File)outputDirectory);
    }

    public void testCorruptIfOnOneNode() throws Exception {
        String tableName = "REPLICATE_TABLE";
        String server1Name = "server1";
        String server2Name = "server2";
        int numDDL = 2;
        this.startVMs(1, 2);
        this.clientCreateDiskStore(1, this.testDiskStoreName);
        this.clientCreatePersistentReplicateTable(1, tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 100);
        this.updateData(tableName, 30, 60);
        this.deleteData(tableName, 60, 90);
        String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
        String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
        this.serverExecute(1, this.getCopyDataDictionary(server1Directory));
        this.serverExecute(2, this.getCopyDataDictionary(server2Directory));
        this.serverExecute(1, this.getCopyOplogsRunnable(server1Directory, this.testDiskStoreName));
        this.serverExecute(1, this.getCorruptIfRunnable(server1Directory, this.testDiskStoreName));
        this.serverExecute(2, this.getCopyOplogsRunnable(server2Directory, this.testDiskStoreName));
        String propertiesFileName = "test_salvage.properties";
        Properties properties = new Properties();
        String server1CopyDir = server1Directory + File.separator + this.copyDirectory;
        String server2CopyDir = server2Directory + File.separator + this.copyDirectory;
        properties.setProperty(server1Name, server1CopyDir + "," + server1CopyDir + File.separator + this.testDiskStoreName);
        properties.setProperty(server2Name, server2CopyDir + "," + server2CopyDir + File.separator + this.testDiskStoreName);
        properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
        String userName = TestUtil.currentUserName == null ? "APP" : TestUtil.currentUserName;
        String[] args = new String[]{"property-file=" + propertiesFileName, "--user-name=" + userName};
        this.disconnectTestInstanceAndCleanUp();
        GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
        String outputDirectoryString = salvager.getOutputDirectory();
        File outputDirectory = new File(outputDirectoryString);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)outputDirectory.exists());
        File server1OutputDirectory = new File(outputDirectory, server1Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server1OutputDirectory, new String[0], numDDL));
        File server2OutputDirectory = new File(outputDirectory, server2Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server2OutputDirectory, new String[]{tableName}, numDDL));
        File summaryFile = new File(outputDirectory, "Summary.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)summaryFile.exists());
        File recommended = new File(outputDirectory, "Recommended.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)recommended.exists());
        FileUtils.deleteDirectory((File)outputDirectory);
    }

    public void testMissingCRFOnOneNode() throws Exception {
        String tableName = "REPLICATE_TABLE";
        String server1Name = "server1";
        String server2Name = "server2";
        int numDDL = 2;
        this.startVMs(1, 2);
        this.clientCreateDiskStore(1, this.testDiskStoreName);
        this.clientCreatePersistentReplicateTable(1, tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 100);
        this.updateData(tableName, 30, 60);
        this.deleteData(tableName, 60, 90);
        String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
        String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
        this.serverExecute(1, this.getCopyDataDictionary(server1Directory));
        this.serverExecute(2, this.getCopyDataDictionary(server2Directory));
        this.serverExecute(1, this.getCopyOplogsRunnable(server1Directory, this.testDiskStoreName));
        this.serverExecute(1, this.getDeleteOplogsRunnable(server1Directory, this.testDiskStoreName, new String[]{".crf"}));
        this.serverExecute(2, this.getCopyOplogsRunnable(server2Directory, this.testDiskStoreName));
        String propertiesFileName = "test_salvage.properties";
        Properties properties = new Properties();
        String server1CopyDir = server1Directory + File.separator + this.copyDirectory;
        String server2CopyDir = server2Directory + File.separator + this.copyDirectory;
        properties.setProperty(server1Name, server1CopyDir + "," + server1CopyDir + File.separator + this.testDiskStoreName);
        properties.setProperty(server2Name, server2CopyDir + "," + server2CopyDir + File.separator + this.testDiskStoreName);
        properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
        String userName = TestUtil.currentUserName == null ? "APP" : TestUtil.currentUserName;
        String[] args = new String[]{"property-file=" + propertiesFileName, "--user-name=" + userName};
        this.disconnectTestInstanceAndCleanUp();
        GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
        String outputDirectoryString = salvager.getOutputDirectory();
        File outputDirectory = new File(outputDirectoryString);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)outputDirectory.exists());
        File server1OutputDirectory = new File(outputDirectory, server1Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server1OutputDirectory, new String[0], numDDL));
        File server2OutputDirectory = new File(outputDirectory, server2Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server2OutputDirectory, new String[]{tableName}, numDDL));
        File summaryFile = new File(outputDirectory, "Summary.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)summaryFile.exists());
        File recommended = new File(outputDirectory, "Recommended.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)recommended.exists());
        FileUtils.deleteDirectory((File)outputDirectory);
    }

    public void testCorruptDataDictionary() throws Exception {
        String tableName = "REPLICATE_TABLE";
        String server1Name = "server1";
        String server2Name = "server2";
        int numDDL = 2;
        this.startVMs(1, 2);
        this.clientCreateDiskStore(1, this.testDiskStoreName);
        this.clientCreatePersistentReplicateTable(1, tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 100);
        this.updateData(tableName, 30, 60);
        this.deleteData(tableName, 60, 90);
        String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
        String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
        this.serverExecute(1, this.getCopyDataDictionary(server1Directory));
        this.serverExecute(1, this.getCorruptOplogsRunnable(server1Directory, "datadictionary", new String[]{".crf"}, 200));
        this.serverExecute(2, this.getCopyDataDictionary(server2Directory));
        this.serverExecute(1, this.getCopyOplogsRunnable(server1Directory, this.testDiskStoreName));
        this.serverExecute(2, this.getCopyOplogsRunnable(server2Directory, this.testDiskStoreName));
        String propertiesFileName = "test_salvage.properties";
        Properties properties = new Properties();
        String server1CopyDir = server1Directory + File.separator + this.copyDirectory;
        String server2CopyDir = server2Directory + File.separator + this.copyDirectory;
        properties.setProperty(server1Name, server1CopyDir + "," + server1CopyDir + File.separator + this.testDiskStoreName);
        properties.setProperty(server2Name, server2CopyDir + "," + server2CopyDir + File.separator + this.testDiskStoreName);
        properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
        String userName = TestUtil.currentUserName == null ? "APP" : TestUtil.currentUserName;
        String[] args = new String[]{"property-file=" + propertiesFileName, "--user-name=" + userName};
        this.disconnectTestInstanceAndCleanUp();
        GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
        String outputDirectoryString = salvager.getOutputDirectory();
        File outputDirectory = new File(outputDirectoryString);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)outputDirectory.exists());
        this.serverExecute(1, this.getCheckDDLSizeRunnable(server1Directory, 0));
        File server2OutputDirectory = new File(outputDirectory, server2Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server2OutputDirectory, new String[]{tableName}, numDDL));
        File summaryFile = new File(outputDirectory, "Summary.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)summaryFile.exists());
        File recommended = new File(outputDirectory, "Recommended.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)recommended.exists());
        FileUtils.deleteDirectory((File)outputDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPersistentView() throws Exception {
        String testName = "testPersistentView";
        String diskStoreName = "testPersistentView" + this.testDiskStoreName;
        try {
            String tableName = "REPLICATE_TABLE";
            String server1Name = "server1";
            String server2Name = "server2";
            String server3Name = "server3";
            this.startVMs(1, 3);
            String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
            String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
            String server3Directory = this.getVM(-3).getWorkingDirectory().getAbsolutePath();
            this.clientCreateDiskStore(1, diskStoreName);
            this.clientCreatePersistentReplicateTable(1, tableName, diskStoreName);
            this.insertData(tableName, 0, 100);
            this.updateData(tableName, 30, 60);
            this.deleteData(tableName, 60, 90);
            this.stopVMNum(-1);
            this.clientDropTable(1, tableName);
            this.stopVMNum(-2);
            this.stopVMNum(-3);
            GemFireXDDataExtractorDUnit.assertTrue((boolean)new File(server1Directory).exists());
            GemFireXDDataExtractorDUnit.assertTrue((boolean)new File(server2Directory).exists());
            GemFireXDDataExtractorDUnit.assertTrue((boolean)new File(server3Directory).exists());
            String propertiesFileName = "test_salvage.properties";
            Properties properties = new Properties();
            properties.setProperty(server1Name, server1Directory + "," + server1Directory + File.separator + diskStoreName);
            properties.setProperty(server2Name, server2Directory + "," + server2Directory + File.separator + diskStoreName);
            properties.setProperty(server3Name, server3Directory + "," + server3Directory + File.separator + diskStoreName);
            properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
            String[] args = new String[]{"property-file=" + propertiesFileName};
            GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
            Map hostToStatsMap = salvager.getHostToStatsMap();
            GemFireXDDataExtractorDUnit.assertFalse((boolean)hostToStatsMap.isEmpty());
            GemFireXDDataExtractorDUnit.assertTrue((hostToStatsMap.size() == 3 ? 1 : 0) != 0);
            Set servers = hostToStatsMap.keySet();
            for (String server : servers) {
                this.getLogWriter().info((Object)("Server name : " + server));
            }
            List rankedAndGroupedDDlStats = salvager.getRankedAndGroupedDDLStats();
            GemFireXDDataExtractorDUnit.assertTrue((!rankedAndGroupedDDlStats.isEmpty() ? 1 : 0) != 0);
            GemFireXDDataExtractorDUnit.assertTrue((rankedAndGroupedDDlStats.size() == 2 ? 1 : 0) != 0);
            List statsGroup = (List)rankedAndGroupedDDlStats.get(0);
            GemFireXDDataExtractorDUnit.assertNotNull((Object)statsGroup);
            GFXDSnapshotExportStat stat = (GFXDSnapshotExportStat)statsGroup.get(0);
            GemFireXDDataExtractorDUnit.assertNotNull((Object)stat);
            GemFireXDDataExtractorDUnit.assertTrue((boolean)stat.getServerName().equals(server3Name));
            stat = (GFXDSnapshotExportStat)statsGroup.get(1);
            GemFireXDDataExtractorDUnit.assertNotNull((Object)stat);
            GemFireXDDataExtractorDUnit.assertTrue((boolean)stat.getServerName().equals(server2Name));
            statsGroup = (List)rankedAndGroupedDDlStats.get(1);
            GemFireXDDataExtractorDUnit.assertNotNull((Object)statsGroup);
            stat = (GFXDSnapshotExportStat)statsGroup.get(0);
            GemFireXDDataExtractorDUnit.assertTrue((boolean)stat.getServerName().equals(server1Name));
            FileUtils.deleteDirectory((File)new File(salvager.getOutputDirectory()));
            this.restartVMNums(-1, -2, -3);
        }
        finally {
            this.tearDown2();
            this.disconnectTestInstanceAndCleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithHDFSAndOffHeap() throws Exception {
        String testName = "testWithHDFS";
        String diskStoreName = "testWithHDFS" + this.testDiskStoreName;
        String hdfsStoreName = "testWithHDFSmyHDFSStore";
        try {
            String tableName = "REPLICATE_TABLE";
            String server1Name = "server1";
            String server2Name = "server2";
            String server3Name = "server3";
            this.startVMs(1, 3);
            String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
            String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
            String server3Directory = this.getVM(-3).getWorkingDirectory().getAbsolutePath();
            this.clientCreateHDFSSTORE(1, "testWithHDFSmyHDFSStore");
            this.clientCreateBookingTableWithHDFS(1, "testWithHDFSmyHDFSStore");
            this.clientCreateDiskStore(1, diskStoreName);
            this.clientCreatePersistentReplicateTable(1, tableName, diskStoreName);
            this.insertRowsIntoBookingsTable(1, 100);
            this.deleteRowsFromBookingsTable(1, 20);
            this.insertData(tableName, 0, 100);
            this.updateData(tableName, 30, 60);
            this.deleteData(tableName, 60, 90);
            this.stopVMNum(-1);
            this.stopVMNum(-2);
            this.dropBookingTable(1);
            this.dropHDFSStore(1, "testWithHDFSmyHDFSStore");
            this.stopVMNum(-3);
            GemFireXDDataExtractorDUnit.assertTrue((boolean)new File(server1Directory).exists());
            GemFireXDDataExtractorDUnit.assertTrue((boolean)new File(server2Directory).exists());
            GemFireXDDataExtractorDUnit.assertTrue((boolean)new File(server3Directory).exists());
            String propertiesFileName = "test_salvage.properties";
            Properties properties = new Properties();
            properties.setProperty(server1Name, server1Directory + "," + server1Directory + File.separator + diskStoreName);
            properties.setProperty(server2Name, server2Directory + "," + server2Directory + File.separator + diskStoreName);
            properties.setProperty(server3Name, server3Directory + "," + server3Directory + File.separator + diskStoreName);
            properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
            String[] args = new String[]{"property-file=" + propertiesFileName};
            GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
            Map hostToStatsMap = salvager.getHostToStatsMap();
            GemFireXDDataExtractorDUnit.assertFalse((boolean)hostToStatsMap.isEmpty());
            GemFireXDDataExtractorDUnit.assertTrue((hostToStatsMap.size() == 3 ? 1 : 0) != 0);
            this.restartVMNums(-1, -2, -3);
            FileUtils.deleteDirectory((File)new File(salvager.getOutputDirectory()));
        }
        finally {
            this.tearDown2();
            this.disconnectTestInstanceAndCleanUp();
        }
    }

    public void testMissingDataDictionary() throws Exception {
        String tableName = "REPLICATE_TABLE";
        String server1Name = "server1";
        String server2Name = "server2";
        int numDDL = 2;
        this.startVMs(1, 2);
        this.clientCreateDiskStore(1, this.testDiskStoreName);
        this.clientCreatePersistentReplicateTable(1, tableName, this.testDiskStoreName);
        this.insertData(tableName, 0, 100);
        this.updateData(tableName, 30, 60);
        this.deleteData(tableName, 60, 90);
        String server1Directory = this.getVM(-1).getWorkingDirectory().getAbsolutePath();
        String server2Directory = this.getVM(-2).getWorkingDirectory().getAbsolutePath();
        this.serverExecute(2, this.getCopyDataDictionary(server2Directory));
        this.serverExecute(1, this.getCopyOplogsRunnable(server1Directory, this.testDiskStoreName));
        this.serverExecute(2, this.getCopyOplogsRunnable(server2Directory, this.testDiskStoreName));
        String propertiesFileName = "test_salvage.properties";
        Properties properties = new Properties();
        String server1CopyDir = server1Directory + File.separator + this.copyDirectory;
        String server2CopyDir = server2Directory + File.separator + this.copyDirectory;
        properties.setProperty(server1Name, server1CopyDir + "," + server1CopyDir + File.separator + this.testDiskStoreName);
        properties.setProperty(server2Name, server2CopyDir + "," + server2CopyDir + File.separator + this.testDiskStoreName);
        properties.store(new FileOutputStream(new File(propertiesFileName)), "test properties");
        String userName = TestUtil.currentUserName == null ? "APP" : TestUtil.currentUserName;
        String[] args = new String[]{"property-file=" + propertiesFileName, "--user-name=" + userName};
        this.disconnectTestInstanceAndCleanUp();
        GemFireXDDataExtractorImpl salvager = GemFireXDDataExtractorImpl.doMain((String[])args);
        String outputDirectoryString = salvager.getOutputDirectory();
        File outputDirectory = new File(outputDirectoryString);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)outputDirectory.exists());
        File server1OutputDirectory = new File(outputDirectory, server1Name);
        this.serverExecute(1, this.getCheckDDLSizeRunnable(server1Directory, 0));
        File server2OutputDirectory = new File(outputDirectory, server2Name);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)this.serverExportedCorrectly(server2OutputDirectory, new String[]{tableName}, numDDL));
        File summaryFile = new File(outputDirectory, "Summary.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)summaryFile.exists());
        File recommended = new File(outputDirectory, "Recommended.txt");
        GemFireXDDataExtractorDUnit.assertTrue((boolean)recommended.exists());
        FileUtils.deleteDirectory((File)outputDirectory);
    }

    private boolean serverExportedCorrectly(File serverOutputDirectory, String[] tableNames, int numDDL) throws IOException {
        GemFireXDDataExtractorDUnit.assertTrue((boolean)serverOutputDirectory.exists());
        String[] ddl = serverOutputDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".sql");
            }
        });
        GemFireXDDataExtractorDUnit.assertEquals((int)1, (int)ddl.length);
        ArrayList ddlStatements = new ArrayList();
        for (int i = 0; i < ddl.length; ++i) {
            ddlStatements.addAll(ExtractorUtils.readSqlStatements((String)new File(serverOutputDirectory, ddl[i]).getAbsolutePath()));
        }
        GemFireXDDataExtractorDUnit.assertTrue((numDDL == ddlStatements.size() || numDDL + 1 == ddlStatements.size() ? 1 : 0) != 0);
        GemFireXDDataExtractorDUnit.assertTrue((boolean)new File(serverOutputDirectory, ddl[0]).exists());
        String[] csvs = serverOutputDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(".csv");
            }
        });
        List<String> list = Arrays.asList(csvs);
        for (int i = 0; i < tableNames.length; ++i) {
            if (this.checkCsvsContainsTableName(csvs, tableNames[i])) continue;
            GemFireXDDataExtractorDUnit.fail((String)("directory did not include csv for table name:" + tableNames[i]));
        }
        return true;
    }

    private boolean checkCsvsContainsTableName(String[] csvs, String tableName) throws IOException {
        for (int j = 0; j < csvs.length; ++j) {
            if (!csvs[j].contains(tableName) || csvs[j].contains("ERROR")) continue;
            return true;
        }
        return false;
    }

    private void insertData(String tableName, int startIndex, int endIndex) throws SQLException {
        Connection connection = TestUtil.getConnection();
        PreparedStatement ps = connection.prepareStatement("INSERT INTO " + tableName + "(bigIntegerField, blobField, charField," + "charForBitData, clobField, dateField, decimalField, doubleField, floatField, longVarcharForBitDataField, numericField," + "realField, smallIntField, timeField, timestampField, varcharField, varcharForBitData, xmlField) values( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, xmlparse(document cast (? as clob) PRESERVE WHITESPACE))");
        for (int i = startIndex; i < endIndex; ++i) {
            int lessThan10 = i % 10;
            ps.setLong(1, i);
            ps.setBlob(2, new ByteArrayInputStream(new byte[]{(byte)i, (byte)i, (byte)i, (byte)i}));
            ps.setString(3, "" + lessThan10);
            ps.setBytes(4, ("" + lessThan10).getBytes());
            ps.setClob(5, new StringReader("SOME CLOB " + i));
            ps.setDate(6, new Date(System.currentTimeMillis()));
            ps.setBigDecimal(7, new BigDecimal((double)lessThan10 + 0.8));
            ps.setDouble(8, (double)i + 0.88);
            ps.setFloat(9, (float)i + 0.9f);
            ps.setBytes(10, ("A" + lessThan10).getBytes());
            ps.setBigDecimal(11, new BigDecimal(i));
            ps.setFloat(12, lessThan10 * 1111);
            ps.setShort(13, (short)i);
            ps.setTime(14, new Time(System.currentTimeMillis()));
            ps.setTimestamp(15, new Timestamp(System.currentTimeMillis()));
            ps.setString(16, "HI" + lessThan10);
            ps.setBytes(17, ("" + lessThan10).getBytes());
            ps.setClob(18, new StringReader("<xml><sometag>SOME XML CLOB " + i + "</sometag></xml>"));
            ps.execute();
        }
    }

    private void deleteData(String tableName, int startIndex, int endIndex) throws SQLException {
        Connection connection = TestUtil.getConnection();
        PreparedStatement ps = connection.prepareStatement("delete from " + tableName + " where bigIntegerField=?");
        for (int i = startIndex; i < endIndex; ++i) {
            ps.setLong(1, i);
            ps.execute();
        }
    }

    private void updateData(String tableName, int startIndex, int endIndex) throws SQLException {
        Connection connection = TestUtil.getConnection();
        PreparedStatement ps = connection.prepareStatement("UPDATE " + tableName + " set blobField=?, charField=?," + "charForBitData=?, clobField=?, dateField=?, decimalField=?, doubleField=?, floatField=?, longVarcharForBitDataField=?, numericField=?," + "realField=?, smallIntField=?, timeField=?, timestampField=?, varcharField=?, varcharForBitData=?, xmlField=xmlparse(document cast (? as clob) PRESERVE WHITESPACE) where bigIntegerField=?");
        for (int i = startIndex; i < endIndex; ++i) {
            int lessThan10 = i % 10;
            ps.setBlob(1, new ByteArrayInputStream(new byte[]{(byte)i, (byte)i, (byte)i, (byte)i}));
            ps.setString(2, "" + lessThan10);
            ps.setBytes(3, ("" + lessThan10).getBytes());
            ps.setClob(4, new StringReader("UPDATE CLOB " + i));
            ps.setDate(5, new Date(System.currentTimeMillis()));
            ps.setBigDecimal(6, new BigDecimal((double)lessThan10 + 0.8));
            ps.setDouble(7, (double)i + 0.88);
            ps.setFloat(8, (float)i + 0.9f);
            ps.setBytes(9, ("B" + lessThan10).getBytes());
            ps.setBigDecimal(10, new BigDecimal(i));
            ps.setFloat(11, lessThan10 * 1111);
            ps.setShort(12, (short)i);
            ps.setTime(13, new Time(System.currentTimeMillis()));
            ps.setTimestamp(14, new Timestamp(System.currentTimeMillis()));
            ps.setString(15, "BY" + lessThan10);
            ps.setBytes(16, ("" + lessThan10).getBytes());
            ps.setClob(17, new StringReader("<xml><sometag>UPDATE XML CLOB " + i + "</sometag></xml>"));
            ps.setLong(18, i);
            ps.execute();
        }
    }

    private void clientCreateDiskStore(int clientId, String diskStoreName) throws Exception {
        this.clientSQLExecute(clientId, "CREATE DISKSTORE " + diskStoreName + "('" + diskStoreName + "') MAXLOGSIZE 2");
    }

    private void clientDropDiskStore(int clientId, String diskStoreName) throws Exception {
        this.clientSQLExecute(clientId, "DROP DISKSTORE " + diskStoreName);
    }

    private void clientCreatePersistentReplicateTable(int clientId, String tableName, String diskStoreName) throws Exception {
        String create = "CREATE TABLE " + tableName + "(bigIntegerField BIGINT, blobField BLOB(1K), charField CHAR(1)," + "charForBitData CHAR(1) FOR BIT DATA, clobField CLOB(1K), dateField DATE, decimalField DECIMAL(10,1)," + "doubleField DOUBLE, floatField FLOAT(10), longVarcharForBitDataField LONG VARCHAR FOR BIT DATA," + "numericField NUMERIC(10,1), realField REAL, smallIntField SMALLINT, timeField TIME, timestampField TIMESTAMP," + "varcharField VARCHAR(10), varcharForBitData VARCHAR(1) FOR BIT DATA, xmlField XML) REPLICATE persistent '" + diskStoreName + "'";
        this.clientSQLExecute(clientId, create);
    }

    private void clientCreateHDFSSTORE(int clientId, String hdfsStoreName) throws Exception {
        this.clientSQLExecute(clientId, "create hdfsstore " + hdfsStoreName + " namenode 'localhost' homedir './myhdfs' queuepersistent true");
    }

    private void dropHDFSStore(int clientId, String hdfsStoreName) throws Exception {
        this.clientSQLExecute(clientId, "DROP HDFSSTORE IF EXISTS " + hdfsStoreName);
    }

    private void dropBookingTable(int clientId) throws Exception {
        this.clientSQLExecute(1, "DROP TABLE IF EXISTS Booking");
    }

    private void clientCreateBookingTableWithHDFS(int clientId, String hdfsStoreName) throws Exception {
        this.clientSQLExecute(clientId, "CREATE TABLE Booking (id bigint not null, beds int not null, primary key (id)) PARTITION BY PRIMARY KEY PERSISTENT HDFSSTORE (" + hdfsStoreName + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertRowsIntoBookingsTable(int start, int count) throws SQLException {
        Connection conn = TestUtil.getConnection();
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            for (int i = 0; i < count; ++i) {
                stmt.executeUpdate("INSERT INTO BOOKING VALUES (" + i + start + ",1)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteRowsFromBookingsTable(int start, int count) throws SQLException {
        Connection conn = TestUtil.getConnection();
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            for (int i = 0; i < count; ++i) {
                stmt.executeUpdate("DELETE FROM BOOKING WHERE ID= + " + i + start);
            }
        }
    }

    private void clientCreatePersistentPartitionedTable(int clientId, String tableName, String diskStoreName) throws Exception {
        String create = "CREATE TABLE " + tableName + "(bigIntegerField BIGINT, blobField BLOB(1K), charField CHAR(1)," + "charForBitData CHAR(1) FOR BIT DATA, clobField CLOB(1K), dateField DATE, decimalField DECIMAL(10,1)," + "doubleField DOUBLE, floatField FLOAT(10), longVarcharForBitDataField LONG VARCHAR FOR BIT DATA," + "numericField NUMERIC(10,1), realField REAL, smallIntField SMALLINT, timeField TIME, timestampField TIMESTAMP," + "varcharField VARCHAR(10), varcharForBitData VARCHAR(1) FOR BIT DATA, xmlField XML, " + "PRIMARY KEY(bigIntegerField)) PARTITION BY PRIMARY KEY persistent '" + diskStoreName + "'";
        this.clientSQLExecute(clientId, create);
    }

    private void clientDropTable(int clientId, String tableName) throws Exception {
        String drop = "DROP TABLE " + tableName;
        this.clientSQLExecute(clientId, drop);
    }

    private void clientCreateIndex(int clientId, String tableName) throws Exception {
        String index = "CREATE INDEX " + tableName + "_INDEX on " + tableName + "(bigIntegerField)";
        this.clientSQLExecute(clientId, index);
    }

    private Runnable getCopyDataDictionary(final String testDirectory) {
        return new SerializableRunnable("copying data dictionary"){

            public void run() throws CacheException {
                try {
                    GemFireXDDataExtractorDUnit.this.copyDataDictionary(testDirectory + File.separator);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private void copyDataDictionary(String testDirectory) throws IOException {
        FileUtils.copyDirectory((File)new File(testDirectory, "datadictionary"), (File)new File(testDirectory, this.copyDirectory + fileSeparator + "datadictionary"));
    }

    private Runnable getCopyOplogsRunnable(final String testDirectory, final String testDiskStoreName) {
        return new SerializableRunnable("copying Oplogs"){

            public void run() throws CacheException {
                try {
                    GemFireXDDataExtractorDUnit.this.copyOplogs(testDirectory, testDiskStoreName);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private void copyOplogs(String testDirectory, String diskStoreName) throws IOException {
        File copiedDirectory = new File(testDirectory, this.copyDirectory + File.separator + diskStoreName);
        FileUtils.copyDirectory((File)new File(testDirectory + File.separator + diskStoreName), (File)copiedDirectory);
        String[] lk = copiedDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith("*.lk");
            }
        });
        if (lk != null) {
            for (int i = 0; i < lk.length; ++i) {
                FileUtils.forceDelete((File)new File(copiedDirectory, lk[i]));
            }
        }
    }

    private Runnable getDeleteOplogsRunnable(final String testDirectory, final String testDiskStoreName, final String[] suffix) {
        return new SerializableRunnable("delete Oplogs"){

            public void run() throws CacheException {
                try {
                    GemFireXDDataExtractorDUnit.this.deleteOplogs(testDirectory, testDiskStoreName, suffix);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private void deleteOplogs(String testDirectory, String diskStoreName, final String[] suffix) throws IOException {
        File copiedDirectory = new File(testDirectory, this.copyDirectory + File.separator + diskStoreName);
        String[] deleteFiles = copiedDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                for (int i = 0; i < suffix.length; ++i) {
                    if (!arg1.endsWith(suffix[i])) continue;
                    return true;
                }
                return false;
            }
        });
        for (int i = 0; i < deleteFiles.length; ++i) {
            FileUtils.forceDelete((File)new File(copiedDirectory, deleteFiles[i]));
        }
    }

    private Runnable getCorruptOplogsRunnable(final String testDirectory, final String testDiskStoreName, final String[] suffix, final int lengthToPreserve) {
        return new SerializableRunnable("corrupt Oplogs"){

            public void run() throws CacheException {
                try {
                    GemFireXDDataExtractorDUnit.this.corruptOplogs(testDirectory, testDiskStoreName, suffix, lengthToPreserve);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private Runnable getCorruptIfRunnable(final String testDirectory, final String testDiskStoreName) {
        return new SerializableRunnable("corrupt IF files"){

            public void run() throws CacheException {
                try {
                    GemFireXDDataExtractorDUnit.this.corruptOplogsWithRightShifting(testDirectory, testDiskStoreName, new String[]{".if"});
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    private void corruptOplogs(String testDirectory, String diskStoreName, final String[] suffix, int lengthToPreserve) throws IOException {
        File copiedDirectory = new File(testDirectory, this.copyDirectory + File.separator + diskStoreName);
        String[] corruptFiles = copiedDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                for (int i = 0; i < suffix.length; ++i) {
                    if (!arg1.endsWith(suffix[i])) continue;
                    return true;
                }
                return false;
            }
        });
        for (int i = 0; i < corruptFiles.length; ++i) {
            GemFireXDDataExtractorJUnit.corruptFile(lengthToPreserve, new File(copiedDirectory, corruptFiles[i]));
        }
    }

    private void corruptOplogsWithRightShifting(String testDirectory, String diskStoreName, final String[] suffix) throws IOException {
        File copiedDirectory = new File(testDirectory, this.copyDirectory + File.separator + diskStoreName);
        String[] corruptFiles = copiedDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                for (int i = 0; i < suffix.length; ++i) {
                    if (!arg1.endsWith(suffix[i])) continue;
                    return true;
                }
                return false;
            }
        });
        for (int i = 0; i < corruptFiles.length; ++i) {
            GemFireXDDataExtractorDUnit.corruptFile(new File(copiedDirectory, corruptFiles[i]));
        }
    }

    private Runnable getCheckDDLSizeRunnable(final String directory, final int size) {
        return new SerializableRunnable("check ddl size"){

            public void run() throws CacheException {
                try {
                    GemFireXDDataExtractorDUnit.this.checkDDLSize(directory, size);
                }
                catch (Exception e) {
                    throw new CacheException(e){};
                }
            }
        };
    }

    public static void corruptFile(File file) throws IOException {
        byte[] fileBytes = FileUtils.readFileToByteArray((File)file);
        if (fileBytes != null && fileBytes.length > 0) {
            GemFireXDDataExtractorDUnit.getGlobalLogger().info((Object)("#SB Corrupting the file : " + file.getCanonicalPath()));
            for (int i = 0; i < fileBytes.length; ++i) {
                fileBytes[i] = (byte)(fileBytes[i] >> 2);
            }
        }
        FileUtils.writeByteArrayToFile((File)file, (byte[])fileBytes, (boolean)false);
    }

    private void checkDDLSize(String testDirectory, int size) throws IOException {
        File copiedDirectory = new File(testDirectory, this.copyDirectory + File.separator + "datadictionary");
        String[] sql = copiedDirectory.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.contains(".sql");
            }
        });
        ArrayList ddlStatements = new ArrayList();
        if (sql != null) {
            for (int i = 0; i < sql.length; ++i) {
                ddlStatements.addAll(ExtractorUtils.readSqlStatements((String)new File(copiedDirectory, sql[i]).getName()));
            }
        } else {
            this.getLogWriter().info((Object)"Could not find the exported .sql file");
        }
        if (size != ddlStatements.size()) {
            throw new CacheException("ddl not the expected size of :" + size + ", instead was " + ddlStatements.size()){};
        }
    }
}

